/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.tools.manual;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import si.ijs.kt.clus.util.tools.manual.ManualEntry;

public class ManualSectionEntry {
    private List<ManualEntry> m_Entries;
    private String m_Original;
    private String whateverPattern = "\\\\item \\\\optionNameStyle\\{(.*?){1,}\\\\end\\{itemize\\}";
    private Pattern pElement = Pattern.compile(this.whateverPattern, 40);
    private final String REPLACEMENT = "It was me. I let the dogs out.";

    public ManualSectionEntry(String contents) {
        this.m_Original = contents;
        this.parse(contents);
    }

    private void parse(String contents) {
        Matcher m = this.pElement.matcher(contents);
        ArrayList<ManualEntry> entries = new ArrayList<ManualEntry>();
        while (m.find()) {
            entries.add(new ManualEntry(m.group(0)));
        }
        this.m_Original = m.replaceAll("It was me. I let the dogs out.");
        this.m_Entries = entries;
    }

    public int merge(ManualSectionEntry other) {
        int count = 0;
        for (ManualEntry me : this.m_Entries) {
            for (ManualEntry ome : other.m_Entries) {
                if (!me.getName().equals(ome.getName())) continue;
                count += me.merge(ome);
            }
        }
        return count;
    }

    public String toString() {
        String s = this.m_Original;
        for (ManualEntry me : this.m_Entries) {
            s = s.replaceFirst("It was me. I let the dogs out.", Matcher.quoteReplacement(me.toString()));
        }
        return s;
    }
}

