/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.jeans.util.sort;

import java.util.Vector;
import si.ijs.kt.clus.util.jeans.util.sort.MComparator;

public class MVectorSorter {
    public static void quickSort(Vector vec, MComparator comp) {
        MVectorSorter.quickSort(vec, 0, vec.size() - 1, comp);
    }

    public static void quickSort(Vector vec, int low, int high, MComparator comp) {
        if (low < high) {
            int mid = MVectorSorter.split(vec, low, high, comp);
            MVectorSorter.quickSort(vec, low, mid - 1, comp);
            MVectorSorter.quickSort(vec, mid + 1, high, comp);
        }
    }

    public static int split(Vector vec, int low, int high, MComparator comp) {
        int left = low;
        int right = high;
        while (left < right) {
            while (MVectorSorter.compareObjects(vec, right, low, comp) <= -1) {
                --right;
            }
            while (left < right && MVectorSorter.compareObjects(vec, left, low, comp) >= 0) {
                ++left;
            }
            if (left >= right) continue;
            MVectorSorter.swapObjects(vec, left, right);
        }
        int mid = right;
        MVectorSorter.swapObjects(vec, mid, low);
        return mid;
    }

    public static int compareObjects(Vector vec, int idx1, int idx2, MComparator comp) {
        Object el1 = vec.elementAt(idx1);
        Object el2 = vec.elementAt(idx2);
        return comp.compare(el1, el2);
    }

    public static void swapObjects(Vector vec, int idx1, int idx2) {
        Object el = vec.elementAt(idx1);
        vec.setElementAt(vec.elementAt(idx2), idx1);
        vec.setElementAt(el, idx2);
    }
}

