/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.jeans.util.sort;

import si.ijs.kt.clus.util.ClusLogger;

public class DoubleIndexSorter {
    protected static DoubleIndexSorter m_Instance;
    protected double[] m_Data;
    protected int[] m_Index;

    public static DoubleIndexSorter getInstance() {
        if (m_Instance == null) {
            m_Instance = new DoubleIndexSorter();
        }
        return m_Instance;
    }

    public final void setData(double[] data) {
        this.m_Data = data;
        int nb = data.length;
        this.m_Index = new int[nb];
        for (int i = 0; i < nb; ++i) {
            this.m_Index[i] = i;
        }
    }

    public final void setData(double[] data, int[] index) {
        this.m_Data = data;
        this.m_Index = index;
    }

    public static double[] arrayclone(double[] data) {
        double[] res = new double[data.length];
        System.arraycopy(data, 0, res, 0, data.length);
        return res;
    }

    public static double[] unsort(double[] data, int[] index) {
        int nb = data.length;
        double[] ndata = new double[nb];
        for (int i = 0; i < nb; ++i) {
            ndata[index[i]] = data[i];
        }
        return ndata;
    }

    public final void sort() {
        this.quickSort(0, this.m_Data.length);
    }

    public final int[] getIndex() {
        return this.m_Index;
    }

    private final void quickSort(int off, int len) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && this.m_Data[j - 1] <= this.m_Data[j]; --j) {
                    this.swap(j, j - 1);
                }
            }
            return;
        }
        int m = off + len / 2;
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = this.med3(l, l + s, l + 2 * s);
                m = this.med3(m - s, m, m + s);
                n = this.med3(n - 2 * s, n - s, n);
            }
            m = this.med3(l, m, n);
        }
        double v = this.m_Data[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && this.m_Data[b] > v) {
                if (this.m_Data[b] == v) {
                    this.swap(a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && this.m_Data[c] < v) {
                if (this.m_Data[c] == v) {
                    this.swap(c, d--);
                }
                --c;
            }
            if (b > c) break;
            this.swap(b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        this.vecswap(off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        this.vecswap(b, n - s, s);
        s = b - a;
        if (s > 1) {
            this.quickSort(off, s);
        }
        if ((s = d - c) > 1) {
            this.quickSort(n - s, s);
        }
    }

    private final void swap(int a, int b) {
        double t = this.m_Data[a];
        this.m_Data[a] = this.m_Data[b];
        this.m_Data[b] = t;
        int i = this.m_Index[a];
        this.m_Index[a] = this.m_Index[b];
        this.m_Index[b] = i;
    }

    private final void vecswap(int a, int b, int n) {
        int i = 0;
        while (i < n) {
            this.swap(a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private final int med3(int a, int b, int c) {
        return this.m_Data[a] >= this.m_Data[b] ? (this.m_Data[b] >= this.m_Data[c] ? b : (this.m_Data[a] >= this.m_Data[c] ? c : a)) : (this.m_Data[b] <= this.m_Data[c] ? b : (this.m_Data[a] <= this.m_Data[c] ? c : a));
    }

    public static void main(String[] args) {
        int nb = 80;
        double[] arr = new double[nb];
        for (int i = 0; i < nb; ++i) {
            arr[i] = Math.random();
        }
        DoubleIndexSorter sr = DoubleIndexSorter.getInstance();
        sr.setData(arr);
        sr.sort();
        for (int i = 0; i < 80; ++i) {
            ClusLogger.info(arr[i]);
        }
    }
}

