/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.jeans.util.array;

public class MyIntArray {
    private int[] m_Ints;
    private int m_Size;
    private int m_Mult;
    private int m_Div;

    public MyIntArray() {
        this.m_Ints = new int[0];
        this.m_Size = 0;
        this.m_Mult = 2;
        this.m_Div = 1;
    }

    public MyIntArray(int cap) {
        this.m_Ints = new int[cap];
        this.m_Size = 0;
        this.m_Mult = 2;
        this.m_Div = 1;
    }

    public MyIntArray(int cap, int mult, int div) {
        this.m_Ints = new int[cap];
        this.m_Size = 0;
        this.m_Mult = mult;
        this.m_Div = div;
    }

    public final int binarySearch(int key) {
        int low = 0;
        int high = this.m_Size - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            int midVal = this.m_Ints[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int[] remove(int e, int[] a) {
        int idx = 0;
        int[] r = new int[a.length - 1];
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == e) continue;
            r[idx++] = a[i];
        }
        return r;
    }

    public static int[] mergeSorted(int[] a1, int[] a2) {
        int i;
        int idx = 0;
        int a1p = 0;
        int a2p = 0;
        int[] a3 = new int[a1.length + a2.length];
        while (a1p < a1.length && a2p < a2.length) {
            if (a1[a1p] <= a2[a2p]) {
                a3[idx++] = a1[a1p++];
                continue;
            }
            a3[idx++] = a2[a2p++];
        }
        for (i = a1p; i < a1.length; ++i) {
            a3[idx++] = a1[i];
        }
        for (i = a2p; i < a2.length; ++i) {
            a3[idx++] = a2[i];
        }
        return a3;
    }

    public static int isIntersectSorted(int[] a1, int[] a2) {
        int a1p = 0;
        int a2p = 0;
        while (a1p < a1.length && a2p < a2.length) {
            if (a1[a1p] == a2[a2p]) {
                return 1;
            }
            if (a1[a1p] < a2[a2p]) {
                ++a1p;
                continue;
            }
            ++a2p;
        }
        return 0;
    }

    public static int[] intersectSorted(int[] a1, int[] a2) {
        int nb = 0;
        int a1p = 0;
        int a2p = 0;
        while (a1p < a1.length && a2p < a2.length) {
            if (a1[a1p] == a2[a2p]) {
                ++nb;
                ++a1p;
                ++a2p;
                continue;
            }
            if (a1[a1p] < a2[a2p]) {
                ++a1p;
                continue;
            }
            ++a2p;
        }
        int idx = 0;
        a2p = 0;
        a1p = 0;
        int[] r = new int[nb];
        if (nb > 0) {
            while (a1p < a1.length && a2p < a2.length) {
                if (a1[a1p] == a2[a2p]) {
                    r[idx++] = a1[a1p];
                    ++a1p;
                    ++a2p;
                    continue;
                }
                if (a1[a1p] < a2[a2p]) {
                    ++a1p;
                    continue;
                }
                ++a2p;
            }
        }
        return r;
    }

    public static String print(int[] arr) {
        if (arr.length == 0) {
            return "[]";
        }
        StringBuffer buff = new StringBuffer();
        buff.append('[');
        buff.append(arr[0]);
        for (int i = 1; i < arr.length; ++i) {
            buff.append(',');
            buff.append(arr[i]);
        }
        buff.append(']');
        return buff.toString();
    }

    public void removeMinusOnes() {
        int delta = 0;
        for (int i = 0; i < this.m_Size; ++i) {
            while (i < this.m_Size && this.m_Ints[i + delta] == -1) {
                ++delta;
                --this.m_Size;
            }
            if (i >= this.m_Size) continue;
            this.m_Ints[i] = this.m_Ints[i + delta];
        }
    }

    public final void addElement(int element) {
        if (this.m_Size == this.m_Ints.length) {
            int[] newints = new int[this.m_Mult * this.m_Ints.length / this.m_Div + 1];
            System.arraycopy(this.m_Ints, 0, newints, 0, this.m_Size);
            this.m_Ints = newints;
        }
        this.m_Ints[this.m_Size++] = element;
    }

    public final int elementAt(int index) {
        return this.m_Ints[index];
    }

    public final int[] elements() {
        return this.m_Ints;
    }

    public final void insertElementAt(int element, int index) {
        if (this.m_Size < this.m_Ints.length) {
            System.arraycopy(this.m_Ints, index, this.m_Ints, index + 1, this.m_Size - index);
            this.m_Ints[index] = element;
        } else {
            int[] nObjs = new int[this.m_Mult * this.m_Ints.length / this.m_Div + 1];
            System.arraycopy(this.m_Ints, 0, nObjs, 0, index);
            nObjs[index] = element;
            System.arraycopy(this.m_Ints, index, nObjs, index + 1, this.m_Size - index);
            this.m_Ints = nObjs;
        }
        ++this.m_Size;
    }

    public final void removeElementAt(int index) {
        System.arraycopy(this.m_Ints, index + 1, this.m_Ints, index, this.m_Size - index - 1);
    }

    public final void removeAllElements() {
        this.m_Size = 0;
    }

    public final void setElementAt(int element, int index) {
        this.m_Ints[index] = element;
        if (index >= this.m_Size) {
            this.m_Size = index + 1;
        }
    }

    public final int size() {
        return this.m_Size;
    }

    public final void setCapacity(int cap) {
        int[] newints = new int[cap];
        System.arraycopy(this.m_Ints, 0, newints, 0, Math.min(cap, this.m_Size));
        this.m_Ints = newints;
        if (this.m_Ints.length < this.m_Size) {
            this.m_Size = this.m_Ints.length;
        }
    }

    public final void swap(int first, int second) {
        int help = this.m_Ints[first];
        this.m_Ints[first] = this.m_Ints[second];
        this.m_Ints[second] = help;
    }

    public final void trimToSize() {
        int[] newints = new int[this.m_Size];
        System.arraycopy(this.m_Ints, 0, newints, 0, this.m_Size);
        this.m_Ints = newints;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        for (int i = 0; i < this.m_Size; ++i) {
            if (i != 0) {
                buf.append(",");
            }
            buf.append(String.valueOf(this.m_Ints[i]));
        }
        buf.append("]");
        return buf.toString();
    }
}

