/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.jeans.util.array;

import java.io.IOException;
import si.ijs.kt.clus.util.jeans.util.MStreamTokenizer;

public class MDoubleArray {
    protected double[] m_hArray;
    protected int m_lSize;
    protected int m_lLen;

    public static final void add(double[] arr, double[] arr1) {
        for (int i = 0; i < arr.length; ++i) {
            int n = i;
            arr[n] = arr[n] + arr1[i];
        }
    }

    public static final void add(double[] arr, double[] arr1, double weight) {
        for (int i = 0; i < arr.length; ++i) {
            int n = i;
            arr[n] = arr[n] + weight * arr1[i];
        }
    }

    public static final void divide(double[] arr, double[] arr1) {
        for (int i = 0; i < arr.length; ++i) {
            if (arr1[i] == 0.0) continue;
            int n = i;
            arr[n] = arr[n] / arr1[i];
        }
    }

    public static final void subtractFromThis(double[] arr, double[] other) {
        for (int i = 0; i < arr.length; ++i) {
            int n = i;
            arr[n] = arr[n] - other[i];
        }
    }

    public static final void subtractFromOther(double[] arr, double[] other) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = other[i] - arr[i];
        }
    }

    public static final void dotscalar(double[] arr, double fac) {
        int i = 0;
        while (i < arr.length) {
            int n = i++;
            arr[n] = arr[n] * fac;
        }
    }

    public static final double[] clone(double[] arr) {
        double[] clone = new double[arr.length];
        System.arraycopy(arr, 0, clone, 0, arr.length);
        return clone;
    }

    public void read(MStreamTokenizer tokens, char st, char ed) throws IOException {
        tokens.readChar(st);
        int idx = 0;
        int ch = tokens.getCharToken();
        if (ch == ed) {
            this.m_lLen = 0;
            return;
        }
        tokens.pushBackChar(ch);
        do {
            double val = Double.parseDouble(tokens.readToken());
            if (idx >= this.m_lSize) {
                this.grow();
            }
            this.m_hArray[idx++] = val;
        } while ((ch = tokens.getCharToken()) != ed);
        this.m_lLen = idx;
    }

    public double[] toArray() {
        double[] nArr = new double[this.m_lLen];
        System.arraycopy(this.m_hArray, 0, nArr, 0, this.m_lLen);
        return nArr;
    }

    public void clear() {
        this.m_lSize = 0;
        this.m_hArray = null;
    }

    public void grow() {
        int nSize = this.m_lSize * 3 / 2 + 10;
        double[] nArr = new double[nSize];
        if (this.m_hArray != null) {
            System.arraycopy(this.m_hArray, 0, nArr, 0, this.m_lSize);
        }
        this.m_lSize = nSize;
        this.m_hArray = nArr;
    }

    public static String toString(double[] arr) {
        String str = "[";
        for (int ctr = 0; ctr < arr.length; ++ctr) {
            if (ctr != 0) {
                str = str + ", ";
            }
            str = str + String.valueOf(arr[ctr]);
        }
        return str + "]";
    }

    public String toString() {
        String str = "[";
        for (int ctr = 0; ctr < this.m_lLen; ++ctr) {
            if (ctr != 0) {
                str = str + ", ";
            }
            str = str + String.valueOf(this.m_hArray[ctr]);
        }
        return str + "]";
    }

    public static double max(double[] values) {
        double m = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] > m)) continue;
            m = values[i];
        }
        return m;
    }
}

