/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.jeans.util;

import java.io.IOException;

public class MStringTokenizer {
    protected String pushbacktoken;
    protected int pushbackchar;
    protected String chartokens = ":;,[]{} \t";
    protected String edblock;
    protected String stblock;
    protected String spacechars;
    protected String strg;
    protected int pos;

    public void setString(String strg) {
        this.strg = strg;
        this.pos = 0;
        this.pushbacktoken = null;
        this.pushbackchar = -1;
    }

    public void setBlockChars(String stBlock, String edBlock) {
        this.stblock = stBlock;
        this.edblock = edBlock;
    }

    public void setSpaceChars(String space) {
        this.spacechars = space;
    }

    public String getToken() {
        if (this.pushbacktoken == null) {
            int ch = this.readSignificantChar();
            if (ch != -1) {
                StringBuffer strg = new StringBuffer();
                boolean done = false;
                if (this.stblock.indexOf((char)ch) != -1) {
                    while (!done) {
                        ch = this.readChar();
                        if (ch == -1) {
                            done = true;
                            continue;
                        }
                        if (this.edblock.indexOf((char)ch) != -1) {
                            done = true;
                            continue;
                        }
                        strg.append((char)ch);
                    }
                }
                while (!done) {
                    strg.append((char)ch);
                    if (this.chartokens.indexOf((char)ch) == -1) {
                        ch = this.readChar();
                        if (ch == -1 || this.spacechars.indexOf((char)ch) != -1) {
                            done = true;
                            continue;
                        }
                        if (this.chartokens.indexOf((char)ch) == -1) continue;
                        this.pushBackChar(ch);
                        done = true;
                        continue;
                    }
                    done = true;
                }
                return strg.toString();
            }
            return null;
        }
        String betw = this.pushbacktoken;
        this.pushbacktoken = null;
        return betw;
    }

    public String readToken() throws IOException {
        String token = this.getToken();
        if (token == null) {
            throw new IOException("Unexpected end of file");
        }
        return token;
    }

    public boolean hasMoreTokens() throws IOException {
        String token = this.getToken();
        if (token == null) {
            return false;
        }
        this.pushBackToken(token);
        return true;
    }

    public int readSignificantChar() {
        int ch = this.readChar();
        while (this.spacechars.indexOf((char)ch) != -1) {
            ch = this.readChar();
        }
        return ch;
    }

    public int read() {
        if (this.pos == this.strg.length()) {
            return -1;
        }
        return this.strg.charAt(this.pos++);
    }

    public int readChar() {
        if (this.pushbackchar == -1) {
            int ch = this.read();
            return ch;
        }
        int betw = this.pushbackchar;
        this.pushbackchar = -1;
        return betw;
    }

    public int readInteger() throws IOException {
        String token = this.readToken();
        try {
            return Integer.parseInt(token);
        }
        catch (NumberFormatException e) {
            throw new IOException("Integer value expected");
        }
    }

    public float readFloat() throws IOException {
        String token = this.readToken();
        try {
            Float fl = new Float(token);
            return fl.floatValue();
        }
        catch (NumberFormatException e) {
            throw new IOException("Float value expected");
        }
    }

    public String isNextTokenIn(String strg) throws IOException {
        String token = this.getToken();
        if (token == null || strg.indexOf(token) != -1) {
            return token;
        }
        this.pushBackToken(token);
        return null;
    }

    public boolean isNextToken(String strg) throws IOException {
        boolean yes = false;
        String token = this.getToken();
        if (token == null) {
            return false;
        }
        if (token.equals(strg)) {
            yes = true;
        } else {
            this.pushBackToken(token);
        }
        return yes;
    }

    public int readChar(String which) throws IOException {
        String character = this.getToken();
        if (character == null) {
            throw new IOException("Unexpected end of file reading character");
        }
        int idx = which.indexOf(character.charAt(0));
        if (idx < 0 || character.length() != 1) {
            throw new IOException("Character '" + which + "' expected");
        }
        return idx;
    }

    public void readChar(char ch) throws IOException {
        String character = this.getToken();
        if (character == null) {
            throw new IOException("Unexpected end of file reading character");
        }
        if (!character.equals(String.valueOf(ch))) {
            throw new IOException("Character '" + ch + "' expected at line");
        }
    }

    public void pushBackChar(int ch) {
        this.pushbackchar = ch;
    }

    public void pushBackToken(String token) {
        this.pushbacktoken = token;
    }

    public String setCharTokens(String chartokens) {
        String result = this.chartokens;
        this.chartokens = chartokens;
        return result;
    }

    public String getCharTokens() {
        return this.chartokens;
    }
}

