/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.jeans.util;

public class IntegerStack {
    protected int[] stack;
    protected int pos;
    protected int grow;
    protected int size;

    public IntegerStack() {
        this(10);
    }

    public IntegerStack(int grow) {
        this.grow = grow;
        this.size = 0;
    }

    public IntegerStack(IntegerStack stack) {
        this.pos = stack.pos;
        this.grow = stack.grow;
        this.size = this.pos;
        if (this.pos > 0) {
            this.stack = new int[this.pos];
            System.arraycopy(stack.stack, 0, this.stack, 0, this.pos);
        }
    }

    public void push(int value) {
        if (this.pos + 1 > this.size) {
            this.grow();
        }
        this.stack[this.pos++] = value;
    }

    public int pop() {
        int res = this.stack[--this.pos];
        if (this.pos < this.size - this.grow) {
            this.shrink();
        }
        return res;
    }

    public boolean isEmpty() {
        return this.pos == 0;
    }

    public int getTop() {
        return this.stack[this.pos - 1];
    }

    public int getElementAt(int pos) {
        return this.stack[pos];
    }

    public void clear() {
        this.size = 0;
        this.stack = null;
    }

    public int getSize() {
        return this.pos;
    }

    private void grow() {
        int[] newStack = new int[this.size + this.grow];
        for (int ctr = 0; ctr < this.size; ++ctr) {
            newStack[ctr] = this.stack[ctr];
        }
        this.stack = newStack;
        this.size += this.grow;
    }

    private void shrink() {
        this.size -= this.grow;
        int[] newStack = new int[this.size];
        for (int ctr = 0; ctr < this.size; ++ctr) {
            newStack[ctr] = this.stack[ctr];
        }
        this.stack = newStack;
    }
}

