/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.jeans.math.matrix;

import java.io.Serializable;
import si.ijs.kt.clus.util.jeans.math.matrix.MMatrix;
import si.ijs.kt.clus.util.jeans.math.matrix.MySparseVector;

public class MSymMatrix
extends MMatrix
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected int m_Size;
    protected double[][] m_Data;

    public MSymMatrix(int size) {
        this.m_Size = size;
        this.m_Data = MSymMatrix.createSymmetricData(size);
    }

    public int getSize() {
        return this.m_Size;
    }

    public final double xtAx(double[] x) {
        double res = 0.0;
        for (int i = 0; i < this.m_Size; ++i) {
            double xi = x[i];
            double[] ai = this.m_Data[i];
            res += this.m_Data[i][i] * xi * xi;
            for (int j = 0; j < i; ++j) {
                res += 2.0 * ai[j] * xi * x[j];
            }
        }
        return res;
    }

    public final double xtAx_delta(double[] x1, double[] x2) {
        double res = 0.0;
        for (int i = 0; i < this.m_Size; ++i) {
            double xi = x1[i] - x2[i];
            double[] ai = this.m_Data[i];
            res += this.m_Data[i][i] * xi * xi;
            for (int j = 0; j < i; ++j) {
                double xj = x1[j] - x2[j];
                res += 2.0 * ai[j] * xi * xj;
            }
        }
        return res;
    }

    public final double xtAx(MySparseVector x) {
        double res = 0.0;
        int nb = x.getNbNonZero();
        for (int vi = 0; vi < nb; ++vi) {
            int i = x.getPosition(vi);
            double xi = x.getValue(vi);
            res += this.m_Data[i][i] * xi * xi;
            for (int vj = 0; vj < vi; ++vj) {
                int j = x.getPosition(vj);
                double xj = x.getValue(vj);
                res += 2.0 * this.get(i, j) * xi * xj;
            }
        }
        return res;
    }

    public final void addRowWeighted(double[] x, int i, double w) {
        int j;
        double[] ai = this.m_Data[i];
        for (j = 0; j <= i; ++j) {
            int n = j;
            x[n] = x[n] + w * ai[j];
        }
        for (j = i + 1; j < this.m_Size; ++j) {
            int n = j;
            x[n] = x[n] + w * this.m_Data[j][i];
        }
    }

    @Override
    public final double get(int r, int c) {
        if (c > r) {
            return this.m_Data[c][r];
        }
        return this.m_Data[r][c];
    }

    public final double get_fast(int r, int c) {
        return this.m_Data[r][c];
    }

    public final double[] getRow(int r) {
        return this.m_Data[r];
    }

    public final void set(int r, int c, double val) {
        this.m_Data[r][c] = val;
    }

    public final void set_sym(int r, int c, double val) {
        if (c > r) {
            this.m_Data[c][r] = val;
        } else {
            this.m_Data[r][c] = val;
        }
    }

    public final void add_sym(int r, int c, double val) {
        if (c > r) {
            double[] dArray = this.m_Data[c];
            int n = r;
            dArray[n] = dArray[n] + val;
        } else {
            double[] dArray = this.m_Data[r];
            int n = c;
            dArray[n] = dArray[n] + val;
        }
    }

    @Override
    public final int getRows() {
        return this.m_Size;
    }

    @Override
    public final int getCols() {
        return this.m_Size;
    }

    private static final double[][] createSymmetricData(int size) {
        double[][] data = new double[size][];
        for (int i = 0; i < size; ++i) {
            data[i] = new double[i + 1];
        }
        return data;
    }

    public String toString() {
        String output = "";
        for (int i = 0; i < this.m_Size; ++i) {
            output = output + this.toString(i);
        }
        return output;
    }

    public String toString(int row) {
        int j;
        String output = "";
        for (j = 0; j <= row; ++j) {
            output = output + this.m_Data[row][j] + " ";
        }
        for (j = row + 1; j < this.m_Size; ++j) {
            output = output + this.m_Data[j][row] + " ";
        }
        output = output + "\n";
        return output;
    }
}

