/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.jeans.math.matrix;

import java.io.PrintWriter;
import java.text.NumberFormat;
import si.ijs.kt.clus.util.jeans.math.matrix.MySparseVector;
import si.ijs.kt.clus.util.jeans.util.StringUtils;

public abstract class MMatrix {
    public abstract double get(int var1, int var2);

    public abstract int getRows();

    public abstract int getCols();

    public static final double dot(double[] x, double[] y) {
        double res = 0.0;
        for (int i = 0; i < x.length; ++i) {
            res += x[i] * y[i];
        }
        return res;
    }

    public static final double dot_delta(double[] x1, double[] x2, double[] y1, double[] y2) {
        double res = 0.0;
        for (int i = 0; i < x1.length; ++i) {
            res += (x1[i] - x2[i]) * (y1[i] - y2[i]);
        }
        return res;
    }

    public static final double dot(MySparseVector x, double[] y) {
        double res = 0.0;
        int nb = x.getNbNonZero();
        for (int vi = 0; vi < nb; ++vi) {
            int i = x.getPosition(vi);
            res += x.getValue(vi) * y[i];
        }
        return res;
    }

    public final double[][] toCPArray() {
        int rows = this.getRows();
        int cols = this.getCols();
        double[][] data = new double[rows][cols];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                data[i][j] = this.get(i, j);
            }
        }
        return data;
    }

    public final void print(PrintWriter wrt, NumberFormat format, int size) {
        if (this.getRows() == 1) {
            this.printRow(0, wrt, format, size);
            wrt.println();
        } else {
            for (int mi = 0; mi < this.getRows(); ++mi) {
                if (mi == 0) {
                    wrt.print("[");
                } else {
                    wrt.print(" ");
                }
                this.printRow(mi, wrt, format, size);
                if (mi == this.getRows() - 1) {
                    wrt.print("]");
                }
                wrt.println();
            }
        }
    }

    private final void printRow(int mi, PrintWriter wrt, NumberFormat format, int size) {
        wrt.print("[");
        for (int mj = 0; mj < this.getCols(); ++mj) {
            if (mj != 0) {
                wrt.print(";");
            }
            String strg = format.format(this.get(mi, mj));
            wrt.print(StringUtils.printStr(strg, size));
        }
        wrt.print("]");
    }
}

