/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.jeans.io.ini;

import si.ijs.kt.clus.util.jeans.io.ini.INIFileEntry;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileNode;
import si.ijs.kt.clus.util.jeans.util.StringUtils;

public class INIFileStringOrInt
extends INIFileEntry {
    public static final long serialVersionUID = 1L;
    protected String m_Value;
    protected int m_Int;
    protected boolean m_IsInt;

    public INIFileStringOrInt(String name) {
        this(name, "");
    }

    public INIFileStringOrInt(String name, String value) {
        super(name);
        this.setValue(value);
    }

    @Override
    public INIFileNode cloneNode() {
        return new INIFileStringOrInt(this.getName(), this.getValue());
    }

    public String getValue() {
        return this.m_Value;
    }

    public int getIntValue() {
        return this.m_Int;
    }

    public void setIntValue(int val) {
        this.m_IsInt = true;
        this.m_Int = val;
        this.m_Value = "";
    }

    public boolean isIntOrNull(String nullstr) {
        if (this.isInt()) {
            return true;
        }
        return StringUtils.unCaseCompare(this.getStringValue(), nullstr);
    }

    public boolean isString(String str) {
        if (this.isInt()) {
            return false;
        }
        return StringUtils.unCaseCompare(this.getStringValue(), str);
    }

    public boolean isInt() {
        return this.m_IsInt;
    }

    @Override
    public void setValue(String value) {
        if (INIFileStringOrInt.isInt(value)) {
            this.m_Int = Integer.parseInt(value);
            this.m_IsInt = true;
        } else {
            this.m_IsInt = false;
        }
        this.m_Value = value;
    }

    @Override
    public String getStringValue() {
        if (this.m_IsInt) {
            return String.valueOf(this.m_Int);
        }
        return this.getValue();
    }

    public static boolean isInt(String value) {
        int len = value.length();
        if (len == 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            if (ch >= '0' && ch <= '9') continue;
            return false;
        }
        return true;
    }
}

