/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.jeans.io.ini;

import si.ijs.kt.clus.util.jeans.io.ini.INIFileEntry;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileNode;
import si.ijs.kt.clus.util.jeans.math.MDouble;
import si.ijs.kt.clus.util.jeans.util.StringUtils;

public class INIFileStringOrDouble
extends INIFileEntry {
    public static final long serialVersionUID = 1L;
    protected String m_Value;
    protected double m_Double;
    protected boolean m_IsDouble;

    public INIFileStringOrDouble(String name) {
        this(name, "");
    }

    public INIFileStringOrDouble(String name, String value) {
        super(name);
        this.setValue(value);
    }

    @Override
    public INIFileNode cloneNode() {
        return new INIFileStringOrDouble(this.getName(), this.getValue());
    }

    public String getValue() {
        return this.m_Value;
    }

    public double getDoubleValue() {
        return this.m_Double;
    }

    public void setDoubleValue(double val) {
        this.m_IsDouble = true;
        this.m_Double = val;
        this.m_Value = "";
    }

    public boolean isDoubleOrNull(String nullstr) {
        if (this.isDouble()) {
            return true;
        }
        return StringUtils.unCaseCompare(this.getStringValue(), nullstr);
    }

    public boolean isString(String str) {
        if (this.isDouble()) {
            return false;
        }
        return StringUtils.unCaseCompare(this.getStringValue(), str);
    }

    public boolean isDouble() {
        return this.m_IsDouble;
    }

    @Override
    public void setValue(String value) {
        if (MDouble.isDouble(value)) {
            this.m_Double = Double.parseDouble(value);
            this.m_IsDouble = true;
        }
        this.m_Value = value;
    }

    @Override
    public String getStringValue() {
        if (this.m_IsDouble) {
            return String.valueOf(this.m_Double);
        }
        return this.getValue();
    }
}

