/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.jeans.io.ini;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileEntry;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileNode;
import si.ijs.kt.clus.util.jeans.io.range.NominalType;
import si.ijs.kt.clus.util.jeans.util.MStreamTokenizer;

public class INIFileNominalOrDoubleOrVector
extends INIFileEntry {
    public static final long serialVersionUID = 1L;
    protected NominalType m_Type;
    protected int m_SingleNominal;
    protected double m_SingleDouble;
    protected int[] m_ArrayNominal;
    protected double[] m_ArrayDouble;
    private boolean m_HasArrayIndexNames;
    private String[] m_Names;

    public INIFileNominalOrDoubleOrVector(String name, String[] values) {
        this(name, new NominalType(values));
    }

    public INIFileNominalOrDoubleOrVector(String name, NominalType values) {
        super(name);
        this.m_Type = values;
        this.m_SingleNominal = -1;
        this.m_Names = new String[0];
    }

    public NominalType getType() {
        return this.m_Type;
    }

    @Override
    public INIFileNode cloneNode() {
        return new INIFileNominalOrDoubleOrVector(this.getName(), this.getType());
    }

    public boolean isVector() {
        return this.m_ArrayNominal != null;
    }

    public boolean isNominal() {
        return this.m_SingleNominal != -1;
    }

    public boolean isNominal(int idx) {
        return this.getNominal(idx) != -1;
    }

    public int getNominal(int idx) {
        if (this.isVector()) {
            return this.m_ArrayNominal[idx];
        }
        return this.getNominal();
    }

    public String getNominalString(int idx) {
        return this.m_Type.getName(this.getNominal(idx));
    }

    public double getDouble(int idx) {
        if (this.isVector()) {
            return this.m_ArrayDouble[idx];
        }
        return this.getDouble();
    }

    public int getNominal() {
        return this.m_SingleNominal;
    }

    public double getDouble() {
        return this.m_SingleDouble;
    }

    public void setDouble(double value) {
        this.m_SingleDouble = value;
        this.m_ArrayNominal = null;
        this.m_ArrayDouble = null;
    }

    public void setNominal(int value) {
        this.m_SingleNominal = value;
        this.m_ArrayNominal = null;
        this.m_ArrayDouble = null;
    }

    public void setDouble(int idx, double value) {
        this.m_ArrayDouble[idx] = value;
        this.m_ArrayNominal[idx] = -1;
    }

    public void setNominal(int idx, int value) {
        this.m_ArrayNominal[idx] = value;
    }

    public void setDoubleArray(double[] values) {
        this.setVector(values.length);
        for (int i = 0; i < values.length; ++i) {
            this.setDouble(i, values[i]);
        }
    }

    public void setVector(int len) {
        this.m_ArrayNominal = new int[len];
        this.m_ArrayDouble = new double[len];
    }

    public int getVectorLength() {
        return this.m_ArrayNominal == null ? 1 : this.m_ArrayNominal.length;
    }

    public boolean hasVector() {
        return this.m_ArrayNominal != null;
    }

    public double[] getDoubleVector() {
        return this.m_ArrayDouble;
    }

    @Override
    public void build(MStreamTokenizer tokens) throws IOException {
        this.m_Type.setReader(true);
        this.setNominal(-1);
        this.setArrayIndexNames(false);
        if (tokens.isNextToken('[')) {
            ArrayList<String> values = new ArrayList<String>();
            String token = tokens.getToken();
            while (token != null && !token.equals("]")) {
                values.add(token);
                token = this.readNextEntry(tokens);
            }
            this.setVector(values.size());
            for (int i = 0; i < values.size(); ++i) {
                String value = (String)values.get(i);
                int idx = this.m_Type.getValue(value);
                if (idx != -1) {
                    this.setNominal(i, idx);
                    continue;
                }
                try {
                    this.setDouble(i, Double.parseDouble(value));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new IOException("Illegal value '" + value + "' in vector at pos " + i + " for setting '" + this.getName() + "'");
                }
            }
        } else {
            String token = tokens.getToken();
            int idx = this.m_Type.getValue(token);
            if (idx != -1) {
                this.setNominal(idx);
            } else if (this.isArrayIndexName(0, token)) {
                this.setVector(this.m_Names.length);
                this.setArrayIndexNames(true);
                for (int i = 0; i < this.m_Names.length; ++i) {
                    if (!this.isArrayIndexName(i, token)) {
                        throw new IOException("Expected one of [" + this.getArrayIndexNamesString() + "] and not '" + token + "' for setting '" + this.getName() + "'");
                    }
                    String value = tokens.getToken();
                    if (!value.equals("=")) {
                        throw new IOException("Expected '=' after '" + this.m_Names[i] + "' for setting '" + this.getName() + "'");
                    }
                    value = tokens.getToken();
                    int idx2 = this.m_Type.getValue(value);
                    if (idx2 != -1) {
                        this.setNominal(i, idx2);
                    } else {
                        try {
                            this.setDouble(i, Double.parseDouble(value));
                        }
                        catch (NumberFormatException e) {
                            throw new IOException("Illegal value '" + value + "' for '" + this.m_Names[i] + "' for setting '" + this.getName() + "'");
                        }
                    }
                    if (i == this.m_Names.length - 1) continue;
                    token = tokens.getToken();
                }
            } else {
                try {
                    this.setDouble(Double.parseDouble(token));
                }
                catch (NumberFormatException e) {
                    throw new IOException("Illegal value '" + token + "' for setting '" + this.getName() + "'");
                }
            }
        }
    }

    @Override
    public void setValue(String value) throws IOException {
        this.build(new MStreamTokenizer(new StringReader(value)));
    }

    public String readNextEntry(MStreamTokenizer tokens) throws IOException {
        String token = tokens.getToken();
        if (token != null && token.equals(",")) {
            token = tokens.getToken();
        }
        return token;
    }

    @Override
    public String getStringValue() {
        if (this.hasArrayIndexNames()) {
            StringBuffer buf = new StringBuffer();
            buf.append("\n");
            for (int i = 0; i < this.m_Names.length; ++i) {
                buf.append("  " + this.m_Names[i] + " = ");
                if (this.isNominal(i)) {
                    buf.append(this.getNominalString(i));
                } else {
                    buf.append(String.valueOf(this.getDouble(i)));
                }
                if (i == this.m_Names.length - 1) continue;
                buf.append("\n");
            }
            return buf.toString();
        }
        if (this.isVector()) {
            StringBuffer buf = new StringBuffer();
            buf.append("[");
            for (int i = 0; i < this.getVectorLength(); ++i) {
                if (i != 0) {
                    buf.append(",");
                }
                if (this.isNominal(i)) {
                    buf.append(this.getNominalString(i));
                    continue;
                }
                buf.append(String.valueOf(this.getDouble(i)));
            }
            buf.append("]");
            return buf.toString();
        }
        if (this.isNominal()) {
            return this.m_Type.getName(this.getNominal());
        }
        return String.valueOf(this.getDouble());
    }

    public String getArrayIndexNamesString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.m_Names.length; ++i) {
            if (i != 0) {
                buf.append(",");
            }
            buf.append(this.m_Names[i]);
        }
        return buf.toString();
    }

    public boolean isArrayIndexName(int i, String name) {
        if (i >= this.m_Names.length) {
            return false;
        }
        return this.m_Names[i].equals(name);
    }

    public boolean isArrayIndexName(String name) {
        for (int i = 0; i < this.m_Names.length; ++i) {
            if (!this.m_Names[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    public void setArrayIndexNames(String[] names) {
        this.m_Names = names;
    }

    public void setArrayIndexNames(boolean enable) {
        this.m_HasArrayIndexNames = enable;
    }

    public boolean hasArrayIndexNames() {
        return this.m_HasArrayIndexNames;
    }
}

