/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.jeans.io.ini;

import java.util.HashMap;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileEntry;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileNode;
import si.ijs.kt.clus.util.jeans.io.range.ValueCheck;

public class INIFileInt
extends INIFileEntry {
    public static final long serialVersionUID = 1L;
    protected int m_Value;
    protected ValueCheck m_Check;
    protected transient HashMap m_NameToValue;
    protected transient HashMap m_ValueToName;

    public INIFileInt(String name, String value) throws NumberFormatException {
        super(name);
        this.setValue(value);
    }

    public INIFileInt(String name, int value) {
        super(name);
        this.setValue(value);
    }

    public INIFileInt(String name) {
        this(name, 0);
    }

    public void setValueCheck(ValueCheck check) {
        this.m_Check = check;
    }

    @Override
    public INIFileNode cloneNode() {
        return new INIFileInt(this.getName(), this.getValue());
    }

    public void setNamedValue(int value, String name) {
        if (this.m_NameToValue == null) {
            this.m_NameToValue = new HashMap();
        }
        if (this.m_ValueToName == null) {
            this.m_ValueToName = new HashMap();
        }
        Integer value_int = new Integer(value);
        this.m_NameToValue.put(name, value_int);
        this.m_ValueToName.put(value_int, name);
    }

    public int getValue() {
        return this.m_Value;
    }

    public void setValue(int value) {
        Integer dval;
        if (this.m_Check != null && !this.m_Check.checkValue(dval = new Integer(value))) {
            throw new NumberFormatException(this.m_Check.getString(this.getName(), dval));
        }
        this.m_Value = value;
    }

    @Override
    public void setValue(String value) throws NumberFormatException {
        if (this.m_NameToValue != null) {
            Integer int_value = (Integer)this.m_NameToValue.get(value);
            if (int_value != null) {
                this.setValue(int_value);
            } else {
                this.setValue(Integer.parseInt(value));
            }
        } else {
            this.setValue(Integer.parseInt(value));
        }
    }

    @Override
    public String getStringValue() {
        String name;
        if (this.m_ValueToName != null && (name = (String)this.m_ValueToName.get(new Integer(this.getValue()))) != null) {
            return name;
        }
        return String.valueOf(this.getValue());
    }
}

