/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.jeans.io.ini;

import java.io.IOException;
import java.util.Arrays;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileEntry;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileNode;

public class INIFileEnum<T extends Enum<T>>
extends INIFileEntry {
    private static final long serialVersionUID = 1L;
    private T m_ChosenOption;
    private Class<T> m_EnumType;

    public INIFileEnum(String name, T defaultValue) {
        super(name);
        this.m_EnumType = defaultValue.getClass();
        this.m_ChosenOption = defaultValue;
    }

    @Override
    public String getStringValue() {
        return ((Enum)this.m_ChosenOption).toString();
    }

    public String toString() {
        return ((Enum)this.m_ChosenOption).toString();
    }

    @Override
    public void setValue(String value) throws IOException {
        try {
            this.m_ChosenOption = Enum.valueOf(this.m_EnumType, value);
        }
        catch (IllegalArgumentException e) {
            System.err.println(String.format("Value %s is illegal for the option %s", value, this.m_hName));
            System.err.println(String.format("List of allowed values: " + Arrays.toString(this.m_EnumType.getEnumConstants()), new Object[0]));
            throw e;
        }
    }

    @Override
    public INIFileNode cloneNode() {
        return new INIFileEnum<T>(this.getName(), this.m_ChosenOption);
    }

    public void setValue(T value) {
        this.m_ChosenOption = value;
    }

    public T getValue() {
        return this.m_ChosenOption;
    }
}

