/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.jeans.io.ini;

import java.io.IOException;
import java.util.Vector;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileEntry;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileNode;
import si.ijs.kt.clus.util.jeans.util.MStreamTokenizer;

public class INIFileArray
extends INIFileEntry {
    public static final long serialVersionUID = 1L;
    protected Vector m_hValue = new Vector();
    protected int m_iType;

    public INIFileArray(String name, int type) {
        super(name);
        this.m_iType = type;
    }

    public INIFileArray(String name, int[] init) {
        super(name);
        this.fromArray(init);
    }

    public INIFileArray(String name, String[] init) {
        super(name);
        this.fromArray(init);
    }

    public INIFileArray(String name, double[] init) {
        super(name);
        this.fromArray(init);
    }

    public int getSize() {
        return this.m_hValue.size();
    }

    public int getType() {
        return this.m_iType;
    }

    public void removeAllElements() {
        this.m_hValue.removeAllElements();
    }

    public Vector getVector() {
        return this.m_hValue;
    }

    public void fromArray(int[] init) {
        this.removeAllElements();
        this.m_iType = 2;
        for (int i = 0; i < init.length; ++i) {
            this.addValue(init[i]);
        }
    }

    public void fromArray(String[] init) {
        this.removeAllElements();
        this.m_iType = 1;
        for (int i = 0; i < init.length; ++i) {
            this.addValue(init[i]);
        }
    }

    public void fromArray(double[] init) {
        this.removeAllElements();
        this.m_iType = 0;
        for (int i = 0; i < init.length; ++i) {
            this.addValue(init[i]);
        }
    }

    public void addValue(int value) {
        if (this.m_iType == 2) {
            this.m_hValue.addElement(new Integer(value));
        }
    }

    public void addValue(String value) {
        if (this.m_iType == 1) {
            this.m_hValue.addElement(value);
        }
    }

    public void addValue(double value) {
        if (this.m_iType == 0) {
            this.m_hValue.addElement(new Double(value));
        }
    }

    public int getIntAt(int idx) {
        if (this.m_iType == 2) {
            Integer value = (Integer)this.m_hValue.elementAt(idx);
            return value;
        }
        return 0;
    }

    public String getStringAt(int idx) {
        if (this.m_iType == 1) {
            return (String)this.m_hValue.elementAt(idx);
        }
        return "";
    }

    public double getDoubleAt(int idx) {
        if (this.m_iType == 0) {
            Double value = (Double)this.m_hValue.elementAt(idx);
            return value;
        }
        return 0.0;
    }

    @Override
    public INIFileNode cloneNode() {
        return new INIFileArray(this.getName(), this.getType());
    }

    @Override
    public void build(MStreamTokenizer tokens) throws IOException {
        tokens.readChar('{');
        this.removeAllElements();
        String token = tokens.getToken();
        while (token != null && !token.equals("}")) {
            this.addToken(token, tokens);
            token = this.readNextEntry(tokens);
        }
    }

    public void addToken(String token, MStreamTokenizer tokens) throws IOException {
        switch (this.m_iType) {
            case 0: {
                try {
                    this.addValue(Double.parseDouble(token.trim()));
                    break;
                }
                catch (NumberFormatException e) {
                    throw new IOException("Double expected at line " + tokens.getLine());
                }
            }
            case 2: {
                try {
                    this.addValue(Integer.parseInt(token.trim()));
                    break;
                }
                catch (NumberFormatException e) {
                    throw new IOException("Integer expected at line " + tokens.getLine());
                }
            }
            case 1: {
                this.m_hValue.addElement(token.trim());
            }
        }
    }

    @Override
    public void setValue(String value) {
    }

    public String readNextEntry(MStreamTokenizer tokens) throws IOException {
        String token = tokens.getToken();
        if (token != null && token.equals(",")) {
            token = tokens.getToken();
        }
        return token;
    }

    @Override
    public String getStringValue() {
        StringBuffer buffer = new StringBuffer("{");
        for (int idx = 0; idx < this.m_hValue.size(); ++idx) {
            Object value = this.m_hValue.elementAt(idx);
            if (idx != 0) {
                buffer.append(", ");
            }
            buffer.append(value.toString());
        }
        buffer.append("}");
        return buffer.toString();
    }
}

