/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.format;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import si.ijs.kt.clus.util.format.ClusFormat;
import si.ijs.kt.clus.util.jeans.util.StringUtils;

public class ClusNumberFormat {
    DecimalFormat m_SmallNumbersFormat;
    NumberFormat m_BigNumbersFormat;
    int m_AfterDot;

    public ClusNumberFormat(int precision) {
        if (precision < 0) {
            throw new RuntimeException("Precision has to be positive!");
        }
        String pattern_for_small = precision == 0 ? "0E0" : String.format("0.%sE0", StringUtils.makeString('0', precision));
        this.m_SmallNumbersFormat = new DecimalFormat(pattern_for_small);
        DecimalFormatSymbols sym = this.m_SmallNumbersFormat.getDecimalFormatSymbols();
        sym.setDecimalSeparator('.');
        this.m_SmallNumbersFormat.setGroupingUsed(false);
        this.m_SmallNumbersFormat.setDecimalFormatSymbols(sym);
        this.m_BigNumbersFormat = ClusFormat.makeNAfterDot(precision);
        this.m_AfterDot = precision;
    }

    public String format(double d) {
        if (-1.0 < d && d < 1.0 && d != 0.0) {
            return this.m_SmallNumbersFormat.format(d);
        }
        return this.m_BigNumbersFormat.format(d);
    }

    public String format(int d) {
        if (-1 < d && d < 1 && d != 0) {
            return this.m_SmallNumbersFormat.format(d);
        }
        return this.m_BigNumbersFormat.format(d);
    }

    public String format(long d) {
        if (-1L < d && d < 1L && d != 0L) {
            return this.m_SmallNumbersFormat.format(d);
        }
        return this.m_BigNumbersFormat.format(d);
    }
}

