/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.statistic;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.math3.distribution.HypergeometricDistribution;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.attweights.ClusAttributeWeights;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.ext.hierarchical.ClassHierarchy;
import si.ijs.kt.clus.ext.hierarchical.ClassTerm;
import si.ijs.kt.clus.ext.hierarchical.ClassesTuple;
import si.ijs.kt.clus.ext.hierarchical.ClassesValue;
import si.ijs.kt.clus.heuristic.GISHeuristic;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsHMLC;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.RegressionStatBinaryNomiss;
import si.ijs.kt.clus.statistic.StatisticPrintInfo;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.format.ClusFormat;
import si.ijs.kt.clus.util.format.ClusNumberFormat;
import si.ijs.kt.clus.util.jeans.util.array.MIntArray;

public class WHTDStatistic
extends RegressionStatBinaryNomiss {
    public static final long serialVersionUID = 1L;
    private static final double DUMMY_THETA = -1.0;
    protected ClassHierarchy m_Hier;
    protected boolean[] m_DiscrMean;
    protected WHTDStatistic m_Global;
    protected WHTDStatistic m_Validation;
    protected double m_SigLevel;
    protected double m_Threshold = -1.0;
    protected SettingsHMLC.HierarchyDistance m_Distance;
    protected double[] m_P;
    private double[] m_Thresholds;
    private RowData m_data;
    private int splitIndex;
    private int prevIndex;
    private double[] previousSumW;
    private double[] previousSumX;
    private double[] previousSumXR;
    private double[] previousSumWXX;
    private double[] previousSumWX;
    private double[] previousSumX2;
    private double[] previousSumWXXR;
    private double[] previousSumWXR;
    private double[] previousSumWR;
    private double[] previousSumX2R;
    private double[] m_Weights;
    public static boolean INITIALIZEPARTIALSUM = true;

    public WHTDStatistic(Settings sett, ClassHierarchy hier) {
        this(sett, hier, false);
    }

    public WHTDStatistic(Settings sett, ClassHierarchy hier, boolean onlymean) {
        super(sett, hier.getDummyAttrs(), onlymean);
        this.m_Hier = hier;
        this.m_Weights = this.m_Hier.getWeights();
        this.previousSumX = new double[1];
        this.previousSumXR = new double[1];
        this.previousSumW = new double[1];
        this.previousSumWXX = new double[1];
        this.previousSumWX = new double[1];
        this.previousSumX2 = new double[1];
        this.previousSumWR = new double[1];
        this.previousSumWXXR = new double[1];
        this.previousSumWXR = new double[1];
        this.previousSumX2R = new double[1];
        this.m_Distance = sett.getHMLC().getHierDistance();
        if (this.m_Distance.equals((Object)SettingsHMLC.HierarchyDistance.PooledAUPRC)) {
            this.m_P = new double[this.m_Hier.getTotal()];
        }
    }

    @Override
    public void setTrainingStat(ClusStatistic train) {
        this.m_Training = (WHTDStatistic)train;
    }

    public void setValidationStat(WHTDStatistic valid) {
        this.m_Validation = valid;
    }

    public void setGlobalStat(WHTDStatistic global) {
        this.m_Global = global;
    }

    public void setSigLevel(double sig) {
        this.m_SigLevel = sig;
    }

    public void setThreshold(double threshold) {
        this.m_Threshold = threshold;
    }

    public double getThreshold() {
        return this.m_Threshold;
    }

    @Override
    public ClusStatistic cloneStat() {
        WHTDStatistic res = new WHTDStatistic(this.m_Settings, this.m_Hier, false);
        res.m_Training = this.m_Training;
        res.m_ParentStat = this.m_ParentStat;
        return res;
    }

    @Override
    public ClusStatistic cloneSimple() {
        WHTDStatistic res = new WHTDStatistic(this.m_Settings, this.m_Hier, true);
        res.m_Threshold = this.m_Threshold;
        res.m_Thresholds = this.m_Thresholds;
        res.m_Training = this.m_Training;
        res.m_ParentStat = this.m_ParentStat;
        if (this.m_Validation != null) {
            res.m_Validation = (WHTDStatistic)this.m_Validation.cloneSimple();
            res.m_Global = this.m_Global;
            res.m_SigLevel = this.m_SigLevel;
        }
        return res;
    }

    public void copyAll(ClusStatistic other) {
        super.copy(other);
        WHTDStatistic my_other = (WHTDStatistic)other;
        this.m_Global = my_other.m_Global;
        this.m_Validation = my_other.m_Validation;
        this.m_SigLevel = my_other.m_SigLevel;
    }

    @Override
    public void addPrediction(ClusStatistic other, double weight) {
        WHTDStatistic or = (WHTDStatistic)other;
        super.addPrediction(other, weight);
        if (this.m_Validation != null) {
            this.m_Validation.addPrediction(or.m_Validation, weight);
        }
    }

    @Override
    public void updateWeighted(DataTuple tuple, double weight) {
        int sidx = this.m_Hier.getType().getArrayIndex();
        ClassesTuple tp = (ClassesTuple)tuple.getObjVal(sidx);
        if (tp.getNbClasses() > 0) {
            this.m_SumWeightLabeled += weight;
            this.m_SumWeight += weight;
            for (int j = 0; j < tp.getNbClasses(); ++j) {
                int idx;
                ClassesValue val = tp.getClass(j);
                int n = idx = val.getIndex();
                this.m_SumValues[n] = this.m_SumValues[n] + weight;
                if (!this.m_Distance.equals((Object)SettingsHMLC.HierarchyDistance.PooledAUPRC)) continue;
                int n2 = idx;
                this.m_P[n2] = this.m_P[n2] + weight;
            }
        }
    }

    public final ClassHierarchy getHier() {
        return this.m_Hier;
    }

    public final void setHier(ClassHierarchy hier) throws ClusException {
        if (this.m_Hier != null && this.m_Hier.getTotal() != hier.getTotal()) {
            throw new ClusException("Different number of classes in new hierarchy: " + hier.getTotal() + " <> " + this.m_Hier.getTotal());
        }
        this.m_Hier = hier;
    }

    public int getNbPredictedClasses() {
        int count = 0;
        for (int i = 0; i < this.m_DiscrMean.length; ++i) {
            if (!this.m_DiscrMean[i]) continue;
            ++count;
        }
        return count;
    }

    public ClassesTuple computeMeanTuple() {
        return this.m_Hier.getTuple(this.m_DiscrMean);
    }

    public ClassesTuple computePrintTuple() {
        ClassesTuple printTuple = this.m_Hier.getTuple(this.m_DiscrMean);
        ArrayList<ClassesValue> added = new ArrayList<ClassesValue>();
        boolean[] interms = new boolean[this.m_Hier.getTotal()];
        printTuple.addIntermediateElems(this.m_Hier, interms, added);
        return printTuple;
    }

    @Override
    public void computePrediction() {
        double threshold = this.m_Threshold == -1.0 ? 0.5 : this.m_Threshold;
        ClassesTuple meantuple = this.m_Hier.getBestTupleMaj(this.m_Means, threshold);
        this.m_DiscrMean = meantuple.getVectorBooleanNodeAndAncestors(this.m_Hier);
        this.performSignificanceTest();
    }

    public String getArrayOfStatisticExtended() {
        CharSequence[] labelThresholdPairs = new String[this.m_Means.length];
        for (int i = 0; i < this.m_Means.length; ++i) {
            String label = this.m_Hier.getTermAt(i).toStringHuman(this.m_Hier);
            double p = this.m_Means[i];
            labelThresholdPairs[i] = String.format("%f", p);
        }
        return "[" + String.join((CharSequence)",", labelThresholdPairs) + "]";
    }

    public String getTargetNames() {
        CharSequence[] names = new String[this.m_Means.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = "'" + this.m_Hier.getTermAt(i).toStringHuman(this.m_Hier) + "'";
        }
        return "[" + String.join((CharSequence)", ", names) + "]";
    }

    @Override
    public void calcMean(double[] means) {
        if (this.getSettings().getHMLC().useMEstimate() && this.m_Training != null) {
            for (int i = 0; i < this.m_NbAttrs; ++i) {
                means[i] = (this.m_SumValues[i] + this.m_Training.m_Means[i]) / (this.m_SumWeight + 1.0);
            }
        } else {
            for (int i = 0; i < this.m_NbAttrs; ++i) {
                means[i] = this.getMean(i);
            }
        }
    }

    @Override
    public void predictTuple(DataTuple prediction) {
        prediction.setObjectVal(this.computeMeanTuple(), this.m_Hier.getType().getArrayIndex());
    }

    @Override
    public double getMean(int i) {
        if (this.getSettings().getHMLC().useMEstimate() && this.m_Training != null) {
            return (this.m_SumValues[i] + this.m_Training.m_Means[i]) / (this.m_SumWeight + 1.0);
        }
        if (this.m_SumWeight == 0.0) {
            switch (this.getSettings().getTree().getMissingTargetAttrHandling()) {
                case ParentNode: {
                    return this.m_ParentStat.getMean(i);
                }
                case Zero: {
                    return 0.0;
                }
            }
            return this.m_Training.getMean(i);
        }
        return this.m_SumValues[i] / this.m_SumWeight;
    }

    @Override
    public void calcMean() {
        super.calcMean();
        this.computePrediction();
    }

    public int round(double value) {
        return (int)Math.round(value);
    }

    public void performSignificanceTest() {
        if (this.m_Validation != null) {
            for (int i = 0; i < this.m_DiscrMean.length; ++i) {
                HypergeometricDistribution dist;
                double stat;
                if (!this.m_DiscrMean[i]) continue;
                int pop_tot = this.round(this.m_Global.getTotalWeight());
                int pop_cls = this.round(this.m_Global.getTotalWeight() * this.m_Global.m_Means[i]);
                int rule_tot = this.round(this.m_Validation.getTotalWeight());
                int rule_cls = this.round(this.m_Validation.getTotalWeight() * this.m_Validation.m_Means[i]);
                int upper = Math.min(rule_tot, pop_cls);
                int nb_other = pop_tot - pop_cls;
                int min_this = rule_tot - nb_other;
                int lower = Math.max(rule_cls, min_this);
                if (rule_cls < min_this || lower > upper) {
                    System.err.println("BUG?");
                    ClusLogger.info("rule = " + this.m_Validation.getTotalWeight() * this.m_Validation.m_Means[i]);
                    ClusLogger.info("pop_tot = " + pop_tot + " pop_cls = " + pop_cls + " rule_tot = " + rule_tot + " rule_cls = " + rule_cls);
                }
                if (!((stat = (dist = new HypergeometricDistribution(pop_tot, pop_cls, rule_tot)).cumulativeProbability(lower, upper)) >= this.m_SigLevel)) continue;
                this.m_DiscrMean[i] = false;
            }
        }
    }

    public void setMeanTuple(ClassesTuple tuple) {
        this.setMeanTuple(tuple.getVectorBoolean(this.m_Hier));
    }

    public void setMeanTuple(boolean[] cls) {
        this.m_DiscrMean = new boolean[cls.length];
        System.arraycopy(cls, 0, this.m_DiscrMean, 0, cls.length);
        Arrays.fill(this.m_Means, 0.0);
        for (int i = 0; i < this.m_DiscrMean.length; ++i) {
            if (!this.m_DiscrMean[i]) continue;
            this.m_Means[i] = 1.0;
        }
    }

    public boolean[] getDiscretePred() {
        return this.m_DiscrMean;
    }

    @Override
    public double getSquaredDistance(DataTuple tuple, ClusAttributeWeights weights) {
        double sum = 0.0;
        boolean[] actual = new boolean[this.m_Hier.getTotal()];
        ClassesTuple tp = (ClassesTuple)tuple.getObjVal(this.m_Hier.getType().getArrayIndex());
        tp.fillBoolArrayNodeAndAncestors(actual);
        for (int i = 0; i < this.m_Hier.getTotal(); ++i) {
            NumericAttrType type = this.getAttribute(i);
            double actual_zo = actual[i] ? 1.0 : 0.0;
            double dist = actual_zo - this.m_Means[i];
            sum += dist * dist * weights.getWeight(type);
        }
        return sum / (double)this.getNbAttributes();
    }

    public double getSquaredDistanceH(DataTuple tuple, double[] m_Weights) {
        if (this.m_Means == null) {
            this.calcMean();
        }
        double sum = 0.0;
        boolean[] actual = new boolean[this.m_Hier.getTotal()];
        ClassesTuple tp = (ClassesTuple)tuple.getObjVal(this.m_Hier.getType().getArrayIndex());
        tp.fillBoolArrayNodeAndAncestors(actual);
        for (int i = 0; i < this.m_Hier.getTotal(); ++i) {
            double actual_zo = actual[i] ? 1.0 : 0.0;
            double dist = actual_zo - this.m_Means[i];
            sum += dist * dist * m_Weights[i];
        }
        return sum;
    }

    public double calcDistance(ClassesTuple t1, ClassesTuple t2) {
        double sum = 0.0;
        boolean[] actual1 = new boolean[this.m_Hier.getTotal()];
        boolean[] actual2 = new boolean[this.m_Hier.getTotal()];
        t1.fillBoolArrayNodeAndAncestors(actual1);
        t2.fillBoolArrayNodeAndAncestors(actual2);
        for (int i = 0; i < this.m_Hier.getTotal(); ++i) {
            double actual_zo2;
            double actual_zo1 = actual1[i] ? 1.0 : 0.0;
            double d = actual_zo2 = actual2[i] ? 1.0 : 0.0;
            if (actual_zo1 == actual_zo2) continue;
            sum += (actual_zo1 - actual_zo2) * (actual_zo1 - actual_zo2) * this.m_Weights[i];
        }
        return sum;
    }

    @Override
    public double calcPtotal(Integer[] permutation) throws ClusException {
        double avgik = 0.0;
        double W = 0.0;
        double upsum = 0.0;
        double downsum = 0.0;
        double upsumR = 0.0;
        double downsumR = 0.0;
        int M = 0;
        int N = this.m_data.getNbRows();
        long NR = this.m_data.getNbRows();
        if (this.splitIndex > 0) {
            N = this.splitIndex;
        } else {
            M = -this.splitIndex;
        }
        for (int i = M; i < N; ++i) {
            DataTuple exi = this.m_data.getTuple(permutation[i]);
            boolean[] actual = new boolean[this.m_Hier.getTotal()];
            ClassesTuple tp = (ClassesTuple)exi.getObjVal(this.m_Hier.getType().getArrayIndex());
            tp.fillBoolArrayNodeAndAncestors(actual);
            for (int j = M; j < N; ++j) {
                long indexMap;
                Double temp;
                DataTuple exj = this.m_data.getTuple(permutation[j]);
                boolean[] actual1 = new boolean[this.m_Hier.getTotal()];
                ClassesTuple tp1 = (ClassesTuple)exj.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp1.fillBoolArrayNodeAndAncestors(actual1);
                long indexI = permutation[i].intValue();
                long indexJ = permutation[j].intValue();
                if (permutation[i] == permutation[j]) continue;
                if (permutation[i] > permutation[j]) {
                    indexI = permutation[j].intValue();
                    indexJ = permutation[i].intValue();
                }
                if ((temp = GISHeuristic.m_distances.get(indexMap = indexI * NR + indexJ)) == null) continue;
                upsum += Math.sqrt(this.getSquaredDistanceH(exi, this.m_Weights) * this.getSquaredDistanceH(exj, this.m_Weights));
            }
            downsum += this.getSquaredDistanceH(exi, this.m_Weights);
        }
        avgik = upsum != 0.0 && downsum != 0.0 ? ((double)(N - M) + 0.0) * upsum / (W * downsum) : 1.0;
        double IL = avgik * (double)(N - M);
        N = this.m_data.getNbRows();
        M = this.splitIndex;
        double avgikR = 0.0;
        double WR = 0.0;
        for (int i = M; i < N; ++i) {
            DataTuple exi = this.m_data.getTuple(permutation[i]);
            boolean[] actual = new boolean[this.m_Hier.getTotal()];
            ClassesTuple tp = (ClassesTuple)exi.getObjVal(this.m_Hier.getType().getArrayIndex());
            tp.fillBoolArrayNodeAndAncestors(actual);
            for (int j = M; j < N; ++j) {
                long indexMap;
                Double temp;
                DataTuple exj = this.m_data.getTuple(permutation[j]);
                boolean[] actual1 = new boolean[this.m_Hier.getTotal()];
                ClassesTuple tp1 = (ClassesTuple)exj.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp1.fillBoolArrayNodeAndAncestors(actual1);
                long indexI = permutation[i].intValue();
                long indexJ = permutation[j].intValue();
                if (permutation[i] == permutation[j]) continue;
                if (permutation[i] > permutation[j]) {
                    indexI = permutation[j].intValue();
                    indexJ = permutation[i].intValue();
                }
                if ((temp = GISHeuristic.m_distances.get(indexMap = indexI * NR + indexJ)) == null) continue;
                upsumR += Math.sqrt(this.getSquaredDistanceH(exi, this.m_Weights) * this.getSquaredDistanceH(exj, this.m_Weights));
            }
            downsumR += this.getSquaredDistanceH(exi, this.m_Weights);
        }
        avgikR = upsumR != 0.0 && downsumR != 0.0 ? ((double)(N - M) + 0.0) * upsumR / (WR * downsumR) : 1.0;
        double I = 1.0 + (IL + avgikR * (double)(N - M)) / (double)this.m_data.getNbRows();
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return I;
    }

    @Override
    public double calcGtotal(Integer[] permutation) throws ClusException {
        double avgik = 0.0;
        double W = 0.0;
        double upsum = 0.0;
        double downsum = 0.0;
        double upsumR = 0.0;
        double downsumR = 0.0;
        int M = 0;
        int N = this.m_data.getNbRows();
        long NR = this.m_data.getNbRows();
        if (this.splitIndex > 0) {
            N = this.splitIndex;
        } else {
            M = -this.splitIndex;
        }
        for (int i = M; i < N; ++i) {
            DataTuple exi = this.m_data.getTuple(permutation[i]);
            boolean[] actual = new boolean[this.m_Hier.getTotal()];
            ClassesTuple tp = (ClassesTuple)exi.getObjVal(this.m_Hier.getType().getArrayIndex());
            tp.fillBoolArrayNodeAndAncestors(actual);
            for (int j = M; j < N; ++j) {
                DataTuple exj = this.m_data.getTuple(permutation[j]);
                boolean[] actual1 = new boolean[this.m_Hier.getTotal()];
                ClassesTuple tp1 = (ClassesTuple)exj.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp1.fillBoolArrayNodeAndAncestors(actual1);
                double w = 0.0;
                long indexI = permutation[i].intValue();
                long indexJ = permutation[j].intValue();
                if (permutation[i] != permutation[j]) {
                    long indexMap;
                    Double temp;
                    if (permutation[i] > permutation[j]) {
                        indexI = permutation[j].intValue();
                        indexJ = permutation[i].intValue();
                    }
                    w = (temp = GISHeuristic.m_distances.get(indexMap = indexI * NR + indexJ)) != null ? temp : 0.0;
                    upsum += w * this.calcDistance(tp, tp1);
                    W += w;
                    continue;
                }
                upsum += this.calcDistance(tp, tp);
                W += 1.0;
            }
            downsum += this.getSquaredDistanceH(exi, this.m_Weights);
        }
        double num = ((double)(N - M) - 1.0) * upsum;
        double den = 2.0 * W * downsum;
        avgik = num != 0.0 && den != 0.0 ? num / den : 0.0;
        double IL = avgik * (double)(N - M);
        N = this.m_data.getNbRows();
        M = this.splitIndex;
        double avgikR = 0.0;
        double WR = 0.0;
        for (int i = M; i < N; ++i) {
            DataTuple exi = this.m_data.getTuple(permutation[i]);
            boolean[] actual = new boolean[this.m_Hier.getTotal()];
            ClassesTuple tp = (ClassesTuple)exi.getObjVal(this.m_Hier.getType().getArrayIndex());
            tp.fillBoolArrayNodeAndAncestors(actual);
            for (int j = M; j < N; ++j) {
                DataTuple exj = this.m_data.getTuple(permutation[j]);
                boolean[] actual1 = new boolean[this.m_Hier.getTotal()];
                ClassesTuple tp1 = (ClassesTuple)exj.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp1.fillBoolArrayNodeAndAncestors(actual1);
                double w = 0.0;
                long indexI = permutation[i].intValue();
                long indexJ = permutation[j].intValue();
                if (permutation[i] != permutation[j]) {
                    long indexMap;
                    Double temp;
                    if (permutation[i] > permutation[j]) {
                        indexI = permutation[j].intValue();
                        indexJ = permutation[i].intValue();
                    }
                    w = (temp = GISHeuristic.m_distances.get(indexMap = indexI * NR + indexJ)) != null ? temp : 0.0;
                    upsumR += w * this.calcDistance(tp, tp1);
                    WR += w;
                    continue;
                }
                upsumR += this.calcDistance(tp, tp);
                WR += 1.0;
            }
            downsumR += this.getSquaredDistanceH(exi, this.m_Weights);
        }
        num = ((double)(N - M) - 1.0) * upsumR;
        den = 2.0 * WR * downsumR;
        avgikR = num != 0.0 && den != 0.0 ? num / den : 0.0;
        double scaledI = 1.0 + (IL + avgikR * (double)(N - M)) / (double)this.m_data.getNbRows();
        if (Double.isNaN(scaledI)) {
            throw new ClusException("err!");
        }
        return scaledI;
    }

    @Override
    public double calcEquvalentItotal(Integer[] permutation) throws ClusException {
        Double temp;
        long indexMap;
        DataTuple exi;
        Double temp2;
        DataTuple exj;
        double w;
        DataTuple exi2;
        int i;
        int M = 0;
        int N = 0;
        int NR = this.m_data.getNbRows();
        double I = 0.0;
        double avgik = 0.0;
        double avgikR = 0.0;
        double ikkR = 0.0;
        int vkupenBrojElementiVoOvojSplit = N - M;
        int vkupenBrojElementiVoCelataSuma = NR;
        M = this.prevIndex;
        N = this.splitIndex;
        if (INITIALIZEPARTIALSUM) {
            INITIALIZEPARTIALSUM = false;
            for (int i2 = M = 0; i2 < NR; ++i2) {
                DataTuple exi3 = this.m_data.getTuple(permutation[i2]);
                this.previousSumX2R[0] = this.previousSumX2R[0] + this.getSquaredDistanceH(exi3, this.m_Weights);
                this.previousSumXR[0] = this.previousSumXR[0] + Math.sqrt(this.getSquaredDistanceH(exi3, this.m_Weights));
                for (int j = M; j < NR; ++j) {
                    Double temp3;
                    DataTuple exj2 = this.m_data.getTuple(permutation[j]);
                    long indexMap2 = permutation[i2] * NR + permutation[j];
                    double w2 = 0.0;
                    if (permutation[i2] > permutation[j]) {
                        indexMap2 = permutation[j] * NR + permutation[i2];
                    }
                    w2 = (temp3 = GISHeuristic.m_distances.get(indexMap2)) != null ? temp3 : 0.0;
                    this.previousSumWR[0] = this.previousSumWR[0] + w2;
                    this.previousSumWXXR[0] = this.previousSumWXXR[0] + w2 * Math.sqrt(this.getSquaredDistanceH(exi3, this.m_Weights) * this.getSquaredDistanceH(exj2, this.m_Weights));
                }
            }
        }
        boolean flagRightAllEqual = true;
        boolean flagLeftAllEqual = true;
        for (int i3 = M; i3 < N; ++i3) {
            DataTuple exi4 = this.m_data.getTuple(permutation[i3]);
            this.previousSumX2[0] = this.previousSumX2[0] + this.getSquaredDistanceH(exi4, this.m_Weights);
            this.previousSumX[0] = this.previousSumX[0] + Math.sqrt(this.getSquaredDistanceH(exi4, this.m_Weights));
            this.previousSumX2R[0] = this.previousSumX2R[0] - this.getSquaredDistanceH(exi4, this.m_Weights);
            this.previousSumXR[0] = this.previousSumXR[0] - Math.sqrt(this.getSquaredDistanceH(exi4, this.m_Weights));
        }
        flagLeftAllEqual = true;
        double oldX = Math.sqrt(this.getSquaredDistanceH(this.m_data.getTuple(0), this.m_Weights));
        for (i = 1; i < N; ++i) {
            exi2 = this.m_data.getTuple(permutation[i]);
            if (Math.sqrt(this.getSquaredDistanceH(exi2, this.m_Weights)) == oldX) continue;
            flagLeftAllEqual = false;
            break;
        }
        for (i = 0; i < M; ++i) {
            exi2 = this.m_data.getTuple(permutation[i]);
            for (int j = M; j < N; ++j) {
                long indexMap3 = permutation[i] * NR + permutation[j];
                w = 0.0;
                exj = this.m_data.getTuple(permutation[j]);
                if (permutation[i] > permutation[j]) {
                    indexMap3 = permutation[j] * NR + permutation[i];
                }
                w = (temp2 = GISHeuristic.m_distances.get(indexMap3)) != null ? temp2 : 0.0;
                this.previousSumW[0] = this.previousSumW[0] + w;
                this.previousSumWXX[0] = this.previousSumWXX[0] + w * Math.sqrt(this.getSquaredDistanceH(exi2, this.m_Weights) * this.getSquaredDistanceH(exj, this.m_Weights));
            }
        }
        for (i = M; i < N; ++i) {
            for (int j = 0; j < M; ++j) {
                long indexMap4 = permutation[i] * NR + permutation[j];
                double w3 = 0.0;
                DataTuple exj3 = this.m_data.getTuple(permutation[j]);
                exi = this.m_data.getTuple(permutation[i]);
                if (permutation[i] > permutation[j]) {
                    indexMap4 = permutation[j] * NR + permutation[i];
                }
                w3 = (temp2 = GISHeuristic.m_distances.get(indexMap4)) != null ? temp2 : 0.0;
                this.previousSumW[0] = this.previousSumW[0] + w3;
                this.previousSumWXX[0] = this.previousSumWXX[0] + w3 * Math.sqrt(this.getSquaredDistanceH(exi, this.m_Weights) * this.getSquaredDistanceH(exj3, this.m_Weights));
            }
        }
        for (i = M; i < N; ++i) {
            exi2 = this.m_data.getTuple(permutation[i]);
            for (int j = M; j < N; ++j) {
                DataTuple exj4 = this.m_data.getTuple(permutation[j]);
                double w4 = 0.0;
                long indexI = permutation[i].intValue();
                long indexJ = permutation[j].intValue();
                if (permutation[i] > permutation[j]) {
                    indexI = permutation[j].intValue();
                    indexJ = permutation[i].intValue();
                }
                indexMap = indexI * (long)NR + indexJ;
                if (permutation[i] > permutation[j]) {
                    indexMap = permutation[j] * NR + permutation[i];
                }
                w4 = (temp = GISHeuristic.m_distances.get(indexMap)) != null ? temp : 0.0;
                this.previousSumW[0] = this.previousSumW[0] + w4;
                this.previousSumWXX[0] = this.previousSumWXX[0] + w4 * Math.sqrt(this.getSquaredDistanceH(exi2, this.m_Weights) * this.getSquaredDistanceH(exj4, this.m_Weights));
            }
        }
        flagRightAllEqual = true;
        oldX = Math.sqrt(this.getSquaredDistanceH(this.m_data.getTuple(N), this.m_Weights));
        for (i = N; i < NR; ++i) {
            exi2 = this.m_data.getTuple(i);
            if (oldX != Math.sqrt(this.getSquaredDistanceH(exi2, this.m_Weights))) {
                flagRightAllEqual = false;
            }
            for (int j = M; j < N; ++j) {
                Double temp4;
                long indexMap5 = permutation[i] * NR + permutation[j];
                w = 0.0;
                exj = this.m_data.getTuple(permutation[j]);
                if (Math.sqrt(this.getSquaredDistanceH(exi2, this.m_Weights)) != oldX) {
                    flagRightAllEqual = false;
                }
                if (permutation[i] > permutation[j]) {
                    indexMap5 = permutation[j] * NR + permutation[i];
                }
                w = (temp4 = GISHeuristic.m_distances.get(indexMap5)) != null ? temp4 : 0.0;
                this.previousSumWR[0] = this.previousSumWR[0] - w;
                this.previousSumWXXR[0] = this.previousSumWXXR[0] - w * Math.sqrt(this.getSquaredDistanceH(exi2, this.m_Weights) * this.getSquaredDistanceH(exj, this.m_Weights));
            }
        }
        for (i = M; i < N; ++i) {
            for (int j = N; j < NR; ++j) {
                Double temp5;
                long indexMap6 = permutation[i] * NR + permutation[j];
                double w5 = 0.0;
                DataTuple exj5 = this.m_data.getTuple(permutation[j]);
                exi = this.m_data.getTuple(permutation[i]);
                if (permutation[i] > permutation[j]) {
                    indexMap6 = permutation[j] * NR + permutation[i];
                }
                w5 = (temp5 = GISHeuristic.m_distances.get(indexMap6)) != null ? temp5 : 0.0;
                this.previousSumWR[0] = this.previousSumWR[0] - w5;
                this.previousSumWXXR[0] = this.previousSumWXXR[0] - w5 * Math.sqrt(this.getSquaredDistanceH(exi, this.m_Weights) * this.getSquaredDistanceH(exj5, this.m_Weights));
            }
        }
        for (i = M; i < N; ++i) {
            exi2 = this.m_data.getTuple(permutation[i]);
            for (int j = M; j < N; ++j) {
                DataTuple exj6 = this.m_data.getTuple(permutation[j]);
                double w6 = 0.0;
                long indexI = permutation[i].intValue();
                long indexJ = permutation[j].intValue();
                if (permutation[i] > permutation[j]) {
                    indexI = permutation[j].intValue();
                    indexJ = permutation[i].intValue();
                }
                indexMap = indexI * (long)NR + indexJ;
                if (permutation[i] > permutation[j]) {
                    indexMap = permutation[j] * NR + permutation[i];
                }
                w6 = (temp = GISHeuristic.m_distances.get(indexMap)) != null ? temp : 0.0;
                this.previousSumWR[0] = this.previousSumWR[0] - w6;
                this.previousSumWXXR[0] = this.previousSumWXXR[0] - w6 * Math.sqrt(this.getSquaredDistanceH(exi2, this.m_Weights) * this.getSquaredDistanceH(exj6, this.m_Weights));
            }
        }
        vkupenBrojElementiVoOvojSplit = N;
        double num = (double)vkupenBrojElementiVoOvojSplit * this.previousSumWXX[0];
        double den = this.previousSumW[0] * this.previousSumX2[0];
        double ikk = den != 0.0 && num != 0.0 && !flagLeftAllEqual ? num / den : 1.0;
        vkupenBrojElementiVoOvojSplit = NR - N;
        double numR = (double)vkupenBrojElementiVoOvojSplit * this.previousSumWXXR[0];
        double denR = this.previousSumWR[0] * this.previousSumX2R[0];
        ikkR = denR != 0.0 && numR != 0.0 && !flagRightAllEqual ? numR / denR : 1.0;
        I = ((avgik += ikk) * (double)N + (avgikR += ikkR) * (double)(NR - N)) / (double)vkupenBrojElementiVoCelataSuma;
        M = this.prevIndex;
        N = this.splitIndex;
        double scaledI = 1.0 + I;
        if (Double.isNaN(scaledI)) {
            throw new ClusException("err!");
        }
        return scaledI;
    }

    @Override
    public double calcEquvalentGtotal(Integer[] permutation) throws ClusException {
        boolean[] actual;
        DataTuple exi;
        long indexMap;
        Double temp;
        long indexI;
        ClassesTuple tp1;
        DataTuple exj;
        ClassesTuple tp;
        boolean[] actual2;
        DataTuple exi2;
        int i;
        int M = 0;
        int N = 0;
        int NR = this.m_data.getNbRows();
        double I = 0.0;
        int vkupenBrojElementiVoOvojSplit = N - M;
        int vkupenBrojElementiVoCelataSuma = NR;
        M = this.prevIndex;
        N = this.splitIndex;
        if (INITIALIZEPARTIALSUM) {
            INITIALIZEPARTIALSUM = false;
            for (int i2 = M = 0; i2 < NR; ++i2) {
                DataTuple exi3 = this.m_data.getTuple(permutation[i2]);
                boolean[] actual3 = new boolean[this.m_Hier.getTotal()];
                ClassesTuple tp2 = (ClassesTuple)exi3.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp2.fillBoolArrayNodeAndAncestors(actual3);
                this.previousSumX2R[0] = this.previousSumX2R[0] + this.getSquaredDistanceH(exi3, this.m_Weights);
                this.previousSumXR[0] = this.previousSumXR[0] + Math.sqrt(this.getSquaredDistanceH(exi3, this.m_Weights));
                for (int j = M; j < NR; ++j) {
                    DataTuple exj2 = this.m_data.getTuple(permutation[j]);
                    boolean[] actual1 = new boolean[this.m_Hier.getTotal()];
                    ClassesTuple tp12 = (ClassesTuple)exj2.getObjVal(this.m_Hier.getType().getArrayIndex());
                    tp12.fillBoolArrayNodeAndAncestors(actual1);
                    double w = 0.0;
                    long indexI2 = permutation[i2].intValue();
                    long indexJ = permutation[j].intValue();
                    if (permutation[i2] != permutation[j]) {
                        long indexMap2;
                        Double temp2;
                        if (permutation[i2] > permutation[j]) {
                            indexI2 = permutation[j].intValue();
                            indexJ = permutation[i2].intValue();
                        }
                        w = (temp2 = GISHeuristic.m_distances.get(indexMap2 = indexI2 * (long)NR + indexJ)) != null ? temp2 : 0.0;
                        this.previousSumWR[0] = this.previousSumWR[0] + w;
                        this.previousSumWXXR[0] = this.previousSumWXXR[0] + w * this.calcDistance(tp2, tp12);
                        continue;
                    }
                    this.previousSumWR[0] = this.previousSumWR[0] + 1.0;
                    this.previousSumWXXR[0] = this.previousSumWXXR[0] + this.calcDistance(tp2, tp2);
                }
            }
        }
        boolean flagRightAllEqual = true;
        boolean flagLeftAllEqual = true;
        for (int i3 = M; i3 < N; ++i3) {
            DataTuple exi4 = this.m_data.getTuple(permutation[i3]);
            boolean[] actual4 = new boolean[this.m_Hier.getTotal()];
            ClassesTuple tp3 = (ClassesTuple)exi4.getObjVal(this.m_Hier.getType().getArrayIndex());
            tp3.fillBoolArrayNodeAndAncestors(actual4);
            this.previousSumX2[0] = this.previousSumX2[0] + this.getSquaredDistanceH(exi4, this.m_Weights);
            this.previousSumX[0] = this.previousSumX[0] + Math.sqrt(this.getSquaredDistanceH(exi4, this.m_Weights));
            this.previousSumX2R[0] = this.previousSumX2R[0] - this.getSquaredDistanceH(exi4, this.m_Weights);
            this.previousSumXR[0] = this.previousSumXR[0] - Math.sqrt(this.getSquaredDistanceH(exi4, this.m_Weights));
        }
        flagLeftAllEqual = true;
        double oldX = Math.sqrt(this.getSquaredDistanceH(this.m_data.getTuple(0), this.m_Weights));
        for (i = 1; i < N; ++i) {
            exi2 = this.m_data.getTuple(permutation[i]);
            actual2 = new boolean[this.m_Hier.getTotal()];
            tp = (ClassesTuple)exi2.getObjVal(this.m_Hier.getType().getArrayIndex());
            tp.fillBoolArrayNodeAndAncestors(actual2);
            if (Math.sqrt(this.getSquaredDistanceH(exi2, this.m_Weights)) == oldX) continue;
            flagLeftAllEqual = false;
            break;
        }
        for (i = 0; i < M; ++i) {
            exi2 = this.m_data.getTuple(permutation[i]);
            actual2 = new boolean[this.m_Hier.getTotal()];
            tp = (ClassesTuple)exi2.getObjVal(this.m_Hier.getType().getArrayIndex());
            tp.fillBoolArrayNodeAndAncestors(actual2);
            for (int j = M; j < N; ++j) {
                exj = this.m_data.getTuple(permutation[j]);
                boolean[] actual1 = new boolean[this.m_Hier.getTotal()];
                tp1 = (ClassesTuple)exj.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp1.fillBoolArrayNodeAndAncestors(actual1);
                double w = 0.0;
                indexI = permutation[i].intValue();
                long indexJ = permutation[j].intValue();
                if (permutation[i] != permutation[j]) {
                    if (permutation[i] > permutation[j]) {
                        indexI = permutation[j].intValue();
                        indexJ = permutation[i].intValue();
                    }
                    w = (temp = GISHeuristic.m_distances.get(indexMap = indexI * (long)NR + indexJ)) != null ? temp : 0.0;
                    this.previousSumW[0] = this.previousSumW[0] + w;
                    this.previousSumWXX[0] = this.previousSumWXX[0] + w * this.calcDistance(tp, tp1);
                    continue;
                }
                this.previousSumW[0] = this.previousSumW[0] + 1.0;
                this.previousSumWXX[0] = this.previousSumWXX[0] + this.calcDistance(tp, tp);
            }
        }
        for (i = M; i < N; ++i) {
            for (int j = 0; j < M; ++j) {
                exi = this.m_data.getTuple(permutation[i]);
                actual = new boolean[this.m_Hier.getTotal()];
                ClassesTuple tp4 = (ClassesTuple)exi.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp4.fillBoolArrayNodeAndAncestors(actual);
                exj = this.m_data.getTuple(permutation[j]);
                boolean[] actual1 = new boolean[this.m_Hier.getTotal()];
                tp1 = (ClassesTuple)exj.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp1.fillBoolArrayNodeAndAncestors(actual1);
                double w = 0.0;
                indexI = permutation[i].intValue();
                long indexJ = permutation[j].intValue();
                if (permutation[i] != permutation[j]) {
                    if (permutation[i] > permutation[j]) {
                        indexI = permutation[j].intValue();
                        indexJ = permutation[i].intValue();
                    }
                    w = (temp = GISHeuristic.m_distances.get(indexMap = indexI * (long)NR + indexJ)) != null ? temp : 0.0;
                    this.previousSumW[0] = this.previousSumW[0] + w;
                    this.previousSumWXX[0] = this.previousSumWXX[0] + w * this.calcDistance(tp4, tp1);
                    continue;
                }
                this.previousSumW[0] = this.previousSumW[0] + 1.0;
                this.previousSumWXX[0] = this.previousSumWXX[0] + this.calcDistance(tp4, tp4);
            }
        }
        for (i = M; i < N; ++i) {
            for (int j = M; j < N; ++j) {
                exi = this.m_data.getTuple(permutation[i]);
                actual = new boolean[this.m_Hier.getTotal()];
                ClassesTuple tp5 = (ClassesTuple)exi.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp5.fillBoolArrayNodeAndAncestors(actual);
                exj = this.m_data.getTuple(permutation[j]);
                boolean[] actual1 = new boolean[this.m_Hier.getTotal()];
                tp1 = (ClassesTuple)exj.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp1.fillBoolArrayNodeAndAncestors(actual1);
                double w = 0.0;
                indexI = permutation[i].intValue();
                long indexJ = permutation[j].intValue();
                if (permutation[i] != permutation[j]) {
                    if (permutation[i] > permutation[j]) {
                        indexI = permutation[j].intValue();
                        indexJ = permutation[i].intValue();
                    }
                    w = (temp = GISHeuristic.m_distances.get(indexMap = indexI * (long)NR + indexJ)) != null ? temp : 0.0;
                    this.previousSumW[0] = this.previousSumW[0] + w;
                    this.previousSumWXX[0] = this.previousSumWXX[0] + w * this.calcDistance(tp5, tp1);
                    continue;
                }
                this.previousSumW[0] = this.previousSumW[0] + 1.0;
                this.previousSumWXX[0] = this.previousSumWXX[0] + this.calcDistance(tp5, tp5);
            }
        }
        flagRightAllEqual = true;
        oldX = Math.sqrt(this.getSquaredDistanceH(this.m_data.getTuple(N), this.m_Weights));
        for (i = N; i < NR; ++i) {
            DataTuple exi5 = this.m_data.getTuple(permutation[i]);
            actual2 = new boolean[this.m_Hier.getTotal()];
            tp = (ClassesTuple)exi5.getObjVal(this.m_Hier.getType().getArrayIndex());
            tp.fillBoolArrayNodeAndAncestors(actual2);
            if (oldX != Math.sqrt(this.getSquaredDistanceH(exi5, this.m_Weights))) {
                flagRightAllEqual = false;
            }
            for (int j = M; j < N; ++j) {
                double w = 0.0;
                DataTuple exj3 = this.m_data.getTuple(permutation[j]);
                boolean[] actual1 = new boolean[this.m_Hier.getTotal()];
                ClassesTuple tp13 = (ClassesTuple)exj3.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp13.fillBoolArrayNodeAndAncestors(actual1);
                if (Math.sqrt(this.getSquaredDistanceH(exi5, this.m_Weights)) != oldX) {
                    flagRightAllEqual = false;
                }
                indexI = permutation[i].intValue();
                long indexJ = permutation[j].intValue();
                if (permutation[i] != permutation[j]) {
                    if (permutation[i] > permutation[j]) {
                        indexI = permutation[j].intValue();
                        indexJ = permutation[i].intValue();
                    }
                    w = (temp = GISHeuristic.m_distances.get(indexMap = indexI * (long)NR + indexJ)) != null ? temp : 0.0;
                    this.previousSumWR[0] = this.previousSumWR[0] - w;
                    this.previousSumWXXR[0] = this.previousSumWXXR[0] - w * this.calcDistance(tp, tp13);
                    continue;
                }
                this.previousSumWR[0] = this.previousSumWR[0] - 1.0;
                this.previousSumWXXR[0] = this.previousSumWXXR[0] - this.calcDistance(tp, tp);
            }
        }
        for (i = M; i < N; ++i) {
            for (int j = N; j < NR; ++j) {
                exi = this.m_data.getTuple(permutation[i]);
                actual = new boolean[this.m_Hier.getTotal()];
                ClassesTuple tp6 = (ClassesTuple)exi.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp6.fillBoolArrayNodeAndAncestors(actual);
                DataTuple exj4 = this.m_data.getTuple(permutation[j]);
                boolean[] actual1 = new boolean[this.m_Hier.getTotal()];
                tp1 = (ClassesTuple)exj4.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp1.fillBoolArrayNodeAndAncestors(actual1);
                double w = 0.0;
                indexI = permutation[i].intValue();
                long indexJ = permutation[j].intValue();
                if (permutation[i] != permutation[j]) {
                    if (permutation[i] > permutation[j]) {
                        indexI = permutation[j].intValue();
                        indexJ = permutation[i].intValue();
                    }
                    w = (temp = GISHeuristic.m_distances.get(indexMap = indexI * (long)NR + indexJ)) != null ? temp : 0.0;
                    this.previousSumWR[0] = this.previousSumWR[0] - w;
                    this.previousSumWXXR[0] = this.previousSumWXXR[0] - w * this.calcDistance(tp6, tp1);
                    continue;
                }
                this.previousSumWR[0] = this.previousSumWR[0] - 1.0;
                this.previousSumWXXR[0] = this.previousSumWXXR[0] - this.calcDistance(tp6, tp6);
            }
        }
        for (i = M; i < N; ++i) {
            DataTuple exi6 = this.m_data.getTuple(permutation[i]);
            actual2 = new boolean[this.m_Hier.getTotal()];
            tp = (ClassesTuple)exi6.getObjVal(this.m_Hier.getType().getArrayIndex());
            tp.fillBoolArrayNodeAndAncestors(actual2);
            for (int j = M; j < N; ++j) {
                DataTuple exj5 = this.m_data.getTuple(permutation[j]);
                boolean[] actual1 = new boolean[this.m_Hier.getTotal()];
                tp1 = (ClassesTuple)exj5.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp1.fillBoolArrayNodeAndAncestors(actual1);
                double w = 0.0;
                indexI = permutation[i].intValue();
                long indexJ = permutation[j].intValue();
                if (permutation[i] != permutation[j]) {
                    if (permutation[i] > permutation[j]) {
                        indexI = permutation[j].intValue();
                        indexJ = permutation[i].intValue();
                    }
                    w = (temp = GISHeuristic.m_distances.get(indexMap = indexI * (long)NR + indexJ)) != null ? temp : 0.0;
                    this.previousSumWR[0] = this.previousSumWR[0] - w;
                    this.previousSumWXXR[0] = this.previousSumWXXR[0] - w * this.calcDistance(tp, tp1);
                    continue;
                }
                this.previousSumWR[0] = this.previousSumWR[0] - 1.0;
                this.previousSumWXXR[0] = this.previousSumWXXR[0] - this.calcDistance(tp, tp);
            }
        }
        vkupenBrojElementiVoOvojSplit = N;
        double num = (double)(vkupenBrojElementiVoOvojSplit - 1) * this.previousSumWXX[0];
        double den = 2.0 * this.previousSumW[0] * this.previousSumX2[0];
        double ikk = den != 0.0 && num != 0.0 && !flagLeftAllEqual ? num / den : 0.0;
        vkupenBrojElementiVoOvojSplit = NR - N;
        double numR = (double)(vkupenBrojElementiVoOvojSplit - 1) * this.previousSumWXXR[0];
        double denR = 2.0 * this.previousSumWR[0] * this.previousSumX2R[0];
        double ikkR = denR != 0.0 && numR != 0.0 && !flagRightAllEqual ? numR / denR : 0.0;
        I = (ikk * (double)N + ikkR * (double)(NR - N)) / (double)vkupenBrojElementiVoCelataSuma;
        M = this.prevIndex;
        N = this.splitIndex;
        double scaledI = 1.0 + I;
        if (Double.isNaN(scaledI)) {
            throw new ClusException("err!");
        }
        return scaledI;
    }

    @Override
    public double calcItotal(Integer[] permutation) throws ClusException {
        double avgik = 0.0;
        double W = 0.0;
        double upsum = 0.0;
        double downsum = 0.0;
        double upsumR = 0.0;
        double downsumR = 0.0;
        int M = 0;
        int N = this.m_data.getNbRows();
        long NR = this.m_data.getNbRows();
        if (this.splitIndex > 0) {
            N = this.splitIndex;
        } else {
            M = -this.splitIndex;
        }
        for (int i = M; i < N; ++i) {
            DataTuple exi = this.m_data.getTuple(permutation[i]);
            boolean[] actual = new boolean[this.m_Hier.getTotal()];
            ClassesTuple tp = (ClassesTuple)exi.getObjVal(this.m_Hier.getType().getArrayIndex());
            tp.fillBoolArrayNodeAndAncestors(actual);
            for (int j = M; j < N; ++j) {
                DataTuple exj = this.m_data.getTuple(permutation[j]);
                boolean[] actual1 = new boolean[this.m_Hier.getTotal()];
                ClassesTuple tp1 = (ClassesTuple)exj.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp1.fillBoolArrayNodeAndAncestors(actual1);
                double w = 0.0;
                long indexI = permutation[i].intValue();
                long indexJ = permutation[j].intValue();
                if (permutation[i] != permutation[j]) {
                    long indexMap;
                    Double temp;
                    if (permutation[i] > permutation[j]) {
                        indexI = permutation[j].intValue();
                        indexJ = permutation[i].intValue();
                    }
                    w = (temp = GISHeuristic.m_distances.get(indexMap = indexI * NR + indexJ)) != null ? temp : 0.0;
                    upsum += w * Math.sqrt(this.getSquaredDistanceH(exi, this.m_Weights) * this.getSquaredDistanceH(exj, this.m_Weights));
                    W += w;
                    continue;
                }
                upsum += this.getSquaredDistanceH(exi, this.m_Weights);
                W += 1.0;
            }
            downsum += this.getSquaredDistanceH(exi, this.m_Weights);
        }
        double num = ((double)(N - M) + 0.0) * upsum;
        double den = W * downsum;
        avgik = num != 0.0 && den != 0.0 ? num / den : 1.0;
        double IL = avgik * (double)(N - M);
        N = this.m_data.getNbRows();
        M = this.splitIndex;
        double avgikR = 0.0;
        double WR = 0.0;
        for (int i = M; i < N; ++i) {
            DataTuple exi = this.m_data.getTuple(permutation[i]);
            boolean[] actual = new boolean[this.m_Hier.getTotal()];
            ClassesTuple tp = (ClassesTuple)exi.getObjVal(this.m_Hier.getType().getArrayIndex());
            tp.fillBoolArrayNodeAndAncestors(actual);
            for (int j = M; j < N; ++j) {
                DataTuple exj = this.m_data.getTuple(permutation[j]);
                boolean[] actual1 = new boolean[this.m_Hier.getTotal()];
                ClassesTuple tp1 = (ClassesTuple)exj.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp1.fillBoolArrayNodeAndAncestors(actual1);
                double w = 0.0;
                long indexI = permutation[i].intValue();
                long indexJ = permutation[j].intValue();
                if (permutation[i] != permutation[j]) {
                    long indexMap;
                    Double temp;
                    if (permutation[i] > permutation[j]) {
                        indexI = permutation[j].intValue();
                        indexJ = permutation[i].intValue();
                    }
                    w = (temp = GISHeuristic.m_distances.get(indexMap = indexI * NR + indexJ)) != null ? temp : 0.0;
                    upsumR += w * Math.sqrt(this.getSquaredDistanceH(exi, this.m_Weights) * this.getSquaredDistanceH(exj, this.m_Weights));
                    WR += w;
                    continue;
                }
                upsumR += this.getSquaredDistanceH(exi, this.m_Weights);
                WR += 1.0;
            }
            downsumR += this.getSquaredDistanceH(exi, this.m_Weights);
        }
        num = ((double)(N - M) + 0.0) * upsumR;
        den = WR * downsumR;
        avgikR = num != 0.0 && den != 0.0 ? num / den : 1.0;
        double I = (IL + avgikR * (double)(N - M)) / (double)this.m_data.getNbRows();
        double scaledI = 1.0 + I;
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return scaledI;
    }

    @Override
    public double calcItotalD(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_data.getSchema();
        ClusAttrType xt = schema.getAllAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
        double avgik = 0.0;
        double W = 0.0;
        double upsum = 0.0;
        double downsum = 0.0;
        double upsumR = 0.0;
        double downsumR = 0.0;
        int M = 0;
        int N = this.m_data.getNbRows();
        if (this.splitIndex > 0) {
            N = this.splitIndex;
        } else {
            M = -this.splitIndex;
        }
        for (int i = M; i < N; ++i) {
            DataTuple exi = this.m_data.getTuple(permutation[i]);
            String xxi = xt.getString(exi);
            for (int j = M; j < N; ++j) {
                DataTuple exj = this.m_data.getTuple(permutation[j]);
                String yyi = xt.getString(exj);
                double w = 0.0;
                String indexI = xxi;
                String indexJ = yyi;
                if (indexI != indexJ) {
                    String indexMap = indexI + "#" + indexJ;
                    Double temp = GISHeuristic.m_distancesS.get(indexMap);
                    w = temp != null ? temp : 0.0;
                    upsum += w * Math.sqrt(this.getSquaredDistanceH(exi, this.m_Weights) * this.getSquaredDistanceH(exj, this.m_Weights));
                    W += w;
                    continue;
                }
                upsum += this.getSquaredDistanceH(exi, this.m_Weights);
                W += 1.0;
            }
            downsum += this.getSquaredDistanceH(exi, this.m_Weights);
        }
        double num = ((double)(N - M) + 0.0) * upsum;
        double den = W * downsum;
        avgik = num != 0.0 && den != 0.0 ? num / den : 1.0;
        double IL = avgik * (double)(N - M);
        N = this.m_data.getNbRows();
        M = this.splitIndex;
        double avgikR = 0.0;
        double WR = 0.0;
        for (int i = M; i < N; ++i) {
            DataTuple exi = this.m_data.getTuple(permutation[i]);
            String xxi = xt.getString(exi);
            for (int j = M; j < N; ++j) {
                DataTuple exj = this.m_data.getTuple(permutation[j]);
                String yyi = xt.getString(exj);
                double w = 0.0;
                String indexI = xxi;
                String indexJ = yyi;
                if (indexI != indexJ) {
                    String indexMap = indexI + "#" + indexJ;
                    Double temp = GISHeuristic.m_distancesS.get(indexMap);
                    w = temp != null ? temp : 0.0;
                    upsumR += w * Math.sqrt(this.getSquaredDistanceH(exi, this.m_Weights) * this.getSquaredDistanceH(exj, this.m_Weights));
                    WR += w;
                    continue;
                }
                upsumR += this.getSquaredDistanceH(exi, this.m_Weights);
                WR += 1.0;
            }
            downsumR += this.getSquaredDistanceH(exi, this.m_Weights);
        }
        num = ((double)(N - M) + 0.0) * upsumR;
        den = WR * downsumR;
        avgikR = num != 0.0 && den != 0.0 ? num / den : 1.0;
        double I = (IL + avgikR * (double)(N - M)) / (double)this.m_data.getNbRows();
        double scaledI = 1.0 + I;
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return scaledI;
    }

    @Override
    public double calcPDistance(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_data.getSchema();
        ClusAttrType xt = schema.getAllAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
        double avgik = 0.0;
        double upsum = 0.0;
        double downsum = 0.0;
        double upsumR = 0.0;
        double downsumR = 0.0;
        int M = 0;
        int N = this.m_data.getNbRows();
        if (this.splitIndex > 0) {
            N = this.splitIndex;
        } else {
            M = -this.splitIndex;
        }
        for (int i = M; i < N; ++i) {
            DataTuple exi = this.m_data.getTuple(permutation[i]);
            String xxi = xt.getString(exi);
            boolean[] actual = new boolean[this.m_Hier.getTotal()];
            ClassesTuple tp = (ClassesTuple)exi.getObjVal(this.m_Hier.getType().getArrayIndex());
            tp.fillBoolArrayNodeAndAncestors(actual);
            for (int j = M; j < N; ++j) {
                String indexMap;
                Double temp;
                DataTuple exj = this.m_data.getTuple(permutation[j]);
                boolean[] actual1 = new boolean[this.m_Hier.getTotal()];
                ClassesTuple tp1 = (ClassesTuple)exj.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp1.fillBoolArrayNodeAndAncestors(actual1);
                String yyi = xt.getString(exj);
                String indexI = xxi;
                String indexJ = yyi;
                if (indexI == indexJ || (temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) == null) continue;
                upsum += Math.sqrt(this.getSquaredDistanceH(exi, this.m_Weights) * this.getSquaredDistanceH(exj, this.m_Weights));
            }
            downsum += this.getSquaredDistanceH(exi, this.m_Weights);
        }
        avgik = upsum != 0.0 && downsum != 0.0 ? upsum / downsum : 1.0;
        double IL = avgik * (double)(N - M);
        N = this.m_data.getNbRows();
        M = this.splitIndex;
        double avgikR = 0.0;
        for (int i = M; i < N; ++i) {
            DataTuple exi = this.m_data.getTuple(permutation[i]);
            String xxi = xt.getString(exi);
            boolean[] actual = new boolean[this.m_Hier.getTotal()];
            ClassesTuple tp = (ClassesTuple)exi.getObjVal(this.m_Hier.getType().getArrayIndex());
            tp.fillBoolArrayNodeAndAncestors(actual);
            for (int j = M; j < N; ++j) {
                String indexMap;
                Double temp;
                DataTuple exj = this.m_data.getTuple(permutation[j]);
                boolean[] actual1 = new boolean[this.m_Hier.getTotal()];
                ClassesTuple tp1 = (ClassesTuple)exj.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp1.fillBoolArrayNodeAndAncestors(actual1);
                String yyi = xt.getString(exj);
                String indexI = xxi;
                String indexJ = yyi;
                if (indexI == indexJ || (temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) == null) continue;
                upsumR += Math.sqrt(this.getSquaredDistanceH(exi, this.m_Weights) * this.getSquaredDistanceH(exj, this.m_Weights));
            }
            downsumR += this.getSquaredDistanceH(exi, this.m_Weights);
        }
        avgikR = upsumR != 0.0 && downsumR != 0.0 ? upsumR / downsumR : 1.0;
        double I = 1.0 + (IL + avgikR * (double)(N - M)) / (double)this.m_data.getNbRows();
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return I;
    }

    @Override
    public double calcGtotalD(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_data.getSchema();
        ClusAttrType xt = schema.getAllAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
        double avgik = 0.0;
        double W = 0.0;
        double upsum = 0.0;
        double downsum = 0.0;
        double upsumR = 0.0;
        double downsumR = 0.0;
        int M = 0;
        int N = this.m_data.getNbRows();
        if (this.splitIndex > 0) {
            N = this.splitIndex;
        } else {
            M = -this.splitIndex;
        }
        for (int i = M; i < N; ++i) {
            DataTuple exi = this.m_data.getTuple(permutation[i]);
            String xxi = xt.getString(exi);
            boolean[] actual = new boolean[this.m_Hier.getTotal()];
            ClassesTuple tp = (ClassesTuple)exi.getObjVal(this.m_Hier.getType().getArrayIndex());
            tp.fillBoolArrayNodeAndAncestors(actual);
            for (int j = M; j < N; ++j) {
                DataTuple exj = this.m_data.getTuple(permutation[j]);
                boolean[] actual1 = new boolean[this.m_Hier.getTotal()];
                ClassesTuple tp1 = (ClassesTuple)exj.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp1.fillBoolArrayNodeAndAncestors(actual1);
                String yyi = xt.getString(exj);
                double w = 0.0;
                String indexI = xxi;
                String indexJ = yyi;
                if (indexI != indexJ) {
                    String indexMap = indexI + "#" + indexJ;
                    Double temp = GISHeuristic.m_distancesS.get(indexMap);
                    w = temp != null ? temp : 0.0;
                    upsum += w * this.calcDistance(tp, tp1);
                    W += w;
                    continue;
                }
                upsum += this.calcDistance(tp, tp);
                W += 1.0;
            }
            downsum += this.getSquaredDistanceH(exi, this.m_Weights);
        }
        double num = ((double)(N - M) - 1.0) * upsum;
        double den = 2.0 * W * downsum;
        avgik = num != 0.0 && den != 0.0 ? num / den : 0.0;
        double IL = avgik * (double)(N - M);
        N = this.m_data.getNbRows();
        M = this.splitIndex;
        double avgikR = 0.0;
        double WR = 0.0;
        for (int i = M; i < N; ++i) {
            DataTuple exi = this.m_data.getTuple(permutation[i]);
            String xxi = xt.getString(exi);
            boolean[] actual = new boolean[this.m_Hier.getTotal()];
            ClassesTuple tp = (ClassesTuple)exi.getObjVal(this.m_Hier.getType().getArrayIndex());
            tp.fillBoolArrayNodeAndAncestors(actual);
            for (int j = M; j < N; ++j) {
                DataTuple exj = this.m_data.getTuple(permutation[j]);
                boolean[] actual1 = new boolean[this.m_Hier.getTotal()];
                ClassesTuple tp1 = (ClassesTuple)exj.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp1.fillBoolArrayNodeAndAncestors(actual1);
                String yyi = xt.getString(exj);
                double w = 0.0;
                String indexI = xxi;
                String indexJ = yyi;
                if (indexI != indexJ) {
                    String indexMap = indexI + "#" + indexJ;
                    Double temp = GISHeuristic.m_distancesS.get(indexMap);
                    w = temp != null ? temp : 0.0;
                    upsumR += w * this.calcDistance(tp, tp1);
                    WR += w;
                    continue;
                }
                upsumR += this.calcDistance(tp, tp);
                WR += 1.0;
            }
            downsumR += this.getSquaredDistanceH(exi, this.m_Weights);
        }
        num = ((double)(N - M) - 1.0) * upsumR;
        den = 2.0 * WR * downsumR;
        avgikR = num != 0.0 && den != 0.0 ? num / den : 0.0;
        double scaledI = 1.0 + (IL + avgikR * (double)(N - M)) / (double)this.m_data.getNbRows();
        if (Double.isNaN(scaledI)) {
            throw new ClusException("err!");
        }
        return scaledI;
    }

    @Override
    public double calcEquvalentIDistance(Integer[] permutation) throws ClusException {
        boolean[] actual;
        String xxi;
        DataTuple exi;
        Double temp;
        String indexMap;
        String indexJ;
        String indexI;
        String yyi;
        ClassesTuple tp1;
        boolean[] actual1;
        ClassesTuple tp;
        boolean[] actual2;
        String xxi2;
        int i;
        ClusSchema schema = this.m_data.getSchema();
        ClusAttrType xt = schema.getAllAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
        int M = 0;
        int N = 0;
        int NR = this.m_data.getNbRows();
        double I = 0.0;
        double ikkR = 0.0;
        int vkupenBrojElementiVoOvojSplit = N - M;
        int vkupenBrojElementiVoCelataSuma = NR;
        M = this.prevIndex;
        N = this.splitIndex;
        if (INITIALIZEPARTIALSUM) {
            INITIALIZEPARTIALSUM = false;
            for (int i2 = M = 0; i2 < NR; ++i2) {
                DataTuple exi2 = this.m_data.getTuple(permutation[i2]);
                String xxi3 = xt.getString(exi2);
                boolean[] actual3 = new boolean[this.m_Hier.getTotal()];
                ClassesTuple tp2 = (ClassesTuple)exi2.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp2.fillBoolArrayNodeAndAncestors(actual3);
                this.previousSumX2R[0] = this.previousSumX2R[0] + this.getSquaredDistanceH(exi2, this.m_Weights);
                this.previousSumXR[0] = this.previousSumXR[0] + Math.sqrt(this.getSquaredDistanceH(exi2, this.m_Weights));
                for (int j = M; j < NR; ++j) {
                    DataTuple exj = this.m_data.getTuple(permutation[j]);
                    boolean[] actual12 = new boolean[this.m_Hier.getTotal()];
                    ClassesTuple tp12 = (ClassesTuple)exj.getObjVal(this.m_Hier.getType().getArrayIndex());
                    tp12.fillBoolArrayNodeAndAncestors(actual12);
                    String yyi2 = xt.getString(exj);
                    double w = 0.0;
                    String indexI2 = xxi3;
                    String indexJ2 = yyi2;
                    if (indexI2 != indexJ2) {
                        String indexMap2 = indexI2 + "#" + indexJ2;
                        Double temp2 = GISHeuristic.m_distancesS.get(indexMap2);
                        w = temp2 != null ? temp2 : 0.0;
                        this.previousSumWR[0] = this.previousSumWR[0] + w;
                        this.previousSumWXXR[0] = this.previousSumWXXR[0] + w * Math.sqrt(this.getSquaredDistanceH(exi2, this.m_Weights) * this.getSquaredDistanceH(exj, this.m_Weights));
                        continue;
                    }
                    this.previousSumWR[0] = this.previousSumWR[0] + 1.0;
                    this.previousSumWXXR[0] = this.previousSumWXXR[0] + this.getSquaredDistanceH(exi2, this.m_Weights);
                }
            }
        }
        boolean flagRightAllEqual = true;
        boolean flagLeftAllEqual = true;
        for (int i3 = M; i3 < N; ++i3) {
            DataTuple exi3 = this.m_data.getTuple(permutation[i3]);
            boolean[] actual4 = new boolean[this.m_Hier.getTotal()];
            ClassesTuple tp3 = (ClassesTuple)exi3.getObjVal(this.m_Hier.getType().getArrayIndex());
            tp3.fillBoolArrayNodeAndAncestors(actual4);
            this.previousSumX2[0] = this.previousSumX2[0] + this.getSquaredDistanceH(exi3, this.m_Weights);
            this.previousSumX[0] = this.previousSumX[0] + Math.sqrt(this.getSquaredDistanceH(exi3, this.m_Weights));
            this.previousSumX2R[0] = this.previousSumX2R[0] - this.getSquaredDistanceH(exi3, this.m_Weights);
            this.previousSumXR[0] = this.previousSumXR[0] - Math.sqrt(this.getSquaredDistanceH(exi3, this.m_Weights));
        }
        flagLeftAllEqual = true;
        double oldX = Math.sqrt(this.getSquaredDistanceH(this.m_data.getTuple(0), this.m_Weights));
        for (i = 1; i < N; ++i) {
            DataTuple exi4 = this.m_data.getTuple(permutation[i]);
            boolean[] actual5 = new boolean[this.m_Hier.getTotal()];
            ClassesTuple tp4 = (ClassesTuple)exi4.getObjVal(this.m_Hier.getType().getArrayIndex());
            tp4.fillBoolArrayNodeAndAncestors(actual5);
            if (Math.sqrt(this.getSquaredDistanceH(exi4, this.m_Weights)) == oldX) continue;
            flagLeftAllEqual = false;
            break;
        }
        for (i = 0; i < M; ++i) {
            DataTuple exi5 = this.m_data.getTuple(permutation[i]);
            xxi2 = xt.getString(exi5);
            actual2 = new boolean[this.m_Hier.getTotal()];
            tp = (ClassesTuple)exi5.getObjVal(this.m_Hier.getType().getArrayIndex());
            tp.fillBoolArrayNodeAndAncestors(actual2);
            for (int j = M; j < N; ++j) {
                DataTuple exj = this.m_data.getTuple(permutation[j]);
                actual1 = new boolean[this.m_Hier.getTotal()];
                tp1 = (ClassesTuple)exj.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp1.fillBoolArrayNodeAndAncestors(actual1);
                yyi = xt.getString(exj);
                double w = 0.0;
                indexI = xxi2;
                indexJ = yyi;
                if (indexI != indexJ) {
                    indexMap = indexI + "#" + indexJ;
                    temp = GISHeuristic.m_distancesS.get(indexMap);
                    w = temp != null ? temp : 0.0;
                    this.previousSumW[0] = this.previousSumW[0] + w;
                    this.previousSumWXX[0] = this.previousSumWXX[0] + w * Math.sqrt(this.getSquaredDistanceH(exi5, this.m_Weights) * this.getSquaredDistanceH(exj, this.m_Weights));
                    continue;
                }
                this.previousSumW[0] = this.previousSumW[0] + 1.0;
                this.previousSumWXX[0] = this.previousSumWXX[0] + Math.sqrt(this.getSquaredDistanceH(exi5, this.m_Weights) * this.getSquaredDistanceH(exj, this.m_Weights));
            }
        }
        for (i = M; i < N; ++i) {
            for (int j = 0; j < M; ++j) {
                exi = this.m_data.getTuple(permutation[i]);
                xxi = xt.getString(exi);
                actual = new boolean[this.m_Hier.getTotal()];
                ClassesTuple tp5 = (ClassesTuple)exi.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp5.fillBoolArrayNodeAndAncestors(actual);
                DataTuple exj = this.m_data.getTuple(permutation[j]);
                actual1 = new boolean[this.m_Hier.getTotal()];
                tp1 = (ClassesTuple)exj.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp1.fillBoolArrayNodeAndAncestors(actual1);
                yyi = xt.getString(exj);
                double w = 0.0;
                indexI = xxi;
                indexJ = yyi;
                if (indexI != indexJ) {
                    indexMap = indexI + "#" + indexJ;
                    temp = GISHeuristic.m_distancesS.get(indexMap);
                    w = temp != null ? temp : 0.0;
                    this.previousSumW[0] = this.previousSumW[0] + w;
                    this.previousSumWXX[0] = this.previousSumWXX[0] + w * Math.sqrt(this.getSquaredDistanceH(exi, this.m_Weights) * this.getSquaredDistanceH(exj, this.m_Weights));
                    continue;
                }
                this.previousSumW[0] = this.previousSumW[0] + 1.0;
                this.previousSumWXX[0] = this.previousSumWXX[0] + Math.sqrt(this.getSquaredDistanceH(exi, this.m_Weights) * this.getSquaredDistanceH(exj, this.m_Weights));
            }
        }
        for (i = M; i < N; ++i) {
            for (int j = M; j < N; ++j) {
                exi = this.m_data.getTuple(permutation[i]);
                xxi = xt.getString(exi);
                actual = new boolean[this.m_Hier.getTotal()];
                ClassesTuple tp6 = (ClassesTuple)exi.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp6.fillBoolArrayNodeAndAncestors(actual);
                DataTuple exj = this.m_data.getTuple(permutation[j]);
                actual1 = new boolean[this.m_Hier.getTotal()];
                tp1 = (ClassesTuple)exj.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp1.fillBoolArrayNodeAndAncestors(actual1);
                yyi = xt.getString(exj);
                double w = 0.0;
                indexI = xxi;
                indexJ = yyi;
                if (indexI != indexJ) {
                    indexMap = indexI + "#" + indexJ;
                    temp = GISHeuristic.m_distancesS.get(indexMap);
                    w = temp != null ? temp : 0.0;
                    this.previousSumW[0] = this.previousSumW[0] + w;
                    this.previousSumWXX[0] = this.previousSumWXX[0] + w * Math.sqrt(this.getSquaredDistanceH(exi, this.m_Weights) * this.getSquaredDistanceH(exj, this.m_Weights));
                    continue;
                }
                this.previousSumW[0] = this.previousSumW[0] + 1.0;
                this.previousSumWXX[0] = this.previousSumWXX[0] + Math.sqrt(this.getSquaredDistanceH(exi, this.m_Weights) * this.getSquaredDistanceH(exj, this.m_Weights));
            }
        }
        flagRightAllEqual = true;
        oldX = Math.sqrt(this.getSquaredDistanceH(this.m_data.getTuple(N), this.m_Weights));
        for (i = N; i < NR; ++i) {
            DataTuple exi6 = this.m_data.getTuple(permutation[i]);
            xxi2 = xt.getString(exi6);
            actual2 = new boolean[this.m_Hier.getTotal()];
            tp = (ClassesTuple)exi6.getObjVal(this.m_Hier.getType().getArrayIndex());
            tp.fillBoolArrayNodeAndAncestors(actual2);
            if (oldX != Math.sqrt(this.getSquaredDistanceH(exi6, this.m_Weights))) {
                flagRightAllEqual = false;
            }
            for (int j = M; j < N; ++j) {
                double w = 0.0;
                DataTuple exj = this.m_data.getTuple(permutation[j]);
                boolean[] actual13 = new boolean[this.m_Hier.getTotal()];
                ClassesTuple tp13 = (ClassesTuple)exj.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp13.fillBoolArrayNodeAndAncestors(actual13);
                String yyi3 = xt.getString(exj);
                if (Math.sqrt(this.getSquaredDistanceH(exi6, this.m_Weights)) != oldX) {
                    flagRightAllEqual = false;
                }
                if ((indexI = xxi2) != (indexJ = yyi3)) {
                    indexMap = indexI + "#" + indexJ;
                    temp = GISHeuristic.m_distancesS.get(indexMap);
                    w = temp != null ? temp : 0.0;
                    this.previousSumWR[0] = this.previousSumWR[0] - w;
                    this.previousSumWXXR[0] = this.previousSumWXXR[0] - w * Math.sqrt(this.getSquaredDistanceH(exi6, this.m_Weights) * this.getSquaredDistanceH(exj, this.m_Weights));
                    continue;
                }
                this.previousSumWR[0] = this.previousSumWR[0] - 1.0;
                this.previousSumWXXR[0] = this.previousSumWXXR[0] - Math.sqrt(this.getSquaredDistanceH(exi6, this.m_Weights) * this.getSquaredDistanceH(exj, this.m_Weights));
            }
        }
        for (i = M; i < N; ++i) {
            for (int j = N; j < NR; ++j) {
                exi = this.m_data.getTuple(permutation[i]);
                xxi = xt.getString(exi);
                actual = new boolean[this.m_Hier.getTotal()];
                ClassesTuple tp7 = (ClassesTuple)exi.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp7.fillBoolArrayNodeAndAncestors(actual);
                DataTuple exj = this.m_data.getTuple(permutation[j]);
                actual1 = new boolean[this.m_Hier.getTotal()];
                tp1 = (ClassesTuple)exj.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp1.fillBoolArrayNodeAndAncestors(actual1);
                yyi = xt.getString(exj);
                double w = 0.0;
                indexI = xxi;
                indexJ = yyi;
                if (indexI != indexJ) {
                    indexMap = indexI + "#" + indexJ;
                    temp = GISHeuristic.m_distancesS.get(indexMap);
                    w = temp != null ? temp : 0.0;
                    this.previousSumWR[0] = this.previousSumWR[0] - w;
                    this.previousSumWXXR[0] = this.previousSumWXXR[0] - w * Math.sqrt(this.getSquaredDistanceH(exi, this.m_Weights) * this.getSquaredDistanceH(exj, this.m_Weights));
                    continue;
                }
                this.previousSumWR[0] = this.previousSumWR[0] - 1.0;
                this.previousSumWXXR[0] = this.previousSumWXXR[0] - Math.sqrt(this.getSquaredDistanceH(exi, this.m_Weights) * this.getSquaredDistanceH(exj, this.m_Weights));
            }
        }
        for (i = M; i < N; ++i) {
            DataTuple exi7 = this.m_data.getTuple(permutation[i]);
            xxi2 = xt.getString(exi7);
            actual2 = new boolean[this.m_Hier.getTotal()];
            tp = (ClassesTuple)exi7.getObjVal(this.m_Hier.getType().getArrayIndex());
            tp.fillBoolArrayNodeAndAncestors(actual2);
            for (int j = M; j < N; ++j) {
                DataTuple exj = this.m_data.getTuple(permutation[j]);
                actual1 = new boolean[this.m_Hier.getTotal()];
                tp1 = (ClassesTuple)exj.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp1.fillBoolArrayNodeAndAncestors(actual1);
                yyi = xt.getString(exj);
                double w = 0.0;
                indexI = xxi2;
                indexJ = yyi;
                if (indexI != indexJ) {
                    indexMap = indexI + "#" + indexJ;
                    temp = GISHeuristic.m_distancesS.get(indexMap);
                    w = temp != null ? temp : 0.0;
                    this.previousSumWR[0] = this.previousSumWR[0] - w;
                    this.previousSumWXXR[0] = this.previousSumWXXR[0] - w * Math.sqrt(this.getSquaredDistanceH(exi7, this.m_Weights) * this.getSquaredDistanceH(exj, this.m_Weights));
                    continue;
                }
                this.previousSumWR[0] = this.previousSumWR[0] - 1.0;
                this.previousSumWXXR[0] = this.previousSumWXXR[0] - Math.sqrt(this.getSquaredDistanceH(exi7, this.m_Weights) * this.getSquaredDistanceH(exj, this.m_Weights));
            }
        }
        vkupenBrojElementiVoOvojSplit = N;
        double num = (double)vkupenBrojElementiVoOvojSplit * this.previousSumWXX[0];
        double den = this.previousSumW[0] * this.previousSumX2[0];
        double ikk = den != 0.0 && num != 0.0 && !flagLeftAllEqual ? num / den : 1.0;
        vkupenBrojElementiVoOvojSplit = NR - N;
        double numR = (double)vkupenBrojElementiVoOvojSplit * this.previousSumWXXR[0];
        double denR = this.previousSumWR[0] * this.previousSumX2R[0];
        ikkR = denR != 0.0 && numR != 0.0 && !flagRightAllEqual ? numR / denR : 1.0;
        I = (ikk * (double)N + ikkR * (double)(NR - N)) / (double)vkupenBrojElementiVoCelataSuma;
        M = this.prevIndex;
        N = this.splitIndex;
        double scaledI = 1.0 + I;
        if (Double.isNaN(scaledI)) {
            throw new ClusException("err!");
        }
        return scaledI;
    }

    @Override
    public double calcEquvalentPDistance(Integer[] permutation) throws ClusException {
        boolean[] actual;
        String xxi;
        DataTuple exi;
        String indexMap;
        Double temp;
        String indexJ;
        String indexI;
        String yyi;
        ClassesTuple tp1;
        boolean[] actual1;
        DataTuple exj;
        ClassesTuple tp;
        boolean[] actual2;
        String xxi2;
        int i;
        int NR;
        ClusSchema schema = this.m_data.getSchema();
        ClusAttrType xt = schema.getAllAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
        int M = 0;
        int N = 0;
        int vkupenBrojElementiVoCelataSuma = NR = this.m_data.getNbRows();
        double I = 0.0;
        double ikkR = 0.0;
        M = this.prevIndex;
        N = this.splitIndex;
        if (INITIALIZEPARTIALSUM) {
            INITIALIZEPARTIALSUM = false;
            for (int i2 = M = 0; i2 < NR; ++i2) {
                DataTuple exi2 = this.m_data.getTuple(permutation[i2]);
                String xxi3 = xt.getString(exi2);
                boolean[] actual3 = new boolean[this.m_Hier.getTotal()];
                ClassesTuple tp2 = (ClassesTuple)exi2.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp2.fillBoolArrayNodeAndAncestors(actual3);
                this.previousSumX2R[0] = this.previousSumX2R[0] + this.getSquaredDistanceH(exi2, this.m_Weights);
                this.previousSumXR[0] = this.previousSumXR[0] + Math.sqrt(this.getSquaredDistanceH(exi2, this.m_Weights));
                for (int j = M; j < NR; ++j) {
                    String indexMap2;
                    Double temp2;
                    DataTuple exj2 = this.m_data.getTuple(permutation[j]);
                    boolean[] actual12 = new boolean[this.m_Hier.getTotal()];
                    ClassesTuple tp12 = (ClassesTuple)exj2.getObjVal(this.m_Hier.getType().getArrayIndex());
                    tp12.fillBoolArrayNodeAndAncestors(actual12);
                    String yyi2 = xt.getString(exj2);
                    String indexI2 = xxi3;
                    String indexJ2 = yyi2;
                    if (indexI2 == indexJ2 || (temp2 = GISHeuristic.m_distancesS.get(indexMap2 = indexI2 + "#" + indexJ2)) == null) continue;
                    this.previousSumWXXR[0] = this.previousSumWXXR[0] + Math.sqrt(this.getSquaredDistanceH(exi2, this.m_Weights) * this.getSquaredDistanceH(exj2, this.m_Weights));
                }
            }
        }
        boolean flagRightAllEqual = true;
        boolean flagLeftAllEqual = true;
        for (int i3 = M; i3 < N; ++i3) {
            DataTuple exi3 = this.m_data.getTuple(permutation[i3]);
            boolean[] actual4 = new boolean[this.m_Hier.getTotal()];
            ClassesTuple tp3 = (ClassesTuple)exi3.getObjVal(this.m_Hier.getType().getArrayIndex());
            tp3.fillBoolArrayNodeAndAncestors(actual4);
            this.previousSumX2[0] = this.previousSumX2[0] + this.getSquaredDistanceH(exi3, this.m_Weights);
            this.previousSumX[0] = this.previousSumX[0] + Math.sqrt(this.getSquaredDistanceH(exi3, this.m_Weights));
            this.previousSumX2R[0] = this.previousSumX2R[0] - this.getSquaredDistanceH(exi3, this.m_Weights);
            this.previousSumXR[0] = this.previousSumXR[0] - Math.sqrt(this.getSquaredDistanceH(exi3, this.m_Weights));
        }
        flagLeftAllEqual = true;
        double oldX = Math.sqrt(this.getSquaredDistanceH(this.m_data.getTuple(0), this.m_Weights));
        for (i = 1; i < N; ++i) {
            DataTuple exi4 = this.m_data.getTuple(permutation[i]);
            boolean[] actual5 = new boolean[this.m_Hier.getTotal()];
            ClassesTuple tp4 = (ClassesTuple)exi4.getObjVal(this.m_Hier.getType().getArrayIndex());
            tp4.fillBoolArrayNodeAndAncestors(actual5);
            if (Math.sqrt(this.getSquaredDistanceH(exi4, this.m_Weights)) == oldX) continue;
            flagLeftAllEqual = false;
            break;
        }
        for (i = 0; i < M; ++i) {
            DataTuple exi5 = this.m_data.getTuple(permutation[i]);
            xxi2 = xt.getString(exi5);
            actual2 = new boolean[this.m_Hier.getTotal()];
            tp = (ClassesTuple)exi5.getObjVal(this.m_Hier.getType().getArrayIndex());
            tp.fillBoolArrayNodeAndAncestors(actual2);
            for (int j = M; j < N; ++j) {
                exj = this.m_data.getTuple(permutation[j]);
                actual1 = new boolean[this.m_Hier.getTotal()];
                tp1 = (ClassesTuple)exj.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp1.fillBoolArrayNodeAndAncestors(actual1);
                yyi = xt.getString(exj);
                indexI = xxi2;
                indexJ = yyi;
                if (indexI == indexJ || (temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) == null) continue;
                this.previousSumWXX[0] = this.previousSumWXX[0] + Math.sqrt(this.getSquaredDistanceH(exi5, this.m_Weights) * this.getSquaredDistanceH(exj, this.m_Weights));
            }
        }
        for (i = M; i < N; ++i) {
            for (int j = 0; j < M; ++j) {
                exi = this.m_data.getTuple(permutation[i]);
                xxi = xt.getString(exi);
                actual = new boolean[this.m_Hier.getTotal()];
                ClassesTuple tp5 = (ClassesTuple)exi.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp5.fillBoolArrayNodeAndAncestors(actual);
                exj = this.m_data.getTuple(permutation[j]);
                actual1 = new boolean[this.m_Hier.getTotal()];
                tp1 = (ClassesTuple)exj.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp1.fillBoolArrayNodeAndAncestors(actual1);
                yyi = xt.getString(exj);
                indexI = xxi;
                indexJ = yyi;
                if (indexI == indexJ || (temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) == null) continue;
                this.previousSumWXX[0] = this.previousSumWXX[0] + Math.sqrt(this.getSquaredDistanceH(exi, this.m_Weights) * this.getSquaredDistanceH(exj, this.m_Weights));
            }
        }
        for (i = M; i < N; ++i) {
            for (int j = M; j < N; ++j) {
                exi = this.m_data.getTuple(permutation[i]);
                xxi = xt.getString(exi);
                actual = new boolean[this.m_Hier.getTotal()];
                ClassesTuple tp6 = (ClassesTuple)exi.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp6.fillBoolArrayNodeAndAncestors(actual);
                exj = this.m_data.getTuple(permutation[j]);
                actual1 = new boolean[this.m_Hier.getTotal()];
                tp1 = (ClassesTuple)exj.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp1.fillBoolArrayNodeAndAncestors(actual1);
                yyi = xt.getString(exj);
                indexI = xxi;
                indexJ = yyi;
                if (indexI == indexJ || (temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) == null) continue;
                this.previousSumWXX[0] = this.previousSumWXX[0] + Math.sqrt(this.getSquaredDistanceH(exi, this.m_Weights) * this.getSquaredDistanceH(exj, this.m_Weights));
            }
        }
        flagRightAllEqual = true;
        oldX = Math.sqrt(this.getSquaredDistanceH(this.m_data.getTuple(N), this.m_Weights));
        for (i = N; i < NR; ++i) {
            DataTuple exi6 = this.m_data.getTuple(permutation[i]);
            xxi2 = xt.getString(exi6);
            actual2 = new boolean[this.m_Hier.getTotal()];
            tp = (ClassesTuple)exi6.getObjVal(this.m_Hier.getType().getArrayIndex());
            tp.fillBoolArrayNodeAndAncestors(actual2);
            if (oldX != Math.sqrt(this.getSquaredDistanceH(exi6, this.m_Weights))) {
                flagRightAllEqual = false;
            }
            for (int j = M; j < N; ++j) {
                exj = this.m_data.getTuple(permutation[j]);
                actual1 = new boolean[this.m_Hier.getTotal()];
                tp1 = (ClassesTuple)exj.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp1.fillBoolArrayNodeAndAncestors(actual1);
                yyi = xt.getString(exj);
                if (Math.sqrt(this.getSquaredDistanceH(exi6, this.m_Weights)) != oldX) {
                    flagRightAllEqual = false;
                }
                if ((indexI = xxi2) == (indexJ = yyi) || (temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) == null) continue;
                this.previousSumWXXR[0] = this.previousSumWXXR[0] - Math.sqrt(this.getSquaredDistanceH(exi6, this.m_Weights) * this.getSquaredDistanceH(exj, this.m_Weights));
            }
        }
        for (i = M; i < N; ++i) {
            for (int j = N; j < NR; ++j) {
                exi = this.m_data.getTuple(permutation[i]);
                xxi = xt.getString(exi);
                actual = new boolean[this.m_Hier.getTotal()];
                ClassesTuple tp7 = (ClassesTuple)exi.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp7.fillBoolArrayNodeAndAncestors(actual);
                exj = this.m_data.getTuple(permutation[j]);
                actual1 = new boolean[this.m_Hier.getTotal()];
                tp1 = (ClassesTuple)exj.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp1.fillBoolArrayNodeAndAncestors(actual1);
                yyi = xt.getString(exj);
                indexI = xxi;
                indexJ = yyi;
                if (indexI == indexJ || (temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) == null) continue;
                this.previousSumWXXR[0] = this.previousSumWXXR[0] - Math.sqrt(this.getSquaredDistanceH(exi, this.m_Weights) * this.getSquaredDistanceH(exj, this.m_Weights));
            }
        }
        for (i = M; i < N; ++i) {
            DataTuple exi7 = this.m_data.getTuple(permutation[i]);
            xxi2 = xt.getString(exi7);
            actual2 = new boolean[this.m_Hier.getTotal()];
            tp = (ClassesTuple)exi7.getObjVal(this.m_Hier.getType().getArrayIndex());
            tp.fillBoolArrayNodeAndAncestors(actual2);
            for (int j = M; j < N; ++j) {
                exj = this.m_data.getTuple(permutation[j]);
                actual1 = new boolean[this.m_Hier.getTotal()];
                tp1 = (ClassesTuple)exj.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp1.fillBoolArrayNodeAndAncestors(actual1);
                yyi = xt.getString(exj);
                indexI = xxi2;
                indexJ = yyi;
                if (indexI == indexJ || (temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) == null) continue;
                this.previousSumWXXR[0] = this.previousSumWXXR[0] - Math.sqrt(this.getSquaredDistanceH(exi7, this.m_Weights) * this.getSquaredDistanceH(exj, this.m_Weights));
            }
        }
        double ikk = this.previousSumX2[0] != 0.0 && this.previousSumWXX[0] != 0.0 && !flagLeftAllEqual ? this.previousSumWXX[0] / this.previousSumX2[0] : 1.0;
        ikkR = this.previousSumX2R[0] != 0.0 && this.previousSumWXXR[0] != 0.0 && !flagRightAllEqual ? this.previousSumWXXR[0] / this.previousSumX2R[0] : 1.0;
        I = (ikk * (double)N + ikkR * (double)(NR - N)) / (double)vkupenBrojElementiVoCelataSuma;
        M = this.prevIndex;
        N = this.splitIndex;
        double scaledI = 1.0 + I;
        if (Double.isNaN(scaledI)) {
            throw new ClusException("err!");
        }
        return scaledI;
    }

    @Override
    public double calcEquvalentGDistance(Integer[] permutation) throws ClusException {
        boolean[] actual;
        String xxi;
        DataTuple exi;
        Double temp;
        String indexMap;
        String indexJ;
        String indexI;
        String yyi;
        ClassesTuple tp1;
        boolean[] actual1;
        ClassesTuple tp;
        boolean[] actual2;
        String xxi2;
        int i;
        ClusSchema schema = this.m_data.getSchema();
        ClusAttrType xt = schema.getAllAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
        int M = 0;
        int N = 0;
        int NR = this.m_data.getNbRows();
        double I = 0.0;
        double avgik = 0.0;
        double avgikR = 0.0;
        int vkupenBrojElementiVoOvojSplit = N - M;
        int vkupenBrojElementiVoCelataSuma = NR;
        M = this.prevIndex;
        N = this.splitIndex;
        if (INITIALIZEPARTIALSUM) {
            INITIALIZEPARTIALSUM = false;
            for (int i2 = M = 0; i2 < NR; ++i2) {
                DataTuple exi2 = this.m_data.getTuple(permutation[i2]);
                String xxi3 = xt.getString(exi2);
                boolean[] actual3 = new boolean[this.m_Hier.getTotal()];
                ClassesTuple tp2 = (ClassesTuple)exi2.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp2.fillBoolArrayNodeAndAncestors(actual3);
                this.previousSumX2R[0] = this.previousSumX2R[0] + this.getSquaredDistanceH(exi2, this.m_Weights);
                this.previousSumXR[0] = this.previousSumXR[0] + Math.sqrt(this.getSquaredDistanceH(exi2, this.m_Weights));
                for (int j = M; j < NR; ++j) {
                    DataTuple exj = this.m_data.getTuple(permutation[j]);
                    boolean[] actual12 = new boolean[this.m_Hier.getTotal()];
                    ClassesTuple tp12 = (ClassesTuple)exj.getObjVal(this.m_Hier.getType().getArrayIndex());
                    tp12.fillBoolArrayNodeAndAncestors(actual12);
                    String yyi2 = xt.getString(exj);
                    double w = 0.0;
                    String indexI2 = xxi3;
                    String indexJ2 = yyi2;
                    if (indexI2 != indexJ2) {
                        String indexMap2 = indexI2 + "#" + indexJ2;
                        Double temp2 = GISHeuristic.m_distancesS.get(indexMap2);
                        w = temp2 != null ? temp2 : 0.0;
                        this.previousSumWR[0] = this.previousSumWR[0] + w;
                        this.previousSumWXXR[0] = this.previousSumWXXR[0] + w * this.calcDistance(tp2, tp12);
                        continue;
                    }
                    this.previousSumWR[0] = this.previousSumWR[0] + 1.0;
                    this.previousSumWXXR[0] = this.previousSumWXXR[0] + this.calcDistance(tp2, tp2);
                }
            }
        }
        boolean flagRightAllEqual = true;
        boolean flagLeftAllEqual = true;
        for (int i3 = M; i3 < N; ++i3) {
            DataTuple exi3 = this.m_data.getTuple(permutation[i3]);
            boolean[] actual4 = new boolean[this.m_Hier.getTotal()];
            ClassesTuple tp3 = (ClassesTuple)exi3.getObjVal(this.m_Hier.getType().getArrayIndex());
            tp3.fillBoolArrayNodeAndAncestors(actual4);
            this.previousSumX2[0] = this.previousSumX2[0] + this.getSquaredDistanceH(exi3, this.m_Weights);
            this.previousSumX[0] = this.previousSumX[0] + Math.sqrt(this.getSquaredDistanceH(exi3, this.m_Weights));
            this.previousSumX2R[0] = this.previousSumX2R[0] - this.getSquaredDistanceH(exi3, this.m_Weights);
            this.previousSumXR[0] = this.previousSumXR[0] - Math.sqrt(this.getSquaredDistanceH(exi3, this.m_Weights));
        }
        flagLeftAllEqual = true;
        double oldX = Math.sqrt(this.getSquaredDistanceH(this.m_data.getTuple(0), this.m_Weights));
        for (i = 1; i < N; ++i) {
            DataTuple exi4 = this.m_data.getTuple(permutation[i]);
            boolean[] actual5 = new boolean[this.m_Hier.getTotal()];
            ClassesTuple tp4 = (ClassesTuple)exi4.getObjVal(this.m_Hier.getType().getArrayIndex());
            tp4.fillBoolArrayNodeAndAncestors(actual5);
            if (Math.sqrt(this.getSquaredDistanceH(exi4, this.m_Weights)) == oldX) continue;
            flagLeftAllEqual = false;
            break;
        }
        for (i = 0; i < M; ++i) {
            DataTuple exi5 = this.m_data.getTuple(permutation[i]);
            xxi2 = xt.getString(exi5);
            actual2 = new boolean[this.m_Hier.getTotal()];
            tp = (ClassesTuple)exi5.getObjVal(this.m_Hier.getType().getArrayIndex());
            tp.fillBoolArrayNodeAndAncestors(actual2);
            for (int j = M; j < N; ++j) {
                DataTuple exj = this.m_data.getTuple(permutation[j]);
                actual1 = new boolean[this.m_Hier.getTotal()];
                tp1 = (ClassesTuple)exj.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp1.fillBoolArrayNodeAndAncestors(actual1);
                yyi = xt.getString(exj);
                double w = 0.0;
                indexI = xxi2;
                indexJ = yyi;
                if (indexI != indexJ) {
                    indexMap = indexI + "#" + indexJ;
                    temp = GISHeuristic.m_distancesS.get(indexMap);
                    w = temp != null ? temp : 0.0;
                    this.previousSumW[0] = this.previousSumW[0] + w;
                    this.previousSumWXX[0] = this.previousSumWXX[0] + w * this.calcDistance(tp, tp1);
                    continue;
                }
                this.previousSumW[0] = this.previousSumW[0] + 1.0;
                this.previousSumWXX[0] = this.previousSumWXX[0] + this.calcDistance(tp, tp);
            }
        }
        for (i = M; i < N; ++i) {
            for (int j = 0; j < M; ++j) {
                exi = this.m_data.getTuple(permutation[i]);
                xxi = xt.getString(exi);
                actual = new boolean[this.m_Hier.getTotal()];
                ClassesTuple tp5 = (ClassesTuple)exi.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp5.fillBoolArrayNodeAndAncestors(actual);
                DataTuple exj = this.m_data.getTuple(permutation[j]);
                actual1 = new boolean[this.m_Hier.getTotal()];
                tp1 = (ClassesTuple)exj.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp1.fillBoolArrayNodeAndAncestors(actual1);
                yyi = xt.getString(exj);
                double w = 0.0;
                indexI = xxi;
                indexJ = yyi;
                if (indexI != indexJ) {
                    indexMap = indexI + "#" + indexJ;
                    temp = GISHeuristic.m_distancesS.get(indexMap);
                    w = temp != null ? temp : 0.0;
                    this.previousSumW[0] = this.previousSumW[0] + w;
                    this.previousSumWXX[0] = this.previousSumWXX[0] + w * this.calcDistance(tp5, tp1);
                    continue;
                }
                this.previousSumW[0] = this.previousSumW[0] + 1.0;
                this.previousSumWXX[0] = this.previousSumWXX[0] + this.calcDistance(tp5, tp5);
            }
        }
        for (i = M; i < N; ++i) {
            for (int j = M; j < N; ++j) {
                exi = this.m_data.getTuple(permutation[i]);
                xxi = xt.getString(exi);
                actual = new boolean[this.m_Hier.getTotal()];
                ClassesTuple tp6 = (ClassesTuple)exi.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp6.fillBoolArrayNodeAndAncestors(actual);
                DataTuple exj = this.m_data.getTuple(permutation[j]);
                actual1 = new boolean[this.m_Hier.getTotal()];
                tp1 = (ClassesTuple)exj.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp1.fillBoolArrayNodeAndAncestors(actual1);
                yyi = xt.getString(exj);
                double w = 0.0;
                indexI = xxi;
                indexJ = yyi;
                if (indexI != indexJ) {
                    indexMap = indexI + "#" + indexJ;
                    temp = GISHeuristic.m_distancesS.get(indexMap);
                    w = temp != null ? temp : 0.0;
                    this.previousSumW[0] = this.previousSumW[0] + w;
                    this.previousSumWXX[0] = this.previousSumWXX[0] + w * this.calcDistance(tp6, tp1);
                    continue;
                }
                this.previousSumW[0] = this.previousSumW[0] + 1.0;
                this.previousSumWXX[0] = this.previousSumWXX[0] + this.calcDistance(tp6, tp6);
            }
        }
        flagRightAllEqual = true;
        oldX = Math.sqrt(this.getSquaredDistanceH(this.m_data.getTuple(N), this.m_Weights));
        for (i = N; i < NR; ++i) {
            DataTuple exi6 = this.m_data.getTuple(permutation[i]);
            xxi2 = xt.getString(exi6);
            actual2 = new boolean[this.m_Hier.getTotal()];
            tp = (ClassesTuple)exi6.getObjVal(this.m_Hier.getType().getArrayIndex());
            tp.fillBoolArrayNodeAndAncestors(actual2);
            if (oldX != Math.sqrt(this.getSquaredDistanceH(exi6, this.m_Weights))) {
                flagRightAllEqual = false;
            }
            for (int j = M; j < N; ++j) {
                double w = 0.0;
                DataTuple exj = this.m_data.getTuple(permutation[j]);
                boolean[] actual13 = new boolean[this.m_Hier.getTotal()];
                ClassesTuple tp13 = (ClassesTuple)exj.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp13.fillBoolArrayNodeAndAncestors(actual13);
                String yyi3 = xt.getString(exj);
                if (Math.sqrt(this.getSquaredDistanceH(exi6, this.m_Weights)) != oldX) {
                    flagRightAllEqual = false;
                }
                if ((indexI = xxi2) != (indexJ = yyi3)) {
                    indexMap = indexI + "#" + indexJ;
                    temp = GISHeuristic.m_distancesS.get(indexMap);
                    w = temp != null ? temp : 0.0;
                    this.previousSumWR[0] = this.previousSumWR[0] - w;
                    this.previousSumWXXR[0] = this.previousSumWXXR[0] - w * this.calcDistance(tp, tp13);
                    continue;
                }
                this.previousSumWR[0] = this.previousSumWR[0] - 1.0;
                this.previousSumWXXR[0] = this.previousSumWXXR[0] - this.calcDistance(tp, tp);
            }
        }
        for (i = M; i < N; ++i) {
            for (int j = N; j < NR; ++j) {
                exi = this.m_data.getTuple(permutation[i]);
                xxi = xt.getString(exi);
                actual = new boolean[this.m_Hier.getTotal()];
                ClassesTuple tp7 = (ClassesTuple)exi.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp7.fillBoolArrayNodeAndAncestors(actual);
                DataTuple exj = this.m_data.getTuple(permutation[j]);
                actual1 = new boolean[this.m_Hier.getTotal()];
                tp1 = (ClassesTuple)exj.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp1.fillBoolArrayNodeAndAncestors(actual1);
                yyi = xt.getString(exj);
                double w = 0.0;
                indexI = xxi;
                indexJ = yyi;
                if (indexI != indexJ) {
                    indexMap = indexI + "#" + indexJ;
                    temp = GISHeuristic.m_distancesS.get(indexMap);
                    w = temp != null ? temp : 0.0;
                    this.previousSumWR[0] = this.previousSumWR[0] - w;
                    this.previousSumWXXR[0] = this.previousSumWXXR[0] - w * this.calcDistance(tp7, tp1);
                    continue;
                }
                this.previousSumWR[0] = this.previousSumWR[0] - 1.0;
                this.previousSumWXXR[0] = this.previousSumWXXR[0] - this.calcDistance(tp7, tp7);
            }
        }
        for (i = M; i < N; ++i) {
            DataTuple exi7 = this.m_data.getTuple(permutation[i]);
            xxi2 = xt.getString(exi7);
            actual2 = new boolean[this.m_Hier.getTotal()];
            tp = (ClassesTuple)exi7.getObjVal(this.m_Hier.getType().getArrayIndex());
            tp.fillBoolArrayNodeAndAncestors(actual2);
            for (int j = M; j < N; ++j) {
                DataTuple exj = this.m_data.getTuple(permutation[j]);
                actual1 = new boolean[this.m_Hier.getTotal()];
                tp1 = (ClassesTuple)exj.getObjVal(this.m_Hier.getType().getArrayIndex());
                tp1.fillBoolArrayNodeAndAncestors(actual1);
                yyi = xt.getString(exj);
                double w = 0.0;
                indexI = xxi2;
                indexJ = yyi;
                if (indexI != indexJ) {
                    indexMap = indexI + "#" + indexJ;
                    temp = GISHeuristic.m_distancesS.get(indexMap);
                    w = temp != null ? temp : 0.0;
                    this.previousSumWR[0] = this.previousSumWR[0] - w;
                    this.previousSumWXXR[0] = this.previousSumWXXR[0] - w * this.calcDistance(tp, tp1);
                    continue;
                }
                this.previousSumWR[0] = this.previousSumWR[0] - 1.0;
                this.previousSumWXXR[0] = this.previousSumWXXR[0] - this.calcDistance(tp, tp);
            }
        }
        vkupenBrojElementiVoOvojSplit = N;
        double num = (double)(vkupenBrojElementiVoOvojSplit - 1) * this.previousSumWXX[0];
        double den = 2.0 * this.previousSumW[0] * this.previousSumX2[0];
        if (den == 0.0 || num == 0.0 || !flagLeftAllEqual) {
            // empty if block
        }
        vkupenBrojElementiVoOvojSplit = NR - N;
        double numR = (double)(vkupenBrojElementiVoOvojSplit - 1) * this.previousSumWXXR[0];
        double denR = 2.0 * this.previousSumWR[0] * this.previousSumX2R[0];
        if (denR == 0.0 || numR == 0.0 || !flagRightAllEqual) {
            // empty if block
        }
        I = (avgik * (double)N + avgikR * (double)(NR - N)) / (double)vkupenBrojElementiVoCelataSuma;
        M = this.prevIndex;
        N = this.splitIndex;
        double scaledI = 2.0 - I;
        if (Double.isNaN(scaledI)) {
            throw new ClusException("err!");
        }
        return scaledI;
    }

    @Override
    public void setData(RowData data) {
        this.m_data = data;
    }

    @Override
    public void setSplitIndex(int i) {
        this.splitIndex = i;
    }

    public int getSplitIndex() {
        return this.splitIndex;
    }

    @Override
    public void setPrevIndex(int i) {
        this.prevIndex = i;
    }

    public int getPrevIndex() {
        return this.prevIndex;
    }

    @Override
    public void initializeSum() {
        Arrays.fill(this.previousSumX, 0.0);
        Arrays.fill(this.previousSumXR, 0.0);
        Arrays.fill(this.previousSumW, 0.0);
        Arrays.fill(this.previousSumWXX, 0.0);
        Arrays.fill(this.previousSumWX, 0.0);
        Arrays.fill(this.previousSumX2, 0.0);
        Arrays.fill(this.previousSumWR, 0.0);
        Arrays.fill(this.previousSumWXXR, 0.0);
        Arrays.fill(this.previousSumWXR, 0.0);
        Arrays.fill(this.previousSumX2R, 0.0);
    }

    public RowData getData() {
        return this.m_data;
    }

    public double[] getPointwiseSquaredDistance(DataTuple tuple) {
        double[] distances = new double[this.m_Hier.getTotal()];
        boolean[] actual = new boolean[this.m_Hier.getTotal()];
        ClassesTuple tp = (ClassesTuple)tuple.getObjVal(this.m_Hier.getType().getArrayIndex());
        tp.fillBoolArrayNodeAndAncestors(actual);
        for (int i = 0; i < this.m_Hier.getTotal(); ++i) {
            double actual_zo = actual[i] ? 1.0 : 0.0;
            double dist = actual_zo - this.m_Means[i];
            distances[i] = dist * dist * this.m_Hier.getWeight(i);
        }
        return distances;
    }

    public double getAbsoluteDistance(DataTuple tuple, ClusAttributeWeights weights, ClusStatManager statmanager) {
        double sum = 0.0;
        boolean[] actual = new boolean[this.m_Hier.getTotal()];
        ClassesTuple tp = (ClassesTuple)tuple.getObjVal(this.m_Hier.getType().getArrayIndex());
        tp.fillBoolArrayNodeAndAncestors(actual);
        for (int i = 0; i < this.m_Hier.getTotal(); ++i) {
            NumericAttrType type = this.getAttribute(i);
            double actual_zo = actual[i] ? 1.0 : 0.0;
            double dist = actual_zo - this.m_Means[i];
            WHTDStatistic tstat = (WHTDStatistic)statmanager.getTrainSetStat(ClusAttrType.AttributeUseType.Clustering);
            if (tstat.getVariance(i) != 0.0) {
                dist /= Math.pow(tstat.getVariance(i), 0.5);
            }
            sum += Math.abs(dist) * weights.getWeight(type);
        }
        return sum / (double)this.getNbAttributes();
    }

    public void printTree() {
        this.m_Hier.print(ClusFormat.OUT_WRITER, this.m_SumValues);
        ClusFormat.OUT_WRITER.flush();
    }

    @Override
    public String getString(StatisticPrintInfo info) {
        String pred = null;
        if (this.m_Threshold >= 0.0) {
            pred = this.computePrintTuple().toStringHuman(this.getHier());
            return pred + " [" + ClusFormat.TWO_AFTER_DOT.format(this.getTotalWeight()) + "]";
        }
        ClusNumberFormat fr = ClusFormat.SIX_AFTER_DOT;
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        for (int i = 0; i < this.getHier().getTotal(); ++i) {
            if (i != 0) {
                buf.append(",");
            }
            if (this.m_SumWeight == 0.0) {
                buf.append("?");
                continue;
            }
            buf.append(fr.format(this.getMean(i)));
        }
        buf.append("]");
        if (info.SHOW_EXAMPLE_COUNT) {
            buf.append(": ");
            buf.append(fr.format(this.m_SumWeight));
        }
        return buf.toString();
    }

    @Override
    public String getPredictString() {
        return "[" + this.computeMeanTuple().toStringHuman(this.getHier()) + "]";
    }

    @Override
    public void showRootInfo() {
        try {
            String hierarchyFile = this.m_Hier.getSettings().getGeneric().getFileAbsolute(this.m_Hier.getSettings().getGeneric().getAppName()) + ".hierarchy";
            PrintWriter wrt = new PrintWriter(new OutputStreamWriter(new FileOutputStream(hierarchyFile)));
            wrt.println("Hier #nodes: " + this.m_Hier.getTotal());
            wrt.println("Hier classes by level: " + MIntArray.toString(this.m_Hier.getClassesByLevel()));
            this.m_Hier.print(wrt, this.m_SumValues, null);
            wrt.close();
        }
        catch (IOException e) {
            ClusLogger.info("IO Error: " + e.getMessage());
        }
    }

    public void printDistributionRec(PrintWriter out, ClassTerm node) {
        int idx = node.getIndex();
        ClassesValue val = new ClassesValue(node);
        out.println(val.toPathString() + ", " + this.m_Means[idx]);
        for (int i = 0; i < node.getNbChildren(); ++i) {
            this.printDistributionRec(out, (ClassTerm)node.getChild(i));
        }
    }

    @Override
    public void printDistribution(PrintWriter wrt) throws IOException {
        wrt.println("Total: " + this.m_SumWeight);
        ClassTerm root = this.m_Hier.getRoot();
        for (int i = 0; i < root.getNbChildren(); ++i) {
            this.printDistributionRec(wrt, (ClassTerm)root.getChild(i));
        }
    }

    public void getExtraInfoRec(ClassTerm node, double[] discrmean, StringBuffer out) {
        int i;
        if (this.m_Validation != null && discrmean[i = node.getIndex()] > 0.5) {
            int pop_tot = this.round(this.m_Global.getTotalWeight());
            int pop_cls = this.round(this.m_Global.getTotalWeight() * this.m_Global.m_Means[i]);
            int rule_tot = this.round(this.m_Validation.getTotalWeight());
            int rule_cls = this.round(this.m_Validation.getTotalWeight() * this.m_Validation.m_Means[i]);
            int upper = Math.min(rule_tot, pop_cls);
            int nb_other = pop_tot - pop_cls;
            int min_this = rule_tot - nb_other;
            int lower = Math.max(rule_cls, min_this);
            HypergeometricDistribution dist = new HypergeometricDistribution(pop_tot, pop_cls, rule_tot);
            double stat = dist.cumulativeProbability(lower, upper);
            out.append(node.toStringHuman(this.getHier()) + ":");
            out.append(" pop_tot = " + String.valueOf(pop_tot));
            out.append(" pop_cls = " + String.valueOf(pop_cls));
            out.append(" rule_tot = " + String.valueOf(rule_tot));
            out.append(" rule_cls = " + String.valueOf(rule_cls));
            out.append(" upper = " + String.valueOf(upper));
            out.append(" prob = " + ClusFormat.SIX_AFTER_DOT.format(stat));
            out.append("\n");
        }
        for (i = 0; i < node.getNbChildren(); ++i) {
            this.getExtraInfoRec((ClassTerm)node.getChild(i), discrmean, out);
        }
    }

    @Override
    public String getExtraInfo() {
        StringBuffer res = new StringBuffer();
        ClassesTuple meantuple = this.m_Hier.getBestTupleMaj(this.m_Means, 50.0);
        double[] discrmean = meantuple.getVectorNodeAndAncestors(this.m_Hier);
        for (int i = 0; i < this.m_Hier.getRoot().getNbChildren(); ++i) {
            this.getExtraInfoRec((ClassTerm)this.m_Hier.getRoot().getChild(i), discrmean, res);
        }
        return res.toString();
    }

    @Override
    public void addPredictWriterSchema(String prefix, ClusSchema schema) {
        ClassHierarchy hier = this.getHier();
        for (int i = 0; i < this.m_NbAttrs; ++i) {
            ClusAttrType type = this.m_Attrs[i].cloneType();
            ClassTerm term = hier.getTermAt(i);
            type.setName(prefix + "-p-" + term.toStringHuman(hier));
            schema.addAttrType(type);
        }
    }

    @Override
    public void unionInit() {
        this.m_DiscrMean = new boolean[this.m_Means.length];
    }

    @Override
    public void union(ClusStatistic other) {
        boolean[] discr_mean = ((WHTDStatistic)other).m_DiscrMean;
        for (int i = 0; i < this.m_DiscrMean.length; ++i) {
            if (!discr_mean[i]) continue;
            this.m_DiscrMean[i] = true;
        }
    }

    @Override
    public void unionDone() {
    }

    @Override
    public void vote(ArrayList<ClusStatistic> votes) {
        this.reset();
        this.m_Means = new double[this.m_NbAttrs];
        int nb_votes = votes.size();
        for (int j = 0; j < nb_votes; ++j) {
            WHTDStatistic vote = (WHTDStatistic)votes.get(j);
            for (int i = 0; i < this.m_NbAttrs; ++i) {
                int n = i;
                this.m_Means[n] = this.m_Means[n] + vote.m_Means[i] / (double)nb_votes;
            }
        }
        this.computePrediction();
    }

    @Override
    public double getDispersion(ClusAttributeWeights scale, RowData data) {
        return this.getSVarS(scale);
    }

    @Override
    public String getDistanceName() {
        return "Hierarchical Weighted Euclidean Distance";
    }

    @Override
    public double getSVarS(int i) {
        throw new RuntimeException("getSVarS(int i)");
    }

    @Override
    public double getSVarS(ClusAttributeWeights scale) {
        if (this.m_Distance.equals((Object)SettingsHMLC.HierarchyDistance.PooledAUPRC)) {
            ArrayList<Integer> classInd = new ArrayList<Integer>(this.m_NbAttrs);
            for (int i = 0; i < this.m_NbAttrs; ++i) {
                classInd.add(i, i);
            }
            final double[] positives = Arrays.copyOf(this.m_P, this.m_P.length);
            classInd.sort(new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    if (positives[o1] < positives[o2]) {
                        return 1;
                    }
                    if (positives[o1] > positives[o2]) {
                        return -1;
                    }
                    return 0;
                }
            });
            double conditionPositives = 0.0;
            for (int i = 0; i < positives.length; ++i) {
                conditionPositives += positives[i];
            }
            double prev = Double.NaN;
            double TP = 0.0;
            double FP = 0.0;
            boolean first = true;
            ArrayList<double[]> PRcurve = new ArrayList<double[]>();
            for (int i = 0; i < positives.length; ++i) {
                double threshold = positives[(Integer)classInd.get(i)];
                if (threshold != prev && !first) {
                    PRcurve.add(new double[]{TP / conditionPositives, TP / (TP + FP)});
                }
                TP += threshold;
                FP += this.m_SumWeight - threshold;
                prev = threshold;
                first = false;
            }
            PRcurve.add(new double[]{TP / conditionPositives, TP / (TP + FP)});
            return WHTDStatistic.computeArea(PRcurve);
        }
        return super.getSVarS(scale);
    }

    @Override
    public double getSVarSDiff(ClusAttributeWeights scale, ClusStatistic other) {
        if (this.m_Distance.equals((Object)SettingsHMLC.HierarchyDistance.PooledAUPRC)) {
            ArrayList<Integer> classInd = new ArrayList<Integer>(this.m_NbAttrs);
            for (int i = 0; i < this.m_NbAttrs; ++i) {
                classInd.add(i, i);
            }
            final double[] positives = new double[this.m_NbAttrs];
            for (int i = 0; i < this.m_NbAttrs; ++i) {
                positives[i] = this.m_P[i] - ((WHTDStatistic)other).m_P[i];
            }
            classInd.sort(new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    if (positives[o1] < positives[o2]) {
                        return 1;
                    }
                    if (positives[o1] > positives[o2]) {
                        return -1;
                    }
                    return 0;
                }
            });
            double conditionPositives = 0.0;
            for (int i = 0; i < positives.length; ++i) {
                conditionPositives += positives[i];
            }
            double prev = Double.NaN;
            double TP = 0.0;
            double FP = 0.0;
            boolean first = true;
            ArrayList<double[]> PRcurve = new ArrayList<double[]>();
            for (int i = 0; i < positives.length; ++i) {
                double threshold = positives[(Integer)classInd.get(i)];
                if (threshold != prev && !first) {
                    PRcurve.add(new double[]{TP / conditionPositives, TP / (TP + FP)});
                }
                TP += threshold;
                FP += this.m_SumWeight - threshold;
                prev = threshold;
                first = false;
            }
            PRcurve.add(new double[]{TP / conditionPositives, TP / (TP + FP)});
            return WHTDStatistic.computeArea(PRcurve);
        }
        return super.getSVarSDiff(scale, other);
    }

    public static double computeArea(ArrayList<double[]> curve) {
        double area = 0.0;
        if (curve.size() > 0) {
            double[] prev = curve.get(0);
            for (int i = 1; i < curve.size(); ++i) {
                double[] pt = curve.get(i);
                area += 0.5 * (pt[1] + prev[1]) * (pt[0] - prev[0]);
                prev = pt;
            }
        }
        return area;
    }

    @Override
    public void copy(ClusStatistic other) {
        if (this.m_Distance.equals((Object)SettingsHMLC.HierarchyDistance.PooledAUPRC)) {
            WHTDStatistic or = (WHTDStatistic)other;
            this.m_SumWeight = or.m_SumWeight;
            this.m_NbExamples = or.m_NbExamples;
            System.arraycopy(or.m_SumValues, 0, this.m_SumValues, 0, this.m_NbAttrs);
            System.arraycopy(or.m_P, 0, this.m_P, 0, this.m_NbAttrs);
        } else {
            super.copy(other);
        }
    }

    public void setThresholds(double threshold) {
        this.m_Thresholds = new double[this.m_Hier.getWeights().length];
        for (int i = 0; i < this.m_Thresholds.length; ++i) {
            this.m_Thresholds[i] = threshold;
        }
    }

    public double[] getThresholds() {
        return this.m_Thresholds;
    }

    @Override
    public boolean samePrediction(ClusStatistic other) {
        WHTDStatistic rstat = (WHTDStatistic)other;
        for (int i = 0; i < this.m_NbAttrs; ++i) {
            if (this.getMean(i) == rstat.getMean(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public double getTargetSumWeights() {
        return this.getTotalWeight();
    }

    public double getWeightLabeled() {
        if (this.m_SumWeight == 0.0) {
            switch (this.getSettings().getTree().getMissingClusteringAttrHandling()) {
                case EstimateFromParentNode: {
                    return this.m_ParentStat.getWeightLabeled();
                }
                case Ignore: {
                    return 0.0;
                }
            }
            return this.m_Training.getWeightLabeled();
        }
        return this.m_SumWeight;
    }
}

