/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.statistic;

import java.util.Arrays;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.attweights.ClusAttributeWeights;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.ext.ensemble.ros.ClusROSModelInfo;
import si.ijs.kt.clus.ext.hierarchicalmtr.ClusHMTRHierarchy;
import si.ijs.kt.clus.heuristic.GISHeuristic;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsTree;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.ComponentStatistic;
import si.ijs.kt.clus.statistic.Distance;
import si.ijs.kt.clus.statistic.DistanceB;
import si.ijs.kt.clus.statistic.RegressionStatBase;
import si.ijs.kt.clus.statistic.StatisticPrintInfo;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.format.ClusFormat;
import si.ijs.kt.clus.util.format.ClusNumberFormat;

public class RegressionStat
extends RegressionStatBase
implements ComponentStatistic {
    public static final long serialVersionUID = 1L;
    public double[] m_SumValues;
    private double[] m_SumSqValues;
    private RegressionStat m_Training;
    private ClusHMTRHierarchy m_HMTRHierarchy;
    public RegressionStat m_ParentStat;
    private double m_I;
    private RowData m_Data;
    private RowData m_TempData;
    private double[] m_SumValuesSpatial;
    private int m_SplitIndex;
    private int m_PrevIndex;
    private double[] m_PreviousSumW;
    private double[] m_PreviousSumX;
    private double[] m_PreviousSumXR;
    private double[] m_PreviousSumWXX;
    private double[] m_PreviousSumWX;
    private double[] m_PreviousSumX2;
    private double[] m_PreviousSumWXXR;
    private double[] m_PreviousSumWXR;
    private double[] m_PreviousSumWR;
    private double[] m_PreviousSumX2R;
    private boolean INITIALIZE_PARTIAL_SUM = true;

    public RegressionStat(Settings sett, NumericAttrType[] attrs) {
        this(sett, attrs, false);
    }

    public RegressionStat(Settings sett, NumericAttrType[] attrs, ClusHMTRHierarchy hier) {
        this(sett, attrs, hier, false);
    }

    public RegressionStat(Settings sett, NumericAttrType[] attrs, ClusHMTRHierarchy hier, boolean onlymean) {
        this(sett, attrs, onlymean);
        this.m_HMTRHierarchy = hier;
    }

    public RegressionStat(Settings sett, NumericAttrType[] attrs, boolean onlymean) {
        super(sett, attrs, onlymean);
        if (!onlymean) {
            this.m_SumValues = new double[this.m_NbAttrs];
            this.m_SumWeights = new double[this.m_NbAttrs];
            this.m_SumSqValues = new double[this.m_NbAttrs];
            this.m_PreviousSumX = new double[2];
            this.m_PreviousSumXR = new double[2];
            this.m_PreviousSumW = new double[2];
            this.m_PreviousSumWXX = new double[2];
            this.m_PreviousSumWX = new double[2];
            this.m_PreviousSumX2 = new double[2];
            this.m_PreviousSumWR = new double[2];
            this.m_PreviousSumWXXR = new double[2];
            this.m_PreviousSumWXR = new double[2];
            this.m_PreviousSumX2R = new double[2];
        }
    }

    public void resetSumValues(int length) {
        this.m_SumValues = new double[length];
    }

    public void resetSumWeights(int length) {
        this.m_SumWeights = new double[length];
    }

    @Override
    public void setTrainingStat(ClusStatistic train) {
        this.m_Training = (RegressionStat)train;
    }

    @Override
    public ClusStatistic cloneStat() {
        RegressionStat res = this.getSettings().getHMTR().isHMTREnabled() ? new RegressionStat(this.m_Settings, this.m_Attrs, this.m_HMTRHierarchy, false) : new RegressionStat(this.m_Settings, this.m_Attrs, false);
        res.m_Training = this.m_Training;
        res.m_ParentStat = this.m_ParentStat;
        return res;
    }

    @Override
    public ClusStatistic cloneSimple() {
        RegressionStat res = this.getSettings().getHMTR().isHMTREnabled() ? new RegressionStat(this.m_Settings, this.m_Attrs, this.m_HMTRHierarchy, true) : new RegressionStat(this.m_Settings, this.m_Attrs, true);
        res.m_Training = this.m_Training;
        res.m_ParentStat = this.m_ParentStat;
        return res;
    }

    @Override
    public ClusStatistic copyNormalizedWeighted(double weight) {
        RegressionStat newStat = this.normalizedCopy();
        for (int iTarget = 0; iTarget < newStat.getNbAttributes(); ++iTarget) {
            newStat.m_Means[iTarget] = weight * newStat.m_Means[iTarget];
        }
        return newStat;
    }

    @Override
    public void reset() {
        this.m_SumWeight = 0.0;
        this.m_NbExamples = 0;
        this.m_SumWeightLabeled = 0.0;
        Arrays.fill(this.m_SumWeights, 0.0);
        Arrays.fill(this.m_SumValues, 0.0);
        Arrays.fill(this.m_SumSqValues, 0.0);
    }

    @Override
    public void copy(ClusStatistic other) {
        RegressionStat or = (RegressionStat)other;
        this.m_SumWeight = or.m_SumWeight;
        this.m_NbExamples = or.m_NbExamples;
        this.m_SumWeightLabeled = or.m_SumWeightLabeled;
        System.arraycopy(or.m_SumWeights, 0, this.m_SumWeights, 0, this.m_NbAttrs);
        System.arraycopy(or.m_SumValues, 0, this.m_SumValues, 0, this.m_NbAttrs);
        System.arraycopy(or.m_SumSqValues, 0, this.m_SumSqValues, 0, this.m_NbAttrs);
    }

    @Override
    public RegressionStat normalizedCopy() {
        RegressionStat copy = (RegressionStat)this.cloneSimple();
        copy.m_NbExamples = 0;
        copy.m_SumWeight = 1.0;
        this.calcMean(copy.m_Means);
        return copy;
    }

    @Override
    public void add(ClusStatistic other) {
        RegressionStat or = (RegressionStat)other;
        this.m_SumWeight += or.m_SumWeight;
        this.m_NbExamples += or.m_NbExamples;
        this.m_SumWeightLabeled += or.m_SumWeightLabeled;
        for (int i = 0; i < this.m_NbAttrs; ++i) {
            int n = i;
            this.m_SumWeights[n] = this.m_SumWeights[n] + or.m_SumWeights[i];
            int n2 = i;
            this.m_SumValues[n2] = this.m_SumValues[n2] + or.m_SumValues[i];
            int n3 = i;
            this.m_SumSqValues[n3] = this.m_SumSqValues[n3] + or.m_SumSqValues[i];
        }
    }

    @Override
    public void addScaled(double scale, ClusStatistic other) {
        RegressionStat or = (RegressionStat)other;
        this.m_SumWeight += scale * or.m_SumWeight;
        this.m_NbExamples += or.m_NbExamples;
        this.m_SumWeightLabeled += scale * or.m_SumWeightLabeled;
        for (int i = 0; i < this.m_NbAttrs; ++i) {
            int n = i;
            this.m_SumWeights[n] = this.m_SumWeights[n] + scale * or.m_SumWeights[i];
            int n2 = i;
            this.m_SumValues[n2] = this.m_SumValues[n2] + scale * or.m_SumValues[i];
            int n3 = i;
            this.m_SumSqValues[n3] = this.m_SumSqValues[n3] + scale * or.m_SumSqValues[i];
        }
    }

    @Override
    public void subtractFromThis(ClusStatistic other) {
        RegressionStat or = (RegressionStat)other;
        this.m_SumWeight -= or.m_SumWeight;
        this.m_NbExamples -= or.m_NbExamples;
        this.m_SumWeightLabeled -= or.m_SumWeightLabeled;
        for (int i = 0; i < this.m_NbAttrs; ++i) {
            int n = i;
            this.m_SumWeights[n] = this.m_SumWeights[n] - or.m_SumWeights[i];
            int n2 = i;
            this.m_SumValues[n2] = this.m_SumValues[n2] - or.m_SumValues[i];
            int n3 = i;
            this.m_SumSqValues[n3] = this.m_SumSqValues[n3] - or.m_SumSqValues[i];
        }
    }

    @Override
    public void subtractFromOther(ClusStatistic other) {
        RegressionStat or = (RegressionStat)other;
        this.m_SumWeight = or.m_SumWeight - this.m_SumWeight;
        this.m_NbExamples = or.m_NbExamples - this.m_NbExamples;
        this.m_SumWeightLabeled += or.m_SumWeightLabeled - this.m_SumWeightLabeled;
        for (int i = 0; i < this.m_NbAttrs; ++i) {
            this.m_SumWeights[i] = or.m_SumWeights[i] - this.m_SumWeights[i];
            this.m_SumValues[i] = or.m_SumValues[i] - this.m_SumValues[i];
            this.m_SumSqValues[i] = or.m_SumSqValues[i] - this.m_SumSqValues[i];
        }
    }

    @Override
    public void updateWeighted(DataTuple tuple, double weight) {
        ++this.m_NbExamples;
        this.m_SumWeight += weight;
        boolean hasLabel = false;
        for (int i = 0; i < this.m_NbAttrs; ++i) {
            double val = this.m_Attrs[i].getNumeric(tuple);
            if (val == Double.POSITIVE_INFINITY) continue;
            int n = i;
            this.m_SumWeights[n] = this.m_SumWeights[n] + weight;
            int n2 = i;
            this.m_SumValues[n2] = this.m_SumValues[n2] + weight * val;
            int n3 = i;
            this.m_SumSqValues[n3] = this.m_SumSqValues[n3] + weight * val * val;
            if (hasLabel || !this.m_Attrs[i].isTarget()) continue;
            hasLabel = true;
        }
        if (hasLabel) {
            this.m_SumWeightLabeled += weight;
        }
    }

    @Override
    public void calcMean(double[] means) {
        for (int i = 0; i < this.m_NbAttrs; ++i) {
            means[i] = this.m_SumWeights[i] != 0.0 ? this.m_SumValues[i] / this.m_SumWeights[i] : 0.0;
        }
    }

    @Override
    public double getMean(int i) {
        if (this.m_SumValues == null || this.m_SumWeights == null) {
            return this.m_Means[i];
        }
        if (this.m_SumWeights[i] == 0.0) {
            switch (this.getSettings().getTree().getMissingTargetAttrHandling()) {
                case ParentNode: {
                    if (this.m_ParentStat == null) {
                        return Double.NaN;
                    }
                    return this.m_ParentStat.getMean(i);
                }
                case Zero: {
                    return 0.0;
                }
            }
            if (this.m_Training == null) {
                return Double.NaN;
            }
            return this.m_Training.getMean(i);
        }
        return this.m_SumValues[i] / this.m_SumWeights[i];
    }

    public double getSumValues(int i) {
        return this.m_SumValues[i];
    }

    public double getSumSqValues(int i) {
        return this.m_SumSqValues[i];
    }

    public double getSumWeights(int i) {
        return this.m_SumWeights[i];
    }

    public RegressionStat getTraining() {
        return this.m_Training;
    }

    public double getEstimatedSVarS(int i) {
        switch (this.getSettings().getTree().getMissingClusteringAttrHandling()) {
            case EstimateFromParentNode: {
                if (this.m_ParentStat == null) {
                    return Double.NaN;
                }
                return this.m_ParentStat.getSVarS(i);
            }
            case Ignore: {
                return Double.NaN;
            }
        }
        if (this.m_Training == null) {
            return Double.NaN;
        }
        return this.m_Training.getSVarS(i);
    }

    public boolean shouldEstimate(double k_tot, double n_tot) {
        return k_tot <= 1.0E-9;
    }

    @Override
    public double getSVarS(int i) {
        double n_tot = this.m_SumWeight;
        double k_tot = this.m_SumWeights[i];
        double sv_tot = this.m_SumValues[i];
        double ss_tot = this.m_SumSqValues[i];
        if (this.shouldEstimate(k_tot, n_tot)) {
            return this.getEstimatedSVarS(i);
        }
        return this.getSVarS(n_tot, k_tot, sv_tot, ss_tot);
    }

    public double getSVarSDiff(int i, RegressionStat or) {
        double n_tot = this.m_SumWeight - or.m_SumWeight;
        double k_tot = this.m_SumWeights[i] - or.m_SumWeights[i];
        double sv_tot = this.m_SumValues[i] - or.m_SumValues[i];
        double ss_tot = this.m_SumSqValues[i] - or.m_SumSqValues[i];
        if (this.shouldEstimate(k_tot, n_tot)) {
            return or.getEstimatedSVarS(i);
        }
        return this.getSVarS(n_tot, k_tot, sv_tot, ss_tot);
    }

    public double getSVarS(double n_tot, double k_tot, double sv_tot, double ss_tot) {
        return ss_tot - sv_tot * sv_tot / k_tot;
    }

    private double getSVarSROS(ClusAttributeWeights scale) {
        double result = 0.0;
        ClusROSModelInfo info = scale.getROSModelInfo();
        for (Integer i : info.getTargets()) {
            result += this.getSVarS(i) * scale.getWeight(this.m_Attrs[i]);
        }
        return result / (double)scale.getROSModelInfo().getSizeOfSubspace();
    }

    @Override
    public double getSVarS(ClusAttributeWeights scale) {
        if (this.getSettings().getEnsemble().isEnsembleROSEnabled()) {
            return this.getSVarSROS(scale);
        }
        if (this.getSettings().getHMTR().isHMTREnabled()) {
            return this.getSVarSHMTR(scale);
        }
        double result = 0.0;
        int nbEffectiveAttrs = this.m_NbAttrs;
        for (int i = 0; i < this.m_NbAttrs; ++i) {
            double var = this.getSVarS(i);
            if (Double.isNaN(var)) {
                --nbEffectiveAttrs;
                continue;
            }
            result += var * scale.getWeight(this.m_Attrs[i]);
        }
        if (nbEffectiveAttrs == 0) {
            return Double.POSITIVE_INFINITY;
        }
        return result / (double)nbEffectiveAttrs;
    }

    public double getSVarSHMTR(ClusAttributeWeights scale) {
        double result = 0.0;
        for (int i = 0; i < this.m_NbAttrs; ++i) {
            double hmtrWeight = this.m_HMTRHierarchy.getWeight(this.m_Attrs[i].getName());
            double n_tot = this.m_SumWeight;
            double k_tot = this.m_SumWeights[i];
            double sv_tot = this.m_SumValues[i];
            double ss_tot = this.m_SumSqValues[i];
            if (k_tot == n_tot) {
                result += (ss_tot - sv_tot * sv_tot / n_tot) * scale.getWeight(this.m_Attrs[i]) * hmtrWeight;
                continue;
            }
            if (k_tot <= 1.0E-9 && this.m_Training != null) {
                result += this.m_Training.getSVarS(i) * scale.getWeight(this.m_Attrs[i]) * hmtrWeight;
                continue;
            }
            result += (ss_tot * (n_tot - 1.0) / (k_tot - 1.0) - n_tot * sv_tot / k_tot * sv_tot / k_tot) * scale.getWeight(this.m_Attrs[i]) * hmtrWeight;
        }
        return result / (double)this.m_NbAttrs;
    }

    public double getSVarSDiffROS(ClusAttributeWeights scale, ClusStatistic other) {
        double result = 0.0;
        RegressionStat or = (RegressionStat)other;
        for (Integer i : scale.getROSModelInfo().getTargets()) {
            result += this.getSVarSDiff(i, or) * scale.getWeight(this.m_Attrs[i]);
        }
        return result / (double)scale.getROSModelInfo().getSizeOfSubspace();
    }

    public double getSVarSDiffHMTR(ClusAttributeWeights scale, ClusStatistic other) {
        double result = 0.0;
        RegressionStat or = (RegressionStat)other;
        for (int i = 0; i < this.m_NbAttrs; ++i) {
            double hmtrWeight = this.m_HMTRHierarchy.getWeight(this.m_Attrs[i].getName());
            double n_tot = this.m_SumWeight - or.m_SumWeight;
            double k_tot = this.m_SumWeights[i] - or.m_SumWeights[i];
            double sv_tot = this.m_SumValues[i] - or.m_SumValues[i];
            double ss_tot = this.m_SumSqValues[i] - or.m_SumSqValues[i];
            if (k_tot == n_tot) {
                result += (ss_tot - sv_tot * sv_tot / n_tot) * scale.getWeight(this.m_Attrs[i]) * hmtrWeight;
                continue;
            }
            if (k_tot <= 1.0E-9 && this.m_Training != null) {
                result += this.m_Training.getSVarS(i) * scale.getWeight(this.m_Attrs[i]) * hmtrWeight;
                continue;
            }
            result += (ss_tot * (n_tot - 1.0) / (k_tot - 1.0) - n_tot * sv_tot / k_tot * sv_tot / k_tot) * scale.getWeight(this.m_Attrs[i]) * hmtrWeight;
        }
        return result / (double)this.m_NbAttrs;
    }

    @Override
    public double getSVarSDiff(ClusAttributeWeights scale, ClusStatistic other) {
        if (this.getSettings().getEnsemble().isEnsembleROSEnabled()) {
            return this.getSVarSDiffROS(scale, other);
        }
        if (this.getSettings().getHMTR().isHMTREnabled()) {
            return this.getSVarSDiffHMTR(scale, other);
        }
        double result = 0.0;
        RegressionStat or = (RegressionStat)other;
        int nbEffectiveAttrs = this.m_NbAttrs;
        for (int i = 0; i < this.m_NbAttrs; ++i) {
            double var = this.getSVarSDiff(i, or);
            if (Double.isNaN(var)) {
                --nbEffectiveAttrs;
                continue;
            }
            result += var * scale.getWeight(this.m_Attrs[i]);
        }
        if (nbEffectiveAttrs == 0) {
            return Double.POSITIVE_INFINITY;
        }
        return result / (double)nbEffectiveAttrs;
    }

    @Override
    public String getString(StatisticPrintInfo info) {
        int i;
        ClusNumberFormat fr = ClusFormat.SIX_AFTER_DOT;
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        for (i = 0; i < this.m_NbAttrs; ++i) {
            double tot;
            if (i != 0) {
                buf.append(",");
            }
            if ((tot = this.getSumWeights(i)) == 0.0) {
                buf.append("?");
                continue;
            }
            double val = this.getSumValues(i);
            if (!Double.isNaN(val)) {
                buf.append(fr.format(val / tot));
                continue;
            }
            buf.append("Not predicted");
        }
        buf.append("]");
        if (info.SHOW_EXAMPLE_COUNT_BYTARGET) {
            buf.append(": [");
            for (i = 0; i < this.m_NbAttrs; ++i) {
                if (i != 0) {
                    buf.append(",");
                }
                buf.append(fr.format(this.m_SumWeights[i]));
            }
            buf.append("]");
        } else if (info.SHOW_EXAMPLE_COUNT) {
            buf.append(": ");
            buf.append(fr.format(this.m_SumWeight));
        }
        return buf.toString();
    }

    @Override
    public void printDebug() {
        for (int i = 0; i < this.getNbAttributes(); ++i) {
            double n_tot = this.m_SumWeight;
            double k_tot = this.m_SumWeights[i];
            double sv_tot = this.m_SumValues[i];
            double ss_tot = this.m_SumSqValues[i];
            ClusLogger.info("n: " + n_tot + " k: " + k_tot);
            ClusLogger.info("sv: " + sv_tot);
            ClusLogger.info("ss: " + ss_tot);
            double mean = sv_tot / n_tot;
            double var = ss_tot - n_tot * mean * mean;
            ClusLogger.info("mean: " + mean);
            ClusLogger.info("var: " + var);
        }
        ClusLogger.info("err: " + this.getError());
    }

    @Override
    public RegressionStat getRegressionStat() {
        return this;
    }

    @Override
    public double getSquaredDistance(ClusStatistic other) {
        double result = 0.0;
        RegressionStat o = (RegressionStat)other;
        for (int i = 0; i < this.m_NbAttrs; ++i) {
            double distance = this.getMean(i) - o.getMean(i);
            result += distance * distance;
        }
        return result;
    }

    @Override
    public int getNbStatisticComponents() {
        return this.m_SumWeights.length;
    }

    public void calcMeanSpatial(double[] means) {
        ClusSchema schema = this.m_TempData.getSchema();
        for (int k = 0; k < this.m_NbAttrs; ++k) {
            NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k];
            NumericAttrType xt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
            NumericAttrType yt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[1];
            int NeighCount = 3;
            int N = schema.getSettings().getModel().getMinimalNbExamples();
            for (int i = 0; i < N; ++i) {
                Distance[] distances = new Distance[NeighCount];
                DataTuple exi = this.m_Data.getTuple(i);
                double xi = ((ClusAttrType)xt).getNumeric(exi);
                double yi = ((ClusAttrType)yt).getNumeric(exi);
                double biggestd = Double.POSITIVE_INFINITY;
                int biggestindex = Integer.MAX_VALUE;
                for (int j = 0; j < N; ++j) {
                    DataTuple exj = this.m_TempData.getTuple(j);
                    double tj = ((ClusAttrType)type).getNumeric(exj);
                    double xj = ((ClusAttrType)xt).getNumeric(exj);
                    double yj = ((ClusAttrType)yt).getNumeric(exj);
                    double d = Math.sqrt((xi - xj) * (xi - xj) + (yi - yj) * (yi - yj));
                    if (N < NeighCount) {
                        distances[j] = new Distance(j, tj, d);
                        continue;
                    }
                    if (j < NeighCount) {
                        distances[j] = new Distance(j, tj, d);
                        continue;
                    }
                    biggestd = distances[0].distance;
                    biggestindex = 0;
                    for (int a = 1; a < NeighCount; ++a) {
                        if (!(distances[a].distance > biggestd)) continue;
                        biggestd = distances[a].distance;
                        biggestindex = a;
                    }
                    if (!(d < biggestd)) continue;
                    distances[biggestindex].index = j;
                    distances[biggestindex].target = tj;
                    distances[biggestindex].distance = d;
                }
                for (int ii = 0; ii < NeighCount; ++ii) {
                    int n = i;
                    this.m_SumValuesSpatial[n] = this.m_SumValuesSpatial[n] + distances[ii].target;
                }
            }
            means[k] = this.m_SumWeights[k] != 0.0 ? this.m_SumValues[k] / this.m_SumWeights[k] : 0.0;
        }
    }

    @Override
    public double calcPDistance(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_Data.getSchema();
        NumericAttrType xt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
        int M = 0;
        int N = this.m_Data.getNbRows();
        if (this.m_SplitIndex > 0) {
            N = this.m_SplitIndex;
        } else {
            M = -this.m_SplitIndex;
        }
        double[] upsum = new double[schema.getNbTargetAttributes()];
        double[] downsum = new double[schema.getNbTargetAttributes()];
        double[] means = new double[schema.getNbTargetAttributes()];
        double[] ikk = new double[schema.getNbTargetAttributes()];
        int k = 0;
        while (k < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k];
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNumeric(exi);
                int n = k;
                means[n] = means[n] + xi;
            }
            int n = k++;
            means[n] = means[n] / (double)(N - M);
        }
        double avgik = 0.0;
        for (int k2 = 0; k2 < schema.getNbTargetAttributes(); ++k2) {
            NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k2];
            for (int i = M; i < N; ++i) {
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNumeric(exi);
                for (int j = M; j < N; ++j) {
                    String indexMap;
                    Double temp;
                    long yyi;
                    long indexJ;
                    DataTuple exj = this.m_Data.getTuple(permutation[j]);
                    double xj = ((ClusAttrType)type).getNumeric(exj);
                    long xxi = (long)((ClusAttrType)xt).getNumeric(exi);
                    long indexI = xxi;
                    if (indexI == (indexJ = (yyi = (long)((ClusAttrType)xt).getNumeric(exj)))) continue;
                    if (indexI > indexJ) {
                        indexI = yyi;
                        indexJ = xxi;
                    }
                    if ((temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) == null) continue;
                    int n = k2;
                    upsum[n] = upsum[n] + (xi - means[k2]) * (xj - means[k2]);
                }
                int n = k2;
                downsum[n] = downsum[n] + (xi - means[k2]) * (xi - means[k2]);
            }
            if (downsum[k2] != 0.0 && upsum[k2] != 0.0) {
                ikk[k2] = upsum[k2] / downsum[k2];
                avgik += ikk[k2];
                continue;
            }
            avgik = 1.0;
        }
        double IL = (avgik /= (double)schema.getNbTargetAttributes()) * (double)(N - M);
        N = this.m_Data.getNbRows();
        M = this.m_SplitIndex;
        double[] upsumR = new double[schema.getNbTargetAttributes()];
        double[] downsumR = new double[schema.getNbTargetAttributes()];
        double[] meansR = new double[schema.getNbTargetAttributes()];
        double[] ikkR = new double[schema.getNbTargetAttributes()];
        int k3 = 0;
        while (k3 < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k3];
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNumeric(exi);
                int n = k3;
                meansR[n] = meansR[n] + xi;
            }
            int n = k3++;
            meansR[n] = meansR[n] / (double)(N - M);
        }
        double avgikR = 0.0;
        for (int k4 = 0; k4 < schema.getNbTargetAttributes(); ++k4) {
            NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k4];
            for (int i = M; i < N; ++i) {
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNumeric(exi);
                for (int j = M; j < N; ++j) {
                    String indexMap;
                    Double temp;
                    long yyi;
                    long indexJ;
                    DataTuple exj = this.m_Data.getTuple(permutation[j]);
                    double xj = ((ClusAttrType)type).getNumeric(exj);
                    long xxi = (long)((ClusAttrType)xt).getNumeric(exi);
                    long indexI = xxi;
                    if (indexI == (indexJ = (yyi = (long)((ClusAttrType)xt).getNumeric(exj)))) continue;
                    if (indexI > indexJ) {
                        indexI = yyi;
                        indexJ = xxi;
                    }
                    if ((temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) == null) continue;
                    int n = k4;
                    upsumR[n] = upsumR[n] + (xi - meansR[k4]) * (xj - meansR[k4]);
                }
                int n = k4;
                downsumR[n] = downsumR[n] + (xi - meansR[k4]) * (xi - meansR[k4]);
            }
            if (downsumR[k4] != 0.0 && upsumR[k4] != 0.0) {
                ikkR[k4] = upsumR[k4] / downsumR[k4];
                avgikR += ikkR[k4];
                continue;
            }
            avgikR = 1.0;
        }
        double IR = avgikR /= (double)schema.getNbTargetAttributes();
        double I = (IL + IR * (double)(N - M)) / (double)this.m_Data.getNbRows();
        double scaledI = 1.0 + I;
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return scaledI;
    }

    @Override
    public double calcPtotal(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_Data.getSchema();
        int M = 0;
        int N = this.m_Data.getNbRows();
        long NR = this.m_Data.getNbRows();
        if (this.m_SplitIndex > 0) {
            N = this.m_SplitIndex;
        } else {
            M = -this.m_SplitIndex;
        }
        double[] upsum = new double[schema.getNbTargetAttributes()];
        double[] downsum = new double[schema.getNbTargetAttributes()];
        double[] means = new double[schema.getNbTargetAttributes()];
        double[] ikk = new double[schema.getNbTargetAttributes()];
        int k = 0;
        while (k < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k];
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNumeric(exi);
                int n = k;
                means[n] = means[n] + xi;
            }
            int n = k++;
            means[n] = means[n] / (double)(N - M);
        }
        double avgik = 0.0;
        for (int k2 = 0; k2 < schema.getNbTargetAttributes(); ++k2) {
            NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k2];
            for (int i = M; i < N; ++i) {
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNumeric(exi);
                for (int j = M; j < N; ++j) {
                    long indexMap;
                    Double temp;
                    DataTuple exj = this.m_Data.getTuple(permutation[j]);
                    double xj = ((ClusAttrType)type).getNumeric(exj);
                    long indexI = permutation[i].intValue();
                    long indexJ = permutation[j].intValue();
                    if (permutation[i] == permutation[j]) continue;
                    if (permutation[i] > permutation[j]) {
                        indexI = permutation[j].intValue();
                        indexJ = permutation[i].intValue();
                    }
                    if ((temp = GISHeuristic.m_distances.get(indexMap = indexI * NR + indexJ)) == null) continue;
                    int n = k2;
                    upsum[n] = upsum[n] + (xi - means[k2]) * (xj - means[k2]);
                }
                int n = k2;
                downsum[n] = downsum[n] + (xi - means[k2]) * (xi - means[k2]);
            }
            if (downsum[k2] != 0.0 && upsum[k2] != 0.0) {
                ikk[k2] = upsum[k2] / downsum[k2];
                avgik += ikk[k2];
                continue;
            }
            avgik = 1.0;
        }
        double IL = (avgik /= (double)schema.getNbTargetAttributes()) * (double)(N - M);
        N = this.m_Data.getNbRows();
        M = this.m_SplitIndex;
        double[] upsumR = new double[schema.getNbTargetAttributes()];
        double[] downsumR = new double[schema.getNbTargetAttributes()];
        double[] meansR = new double[schema.getNbTargetAttributes()];
        double[] ikkR = new double[schema.getNbTargetAttributes()];
        int k3 = 0;
        while (k3 < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k3];
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNumeric(exi);
                int n = k3;
                meansR[n] = meansR[n] + xi;
            }
            int n = k3++;
            meansR[n] = meansR[n] / (double)(N - M);
        }
        double avgikR = 0.0;
        for (int k4 = 0; k4 < schema.getNbTargetAttributes(); ++k4) {
            NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k4];
            for (int i = M; i < N; ++i) {
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNumeric(exi);
                for (int j = M; j < N; ++j) {
                    long indexMap;
                    Double temp;
                    DataTuple exj = this.m_Data.getTuple(permutation[j]);
                    double xj = ((ClusAttrType)type).getNumeric(exj);
                    long indexI = permutation[i].intValue();
                    long indexJ = permutation[j].intValue();
                    if (permutation[i] == permutation[j]) continue;
                    if (permutation[i] > permutation[j]) {
                        indexI = permutation[j].intValue();
                        indexJ = permutation[i].intValue();
                    }
                    if ((temp = GISHeuristic.m_distances.get(indexMap = indexI * NR + indexJ)) == null) continue;
                    int n = k4;
                    upsumR[n] = upsumR[n] + (xi - meansR[k4]) * (xj - meansR[k4]);
                }
                int n = k4;
                downsumR[n] = downsumR[n] + (xi - meansR[k4]) * (xi - meansR[k4]);
            }
            if (downsumR[k4] != 0.0 && upsumR[k4] != 0.0) {
                ikkR[k4] = upsumR[k4] / downsumR[k4];
                avgikR += ikkR[k4];
                continue;
            }
            avgikR = 1.0;
        }
        double IR = avgikR /= (double)schema.getNbTargetAttributes();
        double I = (IL + IR * (double)(N - M)) / (double)this.m_Data.getNbRows();
        double scaledI = 1.0 + I;
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return scaledI;
    }

    @Override
    public double calcMultiIwithNeighbours(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_Data.getSchema();
        if (schema.getNbTargetAttributes() == 1) {
            throw new ClusException("Error calculating Bivariate Heuristics with only one target!");
        }
        int M = 0;
        int N = this.m_Data.getNbRows();
        if (this.m_SplitIndex > 0) {
            N = this.m_SplitIndex;
        } else {
            M = -this.m_SplitIndex;
        }
        double[] upsum = new double[schema.getNbTargetAttributes()];
        double[] downsum = new double[schema.getNbTargetAttributes()];
        double[] means = new double[schema.getNbTargetAttributes()];
        double[] ikk = new double[schema.getNbTargetAttributes()];
        int k = 0;
        while (k < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k];
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNumeric(exi);
                int n = k;
                means[n] = means[n] + xi;
            }
            int n = k++;
            means[n] = means[n] / (double)(N - M);
        }
        double avgik = 0.0;
        for (int k2 = 0; k2 < schema.getNbTargetAttributes(); ++k2) {
            NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k2];
            int NeighCount = (int)schema.getSettings().getTree().getNumNeightbours();
            double W = 0.0;
            if (NeighCount > 0) {
                double[][] w = new double[N][N];
                for (int i = M; i < N; ++i) {
                    Distance[] distances = new Distance[NeighCount];
                    DataTuple exi = this.m_Data.getTuple(permutation[i]);
                    NumericAttrType xt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
                    NumericAttrType yt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[1];
                    double ti = ((ClusAttrType)type).getNumeric(exi);
                    double xi = ((ClusAttrType)xt).getNumeric(exi);
                    double yi = ((ClusAttrType)yt).getNumeric(exi);
                    double biggestd = Double.POSITIVE_INFINITY;
                    int biggestindex = Integer.MAX_VALUE;
                    for (int j = M; j < N; ++j) {
                        DataTuple exj = this.m_Data.getTuple(permutation[j]);
                        double tj = ((ClusAttrType)type).getNumeric(exj);
                        double xj = ((ClusAttrType)xt).getNumeric(exj);
                        double yj = ((ClusAttrType)yt).getNumeric(exj);
                        double d = Math.sqrt((xi - xj) * (xi - xj) + (yi - yj) * (yi - yj));
                        if (N - M < NeighCount) {
                            distances[j] = new Distance(permutation[j].intValue(), tj, d);
                            continue;
                        }
                        if (permutation[j] < NeighCount) {
                            distances[j] = new Distance(permutation[j].intValue(), tj, d);
                            continue;
                        }
                        biggestd = distances[0].distance;
                        biggestindex = 0;
                        for (int a = 1; a < NeighCount; ++a) {
                            if (!(distances[a].distance > biggestd)) continue;
                            biggestd = distances[a].distance;
                            biggestindex = a;
                        }
                        if (!(d < biggestd)) continue;
                        distances[biggestindex].index = permutation[j].intValue();
                        distances[biggestindex].target = tj;
                        distances[biggestindex].distance = d;
                    }
                    SettingsTree.SpatialMatrixType spatialMatrix = schema.getSettings().getTree().getSpatialMatrix();
                    int NN2 = N - M < NeighCount ? N - M : M + NeighCount;
                    for (int j = M; j < NN2; ++j) {
                        if (distances[j].distance == 0.0) {
                            w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                        } else {
                            switch (spatialMatrix) {
                                case Binary: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                    break;
                                }
                                case Euclidean: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0 / distances[j].distance;
                                    break;
                                }
                                case Modified: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount)) * (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount));
                                    break;
                                }
                                case Gaussian: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = Math.exp(-(distances[j].distance * distances[j].distance) / (double)(NeighCount * NeighCount));
                                    break;
                                }
                                default: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                }
                            }
                        }
                        int n = k2;
                        upsum[n] = upsum[n] + w[permutation[i]][permutation[j]] * (ti - means[k2]) * (distances[j].target - means[k2]);
                        W += w[permutation[i]][permutation[j]];
                    }
                    int n = k2;
                    downsum[n] = downsum[n] + (ti - means[k2]) * (ti - means[k2]);
                }
            }
            int n = k2;
            downsum[n] = downsum[n] / ((double)(N - M) + 0.0);
            if (downsum[k2] != 0.0 && upsum[k2] != 0.0) {
                ikk[k2] = upsum[k2] / (W * downsum[k2]);
                avgik += ikk[k2];
                continue;
            }
            avgik = 1.0;
        }
        double IL = (avgik /= (double)schema.getNbTargetAttributes()) * (double)(N - M);
        N = this.m_Data.getNbRows();
        M = this.m_SplitIndex;
        double[] upsumR = new double[schema.getNbTargetAttributes()];
        double[] downsumR = new double[schema.getNbTargetAttributes()];
        double[] meansR = new double[schema.getNbTargetAttributes()];
        double[] ikkR = new double[schema.getNbTargetAttributes()];
        int k3 = 0;
        while (k3 < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k3];
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNumeric(exi);
                int n = k3;
                meansR[n] = meansR[n] + xi;
            }
            int n = k3++;
            meansR[n] = meansR[n] / (double)(N - M);
        }
        double avgikR = 0.0;
        for (int k4 = 0; k4 < schema.getNbTargetAttributes(); ++k4) {
            NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k4];
            int NeighCount = (int)schema.getSettings().getTree().getNumNeightbours();
            double WR = 0.0;
            if (NeighCount > 0) {
                double[][] w = new double[N][N];
                for (int i = M; i < N; ++i) {
                    Distance[] distances = new Distance[NeighCount];
                    DataTuple exi = this.m_Data.getTuple(permutation[i]);
                    NumericAttrType xt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
                    NumericAttrType yt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[1];
                    double ti = ((ClusAttrType)type).getNumeric(exi);
                    double xi = ((ClusAttrType)xt).getNumeric(exi);
                    double yi = ((ClusAttrType)yt).getNumeric(exi);
                    int a = 0;
                    double biggestd = Double.POSITIVE_INFINITY;
                    int biggestindex = Integer.MAX_VALUE;
                    for (int j = M; j < N; ++j) {
                        DataTuple exj = this.m_Data.getTuple(j);
                        double tj = ((ClusAttrType)type).getNumeric(exj);
                        double xj = ((ClusAttrType)xt).getNumeric(exj);
                        double yj = ((ClusAttrType)yt).getNumeric(exj);
                        double d = Math.sqrt((xi - xj) * (xi - xj) + (yi - yj) * (yi - yj));
                        if (N - M < NeighCount) {
                            distances[a] = new Distance(j, tj, d);
                            ++a;
                            continue;
                        }
                        if (a < NeighCount) {
                            distances[a] = new Distance(j, tj, d);
                            ++a;
                            continue;
                        }
                        biggestd = distances[0].distance;
                        biggestindex = 0;
                        for (a = 1; a < NeighCount; ++a) {
                            if (!(distances[a].distance > biggestd)) continue;
                            biggestd = distances[a].distance;
                            biggestindex = a;
                        }
                        if (!(d < biggestd)) continue;
                        distances[biggestindex].index = j;
                        distances[biggestindex].target = tj;
                        distances[biggestindex].distance = d;
                    }
                    SettingsTree.SpatialMatrixType spatialMatrix = schema.getSettings().getTree().getSpatialMatrix();
                    for (int j = 0; distances.length > j && distances[j] != null && j < NeighCount; ++j) {
                        if (distances[j].distance == 0.0) {
                            w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                        } else {
                            switch (spatialMatrix) {
                                case Binary: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                    break;
                                }
                                case Euclidean: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0 / distances[j].distance;
                                    break;
                                }
                                case Modified: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount)) * (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount));
                                    break;
                                }
                                case Gaussian: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = Math.exp(-(distances[j].distance * distances[j].distance) / (double)(NeighCount * NeighCount));
                                    break;
                                }
                                default: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                }
                            }
                        }
                        int n = k4;
                        upsumR[n] = upsumR[n] + w[permutation[i]][permutation[j]] * (ti - meansR[k4]) * (distances[j].target - meansR[k4]);
                        WR += w[permutation[i]][permutation[j]];
                    }
                    int n = k4;
                    downsumR[n] = downsumR[n] + (ti - meansR[k4]) * (ti - meansR[k4]);
                }
            }
            int n = k4;
            downsumR[n] = downsumR[n] / ((double)(N - M) + 0.0);
            if (downsumR[k4] != 0.0 && upsumR[k4] != 0.0) {
                ikkR[k4] = upsumR[k4] / (WR * downsumR[k4]);
                avgikR += ikkR[k4];
                continue;
            }
            avgikR = 1.0;
        }
        double IR = avgikR /= (double)schema.getNbTargetAttributes();
        double I = (IL + IR * (double)(N - M)) / (double)this.m_Data.getNbRows();
        double scaledI = 1.0 + I;
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return scaledI;
    }

    @Override
    public double calcBivariateLee(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_Data.getSchema();
        if (schema.getNbTargetAttributes() == 1) {
            throw new ClusException("Error calculating Bivariate Heuristics with only one target!");
        }
        int M = 0;
        int N = this.m_Data.getNbRows();
        long NR = this.m_Data.getNbRows();
        if (this.m_SplitIndex > 0) {
            N = this.m_SplitIndex;
        } else {
            M = -this.m_SplitIndex;
        }
        double[][] upsum = new double[schema.getNbTargetAttributes()][N - M];
        double[] means = new double[schema.getNbTargetAttributes()];
        double[] xi = new double[schema.getNbTargetAttributes()];
        double[] xj = new double[schema.getNbTargetAttributes()];
        int k = 0;
        while (k < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k];
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                double xxi = ((ClusAttrType)type).getNumeric(exi);
                int n = k;
                means[n] = means[n] + xxi;
            }
            int n = k++;
            means[n] = means[n] / (double)(N - M);
        }
        double avgik = 0.0;
        double upsum0 = 0.0;
        double upsum1 = 1.0;
        double downsum0 = 0.0;
        double downsum1 = 0.0;
        double WL = 0.0;
        for (int i = M; i < N; ++i) {
            DataTuple exi = this.m_Data.getTuple(permutation[i]);
            for (int k2 = 0; k2 < schema.getNbTargetAttributes(); ++k2) {
                NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k2];
                xi[k2] = ((ClusAttrType)type).getNumeric(exi);
            }
            double W = 0.0;
            for (int j = M; j < N; ++j) {
                DataTuple exj = this.m_Data.getTuple(j);
                for (int k3 = 0; k3 < schema.getNbTargetAttributes(); ++k3) {
                    NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k3];
                    xj[k3] = ((ClusAttrType)type).getNumeric(exj);
                }
                double w = 0.0;
                long indexI = i;
                long indexJ = j;
                if (i != j) {
                    long indexMap;
                    Double temp;
                    if (i > j) {
                        indexI = j;
                        indexJ = i;
                    }
                    w = (temp = GISHeuristic.m_distances.get(indexMap = indexI * NR + indexJ)) != null ? temp : 0.0;
                    double[] dArray = upsum[0];
                    int n = i;
                    dArray[n] = dArray[n] + w * (xj[0] - means[0]);
                    double[] dArray2 = upsum[1];
                    int n2 = i;
                    dArray2[n2] = dArray2[n2] + w * (xj[1] - means[1]);
                    W += w;
                    continue;
                }
                double[] dArray = upsum[0];
                int n = i;
                dArray[n] = dArray[n] + (xi[0] - means[0]);
                double[] dArray3 = upsum[1];
                int n3 = i;
                dArray3[n3] = dArray3[n3] + (xi[1] - means[1]);
                W += 1.0;
            }
            WL += W * W;
            upsum0 += upsum[0][permutation[i]] * upsum[1][permutation[i]];
            downsum0 += (xi[0] - means[0]) * (xi[0] - means[0]);
            downsum1 += (xi[1] - means[1]) * (xi[1] - means[1]);
        }
        avgik = upsum0 != 0.0 && upsum1 != 0.0 && downsum0 != 0.0 && downsum1 != 0.0 ? ((double)(N - M) + 0.0) * upsum0 * upsum1 / (WL * Math.sqrt(downsum0 * downsum1)) : 0.0;
        double IL = avgik * (double)(N - M);
        N = this.m_Data.getNbRows();
        M = this.m_SplitIndex;
        double IR = 0.0;
        double upsumR0 = 0.0;
        double upsumR1 = 1.0;
        double downsumR0 = 0.0;
        double downsumR1 = 0.0;
        double WRR = 0.0;
        double[][] upsumR = new double[schema.getNbTargetAttributes()][N - M];
        double[] meansR = new double[schema.getNbTargetAttributes()];
        double[] xiR = new double[schema.getNbTargetAttributes()];
        double[] xjR = new double[schema.getNbTargetAttributes()];
        int k4 = 0;
        while (k4 < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k4];
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                double xxi = ((ClusAttrType)type).getNumeric(exi);
                int n = k4;
                meansR[n] = meansR[n] + xxi;
            }
            int n = k4++;
            meansR[n] = meansR[n] / (double)(N - M);
        }
        for (int i = M; i < N; ++i) {
            DataTuple exi = this.m_Data.getTuple(permutation[i]);
            for (int k5 = 0; k5 < schema.getNbTargetAttributes(); ++k5) {
                NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k5];
                xiR[k5] = ((ClusAttrType)type).getNumeric(exi);
            }
            double WR = 0.0;
            for (int j = M; j < N; ++j) {
                DataTuple exj = this.m_Data.getTuple(j);
                for (int k6 = 0; k6 < schema.getNbTargetAttributes(); ++k6) {
                    NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k6];
                    xjR[k6] = ((ClusAttrType)type).getNumeric(exj);
                }
                double w = 0.0;
                long indexI = i;
                long indexJ = j;
                if (i != j) {
                    long indexMap;
                    Double temp;
                    if (i > j) {
                        indexI = j;
                        indexJ = i;
                    }
                    w = (temp = GISHeuristic.m_distances.get(indexMap = indexI * NR + indexJ)) != null ? temp : 0.0;
                    double[] dArray = upsumR[0];
                    int n = i - M;
                    dArray[n] = dArray[n] + w * (xjR[0] - meansR[0]);
                    double[] dArray4 = upsumR[1];
                    int n4 = i - M;
                    dArray4[n4] = dArray4[n4] + w * (xjR[1] - meansR[1]);
                    WR += w;
                    continue;
                }
                double[] dArray = upsumR[0];
                int n = i - M;
                dArray[n] = dArray[n] + (xiR[0] - meansR[0]);
                double[] dArray5 = upsumR[1];
                int n5 = i - M;
                dArray5[n5] = dArray5[n5] + (xiR[1] - meansR[1]);
                WR += 1.0;
            }
            WRR += WR * WR;
            upsumR0 += upsumR[0][i - M] * upsumR[1][i - M];
            downsumR0 += (xiR[0] - meansR[0]) * (xiR[0] - meansR[0]);
            downsumR1 += (xiR[1] - meansR[1]) * (xiR[1] - meansR[1]);
        }
        IR = upsumR0 != 0.0 && upsumR1 != 0.0 && downsumR0 != 0.0 && downsumR1 != 0.0 ? ((double)(N - M) + 0.0) * upsumR0 * upsumR1 / (WRR * Math.sqrt(downsumR0 * downsumR1)) : 0.0;
        double I = (IL + IR * (double)(N - M)) / (double)NR;
        double scaledI = 1.0 + I;
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return scaledI;
    }

    @Override
    public double calcLeewithNeighbours(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_Data.getSchema();
        if (schema.getNbTargetAttributes() == 1) {
            throw new ClusException("Error calculating Bivariate Heuristics with only one target!");
        }
        int M = 0;
        int N = this.m_Data.getNbRows();
        if (this.m_SplitIndex > 0) {
            N = this.m_SplitIndex;
        } else {
            M = -this.m_SplitIndex;
        }
        double[][] upsum = new double[schema.getNbTargetAttributes()][N - M];
        double[] means = new double[schema.getNbTargetAttributes()];
        double[] xi = new double[schema.getNbTargetAttributes()];
        double[] xj = new double[schema.getNbTargetAttributes()];
        int k = 0;
        while (k < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k];
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                double m = ((ClusAttrType)type).getNumeric(exi);
                int n = k;
                means[n] = means[n] + m;
            }
            int n = k++;
            means[n] = means[n] / (double)(N - M);
        }
        double avgik = 0.0;
        double upsum0 = 0.0;
        double upsum1 = 1.0;
        double downsum0 = 0.0;
        double downsum1 = 0.0;
        double WL = 0.0;
        int NeighCount = (int)schema.getSettings().getTree().getNumNeightbours();
        SettingsTree.SpatialMatrixType spatialMatrix = schema.getSettings().getTree().getSpatialMatrix();
        int NN2 = N - M < NeighCount ? N - M : M + NeighCount;
        if (NeighCount > 0) {
            double[][] w = new double[N][N];
            for (int i = M; i < N; ++i) {
                int j;
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                double yyi = 0.0;
                double xxi = 0.0;
                double W = 0.0;
                for (int k2 = 0; k2 < schema.getNbTargetAttributes(); ++k2) {
                    NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k2];
                    NumericAttrType xt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
                    NumericAttrType yt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[1];
                    xi[k2] = ((ClusAttrType)type).getNumeric(exi);
                    xxi = ((ClusAttrType)xt).getNumeric(exi);
                    yyi = ((ClusAttrType)yt).getNumeric(exi);
                }
                double biggestd = Double.POSITIVE_INFINITY;
                int biggestindex = Integer.MAX_VALUE;
                DistanceB[] distances = new DistanceB[NeighCount];
                double yyj = 0.0;
                double xxj = 0.0;
                for (j = M; j < N; ++j) {
                    DataTuple exj = this.m_Data.getTuple(j);
                    for (int k3 = 0; k3 < schema.getNbTargetAttributes(); ++k3) {
                        NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k3];
                        NumericAttrType xt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
                        NumericAttrType yt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[1];
                        xj[k3] = ((ClusAttrType)type).getNumeric(exj);
                        xxj = ((ClusAttrType)xt).getNumeric(exi);
                        yyj = ((ClusAttrType)yt).getNumeric(exi);
                    }
                    double d = Math.sqrt((xxi - xxj) * (xxi - xxj) + (yyi - yyj) * (yyi - yyj));
                    if (N - M < NeighCount) {
                        distances[j] = new DistanceB(j, xj[0], xj[1], d);
                        continue;
                    }
                    if (j < NeighCount) {
                        distances[j] = new DistanceB(j, xj[0], xj[1], d);
                        continue;
                    }
                    biggestd = distances[0].distance;
                    biggestindex = 0;
                    for (int a = 1; a < NeighCount; ++a) {
                        if (!(distances[a].distance > biggestd)) continue;
                        biggestd = distances[a].distance;
                        biggestindex = a;
                    }
                    if (!(d < biggestd)) continue;
                    distances[biggestindex].index = j;
                    distances[biggestindex].distance = d;
                    distances[biggestindex].target1 = xj[0];
                    distances[biggestindex].target2 = xj[1];
                }
                for (j = M; j < NN2; ++j) {
                    if (distances[j].distance == 0.0) {
                        w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                    } else {
                        switch (spatialMatrix) {
                            case Binary: {
                                w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                break;
                            }
                            case Euclidean: {
                                w[permutation[i].intValue()][permutation[j].intValue()] = 1.0 / distances[j].distance;
                                break;
                            }
                            case Modified: {
                                w[permutation[i].intValue()][permutation[j].intValue()] = (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount)) * (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount));
                                break;
                            }
                            case Gaussian: {
                                w[permutation[i].intValue()][permutation[j].intValue()] = Math.exp(-(distances[j].distance * distances[j].distance) / (double)(NeighCount * NeighCount));
                                break;
                            }
                            default: {
                                w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                            }
                        }
                    }
                    double[] dArray = upsum[0];
                    int n = permutation[i];
                    dArray[n] = dArray[n] + w[permutation[i]][permutation[j]] * (xj[0] - means[0]);
                    double[] dArray2 = upsum[1];
                    int n2 = permutation[i];
                    dArray2[n2] = dArray2[n2] + w[permutation[i]][permutation[j]] * (xj[1] - means[1]);
                    W += w[permutation[i]][permutation[j]];
                }
                WL += W * W;
                upsum0 += upsum[0][permutation[i]] * upsum[1][permutation[i]];
                downsum0 += (xi[0] - means[0]) * (xi[0] - means[0]);
                downsum1 += (xi[1] - means[1]) * (xi[1] - means[1]);
            }
        }
        avgik = upsum0 != 0.0 && upsum1 != 0.0 && downsum0 != 0.0 && downsum1 != 0.0 ? ((double)(N - M) + 0.0) * upsum0 * upsum1 / (WL * Math.sqrt(downsum0 * downsum1)) : 0.0;
        double IL = avgik * (double)(N - M);
        N = this.m_Data.getNbRows();
        M = this.m_SplitIndex;
        double[][] upsumR = new double[schema.getNbTargetAttributes()][N - M];
        double[] meansR = new double[schema.getNbTargetAttributes()];
        double[] xRi = new double[schema.getNbTargetAttributes()];
        double[] xRj = new double[schema.getNbTargetAttributes()];
        int k4 = 0;
        while (k4 < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k4];
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                double m = ((ClusAttrType)type).getNumeric(exi);
                int n = k4;
                meansR[n] = meansR[n] + m;
            }
            int n = k4++;
            meansR[n] = meansR[n] / (double)(N - M);
        }
        double avgikR = 0.0;
        double upsumR0 = 0.0;
        double upsumR1 = 1.0;
        double downsumR0 = 0.0;
        double downsumR1 = 0.0;
        double WRR = 0.0;
        if (NeighCount > 0) {
            double[][] w = new double[N][N];
            for (int i = M; i < N; ++i) {
                int j;
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                double yyi = 0.0;
                double xxi = 0.0;
                double WR = 0.0;
                for (int k5 = 0; k5 < schema.getNbTargetAttributes(); ++k5) {
                    NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k5];
                    NumericAttrType xt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
                    NumericAttrType yt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[1];
                    xRi[k5] = ((ClusAttrType)type).getNumeric(exi);
                    xxi = ((ClusAttrType)xt).getNumeric(exi);
                    yyi = ((ClusAttrType)yt).getNumeric(exi);
                }
                double biggestd = Double.POSITIVE_INFINITY;
                int biggestindex = Integer.MAX_VALUE;
                int a = 0;
                DistanceB[] distances = new DistanceB[NeighCount];
                double yyj = 0.0;
                double xxj = 0.0;
                for (j = M; j < N; ++j) {
                    DataTuple exj = this.m_Data.getTuple(j);
                    for (int k6 = 0; k6 < schema.getNbTargetAttributes(); ++k6) {
                        NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k6];
                        NumericAttrType xt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
                        NumericAttrType yt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[1];
                        xRj[k6] = ((ClusAttrType)type).getNumeric(exj);
                        xxj = ((ClusAttrType)xt).getNumeric(exi);
                        yyj = ((ClusAttrType)yt).getNumeric(exi);
                    }
                    double d = Math.sqrt((xxi - xxj) * (xxi - xxj) + (yyi - yyj) * (yyi - yyj));
                    if (N - M < NeighCount) {
                        distances[a] = new DistanceB(j, xRj[0], xRj[1], d);
                        ++a;
                        continue;
                    }
                    if (a < NeighCount) {
                        distances[a] = new DistanceB(j, xRj[0], xRj[1], d);
                        ++a;
                        continue;
                    }
                    biggestindex = 0;
                    biggestd = distances[0].distance;
                    for (a = 1; a < NeighCount; ++a) {
                        if (!(distances[a].distance > biggestd)) continue;
                        biggestd = distances[a].distance;
                        biggestindex = a;
                    }
                    if (!(d < biggestd)) continue;
                    distances[biggestindex].index = j;
                    distances[biggestindex].distance = d;
                    distances[biggestindex].target1 = xRj[0];
                    distances[biggestindex].target2 = xRj[1];
                }
                j = 0;
                while (distances.length > j && distances[j] != null && j < NeighCount) {
                    if (distances[j].distance == 0.0) {
                        w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                    } else {
                        switch (spatialMatrix) {
                            case Binary: {
                                w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                break;
                            }
                            case Euclidean: {
                                w[permutation[i].intValue()][permutation[j].intValue()] = 1.0 / distances[j].distance;
                                break;
                            }
                            case Modified: {
                                w[permutation[i].intValue()][permutation[j].intValue()] = (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount)) * (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount));
                                break;
                            }
                            case Gaussian: {
                                w[permutation[i].intValue()][permutation[j].intValue()] = Math.exp(-(distances[j].distance * distances[j].distance) / (double)(NeighCount * NeighCount));
                                break;
                            }
                            default: {
                                w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                            }
                        }
                    }
                    double[] dArray = upsumR[0];
                    int n = permutation[i];
                    dArray[n] = dArray[n] + w[permutation[i]][permutation[j]] * (xRj[0] - meansR[0]);
                    double[] dArray3 = upsumR[1];
                    int n3 = permutation[i];
                    dArray3[n3] = dArray3[n3] + w[permutation[i]][permutation[j]] * (xRj[1] - meansR[1]);
                    WR += w[permutation[i]][permutation[j]];
                }
                WRR += WR * WR;
                upsumR0 += upsumR[0][permutation[i]] * upsumR[1][permutation[i]];
                downsumR0 += (xRi[0] - meansR[0]) * (xRi[0] - meansR[0]);
                downsumR1 += (xRi[1] - meansR[1]) * (xRi[1] - meansR[1]);
            }
        }
        avgikR = upsumR0 != 0.0 && upsumR1 != 0.0 && downsumR0 != 0.0 && downsumR1 != 0.0 ? ((double)(N - M) + 0.0) * upsumR0 * upsumR1 / (WRR * Math.sqrt(downsumR0 * downsumR1)) : 0.0;
        double IR = avgikR * (double)(N - M);
        double I = (IL + IR * (double)(N - M)) / (double)this.m_Data.getNbRows();
        double scaledI = 1.0 + I;
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return scaledI;
    }

    @Override
    public double calcMutivariateItotal(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_Data.getSchema();
        if (schema.getNbTargetAttributes() == 1) {
            throw new ClusException("Error calculating Bivariate Heuristics with only one target!");
        }
        int M = 0;
        int N = this.m_Data.getNbRows();
        long NR = this.m_Data.getNbRows();
        if (this.m_SplitIndex > 0) {
            N = this.m_SplitIndex;
        } else {
            M = -this.m_SplitIndex;
        }
        double upsum = 0.0;
        double downsumAll = 1.0;
        double ikk = 0.0;
        double W = 0.0;
        double[] downsum = new double[schema.getNbTargetAttributes()];
        double[] means = new double[schema.getNbTargetAttributes()];
        double[] xi = new double[schema.getNbTargetAttributes()];
        double[] xj = new double[schema.getNbTargetAttributes()];
        int k = 0;
        while (k < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k];
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                double xxi = ((ClusAttrType)type).getNumeric(exi);
                int n = k;
                means[n] = means[n] + xxi;
            }
            int n = k++;
            means[n] = means[n] / (double)(N - M);
        }
        for (int i = M; i < N; ++i) {
            int k2;
            DataTuple exi = this.m_Data.getTuple(permutation[i]);
            for (k2 = 0; k2 < schema.getNbTargetAttributes(); ++k2) {
                NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k2];
                xi[k2] = ((ClusAttrType)type).getNumeric(exi);
            }
            for (int j = M; j < N; ++j) {
                long indexMap;
                Double temp;
                DataTuple exj = this.m_Data.getTuple(j);
                for (int k3 = 0; k3 < schema.getNbTargetAttributes(); ++k3) {
                    NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k3];
                    xj[k3] = ((ClusAttrType)type).getNumeric(exj);
                }
                double w = 0.0;
                long indexI = i;
                long indexJ = j;
                if (i == j) continue;
                if (i > j) {
                    indexI = j;
                    indexJ = i;
                }
                w = (temp = GISHeuristic.m_distances.get(indexMap = indexI * NR + indexJ)) != null ? temp : 0.0;
                upsum += w * (xi[0] - means[0]) * (xj[1] - means[1]);
                W += w;
            }
            for (k2 = 0; k2 < schema.getNbTargetAttributes(); ++k2) {
                int n = k2;
                downsum[n] = downsum[n] + (xi[k2] - means[k2]) * (xi[k2] - means[k2]);
            }
        }
        for (k = 0; k < schema.getNbTargetAttributes(); ++k) {
            downsumAll *= downsum[k];
        }
        ikk = downsumAll > 0.0 && upsum != 0.0 ? ((double)(N - M) + 0.0) * upsum / (W * Math.sqrt(downsumAll)) : 0.0;
        double IL = ikk * (double)(N - M);
        N = this.m_Data.getNbRows();
        M = this.m_SplitIndex;
        double upsumR = 0.0;
        double downsumAllR = 1.0;
        double ikkR = 0.0;
        double WR = 0.0;
        double[] downsumR = new double[schema.getNbTargetAttributes()];
        double[] meansR = new double[schema.getNbTargetAttributes()];
        double[] xiR = new double[schema.getNbTargetAttributes()];
        double[] xjR = new double[schema.getNbTargetAttributes()];
        int k4 = 0;
        while (k4 < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k4];
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                double xxi = ((ClusAttrType)type).getNumeric(exi);
                int n = k4;
                meansR[n] = meansR[n] + xxi;
            }
            int n = k4++;
            meansR[n] = meansR[n] / (double)(N - M);
        }
        for (int i = M; i < N; ++i) {
            int k5;
            DataTuple exi = this.m_Data.getTuple(permutation[i]);
            for (k5 = 0; k5 < schema.getNbTargetAttributes(); ++k5) {
                NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k5];
                xiR[k5] = ((ClusAttrType)type).getNumeric(exi);
            }
            for (int j = M; j < N; ++j) {
                long indexMap;
                Double temp;
                DataTuple exj = this.m_Data.getTuple(j);
                for (int k6 = 0; k6 < schema.getNbTargetAttributes(); ++k6) {
                    NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k6];
                    xjR[k6] = ((ClusAttrType)type).getNumeric(exj);
                }
                double w = 0.0;
                long indexI = i;
                long indexJ = j;
                if (i == j) continue;
                if (i > j) {
                    indexI = j;
                    indexJ = i;
                }
                w = (temp = GISHeuristic.m_distances.get(indexMap = indexI * NR + indexJ)) != null ? temp : 0.0;
                upsumR += w * (xiR[0] - meansR[0]) * (xjR[1] - meansR[1]);
                WR += w;
            }
            for (k5 = 0; k5 < schema.getNbTargetAttributes(); ++k5) {
                int n = k5;
                downsumR[n] = downsumR[n] + (xiR[k5] - meansR[k5]) * (xiR[k5] - meansR[k5]);
            }
        }
        for (k4 = 0; k4 < schema.getNbTargetAttributes(); ++k4) {
            downsumAllR *= downsumR[k4];
        }
        ikkR = downsumAllR > 0.0 && upsumR != 0.0 ? ((double)(N - M) + 0.0) * upsumR / (WR * Math.sqrt(downsumAllR)) : 0.0;
        double IR = ikkR;
        double I = (IL + IR * (double)(N - M)) / (double)N;
        double scaledI = 1.0 + I;
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return scaledI;
    }

    @Override
    public double calcCItotalD(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_Data.getSchema();
        NumericAttrType xt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
        int M = 0;
        int N = this.m_Data.getNbRows();
        if (this.m_SplitIndex > 0) {
            N = this.m_SplitIndex;
        } else {
            M = -this.m_SplitIndex;
        }
        double[] D = new double[N - M];
        double[] W = new double[N - M];
        double[][] w = new double[N - M][N - M];
        double[] ikk = new double[schema.getNbTargetAttributes()];
        double avgik = 0.0;
        for (int k = 0; k < schema.getNbTargetAttributes(); ++k) {
            int i;
            for (i = M; i < N; ++i) {
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                long xxi = (long)((ClusAttrType)xt).getNumeric(exi);
                for (int j = M; j < N; ++j) {
                    String indexMap;
                    Double temp;
                    long indexI = xxi;
                    DataTuple exj = this.m_Data.getTuple(j);
                    long yyi = (long)((ClusAttrType)xt).getNumeric(exj);
                    long indexJ = yyi;
                    if (indexI == indexJ) continue;
                    if (indexI > indexJ) {
                        indexI = yyi;
                        indexJ = xxi;
                    }
                    w[permutation[i].intValue()][permutation[j].intValue()] = (temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) != null ? temp : 0.0;
                    int n = permutation[i];
                    D[n] = D[n] + w[permutation[i]][permutation[j]];
                }
            }
            for (i = M; i < N; ++i) {
                for (int j = M; j < N; ++j) {
                    if (i == j || D[permutation[j]] == 0.0) continue;
                    int n = permutation[i];
                    W[n] = W[n] + Math.sqrt(D[permutation[j]]);
                }
                if (D[permutation[i]] == 0.0) continue;
                int n = k;
                ikk[n] = ikk[n] + Math.sqrt(D[permutation[i]]);
            }
            avgik += ikk[k];
        }
        double IL = avgik /= (double)schema.getNbTargetAttributes();
        if (Double.isNaN(IL)) {
            IL = 0.0;
        }
        N = this.m_Data.getNbRows();
        M = this.m_SplitIndex;
        double IR = 0.0;
        double[] DR = new double[N - M];
        double[] WR = new double[N - M];
        double[][] wr = new double[N - M][N - M];
        double[] ikkR = new double[schema.getNbTargetAttributes()];
        for (int k = 0; k < schema.getNbTargetAttributes(); ++k) {
            int i;
            for (i = M; i < N; ++i) {
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                long xxi = (long)((ClusAttrType)xt).getNumeric(exi);
                for (int j = M; j < N; ++j) {
                    String indexMap;
                    Double temp;
                    long indexI = xxi;
                    DataTuple exj = this.m_Data.getTuple(j);
                    long yyi = (long)((ClusAttrType)xt).getNumeric(exj);
                    long indexJ = yyi;
                    if (indexI == indexJ) continue;
                    if (indexI > indexJ) {
                        indexI = yyi;
                        indexJ = xxi;
                    }
                    wr[i - M][j - M] = (temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) != null && DR[i - M] != 0.0 ? temp : 0.0;
                    if (DR[i - M] == 0.0) continue;
                    int n = i - M;
                    DR[n] = DR[n] + wr[i - M][j - M];
                }
            }
            for (i = M; i < N; ++i) {
                for (int j = M; j < N; ++j) {
                    if (i == j || DR[j - M] == 0.0) continue;
                    int n = i - M;
                    WR[n] = WR[n] + wr[i - M][j - M] / Math.sqrt(DR[j - M]);
                }
                if (DR[i - M] == 0.0) continue;
                int n = k;
                ikkR[n] = ikkR[n] + WR[i - M] / Math.sqrt(DR[i - M]);
            }
            IR += ikkR[k];
        }
        if (Double.isNaN(IR /= (double)schema.getNbTargetAttributes())) {
            IR = 0.0;
        }
        double I = (IL + IR) / (double)this.m_Data.getNbRows();
        double scaledI = 1.0 + I;
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return scaledI;
    }

    @Override
    public double calcCItotal(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_Data.getSchema();
        int M = 0;
        int N = this.m_Data.getNbRows();
        long NR = this.m_Data.getNbRows();
        if (this.m_SplitIndex > 0) {
            N = this.m_SplitIndex;
        } else {
            M = -this.m_SplitIndex;
        }
        double[] D = new double[N - M];
        double[] W = new double[N - M];
        double[][] w = new double[N - M][N - M];
        double[] ikk = new double[schema.getNbTargetAttributes()];
        double avgik = 0.0;
        for (int k = 0; k < schema.getNbTargetAttributes(); ++k) {
            int j;
            int i;
            for (i = M; i < N; ++i) {
                for (j = M; j < N; ++j) {
                    long indexMap;
                    Double temp;
                    long indexI = i;
                    long indexJ = j;
                    if (i == j) continue;
                    if (i > j) {
                        indexI = j;
                        indexJ = i;
                    }
                    w[permutation[i].intValue()][permutation[j].intValue()] = (temp = GISHeuristic.m_distances.get(indexMap = indexI * NR + indexJ)) != null ? temp : 0.0;
                    int n = permutation[i];
                    D[n] = D[n] + w[permutation[i]][permutation[j]];
                }
            }
            for (i = M; i < N; ++i) {
                for (j = M; j < N; ++j) {
                    if (i == j || D[permutation[j]] == 0.0) continue;
                    int n = permutation[i];
                    W[n] = W[n] + w[permutation[i]][permutation[j]] / Math.sqrt(D[permutation[j]]);
                }
                if (D[permutation[i]] == 0.0) continue;
                int n = k;
                ikk[n] = ikk[n] + W[permutation[i]] / Math.sqrt(D[permutation[i]]);
            }
            avgik += ikk[k];
        }
        double IL = avgik /= (double)schema.getNbTargetAttributes();
        if (Double.isNaN(IL)) {
            IL = 0.0;
        }
        N = this.m_Data.getNbRows();
        M = this.m_SplitIndex;
        double IR = 0.0;
        double[] DR = new double[N - M];
        double[] WR = new double[N - M];
        double[][] wr = new double[N - M][N - M];
        double[] ikkR = new double[schema.getNbTargetAttributes()];
        for (int k = 0; k < schema.getNbTargetAttributes(); ++k) {
            int j;
            int i;
            for (i = M; i < N; ++i) {
                for (j = M; j < N; ++j) {
                    long indexMap;
                    Double temp;
                    long indexI = i;
                    long indexJ = j;
                    if (i == j) continue;
                    if (i > j) {
                        indexI = j;
                        indexJ = i;
                    }
                    wr[i - M][j - M] = (temp = GISHeuristic.m_distances.get(indexMap = indexI * NR + indexJ)) != null ? temp : 0.0;
                    int n = i - M;
                    DR[n] = DR[n] + wr[i - M][j - M];
                }
            }
            for (i = M; i < N; ++i) {
                for (j = M; j < N; ++j) {
                    if (i == j || DR[j - M] == 0.0) continue;
                    int n = i - M;
                    WR[n] = WR[n] + wr[i - M][j - M] / Math.sqrt(DR[j - M]);
                }
                if (DR[i - M] == 0.0) continue;
                int n = k;
                ikkR[n] = ikkR[n] + WR[i - M] / Math.sqrt(DR[i - M]);
            }
            IR += ikkR[k];
        }
        if (Double.isNaN(IR /= (double)schema.getNbTargetAttributes())) {
            IR = 0.0;
        }
        double I = (IL + IR) / (double)this.m_Data.getNbRows();
        double scaledI = 1.0 + I;
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return scaledI;
    }

    @Override
    public double calcCIwithNeighbours(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_Data.getSchema();
        int M = 0;
        int N = this.m_Data.getNbRows();
        if (this.m_SplitIndex > 0) {
            N = this.m_SplitIndex;
        } else {
            M = -this.m_SplitIndex;
        }
        double[] ikk = new double[schema.getNbTargetAttributes()];
        double avgik = 0.0;
        for (int k = 0; k < schema.getNbTargetAttributes(); ++k) {
            NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k];
            int NeighCount = (int)schema.getSettings().getTree().getNumNeightbours();
            double[] D = new double[N - M];
            double[] W = new double[N - M];
            if (NeighCount > 0) {
                int i;
                double[][] w = new double[N][N];
                Distance[] distances = new Distance[NeighCount];
                double biggestd = Double.POSITIVE_INFINITY;
                int biggestindex = Integer.MAX_VALUE;
                SettingsTree.SpatialMatrixType spatialMatrix = schema.getSettings().getTree().getSpatialMatrix();
                int NN2 = N - M < NeighCount ? N - M : M + NeighCount;
                for (i = M; i < N; ++i) {
                    int j;
                    DataTuple exi = this.m_Data.getTuple(permutation[i]);
                    NumericAttrType xt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
                    NumericAttrType yt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[1];
                    double xi = ((ClusAttrType)xt).getNumeric(exi);
                    double yi = ((ClusAttrType)yt).getNumeric(exi);
                    for (j = M; j < N; ++j) {
                        DataTuple exj = this.m_Data.getTuple(j);
                        double tj = ((ClusAttrType)type).getNumeric(exj);
                        double xj = ((ClusAttrType)xt).getNumeric(exj);
                        double yj = ((ClusAttrType)yt).getNumeric(exj);
                        double d = Math.sqrt((xi - xj) * (xi - xj) + (yi - yj) * (yi - yj));
                        if (N - M < NeighCount) {
                            distances[j] = new Distance(j, tj, d);
                            continue;
                        }
                        if (j < NeighCount) {
                            distances[j] = new Distance(j, tj, d);
                            continue;
                        }
                        biggestd = distances[0].distance;
                        biggestindex = 0;
                        for (int a = 1; a < NeighCount; ++a) {
                            if (!(distances[a].distance > biggestd)) continue;
                            biggestd = distances[a].distance;
                            biggestindex = a;
                        }
                        if (!(d < biggestd)) continue;
                        distances[biggestindex].index = j;
                        distances[biggestindex].target = tj;
                        distances[biggestindex].distance = d;
                    }
                    for (j = M; j < NN2; ++j) {
                        if (distances[j].distance == 0.0) {
                            w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                        } else {
                            switch (spatialMatrix) {
                                case Binary: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                    break;
                                }
                                case Euclidean: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0 / distances[j].distance;
                                    break;
                                }
                                case Modified: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount)) * (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount));
                                    break;
                                }
                                case Gaussian: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = Math.exp(-(distances[j].distance * distances[j].distance) / (double)(NeighCount * NeighCount));
                                    break;
                                }
                                default: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                }
                            }
                        }
                        int n = permutation[i];
                        D[n] = D[n] + w[permutation[i]][permutation[j]];
                    }
                }
                for (i = M; i < N; ++i) {
                    for (int j = M; j < NN2; ++j) {
                        if (distances[j].distance == 0.0) {
                            w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                        } else {
                            switch (spatialMatrix) {
                                case Binary: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                    break;
                                }
                                case Euclidean: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0 / distances[j].distance;
                                    break;
                                }
                                case Modified: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount)) * (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount));
                                    break;
                                }
                                case Gaussian: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = Math.exp(-(distances[j].distance * distances[j].distance) / (double)(NeighCount * NeighCount));
                                    break;
                                }
                                default: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                }
                            }
                        }
                        int n = permutation[i];
                        W[n] = W[n] + w[permutation[i]][permutation[j]] / Math.sqrt(D[permutation[j]]);
                    }
                    int n = k;
                    ikk[n] = ikk[n] + W[permutation[i]] / Math.sqrt(D[permutation[i]]);
                }
            }
            avgik += ikk[k];
        }
        double IL = (avgik /= (double)schema.getNbTargetAttributes()) * (double)(N - M);
        N = this.m_Data.getNbRows();
        M = this.m_SplitIndex;
        double[] ikkR = new double[schema.getNbTargetAttributes()];
        double avgikR = 0.0;
        for (int k = 0; k < schema.getNbTargetAttributes(); ++k) {
            NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k];
            int NeighCount = (int)schema.getSettings().getTree().getNumNeightbours();
            double[] DR = new double[N - M];
            double[] WR = new double[N - M];
            if (NeighCount > 0) {
                int i;
                double[][] w = new double[N][N];
                Distance[] distances = new Distance[NeighCount];
                double biggestd = Double.POSITIVE_INFINITY;
                int biggestindex = Integer.MAX_VALUE;
                SettingsTree.SpatialMatrixType spatialMatrix = schema.getSettings().getTree().getSpatialMatrix();
                for (i = M; i < N; ++i) {
                    int j;
                    DataTuple exi = this.m_Data.getTuple(permutation[i]);
                    NumericAttrType xt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
                    NumericAttrType yt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[1];
                    double xi = ((ClusAttrType)xt).getNumeric(exi);
                    double yi = ((ClusAttrType)yt).getNumeric(exi);
                    int a = 0;
                    for (j = M; j < N; ++j) {
                        DataTuple exj = this.m_Data.getTuple(j);
                        double tj = ((ClusAttrType)type).getNumeric(exj);
                        double xj = ((ClusAttrType)xt).getNumeric(exj);
                        double yj = ((ClusAttrType)yt).getNumeric(exj);
                        double d = Math.sqrt((xi - xj) * (xi - xj) + (yi - yj) * (yi - yj));
                        if (N - M < NeighCount) {
                            distances[a] = new Distance(j, tj, d);
                            ++a;
                            continue;
                        }
                        if (a < NeighCount) {
                            distances[a] = new Distance(j, tj, d);
                            ++a;
                            continue;
                        }
                        biggestd = distances[0].distance;
                        biggestindex = 0;
                        for (a = 1; a < NeighCount; ++a) {
                            if (!(distances[a].distance > biggestd)) continue;
                            biggestd = distances[a].distance;
                            biggestindex = a;
                        }
                        if (!(d < biggestd)) continue;
                        distances[biggestindex].index = j;
                        distances[biggestindex].target = tj;
                        distances[biggestindex].distance = d;
                    }
                    j = 0;
                    while (j < NeighCount) {
                        if (distances[j].distance == 0.0) {
                            w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                        } else {
                            switch (spatialMatrix) {
                                case Binary: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                    break;
                                }
                                case Euclidean: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0 / distances[j].distance;
                                    break;
                                }
                                case Modified: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount)) * (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount));
                                    break;
                                }
                                case Gaussian: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = Math.exp(-(distances[j].distance * distances[j].distance) / (double)(NeighCount * NeighCount));
                                    break;
                                }
                                default: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                }
                            }
                        }
                        int n = permutation[i];
                        DR[n] = DR[n] + w[permutation[i]][permutation[j]];
                    }
                }
                for (i = M; i < N; ++i) {
                    for (int j = M; j < N; ++j) {
                        if (distances[j].distance == 0.0) {
                            w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                        } else {
                            switch (spatialMatrix) {
                                case Binary: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                    break;
                                }
                                case Euclidean: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0 / distances[j].distance;
                                    break;
                                }
                                case Modified: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount)) * (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount));
                                    break;
                                }
                                case Gaussian: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = Math.exp(-(distances[j].distance * distances[j].distance) / (double)(NeighCount * NeighCount));
                                    break;
                                }
                                default: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                }
                            }
                        }
                        int n = permutation[i];
                        WR[n] = WR[n] + w[permutation[i]][permutation[j]] / Math.sqrt(DR[permutation[j]]);
                    }
                    int n = k;
                    ikkR[n] = ikkR[n] + WR[permutation[i]] / Math.sqrt(DR[permutation[i]]);
                }
            }
            avgikR += ikkR[k];
        }
        double IR = avgikR /= (double)schema.getNbTargetAttributes();
        double I = (IL + IR * (double)(N - M)) / (double)this.m_Data.getNbRows();
        double scaledI = 1.0 + I;
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return scaledI;
    }

    @Override
    public double calcCwithNeighbourstotal(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_Data.getSchema();
        int M = 0;
        int N = this.m_Data.getNbRows();
        if (this.m_SplitIndex > 0) {
            N = this.m_SplitIndex;
        } else {
            M = -this.m_SplitIndex;
        }
        double[] upsum = new double[schema.getNbTargetAttributes()];
        double[] downsum = new double[schema.getNbTargetAttributes()];
        double[] means = new double[schema.getNbTargetAttributes()];
        double[] ikk = new double[schema.getNbTargetAttributes()];
        int k = 0;
        while (k < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k];
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNumeric(exi);
                int n = k;
                means[n] = means[n] + xi;
            }
            int n = k++;
            means[n] = means[n] / (double)(N - M);
        }
        double avgik = 0.0;
        for (int k2 = 0; k2 < schema.getNbTargetAttributes(); ++k2) {
            NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k2];
            int NeighCount = (int)schema.getSettings().getTree().getNumNeightbours();
            double W = 0.0;
            if (NeighCount > 0) {
                double[][] w = new double[N][N];
                for (int i = M; i < N; ++i) {
                    Distance[] distances = new Distance[NeighCount];
                    DataTuple exi = this.m_Data.getTuple(permutation[i]);
                    NumericAttrType xt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
                    NumericAttrType yt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[1];
                    double ti = ((ClusAttrType)type).getNumeric(exi);
                    double xi = ((ClusAttrType)xt).getNumeric(exi);
                    double yi = ((ClusAttrType)yt).getNumeric(exi);
                    double biggestd = Double.POSITIVE_INFINITY;
                    int biggestindex = Integer.MAX_VALUE;
                    for (int j = M; j < N; ++j) {
                        DataTuple exj = this.m_Data.getTuple(j);
                        double tj = ((ClusAttrType)type).getNumeric(exj);
                        double xj = ((ClusAttrType)xt).getNumeric(exj);
                        double yj = ((ClusAttrType)yt).getNumeric(exj);
                        double d = Math.sqrt((xi - xj) * (xi - xj) + (yi - yj) * (yi - yj));
                        if (N - M < NeighCount) {
                            distances[j] = new Distance(j, tj, d);
                            continue;
                        }
                        if (j < NeighCount) {
                            distances[j] = new Distance(j, tj, d);
                            continue;
                        }
                        biggestd = distances[0].distance;
                        biggestindex = 0;
                        for (int a = 1; a < NeighCount; ++a) {
                            if (!(distances[a].distance > biggestd)) continue;
                            biggestd = distances[a].distance;
                            biggestindex = a;
                        }
                        if (!(d < biggestd)) continue;
                        distances[biggestindex].index = j;
                        distances[biggestindex].target = tj;
                        distances[biggestindex].distance = d;
                    }
                    SettingsTree.SpatialMatrixType spatialMatrix = schema.getSettings().getTree().getSpatialMatrix();
                    int NN2 = N - M < NeighCount ? N - M : M + NeighCount;
                    for (int j = M; j < NN2; ++j) {
                        if (distances[j].distance == 0.0) {
                            w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                        } else {
                            switch (spatialMatrix) {
                                case Binary: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                    break;
                                }
                                case Euclidean: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0 / distances[j].distance;
                                    break;
                                }
                                case Modified: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount)) * (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount));
                                    break;
                                }
                                case Gaussian: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = Math.exp(-(distances[j].distance * distances[j].distance) / (double)(NeighCount * NeighCount));
                                    break;
                                }
                                default: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                }
                            }
                        }
                        int n = k2;
                        upsum[n] = upsum[n] + w[permutation[i]][permutation[j]] * (ti - distances[j].target) * (ti - distances[j].target);
                        W += w[permutation[i]][permutation[j]];
                    }
                    int n = k2;
                    downsum[n] = downsum[n] + (ti - means[k2]) * (ti - means[k2]);
                }
            }
            int n = k2;
            downsum[n] = downsum[n] / ((double)(N - M - 1) + 0.0);
            if (downsum[k2] != 0.0 && upsum[k2] != 0.0) {
                ikk[k2] = upsum[k2] / (2.0 * W * downsum[k2]);
                avgik += ikk[k2];
                continue;
            }
            avgik = 1.0;
        }
        double IL = (avgik /= (double)schema.getNbTargetAttributes()) * (double)(N - M);
        N = this.m_Data.getNbRows();
        M = this.m_SplitIndex;
        double[] upsumR = new double[schema.getNbTargetAttributes()];
        double[] downsumR = new double[schema.getNbTargetAttributes()];
        double[] meansR = new double[schema.getNbTargetAttributes()];
        double[] ikkR = new double[schema.getNbTargetAttributes()];
        int k3 = 0;
        while (k3 < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k3];
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNumeric(exi);
                int n = k3;
                meansR[n] = meansR[n] + xi;
            }
            int n = k3++;
            meansR[n] = meansR[n] / (double)(N - M);
        }
        double avgikR = 0.0;
        for (int k4 = 0; k4 < schema.getNbTargetAttributes(); ++k4) {
            NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k4];
            int NeighCount = (int)schema.getSettings().getTree().getNumNeightbours();
            double WR = 0.0;
            if (NeighCount > 0) {
                double[][] w = new double[N][N];
                for (int i = M; i < N; ++i) {
                    Distance[] distances = new Distance[NeighCount];
                    DataTuple exi = this.m_Data.getTuple(permutation[i]);
                    NumericAttrType xt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
                    NumericAttrType yt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[1];
                    double ti = ((ClusAttrType)type).getNumeric(exi);
                    double xi = ((ClusAttrType)xt).getNumeric(exi);
                    double yi = ((ClusAttrType)yt).getNumeric(exi);
                    int a = 0;
                    double biggestd = Double.POSITIVE_INFINITY;
                    int biggestindex = Integer.MAX_VALUE;
                    for (int j = M; j < N; ++j) {
                        DataTuple exj = this.m_Data.getTuple(j);
                        double tj = ((ClusAttrType)type).getNumeric(exj);
                        double xj = ((ClusAttrType)xt).getNumeric(exj);
                        double yj = ((ClusAttrType)yt).getNumeric(exj);
                        double d = Math.sqrt((xi - xj) * (xi - xj) + (yi - yj) * (yi - yj));
                        if (N - M < NeighCount) {
                            distances[a] = new Distance(j, tj, d);
                            ++a;
                            continue;
                        }
                        if (a < NeighCount) {
                            distances[a] = new Distance(j, tj, d);
                            ++a;
                            continue;
                        }
                        biggestd = distances[0].distance;
                        biggestindex = 0;
                        for (a = 1; a < NeighCount; ++a) {
                            if (!(distances[a].distance > biggestd)) continue;
                            biggestd = distances[a].distance;
                            biggestindex = a;
                        }
                        if (!(d < biggestd)) continue;
                        distances[biggestindex].index = j;
                        distances[biggestindex].target = tj;
                        distances[biggestindex].distance = d;
                    }
                    SettingsTree.SpatialMatrixType spatialMatrix = schema.getSettings().getTree().getSpatialMatrix();
                    for (int j = 0; distances.length > j && distances[j] != null && j < NeighCount; ++j) {
                        if (distances[j].distance == 0.0) {
                            w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                        } else {
                            switch (spatialMatrix) {
                                case Binary: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                    break;
                                }
                                case Euclidean: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0 / distances[j].distance;
                                    break;
                                }
                                case Modified: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount)) * (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount));
                                    break;
                                }
                                case Gaussian: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = Math.exp(-(distances[j].distance * distances[j].distance) / (double)(NeighCount * NeighCount));
                                    break;
                                }
                                default: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                }
                            }
                        }
                        int n = k4;
                        upsumR[n] = upsumR[n] + w[permutation[i]][permutation[j]] * (ti - distances[j].target) * (ti - distances[j].target);
                        WR += w[permutation[i]][permutation[j]];
                    }
                    int n = k4;
                    downsumR[n] = downsumR[n] + (ti - meansR[k4]) * (ti - meansR[k4]);
                }
            }
            int n = k4;
            downsumR[n] = downsumR[n] / ((double)(N - M - 1) + 0.0);
            if (downsumR[k4] != 0.0 && upsumR[k4] != 0.0) {
                ikkR[k4] = upsumR[k4] / (2.0 * WR * downsumR[k4]);
                avgikR += ikkR[k4];
                continue;
            }
            avgikR = 1.0;
        }
        double IR = avgikR /= (double)schema.getNbTargetAttributes();
        double I = 2.0 - (IL + IR * (double)(N - M)) / (double)this.m_Data.getNbRows();
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return I;
    }

    @Override
    public double calcIwithNeighbourstotal(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_Data.getSchema();
        int M = 0;
        int N = this.m_Data.getNbRows();
        if (this.m_SplitIndex > 0) {
            N = this.m_SplitIndex;
        } else {
            M = -this.m_SplitIndex;
        }
        double[] upsum = new double[schema.getNbTargetAttributes()];
        double[] downsum = new double[schema.getNbTargetAttributes()];
        double[] means = new double[schema.getNbTargetAttributes()];
        double[] ikk = new double[schema.getNbTargetAttributes()];
        int k = 0;
        while (k < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k];
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNumeric(exi);
                int n = k;
                means[n] = means[n] + xi;
            }
            int n = k++;
            means[n] = means[n] / (double)(N - M);
        }
        double avgik = 0.0;
        for (int k2 = 0; k2 < schema.getNbTargetAttributes(); ++k2) {
            NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k2];
            int NeighCount = (int)schema.getSettings().getTree().getNumNeightbours();
            double W = 0.0;
            if (NeighCount > 0) {
                double[][] w = new double[N][N];
                for (int i = M; i < N; ++i) {
                    Distance[] distances = new Distance[NeighCount];
                    DataTuple exi = this.m_Data.getTuple(permutation[i]);
                    NumericAttrType xt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
                    NumericAttrType yt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[1];
                    double ti = ((ClusAttrType)type).getNumeric(exi);
                    double xi = ((ClusAttrType)xt).getNumeric(exi);
                    double yi = ((ClusAttrType)yt).getNumeric(exi);
                    double biggestd = Double.POSITIVE_INFINITY;
                    int biggestindex = Integer.MAX_VALUE;
                    for (int j = M; j < N; ++j) {
                        DataTuple exj = this.m_Data.getTuple(j);
                        double tj = ((ClusAttrType)type).getNumeric(exj);
                        double xj = ((ClusAttrType)xt).getNumeric(exj);
                        double yj = ((ClusAttrType)yt).getNumeric(exj);
                        double d = Math.sqrt((xi - xj) * (xi - xj) + (yi - yj) * (yi - yj));
                        if (N - M < NeighCount) {
                            distances[j] = new Distance(j, tj, d);
                            continue;
                        }
                        if (j < NeighCount) {
                            distances[j] = new Distance(j, tj, d);
                            continue;
                        }
                        biggestd = distances[0].distance;
                        biggestindex = 0;
                        for (int a = 1; a < NeighCount; ++a) {
                            if (!(distances[a].distance > biggestd)) continue;
                            biggestd = distances[a].distance;
                            biggestindex = a;
                        }
                        if (!(d < biggestd)) continue;
                        distances[biggestindex].index = j;
                        distances[biggestindex].target = tj;
                        distances[biggestindex].distance = d;
                    }
                    SettingsTree.SpatialMatrixType spatialMatrix = schema.getSettings().getTree().getSpatialMatrix();
                    int NN2 = N - M < NeighCount ? N - M : M + NeighCount;
                    for (int j = M; j < NN2; ++j) {
                        if (distances[j].distance == 0.0) {
                            w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                        } else {
                            switch (spatialMatrix) {
                                case Binary: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                    break;
                                }
                                case Euclidean: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0 / distances[j].distance;
                                    break;
                                }
                                case Modified: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount)) * (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount));
                                    break;
                                }
                                case Gaussian: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = Math.exp(-(distances[j].distance * distances[j].distance) / (double)(NeighCount * NeighCount));
                                    break;
                                }
                                default: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                }
                            }
                        }
                        int n = k2;
                        upsum[n] = upsum[n] + w[permutation[i]][permutation[j]] * (ti - means[k2]) * (distances[j].target - means[k2]);
                        W += w[permutation[i]][permutation[j]];
                    }
                    int n = k2;
                    downsum[n] = downsum[n] + (ti - means[k2]) * (ti - means[k2]);
                }
            }
            int n = k2;
            downsum[n] = downsum[n] / ((double)(N - M) + 0.0);
            if (downsum[k2] != 0.0 && upsum[k2] != 0.0) {
                ikk[k2] = upsum[k2] / (W * downsum[k2]);
                avgik += ikk[k2];
                continue;
            }
            avgik = 1.0;
        }
        double IL = (avgik /= (double)schema.getNbTargetAttributes()) * (double)(N - M);
        N = this.m_Data.getNbRows();
        M = this.m_SplitIndex;
        double[] upsumR = new double[schema.getNbTargetAttributes()];
        double[] downsumR = new double[schema.getNbTargetAttributes()];
        double[] meansR = new double[schema.getNbTargetAttributes()];
        double[] ikkR = new double[schema.getNbTargetAttributes()];
        int k3 = 0;
        while (k3 < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k3];
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNumeric(exi);
                int n = k3;
                meansR[n] = meansR[n] + xi;
            }
            int n = k3++;
            meansR[n] = meansR[n] / (double)(N - M);
        }
        double avgikR = 0.0;
        for (int k4 = 0; k4 < schema.getNbTargetAttributes(); ++k4) {
            NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k4];
            int NeighCount = (int)schema.getSettings().getTree().getNumNeightbours();
            double WR = 0.0;
            if (NeighCount > 0) {
                double[][] w = new double[N][N];
                for (int i = M; i < N; ++i) {
                    Distance[] distances = new Distance[NeighCount];
                    DataTuple exi = this.m_Data.getTuple(permutation[i]);
                    NumericAttrType xt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
                    NumericAttrType yt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[1];
                    double ti = ((ClusAttrType)type).getNumeric(exi);
                    double xi = ((ClusAttrType)xt).getNumeric(exi);
                    double yi = ((ClusAttrType)yt).getNumeric(exi);
                    int a = 0;
                    double biggestd = Double.POSITIVE_INFINITY;
                    int biggestindex = Integer.MAX_VALUE;
                    for (int j = M; j < N; ++j) {
                        DataTuple exj = this.m_Data.getTuple(j);
                        double tj = ((ClusAttrType)type).getNumeric(exj);
                        double xj = ((ClusAttrType)xt).getNumeric(exj);
                        double yj = ((ClusAttrType)yt).getNumeric(exj);
                        double d = Math.sqrt((xi - xj) * (xi - xj) + (yi - yj) * (yi - yj));
                        if (N - M < NeighCount) {
                            distances[a] = new Distance(j, tj, d);
                            ++a;
                            continue;
                        }
                        if (a < NeighCount) {
                            distances[a] = new Distance(j, tj, d);
                            ++a;
                            continue;
                        }
                        biggestd = distances[0].distance;
                        biggestindex = 0;
                        for (a = 1; a < NeighCount; ++a) {
                            if (!(distances[a].distance > biggestd)) continue;
                            biggestd = distances[a].distance;
                            biggestindex = a;
                        }
                        if (!(d < biggestd)) continue;
                        distances[biggestindex].index = j;
                        distances[biggestindex].target = tj;
                        distances[biggestindex].distance = d;
                    }
                    SettingsTree.SpatialMatrixType spatialMatrix = schema.getSettings().getTree().getSpatialMatrix();
                    for (int j = 0; distances.length > j && distances[j] != null && j < NeighCount; ++j) {
                        if (distances[j].distance == 0.0) {
                            w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                        } else {
                            switch (spatialMatrix) {
                                case Binary: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                    break;
                                }
                                case Euclidean: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0 / distances[j].distance;
                                    break;
                                }
                                case Modified: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount)) * (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount));
                                    break;
                                }
                                case Gaussian: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = Math.exp(-(distances[j].distance * distances[j].distance) / (double)(NeighCount * NeighCount));
                                    break;
                                }
                                default: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                }
                            }
                        }
                        int n = k4;
                        upsumR[n] = upsumR[n] + w[permutation[i]][permutation[j]] * (ti - meansR[k4]) * (distances[j].target - meansR[k4]);
                        WR += w[permutation[i]][permutation[j]];
                    }
                    int n = k4;
                    downsumR[n] = downsumR[n] + (ti - meansR[k4]) * (ti - meansR[k4]);
                }
            }
            int n = k4;
            downsumR[n] = downsumR[n] / ((double)(N - M) + 0.0);
            if (downsumR[k4] != 0.0 && upsumR[k4] != 0.0) {
                ikkR[k4] = upsumR[k4] / (WR * downsumR[k4]);
                avgikR += ikkR[k4];
                continue;
            }
            avgikR = 1.0;
        }
        double IR = avgikR /= (double)schema.getNbTargetAttributes();
        double I = (IL + IR * (double)(N - M)) / (double)this.m_Data.getNbRows();
        double scaledI = 1.0 + I;
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return scaledI;
    }

    public double calcEquvalentIwithNeighbourstotal() throws ClusException {
        double I;
        ClusSchema schema = this.m_Data.getSchema();
        double avgik = 0.0;
        if (this.m_SplitIndex > 0) {
            // empty if block
        }
        if ((I = (avgik /= (double)schema.getNbTargetAttributes())) > 1.0) {
            I = 1.0;
        }
        if (I < -1.0) {
            I = -1.0;
        }
        double scaledI = 1.0 - I;
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return scaledI;
    }

    @Override
    public double calcEquvalentGDistance(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_Data.getSchema();
        double[] ikk = new double[schema.getNbTargetAttributes()];
        double[] ikkR = new double[schema.getNbTargetAttributes()];
        double[] num = new double[schema.getNbTargetAttributes()];
        double[] den = new double[schema.getNbTargetAttributes()];
        double[] numR = new double[schema.getNbTargetAttributes()];
        double[] denR = new double[schema.getNbTargetAttributes()];
        double[] means = new double[schema.getNbTargetAttributes()];
        double[] meansR = new double[schema.getNbTargetAttributes()];
        double avgik = 0.0;
        double avgikR = 0.0;
        int M = 0;
        int N = 0;
        int NR = this.m_Data.getNbRows();
        double I = 0.0;
        int vkupenBrojElementiVoOvojSplit = N - M;
        int vkupenBrojElementiVoCelataSuma = NR;
        for (int k = 0; k < schema.getNbTargetAttributes(); ++k) {
            long xxi;
            double xi;
            DataTuple exi;
            String indexMap;
            Double temp;
            long indexJ;
            long yyi;
            double xj;
            DataTuple exj;
            DataTuple exi2;
            int i;
            double w;
            NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k];
            NumericAttrType xt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
            M = this.m_PrevIndex;
            N = this.m_SplitIndex;
            if (this.INITIALIZE_PARTIAL_SUM) {
                this.INITIALIZE_PARTIAL_SUM = false;
                for (int i2 = M = 0; i2 < NR; ++i2) {
                    DataTuple exi3 = this.m_Data.getTuple(permutation[i2]);
                    double xi2 = ((ClusAttrType)type).getNumeric(exi3);
                    long xxi2 = (long)((ClusAttrType)xt).getNumeric(exi3);
                    int n = k;
                    meansR[n] = meansR[n] + xi2;
                    int n2 = k;
                    this.m_PreviousSumX2R[n2] = this.m_PreviousSumX2R[n2] + xi2 * xi2;
                    int n3 = k;
                    this.m_PreviousSumXR[n3] = this.m_PreviousSumXR[n3] + xi2;
                    for (int j = M; j < NR; ++j) {
                        DataTuple exj2 = this.m_Data.getTuple(j);
                        double xj2 = ((ClusAttrType)type).getNumeric(exj2);
                        long yyi2 = (long)((ClusAttrType)xt).getNumeric(exj2);
                        w = 0.0;
                        long indexI = xxi2;
                        long indexJ2 = yyi2;
                        if (indexI != indexJ2) {
                            String indexMap2;
                            Double temp2;
                            if (indexI > indexJ2) {
                                indexI = yyi2;
                                indexJ2 = xxi2;
                            }
                            w = (temp2 = GISHeuristic.m_distancesS.get(indexMap2 = indexI + "#" + indexJ2)) != null ? temp2 : 0.0;
                            int n4 = k;
                            this.m_PreviousSumWR[n4] = this.m_PreviousSumWR[n4] + w;
                            int n5 = k;
                            this.m_PreviousSumWXXR[n5] = this.m_PreviousSumWXXR[n5] + w * (xi2 - xj2) * (xi2 - xj2);
                            continue;
                        }
                        int n6 = k;
                        this.m_PreviousSumWR[n6] = this.m_PreviousSumWR[n6] + 1.0;
                        int n7 = k;
                        this.m_PreviousSumWXXR[n7] = this.m_PreviousSumWXXR[n7] + (xi2 - xj2) * (xi2 - xj2);
                    }
                }
            }
            boolean flagRightAllEqual = true;
            boolean flagLeftAllEqual = true;
            for (int i3 = M; i3 < N; ++i3) {
                DataTuple exi4 = this.m_Data.getTuple(permutation[i3]);
                double xi3 = ((ClusAttrType)type).getNumeric(exi4);
                int n = k;
                means[n] = means[n] + xi3;
                int n8 = k;
                this.m_PreviousSumX2[n8] = this.m_PreviousSumX2[n8] + xi3 * xi3;
                int n9 = k;
                this.m_PreviousSumX[n9] = this.m_PreviousSumX[n9] + xi3;
                int n10 = k;
                meansR[n10] = meansR[n10] - xi3;
                int n11 = k;
                this.m_PreviousSumX2R[n11] = this.m_PreviousSumX2R[n11] - xi3 * xi3;
                int n12 = k;
                this.m_PreviousSumXR[n12] = this.m_PreviousSumXR[n12] - xi3;
            }
            flagLeftAllEqual = true;
            double oldX = ((ClusAttrType)type).getNumeric(this.m_Data.getTuple(0));
            for (i = 1; i < N; ++i) {
                exi2 = this.m_Data.getTuple(permutation[i]);
                double xi4 = ((ClusAttrType)type).getNumeric(exi2);
                if (xi4 == oldX) continue;
                flagLeftAllEqual = false;
                break;
            }
            for (i = 0; i < M; ++i) {
                exi2 = this.m_Data.getTuple(permutation[i]);
                double xi5 = ((ClusAttrType)type).getNumeric(exi2);
                long xxi3 = (long)((ClusAttrType)xt).getNumeric(exi2);
                for (int j = M; j < N; ++j) {
                    exj = this.m_Data.getTuple(j);
                    xj = ((ClusAttrType)type).getNumeric(exj);
                    yyi = (long)((ClusAttrType)xt).getNumeric(exj);
                    double w2 = 0.0;
                    long indexI = xxi3;
                    indexJ = yyi;
                    if (indexI != indexJ) {
                        if (indexI > indexJ) {
                            indexI = yyi;
                            indexJ = xxi3;
                        }
                        w2 = (temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) != null ? temp : 0.0;
                        int n = k;
                        this.m_PreviousSumW[n] = this.m_PreviousSumW[n] + w2;
                        int n13 = k;
                        this.m_PreviousSumWXX[n13] = this.m_PreviousSumWXX[n13] + w2 * (xi5 - xj) * (xi5 - xj);
                        continue;
                    }
                    int n = k;
                    this.m_PreviousSumW[n] = this.m_PreviousSumW[n] + 1.0;
                    int n14 = k;
                    this.m_PreviousSumWXX[n14] = this.m_PreviousSumWXX[n14] + (xi5 - xj) * (xi5 - xj);
                }
            }
            for (i = M; i < N; ++i) {
                for (int j = 0; j < M; ++j) {
                    long yyi3;
                    double w3 = 0.0;
                    DataTuple exj3 = this.m_Data.getTuple(j);
                    double xj3 = ((ClusAttrType)type).getNumeric(exj3);
                    exi = this.m_Data.getTuple(permutation[i]);
                    xi = ((ClusAttrType)type).getNumeric(exi);
                    xxi = (long)((ClusAttrType)xt).getNumeric(exi);
                    long indexI = xxi;
                    if (indexI != (indexJ = (yyi3 = (long)((ClusAttrType)xt).getNumeric(exj3)))) {
                        if (indexI > indexJ) {
                            indexI = yyi3;
                            indexJ = xxi;
                        }
                        w3 = (temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) != null ? temp : 0.0;
                        int n = k;
                        this.m_PreviousSumW[n] = this.m_PreviousSumW[n] + w3;
                        int n15 = k;
                        this.m_PreviousSumWXX[n15] = this.m_PreviousSumWXX[n15] + w3 * (xi - xj3) * (xi - xj3);
                        continue;
                    }
                    int n = k;
                    this.m_PreviousSumW[n] = this.m_PreviousSumW[n] + 1.0;
                    int n16 = k;
                    this.m_PreviousSumWXX[n16] = this.m_PreviousSumWXX[n16] + (xi - xj3) * (xi - xj3);
                }
            }
            for (i = M; i < N; ++i) {
                exi2 = this.m_Data.getTuple(permutation[i]);
                double xi6 = ((ClusAttrType)type).getNumeric(exi2);
                for (int j = M; j < N; ++j) {
                    long yyi4;
                    DataTuple exj4 = this.m_Data.getTuple(j);
                    double xj4 = ((ClusAttrType)type).getNumeric(exj4);
                    w = 0.0;
                    xxi = (long)((ClusAttrType)xt).getNumeric(exi2);
                    long indexI = xxi;
                    if (indexI != (indexJ = (yyi4 = (long)((ClusAttrType)xt).getNumeric(exj4)))) {
                        if (indexI > indexJ) {
                            indexI = yyi4;
                            indexJ = xxi;
                        }
                        w = (temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) != null ? temp : 0.0;
                        int n = k;
                        this.m_PreviousSumW[n] = this.m_PreviousSumW[n] + w;
                        int n17 = k;
                        this.m_PreviousSumWXX[n17] = this.m_PreviousSumWXX[n17] + w * (xi6 - xj4) * (xi6 - xj4);
                        continue;
                    }
                    int n = k;
                    this.m_PreviousSumW[n] = this.m_PreviousSumW[n] + 1.0;
                    int n18 = k;
                    this.m_PreviousSumWXX[n18] = this.m_PreviousSumWXX[n18] + (xi6 - xj4) * (xi6 - xj4);
                }
            }
            flagRightAllEqual = true;
            oldX = ((ClusAttrType)type).getNumeric(this.m_Data.getTuple(N));
            for (i = N; i < NR; ++i) {
                exi2 = this.m_Data.getTuple(permutation[i]);
                double xi7 = ((ClusAttrType)type).getNumeric(exi2);
                if (oldX != xi7) {
                    flagRightAllEqual = false;
                }
                for (int j = M; j < N; ++j) {
                    long yyi5;
                    long indexI;
                    double w4 = 0.0;
                    exj = this.m_Data.getTuple(j);
                    xj = ((ClusAttrType)type).getNumeric(exj);
                    if (xi7 != oldX) {
                        flagRightAllEqual = false;
                    }
                    if ((indexI = (xxi = (long)((ClusAttrType)xt).getNumeric(exi2))) != (indexJ = (yyi5 = (long)((ClusAttrType)xt).getNumeric(exj)))) {
                        if (indexI > indexJ) {
                            indexI = yyi5;
                            indexJ = xxi;
                        }
                        w4 = (temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) != null ? temp : 0.0;
                        int n = k;
                        this.m_PreviousSumWR[n] = this.m_PreviousSumWR[n] - w4;
                        int n19 = k;
                        this.m_PreviousSumWXXR[n19] = this.m_PreviousSumWXXR[n19] - w4 * (xi7 - xj) * (xi7 - xj);
                        continue;
                    }
                    int n = k;
                    this.m_PreviousSumWR[n] = this.m_PreviousSumWR[n] - 1.0;
                    int n20 = k;
                    this.m_PreviousSumWXXR[n20] = this.m_PreviousSumWXXR[n20] - (xi7 - xj) * (xi7 - xj);
                }
            }
            for (i = M; i < N; ++i) {
                for (int j = N; j < NR; ++j) {
                    long yyi6;
                    double w5 = 0.0;
                    DataTuple exj5 = this.m_Data.getTuple(j);
                    double xj5 = ((ClusAttrType)type).getNumeric(exj5);
                    exi = this.m_Data.getTuple(permutation[i]);
                    xi = ((ClusAttrType)type).getNumeric(exi);
                    xxi = (long)((ClusAttrType)xt).getNumeric(exi);
                    long indexI = xxi;
                    if (indexI != (indexJ = (yyi6 = (long)((ClusAttrType)xt).getNumeric(exj5)))) {
                        if (indexI > indexJ) {
                            indexI = yyi6;
                            indexJ = xxi;
                        }
                        w5 = (temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) != null ? temp : 0.0;
                        int n = k;
                        this.m_PreviousSumWR[n] = this.m_PreviousSumWR[n] - w5;
                        int n21 = k;
                        this.m_PreviousSumWXXR[n21] = this.m_PreviousSumWXXR[n21] - w5 * (xi - xj5) * (xi - xj5);
                        continue;
                    }
                    int n = k;
                    this.m_PreviousSumWR[n] = this.m_PreviousSumWR[n] - 1.0;
                    int n22 = k;
                    this.m_PreviousSumWXXR[n22] = this.m_PreviousSumWXXR[n22] - (xi - xj5) * (xi - xj5);
                }
            }
            for (i = M; i < N; ++i) {
                exi2 = this.m_Data.getTuple(permutation[i]);
                double xi8 = ((ClusAttrType)type).getNumeric(exi2);
                long xxi4 = (long)((ClusAttrType)xt).getNumeric(exi2);
                for (int j = M; j < N; ++j) {
                    exj = this.m_Data.getTuple(j);
                    xj = ((ClusAttrType)type).getNumeric(exj);
                    yyi = (long)((ClusAttrType)xt).getNumeric(exj);
                    double w6 = 0.0;
                    long indexI = xxi4;
                    indexJ = yyi;
                    if (indexI != indexJ) {
                        if (indexI > indexJ) {
                            indexI = yyi;
                            indexJ = xxi4;
                        }
                        w6 = (temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) != null ? temp : 0.0;
                        int n = k;
                        this.m_PreviousSumWR[n] = this.m_PreviousSumWR[n] - w6;
                        int n23 = k;
                        this.m_PreviousSumWXXR[n23] = this.m_PreviousSumWXXR[n23] - w6 * (xi8 - xj) * (xi8 - xj);
                        continue;
                    }
                    int n = k;
                    this.m_PreviousSumWR[n] = this.m_PreviousSumWR[n] - 1.0;
                    int n24 = k;
                    this.m_PreviousSumWXXR[n24] = this.m_PreviousSumWXXR[n24] - (xi8 - xj) * (xi8 - xj);
                }
            }
            vkupenBrojElementiVoOvojSplit = N;
            num[k] = (double)(vkupenBrojElementiVoOvojSplit - 1) * this.m_PreviousSumWXX[k];
            den[k] = 2.0 * this.m_PreviousSumW[k] * (this.m_PreviousSumX2[k] - (double)vkupenBrojElementiVoOvojSplit * (this.m_PreviousSumX[k] / (double)vkupenBrojElementiVoOvojSplit) * (this.m_PreviousSumX[k] / (double)vkupenBrojElementiVoOvojSplit));
            ikk[k] = den[k] != 0.0 && num[k] != 0.0 && !flagLeftAllEqual ? num[k] / den[k] : 0.0;
            vkupenBrojElementiVoOvojSplit = NR - N;
            numR[k] = (double)(vkupenBrojElementiVoOvojSplit - 1) * this.m_PreviousSumWXXR[k];
            denR[k] = 2.0 * this.m_PreviousSumWR[k] * (this.m_PreviousSumX2R[k] - this.m_PreviousSumXR[k] * this.m_PreviousSumXR[k] / (double)vkupenBrojElementiVoOvojSplit);
            ikkR[k] = denR[k] != 0.0 && numR[k] != 0.0 && !flagRightAllEqual ? numR[k] / denR[k] : 0.0;
            avgikR += ikkR[k];
            avgik += ikk[k];
        }
        I = ((avgik /= (double)schema.getNbTargetAttributes()) * (double)N + (avgikR /= (double)schema.getNbTargetAttributes()) * (double)(NR - N)) / (double)vkupenBrojElementiVoCelataSuma;
        M = this.m_PrevIndex;
        N = this.m_SplitIndex;
        double scaledI = 2.0 - I;
        if (Double.isNaN(scaledI)) {
            throw new ClusException("err!");
        }
        return scaledI;
    }

    @Override
    public double calcEquvalentIDistance(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_Data.getSchema();
        double[] ikk = new double[schema.getNbTargetAttributes()];
        double[] ikkR = new double[schema.getNbTargetAttributes()];
        double[] num = new double[schema.getNbTargetAttributes()];
        double[] den = new double[schema.getNbTargetAttributes()];
        double[] numR = new double[schema.getNbTargetAttributes()];
        double[] denR = new double[schema.getNbTargetAttributes()];
        double[] means = new double[schema.getNbTargetAttributes()];
        double[] meansR = new double[schema.getNbTargetAttributes()];
        double avgik = 0.0;
        double avgikR = 0.0;
        int M = 0;
        int N = 0;
        int NR = this.m_Data.getNbRows();
        double I = 0.0;
        int vkupenBrojElementiVoOvojSplit = N - M;
        int vkupenBrojElementiVoCelataSuma = NR;
        for (int k = 0; k < schema.getNbTargetAttributes(); ++k) {
            long xxi;
            double xi;
            DataTuple exi;
            String indexMap;
            Double temp;
            long indexJ;
            long yyi;
            double xj;
            DataTuple exj;
            DataTuple exi2;
            int i;
            double w;
            NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k];
            NumericAttrType xt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
            M = this.m_PrevIndex;
            N = this.m_SplitIndex;
            if (this.INITIALIZE_PARTIAL_SUM) {
                this.INITIALIZE_PARTIAL_SUM = false;
                for (int i2 = M = 0; i2 < NR; ++i2) {
                    DataTuple exi3 = this.m_Data.getTuple(permutation[i2]);
                    double xi2 = ((ClusAttrType)type).getNumeric(exi3);
                    long xxi2 = (long)((ClusAttrType)xt).getNumeric(exi3);
                    int n = k;
                    meansR[n] = meansR[n] + xi2;
                    int n2 = k;
                    this.m_PreviousSumX2R[n2] = this.m_PreviousSumX2R[n2] + xi2 * xi2;
                    int n3 = k;
                    this.m_PreviousSumXR[n3] = this.m_PreviousSumXR[n3] + xi2;
                    for (int j = M; j < NR; ++j) {
                        DataTuple exj2 = this.m_Data.getTuple(j);
                        double xj2 = ((ClusAttrType)type).getNumeric(exj2);
                        long yyi2 = (long)((ClusAttrType)xt).getNumeric(exj2);
                        w = 0.0;
                        long indexI = xxi2;
                        long indexJ2 = yyi2;
                        if (indexI != indexJ2) {
                            String indexMap2;
                            Double temp2;
                            if (indexI > indexJ2) {
                                indexI = yyi2;
                                indexJ2 = xxi2;
                            }
                            w = (temp2 = GISHeuristic.m_distancesS.get(indexMap2 = indexI + "#" + indexJ2)) != null ? temp2 : 0.0;
                            int n4 = k;
                            this.m_PreviousSumWR[n4] = this.m_PreviousSumWR[n4] + w;
                            int n5 = k;
                            this.m_PreviousSumWXXR[n5] = this.m_PreviousSumWXXR[n5] + w * xi2 * xj2;
                            int n6 = k;
                            this.m_PreviousSumWXR[n6] = this.m_PreviousSumWXR[n6] + w * xj2;
                            continue;
                        }
                        int n7 = k;
                        this.m_PreviousSumWR[n7] = this.m_PreviousSumWR[n7] + 1.0;
                        int n8 = k;
                        this.m_PreviousSumWXXR[n8] = this.m_PreviousSumWXXR[n8] + xi2 * xj2;
                        int n9 = k;
                        this.m_PreviousSumWXR[n9] = this.m_PreviousSumWXR[n9] + xj2;
                    }
                }
            }
            boolean flagRightAllEqual = true;
            boolean flagLeftAllEqual = true;
            for (int i3 = M; i3 < N; ++i3) {
                DataTuple exi4 = this.m_Data.getTuple(permutation[i3]);
                double xi3 = ((ClusAttrType)type).getNumeric(exi4);
                int n = k;
                means[n] = means[n] + xi3;
                int n10 = k;
                this.m_PreviousSumX2[n10] = this.m_PreviousSumX2[n10] + xi3 * xi3;
                int n11 = k;
                this.m_PreviousSumX[n11] = this.m_PreviousSumX[n11] + xi3;
                int n12 = k;
                meansR[n12] = meansR[n12] - xi3;
                int n13 = k;
                this.m_PreviousSumX2R[n13] = this.m_PreviousSumX2R[n13] - xi3 * xi3;
                int n14 = k;
                this.m_PreviousSumXR[n14] = this.m_PreviousSumXR[n14] - xi3;
            }
            flagLeftAllEqual = true;
            double oldX = ((ClusAttrType)type).getNumeric(this.m_Data.getTuple(0));
            for (i = 1; i < N; ++i) {
                exi2 = this.m_Data.getTuple(permutation[i]);
                double xi4 = ((ClusAttrType)type).getNumeric(exi2);
                if (xi4 == oldX) continue;
                flagLeftAllEqual = false;
                break;
            }
            for (i = 0; i < M; ++i) {
                exi2 = this.m_Data.getTuple(permutation[i]);
                double xi5 = ((ClusAttrType)type).getNumeric(exi2);
                long xxi3 = (long)((ClusAttrType)xt).getNumeric(exi2);
                for (int j = M; j < N; ++j) {
                    exj = this.m_Data.getTuple(j);
                    xj = ((ClusAttrType)type).getNumeric(exj);
                    yyi = (long)((ClusAttrType)xt).getNumeric(exj);
                    double w2 = 0.0;
                    long indexI = xxi3;
                    indexJ = yyi;
                    if (indexI != indexJ) {
                        if (indexI > indexJ) {
                            indexI = yyi;
                            indexJ = xxi3;
                        }
                        w2 = (temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) != null ? temp : 0.0;
                        int n = k;
                        this.m_PreviousSumW[n] = this.m_PreviousSumW[n] + w2;
                        int n15 = k;
                        this.m_PreviousSumWXX[n15] = this.m_PreviousSumWXX[n15] + w2 * xi5 * xj;
                        int n16 = k;
                        this.m_PreviousSumWX[n16] = this.m_PreviousSumWX[n16] + w2 * xj;
                        continue;
                    }
                    int n = k;
                    this.m_PreviousSumW[n] = this.m_PreviousSumW[n] + 1.0;
                    int n17 = k;
                    this.m_PreviousSumWXX[n17] = this.m_PreviousSumWXX[n17] + xi5 * xj;
                    int n18 = k;
                    this.m_PreviousSumWX[n18] = this.m_PreviousSumWX[n18] + xj;
                }
            }
            for (i = M; i < N; ++i) {
                for (int j = 0; j < M; ++j) {
                    long yyi3;
                    double w3 = 0.0;
                    DataTuple exj3 = this.m_Data.getTuple(j);
                    double xj3 = ((ClusAttrType)type).getNumeric(exj3);
                    exi = this.m_Data.getTuple(permutation[i]);
                    xi = ((ClusAttrType)type).getNumeric(exi);
                    xxi = (long)((ClusAttrType)xt).getNumeric(exi);
                    long indexI = xxi;
                    if (indexI != (indexJ = (yyi3 = (long)((ClusAttrType)xt).getNumeric(exj3)))) {
                        if (indexI > indexJ) {
                            indexI = yyi3;
                            indexJ = xxi;
                        }
                        w3 = (temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) != null ? temp : 0.0;
                        int n = k;
                        this.m_PreviousSumW[n] = this.m_PreviousSumW[n] + w3;
                        int n19 = k;
                        this.m_PreviousSumWX[n19] = this.m_PreviousSumWX[n19] + w3 * xj3;
                        int n20 = k;
                        this.m_PreviousSumWXX[n20] = this.m_PreviousSumWXX[n20] + w3 * xi * xj3;
                        continue;
                    }
                    int n = k;
                    this.m_PreviousSumW[n] = this.m_PreviousSumW[n] + 1.0;
                    int n21 = k;
                    this.m_PreviousSumWXX[n21] = this.m_PreviousSumWXX[n21] + xi * xj3;
                    int n22 = k;
                    this.m_PreviousSumWX[n22] = this.m_PreviousSumWX[n22] + xj3;
                }
            }
            for (i = M; i < N; ++i) {
                exi2 = this.m_Data.getTuple(permutation[i]);
                double xi6 = ((ClusAttrType)type).getNumeric(exi2);
                for (int j = M; j < N; ++j) {
                    long yyi4;
                    DataTuple exj4 = this.m_Data.getTuple(j);
                    double xj4 = ((ClusAttrType)type).getNumeric(exj4);
                    w = 0.0;
                    xxi = (long)((ClusAttrType)xt).getNumeric(exi2);
                    long indexI = xxi;
                    if (indexI != (indexJ = (yyi4 = (long)((ClusAttrType)xt).getNumeric(exj4)))) {
                        if (indexI > indexJ) {
                            indexI = yyi4;
                            indexJ = xxi;
                        }
                        w = (temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) != null ? temp : 0.0;
                        int n = k;
                        this.m_PreviousSumW[n] = this.m_PreviousSumW[n] + w;
                        int n23 = k;
                        this.m_PreviousSumWX[n23] = this.m_PreviousSumWX[n23] + w * xj4;
                        int n24 = k;
                        this.m_PreviousSumWXX[n24] = this.m_PreviousSumWXX[n24] + w * xi6 * xj4;
                        continue;
                    }
                    int n = k;
                    this.m_PreviousSumW[n] = this.m_PreviousSumW[n] + 1.0;
                    int n25 = k;
                    this.m_PreviousSumWXX[n25] = this.m_PreviousSumWXX[n25] + xi6 * xj4;
                    int n26 = k;
                    this.m_PreviousSumWX[n26] = this.m_PreviousSumWX[n26] + xj4;
                }
            }
            flagRightAllEqual = true;
            oldX = ((ClusAttrType)type).getNumeric(this.m_Data.getTuple(N));
            for (i = N; i < NR; ++i) {
                exi2 = this.m_Data.getTuple(permutation[i]);
                double xi7 = ((ClusAttrType)type).getNumeric(exi2);
                if (oldX != xi7) {
                    flagRightAllEqual = false;
                }
                for (int j = M; j < N; ++j) {
                    long yyi5;
                    long indexI;
                    double w4 = 0.0;
                    exj = this.m_Data.getTuple(j);
                    xj = ((ClusAttrType)type).getNumeric(exj);
                    if (xi7 != oldX) {
                        flagRightAllEqual = false;
                    }
                    if ((indexI = (xxi = (long)((ClusAttrType)xt).getNumeric(exi2))) != (indexJ = (yyi5 = (long)((ClusAttrType)xt).getNumeric(exj)))) {
                        if (indexI > indexJ) {
                            indexI = yyi5;
                            indexJ = xxi;
                        }
                        w4 = (temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) != null ? temp : 0.0;
                        int n = k;
                        this.m_PreviousSumWR[n] = this.m_PreviousSumWR[n] - w4;
                        int n27 = k;
                        this.m_PreviousSumWXXR[n27] = this.m_PreviousSumWXXR[n27] - w4 * xi7 * xj;
                        int n28 = k;
                        this.m_PreviousSumWXR[n28] = this.m_PreviousSumWXR[n28] - w4 * xj;
                        continue;
                    }
                    int n = k;
                    this.m_PreviousSumWR[n] = this.m_PreviousSumWR[n] - 1.0;
                    int n29 = k;
                    this.m_PreviousSumWXXR[n29] = this.m_PreviousSumWXXR[n29] - xi7 * xj;
                    int n30 = k;
                    this.m_PreviousSumWXR[n30] = this.m_PreviousSumWXR[n30] - xj;
                }
            }
            for (i = M; i < N; ++i) {
                for (int j = N; j < NR; ++j) {
                    long yyi6;
                    double w5 = 0.0;
                    DataTuple exj5 = this.m_Data.getTuple(j);
                    double xj5 = ((ClusAttrType)type).getNumeric(exj5);
                    exi = this.m_Data.getTuple(permutation[i]);
                    xi = ((ClusAttrType)type).getNumeric(exi);
                    xxi = (long)((ClusAttrType)xt).getNumeric(exi);
                    long indexI = xxi;
                    if (indexI != (indexJ = (yyi6 = (long)((ClusAttrType)xt).getNumeric(exj5)))) {
                        if (indexI > indexJ) {
                            indexI = yyi6;
                            indexJ = xxi;
                        }
                        w5 = (temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) != null ? temp : 0.0;
                        int n = k;
                        this.m_PreviousSumWR[n] = this.m_PreviousSumWR[n] - w5;
                        int n31 = k;
                        this.m_PreviousSumWXXR[n31] = this.m_PreviousSumWXXR[n31] - w5 * xi * xj5;
                        int n32 = k;
                        this.m_PreviousSumWXR[n32] = this.m_PreviousSumWXR[n32] - w5 * xj5;
                        continue;
                    }
                    int n = k;
                    this.m_PreviousSumWR[n] = this.m_PreviousSumWR[n] - 1.0;
                    int n33 = k;
                    this.m_PreviousSumWXXR[n33] = this.m_PreviousSumWXXR[n33] - xi * xj5;
                    int n34 = k;
                    this.m_PreviousSumWXR[n34] = this.m_PreviousSumWXR[n34] - xj5;
                }
            }
            for (i = M; i < N; ++i) {
                exi2 = this.m_Data.getTuple(permutation[i]);
                double xi8 = ((ClusAttrType)type).getNumeric(exi2);
                long xxi4 = (long)((ClusAttrType)xt).getNumeric(exi2);
                for (int j = M; j < N; ++j) {
                    exj = this.m_Data.getTuple(j);
                    xj = ((ClusAttrType)type).getNumeric(exj);
                    yyi = (long)((ClusAttrType)xt).getNumeric(exj);
                    double w6 = 0.0;
                    long indexI = xxi4;
                    indexJ = yyi;
                    if (indexI != indexJ) {
                        if (indexI > indexJ) {
                            indexI = yyi;
                            indexJ = xxi4;
                        }
                        w6 = (temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) != null ? temp : 0.0;
                        int n = k;
                        this.m_PreviousSumWR[n] = this.m_PreviousSumWR[n] - w6;
                        int n35 = k;
                        this.m_PreviousSumWXXR[n35] = this.m_PreviousSumWXXR[n35] - w6 * xi8 * xj;
                        int n36 = k;
                        this.m_PreviousSumWXR[n36] = this.m_PreviousSumWXR[n36] - w6 * xj;
                        continue;
                    }
                    int n = k;
                    this.m_PreviousSumWR[n] = this.m_PreviousSumWR[n] - 1.0;
                    int n37 = k;
                    this.m_PreviousSumWXXR[n37] = this.m_PreviousSumWXXR[n37] - xi8 * xj;
                    int n38 = k;
                    this.m_PreviousSumWXR[n38] = this.m_PreviousSumWXR[n38] - xj;
                }
            }
            vkupenBrojElementiVoOvojSplit = N;
            num[k] = (double)vkupenBrojElementiVoOvojSplit * (this.m_PreviousSumWXX[k] - 2.0 * (this.m_PreviousSumX[k] / (double)vkupenBrojElementiVoOvojSplit) * this.m_PreviousSumWX[k] + this.m_PreviousSumX[k] / (double)vkupenBrojElementiVoOvojSplit * (this.m_PreviousSumX[k] / (double)vkupenBrojElementiVoOvojSplit) * this.m_PreviousSumW[k]);
            den[k] = this.m_PreviousSumW[k] * (this.m_PreviousSumX2[k] - (double)vkupenBrojElementiVoOvojSplit * (this.m_PreviousSumX[k] / (double)vkupenBrojElementiVoOvojSplit) * (this.m_PreviousSumX[k] / (double)vkupenBrojElementiVoOvojSplit));
            ikk[k] = den[k] != 0.0 && num[k] != 0.0 && !flagLeftAllEqual ? num[k] / den[k] : 1.0;
            vkupenBrojElementiVoOvojSplit = NR - N;
            numR[k] = (double)vkupenBrojElementiVoOvojSplit * (this.m_PreviousSumWXXR[k] - 2.0 * this.m_PreviousSumWXR[k] * (this.m_PreviousSumXR[k] / (double)vkupenBrojElementiVoOvojSplit) + this.m_PreviousSumXR[k] / (double)vkupenBrojElementiVoOvojSplit * (this.m_PreviousSumXR[k] / (double)vkupenBrojElementiVoOvojSplit) * this.m_PreviousSumWR[k]);
            denR[k] = this.m_PreviousSumWR[k] * (this.m_PreviousSumX2R[k] - this.m_PreviousSumXR[k] * this.m_PreviousSumXR[k] / (double)vkupenBrojElementiVoOvojSplit);
            ikkR[k] = denR[k] != 0.0 && numR[k] != 0.0 && !flagRightAllEqual ? numR[k] / denR[k] : 1.0;
            avgikR += ikkR[k];
            avgik += ikk[k];
        }
        I = ((avgik /= (double)schema.getNbTargetAttributes()) * (double)N + (avgikR /= (double)schema.getNbTargetAttributes()) * (double)(NR - N)) / (double)vkupenBrojElementiVoCelataSuma;
        M = this.m_PrevIndex;
        N = this.m_SplitIndex;
        double scaledI = 1.0 + I;
        if (Double.isNaN(scaledI)) {
            throw new ClusException("err!");
        }
        return scaledI;
    }

    @Override
    public double calcEquvalentGtotal(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_Data.getSchema();
        double[] ikk = new double[schema.getNbTargetAttributes()];
        double[] ikkR = new double[schema.getNbTargetAttributes()];
        double[] num = new double[schema.getNbTargetAttributes()];
        double[] den = new double[schema.getNbTargetAttributes()];
        double[] numR = new double[schema.getNbTargetAttributes()];
        double[] denR = new double[schema.getNbTargetAttributes()];
        double[] means = new double[schema.getNbTargetAttributes()];
        double[] meansR = new double[schema.getNbTargetAttributes()];
        double avgik = 0.0;
        double avgikR = 0.0;
        int M = 0;
        int N = 0;
        int NR = this.m_Data.getNbRows();
        double I = 0.0;
        int vkupenBrojElementiVoOvojSplit = N - M;
        int vkupenBrojElementiVoCelataSuma = NR;
        for (int k = 0; k < schema.getNbTargetAttributes(); ++k) {
            Double temp;
            long indexMap;
            DataTuple exi;
            double xj;
            Double temp2;
            DataTuple exj;
            double w;
            double xi;
            DataTuple exi2;
            int i;
            NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k];
            M = this.m_PrevIndex;
            N = this.m_SplitIndex;
            if (this.INITIALIZE_PARTIAL_SUM) {
                this.INITIALIZE_PARTIAL_SUM = false;
                for (int i2 = M = 0; i2 < NR; ++i2) {
                    DataTuple exi3 = this.m_Data.getTuple(permutation[i2]);
                    double xi2 = ((ClusAttrType)type).getNumeric(exi3);
                    int n = k;
                    meansR[n] = meansR[n] + xi2;
                    int n2 = k;
                    this.m_PreviousSumX2R[n2] = this.m_PreviousSumX2R[n2] + xi2 * xi2;
                    int n3 = k;
                    this.m_PreviousSumXR[n3] = this.m_PreviousSumXR[n3] + xi2;
                    for (int j = M; j < NR; ++j) {
                        Double temp3;
                        DataTuple exj2 = this.m_Data.getTuple(j);
                        double xj2 = ((ClusAttrType)type).getNumeric(exj2);
                        long indexMap2 = i2 * NR + j;
                        double w2 = 0.0;
                        if (i2 > j) {
                            indexMap2 = j * NR + i2;
                        }
                        w2 = (temp3 = GISHeuristic.m_distances.get(indexMap2)) != null ? temp3 : 0.0;
                        int n4 = k;
                        this.m_PreviousSumWR[n4] = this.m_PreviousSumWR[n4] + w2;
                        int n5 = k;
                        this.m_PreviousSumWXXR[n5] = this.m_PreviousSumWXXR[n5] + w2 * (xi2 - xj2) * (xi2 - xj2);
                    }
                }
            }
            boolean flagRightAllEqual = true;
            boolean flagLeftAllEqual = true;
            for (int i3 = M; i3 < N; ++i3) {
                DataTuple exi4 = this.m_Data.getTuple(permutation[i3]);
                double xi3 = ((ClusAttrType)type).getNumeric(exi4);
                int n = k;
                means[n] = means[n] + xi3;
                int n6 = k;
                this.m_PreviousSumX2[n6] = this.m_PreviousSumX2[n6] + xi3 * xi3;
                int n7 = k;
                this.m_PreviousSumX[n7] = this.m_PreviousSumX[n7] + xi3;
                int n8 = k;
                meansR[n8] = meansR[n8] - xi3;
                int n9 = k;
                this.m_PreviousSumX2R[n9] = this.m_PreviousSumX2R[n9] - xi3 * xi3;
                int n10 = k;
                this.m_PreviousSumXR[n10] = this.m_PreviousSumXR[n10] - xi3;
            }
            flagLeftAllEqual = true;
            double oldX = ((ClusAttrType)type).getNumeric(this.m_Data.getTuple(0));
            for (i = 1; i < N; ++i) {
                exi2 = this.m_Data.getTuple(permutation[i]);
                xi = ((ClusAttrType)type).getNumeric(exi2);
                if (xi == oldX) continue;
                flagLeftAllEqual = false;
                break;
            }
            for (i = 0; i < M; ++i) {
                exi2 = this.m_Data.getTuple(permutation[i]);
                xi = ((ClusAttrType)type).getNumeric(exi2);
                for (int j = M; j < N; ++j) {
                    long indexMap3 = i * NR + j;
                    w = 0.0;
                    exj = this.m_Data.getTuple(j);
                    double xj3 = ((ClusAttrType)type).getNumeric(exj);
                    if (i > j) {
                        indexMap3 = j * NR + i;
                    }
                    w = (temp2 = GISHeuristic.m_distances.get(indexMap3)) != null ? temp2 : 0.0;
                    int n = k;
                    this.m_PreviousSumW[n] = this.m_PreviousSumW[n] + w;
                    int n11 = k;
                    this.m_PreviousSumWXX[n11] = this.m_PreviousSumWXX[n11] + w * (xi - xj3) * (xi - xj3);
                }
            }
            for (i = M; i < N; ++i) {
                for (int j = 0; j < M; ++j) {
                    long indexMap4 = i * NR + j;
                    double w3 = 0.0;
                    DataTuple exj3 = this.m_Data.getTuple(j);
                    xj = ((ClusAttrType)type).getNumeric(exj3);
                    exi = this.m_Data.getTuple(permutation[i]);
                    double xi4 = ((ClusAttrType)type).getNumeric(exi);
                    if (i > j) {
                        indexMap4 = j * NR + i;
                    }
                    w3 = (temp2 = GISHeuristic.m_distances.get(indexMap4)) != null ? temp2 : 0.0;
                    int n = k;
                    this.m_PreviousSumW[n] = this.m_PreviousSumW[n] + w3;
                    int n12 = k;
                    this.m_PreviousSumWXX[n12] = this.m_PreviousSumWXX[n12] + w3 * (xi4 - xj) * (xi4 - xj);
                }
            }
            for (i = M; i < N; ++i) {
                DataTuple exi5 = this.m_Data.getTuple(permutation[i]);
                double xi5 = ((ClusAttrType)type).getNumeric(exi5);
                for (int j = M; j < N; ++j) {
                    DataTuple exj4 = this.m_Data.getTuple(j);
                    double xj4 = ((ClusAttrType)type).getNumeric(exj4);
                    double w4 = 0.0;
                    long indexI = i;
                    long indexJ = j;
                    if (i > j) {
                        indexI = j;
                        indexJ = i;
                    }
                    indexMap = indexI * (long)NR + indexJ;
                    if (i > j) {
                        indexMap = j * NR + i;
                    }
                    w4 = (temp = GISHeuristic.m_distances.get(indexMap)) != null ? temp : 0.0;
                    int n = k;
                    this.m_PreviousSumW[n] = this.m_PreviousSumW[n] + w4;
                    int n13 = k;
                    this.m_PreviousSumWXX[n13] = this.m_PreviousSumWXX[n13] + w4 * (xi5 - xj4) * (xi5 - xj4);
                }
            }
            flagRightAllEqual = true;
            oldX = ((ClusAttrType)type).getNumeric(this.m_Data.getTuple(N));
            for (i = N; i < NR; ++i) {
                DataTuple exi6 = this.m_Data.getTuple(permutation[i]);
                double xi6 = ((ClusAttrType)type).getNumeric(exi6);
                if (oldX != xi6) {
                    flagRightAllEqual = false;
                }
                for (int j = M; j < N; ++j) {
                    Double temp4;
                    long indexMap5 = i * NR + j;
                    w = 0.0;
                    exj = this.m_Data.getTuple(j);
                    double xj5 = ((ClusAttrType)type).getNumeric(exj);
                    if (xi6 != oldX) {
                        flagRightAllEqual = false;
                    }
                    if (i > j) {
                        indexMap5 = j * NR + i;
                    }
                    w = (temp4 = GISHeuristic.m_distances.get(indexMap5)) != null ? temp4 : 0.0;
                    int n = k;
                    this.m_PreviousSumWR[n] = this.m_PreviousSumWR[n] - w;
                    int n14 = k;
                    this.m_PreviousSumWXXR[n14] = this.m_PreviousSumWXXR[n14] - w * (xi6 - xj5) * (xi6 - xj5);
                }
            }
            for (i = M; i < N; ++i) {
                for (int j = N; j < NR; ++j) {
                    Double temp5;
                    long indexMap6 = i * NR + j;
                    double w5 = 0.0;
                    DataTuple exj5 = this.m_Data.getTuple(j);
                    xj = ((ClusAttrType)type).getNumeric(exj5);
                    exi = this.m_Data.getTuple(permutation[i]);
                    double xi7 = ((ClusAttrType)type).getNumeric(exi);
                    if (i > j) {
                        indexMap6 = j * NR + i;
                    }
                    w5 = (temp5 = GISHeuristic.m_distances.get(indexMap6)) != null ? temp5 : 0.0;
                    int n = k;
                    this.m_PreviousSumWR[n] = this.m_PreviousSumWR[n] - w5;
                    int n15 = k;
                    this.m_PreviousSumWXXR[n15] = this.m_PreviousSumWXXR[n15] - w5 * (xi7 - xj) * (xi7 - xj);
                }
            }
            for (i = M; i < N; ++i) {
                DataTuple exi7 = this.m_Data.getTuple(permutation[i]);
                double xi8 = ((ClusAttrType)type).getNumeric(exi7);
                for (int j = M; j < N; ++j) {
                    DataTuple exj6 = this.m_Data.getTuple(j);
                    double xj6 = ((ClusAttrType)type).getNumeric(exj6);
                    double w6 = 0.0;
                    long indexI = i;
                    long indexJ = j;
                    if (i > j) {
                        indexI = j;
                        indexJ = i;
                    }
                    indexMap = indexI * (long)NR + indexJ;
                    if (i > j) {
                        indexMap = j * NR + i;
                    }
                    w6 = (temp = GISHeuristic.m_distances.get(indexMap)) != null ? temp : 0.0;
                    int n = k;
                    this.m_PreviousSumWR[n] = this.m_PreviousSumWR[n] - w6;
                    int n16 = k;
                    this.m_PreviousSumWXXR[n16] = this.m_PreviousSumWXXR[n16] - w6 * (xi8 - xj6) * (xi8 - xj6);
                }
            }
            vkupenBrojElementiVoOvojSplit = N;
            num[k] = (double)(vkupenBrojElementiVoOvojSplit - 1) * this.m_PreviousSumWXX[k];
            den[k] = 2.0 * this.m_PreviousSumW[k] * (this.m_PreviousSumX2[k] - (double)vkupenBrojElementiVoOvojSplit * (this.m_PreviousSumX[k] / (double)vkupenBrojElementiVoOvojSplit) * (this.m_PreviousSumX[k] / (double)vkupenBrojElementiVoOvojSplit));
            ikk[k] = den[k] != 0.0 && num[k] != 0.0 && !flagLeftAllEqual ? num[k] / den[k] : 1.0;
            vkupenBrojElementiVoOvojSplit = NR - N;
            numR[k] = (double)(vkupenBrojElementiVoOvojSplit - 1) * this.m_PreviousSumWXXR[k];
            denR[k] = 2.0 * this.m_PreviousSumWR[k] * (this.m_PreviousSumX2R[k] - this.m_PreviousSumXR[k] * this.m_PreviousSumXR[k] / (double)vkupenBrojElementiVoOvojSplit);
            ikkR[k] = denR[k] != 0.0 && numR[k] != 0.0 && !flagRightAllEqual ? numR[k] / denR[k] : 1.0;
            avgikR += ikkR[k];
            avgik += ikk[k];
        }
        I = ((avgik /= (double)schema.getNbTargetAttributes()) * (double)N + (avgikR /= (double)schema.getNbTargetAttributes()) * (double)(NR - N)) / (double)vkupenBrojElementiVoCelataSuma;
        M = this.m_PrevIndex;
        N = this.m_SplitIndex;
        double scaledI = 2.0 - I;
        if (Double.isNaN(scaledI)) {
            throw new ClusException("err!");
        }
        return scaledI;
    }

    @Override
    public double calcEquvalentItotal(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_Data.getSchema();
        double[] ikk = new double[schema.getNbTargetAttributes()];
        double[] ikkR = new double[schema.getNbTargetAttributes()];
        double[] num = new double[schema.getNbTargetAttributes()];
        double[] den = new double[schema.getNbTargetAttributes()];
        double[] numR = new double[schema.getNbTargetAttributes()];
        double[] denR = new double[schema.getNbTargetAttributes()];
        double[] means = new double[schema.getNbTargetAttributes()];
        double[] meansR = new double[schema.getNbTargetAttributes()];
        double avgik = 0.0;
        double avgikR = 0.0;
        int M = 0;
        int N = 0;
        int NR = this.m_Data.getNbRows();
        double I = 0.0;
        int vkupenBrojElementiVoOvojSplit = N - M;
        int vkupenBrojElementiVoCelataSuma = NR;
        for (int k = 0; k < schema.getNbTargetAttributes(); ++k) {
            Double temp;
            long indexMap;
            DataTuple exi;
            double xj;
            Double temp2;
            DataTuple exj;
            double w;
            double xi;
            DataTuple exi2;
            int i;
            NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k];
            M = this.m_PrevIndex;
            N = this.m_SplitIndex;
            if (this.INITIALIZE_PARTIAL_SUM) {
                this.INITIALIZE_PARTIAL_SUM = false;
                for (int i2 = M = 0; i2 < NR; ++i2) {
                    DataTuple exi3 = this.m_Data.getTuple(permutation[i2]);
                    double xi2 = ((ClusAttrType)type).getNumeric(exi3);
                    int n = k;
                    meansR[n] = meansR[n] + xi2;
                    int n2 = k;
                    this.m_PreviousSumX2R[n2] = this.m_PreviousSumX2R[n2] + xi2 * xi2;
                    int n3 = k;
                    this.m_PreviousSumXR[n3] = this.m_PreviousSumXR[n3] + xi2;
                    for (int j = M; j < NR; ++j) {
                        Double temp3;
                        DataTuple exj2 = this.m_Data.getTuple(j);
                        double xj2 = ((ClusAttrType)type).getNumeric(exj2);
                        long indexMap2 = i2 * NR + j;
                        double w2 = 0.0;
                        if (i2 > j) {
                            indexMap2 = j * NR + i2;
                        }
                        w2 = (temp3 = GISHeuristic.m_distances.get(indexMap2)) != null ? temp3 : 0.0;
                        int n4 = k;
                        this.m_PreviousSumWR[n4] = this.m_PreviousSumWR[n4] + w2;
                        int n5 = k;
                        this.m_PreviousSumWXXR[n5] = this.m_PreviousSumWXXR[n5] + w2 * xi2 * xj2;
                        int n6 = k;
                        this.m_PreviousSumWXR[n6] = this.m_PreviousSumWXR[n6] + w2 * xj2;
                    }
                }
            }
            boolean flagRightAllEqual = true;
            boolean flagLeftAllEqual = true;
            for (int i3 = M; i3 < N; ++i3) {
                DataTuple exi4 = this.m_Data.getTuple(permutation[i3]);
                double xi3 = ((ClusAttrType)type).getNumeric(exi4);
                int n = k;
                means[n] = means[n] + xi3;
                int n7 = k;
                this.m_PreviousSumX2[n7] = this.m_PreviousSumX2[n7] + xi3 * xi3;
                int n8 = k;
                this.m_PreviousSumX[n8] = this.m_PreviousSumX[n8] + xi3;
                int n9 = k;
                meansR[n9] = meansR[n9] - xi3;
                int n10 = k;
                this.m_PreviousSumX2R[n10] = this.m_PreviousSumX2R[n10] - xi3 * xi3;
                int n11 = k;
                this.m_PreviousSumXR[n11] = this.m_PreviousSumXR[n11] - xi3;
            }
            flagLeftAllEqual = true;
            double oldX = ((ClusAttrType)type).getNumeric(this.m_Data.getTuple(0));
            for (i = 1; i < N; ++i) {
                exi2 = this.m_Data.getTuple(permutation[i]);
                xi = ((ClusAttrType)type).getNumeric(exi2);
                if (xi == oldX) continue;
                flagLeftAllEqual = false;
                break;
            }
            for (i = 0; i < M; ++i) {
                exi2 = this.m_Data.getTuple(permutation[i]);
                xi = ((ClusAttrType)type).getNumeric(exi2);
                for (int j = M; j < N; ++j) {
                    long indexMap3 = i * NR + j;
                    w = 0.0;
                    exj = this.m_Data.getTuple(j);
                    double xj3 = ((ClusAttrType)type).getNumeric(exj);
                    if (i > j) {
                        indexMap3 = j * NR + i;
                    }
                    w = (temp2 = GISHeuristic.m_distances.get(indexMap3)) != null ? temp2 : 0.0;
                    int n = k;
                    this.m_PreviousSumW[n] = this.m_PreviousSumW[n] + w;
                    int n12 = k;
                    this.m_PreviousSumWXX[n12] = this.m_PreviousSumWXX[n12] + w * xi * xj3;
                    int n13 = k;
                    this.m_PreviousSumWX[n13] = this.m_PreviousSumWX[n13] + w * xj3;
                }
            }
            for (i = M; i < N; ++i) {
                for (int j = 0; j < M; ++j) {
                    long indexMap4 = i * NR + j;
                    double w3 = 0.0;
                    DataTuple exj3 = this.m_Data.getTuple(j);
                    xj = ((ClusAttrType)type).getNumeric(exj3);
                    exi = this.m_Data.getTuple(permutation[i]);
                    double xi4 = ((ClusAttrType)type).getNumeric(exi);
                    if (i > j) {
                        indexMap4 = j * NR + i;
                    }
                    w3 = (temp2 = GISHeuristic.m_distances.get(indexMap4)) != null ? temp2 : 0.0;
                    int n = k;
                    this.m_PreviousSumW[n] = this.m_PreviousSumW[n] + w3;
                    int n14 = k;
                    this.m_PreviousSumWX[n14] = this.m_PreviousSumWX[n14] + w3 * xj;
                    int n15 = k;
                    this.m_PreviousSumWXX[n15] = this.m_PreviousSumWXX[n15] + w3 * xi4 * xj;
                }
            }
            for (i = M; i < N; ++i) {
                DataTuple exi5 = this.m_Data.getTuple(permutation[i]);
                double xi5 = ((ClusAttrType)type).getNumeric(exi5);
                for (int j = M; j < N; ++j) {
                    DataTuple exj4 = this.m_Data.getTuple(j);
                    double xj4 = ((ClusAttrType)type).getNumeric(exj4);
                    double w4 = 0.0;
                    long indexI = i;
                    long indexJ = j;
                    if (i > j) {
                        indexI = j;
                        indexJ = i;
                    }
                    indexMap = indexI * (long)NR + indexJ;
                    if (i > j) {
                        indexMap = j * NR + i;
                    }
                    w4 = (temp = GISHeuristic.m_distances.get(indexMap)) != null ? temp : 0.0;
                    int n = k;
                    this.m_PreviousSumW[n] = this.m_PreviousSumW[n] + w4;
                    int n16 = k;
                    this.m_PreviousSumWX[n16] = this.m_PreviousSumWX[n16] + w4 * xj4;
                    int n17 = k;
                    this.m_PreviousSumWXX[n17] = this.m_PreviousSumWXX[n17] + w4 * xi5 * xj4;
                }
            }
            flagRightAllEqual = true;
            oldX = ((ClusAttrType)type).getNumeric(this.m_Data.getTuple(N));
            for (i = N; i < NR; ++i) {
                DataTuple exi6 = this.m_Data.getTuple(permutation[i]);
                double xi6 = ((ClusAttrType)type).getNumeric(exi6);
                if (oldX != xi6) {
                    flagRightAllEqual = false;
                }
                for (int j = M; j < N; ++j) {
                    Double temp4;
                    long indexMap5 = i * NR + j;
                    w = 0.0;
                    exj = this.m_Data.getTuple(j);
                    double xj5 = ((ClusAttrType)type).getNumeric(exj);
                    if (xi6 != oldX) {
                        flagRightAllEqual = false;
                    }
                    if (i > j) {
                        indexMap5 = j * NR + i;
                    }
                    w = (temp4 = GISHeuristic.m_distances.get(indexMap5)) != null ? temp4 : 0.0;
                    int n = k;
                    this.m_PreviousSumWR[n] = this.m_PreviousSumWR[n] - w;
                    int n18 = k;
                    this.m_PreviousSumWXXR[n18] = this.m_PreviousSumWXXR[n18] - w * xi6 * xj5;
                    int n19 = k;
                    this.m_PreviousSumWXR[n19] = this.m_PreviousSumWXR[n19] - w * xj5;
                }
            }
            for (i = M; i < N; ++i) {
                for (int j = N; j < NR; ++j) {
                    Double temp5;
                    long indexMap6 = i * NR + j;
                    double w5 = 0.0;
                    DataTuple exj5 = this.m_Data.getTuple(j);
                    xj = ((ClusAttrType)type).getNumeric(exj5);
                    exi = this.m_Data.getTuple(permutation[i]);
                    double xi7 = ((ClusAttrType)type).getNumeric(exi);
                    if (i > j) {
                        indexMap6 = j * NR + i;
                    }
                    w5 = (temp5 = GISHeuristic.m_distances.get(indexMap6)) != null ? temp5 : 0.0;
                    int n = k;
                    this.m_PreviousSumWR[n] = this.m_PreviousSumWR[n] - w5;
                    int n20 = k;
                    this.m_PreviousSumWXXR[n20] = this.m_PreviousSumWXXR[n20] - w5 * xi7 * xj;
                    int n21 = k;
                    this.m_PreviousSumWXR[n21] = this.m_PreviousSumWXR[n21] - w5 * xj;
                }
            }
            for (i = M; i < N; ++i) {
                DataTuple exi7 = this.m_Data.getTuple(permutation[i]);
                double xi8 = ((ClusAttrType)type).getNumeric(exi7);
                for (int j = M; j < N; ++j) {
                    DataTuple exj6 = this.m_Data.getTuple(j);
                    double xj6 = ((ClusAttrType)type).getNumeric(exj6);
                    double w6 = 0.0;
                    long indexI = i;
                    long indexJ = j;
                    if (i > j) {
                        indexI = j;
                        indexJ = i;
                    }
                    indexMap = indexI * (long)NR + indexJ;
                    if (i > j) {
                        indexMap = j * NR + i;
                    }
                    w6 = (temp = GISHeuristic.m_distances.get(indexMap)) != null ? temp : 0.0;
                    int n = k;
                    this.m_PreviousSumWR[n] = this.m_PreviousSumWR[n] - w6;
                    int n22 = k;
                    this.m_PreviousSumWXXR[n22] = this.m_PreviousSumWXXR[n22] - w6 * xi8 * xj6;
                    int n23 = k;
                    this.m_PreviousSumWXR[n23] = this.m_PreviousSumWXR[n23] - w6 * xj6;
                }
            }
            vkupenBrojElementiVoOvojSplit = N;
            num[k] = (double)vkupenBrojElementiVoOvojSplit * (this.m_PreviousSumWXX[k] - 2.0 * (this.m_PreviousSumX[k] / (double)vkupenBrojElementiVoOvojSplit) * this.m_PreviousSumWX[k] + this.m_PreviousSumX[k] / (double)vkupenBrojElementiVoOvojSplit * (this.m_PreviousSumX[k] / (double)vkupenBrojElementiVoOvojSplit) * this.m_PreviousSumW[k]);
            den[k] = this.m_PreviousSumW[k] * (this.m_PreviousSumX2[k] - (double)vkupenBrojElementiVoOvojSplit * (this.m_PreviousSumX[k] / (double)vkupenBrojElementiVoOvojSplit) * (this.m_PreviousSumX[k] / (double)vkupenBrojElementiVoOvojSplit));
            ikk[k] = den[k] != 0.0 && num[k] != 0.0 && !flagLeftAllEqual ? num[k] / den[k] : 1.0;
            vkupenBrojElementiVoOvojSplit = NR - N;
            numR[k] = (double)vkupenBrojElementiVoOvojSplit * (this.m_PreviousSumWXXR[k] - 2.0 * this.m_PreviousSumWXR[k] * (this.m_PreviousSumXR[k] / (double)vkupenBrojElementiVoOvojSplit) + this.m_PreviousSumXR[k] / (double)vkupenBrojElementiVoOvojSplit * (this.m_PreviousSumXR[k] / (double)vkupenBrojElementiVoOvojSplit) * this.m_PreviousSumWR[k]);
            denR[k] = this.m_PreviousSumWR[k] * (this.m_PreviousSumX2R[k] - this.m_PreviousSumXR[k] * this.m_PreviousSumXR[k] / (double)vkupenBrojElementiVoOvojSplit);
            ikkR[k] = denR[k] != 0.0 && numR[k] != 0.0 && !flagRightAllEqual ? numR[k] / denR[k] : 1.0;
            avgikR += ikkR[k];
            avgik += ikk[k];
        }
        I = ((avgik /= (double)schema.getNbTargetAttributes()) * (double)N + (avgikR /= (double)schema.getNbTargetAttributes()) * (double)(NR - N)) / (double)vkupenBrojElementiVoCelataSuma;
        M = this.m_PrevIndex;
        N = this.m_SplitIndex;
        double scaledI = 1.0 + I;
        if (Double.isNaN(scaledI)) {
            throw new ClusException("err!");
        }
        return scaledI;
    }

    @Override
    public double calcItotal(Integer[] permutation) throws ClusException {
        double den;
        double num;
        ClusSchema schema = this.m_Data.getSchema();
        this.m_TempData = this.m_Data;
        int M = 0;
        int N = this.m_Data.getNbRows();
        long NR = this.m_Data.getNbRows();
        if (this.m_SplitIndex > 0) {
            N = this.m_SplitIndex;
        } else {
            M = -this.m_SplitIndex;
        }
        double[] upsum = new double[schema.getNbTargetAttributes()];
        double[] downsum = new double[schema.getNbTargetAttributes()];
        double[] means = new double[schema.getNbTargetAttributes()];
        double[] ikk = new double[schema.getNbTargetAttributes()];
        int k = 0;
        while (k < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k];
                DataTuple exi = this.m_Data.getTuple(permutation[permutation[i]]);
                double xi = ((ClusAttrType)type).getNumeric(exi);
                int n = k;
                means[n] = means[n] + xi;
            }
            int n = k++;
            means[n] = means[n] / (double)(N - M);
        }
        double avgik = 0.0;
        double W = 0.0;
        for (int k2 = 0; k2 < schema.getNbTargetAttributes(); ++k2) {
            NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k2];
            for (int i = M; i < N; ++i) {
                int permI = permutation[i];
                DataTuple exi = this.m_Data.getTuple(permI);
                double xi = ((ClusAttrType)type).getNumeric(exi);
                for (int j = M; j < N; ++j) {
                    int permJ = permutation[permutation[j]];
                    DataTuple exj = this.m_Data.getTuple(permJ);
                    double xj = ((ClusAttrType)type).getNumeric(exj);
                    double w = 0.0;
                    long indexI = permI;
                    long indexJ = permJ;
                    if (permI != permJ) {
                        long indexMap;
                        Double temp;
                        if (permI > permJ) {
                            indexI = permJ;
                            indexJ = permI;
                        }
                        w = (temp = GISHeuristic.m_distances.get(indexMap = indexI * NR + indexJ)) != null ? temp : 0.0;
                        int n = k2;
                        upsum[n] = upsum[n] + w * (xi - means[k2]) * (xj - means[k2]);
                        W += w;
                        continue;
                    }
                    int n = k2;
                    upsum[n] = upsum[n] + (xi - means[k2]) * (xi - means[k2]);
                    W += 1.0;
                }
                int n = k2;
                downsum[n] = downsum[n] + (xi - means[k2]) * (xi - means[k2]);
            }
            num = ((double)(N - M) + 0.0) * upsum[k2];
            den = W * downsum[k2];
            ikk[k2] = num != 0.0 && den != 0.0 ? num / den : 1.0;
            avgik += ikk[k2];
        }
        double IL = (avgik /= (double)schema.getNbTargetAttributes()) * (double)(N - M);
        N = this.m_Data.getNbRows();
        M = this.m_SplitIndex;
        double[] upsumR = new double[schema.getNbTargetAttributes()];
        double[] downsumR = new double[schema.getNbTargetAttributes()];
        double[] meansR = new double[schema.getNbTargetAttributes()];
        double[] ikkR = new double[schema.getNbTargetAttributes()];
        int k3 = 0;
        while (k3 < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k3];
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNumeric(exi);
                int n = k3;
                meansR[n] = meansR[n] + xi;
            }
            int n = k3++;
            meansR[n] = meansR[n] / (double)(N - M);
        }
        double avgikR = 0.0;
        double WR = 0.0;
        for (int k4 = 0; k4 < schema.getNbTargetAttributes(); ++k4) {
            NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k4];
            for (int i = M; i < N; ++i) {
                int permI = permutation[i];
                DataTuple exi = this.m_Data.getTuple(permI);
                double xi = ((ClusAttrType)type).getNumeric(exi);
                for (int j = M; j < N; ++j) {
                    int permJ = permutation[j];
                    DataTuple exj = this.m_Data.getTuple(permJ);
                    double xj = ((ClusAttrType)type).getNumeric(exj);
                    double w = 0.0;
                    long indexI = permI;
                    long indexJ = permJ;
                    if (permI != permJ) {
                        long indexMap;
                        Double temp;
                        if (permI > permJ) {
                            indexI = permJ;
                            indexJ = permI;
                        }
                        w = (temp = GISHeuristic.m_distances.get(indexMap = indexI * NR + indexJ)) != null ? temp : 0.0;
                        int n = k4;
                        upsumR[n] = upsumR[n] + w * (xi - meansR[k4]) * (xj - meansR[k4]);
                        WR += w;
                        continue;
                    }
                    int n = k4;
                    upsumR[n] = upsumR[n] + (xi - meansR[k4]) * (xi - meansR[k4]);
                    WR += 1.0;
                }
                int n = k4;
                downsumR[n] = downsumR[n] + (xi - meansR[k4]) * (xi - meansR[k4]);
            }
            num = ((double)(N - M) + 0.0) * upsumR[k4];
            den = WR * downsumR[k4];
            ikkR[k4] = num != 0.0 && den != 0.0 ? num / den : 1.0;
            avgikR += ikkR[k4];
        }
        double IR = avgikR /= (double)schema.getNbTargetAttributes();
        double I = (IL + IR * (double)(N - M)) / (double)this.m_Data.getNbRows();
        double scaledI = 1.0 + I;
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return scaledI;
    }

    @Override
    public double calcItotalD(Integer[] permutation) throws ClusException {
        double den;
        double num;
        ClusSchema schema = this.m_Data.getSchema();
        double avgik = 0.0;
        double W = 0.0;
        this.m_TempData = this.m_Data;
        int M = 0;
        int N = this.m_Data.getNbRows();
        if (this.m_SplitIndex > 0) {
            N = this.m_SplitIndex;
        } else {
            M = -this.m_SplitIndex;
        }
        double[] upsum = new double[schema.getNbTargetAttributes()];
        double[] downsum = new double[schema.getNbTargetAttributes()];
        double[] means = new double[schema.getNbTargetAttributes()];
        double[] ikk = new double[schema.getNbTargetAttributes()];
        int k = 0;
        while (k < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k];
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNumeric(exi);
                int n = k;
                means[n] = means[n] + xi;
            }
            int n = k++;
            means[n] = means[n] / (double)(N - M);
        }
        for (k = 0; k < schema.getNbTargetAttributes(); ++k) {
            NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k];
            NumericAttrType xt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
            for (int i = M; i < N; ++i) {
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNumeric(exi);
                long xxi = (long)((ClusAttrType)xt).getNumeric(exi);
                for (int j = M; j < N; ++j) {
                    DataTuple exj = this.m_Data.getTuple(j);
                    double xj = ((ClusAttrType)type).getNumeric(exj);
                    long yyi = (long)((ClusAttrType)xt).getNumeric(exj);
                    double w = 0.0;
                    long indexI = xxi;
                    long indexJ = yyi;
                    if (indexI != indexJ) {
                        String indexMap;
                        Double tmp;
                        if (indexI > indexJ) {
                            indexI = yyi;
                            indexJ = xxi;
                        }
                        w = (tmp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) != null ? tmp : 0.0;
                        int n = k;
                        upsum[n] = upsum[n] + w * (xi - means[k]) * (xj - means[k]);
                        W += w;
                        continue;
                    }
                    int n = k;
                    upsum[n] = upsum[n] + (xi - means[k]) * (xi - means[k]);
                    W += 1.0;
                }
                int n = k;
                downsum[n] = downsum[n] + (xi - means[k]) * (xi - means[k]);
            }
            num = ((double)(N - M) + 0.0) * upsum[k];
            den = W * downsum[k];
            ikk[k] = num != 0.0 && den != 0.0 ? num / den : 1.0;
            avgik += ikk[k];
        }
        double IL = (avgik /= (double)schema.getNbTargetAttributes()) * (double)(N - M);
        num = 0.0;
        den = 0.0;
        N = this.m_Data.getNbRows();
        M = this.m_SplitIndex;
        double avgikR = 0.0;
        double[] upsumR = new double[schema.getNbTargetAttributes()];
        double[] downsumR = new double[schema.getNbTargetAttributes()];
        double[] meansR = new double[schema.getNbTargetAttributes()];
        double[] ikkR = new double[schema.getNbTargetAttributes()];
        int k2 = 0;
        while (k2 < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k2];
                DataTuple exi = this.m_Data.getTuple(i);
                double xi = ((ClusAttrType)type).getNumeric(exi);
                int n = k2;
                meansR[n] = meansR[n] + xi;
            }
            int n = k2++;
            meansR[n] = meansR[n] / (double)(N - M);
        }
        for (k2 = 0; k2 < schema.getNbTargetAttributes(); ++k2) {
            NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k2];
            NumericAttrType xt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
            for (int i = M; i < N; ++i) {
                DataTuple exi = this.m_Data.getTuple(i);
                double xi = ((ClusAttrType)type).getNumeric(exi);
                long xxi = (long)((ClusAttrType)xt).getNumeric(exi);
                for (int j = M; j < N; ++j) {
                    DataTuple exj = this.m_Data.getTuple(j);
                    double xj = ((ClusAttrType)type).getNumeric(exj);
                    long yyi = (long)((ClusAttrType)xt).getNumeric(exj);
                    double w = 0.0;
                    long indexI = xxi;
                    long indexJ = yyi;
                    if (indexI != indexJ) {
                        String indexMap;
                        Double tmp;
                        if (indexI > indexJ) {
                            indexI = yyi;
                            indexJ = xxi;
                        }
                        w = (tmp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) != null ? tmp : 0.0;
                        int n = k2;
                        upsumR[n] = upsumR[n] + w * (xi - meansR[k2]) * (xj - meansR[k2]);
                        continue;
                    }
                    int n = k2;
                    upsumR[n] = upsumR[n] + (xi - meansR[k2]) * (xi - meansR[k2]);
                }
                int n = k2;
                downsumR[n] = downsumR[n] + (xi - meansR[k2]) * (xi - meansR[k2]);
            }
            num = ((double)(N - M) + 0.0) * upsumR[k2];
            den = W * downsumR[k2];
            ikkR[k2] = num != 0.0 && den != 0.0 ? num / den : 1.0;
            avgikR += ikkR[k2];
        }
        double IR = avgikR /= (double)schema.getNbTargetAttributes();
        double I = (IL + IR * (double)(N - M)) / (double)this.m_Data.getNbRows();
        double scaledI = 1.0 + I;
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return scaledI;
    }

    @Override
    public double calcGtotal(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_Data.getSchema();
        int M = 0;
        int N = this.m_Data.getNbRows();
        long NR = this.m_Data.getNbRows();
        if (this.m_SplitIndex > 0) {
            N = this.m_SplitIndex;
        } else {
            M = -this.m_SplitIndex;
        }
        double[] upsum = new double[schema.getNbTargetAttributes()];
        double[] downsum = new double[schema.getNbTargetAttributes()];
        double[] means = new double[schema.getNbTargetAttributes()];
        double[] ikk = new double[schema.getNbTargetAttributes()];
        int k = 0;
        while (k < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k];
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNumeric(exi);
                int n = k;
                means[n] = means[n] + xi;
            }
            int n = k++;
            means[n] = means[n] / (double)(N - M);
        }
        double avgik = 0.0;
        double W = 0.0;
        for (int k2 = 0; k2 < schema.getNbTargetAttributes(); ++k2) {
            NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k2];
            for (int i = M; i < N; ++i) {
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNumeric(exi);
                for (int j = M; j < N; ++j) {
                    DataTuple exj = this.m_Data.getTuple(j);
                    double xj = ((ClusAttrType)type).getNumeric(exj);
                    double w = 0.0;
                    long indexI = i;
                    long indexJ = j;
                    if (i != j) {
                        long indexMap;
                        Double temp;
                        if (i > j) {
                            indexI = j;
                            indexJ = i;
                        }
                        w = (temp = GISHeuristic.m_distances.get(indexMap = indexI * NR + indexJ)) != null ? temp : 0.0;
                        int n = k2;
                        upsum[n] = upsum[n] + w * (xi - xj) * (xi - xj);
                        W += w;
                        continue;
                    }
                    W += 1.0;
                    int n = k2;
                    upsum[n] = upsum[n] + (xi - xj) * (xi - xj);
                }
                int n = k2;
                downsum[n] = downsum[n] + (xi - means[k2]) * (xi - means[k2]);
            }
            if (downsum[k2] != 0.0 && upsum[k2] != 0.0) {
                ikk[k2] = (double)(N - M - 1) * upsum[k2] / (2.0 * W * downsum[k2]);
                avgik += ikk[k2];
                continue;
            }
            ikk[k2] = 0.0;
        }
        double IL = (double)(N - M) * (avgik /= (double)schema.getNbTargetAttributes());
        M = this.m_SplitIndex;
        N = this.m_Data.getNbRows();
        double[] upsumR = new double[schema.getNbTargetAttributes()];
        double[] downsumR = new double[schema.getNbTargetAttributes()];
        double[] meansR = new double[schema.getNbTargetAttributes()];
        double[] ikkR = new double[schema.getNbTargetAttributes()];
        int k3 = 0;
        while (k3 < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k3];
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNumeric(exi);
                int n = k3;
                meansR[n] = meansR[n] + xi;
            }
            int n = k3++;
            meansR[n] = meansR[n] / (double)(N - M);
        }
        double avgikR = 0.0;
        double WR = 0.0;
        for (int k4 = 0; k4 < schema.getNbTargetAttributes(); ++k4) {
            NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k4];
            for (int i = M; i < N; ++i) {
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNumeric(exi);
                for (int j = M; j < N; ++j) {
                    DataTuple exj = this.m_Data.getTuple(j);
                    double xj = ((ClusAttrType)type).getNumeric(exj);
                    double w = 0.0;
                    long indexI = i;
                    long indexJ = j;
                    if (i != j) {
                        long indexMap;
                        Double temp;
                        if (i > j) {
                            indexI = j;
                            indexJ = i;
                        }
                        w = (temp = GISHeuristic.m_distances.get(indexMap = indexI * NR + indexJ)) != null ? temp : 0.0;
                        int n = k4;
                        upsumR[n] = upsumR[n] + w * (xi - xj) * (xi - xj);
                        WR += w;
                        continue;
                    }
                    WR += 1.0;
                    int n = k4;
                    upsumR[n] = upsumR[n] + (xi - xj) * (xi - xj);
                }
                int n = k4;
                downsumR[n] = downsumR[n] + (xi - meansR[k4]) * (xi - meansR[k4]);
            }
            if (downsumR[k4] != 0.0 && upsumR[k4] != 0.0) {
                ikkR[k4] = (double)(N - M - 1) * upsumR[k4] / (2.0 * WR * downsumR[k4]);
                avgikR += ikkR[k4];
                continue;
            }
            ikkR[k4] = 0.0;
        }
        double IR = avgikR /= (double)schema.getNbTargetAttributes();
        double I = 2.0 - (IL + IR * (double)(N - M)) / (double)NR;
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return I;
    }

    @Override
    public double calcGtotalD(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_Data.getSchema();
        int M = 0;
        int N = this.m_Data.getNbRows();
        long NR = this.m_Data.getNbRows();
        if (this.m_SplitIndex > 0) {
            N = this.m_SplitIndex;
        } else {
            M = -this.m_SplitIndex;
        }
        double[] upsum = new double[schema.getNbTargetAttributes()];
        double[] downsum = new double[schema.getNbTargetAttributes()];
        double[] means = new double[schema.getNbTargetAttributes()];
        double[] ikk = new double[schema.getNbTargetAttributes()];
        int k = 0;
        while (k < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k];
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNumeric(exi);
                int n = k;
                means[n] = means[n] + xi;
            }
            int n = k++;
            means[n] = means[n] / (double)(N - M);
        }
        double avgik = 0.0;
        double W = 0.0;
        for (int k2 = 0; k2 < schema.getNbTargetAttributes(); ++k2) {
            NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k2];
            NumericAttrType xt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
            for (int i = M; i < N; ++i) {
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNumeric(exi);
                long xxi = (long)((ClusAttrType)xt).getNumeric(exi);
                for (int j = M; j < N; ++j) {
                    DataTuple exj = this.m_Data.getTuple(j);
                    double xj = ((ClusAttrType)type).getNumeric(exj);
                    long yyi = (long)((ClusAttrType)xt).getNumeric(exj);
                    double w = 0.0;
                    long indexI = xxi;
                    long indexJ = yyi;
                    if (indexI != indexJ) {
                        String indexMap;
                        Double temp;
                        if (indexI > indexJ) {
                            indexI = yyi;
                            indexJ = xxi;
                        }
                        w = (temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) != null ? temp : 0.0;
                        int n = k2;
                        upsum[n] = upsum[n] + w * (xi - xj) * (xi - xj);
                        W += w;
                        continue;
                    }
                    W += 1.0;
                    int n = k2;
                    upsum[n] = upsum[n] + (xi - xj) * (xi - xj);
                }
                int n = k2;
                downsum[n] = downsum[n] + (xi - means[k2]) * (xi - means[k2]);
            }
            if (downsum[k2] != 0.0 && upsum[k2] != 0.0) {
                ikk[k2] = (double)(N - M - 1) * upsum[k2] / (2.0 * W * downsum[k2]);
                avgik += ikk[k2];
                continue;
            }
            ikk[k2] = 0.0;
        }
        double IL = (double)(N - M) * (avgik /= (double)schema.getNbTargetAttributes());
        M = this.m_SplitIndex;
        N = this.m_Data.getNbRows();
        double[] upsumR = new double[schema.getNbTargetAttributes()];
        double[] downsumR = new double[schema.getNbTargetAttributes()];
        double[] meansR = new double[schema.getNbTargetAttributes()];
        double[] ikkR = new double[schema.getNbTargetAttributes()];
        int k3 = 0;
        while (k3 < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k3];
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNumeric(exi);
                int n = k3;
                meansR[n] = meansR[n] + xi;
            }
            int n = k3++;
            meansR[n] = meansR[n] / (double)(N - M);
        }
        double avgikR = 0.0;
        double WR = 0.0;
        for (int k4 = 0; k4 < schema.getNbTargetAttributes(); ++k4) {
            NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k4];
            NumericAttrType xt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
            for (int i = M; i < N; ++i) {
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNumeric(exi);
                long xxi = (long)((ClusAttrType)xt).getNumeric(exi);
                for (int j = M; j < N; ++j) {
                    DataTuple exj = this.m_Data.getTuple(j);
                    double xj = ((ClusAttrType)type).getNumeric(exj);
                    long yyi = (long)((ClusAttrType)xt).getNumeric(exj);
                    double w = 0.0;
                    long indexI = xxi;
                    long indexJ = yyi;
                    if (indexI != indexJ) {
                        String indexMap;
                        Double temp;
                        if (indexI > indexJ) {
                            indexI = yyi;
                            indexJ = xxi;
                        }
                        w = (temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) != null ? temp : 0.0;
                        int n = k4;
                        upsumR[n] = upsumR[n] + w * (xi - xj) * (xi - xj);
                        WR += w;
                        continue;
                    }
                    WR += 1.0;
                    int n = k4;
                    upsumR[n] = upsumR[n] + (xi - xj) * (xi - xj);
                }
                int n = k4;
                downsumR[n] = downsumR[n] + (xi - meansR[k4]) * (xi - meansR[k4]);
            }
            if (downsumR[k4] != 0.0 && upsumR[k4] != 0.0) {
                ikkR[k4] = (double)(N - M - 1) * upsumR[k4] / (2.0 * WR * downsumR[k4]);
                avgikR += ikkR[k4];
                continue;
            }
            ikkR[k4] = 0.0;
        }
        double IR = avgikR /= (double)schema.getNbTargetAttributes();
        double I = 2.0 - (IL + IR * (double)(N - M)) / (double)NR;
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return I;
    }

    @Override
    public double calcGetisTotal(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_Data.getSchema();
        int M = 0;
        int N = this.m_Data.getNbRows();
        if (this.m_SplitIndex > 0) {
            N = this.m_SplitIndex;
        } else {
            M = -this.m_SplitIndex;
        }
        double[] upsum = new double[schema.getNbTargetAttributes()];
        double[] downsum = new double[schema.getNbTargetAttributes()];
        double[] ikk = new double[schema.getNbTargetAttributes()];
        double avgik = 0.0;
        for (int k = 0; k < schema.getNbTargetAttributes(); ++k) {
            NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k];
            for (int i = M; i < N; ++i) {
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNumeric(exi);
                for (int j = M; j < N; ++j) {
                    long indexMap;
                    DataTuple exj = this.m_Data.getTuple(j);
                    double xj = ((ClusAttrType)type).getNumeric(exj);
                    double w = 0.0;
                    long indexI = i;
                    long indexJ = j;
                    if (i == j) continue;
                    if (i > j) {
                        indexI = j;
                        indexJ = i;
                    }
                    w = GISHeuristic.m_distances.get(indexMap = indexI * (long)(N - M) + indexJ) != null ? GISHeuristic.m_distances.get(indexMap) : 0.0;
                    int n = k;
                    upsum[n] = upsum[n] + w * xi * xj;
                    int n2 = k;
                    downsum[n2] = downsum[n2] + xi * xj;
                }
            }
            if (downsum[k] != 0.0 && upsum[k] != 0.0) {
                ikk[k] = upsum[k] / downsum[k];
                avgik += ikk[k];
                continue;
            }
            avgik = 1.0;
        }
        double I = avgik /= (double)schema.getNbTargetAttributes();
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return I;
    }

    @Override
    public double calcLISAtotal(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_Data.getSchema();
        int M = 0;
        int N = this.m_Data.getNbRows();
        if (this.m_SplitIndex > 0) {
            N = this.m_SplitIndex;
        } else {
            M = -this.m_SplitIndex;
        }
        double[][] upsum = new double[schema.getNbTargetAttributes()][N];
        double[][] upsum1 = new double[schema.getNbTargetAttributes()][N];
        double[][] ik = new double[schema.getNbTargetAttributes()][N];
        double[] downsum = new double[schema.getNbTargetAttributes()];
        double[] means = new double[schema.getNbTargetAttributes()];
        double[] ikk = new double[schema.getNbTargetAttributes()];
        int k = 0;
        while (k < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k];
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNumeric(exi);
                int n = k;
                means[n] = means[n] + xi;
            }
            int n = k++;
            means[n] = means[n] / (double)(N - M);
        }
        double avgik = 0.0;
        for (int k2 = 0; k2 < schema.getNbTargetAttributes(); ++k2) {
            int i;
            NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k2];
            for (i = M; i < N; ++i) {
                for (int j = M; j < N; ++j) {
                    long indexMap;
                    DataTuple exj = this.m_Data.getTuple(j);
                    double xj = ((ClusAttrType)type).getNumeric(exj);
                    double w = 0.0;
                    long indexI = i;
                    long indexJ = j;
                    if (i == j) continue;
                    if (i > j) {
                        indexI = j;
                        indexJ = i;
                    }
                    w = GISHeuristic.m_distances.get(indexMap = indexI * (long)(N - M) + indexJ) != null ? GISHeuristic.m_distances.get(indexMap) : 0.0;
                    double[] dArray = upsum1[k2];
                    int n = permutation[i];
                    dArray[n] = dArray[n] + w * (xj - means[k2]);
                }
            }
            for (i = M; i < N; ++i) {
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNumeric(exi);
                upsum[k2][permutation[i].intValue()] = (xi - means[k2]) * upsum1[k2][permutation[i]];
                int n = k2;
                downsum[n] = downsum[n] + (xi - means[k2]) * (xi - means[k2]);
            }
            int n = k2;
            downsum[n] = downsum[n] / ((double)(N - M) + 0.0);
            for (i = M; i < N; ++i) {
                if (downsum[k2] != 0.0 && upsum[k2][permutation[i]] != 0.0) {
                    ik[k2][permutation[i].intValue()] = upsum[k2][permutation[i]] / downsum[k2];
                    int n2 = k2;
                    ikk[n2] = ikk[n2] + ik[k2][permutation[i]];
                    continue;
                }
                ikk[k2] = 0.0;
            }
            avgik += ikk[k2];
        }
        double I = avgik /= (double)schema.getNbTargetAttributes();
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return I;
    }

    @Override
    public double calcGLocalTotal(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_Data.getSchema();
        int M = 0;
        int N = this.m_Data.getNbRows();
        if (this.m_SplitIndex > 0) {
            N = this.m_SplitIndex;
        } else {
            M = -this.m_SplitIndex;
        }
        double[][] upsum = new double[schema.getNbTargetAttributes()][N];
        double[] downsum = new double[schema.getNbTargetAttributes()];
        double[] means = new double[schema.getNbTargetAttributes()];
        double[] ikk = new double[schema.getNbTargetAttributes()];
        double[][] ik = new double[schema.getNbTargetAttributes()][N];
        int k = 0;
        while (k < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k];
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNumeric(exi);
                int n = k;
                means[n] = means[n] + xi;
            }
            int n = k++;
            means[n] = means[n] / (double)(N - M);
        }
        double avgik = 0.0;
        for (int k2 = 0; k2 < schema.getNbTargetAttributes(); ++k2) {
            int i;
            NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k2];
            for (i = M; i < N; ++i) {
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNumeric(exi);
                for (int j = M; j < N; ++j) {
                    long indexMap;
                    DataTuple exj = this.m_Data.getTuple(j);
                    double xj = ((ClusAttrType)type).getNumeric(exj);
                    double w = 0.0;
                    long indexI = i;
                    long indexJ = j;
                    if (i == j) continue;
                    if (i > j) {
                        indexI = j;
                        indexJ = i;
                    }
                    w = GISHeuristic.m_distances.get(indexMap = indexI * (long)(N - M) + indexJ) != null ? GISHeuristic.m_distances.get(indexMap) : 0.0;
                    double[] dArray = upsum[k2];
                    int n = permutation[i];
                    dArray[n] = dArray[n] + w * (xi - xj) * (xi - xj);
                }
                int n = k2;
                downsum[n] = downsum[n] + (xi - means[k2]) * (xi - means[k2]);
            }
            for (i = M; i < N; ++i) {
                if (downsum[k2] != 0.0 && upsum[k2][permutation[i]] != 0.0) {
                    ik[k2][permutation[i].intValue()] = (double)(N - M) * upsum[k2][permutation[i]] / downsum[k2];
                    int n = k2;
                    ikk[n] = ikk[n] + ik[k2][permutation[i]];
                    continue;
                }
                ikk[k2] = 0.0;
            }
            avgik += ikk[k2];
        }
        double I = avgik /= (double)schema.getNbTargetAttributes();
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return I;
    }

    @Override
    public double calcLocalGetisTotal(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_Data.getSchema();
        int M = 0;
        int N = this.m_Data.getNbRows();
        if (this.m_SplitIndex > 0) {
            N = this.m_SplitIndex;
        } else {
            M = -this.m_SplitIndex;
        }
        double[][] upsum = new double[schema.getNbTargetAttributes()][N];
        double[][] downsum = new double[schema.getNbTargetAttributes()][N];
        double[] means = new double[schema.getNbTargetAttributes()];
        double[] ikk = new double[schema.getNbTargetAttributes()];
        double[][] ik = new double[schema.getNbTargetAttributes()][N];
        int k = 0;
        while (k < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k];
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNumeric(exi);
                int n = k;
                means[n] = means[n] + xi;
            }
            int n = k++;
            means[n] = means[n] / (double)(N - M);
        }
        double avgik = 0.0;
        for (int k2 = 0; k2 < schema.getNbTargetAttributes(); ++k2) {
            NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k2];
            for (int i = M; i < N; ++i) {
                for (int j = M; j < N; ++j) {
                    long indexMap;
                    DataTuple exj = this.m_Data.getTuple(j);
                    double xj = ((ClusAttrType)type).getNumeric(exj);
                    double w = 0.0;
                    long indexI = i;
                    long indexJ = j;
                    if (i == j) continue;
                    if (i > j) {
                        indexI = j;
                        indexJ = i;
                    }
                    w = GISHeuristic.m_distances.get(indexMap = indexI * (long)(N - M) + indexJ) != null ? GISHeuristic.m_distances.get(indexMap) : 0.0;
                    double[] dArray = upsum[k2];
                    int n = permutation[i];
                    dArray[n] = dArray[n] + w * xj;
                    double[] dArray2 = downsum[k2];
                    int n2 = permutation[i];
                    dArray2[n2] = dArray2[n2] + xj;
                }
                if (upsum[k2][permutation[i]] != 0.0) {
                    ik[k2][permutation[i].intValue()] = upsum[k2][permutation[i]] / downsum[k2][permutation[i]];
                    int n = k2;
                    ikk[n] = ikk[n] + ik[k2][permutation[i]];
                } else {
                    ikk[k2] = 0.0;
                }
                avgik += ikk[k2];
            }
        }
        double I = avgik /= (double)schema.getNbTargetAttributes();
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return I;
    }

    @Override
    public double calcGETIStotal(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_Data.getSchema();
        int M = 0;
        int N = this.m_Data.getNbRows();
        if (this.m_SplitIndex > 0) {
            N = this.m_SplitIndex;
        } else {
            M = -this.m_SplitIndex;
        }
        double[][] upsum = new double[schema.getNbTargetAttributes()][N];
        double[][] upsum1 = new double[schema.getNbTargetAttributes()][N];
        double[][] downsum1 = new double[schema.getNbTargetAttributes()][N];
        double[][] downsum2 = new double[schema.getNbTargetAttributes()][N];
        double[][] ik = new double[schema.getNbTargetAttributes()][N];
        double[] downsum = new double[schema.getNbTargetAttributes()];
        double[] means = new double[schema.getNbTargetAttributes()];
        double[] ikk = new double[schema.getNbTargetAttributes()];
        int k = 0;
        while (k < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k];
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNumeric(exi);
                int n = k;
                means[n] = means[n] + xi;
            }
            int n = k++;
            means[n] = means[n] / (double)(N - M);
        }
        double avgik = 0.0;
        double[] W = new double[N];
        for (int k2 = 0; k2 < schema.getNbTargetAttributes(); ++k2) {
            int i;
            NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[k2];
            for (i = M; i < N; ++i) {
                DataTuple exi = this.m_Data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNumeric(exi);
                for (int j = M; j < N; ++j) {
                    long indexMap;
                    DataTuple exj = this.m_Data.getTuple(j);
                    double xj = ((ClusAttrType)type).getNumeric(exj);
                    double w = 0.0;
                    long indexI = i;
                    long indexJ = j;
                    if (i == j) continue;
                    if (i > j) {
                        indexI = j;
                        indexJ = i;
                    }
                    w = GISHeuristic.m_distances.get(indexMap = indexI * (long)(N - M) + indexJ) != null ? GISHeuristic.m_distances.get(indexMap) : 0.0;
                    double[] dArray = upsum1[k2];
                    int n = permutation[i];
                    dArray[n] = dArray[n] + w * xj;
                    double[] dArray2 = downsum1[k2];
                    int n2 = permutation[i];
                    dArray2[n2] = dArray2[n2] + w * w;
                    int n3 = permutation[i];
                    W[n3] = W[n3] + w;
                }
                upsum[k2][permutation[i].intValue()] = upsum1[k2][permutation[i]] - means[k2] * W[permutation[i]];
                int n = k2;
                downsum[n] = downsum[n] + (xi - means[k2]) * (xi - means[k2]);
                downsum2[k2][permutation[i].intValue()] = (double)(N - M) * downsum1[k2][permutation[i]] - W[permutation[i]] * W[permutation[i]];
            }
            for (i = M; i < N; ++i) {
                if (downsum[k2] != 0.0 && upsum[k2][permutation[i]] != 0.0 && downsum2[k2][permutation[i]] != 0.0) {
                    ik[k2][permutation[i].intValue()] = upsum[k2][permutation[i]] / Math.sqrt(downsum[k2] / (double)((N - M) * (N - M - 1)) * downsum2[k2][permutation[i]]);
                    int n = k2;
                    ikk[n] = ikk[n] + ik[k2][permutation[i]];
                    continue;
                }
                ikk[k2] = 0.0;
            }
            avgik += ikk[k2];
        }
        double I = avgik /= (double)schema.getNbTargetAttributes();
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return I;
    }

    public double getCalcItotal() {
        return this.m_I;
    }

    public void setCalcItotal(double ii) {
        this.m_I = ii;
    }

    @Override
    public void setData(RowData data) {
        this.m_Data = data;
    }

    @Override
    public void setSplitIndex(int i) {
        this.m_SplitIndex = i;
    }

    public int getSplitIndex() {
        return this.m_SplitIndex;
    }

    @Override
    public void setPrevIndex(int i) {
        this.m_PrevIndex = i;
    }

    public int getPrevIndex() {
        return this.m_PrevIndex;
    }

    @Override
    public void initializeSum() {
        Arrays.fill(this.m_PreviousSumX, 0.0);
        Arrays.fill(this.m_PreviousSumXR, 0.0);
        Arrays.fill(this.m_PreviousSumW, 0.0);
        Arrays.fill(this.m_PreviousSumWXX, 0.0);
        Arrays.fill(this.m_PreviousSumWX, 0.0);
        Arrays.fill(this.m_PreviousSumX2, 0.0);
        Arrays.fill(this.m_PreviousSumWR, 0.0);
        Arrays.fill(this.m_PreviousSumWXXR, 0.0);
        Arrays.fill(this.m_PreviousSumWXR, 0.0);
        Arrays.fill(this.m_PreviousSumX2R, 0.0);
    }

    public RowData getData() {
        return this.m_Data;
    }

    @Override
    public void setParentStat(ClusStatistic parent) {
        this.m_ParentStat = (RegressionStat)parent;
    }

    @Override
    public double getTargetSumWeights() {
        return this.m_SumWeightLabeled;
    }

    @Override
    public boolean samePrediction(ClusStatistic other) {
        RegressionStat rstat = (RegressionStat)other;
        for (int i = 0; i < this.m_NbAttrs; ++i) {
            if (this.getMean(i) == rstat.getMean(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ClusStatistic getParentStat() {
        return this.m_ParentStat;
    }
}

