/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.statistic;

import si.ijs.kt.clus.data.attweights.ClusAttributeWeights;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.RegressionStat;

@Deprecated
public class GISStat
extends RegressionStat {
    public static final long serialVersionUID = 1L;
    public int m_NbTarget;
    public double[] m_SumValues;
    public double[] m_SumSqValues;
    public GISStat m_Training;

    public GISStat(Settings sett, NumericAttrType[] attrs) {
        this(sett, attrs, false);
    }

    public GISStat(Settings sett, NumericAttrType[] attrs, boolean onlymean) {
        super(sett, attrs, onlymean);
        if (!onlymean) {
            this.m_SumValues = new double[this.m_NbAttrs];
            this.m_SumWeights = new double[this.m_NbAttrs];
            this.m_SumSqValues = new double[this.m_NbAttrs];
            this.m_NbTarget = attrs.length;
        }
    }

    @Override
    public void setTrainingStat(ClusStatistic train) {
        this.m_Training = (GISStat)train;
    }

    @Override
    public ClusStatistic cloneStat() {
        GISStat res = new GISStat(this.getSettings(), this.m_Attrs, false);
        res.m_Training = this.m_Training;
        res.m_NbTarget = this.m_NbTarget;
        return res;
    }

    @Override
    public ClusStatistic cloneSimple() {
        GISStat res = new GISStat(this.getSettings(), this.m_Attrs, true);
        res.m_Training = this.m_Training;
        res.m_NbTarget = this.m_NbTarget;
        return res;
    }

    @Override
    public ClusStatistic copyNormalizedWeighted(double weight) {
        GISStat newStat = this.normalizedCopy();
        for (int iTarget = 0; iTarget < newStat.getNbAttributes(); ++iTarget) {
            newStat.m_Means[iTarget] = weight * newStat.m_Means[iTarget];
        }
        return newStat;
    }

    @Override
    public void copy(ClusStatistic other) {
        GISStat or = (GISStat)other;
        this.m_SumWeight = or.m_SumWeight;
        this.m_NbExamples = or.m_NbExamples;
        this.m_NbTarget = or.m_NbTarget;
        System.arraycopy(or.m_SumWeights, 0, this.m_SumWeights, 0, this.m_NbAttrs);
        System.arraycopy(or.m_SumValues, 0, this.m_SumValues, 0, this.m_NbAttrs);
        System.arraycopy(or.m_SumSqValues, 0, this.m_SumSqValues, 0, this.m_NbAttrs);
    }

    @Override
    public GISStat normalizedCopy() {
        GISStat copy = (GISStat)this.cloneSimple();
        copy.m_NbExamples = 0;
        copy.m_SumWeight = 1.0;
        this.calcMean(copy.m_Means);
        return copy;
    }

    @Override
    public void add(ClusStatistic other) {
        GISStat or = (GISStat)other;
        this.m_SumWeight += or.m_SumWeight;
        this.m_NbExamples += or.m_NbExamples;
        for (int i = 0; i < this.m_NbAttrs; ++i) {
            int n = i;
            this.m_SumWeights[n] = this.m_SumWeights[n] + or.m_SumWeights[i];
            int n2 = i;
            this.m_SumValues[n2] = this.m_SumValues[n2] + or.m_SumValues[i];
            int n3 = i;
            this.m_SumSqValues[n3] = this.m_SumSqValues[n3] + or.m_SumSqValues[i];
        }
    }

    @Override
    public void addScaled(double scale, ClusStatistic other) {
        GISStat or = (GISStat)other;
        this.m_SumWeight += scale * or.m_SumWeight;
        this.m_NbExamples += or.m_NbExamples;
        for (int i = 0; i < this.m_NbAttrs; ++i) {
            int n = i;
            this.m_SumWeights[n] = this.m_SumWeights[n] + scale * or.m_SumWeights[i];
            int n2 = i;
            this.m_SumValues[n2] = this.m_SumValues[n2] + scale * or.m_SumValues[i];
            int n3 = i;
            this.m_SumSqValues[n3] = this.m_SumSqValues[n3] + scale * or.m_SumSqValues[i];
        }
    }

    @Override
    public void subtractFromThis(ClusStatistic other) {
        GISStat or = (GISStat)other;
        this.m_SumWeight -= or.m_SumWeight;
        this.m_NbExamples -= or.m_NbExamples;
        for (int i = 0; i < this.m_NbAttrs; ++i) {
            int n = i;
            this.m_SumWeights[n] = this.m_SumWeights[n] - or.m_SumWeights[i];
            int n2 = i;
            this.m_SumValues[n2] = this.m_SumValues[n2] - or.m_SumValues[i];
            int n3 = i;
            this.m_SumSqValues[n3] = this.m_SumSqValues[n3] - or.m_SumSqValues[i];
        }
    }

    @Override
    public void subtractFromOther(ClusStatistic other) {
        GISStat or = (GISStat)other;
        this.m_SumWeight = or.m_SumWeight - this.m_SumWeight;
        this.m_NbExamples = or.m_NbExamples - this.m_NbExamples;
        for (int i = 0; i < this.m_NbAttrs; ++i) {
            this.m_SumWeights[i] = or.m_SumWeights[i] - this.m_SumWeights[i];
            this.m_SumValues[i] = or.m_SumValues[i] - this.m_SumValues[i];
            this.m_SumSqValues[i] = or.m_SumSqValues[i] - this.m_SumSqValues[i];
        }
    }

    public double getVarLisa(int i) {
        double n_tot = this.m_SumWeight;
        double k_tot = this.m_SumWeights[i];
        double sv_tot = this.m_SumValues[i];
        double ss_tot = this.m_SumSqValues[i];
        if (k_tot <= 1.0E-9 && this.m_Training != null) {
            return this.m_Training.getSVarS(i);
        }
        return k_tot > 1.0 ? ss_tot * (n_tot - 1.0) / (k_tot - 1.0) - n_tot * sv_tot / k_tot * sv_tot / k_tot : 0.0;
    }

    public double getVarLisa(ClusAttributeWeights scale) {
        double result = 0.0;
        for (int i = 0; i < this.m_NbAttrs; ++i) {
            double n_tot = this.m_SumWeight;
            double k_tot = this.m_SumWeights[i];
            double sv_tot = this.m_SumValues[i];
            double ss_tot = this.m_SumSqValues[i];
            if (k_tot == n_tot) {
                result += (ss_tot - sv_tot * sv_tot / n_tot) * scale.getWeight(this.m_Attrs[i]);
                continue;
            }
            if (k_tot <= 1.0E-9 && this.m_Training != null) {
                result += this.m_Training.getSVarS(i) * scale.getWeight(this.m_Attrs[i]);
                continue;
            }
            result += (ss_tot * (n_tot - 1.0) / (k_tot - 1.0) - n_tot * sv_tot / k_tot * sv_tot / k_tot) * scale.getWeight(this.m_Attrs[i]);
        }
        return result / (double)this.m_NbAttrs;
    }

    public double getVarLisaDiff(ClusAttributeWeights scale, ClusStatistic other) {
        double result = 0.0;
        RegressionStat or = (RegressionStat)other;
        for (int i = 0; i < this.m_NbAttrs; ++i) {
            double n_tot = this.m_SumWeight - or.m_SumWeight;
            double k_tot = this.m_SumWeights[i] - or.getSumWeights(i);
            double sv_tot = this.m_SumValues[i] - or.getSumValues(i);
            double ss_tot = this.m_SumSqValues[i] - or.getSumSqValues(i);
            if (k_tot == n_tot) {
                result += (ss_tot - sv_tot * sv_tot / n_tot) * scale.getWeight(this.m_Attrs[i]);
                continue;
            }
            if (k_tot <= 1.0E-9 && this.m_Training != null) {
                result += this.m_Training.getSVarS(i) * scale.getWeight(this.m_Attrs[i]);
                continue;
            }
            result += (ss_tot * (n_tot - 1.0) / (k_tot - 1.0) - n_tot * sv_tot / k_tot * sv_tot / k_tot) * scale.getWeight(this.m_Attrs[i]);
        }
        return result / (double)this.m_NbAttrs;
    }

    public GISStat getGISStat() {
        return this;
    }
}

