/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.statistic;

import java.util.ArrayList;
import si.ijs.kt.clus.data.attweights.ClusAttributeWeights;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.statistic.ClassificationStat;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.CombStat;
import si.ijs.kt.clus.statistic.RegressionStat;
import si.ijs.kt.clus.statistic.StatisticPrintInfo;
import si.ijs.kt.clus.statistic.WHTDStatistic;

public class CombStatClassRegHier
extends CombStat {
    public static final long serialVersionUID = 1L;
    protected WHTDStatistic m_HierStat;

    public CombStatClassRegHier(ClusStatManager statManager, RegressionStat reg, ClassificationStat cls, WHTDStatistic hier) {
        super(statManager, reg, cls);
        this.m_HierStat = hier;
    }

    public CombStatClassRegHier(ClusStatManager statManager, NumericAttrType[] num, NominalAttrType[] nom, WHTDStatistic hier) {
        super(statManager, num, nom);
        this.m_HierStat = hier;
    }

    @Override
    public ClusStatistic cloneStat() {
        return new CombStatClassRegHier(this.m_StatManager, (RegressionStat)this.m_RegStat.cloneStat(), (ClassificationStat)this.m_ClassStat.cloneStat(), (WHTDStatistic)this.m_HierStat.cloneStat());
    }

    @Override
    public ClusStatistic cloneSimple() {
        return new CombStatClassRegHier(this.m_StatManager, (RegressionStat)this.m_RegStat.cloneSimple(), (ClassificationStat)this.m_ClassStat.cloneSimple(), (WHTDStatistic)this.m_HierStat.cloneSimple());
    }

    public WHTDStatistic getHierarchicalStat() {
        return this.m_HierStat;
    }

    @Override
    public void setParentStat(ClusStatistic parent) {
        CombStatClassRegHier cstat = (CombStatClassRegHier)parent;
        this.getClassificationStat().setParentStat(cstat.getClassificationStat());
        this.getRegressionStat().setParentStat(cstat.getRegressionStat());
        this.getHierarchicalStat().setParentStat(cstat.getHierarchicalStat());
    }

    @Override
    public ClusStatistic getParentStat() {
        return new CombStatClassRegHier(this.m_StatManager, (RegressionStat)this.m_RegStat.getParentStat(), (ClassificationStat)this.m_ClassStat.getParentStat(), (WHTDStatistic)this.m_HierStat.getParentStat());
    }

    @Override
    public void setTrainingStat(ClusStatistic train) {
        CombStatClassRegHier ctrain = (CombStatClassRegHier)train;
        this.m_RegStat.setTrainingStat(ctrain.getRegressionStat());
        this.m_ClassStat.setTrainingStat(ctrain.getClassificationStat());
        this.m_HierStat.setTrainingStat(ctrain.getHierarchicalStat());
    }

    @Override
    public void updateWeighted(DataTuple tuple, double weight) {
        this.m_RegStat.updateWeighted(tuple, weight);
        this.m_ClassStat.updateWeighted(tuple, weight);
        this.m_HierStat.updateWeighted(tuple, weight);
        this.m_SumWeight += weight;
    }

    @Override
    public void updateWeighted(DataTuple tuple, int idx) {
        this.m_RegStat.updateWeighted(tuple, tuple.getWeight());
        this.m_ClassStat.updateWeighted(tuple, tuple.getWeight());
        this.m_HierStat.updateWeighted(tuple, tuple.getWeight());
        this.m_SumWeight += tuple.getWeight();
    }

    @Override
    public void calcMean() {
        this.m_RegStat.calcMean();
        this.m_ClassStat.calcMean();
        this.m_HierStat.calcMean();
    }

    @Override
    public double getSVarS(ClusAttributeWeights scale) {
        int nbClusteringNom = this.m_ClassStat.getNbNominalAttributes();
        int nbClusteringNum = this.m_RegStat.getNbNumericAttributes();
        int nbTargetHier = this.m_HierStat.getNbAttributes();
        if (nbClusteringNom == 0) {
            return (this.m_RegStat.getSVarS(scale) * (double)nbClusteringNum + this.m_HierStat.getSVarS(scale) * (double)nbTargetHier) / (double)(nbClusteringNum + 1);
        }
        if (nbClusteringNum == 0) {
            return (this.m_ClassStat.getSVarS(scale) * (double)nbClusteringNom + this.m_HierStat.getSVarS(scale) * (double)nbTargetHier) / (double)(nbClusteringNom + 1);
        }
        return (this.m_ClassStat.getSVarS(scale) * (double)nbClusteringNom + this.m_RegStat.getSVarS(scale) * (double)nbClusteringNum + this.m_HierStat.getSVarS(scale) * (double)nbTargetHier) / (double)(nbClusteringNom + nbClusteringNum + 1);
    }

    @Override
    public double getSVarSDiff(ClusAttributeWeights scale, ClusStatistic other) {
        int nbClusteringNom = this.m_ClassStat.getNbNominalAttributes();
        int nbClusteringNum = this.m_RegStat.getNbNumericAttributes();
        int nbTargetHier = this.m_HierStat.getNbAttributes();
        ClassificationStat ocls = ((CombStat)other).getClassificationStat();
        RegressionStat oreg = ((CombStat)other).getRegressionStat();
        WHTDStatistic ohier = ((CombStatClassRegHier)other).getHierarchicalStat();
        if (nbClusteringNom == 0) {
            return (this.m_RegStat.getSVarSDiff(scale, (ClusStatistic)oreg) * (double)nbClusteringNum + this.m_HierStat.getSVarSDiff(scale, ohier) * (double)nbTargetHier) / (double)(nbClusteringNum + 1);
        }
        if (nbClusteringNum == 0) {
            return (this.m_ClassStat.getSVarSDiff(scale, ocls) * (double)nbClusteringNom + this.m_HierStat.getSVarSDiff(scale, ohier) * (double)nbTargetHier) / (double)(nbClusteringNom + nbClusteringNum + 1);
        }
        return (this.m_ClassStat.getSVarSDiff(scale, ocls) * (double)nbClusteringNom + this.m_RegStat.getSVarSDiff(scale, (ClusStatistic)oreg) * (double)nbClusteringNum + this.m_HierStat.getSVarSDiff(scale, ohier) * (double)nbTargetHier) / (double)(nbClusteringNom + nbClusteringNum + 1);
    }

    @Override
    public String getString(StatisticPrintInfo info) {
        return "ClassificationStat: " + this.m_ClassStat.getString() + " RegressionStat: " + this.m_RegStat.toString() + " HierarchicalStat:" + this.m_HierStat.getString();
    }

    @Override
    public String getPredictedClassName(int idx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getArrayOfStatistic() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void reset() {
        this.m_RegStat.reset();
        this.m_ClassStat.reset();
        this.m_HierStat.reset();
        this.m_SumWeight = 0.0;
    }

    @Override
    public void copy(ClusStatistic other) {
        CombStatClassRegHier or = (CombStatClassRegHier)other;
        this.m_SumWeight = or.m_SumWeight;
        this.m_StatManager = or.m_StatManager;
        this.m_RegStat.copy(or.m_RegStat);
        this.m_ClassStat.copy(or.m_ClassStat);
        this.m_HierStat.copy(or.m_HierStat);
    }

    @Override
    public void addPrediction(ClusStatistic other, double weight) {
        CombStatClassRegHier or = (CombStatClassRegHier)other;
        this.m_RegStat.addPrediction(or.m_RegStat, weight);
        this.m_ClassStat.addPrediction(or.m_ClassStat, weight);
        this.m_HierStat.addPrediction(or.m_HierStat, weight);
    }

    @Override
    public void add(ClusStatistic other) {
        CombStatClassRegHier or = (CombStatClassRegHier)other;
        this.m_RegStat.add(or.m_RegStat);
        this.m_ClassStat.add(or.m_ClassStat);
        this.m_HierStat.add(or.m_HierStat);
        this.m_SumWeight += or.m_SumWeight;
    }

    @Override
    public void subtractFromThis(ClusStatistic other) {
        CombStatClassRegHier or = (CombStatClassRegHier)other;
        this.m_RegStat.subtractFromThis(or.m_RegStat);
        this.m_ClassStat.subtractFromThis(or.m_ClassStat);
        this.m_HierStat.subtractFromThis(or.m_HierStat);
        this.m_SumWeight -= or.m_SumWeight;
    }

    @Override
    public void subtractFromOther(ClusStatistic other) {
        CombStatClassRegHier or = (CombStatClassRegHier)other;
        this.m_RegStat.subtractFromOther(or.m_RegStat);
        this.m_ClassStat.subtractFromOther(or.m_ClassStat);
        this.m_HierStat.subtractFromOther(or.m_HierStat);
        this.m_SumWeight = or.m_SumWeight - this.m_SumWeight;
    }

    public void vote(ArrayList votes) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean samePrediction(ClusStatistic other) {
        CombStatClassRegHier cstat = (CombStatClassRegHier)other;
        return this.getClassificationStat().samePrediction(cstat.getClassificationStat()) && this.getRegressionStat().samePrediction(cstat.getRegressionStat()) && this.getHierarchicalStat().samePrediction(cstat.getHierarchicalStat());
    }

    @Override
    public double getTargetSumWeights() {
        return this.m_HierStat.getTargetSumWeights();
    }
}

