/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.statistic;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.attweights.ClusAttributeWeights;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.ext.ensemble.ClusOOBWeights;
import si.ijs.kt.clus.ext.ensemble.ros.ClusROSForestInfo;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.statistic.ClassificationStat;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.RegressionStat;
import si.ijs.kt.clus.statistic.StatisticPrintInfo;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.format.ClusFormat;
import si.ijs.kt.clus.util.format.ClusNumberFormat;

public class CombStat
extends ClusStatistic {
    public static final long serialVersionUID = 1L;
    public static int IN_HEURISTIC = 0;
    public static int IN_OUTPUT = 1;
    protected RegressionStat m_RegStat;
    protected ClassificationStat m_ClassStat;
    protected ClusStatManager m_StatManager;

    private CombStat(Settings sett) {
        super(sett);
    }

    public CombStat(ClusStatManager statManager, NumericAttrType[] num, NominalAttrType[] nom) {
        this(statManager.getSettings());
        this.m_StatManager = statManager;
        this.m_RegStat = new RegressionStat(statManager.getSettings(), num);
        this.m_ClassStat = statManager.getSettings().getMLC().getSectionMultiLabel().isEnabled() ? new ClassificationStat(statManager.getSettings(), nom, statManager.getSettings().getMLC().getMultiLabelThreshold()) : new ClassificationStat(statManager.getSettings(), nom);
    }

    public CombStat(ClusStatManager statManager, RegressionStat reg, ClassificationStat cls) {
        this(statManager.getSettings());
        this.m_StatManager = statManager;
        this.m_RegStat = reg;
        this.m_ClassStat = cls;
    }

    @Override
    public ClusStatistic cloneStat() {
        return new CombStat(this.m_StatManager, (RegressionStat)this.m_RegStat.cloneStat(), (ClassificationStat)this.m_ClassStat.cloneStat());
    }

    @Override
    public ClusStatistic cloneSimple() {
        return new CombStat(this.m_StatManager, (RegressionStat)this.m_RegStat.cloneSimple(), (ClassificationStat)this.m_ClassStat.cloneSimple());
    }

    @Override
    public RegressionStat getRegressionStat() {
        return this.m_RegStat;
    }

    @Override
    public ClassificationStat getClassificationStat() {
        return this.m_ClassStat;
    }

    @Override
    public void setTrainingStat(ClusStatistic train) {
        this.m_RegStat.setTrainingStat(train.getRegressionStat());
        this.m_ClassStat.setTrainingStat(train.getClassificationStat());
    }

    @Override
    public void updateWeighted(DataTuple tuple, double weight) {
        this.m_RegStat.updateWeighted(tuple, weight);
        this.m_ClassStat.updateWeighted(tuple, weight);
        this.m_SumWeight += weight;
    }

    @Override
    public void updateWeighted(DataTuple tuple, int idx) {
        this.m_RegStat.updateWeighted(tuple, tuple.getWeight());
        this.m_ClassStat.updateWeighted(tuple, tuple.getWeight());
        this.m_SumWeight += tuple.getWeight();
    }

    @Override
    public void calcMean() {
        this.m_RegStat.calcMean();
        this.m_ClassStat.calcMean();
    }

    @Override
    public double getDispersion(ClusAttributeWeights scale, RowData data) {
        return this.dispersionCalc();
    }

    public double dispersionCalc() {
        return this.dispersion(IN_OUTPUT);
    }

    public double dispersionAdtHeur() {
        double offset = this.getSettings().getRules().getHeurDispOffset();
        double disp = this.dispersion(IN_HEURISTIC) + offset;
        double train_sum_w = this.m_StatManager.getTrainSetStat().getTotalWeight();
        double cov_par = this.getSettings().getRules().getHeurCoveragePar();
        disp -= cov_par * this.m_SumWeight / train_sum_w / 2.0;
        if (this.getSettings().getRules().isHeurPrototypeDistPar()) {
            double proto_par = this.getSettings().getRules().getHeurPrototypeDistPar();
            double proto_val = this.prototypeDifference((CombStat)this.m_StatManager.getTrainSetStat());
            disp -= proto_par * proto_val;
        }
        if (this.getSettings().getRules().getIS_RULE_SIG_TESTING()) {
            int thresh = this.getSettings().getRules().getRuleNbSigAtt();
            if (thresh > 0) {
                int sign_diff = this.signDifferent();
                if (sign_diff < thresh) {
                    disp += 1000.0;
                }
            } else if (thresh < 0 && !this.targetSignDifferent()) {
                disp += 1000.0;
            }
        }
        return disp;
    }

    public double rDispersionAdtHeur() {
        double offset = this.getSettings().getRules().getHeurDispOffset();
        double disp = this.dispersion(IN_HEURISTIC) + offset;
        double def_disp = ((CombStat)this.m_StatManager.getTrainSetStat()).dispersion(IN_HEURISTIC);
        disp -= def_disp;
        double train_sum_w = this.m_StatManager.getTrainSetStat().getTotalWeight();
        double cov_par = this.getSettings().getRules().getHeurCoveragePar();
        disp -= cov_par * this.m_SumWeight / train_sum_w / 2.0;
        if (this.getSettings().getRules().isHeurPrototypeDistPar()) {
            double proto_par = this.getSettings().getRules().getHeurPrototypeDistPar();
            double proto_val = this.prototypeDifference((CombStat)this.m_StatManager.getTrainSetStat());
            disp -= proto_par * proto_val;
        }
        if (this.getSettings().getRules().getIS_RULE_SIG_TESTING()) {
            int thresh = this.getSettings().getRules().getRuleNbSigAtt();
            if (thresh > 0) {
                int sign_diff = this.signDifferent();
                if (sign_diff < thresh) {
                    disp += 1000.0;
                }
            } else if (thresh < 0 && !this.targetSignDifferent()) {
                disp += 1000.0;
            }
        }
        return disp;
    }

    public double dispersionMltHeur() {
        double offset = this.getSettings().getRules().getHeurDispOffset();
        double disp = this.dispersion(IN_HEURISTIC) + offset;
        double train_sum_w = this.m_StatManager.getTrainSetStat().getTotalWeight();
        double cov_par = this.getSettings().getRules().getHeurCoveragePar();
        disp *= Math.pow(this.m_SumWeight / train_sum_w, cov_par);
        if (this.getSettings().getRules().isHeurPrototypeDistPar()) {
            double proto_par = this.getSettings().getRules().getHeurPrototypeDistPar();
            double proto_val = this.prototypeDifference((CombStat)this.m_StatManager.getTrainSetStat());
            double d = disp = proto_val > 0.0 ? disp / Math.pow(proto_val, proto_par) : 0.0;
        }
        if (this.getSettings().getRules().getIS_RULE_SIG_TESTING()) {
            int thresh = this.getSettings().getRules().getRuleNbSigAtt();
            if (thresh > 0) {
                int sign_diff = this.signDifferent();
                if (sign_diff < thresh) {
                    disp *= 1000.0;
                }
            } else if (thresh < 0 && !this.targetSignDifferent()) {
                disp *= 1000.0;
            }
        }
        return disp;
    }

    public double rDispersionMltHeur() {
        double offset = this.getSettings().getRules().getHeurDispOffset();
        double disp = this.dispersion(IN_HEURISTIC) + offset;
        double def_disp = ((CombStat)this.m_StatManager.getTrainSetStat()).dispersion(IN_HEURISTIC);
        disp -= def_disp;
        double train_sum_w = this.m_StatManager.getTrainSetStat().getTotalWeight();
        double cov_par = this.getSettings().getRules().getHeurCoveragePar();
        disp *= Math.pow(this.m_SumWeight / train_sum_w, cov_par);
        if (this.getSettings().getRules().isHeurPrototypeDistPar()) {
            double proto_par = this.getSettings().getRules().getHeurPrototypeDistPar();
            double proto_val = this.prototypeDifference((CombStat)this.m_StatManager.getTrainSetStat());
            double d = disp = proto_val > 0.0 ? disp / Math.pow(proto_val, proto_par) : 0.0;
        }
        if (this.getSettings().getRules().getIS_RULE_SIG_TESTING()) {
            int thresh = this.getSettings().getRules().getRuleNbSigAtt();
            if (thresh > 0) {
                int sign_diff = this.signDifferent();
                if (sign_diff < thresh) {
                    disp *= 1000.0;
                }
            } else if (thresh < 0 && !this.targetSignDifferent()) {
                disp *= 1000.0;
            }
        }
        return disp;
    }

    public double dispersion(int use) {
        return this.dispersionNom(use) + this.meanVariance(use);
    }

    public double dispersionNum(int use) {
        return this.meanVariance(use);
    }

    public double dispersionNom(int use) {
        return this.meanDistNom(use);
    }

    public double meanVariance(int use) {
        double sumvar = 0.0;
        double norm = this.getSettings().getRules().getVarBasedDispNormWeight();
        for (int i = 0; i < this.m_RegStat.getNbNumericAttributes(); ++i) {
            double weight = use == IN_HEURISTIC ? this.m_StatManager.getClusteringWeights().getWeight(this.m_RegStat.getAttribute(i)) : this.m_StatManager.getDispersionWeights().getWeight(this.m_RegStat.getAttribute(i));
            sumvar += this.m_RegStat.getVariance(i) * weight / (norm * norm);
        }
        return sumvar;
    }

    public double meanDistNom(int use) {
        double sumdist = 0.0;
        double weight = 0.0;
        for (int i = 0; i < this.m_ClassStat.getNbNominalAttributes(); ++i) {
            weight = use == IN_HEURISTIC ? this.m_StatManager.getClusteringWeights().getWeight(this.m_ClassStat.getAttribute(i)) : this.m_StatManager.getDispersionWeights().getWeight(this.m_ClassStat.getAttribute(i));
            sumdist += this.meanDistNomOne(i) * weight;
        }
        return sumdist;
    }

    public double meanDistNomOne(int attr_idx) {
        int i;
        double[] counts = this.m_ClassStat.m_ClassCounts[attr_idx];
        double[] prototype = new double[counts.length];
        double sum = 0.0;
        double dist = 0.0;
        int nbval = counts.length;
        for (i = 0; i < nbval; ++i) {
            sum += counts[i];
        }
        for (i = 0; i < nbval; ++i) {
            prototype[i] = sum != 0.0 ? counts[i] / sum : 0.0;
        }
        for (i = 0; i < nbval; ++i) {
            dist += (1.0 - prototype[i]) * counts[i];
        }
        dist = (dist = dist * (double)nbval / (double)(nbval - 1)) != 0.0 ? dist / sum : 0.0;
        return dist;
    }

    public double meanEntropy() {
        double sent = 0.0;
        int nbNominal = this.m_ClassStat.getNbNominalAttributes();
        for (int i = 0; i < nbNominal; ++i) {
            sent += this.entropy(i);
        }
        return sent / (double)nbNominal;
    }

    public double entropy(int attr) {
        return this.m_ClassStat.entropy(attr);
    }

    public double prototypeDifference(CombStat stat) {
        double weight;
        int i;
        double sumdiff = 0.0;
        for (i = 0; i < this.m_RegStat.getNbNumericAttributes(); ++i) {
            weight = this.m_StatManager.getClusteringWeights().getWeight(this.m_RegStat.getAttribute(i));
            sumdiff += Math.abs(this.prototypeNum(i) - stat.prototypeNum(i)) * weight;
        }
        for (i = 0; i < this.m_ClassStat.getNbNominalAttributes(); ++i) {
            weight = this.m_StatManager.getClusteringWeights().getWeight(this.m_ClassStat.getAttribute(i));
            double sum = 0.0;
            double[] proto1 = this.prototypeNom(i);
            double[] proto2 = stat.prototypeNom(i);
            for (int j = 0; j < proto1.length; ++j) {
                sum += Math.abs(proto1[j] - proto2[j]);
            }
            sumdiff += sum * weight;
        }
        return sumdiff != 0.0 ? sumdiff : 0.0;
    }

    public double[] prototypeNom(int attr_idx) {
        int i;
        double[] counts = this.m_ClassStat.m_ClassCounts[attr_idx];
        double[] prototype = new double[counts.length];
        double sum = 0.0;
        int nbval = counts.length;
        for (i = 0; i < nbval; ++i) {
            sum += counts[i];
        }
        for (i = 0; i < nbval; ++i) {
            prototype[i] = sum != 0.0 ? counts[i] / sum : 0.0;
        }
        return prototype;
    }

    public double prototypeNum(int attr_idx) {
        return this.m_RegStat.getMean(attr_idx);
    }

    public int signDifferent() {
        int i;
        int sign_diff = 0;
        for (i = 0; i < this.m_ClassStat.getNbAttributes(); ++i) {
            if (!this.SignDifferentNom(i)) continue;
            ++sign_diff;
        }
        for (i = 0; i < this.m_RegStat.getNbAttributes(); ++i) {
            try {
                if (!this.SignDifferentNum(i)) continue;
                ++sign_diff;
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        ClusLogger.info("Nb.sig.atts: " + sign_diff);
        return sign_diff;
    }

    public boolean targetSignDifferent() {
        boolean res = false;
        int att = -1;
        ClusStatistic targetStat = this.m_StatManager.getStatistic(ClusAttrType.AttributeUseType.Target);
        if (targetStat instanceof ClassificationStat) {
            for (int i = 0; i < targetStat.getNbNominalAttributes(); ++i) {
                String att_name = ((ClassificationStat)targetStat).getAttribute(i).getName();
                for (int j = 0; j < this.m_ClassStat.getNbNominalAttributes(); ++j) {
                    String att_name2 = this.m_ClassStat.getAttribute(j).getName();
                    if (!att_name.equals(att_name2)) continue;
                    att = j;
                    break;
                }
                if (!this.SignDifferentNom(att)) continue;
                res = true;
                break;
            }
            return res;
        }
        if (targetStat instanceof RegressionStat) {
            for (int i = 0; i < targetStat.getNbNumericAttributes(); ++i) {
                String att_name = ((RegressionStat)targetStat).getAttribute(i).getName();
                for (int j = 0; j < this.m_RegStat.getNbNumericAttributes(); ++j) {
                    String att_name2 = this.m_RegStat.getAttribute(j).getName();
                    if (!att_name.equals(att_name2)) continue;
                    att = j;
                    break;
                }
                try {
                    if (!this.SignDifferentNum(att)) continue;
                    res = true;
                    break;
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
            return res;
        }
        return true;
    }

    private boolean SignDifferentNom(int att) {
        return this.m_ClassStat.getGTest(att, this.m_StatManager);
    }

    private boolean SignDifferentNum(int att) throws IllegalArgumentException {
        double alpha = this.getSettings().getRules().getRuleSignificanceLevel();
        double p_value = this.m_RegStat.getTTestPValue(att, this.m_StatManager);
        return p_value < alpha;
    }

    public String getDispersionString() {
        StringBuffer buf = new StringBuffer();
        ClusNumberFormat fr = ClusFormat.SIX_AFTER_DOT;
        buf.append("[");
        buf.append(fr.format(this.dispersionCalc()));
        buf.append(" : ");
        buf.append(fr.format(this.dispersionNum(IN_OUTPUT)));
        buf.append(" , ");
        buf.append(fr.format(this.dispersionNom(IN_OUTPUT)));
        buf.append("]");
        return buf.toString();
    }

    @Override
    public String getString(StatisticPrintInfo info) {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        buf.append(this.m_ClassStat.getString(info));
        buf.append(" | ");
        buf.append(this.m_RegStat.getString(info));
        buf.append("]");
        return buf.toString();
    }

    @Override
    public void addPredictWriterSchema(String prefix, ClusSchema schema) {
        this.m_ClassStat.addPredictWriterSchema(prefix, schema);
        this.m_RegStat.addPredictWriterSchema(prefix, schema);
    }

    @Override
    public String getPredictWriterString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.m_ClassStat.getPredictWriterString());
        if (buf.length() != 0) {
            buf.append(",");
        }
        buf.append(this.m_RegStat.getPredictWriterString());
        return buf.toString();
    }

    @Override
    public String getArrayOfStatistic() {
        return null;
    }

    @Override
    public double getSVarS(ClusAttributeWeights scale) {
        int nbTargetNom = this.m_ClassStat.getNbNominalAttributes();
        int nbTargetNum = this.m_RegStat.getNbNumericAttributes();
        return (this.m_ClassStat.getSVarS(scale) * (double)nbTargetNom + this.m_RegStat.getSVarS(scale) * (double)nbTargetNum) / (double)(nbTargetNom + nbTargetNum);
    }

    @Override
    public double getSVarSDiff(ClusAttributeWeights scale, ClusStatistic other) {
        int nbTargetNom = this.m_ClassStat.getNbNominalAttributes();
        int nbTargetNum = this.m_RegStat.getNbNumericAttributes();
        ClassificationStat ocls = ((CombStat)other).getClassificationStat();
        RegressionStat oreg = ((CombStat)other).getRegressionStat();
        return (this.m_ClassStat.getSVarSDiff(scale, ocls) * (double)nbTargetNom + this.m_RegStat.getSVarSDiff(scale, (ClusStatistic)oreg) * (double)nbTargetNum) / (double)(nbTargetNom + nbTargetNum);
    }

    @Override
    public void reset() {
        this.m_RegStat.reset();
        this.m_ClassStat.reset();
        this.m_SumWeight = 0.0;
    }

    @Override
    public void copy(ClusStatistic other) {
        CombStat or = (CombStat)other;
        this.m_SumWeight = or.m_SumWeight;
        this.m_StatManager = or.m_StatManager;
        this.m_RegStat.copy(or.m_RegStat);
        this.m_ClassStat.copy(or.m_ClassStat);
    }

    @Override
    public void addPrediction(ClusStatistic other, double weight) {
        CombStat or = (CombStat)other;
        this.m_RegStat.addPrediction(or.m_RegStat, weight);
        this.m_ClassStat.addPrediction(or.m_ClassStat, weight);
    }

    @Override
    public void add(ClusStatistic other) {
        CombStat or = (CombStat)other;
        this.m_RegStat.add(or.m_RegStat);
        this.m_ClassStat.add(or.m_ClassStat);
        this.m_SumWeight += or.m_SumWeight;
    }

    @Override
    public void subtractFromThis(ClusStatistic other) {
        CombStat or = (CombStat)other;
        this.m_RegStat.subtractFromThis(or.m_RegStat);
        this.m_ClassStat.subtractFromThis(or.m_ClassStat);
        this.m_SumWeight -= or.m_SumWeight;
    }

    @Override
    public void subtractFromOther(ClusStatistic other) {
        CombStat or = (CombStat)other;
        this.m_RegStat.subtractFromOther(or.m_RegStat);
        this.m_ClassStat.subtractFromOther(or.m_ClassStat);
        this.m_SumWeight = or.m_SumWeight - this.m_SumWeight;
    }

    @Override
    public int getNbNominalAttributes() {
        return this.m_ClassStat.getNbNominalAttributes();
    }

    @Override
    public String getPredictedClassName(int idx) {
        return "";
    }

    @Override
    public int getNbNumericAttributes() {
        return this.m_RegStat.getNbNumericAttributes();
    }

    @Override
    public double[] getNumericPred() {
        return this.m_RegStat.getNumericPred();
    }

    @Override
    public int[] getNominalPred() {
        return this.m_ClassStat.getNominalPred();
    }

    @Override
    public double getError(ClusAttributeWeights scale) {
        ClusLogger.info("CombStat :getError");
        switch (this.m_StatManager.getClusterMode()) {
            case CLASSIFY: {
                return this.m_ClassStat.getError(scale);
            }
            case REGRESSION: {
                return this.m_RegStat.getError(scale);
            }
            case CLASSIFY_AND_REGRESSION: {
                return this.m_RegStat.getError(scale) + this.m_ClassStat.getError(scale);
            }
        }
        System.err.println(this.getClass().getName() + ": getError(): Invalid mode!");
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public void printDistribution(PrintWriter wrt) throws IOException {
        this.m_ClassStat.printDistribution(wrt);
        this.m_RegStat.printDistribution(wrt);
    }

    @Override
    public void vote(ArrayList<ClusStatistic> votes) {
        throw new RuntimeException("si.ijs.kt.clus.statistic.CombStat.vote(ArrayList<ClusStatistic>) not implemented");
    }

    @Override
    public void vote(ArrayList<ClusStatistic> votes, ClusROSForestInfo ROSForestInfo) {
        throw new RuntimeException("si.ijs.kt.clus.statistic.CombStat.vote(ArrayList<ClusStatistic>, ClusROSForestInfo) not implemented");
    }

    @Override
    public void vote(ArrayList<ClusStatistic> votes, ClusOOBWeights weights) {
        throw new RuntimeException("si.ijs.kt.clus.statistic.CombStat.vote(ArrayList<ClusStatistic>, ArrayList<Double>) not implemented");
    }

    @Override
    public void vote(ArrayList<ClusStatistic> votes, ClusOOBWeights weights, ClusROSForestInfo ROSForestInfo) {
        throw new RuntimeException("si.ijs.kt.clus.statistic.CombStat.vote(ArrayList<ClusStatistic>, ArrayList<Double>, ClusROSForestInfo) not implemented");
    }

    @Override
    public int getNbStatisticComponents() {
        throw new RuntimeException("CombStat: getNbStatisticComponents() not implemented.");
    }

    @Override
    public void setParentStat(ClusStatistic parent) {
        CombStat cstat = (CombStat)parent;
        this.getClassificationStat().setParentStat(cstat.getClassificationStat());
        this.getRegressionStat().setParentStat(cstat.getRegressionStat());
    }

    @Override
    public double getTargetSumWeights() {
        return this.m_ClassStat.getTargetSumWeights() + this.m_RegStat.getTargetSumWeights();
    }

    @Override
    public boolean samePrediction(ClusStatistic other) {
        CombStat cstat = (CombStat)other;
        return this.getClassificationStat().samePrediction(cstat.getClassificationStat()) && this.getRegressionStat().samePrediction(cstat.getRegressionStat());
    }

    @Override
    public ClusStatistic getParentStat() {
        return new CombStat(this.m_StatManager, (RegressionStat)this.m_RegStat.getParentStat(), (ClassificationStat)this.m_ClassStat.getParentStat());
    }
}

