/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.statistic;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.lang.NotImplementedException;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.attweights.ClusAttributeWeights;
import si.ijs.kt.clus.data.cols.ColTarget;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.distance.ClusDistance;
import si.ijs.kt.clus.ext.beamsearch.ClusBeam;
import si.ijs.kt.clus.ext.ensemble.ClusOOBWeights;
import si.ijs.kt.clus.ext.ensemble.ros.ClusROSForestInfo;
import si.ijs.kt.clus.ext.timeseries.TimeSeries;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.statistic.ClassificationStat;
import si.ijs.kt.clus.statistic.RegressionStat;
import si.ijs.kt.clus.statistic.StatisticPrintInfo;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.format.ClusFormat;

public abstract class ClusStatistic
implements Serializable {
    public static final long serialVersionUID = 1L;
    protected double m_SumWeight;
    public double[] m_SumWeights;
    protected double m_SumWeightLabeled;
    public int m_NbExamples;
    public static boolean INITIALIZEPARTIALSUM = true;
    protected Settings m_Settings;

    public ClusStatistic(Settings sett) {
        this.m_Settings = sett;
    }

    public abstract ClusStatistic cloneStat();

    public boolean isAnyLabeled(int target) {
        if (this.m_SumWeights == null) {
            return this.m_SumWeightLabeled > 0.0;
        }
        return this.m_SumWeights[target] > 0.0;
    }

    public ClusStatistic cloneSimple() {
        return this.cloneStat();
    }

    public ClusStatistic copyNormalizedWeighted(double weight) {
        System.err.println(this.getClass().getName() + ": copyNormalizedWeighted(): Not yet implemented");
        return null;
    }

    public int getNbAttributes() {
        return this.getNbNominalAttributes() + this.getNbNumericAttributes();
    }

    public int getNbNominalAttributes() {
        return 0;
    }

    public int getNbNumericAttributes() {
        return 0;
    }

    public abstract int getNbStatisticComponents();

    public void printDebug() {
    }

    public void setSDataSize(int nbex) {
    }

    public void setTrainingStat(ClusStatistic train) {
    }

    public abstract void setParentStat(ClusStatistic var1);

    public abstract ClusStatistic getParentStat();

    public void optimizePreCalc(RowData data) throws ClusException {
    }

    public void showRootInfo() {
    }

    public boolean isValidPrediction() {
        return true;
    }

    public void update(ColTarget target, int idx) {
        System.err.println(this.getClass().getName() + ": update(ColTarget target, int idx): Not yet implemented");
    }

    public abstract void updateWeighted(DataTuple var1, int var2);

    public void updateWeighted(DataTuple tuple, double weight) {
    }

    public abstract void calcMean() throws ClusException;

    public abstract String getString(StatisticPrintInfo var1);

    public abstract String getPredictedClassName(int var1);

    public abstract String getArrayOfStatistic();

    public void computePrediction() throws ClusException {
        this.calcMean();
    }

    public String getString() {
        return this.getString(StatisticPrintInfo.getInstance());
    }

    public String getPredictString() {
        return this.getString();
    }

    public abstract void reset();

    public abstract void copy(ClusStatistic var1);

    public abstract void addPrediction(ClusStatistic var1, double var2);

    public abstract void add(ClusStatistic var1);

    public void addData(RowData data) {
        for (int i = 0; i < data.getNbRows(); ++i) {
            this.updateWeighted(data.getTuple(i), 1);
        }
    }

    public void addScaled(double scale, ClusStatistic other) {
        System.err.println(this.getClass().getName() + ": addScaled(): Not yet implemented");
    }

    public void resetToSimple(double weight) {
        System.err.println(this.getClass().getName() + ": resetToSimple(): Not yet implemented");
    }

    public abstract void subtractFromThis(ClusStatistic var1);

    public abstract void subtractFromOther(ClusStatistic var1);

    public void setData(RowData data) {
        throw new NotImplementedException();
    }

    public void setSplitIndex(int i) {
    }

    public void setPrevIndex(int i) {
    }

    public void initializeSum() {
        throw new NotImplementedException();
    }

    public double[] getNumericPred() {
        throw new NotImplementedException();
    }

    public TimeSeries getTimeSeriesPred() {
        throw new NotImplementedException();
    }

    public int[] getNominalPred() {
        throw new NotImplementedException();
    }

    public String getString2() {
        return "";
    }

    public String getClassString() {
        return this.getString();
    }

    public String getSimpleString() {
        return ClusFormat.ONE_AFTER_DOT.format(this.m_SumWeight);
    }

    public final double getTotalWeight() {
        return this.m_SumWeight;
    }

    public double getTargetSumWeights() {
        System.err.println(this.getClass().getName() + ": getTargetSumWeights(): Not yet implemented");
        return this.getTotalWeight();
    }

    public int getNbExamples() {
        return this.m_NbExamples;
    }

    public String getDebugString() {
        return String.valueOf(this.m_SumWeight);
    }

    public boolean samePrediction(ClusStatistic other) {
        throw new NotImplementedException();
    }

    public double getError() {
        return this.getError(null);
    }

    public double getErrorRel() {
        return this.getError(null);
    }

    public double getErrorDiff(ClusStatistic other) {
        return this.getErrorDiff(null, other);
    }

    public double getError(ClusAttributeWeights scale, RowData data) {
        return this.getError(scale);
    }

    public double getError(ClusAttributeWeights scale) {
        throw new NotImplementedException();
    }

    public double getErrorDiff(ClusAttributeWeights scale, ClusStatistic other) {
        throw new NotImplementedException();
    }

    public double getSVarS(ClusAttributeWeights scale) {
        throw new NotImplementedException();
    }

    public double getSVarSDiff(ClusAttributeWeights scale, ClusStatistic other) {
        throw new NotImplementedException();
    }

    public double getSVarS(ClusAttributeWeights scale, RowData data) throws ClusException {
        return this.getSVarS(scale);
    }

    public double getSVarSDiff(ClusAttributeWeights scale, ClusStatistic other, RowData data) {
        return this.getSVarSDiff(scale, other);
    }

    public double getAbsoluteDistance(DataTuple tuple, ClusAttributeWeights weights) throws ClusException {
        return Double.POSITIVE_INFINITY;
    }

    public double getDispersion(ClusAttributeWeights scale, RowData data) throws ClusException {
        System.err.println(this.getClass().getName() + ": getDispersion(): Not implemented here!");
        return Double.POSITIVE_INFINITY;
    }

    public double getSquaredDistance(DataTuple tuple, ClusAttributeWeights weights) {
        return Double.POSITIVE_INFINITY;
    }

    public double getSquaredDistance(ClusStatistic other) {
        return Double.POSITIVE_INFINITY;
    }

    public static void reset(ClusStatistic[] stat) {
        for (int i = 0; i < stat.length; ++i) {
            stat[i].reset();
        }
    }

    public String toString() {
        return this.getString();
    }

    public String getExtraInfo() {
        return null;
    }

    public void printDistribution(PrintWriter wrt) throws IOException {
        wrt.println(this.getClass().getName() + " does not implement printDistribution()");
    }

    public static void calcMeans(ClusStatistic[] stats) throws ClusException {
        for (int i = 0; i < stats.length; ++i) {
            stats[i].calcMean();
        }
    }

    public void addPredictWriterSchema(String prefix, ClusSchema schema) {
    }

    public String getPredictWriterString() {
        return this.getPredictString();
    }

    public String getPredictWriterString(DataTuple tuple) throws ClusException {
        return this.getPredictWriterString();
    }

    public void predictTuple(DataTuple prediction) {
        System.err.println(this.getClass().getName() + " does not implement predictTuple()");
    }

    public void predictTupleOneComponent(DataTuple tuple, int i, int value) {
        System.err.println(this.getClass().getName() + " does not implement predictTupleOneComponent(DataTuple tuple, int i, int value)");
    }

    public void predictTupleOneComponent(DataTuple tuple, int i, double value) {
        System.err.println(this.getClass().getName() + " does not implement predictTupleOneComponent(DataTuple tuple, int i, double value)");
    }

    public RegressionStat getRegressionStat() {
        return null;
    }

    public ClassificationStat getClassificationStat() {
        return null;
    }

    public void unionInit() {
    }

    public void unionDone() {
    }

    public void union(ClusStatistic other) {
    }

    public abstract void vote(ArrayList<ClusStatistic> var1);

    public abstract void vote(ArrayList<ClusStatistic> var1, ClusOOBWeights var2);

    public abstract void vote(ArrayList<ClusStatistic> var1, ClusROSForestInfo var2);

    public abstract void vote(ArrayList<ClusStatistic> var1, ClusOOBWeights var2, ClusROSForestInfo var3);

    public ClusStatistic normalizedCopy() {
        return null;
    }

    public ClusDistance getDistance() {
        return null;
    }

    public double getCount(int idx, int cls) {
        System.err.println(this.getClass().getName() + " does not implement predictTuple()");
        return Double.POSITIVE_INFINITY;
    }

    public String getDistanceName() {
        return "Unknown Distance";
    }

    public void setBeam(ClusBeam beam) {
    }

    public double getSumWeight() {
        return this.m_SumWeight;
    }

    public final Settings getSettings() {
        return this.m_Settings;
    }

    public double calcItotal(Integer[] permutation) throws ClusException {
        throw new NotImplementedException();
    }

    public double calcEquvalentIDistance(Integer[] permutation) throws ClusException {
        throw new NotImplementedException();
    }

    public double calcGtotal(Integer[] permutation) throws ClusException {
        throw new NotImplementedException();
    }

    public double calcGetisTotal(Integer[] permutation) throws ClusException {
        throw new NotImplementedException();
    }

    public double calcLISAtotal(Integer[] permutation) throws ClusException {
        throw new NotImplementedException();
    }

    public double calcGLocalTotal(Integer[] permutation) throws ClusException {
        throw new NotImplementedException();
    }

    public double calcLocalGetisTotal(Integer[] permutation) throws ClusException {
        throw new NotImplementedException();
    }

    public double calcGETIStotal(Integer[] permutation) throws ClusException {
        throw new NotImplementedException();
    }

    public double calcEquvalentItotal(Integer[] permutation) throws ClusException {
        throw new NotImplementedException();
    }

    public double calcIwithNeighbourstotal(Integer[] permutation) throws ClusException {
        throw new NotImplementedException();
    }

    public double calcEquvalentIwithNeighbourstotal(Integer[] permutation) throws ClusException {
        throw new NotImplementedException();
    }

    public double calcEquvalentGDistance(Integer[] permutation) throws ClusException {
        throw new NotImplementedException();
    }

    public double calcEquvalentPDistance(Integer[] permutation) throws ClusException {
        throw new NotImplementedException();
    }

    public double calcEquvalentGtotal(Integer[] permutation) throws ClusException {
        throw new NotImplementedException();
    }

    public double calcItotalD(Integer[] permutation) throws ClusException {
        throw new NotImplementedException();
    }

    public double calcPDistance(Integer[] permutation) throws ClusException {
        throw new NotImplementedException();
    }

    public double calcGtotalD(Integer[] permutation) throws ClusException {
        throw new NotImplementedException();
    }

    public double calcCItotal(Integer[] permutation) throws ClusException {
        throw new NotImplementedException();
    }

    public double calcMutivariateItotal(Integer[] permutation) throws ClusException {
        throw new NotImplementedException();
    }

    public double calcCwithNeighbourstotal(Integer[] permutation) throws ClusException {
        throw new NotImplementedException();
    }

    public double calcBivariateLee(Integer[] permutation) throws Exception {
        throw new NotImplementedException();
    }

    public double calcMultiIwithNeighbours(Integer[] permutation) throws Exception {
        throw new NotImplementedException();
    }

    public double calcCIwithNeighbours(Integer[] permutation) throws ClusException {
        throw new NotImplementedException();
    }

    public double calcLeewithNeighbours(Integer[] permutation) throws ClusException {
        throw new NotImplementedException();
    }

    public double calcPtotal(Integer[] permutation) throws ClusException {
        throw new NotImplementedException();
    }

    public double calcCItotalD(Integer[] permutation) throws ClusException {
        throw new NotImplementedException();
    }

    public double calcDHtotalD(Integer[] permutation) {
        throw new NotImplementedException();
    }
}

