/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.statistic;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.math3.distribution.ChiSquaredDistribution;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.attweights.ClusAttributeWeights;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.ext.ensemble.ClusOOBWeights;
import si.ijs.kt.clus.ext.ensemble.ros.ClusROSForestInfo;
import si.ijs.kt.clus.ext.ensemble.ros.ClusROSModelInfo;
import si.ijs.kt.clus.heuristic.GISHeuristic;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsTree;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.CombStat;
import si.ijs.kt.clus.statistic.ComponentStatistic;
import si.ijs.kt.clus.statistic.StatisticPrintInfo;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.format.ClusFormat;
import si.ijs.kt.clus.util.format.ClusNumberFormat;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileNominalOrDoubleOrVector;
import si.ijs.kt.clus.util.jeans.math.MathUtil;
import si.ijs.kt.clus.util.jeans.util.StringUtils;

public class ClassificationStat
extends ClusStatistic
implements ComponentStatistic {
    public static final long serialVersionUID = 1L;
    public int m_NbTarget;
    private int m_NbAttrs;
    public NominalAttrType[] m_Attrs;
    public ClassificationStat m_Training;
    public ClassificationStat m_ParentStat;
    public double[][] m_ClassCounts;
    public int[] m_MajorityClasses;
    public double[] m_Thresholds;
    public double m_I;
    public RowData m_data;
    public RowData temp_data;
    public double[] m_SumValuesSpatial;
    private int splitIndex;
    private int prevIndex;
    public double[] previousSumW;
    public double[] previousSumX;
    public double[] previousSumXR;
    public double[] previousSumWXX;
    public double[] previousSumWX;
    public double[] previousSumX2;
    public double[] previousSumWXXR;
    public double[] previousSumWXR;
    public double[] previousSumWR;
    public double[] previousSumX2R;
    public static boolean INITIALIZEPARTIALSUM = true;

    public ClassificationStat(Settings sett, NominalAttrType[] nomAtts) {
        super(sett);
        this.initialize(nomAtts);
    }

    public ClassificationStat(Settings sett, NominalAttrType[] nomAtts, INIFileNominalOrDoubleOrVector multiLabelThreshold) {
        this(sett, nomAtts);
        double[] thresholds = multiLabelThreshold.getDoubleVector();
        if (thresholds != null) {
            this.setThresholds(thresholds);
        } else {
            this.setThresholds(multiLabelThreshold.getDouble());
        }
    }

    private void initialize(NominalAttrType[] nomAtts) {
        this.m_NbTarget = nomAtts.length;
        this.m_SumWeights = new double[this.m_NbTarget];
        this.m_ClassCounts = new double[this.m_NbTarget][];
        for (int i = 0; i < this.m_NbTarget; ++i) {
            this.m_ClassCounts[i] = new double[nomAtts[i].getNbValues()];
        }
        this.m_Attrs = nomAtts;
        this.previousSumX = new double[2];
        this.previousSumXR = new double[2];
        this.previousSumW = new double[2];
        this.previousSumWXX = new double[2];
        this.previousSumWX = new double[2];
        this.previousSumX2 = new double[2];
        this.previousSumWR = new double[2];
        this.previousSumWXXR = new double[2];
        this.previousSumWXR = new double[2];
        this.previousSumX2R = new double[2];
    }

    @Override
    public void setTrainingStat(ClusStatistic train) {
        this.m_Training = (ClassificationStat)train;
    }

    public void setThresholds(double[] thresholds) {
        this.m_Thresholds = new double[this.m_NbTarget];
        for (int i = 0; i < this.m_NbTarget; ++i) {
            this.m_Thresholds[i] = thresholds[i];
        }
    }

    public void setThresholds(double threshold) {
        this.m_Thresholds = new double[this.m_NbTarget];
        for (int i = 0; i < this.m_NbTarget; ++i) {
            this.m_Thresholds[i] = threshold;
        }
    }

    @Override
    public int getNbNominalAttributes() {
        return this.m_NbTarget;
    }

    public NominalAttrType[] getAttributes() {
        return this.m_Attrs;
    }

    @Override
    public ClusStatistic cloneStat() {
        ClassificationStat res = new ClassificationStat(this.m_Settings, this.m_Attrs);
        res.m_Training = this.m_Training;
        res.m_ParentStat = this.m_ParentStat;
        if (this.m_Thresholds != null) {
            res.m_Thresholds = Arrays.copyOf(this.m_Thresholds, this.m_Thresholds.length);
        }
        return res;
    }

    public void initSingleTargetFrom(double[] distro) {
        this.m_ClassCounts[0] = distro;
        this.m_SumWeight = 0.0;
        for (int i = 0; i < distro.length; ++i) {
            this.m_SumWeight += distro[i];
        }
        Arrays.fill(this.m_SumWeights, this.m_SumWeight);
    }

    public NominalAttrType getAttribute(int idx) {
        return this.m_Attrs[idx];
    }

    @Override
    public void reset() {
        this.m_NbExamples = 0;
        this.m_SumWeight = 0.0;
        this.m_SumWeightLabeled = 0.0;
        Arrays.fill(this.m_SumWeights, 0.0);
        for (int i = 0; i < this.m_NbTarget; ++i) {
            Arrays.fill(this.m_ClassCounts[i], 0.0);
        }
    }

    @Override
    public void resetToSimple(double weight) {
        this.m_NbExamples = 0;
        this.m_SumWeight = weight;
        Arrays.fill(this.m_SumWeights, weight);
        for (int i = 0; i < this.m_NbTarget; ++i) {
            double[] clcts = this.m_ClassCounts[i];
            for (int j = 0; j < clcts.length; ++j) {
                clcts[j] = j == this.m_MajorityClasses[i] ? weight : 0.0;
            }
        }
    }

    @Override
    public void copy(ClusStatistic other) {
        ClassificationStat or = (ClassificationStat)other;
        this.m_SumWeight = or.m_SumWeight;
        this.m_SumWeightLabeled = or.m_SumWeightLabeled;
        this.m_NbExamples = or.m_NbExamples;
        System.arraycopy(or.m_SumWeights, 0, this.m_SumWeights, 0, this.m_NbTarget);
        for (int i = 0; i < this.m_NbTarget; ++i) {
            double[] my = this.m_ClassCounts[i];
            System.arraycopy(or.m_ClassCounts[i], 0, my, 0, my.length);
        }
    }

    @Override
    public ClassificationStat normalizedCopy() {
        ClassificationStat copy = (ClassificationStat)this.cloneStat();
        copy.copy(this);
        for (int i = 0; i < this.m_NbTarget; ++i) {
            int j = 0;
            while (j < this.m_ClassCounts[i].length) {
                double[] dArray = copy.m_ClassCounts[i];
                int n = j++;
                dArray[n] = dArray[n] / this.m_SumWeights[i];
            }
        }
        Arrays.fill(copy.m_SumWeights, 1.0);
        copy.m_SumWeight = 1.0;
        return copy;
    }

    @Override
    public boolean samePrediction(ClusStatistic other) {
        ClassificationStat or = (ClassificationStat)other;
        for (int i = 0; i < this.m_NbTarget; ++i) {
            if (this.m_MajorityClasses[i] == or.m_MajorityClasses[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addPrediction(ClusStatistic other, double weight) {
        ClassificationStat or = (ClassificationStat)other;
        this.m_SumWeight += weight * or.m_SumWeight;
        for (int i = 0; i < this.m_NbTarget; ++i) {
            double[] my = this.m_ClassCounts[i];
            double[] your = or.m_ClassCounts[i];
            for (int j = 0; j < my.length; ++j) {
                int n = j;
                my[n] = my[n] + weight * your[j];
            }
            int n = i;
            this.m_SumWeights[n] = this.m_SumWeights[n] + weight * or.m_SumWeights[i];
        }
    }

    @Override
    public void add(ClusStatistic other) {
        ClassificationStat or = (ClassificationStat)other;
        this.m_SumWeight += or.m_SumWeight;
        this.m_SumWeightLabeled += or.m_SumWeightLabeled;
        this.m_NbExamples += or.m_NbExamples;
        for (int i = 0; i < this.m_NbTarget; ++i) {
            double[] my = this.m_ClassCounts[i];
            double[] your = or.m_ClassCounts[i];
            for (int j = 0; j < my.length; ++j) {
                int n = j;
                my[n] = my[n] + your[j];
            }
            int n = i;
            this.m_SumWeights[n] = this.m_SumWeights[n] + or.m_SumWeights[i];
        }
    }

    @Override
    public void addScaled(double scale, ClusStatistic other) {
        ClassificationStat or = (ClassificationStat)other;
        this.m_SumWeight += scale * or.m_SumWeight;
        this.m_SumWeightLabeled += scale * or.m_SumWeightLabeled;
        this.m_NbExamples += or.m_NbExamples;
        for (int i = 0; i < this.m_NbTarget; ++i) {
            double[] my = this.m_ClassCounts[i];
            double[] your = or.m_ClassCounts[i];
            for (int j = 0; j < my.length; ++j) {
                int n = j;
                my[n] = my[n] + scale * your[j];
            }
            int n = i;
            this.m_SumWeights[n] = this.m_SumWeights[n] + scale * or.m_SumWeights[i];
        }
    }

    @Override
    public void subtractFromThis(ClusStatistic other) {
        ClassificationStat or = (ClassificationStat)other;
        this.m_SumWeight -= or.m_SumWeight;
        this.m_SumWeightLabeled -= or.m_SumWeightLabeled;
        this.m_NbExamples -= or.m_NbExamples;
        for (int i = 0; i < this.m_NbTarget; ++i) {
            double[] my = this.m_ClassCounts[i];
            double[] your = or.m_ClassCounts[i];
            for (int j = 0; j < my.length; ++j) {
                int n = j;
                my[n] = my[n] - your[j];
            }
            int n = i;
            this.m_SumWeights[n] = this.m_SumWeights[n] - or.m_SumWeights[i];
        }
    }

    @Override
    public void subtractFromOther(ClusStatistic other) {
        ClassificationStat or = (ClassificationStat)other;
        this.m_SumWeight = or.m_SumWeight - this.m_SumWeight;
        this.m_SumWeightLabeled = or.m_SumWeightLabeled - this.m_SumWeightLabeled;
        this.m_NbExamples = or.m_NbExamples - this.m_NbExamples;
        for (int i = 0; i < this.m_NbTarget; ++i) {
            double[] my = this.m_ClassCounts[i];
            double[] your = or.m_ClassCounts[i];
            for (int j = 0; j < my.length; ++j) {
                my[j] = your[j] - my[j];
            }
            this.m_SumWeights[i] = or.m_SumWeights[i] - this.m_SumWeights[i];
        }
    }

    @Override
    public void updateWeighted(DataTuple tuple, int idx) {
        this.updateWeighted(tuple, tuple.getWeight());
    }

    @Override
    public void updateWeighted(DataTuple tuple, double weight) {
        ++this.m_NbExamples;
        this.m_SumWeight += weight;
        boolean hasLabel = false;
        for (int i = 0; i < this.m_NbTarget; ++i) {
            int val = this.m_Attrs[i].getNominal(tuple);
            if (val == this.m_Attrs[i].getNbValues()) continue;
            double[] dArray = this.m_ClassCounts[i];
            int n = val;
            dArray[n] = dArray[n] + weight;
            int n2 = i;
            this.m_SumWeights[n2] = this.m_SumWeights[n2] + weight;
            if (hasLabel || !this.m_Attrs[i].isTarget()) continue;
            hasLabel = true;
        }
        if (hasLabel) {
            this.m_SumWeightLabeled += weight;
        }
    }

    public int getMajorityClass(int attr) {
        int m_class = -1;
        double m_max = Double.NEGATIVE_INFINITY;
        double[] clcts = this.m_ClassCounts[attr];
        for (int i = 0; i < clcts.length; ++i) {
            if (!(clcts[i] > m_max)) continue;
            m_class = i;
            m_max = clcts[i];
        }
        if (m_max <= 1.0E-9 && this.m_Training != null) {
            switch (this.getSettings().getTree().getMissingTargetAttrHandling()) {
                case ParentNode: {
                    return this.m_ParentStat.getMajorityClass(attr);
                }
                case Zero: {
                    return 0;
                }
            }
            return this.m_Training.getMajorityClass(attr);
        }
        if (this.m_Thresholds != null) {
            return clcts[0] / (clcts[0] + clcts[1]) >= this.m_Thresholds[attr] ? 0 : 1;
        }
        return m_class;
    }

    public int getMajorityClassDiff(int attr, ClassificationStat other) {
        if (this.m_Thresholds != null) {
            throw new RuntimeException("Not implemented for MLC.");
        }
        int m_class = -1;
        double m_max = Double.NEGATIVE_INFINITY;
        double[] clcts1 = this.m_ClassCounts[attr];
        double[] clcts2 = other.m_ClassCounts[attr];
        for (int i = 0; i < clcts1.length; ++i) {
            double diff = clcts1[i] - clcts2[i];
            if (!(diff > m_max)) continue;
            m_class = i;
            m_max = diff;
        }
        if (m_max <= 1.0E-9 && this.m_Training != null) {
            switch (this.getSettings().getTree().getMissingTargetAttrHandling()) {
                case ParentNode: {
                    return this.m_ParentStat.getMajorityClass(attr);
                }
                case Zero: {
                    return 0;
                }
            }
            return this.m_Training.getMajorityClass(attr);
        }
        return m_class;
    }

    public double entropy() {
        double sum = 0.0;
        for (int i = 0; i < this.m_NbTarget; ++i) {
            sum += this.entropy(i);
        }
        return sum;
    }

    public double entropyDifference(ClassificationStat other) {
        double sum = 0.0;
        for (int i = 0; i < this.m_NbTarget; ++i) {
            sum += this.entropyDifference(i, other);
        }
        return sum;
    }

    public double entropy(int attr) {
        double total = this.m_SumWeights[attr];
        if (total < 1.0E-6) {
            return 0.0;
        }
        double acc = 0.0;
        double[] clcts = this.m_ClassCounts[attr];
        for (int i = 0; i < clcts.length; ++i) {
            if (clcts[i] == 0.0) continue;
            double prob = clcts[i] / total;
            acc += prob * Math.log(prob);
        }
        return -acc / MathUtil.M_LN2;
    }

    public double modifiedEntropy(int attr) {
        double total = this.m_SumWeights[attr];
        if (total < 1.0E-6) {
            return 0.0;
        }
        double acc = 0.0;
        double[] clcts = this.m_ClassCounts[attr];
        for (int i = 0; i < clcts.length; ++i) {
            if (clcts[i] == 0.0) continue;
            double prob = (clcts[i] + 1.0) / (total + (double)clcts.length);
            acc += prob * Math.log(prob);
        }
        return -acc / MathUtil.M_LN2;
    }

    public double entropyDifference(ClassificationStat other, ClusAttributeWeights scale) {
        if (this.getSettings().getEnsemble().isEnsembleROSEnabled()) {
            return this.entropyDifferenceROS(other, scale);
        }
        double sum = 0.0;
        for (int i = 0; i < this.m_NbTarget; ++i) {
            if (other.getAttribute(i).getSchema().getSettings().getTree().getEntropyType().equals((Object)SettingsTree.EntropyType.StandardEntropy)) {
                sum += this.entropyDifference(i, other);
                continue;
            }
            sum += this.modifiedEntropyDifference(i, other);
        }
        return sum;
    }

    public double entropyDifferenceROS(ClassificationStat other, ClusAttributeWeights scale) {
        double sum = 0.0;
        ClusROSModelInfo info = scale.getROSModelInfo();
        for (Integer i : info.getTargets()) {
            if (other.getAttribute(i).getSchema().getSettings().getTree().getEntropyType().equals((Object)SettingsTree.EntropyType.StandardEntropy)) {
                sum += this.entropyDifference(i, other);
                continue;
            }
            sum += this.modifiedEntropyDifference(i, other);
        }
        return sum;
    }

    public double entropy(ClusAttributeWeights scale) {
        if (this.getSettings().getEnsemble().isEnsembleROSEnabled()) {
            return this.entropyROS(scale);
        }
        double sum = 0.0;
        for (int i = 0; i < this.m_NbTarget; ++i) {
            if (this.getAttribute(i).getSchema().getSettings().getTree().getEntropyType().equals((Object)SettingsTree.EntropyType.StandardEntropy)) {
                sum += this.entropy(i);
                continue;
            }
            sum += this.modifiedEntropy(i);
        }
        return sum;
    }

    public double entropyROS(ClusAttributeWeights scale) {
        double sum = 0.0;
        ClusROSModelInfo info = scale.getROSModelInfo();
        for (Integer i : info.getTargets()) {
            if (this.getAttribute(i).getSchema().getSettings().getTree().getEntropyType().equals((Object)SettingsTree.EntropyType.StandardEntropy)) {
                sum += this.entropy(i);
                continue;
            }
            sum += this.modifiedEntropy(i);
        }
        return sum;
    }

    double entropyDifference(int attr, ClassificationStat other) {
        double acc = 0.0;
        double[] clcts = this.m_ClassCounts[attr];
        double[] otcts = other.m_ClassCounts[attr];
        double total = this.m_SumWeights[attr] - other.m_SumWeights[attr];
        for (int i = 0; i < clcts.length; ++i) {
            double diff = clcts[i] - otcts[i];
            if (diff == 0.0) continue;
            acc += diff / total * Math.log(diff / total);
        }
        return -acc / MathUtil.M_LN2;
    }

    double modifiedEntropyDifference(int attr, ClassificationStat other) {
        double acc = 0.0;
        double[] clcts = this.m_ClassCounts[attr];
        double[] otcts = other.m_ClassCounts[attr];
        double total = this.m_SumWeights[attr] - other.m_SumWeights[attr];
        for (int i = 0; i < clcts.length; ++i) {
            double diff = clcts[i] - otcts[i];
            if (diff == 0.0) continue;
            acc += (diff + 1.0) / (total + (double)clcts.length) * Math.log((diff + 1.0) / (total + (double)clcts.length));
        }
        return -acc / MathUtil.M_LN2;
    }

    public double gini(int attr) {
        double total = this.m_SumWeights[attr];
        if (total <= 1.0E-9) {
            return this.getEsimatedGini(attr);
        }
        double sum = 0.0;
        double[] clcts = this.m_ClassCounts[attr];
        for (int i = 0; i < clcts.length; ++i) {
            double prob = clcts[i] / total;
            sum += prob * prob;
        }
        return 1.0 - sum;
    }

    public double giniDifference(int attr, ClassificationStat other) {
        double wDiff = this.m_SumWeights[attr] - other.m_SumWeights[attr];
        if (wDiff <= 1.0E-9) {
            return other.getEsimatedGini(attr);
        }
        double sum = 0.0;
        double[] clcts = this.m_ClassCounts[attr];
        double[] otcts = other.m_ClassCounts[attr];
        for (int i = 0; i < clcts.length; ++i) {
            double diff = clcts[i] - otcts[i];
            sum += diff / wDiff * (diff / wDiff);
        }
        return 1.0 - sum;
    }

    public double getEsimatedGini(int i) {
        switch (this.getSettings().getTree().getMissingClusteringAttrHandling()) {
            case EstimateFromParentNode: {
                if (this.m_ParentStat == null) {
                    return Double.NaN;
                }
                return this.m_ParentStat.gini(i);
            }
            case Ignore: {
                return Double.NaN;
            }
        }
        if (this.m_Training == null) {
            return Double.NaN;
        }
        return this.m_Training.gini(i);
    }

    @Override
    public double getError(ClusAttributeWeights scale) {
        if (this.getSettings().getEnsemble().isEnsembleROSEnabled()) {
            return this.getErrorROS(scale);
        }
        double result = 0.0;
        for (int i = 0; i < this.m_NbTarget; ++i) {
            int maj = this.getMajorityClass(i);
            result += this.m_SumWeights[i] - this.m_ClassCounts[i][maj];
        }
        return result / (double)this.m_NbTarget;
    }

    public double getErrorROS(ClusAttributeWeights scale) {
        double result = 0.0;
        ClusROSModelInfo info = scale.getROSModelInfo();
        for (Integer i : info.getTargets()) {
            int maj = this.getMajorityClass(i);
            result += this.m_SumWeights[i] - this.m_ClassCounts[i][maj];
        }
        return result / (double)info.getSizeOfSubspace();
    }

    @Override
    public double getErrorRel() {
        return this.getError() / this.getTotalWeight();
    }

    @Override
    public double getErrorDiff(ClusAttributeWeights scale, ClusStatistic other) {
        if (this.getSettings().getEnsemble().isEnsembleROSEnabled()) {
            return this.getErrorDiffROS(scale, other);
        }
        double result = 0.0;
        ClassificationStat or = (ClassificationStat)other;
        for (int i = 0; i < this.m_NbTarget; ++i) {
            int maj = this.getMajorityClassDiff(i, or);
            double diff_maj = this.m_ClassCounts[i][maj] - or.m_ClassCounts[i][maj];
            double diff_total = this.m_SumWeights[i] - or.m_SumWeights[i];
            result += diff_total - diff_maj;
        }
        return result / (double)this.m_NbTarget;
    }

    public double getErrorDiffROS(ClusAttributeWeights scale, ClusStatistic other) {
        double result = 0.0;
        ClassificationStat or = (ClassificationStat)other;
        ClusROSModelInfo info = scale.getROSModelInfo();
        for (Integer i : info.getTargets()) {
            int maj = this.getMajorityClassDiff(i, or);
            double diff_maj = this.m_ClassCounts[i][maj] - or.m_ClassCounts[i][maj];
            double diff_total = this.m_SumWeights[i] - or.m_SumWeights[i];
            result += diff_total - diff_maj;
        }
        return result / (double)info.getSizeOfSubspace();
    }

    @Override
    public double getSVarS(ClusAttributeWeights scale) {
        if (this.getSettings().getEnsemble().isEnsembleROSEnabled()) {
            return this.getSVarSROS(scale);
        }
        double result = 0.0;
        int nbEffectiveAttrs = this.m_NbTarget;
        for (int i = 0; i < this.m_NbTarget; ++i) {
            double SVarS = this.getSVarS(i);
            if (Double.isNaN(SVarS)) {
                --nbEffectiveAttrs;
                continue;
            }
            result += this.getSVarS(i) * scale.getWeight(this.m_Attrs[i]);
        }
        if (nbEffectiveAttrs == 0) {
            return Double.POSITIVE_INFINITY;
        }
        return result / (double)nbEffectiveAttrs;
    }

    @Override
    public double getSVarS(int i) {
        return this.gini(i) * this.m_SumWeights[i];
    }

    public double getSVarSROS(ClusAttributeWeights scale) {
        double result = 0.0;
        ClusROSModelInfo info = scale.getROSModelInfo();
        for (Integer i : info.getTargets()) {
            result += this.getSVarS(i) * scale.getWeight(this.m_Attrs[i]);
        }
        return result / (double)info.getSizeOfSubspace();
    }

    @Override
    public double getSVarSDiff(ClusAttributeWeights scale, ClusStatistic other) {
        if (this.getSettings().getEnsemble().isEnsembleROSEnabled()) {
            return this.getSVarSDiffROS(scale, other);
        }
        ClassificationStat or = (ClassificationStat)other;
        double result = 0.0;
        int nbEffectiveAttrs = this.m_NbTarget;
        ClassificationStat cother = (ClassificationStat)other;
        for (int i = 0; i < this.m_NbTarget; ++i) {
            double SVarSDiff = this.giniDifference(i, cother);
            if (Double.isNaN(SVarSDiff)) {
                --nbEffectiveAttrs;
                continue;
            }
            result += SVarSDiff * scale.getWeight(this.m_Attrs[i]) * (this.m_SumWeights[i] - or.m_SumWeights[i]);
        }
        if (nbEffectiveAttrs == 0) {
            return Double.POSITIVE_INFINITY;
        }
        return result / (double)nbEffectiveAttrs;
    }

    public double getSVarSDiffROS(ClusAttributeWeights scale, ClusStatistic other) {
        double result = 0.0;
        double sum = this.m_SumWeight - other.m_SumWeight;
        ClassificationStat cother = (ClassificationStat)other;
        ClusROSModelInfo info = scale.getROSModelInfo();
        for (Integer i : info.getTargets()) {
            result += this.giniDifference(i, cother) * scale.getWeight(this.m_Attrs[i]) * sum;
        }
        return result / (double)info.getSizeOfSubspace();
    }

    public double getSumWeight(int attr) {
        return this.m_SumWeights[attr];
    }

    public double getProportion(int attr, int cls) {
        double total = this.m_SumWeights[attr];
        if (total <= 1.0E-9) {
            return this.m_Training.getProportion(attr, cls);
        }
        return this.m_ClassCounts[attr][cls] / total;
    }

    public static double computeSplitInfo(double sum_tot, double sum_pos, double sum_neg) {
        if (sum_pos == 0.0) {
            return -1.0 * sum_neg / sum_tot * Math.log(sum_neg / sum_tot) / MathUtil.M_LN2;
        }
        if (sum_neg == 0.0) {
            return -1.0 * sum_pos / sum_tot * Math.log(sum_pos / sum_tot) / MathUtil.M_LN2;
        }
        return -(sum_pos / sum_tot * Math.log(sum_pos / sum_tot) + sum_neg / sum_tot * Math.log(sum_neg / sum_tot)) / MathUtil.M_LN2;
    }

    public boolean isCalcMean() {
        return this.m_MajorityClasses != null;
    }

    @Override
    public void calcMean() {
        this.m_MajorityClasses = new int[this.m_NbTarget];
        for (int i = 0; i < this.m_NbTarget; ++i) {
            this.m_MajorityClasses[i] = this.getMajorityClass(i);
        }
    }

    public void calcMeanSpatial() {
        this.m_MajorityClasses = new int[this.m_NbTarget];
        for (int i = 0; i < this.m_NbTarget; ++i) {
            this.m_MajorityClasses[i] = this.getMajorityClass(i);
        }
    }

    public double[] calcScores() {
        double[] scores = new double[this.m_NbTarget];
        for (int attr = 0; attr < this.m_NbTarget; ++attr) {
            scores[attr] = this.m_ClassCounts[attr][0] / this.m_SumWeights[attr];
        }
        return scores;
    }

    @Override
    public double getDispersion(ClusAttributeWeights scale, RowData data) {
        System.err.println(this.getClass().getName() + ": getDispersion(): Not yet implemented!");
        return Double.POSITIVE_INFINITY;
    }

    public double getGTestPValue(int att, ClusStatManager stat_manager) {
        double global_n = ((CombStat)stat_manager.getTrainSetStat()).getTotalWeight();
        double local_n = this.getTotalWeight();
        double ratio = local_n / global_n;
        double[] global_counts = ((CombStat)stat_manager.getTrainSetStat()).m_ClassStat.getClassCounts(att);
        double[] local_counts = this.getClassCounts(att);
        double g = 0.0;
        for (int i = 0; i < global_counts.length; ++i) {
            if (!(local_counts[i] > 0.0) || !(global_counts[i] > 0.0)) continue;
            g += 2.0 * local_counts[i] * Math.log(local_counts[i] / (global_counts[i] * ratio));
        }
        double degreesOfFreedom = (double)global_counts.length - 1.0;
        ChiSquaredDistribution chiSquaredDistribution = new ChiSquaredDistribution(degreesOfFreedom);
        return 1.0 - chiSquaredDistribution.cumulativeProbability(g);
    }

    public boolean getGTest(int att, ClusStatManager stat_manager) {
        double global_n = ((CombStat)stat_manager.getTrainSetStat()).getTotalWeight();
        double local_n = this.getTotalWeight();
        double ratio = local_n / global_n;
        double[] global_counts = ((CombStat)stat_manager.getTrainSetStat()).m_ClassStat.getClassCounts(att);
        double[] local_counts = this.getClassCounts(att);
        double g = 0.0;
        for (int i = 0; i < global_counts.length; ++i) {
            if (!(local_counts[i] > 0.0) || !(global_counts[i] > 0.0)) continue;
            g += 2.0 * local_counts[i] * Math.log(local_counts[i] / (global_counts[i] * ratio));
        }
        int df = global_counts.length - 1;
        double chi2_crit = stat_manager.getChiSquareInvProb(df);
        return g > chi2_crit;
    }

    @Override
    public double[] getNumericPred() {
        return null;
    }

    @Override
    public int[] getNominalPred() {
        return this.m_MajorityClasses;
    }

    @Override
    public String getString2() {
        StringBuffer buf = new StringBuffer();
        ClusNumberFormat fr = ClusFormat.SIX_AFTER_DOT;
        buf.append(fr.format(this.m_SumWeight));
        buf.append(" ");
        buf.append(super.toString());
        return buf.toString();
    }

    @Override
    public String getArrayOfStatistic() {
        StringBuffer buf = new StringBuffer();
        if (this.m_MajorityClasses != null) {
            buf.append("[");
            for (int i = 0; i < this.m_NbTarget; ++i) {
                if (i != 0) {
                    buf.append(",");
                }
                buf.append("\"" + this.m_Attrs[i].getValue(this.m_MajorityClasses[i]) + "\"");
            }
            buf.append("]");
        }
        return buf.toString();
    }

    public String getArrayOfStatisticExtended(boolean isMLC) {
        CharSequence[] majorityClasses = new String[this.m_NbTarget];
        for (int i = 0; i < this.m_NbTarget; ++i) {
            int maj_ind;
            String maj_str;
            NominalAttrType a = this.m_Attrs[i];
            if (isMLC) {
                maj_str = a.getName();
                maj_ind = NominalAttrType.POSITIVE_CLASS_INDEX;
            } else {
                maj_ind = this.m_MajorityClasses[i];
                maj_str = a.getValue(maj_ind);
            }
            double p = this.m_ClassCounts[i][maj_ind] / this.m_SumWeights[i];
            majorityClasses[i] = String.format("%f", p);
        }
        return "[" + String.join((CharSequence)",", majorityClasses) + "]";
    }

    public String getTargetNames() {
        CharSequence[] names = new String[this.m_NbTarget];
        for (int i = 0; i < this.m_NbTarget; ++i) {
            names[i] = "'" + this.m_Attrs[i].getName() + "'";
        }
        return "[" + String.join((CharSequence)", ", names) + "]";
    }

    @Override
    public String getString(StatisticPrintInfo info) {
        int i;
        StringBuffer buf = new StringBuffer();
        ClusNumberFormat fr = ClusFormat.SIX_AFTER_DOT;
        if (this.m_MajorityClasses != null) {
            buf.append("[");
            for (i = 0; i < this.m_NbTarget; ++i) {
                if (i != 0) {
                    buf.append(",");
                }
                buf.append(this.m_Attrs[i].getValue(this.m_MajorityClasses[i]));
            }
            buf.append("]");
        } else {
            buf.append("?");
        }
        if (info.SHOW_DISTRIBUTION) {
            for (int j = 0; j < this.m_NbTarget; ++j) {
                buf.append(" [");
                for (int i2 = 0; i2 < this.m_ClassCounts[j].length; ++i2) {
                    if (i2 != 0) {
                        buf.append(",");
                    }
                    buf.append(this.m_Attrs[j].getValue(i2));
                    buf.append(":");
                    buf.append(fr.format(this.m_ClassCounts[j][i2]));
                }
                buf.append("]");
            }
            if (info.SHOW_EXAMPLE_COUNT) {
                buf.append(":");
                buf.append(fr.format(this.m_SumWeight));
            }
        } else if (this.m_MajorityClasses != null) {
            buf.append(" [");
            for (i = 0; i < this.m_NbTarget; ++i) {
                if (i != 0) {
                    buf.append(",");
                }
                buf.append(this.m_ClassCounts[i][this.m_MajorityClasses[i]]);
            }
            buf.append("]: ");
            buf.append(fr.format(this.m_SumWeight));
        }
        return buf.toString();
    }

    @Override
    public void addPredictWriterSchema(String prefix, ClusSchema schema) {
        int i;
        for (i = 0; i < this.m_NbTarget; ++i) {
            ClusAttrType type = this.m_Attrs[i].cloneType();
            type.setName(prefix + "-p-" + type.getName());
            schema.addAttrType(type);
        }
        for (i = 0; i < this.m_NbTarget; ++i) {
            for (int j = 0; j < this.m_ClassCounts[i].length; ++j) {
                String value = this.m_Attrs[i].getValue(j);
                NumericAttrType type = new NumericAttrType(prefix + "-p-" + this.m_Attrs[i].getName() + "-" + value);
                schema.addAttrType(type);
            }
        }
    }

    @Override
    public String getPredictWriterString() {
        int i;
        StringBuffer buf = new StringBuffer();
        for (i = 0; i < this.m_NbTarget; ++i) {
            if (i != 0) {
                buf.append(",");
            }
            if (this.m_MajorityClasses != null) {
                buf.append(this.m_Attrs[i].getValue(this.m_MajorityClasses[i]));
                continue;
            }
            buf.append("?");
        }
        for (i = 0; i < this.m_NbTarget; ++i) {
            for (int j = 0; j < this.m_ClassCounts[i].length; ++j) {
                buf.append(",");
                buf.append("" + this.m_ClassCounts[i][j]);
            }
        }
        return buf.toString();
    }

    public int getNbClasses(int idx) {
        return this.m_ClassCounts[idx].length;
    }

    @Override
    public double getCount(int idx, int cls) {
        return this.m_ClassCounts[idx][cls];
    }

    @Override
    public String getPredictedClassName(int idx) {
        return this.m_Attrs[idx].getValue(this.getMajorityClass(idx));
    }

    public String getClassName(int idx, int cls) {
        return this.m_Attrs[idx].getValue(cls);
    }

    public void setCount(int idx, int cls, double count) {
        this.m_ClassCounts[idx][cls] = count;
    }

    @Override
    public String getSimpleString() {
        return this.getClassString() + " : " + super.getSimpleString();
    }

    @Override
    public String getClassString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.m_NbTarget; ++i) {
            if (i != 0) {
                buf.append(",");
            }
            buf.append(this.m_Attrs[i].getValue(this.m_MajorityClasses[i]));
        }
        return buf.toString();
    }

    public void initNormalizationWeights(ClusAttributeWeights weights, boolean[] shouldNormalize) {
        for (int i = 0; i < this.m_NbTarget; ++i) {
            int idx = this.m_Attrs[i].getIndex();
            if (!shouldNormalize[idx]) continue;
            double var = this.gini(i);
            double norm = var > 0.0 ? 1.0 / var : 1.0;
            weights.setWeight(this.m_Attrs[i], norm);
        }
    }

    public double[] getClassCounts(int i) {
        return this.m_ClassCounts[i];
    }

    public double[][] getClassCounts() {
        return this.m_ClassCounts;
    }

    @Override
    public String toString() {
        return this.getString();
    }

    @Override
    public void printDistribution(PrintWriter wrt) throws IOException {
        ClusNumberFormat fr = ClusFormat.SIX_AFTER_DOT;
        for (int i = 0; i < this.m_Attrs.length; ++i) {
            wrt.print(StringUtils.printStr(this.m_Attrs[i].getName(), 35));
            wrt.print(" [");
            double sum = 0.0;
            for (int j = 0; j < this.m_ClassCounts[i].length; ++j) {
                if (j != 0) {
                    wrt.print(",");
                }
                wrt.print(this.m_Attrs[i].getValue(j) + ":");
                wrt.print(fr.format(this.m_ClassCounts[i][j]));
                sum += this.m_ClassCounts[i][j];
            }
            wrt.println("]: " + fr.format(sum));
        }
    }

    @Override
    public void predictTuple(DataTuple prediction) {
        for (int i = 0; i < this.m_NbTarget; ++i) {
            NominalAttrType type = this.m_Attrs[i];
            type.setNominal(prediction, this.m_MajorityClasses[i]);
        }
    }

    @Override
    public void predictTupleOneComponent(DataTuple tuple, int i, int value) {
        NominalAttrType type = this.m_Attrs[i];
        type.setNominal(tuple, value);
    }

    @Override
    public void vote(ArrayList<ClusStatistic> votes) {
        switch (this.getSettings().getEnsemble().getEnsembleVotingType()) {
            case Majority: {
                this.voteMajority(votes);
                break;
            }
            default: {
                this.voteProbDistr(votes);
            }
        }
    }

    @Override
    public void vote(ArrayList<ClusStatistic> votes, ClusROSForestInfo ROSForestInfo) {
        switch (this.getSettings().getEnsemble().getEnsembleVotingType()) {
            case Majority: {
                this.voteMajority(votes, ROSForestInfo);
                break;
            }
            default: {
                this.voteProbDistr(votes, ROSForestInfo);
            }
        }
    }

    @Override
    public void vote(ArrayList<ClusStatistic> votes, ClusOOBWeights weights) {
        throw new RuntimeException("si.ijs.kt.clus.statistic.ClassificationStat.vote(ArrayList<ClusStatistic>, ArrayList<Double>) not implemented");
    }

    @Override
    public void vote(ArrayList<ClusStatistic> votes, ClusOOBWeights weights, ClusROSForestInfo ROSForestInfo) {
        throw new RuntimeException("si.ijs.kt.clus.statistic.ClusStatistic not implemented");
    }

    public void voteMajority(ArrayList<ClusStatistic> votes) {
        this.reset();
        int nb_votes = votes.size();
        this.m_SumWeight = nb_votes;
        Arrays.fill(this.m_SumWeights, (double)nb_votes);
        for (int j = 0; j < nb_votes; ++j) {
            ClassificationStat vote = (ClassificationStat)votes.get(j);
            for (int i = 0; i < this.m_NbTarget; ++i) {
                double[] dArray = this.m_ClassCounts[i];
                int n = vote.getNominalPred()[i];
                dArray[n] = dArray[n] + 1.0;
            }
        }
        this.calcMean();
    }

    public void voteMajority(ArrayList<ClusStatistic> votes, ClusROSForestInfo ROSForestInfo) {
        this.reset();
        int nb_votes = votes.size();
        this.m_SumWeight = nb_votes;
        Arrays.fill(this.m_SumWeights, (double)nb_votes);
        for (int j = 0; j < nb_votes; ++j) {
            ClassificationStat vote = (ClassificationStat)votes.get(j);
            ClusROSModelInfo info = ROSForestInfo.getROSModelInfo(j);
            for (Integer i : info.getTargets()) {
                double[] dArray = this.m_ClassCounts[i];
                int n = vote.getNominalPred()[i];
                dArray[n] = dArray[n] + 1.0;
            }
        }
        this.calcMean();
    }

    public void voteProbDistr(ArrayList<ClusStatistic> votes) {
        this.reset();
        int nb_votes = votes.size();
        for (int j = 0; j < nb_votes; ++j) {
            ClassificationStat vote = (ClassificationStat)votes.get(j);
            this.m_SumWeight += vote.m_SumWeight;
            for (int attr = 0; attr < this.m_NbTarget; ++attr) {
                int n = attr;
                this.m_SumWeights[n] = this.m_SumWeights[n] + vote.m_SumWeights[attr];
                double[] my = this.m_ClassCounts[attr];
                for (int i = 0; i < my.length; ++i) {
                    int n2 = i;
                    my[n2] = my[n2] + vote.getProportion(attr, i);
                }
            }
        }
        this.calcMean();
    }

    public void voteProbDistr(ArrayList<ClusStatistic> votes, ClusROSForestInfo ROSForestInfo) {
        this.reset();
        int nb_votes = votes.size();
        for (int j = 0; j < nb_votes; ++j) {
            ClassificationStat vote = (ClassificationStat)votes.get(j);
            ClusROSModelInfo info = ROSForestInfo.getROSModelInfo(j);
            this.m_SumWeight += vote.m_SumWeight;
            for (int attr = 0; attr < this.m_NbTarget; ++attr) {
                if (!info.isTargetEnabled(attr)) continue;
                int n = attr;
                this.m_SumWeights[n] = this.m_SumWeights[n] + vote.m_SumWeights[attr];
                double[] my = this.m_ClassCounts[attr];
                for (int i = 0; i < my.length; ++i) {
                    int n2 = i;
                    my[n2] = my[n2] + vote.getProportion(attr, i);
                }
            }
        }
        this.calcMean();
    }

    @Override
    public ClassificationStat getClassificationStat() {
        return this;
    }

    public double[][] getProbabilityPrediction() {
        double[][] result = new double[this.m_NbTarget][];
        for (int i = 0; i < this.m_NbTarget; ++i) {
            double total = 0.0;
            for (int k = 0; k < this.m_ClassCounts[i].length; ++k) {
                total += this.m_ClassCounts[i][k];
            }
            if (total == 0.0) {
                result[i] = this.getEstimatedProbabilityPrediction(i);
                continue;
            }
            result[i] = new double[this.m_ClassCounts[i].length];
            for (int j = 0; j < result[i].length; ++j) {
                result[i][j] = this.m_ClassCounts[i][j] / total;
            }
        }
        return result;
    }

    public double[] getProbabilityPrediction(int i) {
        double[] result = new double[this.m_ClassCounts[i].length];
        double total = 0.0;
        for (int k = 0; k < this.m_ClassCounts[i].length; ++k) {
            total += this.m_ClassCounts[i][k];
        }
        if (total == 0.0) {
            return this.getEstimatedProbabilityPrediction(i);
        }
        for (int j = 0; j < result.length; ++j) {
            result[j] = this.m_ClassCounts[i][j] / total;
        }
        return result;
    }

    public double[] getEstimatedProbabilityPrediction(int i) {
        switch (this.getSettings().getTree().getMissingClusteringAttrHandling()) {
            case EstimateFromParentNode: {
                return this.m_ParentStat.getProbabilityPrediction(i);
            }
            case Ignore: {
                return new double[this.m_ClassCounts[i].length];
            }
        }
        return this.m_Training.getProbabilityPrediction(i);
    }

    @Override
    public double getSquaredDistance(ClusStatistic other) {
        double[][] these = this.getProbabilityPrediction();
        ClassificationStat o = (ClassificationStat)other;
        double[][] others = o.getProbabilityPrediction();
        double result = 0.0;
        for (int i = 0; i < this.m_NbTarget; ++i) {
            double distance = 0.0;
            for (int j = 0; j < these[i].length; ++j) {
                distance += (these[i][j] - others[i][j]) * (these[i][j] - others[i][j]);
            }
            result += distance / (double)these[i].length;
        }
        return result / (double)this.m_NbTarget;
    }

    public double[] getPointwiseSquaredDistance(ClusStatistic other) {
        double[][] these = this.getProbabilityPrediction();
        ClassificationStat o = (ClassificationStat)other;
        double[][] others = o.getProbabilityPrediction();
        double[] distances = new double[this.m_NbTarget];
        for (int i = 0; i < this.m_NbTarget; ++i) {
            double distance = 0.0;
            for (int j = 0; j < these[i].length; ++j) {
                distance += (these[i][j] - others[i][j]) * (these[i][j] - others[i][j]);
            }
            distances[i] = distance / (double)these[i].length;
        }
        return distances;
    }

    public double getSumWeights(int attr) {
        return this.m_SumWeights[attr];
    }

    @Override
    public int getNbStatisticComponents() {
        return this.m_NbTarget;
    }

    @Override
    public void setData(RowData data) {
        this.m_data = data;
    }

    @Override
    public void setParentStat(ClusStatistic parent) {
        this.m_ParentStat = (ClassificationStat)parent;
    }

    @Override
    public double getTargetSumWeights() {
        return this.m_SumWeightLabeled;
    }

    @Override
    public ClusStatistic getParentStat() {
        return this.m_ParentStat;
    }

    @Override
    public void setSplitIndex(int i) {
        this.splitIndex = i;
    }

    public int getSplitIndex() {
        return this.splitIndex;
    }

    @Override
    public void setPrevIndex(int i) {
        this.prevIndex = i;
    }

    public int getPrevIndex() {
        return this.prevIndex;
    }

    @Override
    public void initializeSum() {
        Arrays.fill(this.previousSumX, 0.0);
        Arrays.fill(this.previousSumXR, 0.0);
        Arrays.fill(this.previousSumW, 0.0);
        Arrays.fill(this.previousSumWXX, 0.0);
        Arrays.fill(this.previousSumWX, 0.0);
        Arrays.fill(this.previousSumX2, 0.0);
        Arrays.fill(this.previousSumWR, 0.0);
        Arrays.fill(this.previousSumWXXR, 0.0);
        Arrays.fill(this.previousSumWXR, 0.0);
        Arrays.fill(this.previousSumX2R, 0.0);
    }

    public RowData getData() {
        return this.m_data;
    }

    @Override
    public double calcPDistance(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_data.getSchema();
        NumericAttrType xt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
        int M = 0;
        int N = this.m_data.getNbRows();
        if (this.splitIndex > 0) {
            N = this.splitIndex;
        } else {
            M = -this.splitIndex;
        }
        double[] upsum = new double[schema.getNbTargetAttributes()];
        double[] downsum = new double[schema.getNbTargetAttributes()];
        double[] means = new double[schema.getNbTargetAttributes()];
        double[] ikk = new double[schema.getNbTargetAttributes()];
        int k = 0;
        while (k < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k];
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNominal(exi);
                int n = k;
                means[n] = means[n] + xi;
            }
            int n = k++;
            means[n] = means[n] / (double)(N - M);
        }
        double avgik = 0.0;
        for (int k2 = 0; k2 < schema.getNbTargetAttributes(); ++k2) {
            NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k2];
            for (int i = M; i < N; ++i) {
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNominal(exi);
                for (int j = M; j < N; ++j) {
                    String indexMap;
                    Double temp;
                    long yyi;
                    long indexJ;
                    DataTuple exj = this.m_data.getTuple(j);
                    double xj = ((ClusAttrType)type).getNominal(exj);
                    long xxi = (long)((ClusAttrType)xt).getNumeric(exi);
                    long indexI = xxi;
                    if (indexI == (indexJ = (yyi = (long)((ClusAttrType)xt).getNumeric(exj)))) continue;
                    if (indexI > indexJ) {
                        indexI = yyi;
                        indexJ = xxi;
                    }
                    if ((temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) == null) continue;
                    int n = k2;
                    upsum[n] = upsum[n] + (xi - means[k2]) * (xj - means[k2]);
                }
                int n = k2;
                downsum[n] = downsum[n] + (xi - means[k2]) * (xi - means[k2]);
            }
            if (downsum[k2] != 0.0 && upsum[k2] != 0.0) {
                ikk[k2] = upsum[k2] / downsum[k2];
                avgik += ikk[k2];
                continue;
            }
            avgik = 1.0;
        }
        double IL = (avgik /= (double)schema.getNbTargetAttributes()) * (double)(N - M);
        N = this.m_data.getNbRows();
        M = this.splitIndex;
        double[] upsumR = new double[schema.getNbTargetAttributes()];
        double[] downsumR = new double[schema.getNbTargetAttributes()];
        double[] meansR = new double[schema.getNbTargetAttributes()];
        double[] ikkR = new double[schema.getNbTargetAttributes()];
        int k3 = 0;
        while (k3 < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k3];
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNominal(exi);
                int n = k3;
                meansR[n] = meansR[n] + xi;
            }
            int n = k3++;
            meansR[n] = meansR[n] / (double)(N - M);
        }
        double avgikR = 0.0;
        for (int k4 = 0; k4 < schema.getNbTargetAttributes(); ++k4) {
            NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k4];
            for (int i = M; i < N; ++i) {
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNominal(exi);
                for (int j = M; j < N; ++j) {
                    String indexMap;
                    Double temp;
                    long yyi;
                    long indexJ;
                    DataTuple exj = this.m_data.getTuple(permutation[j]);
                    double xj = ((ClusAttrType)type).getNominal(exj);
                    long xxi = (long)((ClusAttrType)xt).getNumeric(exi);
                    long indexI = xxi;
                    if (indexI == (indexJ = (yyi = (long)((ClusAttrType)xt).getNumeric(exj)))) continue;
                    if (indexI > indexJ) {
                        indexI = yyi;
                        indexJ = xxi;
                    }
                    if ((temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) == null) continue;
                    int n = k4;
                    upsumR[n] = upsumR[n] + (xi - meansR[k4]) * (xj - meansR[k4]);
                }
                int n = k4;
                downsumR[n] = downsumR[n] + (xi - meansR[k4]) * (xi - meansR[k4]);
            }
            if (downsumR[k4] != 0.0 && upsumR[k4] != 0.0) {
                ikkR[k4] = upsumR[k4] / downsumR[k4];
                avgikR += ikkR[k4];
                continue;
            }
            avgikR = 1.0;
        }
        double IR = avgikR /= (double)schema.getNbTargetAttributes();
        double I = (IL + IR * (double)(N - M)) / (double)this.m_data.getNbRows();
        double scaledI = 1.0 + I;
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return scaledI;
    }

    @Override
    public double calcPtotal(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_data.getSchema();
        int M = 0;
        int N = this.m_data.getNbRows();
        long NR = this.m_data.getNbRows();
        if (this.splitIndex > 0) {
            N = this.splitIndex;
        } else {
            M = -this.splitIndex;
        }
        double[] upsum = new double[schema.getNbTargetAttributes()];
        double[] downsum = new double[schema.getNbTargetAttributes()];
        double[] means = new double[schema.getNbTargetAttributes()];
        double[] ikk = new double[schema.getNbTargetAttributes()];
        int k = 0;
        while (k < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k];
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNominal(exi);
                int n = k;
                means[n] = means[n] + xi;
            }
            int n = k++;
            means[n] = means[n] / (double)(N - M);
        }
        double avgik = 0.0;
        for (int k2 = 0; k2 < schema.getNbTargetAttributes(); ++k2) {
            NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k2];
            for (int i = M; i < N; ++i) {
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNominal(exi);
                for (int j = M; j < N; ++j) {
                    long indexMap;
                    Double temp;
                    DataTuple exj = this.m_data.getTuple(permutation[j]);
                    double xj = ((ClusAttrType)type).getNominal(exj);
                    long indexI = permutation[i].intValue();
                    long indexJ = permutation[j].intValue();
                    if (permutation[i] == permutation[j]) continue;
                    if (permutation[i] > permutation[j]) {
                        indexI = permutation[j].intValue();
                        indexJ = permutation[i].intValue();
                    }
                    if ((temp = GISHeuristic.m_distances.get(indexMap = indexI * NR + indexJ)) == null) continue;
                    int n = k2;
                    upsum[n] = upsum[n] + (xi - means[k2]) * (xj - means[k2]);
                }
                int n = k2;
                downsum[n] = downsum[n] + (xi - means[k2]) * (xi - means[k2]);
            }
            if (downsum[k2] != 0.0 && upsum[k2] != 0.0) {
                ikk[k2] = upsum[k2] / downsum[k2];
                avgik += ikk[k2];
                continue;
            }
            avgik = 1.0;
        }
        double IL = (avgik /= (double)schema.getNbTargetAttributes()) * (double)(N - M);
        N = this.m_data.getNbRows();
        M = this.splitIndex;
        double[] upsumR = new double[schema.getNbTargetAttributes()];
        double[] downsumR = new double[schema.getNbTargetAttributes()];
        double[] meansR = new double[schema.getNbTargetAttributes()];
        double[] ikkR = new double[schema.getNbTargetAttributes()];
        int k3 = 0;
        while (k3 < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k3];
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNominal(exi);
                int n = k3;
                meansR[n] = meansR[n] + xi;
            }
            int n = k3++;
            meansR[n] = meansR[n] / (double)(N - M);
        }
        double avgikR = 0.0;
        for (int k4 = 0; k4 < schema.getNbTargetAttributes(); ++k4) {
            NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k4];
            for (int i = M; i < N; ++i) {
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNominal(exi);
                for (int j = M; j < N; ++j) {
                    long indexMap;
                    Double temp;
                    DataTuple exj = this.m_data.getTuple(permutation[j]);
                    double xj = ((ClusAttrType)type).getNominal(exj);
                    long indexI = permutation[i].intValue();
                    long indexJ = permutation[j].intValue();
                    if (permutation[i] == permutation[j]) continue;
                    if (permutation[i] > permutation[j]) {
                        indexI = permutation[j].intValue();
                        indexJ = permutation[i].intValue();
                    }
                    if ((temp = GISHeuristic.m_distances.get(indexMap = indexI * NR + indexJ)) == null) continue;
                    int n = k4;
                    upsumR[n] = upsumR[n] + (xi - meansR[k4]) * (xj - meansR[k4]);
                }
                int n = k4;
                downsumR[n] = downsumR[n] + (xi - meansR[k4]) * (xi - meansR[k4]);
            }
            if (downsumR[k4] != 0.0 && upsumR[k4] != 0.0) {
                ikkR[k4] = upsumR[k4] / downsumR[k4];
                avgikR += ikkR[k4];
                continue;
            }
            avgikR = 1.0;
        }
        double IR = avgikR /= (double)schema.getNbTargetAttributes();
        double I = (IL + IR * (double)(N - M)) / (double)this.m_data.getNbRows();
        double scaledI = 1.0 + I;
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return scaledI;
    }

    @Override
    public double calcMultiIwithNeighbours(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_data.getSchema();
        if (schema.getNbTargetAttributes() == 1) {
            throw new ClusException("Error calculating Bivariate Heuristics with only one target!");
        }
        int M = 0;
        int N = this.m_data.getNbRows();
        if (this.splitIndex > 0) {
            N = this.splitIndex;
        } else {
            M = -this.splitIndex;
        }
        double[] upsum = new double[schema.getNbTargetAttributes()];
        double[] downsum = new double[schema.getNbTargetAttributes()];
        double[] means = new double[schema.getNbTargetAttributes()];
        double[] ikk = new double[schema.getNbTargetAttributes()];
        int k = 0;
        while (k < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k];
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNominal(exi);
                int n = k;
                means[n] = means[n] + xi;
            }
            int n = k++;
            means[n] = means[n] / (double)(N - M);
        }
        double avgik = 0.0;
        for (int k2 = 0; k2 < schema.getNbTargetAttributes(); ++k2) {
            NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k2];
            int NeighCount = (int)schema.getSettings().getTree().getNumNeightbours();
            double W = 0.0;
            if (NeighCount > 0) {
                double[][] w = new double[N][N];
                for (int i = M; i < N; ++i) {
                    Distance[] distances = new Distance[NeighCount];
                    DataTuple exi = this.m_data.getTuple(permutation[i]);
                    NumericAttrType xt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
                    NumericAttrType yt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[1];
                    double ti = type.getNumeric(exi);
                    double xi = ((ClusAttrType)xt).getNumeric(exi);
                    double yi = ((ClusAttrType)yt).getNumeric(exi);
                    double biggestd = Double.POSITIVE_INFINITY;
                    int biggestindex = Integer.MAX_VALUE;
                    for (int j = M; j < N; ++j) {
                        DataTuple exj = this.m_data.getTuple(permutation[j]);
                        double tj = type.getNumeric(exj);
                        double xj = ((ClusAttrType)xt).getNumeric(exj);
                        double yj = ((ClusAttrType)yt).getNumeric(exj);
                        double d = Math.sqrt((xi - xj) * (xi - xj) + (yi - yj) * (yi - yj));
                        if (N - M < NeighCount) {
                            distances[j] = new Distance(permutation[j].intValue(), tj, d);
                            continue;
                        }
                        if (permutation[j] < NeighCount) {
                            distances[j] = new Distance(permutation[j].intValue(), tj, d);
                            continue;
                        }
                        biggestd = distances[0].distance;
                        biggestindex = 0;
                        for (int a = 1; a < NeighCount; ++a) {
                            if (!(distances[a].distance > biggestd)) continue;
                            biggestd = distances[a].distance;
                            biggestindex = a;
                        }
                        if (!(d < biggestd)) continue;
                        distances[biggestindex].index = permutation[j].intValue();
                        distances[biggestindex].target = tj;
                        distances[biggestindex].distance = d;
                    }
                    SettingsTree.SpatialMatrixType spatialMatrix = schema.getSettings().getTree().getSpatialMatrix();
                    int NN2 = N - M < NeighCount ? N - M : M + NeighCount;
                    for (int j = M; j < NN2; ++j) {
                        if (distances[j].distance == 0.0) {
                            w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                        } else {
                            switch (spatialMatrix) {
                                case Binary: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                    break;
                                }
                                case Euclidean: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0 / distances[j].distance;
                                    break;
                                }
                                case Modified: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount)) * (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount));
                                    break;
                                }
                                case Gaussian: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = Math.exp(-(distances[j].distance * distances[j].distance) / (double)(NeighCount * NeighCount));
                                    break;
                                }
                                default: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                }
                            }
                        }
                        int n = k2;
                        upsum[n] = upsum[n] + w[permutation[i]][permutation[j]] * (ti - means[k2]) * (distances[j].target - means[k2]);
                        W += w[permutation[i]][permutation[j]];
                    }
                    int n = k2;
                    downsum[n] = downsum[n] + (ti - means[k2]) * (ti - means[k2]);
                }
            }
            int n = k2;
            downsum[n] = downsum[n] / ((double)(N - M) + 0.0);
            if (downsum[k2] != 0.0 && upsum[k2] != 0.0) {
                ikk[k2] = upsum[k2] / (W * downsum[k2]);
                avgik += ikk[k2];
                continue;
            }
            avgik = 1.0;
        }
        double IL = (avgik /= (double)schema.getNbTargetAttributes()) * (double)(N - M);
        N = this.m_data.getNbRows();
        M = this.splitIndex;
        double[] upsumR = new double[schema.getNbTargetAttributes()];
        double[] downsumR = new double[schema.getNbTargetAttributes()];
        double[] meansR = new double[schema.getNbTargetAttributes()];
        double[] ikkR = new double[schema.getNbTargetAttributes()];
        int k3 = 0;
        while (k3 < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k3];
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNominal(exi);
                int n = k3;
                meansR[n] = meansR[n] + xi;
            }
            int n = k3++;
            meansR[n] = meansR[n] / (double)(N - M);
        }
        double avgikR = 0.0;
        for (int k4 = 0; k4 < schema.getNbTargetAttributes(); ++k4) {
            NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k4];
            int NeighCount = (int)schema.getSettings().getTree().getNumNeightbours();
            double WR = 0.0;
            if (NeighCount > 0) {
                double[][] w = new double[N][N];
                for (int i = M; i < N; ++i) {
                    Distance[] distances = new Distance[NeighCount];
                    DataTuple exi = this.m_data.getTuple(permutation[i]);
                    NumericAttrType xt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
                    NumericAttrType yt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[1];
                    double ti = type.getNumeric(exi);
                    double xi = ((ClusAttrType)xt).getNumeric(exi);
                    double yi = ((ClusAttrType)yt).getNumeric(exi);
                    int a = 0;
                    double biggestd = Double.POSITIVE_INFINITY;
                    int biggestindex = Integer.MAX_VALUE;
                    for (int j = M; j < N; ++j) {
                        DataTuple exj = this.m_data.getTuple(permutation[j]);
                        double tj = type.getNumeric(exj);
                        double xj = ((ClusAttrType)xt).getNumeric(exj);
                        double yj = ((ClusAttrType)yt).getNumeric(exj);
                        double d = Math.sqrt((xi - xj) * (xi - xj) + (yi - yj) * (yi - yj));
                        if (N - M < NeighCount) {
                            distances[a] = new Distance(permutation[j].intValue(), tj, d);
                            ++a;
                            continue;
                        }
                        if (a < NeighCount) {
                            distances[a] = new Distance(permutation[j].intValue(), tj, d);
                            ++a;
                            continue;
                        }
                        biggestd = distances[0].distance;
                        biggestindex = 0;
                        for (a = 1; a < NeighCount; ++a) {
                            if (!(distances[a].distance > biggestd)) continue;
                            biggestd = distances[a].distance;
                            biggestindex = a;
                        }
                        if (!(d < biggestd)) continue;
                        distances[biggestindex].index = permutation[j].intValue();
                        distances[biggestindex].target = tj;
                        distances[biggestindex].distance = d;
                    }
                    SettingsTree.SpatialMatrixType spatialMatrix = schema.getSettings().getTree().getSpatialMatrix();
                    for (int j = 0; distances.length > j && distances[j] != null && j < NeighCount; ++j) {
                        if (distances[j].distance == 0.0) {
                            w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                        } else {
                            switch (spatialMatrix) {
                                case Binary: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                    break;
                                }
                                case Euclidean: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0 / distances[j].distance;
                                    break;
                                }
                                case Modified: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount)) * (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount));
                                    break;
                                }
                                case Gaussian: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = Math.exp(-(distances[j].distance * distances[j].distance) / (double)(NeighCount * NeighCount));
                                    break;
                                }
                                default: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                }
                            }
                        }
                        int n = k4;
                        upsumR[n] = upsumR[n] + w[permutation[i]][permutation[j]] * (ti - meansR[k4]) * (distances[j].target - meansR[k4]);
                        WR += w[permutation[i]][permutation[j]];
                    }
                    int n = k4;
                    downsumR[n] = downsumR[n] + (ti - meansR[k4]) * (ti - meansR[k4]);
                }
            }
            int n = k4;
            downsumR[n] = downsumR[n] / ((double)(N - M) + 0.0);
            if (downsumR[k4] != 0.0 && upsumR[k4] != 0.0) {
                ikkR[k4] = upsumR[k4] / (WR * downsumR[k4]);
                avgikR += ikkR[k4];
                continue;
            }
            avgikR = 1.0;
        }
        double IR = avgikR /= (double)schema.getNbTargetAttributes();
        double I = (IL + IR * (double)(N - M)) / (double)this.m_data.getNbRows();
        double scaledI = 1.0 + I;
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return scaledI;
    }

    @Override
    public double calcBivariateLee(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_data.getSchema();
        if (schema.getNbTargetAttributes() == 1) {
            throw new ClusException("Error calculating Bivariate Heuristics with only one target!");
        }
        int M = 0;
        int N = this.m_data.getNbRows();
        long NR = this.m_data.getNbRows();
        if (this.splitIndex > 0) {
            N = this.splitIndex;
        } else {
            M = -this.splitIndex;
        }
        double[][] upsum = new double[schema.getNbTargetAttributes()][N - M];
        double[] means = new double[schema.getNbTargetAttributes()];
        double[] xi = new double[schema.getNbTargetAttributes()];
        double[] xj = new double[schema.getNbTargetAttributes()];
        int k = 0;
        while (k < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k];
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                double xxi = type.getNumeric(exi);
                int n = k;
                means[n] = means[n] + xxi;
            }
            int n = k++;
            means[n] = means[n] / (double)(N - M);
        }
        double avgik = 0.0;
        double upsum0 = 0.0;
        double upsum1 = 1.0;
        double downsum0 = 0.0;
        double downsum1 = 0.0;
        double WL = 0.0;
        for (int i = M; i < N; ++i) {
            DataTuple exi = this.m_data.getTuple(permutation[i]);
            for (int k2 = 0; k2 < schema.getNbTargetAttributes(); ++k2) {
                NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k2];
                xi[k2] = type.getNumeric(exi);
            }
            double W = 0.0;
            for (int j = M; j < N; ++j) {
                DataTuple exj = this.m_data.getTuple(permutation[j]);
                for (int k3 = 0; k3 < schema.getNbTargetAttributes(); ++k3) {
                    NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k3];
                    xj[k3] = type.getNumeric(exj);
                }
                double w = 0.0;
                long indexI = permutation[i].intValue();
                long indexJ = permutation[j].intValue();
                if (permutation[i] != permutation[j]) {
                    long indexMap;
                    Double temp;
                    if (permutation[i] > permutation[j]) {
                        indexI = permutation[j].intValue();
                        indexJ = permutation[i].intValue();
                    }
                    w = (temp = GISHeuristic.m_distances.get(indexMap = indexI * NR + indexJ)) != null ? temp : 0.0;
                    double[] dArray = upsum[0];
                    int n = permutation[i];
                    dArray[n] = dArray[n] + w * (xj[0] - means[0]);
                    double[] dArray2 = upsum[1];
                    int n2 = permutation[i];
                    dArray2[n2] = dArray2[n2] + w * (xj[1] - means[1]);
                    W += w;
                    continue;
                }
                double[] dArray = upsum[0];
                int n = permutation[i];
                dArray[n] = dArray[n] + (xi[0] - means[0]);
                double[] dArray3 = upsum[1];
                int n3 = permutation[i];
                dArray3[n3] = dArray3[n3] + (xi[1] - means[1]);
                W += 1.0;
            }
            WL += W * W;
            upsum0 += upsum[0][permutation[i]] * upsum[1][permutation[i]];
            downsum0 += (xi[0] - means[0]) * (xi[0] - means[0]);
            downsum1 += (xi[1] - means[1]) * (xi[1] - means[1]);
        }
        avgik = upsum0 != 0.0 && upsum1 != 0.0 && downsum0 != 0.0 && downsum1 != 0.0 ? ((double)(N - M) + 0.0) * upsum0 * upsum1 / (WL * Math.sqrt(downsum0 * downsum1)) : 0.0;
        double IL = avgik * (double)(N - M);
        N = this.m_data.getNbRows();
        M = this.splitIndex;
        double IR = 0.0;
        double upsumR0 = 0.0;
        double upsumR1 = 1.0;
        double downsumR0 = 0.0;
        double downsumR1 = 0.0;
        double WRR = 0.0;
        double[][] upsumR = new double[schema.getNbTargetAttributes()][N - M];
        double[] meansR = new double[schema.getNbTargetAttributes()];
        double[] xiR = new double[schema.getNbTargetAttributes()];
        double[] xjR = new double[schema.getNbTargetAttributes()];
        int k4 = 0;
        while (k4 < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k4];
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                double xxi = type.getNumeric(exi);
                int n = k4;
                meansR[n] = meansR[n] + xxi;
            }
            int n = k4++;
            meansR[n] = meansR[n] / (double)(N - M);
        }
        for (int i = M; i < N; ++i) {
            DataTuple exi = this.m_data.getTuple(permutation[i]);
            for (int k5 = 0; k5 < schema.getNbTargetAttributes(); ++k5) {
                NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k5];
                xiR[k5] = type.getNumeric(exi);
            }
            double WR = 0.0;
            for (int j = M; j < N; ++j) {
                DataTuple exj = this.m_data.getTuple(permutation[j]);
                for (int k6 = 0; k6 < schema.getNbTargetAttributes(); ++k6) {
                    NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k6];
                    xjR[k6] = type.getNumeric(exj);
                }
                double w = 0.0;
                long indexI = permutation[i].intValue();
                long indexJ = permutation[j].intValue();
                if (permutation[i] != permutation[j]) {
                    long indexMap;
                    Double temp;
                    if (permutation[i] > permutation[j]) {
                        indexI = permutation[j].intValue();
                        indexJ = permutation[i].intValue();
                    }
                    w = (temp = GISHeuristic.m_distances.get(indexMap = indexI * NR + indexJ)) != null ? temp : 0.0;
                    double[] dArray = upsumR[0];
                    int n = permutation[i] - M;
                    dArray[n] = dArray[n] + w * (xjR[0] - meansR[0]);
                    double[] dArray4 = upsumR[1];
                    int n4 = permutation[i] - M;
                    dArray4[n4] = dArray4[n4] + w * (xjR[1] - meansR[1]);
                    WR += w;
                    continue;
                }
                double[] dArray = upsumR[0];
                int n = permutation[i] - M;
                dArray[n] = dArray[n] + (xiR[0] - meansR[0]);
                double[] dArray5 = upsumR[1];
                int n5 = permutation[i] - M;
                dArray5[n5] = dArray5[n5] + (xiR[1] - meansR[1]);
                WR += 1.0;
            }
            WRR += WR * WR;
            upsumR0 += upsumR[0][permutation[i] - M] * upsumR[1][permutation[i] - M];
            downsumR0 += (xiR[0] - meansR[0]) * (xiR[0] - meansR[0]);
            downsumR1 += (xiR[1] - meansR[1]) * (xiR[1] - meansR[1]);
        }
        IR = upsumR0 != 0.0 && upsumR1 != 0.0 && downsumR0 != 0.0 && downsumR1 != 0.0 ? ((double)(N - M) + 0.0) * upsumR0 * upsumR1 / (WRR * Math.sqrt(downsumR0 * downsumR1)) : 0.0;
        double I = (IL + IR * (double)(N - M)) / (double)NR;
        double scaledI = 1.0 + I;
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return scaledI;
    }

    @Override
    public double calcLeewithNeighbours(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_data.getSchema();
        if (schema.getNbTargetAttributes() == 1) {
            throw new ClusException("Error calculating Bivariate Heuristics with only one target!");
        }
        int M = 0;
        int N = this.m_data.getNbRows();
        if (this.splitIndex > 0) {
            N = this.splitIndex;
        } else {
            M = -this.splitIndex;
        }
        double[][] upsum = new double[schema.getNbTargetAttributes()][N - M];
        double[] means = new double[schema.getNbTargetAttributes()];
        double[] xi = new double[schema.getNbTargetAttributes()];
        double[] xj = new double[schema.getNbTargetAttributes()];
        int k = 0;
        while (k < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k];
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                double m = type.getNumeric(exi);
                int n = k;
                means[n] = means[n] + m;
            }
            int n = k++;
            means[n] = means[n] / (double)(N - M);
        }
        double avgik = 0.0;
        double upsum0 = 0.0;
        double upsum1 = 1.0;
        double downsum0 = 0.0;
        double downsum1 = 0.0;
        double WL = 0.0;
        int NeighCount = (int)schema.getSettings().getTree().getNumNeightbours();
        SettingsTree.SpatialMatrixType spatialMatrix = schema.getSettings().getTree().getSpatialMatrix();
        int NN2 = N - M < NeighCount ? N - M : M + NeighCount;
        if (NeighCount > 0) {
            double[][] w = new double[N][N];
            for (int i = M; i < N; ++i) {
                int j;
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                double yyi = 0.0;
                double xxi = 0.0;
                double W = 0.0;
                for (int k2 = 0; k2 < schema.getNbTargetAttributes(); ++k2) {
                    NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k2];
                    NumericAttrType xt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
                    NumericAttrType yt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[1];
                    xi[k2] = type.getNumeric(exi);
                    xxi = ((ClusAttrType)xt).getNumeric(exi);
                    yyi = ((ClusAttrType)yt).getNumeric(exi);
                }
                double biggestd = Double.POSITIVE_INFINITY;
                int biggestindex = Integer.MAX_VALUE;
                DistanceB[] distances = new DistanceB[NeighCount];
                double yyj = 0.0;
                double xxj = 0.0;
                for (j = M; j < N; ++j) {
                    DataTuple exj = this.m_data.getTuple(permutation[j]);
                    for (int k3 = 0; k3 < schema.getNbTargetAttributes(); ++k3) {
                        NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k3];
                        NumericAttrType xt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
                        NumericAttrType yt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[1];
                        xj[k3] = type.getNumeric(exj);
                        xxj = ((ClusAttrType)xt).getNumeric(exi);
                        yyj = ((ClusAttrType)yt).getNumeric(exi);
                    }
                    double d = Math.sqrt((xxi - xxj) * (xxi - xxj) + (yyi - yyj) * (yyi - yyj));
                    if (N - M < NeighCount) {
                        distances[j] = new DistanceB(permutation[j].intValue(), xj[0], xj[1], d);
                        continue;
                    }
                    if (permutation[j] < NeighCount) {
                        distances[j] = new DistanceB(permutation[j].intValue(), xj[0], xj[1], d);
                        continue;
                    }
                    biggestd = distances[0].distance;
                    biggestindex = 0;
                    for (int a = 1; a < NeighCount; ++a) {
                        if (!(distances[a].distance > biggestd)) continue;
                        biggestd = distances[a].distance;
                        biggestindex = a;
                    }
                    if (!(d < biggestd)) continue;
                    distances[biggestindex].index = permutation[j].intValue();
                    distances[biggestindex].distance = d;
                    distances[biggestindex].target1 = xj[0];
                    distances[biggestindex].target2 = xj[1];
                }
                for (j = M; j < NN2; ++j) {
                    if (distances[j].distance == 0.0) {
                        w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                    } else {
                        switch (spatialMatrix) {
                            case Binary: {
                                w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                break;
                            }
                            case Euclidean: {
                                w[permutation[i].intValue()][permutation[j].intValue()] = 1.0 / distances[j].distance;
                                break;
                            }
                            case Modified: {
                                w[permutation[i].intValue()][permutation[j].intValue()] = (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount)) * (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount));
                                break;
                            }
                            case Gaussian: {
                                w[permutation[i].intValue()][permutation[j].intValue()] = Math.exp(-(distances[j].distance * distances[j].distance) / (double)(NeighCount * NeighCount));
                                break;
                            }
                            default: {
                                w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                            }
                        }
                    }
                    double[] dArray = upsum[0];
                    int n = permutation[i];
                    dArray[n] = dArray[n] + w[permutation[i]][permutation[j]] * (xj[0] - means[0]);
                    double[] dArray2 = upsum[1];
                    int n2 = permutation[i];
                    dArray2[n2] = dArray2[n2] + w[permutation[i]][permutation[j]] * (xj[1] - means[1]);
                    W += w[permutation[i]][permutation[j]];
                }
                WL += W * W;
                upsum0 += upsum[0][permutation[i]] * upsum[1][permutation[i]];
                downsum0 += (xi[0] - means[0]) * (xi[0] - means[0]);
                downsum1 += (xi[1] - means[1]) * (xi[1] - means[1]);
            }
        }
        avgik = upsum0 != 0.0 && upsum1 != 0.0 && downsum0 != 0.0 && downsum1 != 0.0 ? ((double)(N - M) + 0.0) * upsum0 * upsum1 / (WL * Math.sqrt(downsum0 * downsum1)) : 0.0;
        double IL = avgik * (double)(N - M);
        N = this.m_data.getNbRows();
        M = this.splitIndex;
        double[][] upsumR = new double[schema.getNbTargetAttributes()][N - M];
        double[] meansR = new double[schema.getNbTargetAttributes()];
        double[] xRi = new double[schema.getNbTargetAttributes()];
        double[] xRj = new double[schema.getNbTargetAttributes()];
        int k4 = 0;
        while (k4 < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k4];
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                double m = type.getNumeric(exi);
                int n = k4;
                meansR[n] = meansR[n] + m;
            }
            int n = k4++;
            meansR[n] = meansR[n] / (double)(N - M);
        }
        double avgikR = 0.0;
        double upsumR0 = 0.0;
        double upsumR1 = 1.0;
        double downsumR0 = 0.0;
        double downsumR1 = 0.0;
        double WRR = 0.0;
        if (NeighCount > 0) {
            double[][] w = new double[N][N];
            for (int i = M; i < N; ++i) {
                int j;
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                double yyi = 0.0;
                double xxi = 0.0;
                double WR = 0.0;
                for (int k5 = 0; k5 < schema.getNbTargetAttributes(); ++k5) {
                    NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k5];
                    NumericAttrType xt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
                    NumericAttrType yt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[1];
                    xRi[k5] = type.getNumeric(exi);
                    xxi = ((ClusAttrType)xt).getNumeric(exi);
                    yyi = ((ClusAttrType)yt).getNumeric(exi);
                }
                double biggestd = Double.POSITIVE_INFINITY;
                int biggestindex = Integer.MAX_VALUE;
                int a = 0;
                DistanceB[] distances = new DistanceB[NeighCount];
                double yyj = 0.0;
                double xxj = 0.0;
                for (j = M; j < N; ++j) {
                    DataTuple exj = this.m_data.getTuple(permutation[j]);
                    for (int k6 = 0; k6 < schema.getNbTargetAttributes(); ++k6) {
                        NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k6];
                        NumericAttrType xt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
                        NumericAttrType yt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[1];
                        xRj[k6] = type.getNumeric(exj);
                        xxj = ((ClusAttrType)xt).getNumeric(exi);
                        yyj = ((ClusAttrType)yt).getNumeric(exi);
                    }
                    double d = Math.sqrt((xxi - xxj) * (xxi - xxj) + (yyi - yyj) * (yyi - yyj));
                    if (N - M < NeighCount) {
                        distances[a] = new DistanceB(permutation[j].intValue(), xRj[0], xRj[1], d);
                        ++a;
                        continue;
                    }
                    if (a < NeighCount) {
                        distances[a] = new DistanceB(permutation[j].intValue(), xRj[0], xRj[1], d);
                        ++a;
                        continue;
                    }
                    biggestindex = 0;
                    biggestd = distances[0].distance;
                    for (a = 1; a < NeighCount; ++a) {
                        if (!(distances[a].distance > biggestd)) continue;
                        biggestd = distances[a].distance;
                        biggestindex = a;
                    }
                    if (!(d < biggestd)) continue;
                    distances[biggestindex].index = permutation[j].intValue();
                    distances[biggestindex].distance = d;
                    distances[biggestindex].target1 = xRj[0];
                    distances[biggestindex].target2 = xRj[1];
                }
                j = 0;
                while (distances.length > j && distances[j] != null && j < NeighCount) {
                    if (distances[j].distance == 0.0) {
                        w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                    } else {
                        switch (spatialMatrix) {
                            case Binary: {
                                w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                break;
                            }
                            case Euclidean: {
                                w[permutation[i].intValue()][permutation[j].intValue()] = 1.0 / distances[j].distance;
                                break;
                            }
                            case Modified: {
                                w[permutation[i].intValue()][permutation[j].intValue()] = (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount)) * (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount));
                                break;
                            }
                            case Gaussian: {
                                w[permutation[i].intValue()][permutation[j].intValue()] = Math.exp(-(distances[j].distance * distances[j].distance) / (double)(NeighCount * NeighCount));
                                break;
                            }
                            default: {
                                w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                            }
                        }
                    }
                    double[] dArray = upsumR[0];
                    int n = permutation[i];
                    dArray[n] = dArray[n] + w[permutation[i]][permutation[j]] * (xRj[0] - meansR[0]);
                    double[] dArray3 = upsumR[1];
                    int n3 = permutation[i];
                    dArray3[n3] = dArray3[n3] + w[permutation[i]][permutation[j]] * (xRj[1] - meansR[1]);
                    WR += w[permutation[i]][permutation[j]];
                }
                WRR += WR * WR;
                upsumR0 += upsumR[0][permutation[i]] * upsumR[1][permutation[i]];
                downsumR0 += (xRi[0] - meansR[0]) * (xRi[0] - meansR[0]);
                downsumR1 += (xRi[1] - meansR[1]) * (xRi[1] - meansR[1]);
            }
        }
        avgikR = upsumR0 != 0.0 && upsumR1 != 0.0 && downsumR0 != 0.0 && downsumR1 != 0.0 ? ((double)(N - M) + 0.0) * upsumR0 * upsumR1 / (WRR * Math.sqrt(downsumR0 * downsumR1)) : 0.0;
        double IR = avgikR * (double)(N - M);
        double I = (IL + IR * (double)(N - M)) / (double)this.m_data.getNbRows();
        double scaledI = 1.0 + I;
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return scaledI;
    }

    @Override
    public double calcMutivariateItotal(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_data.getSchema();
        if (schema.getNbTargetAttributes() == 1) {
            throw new ClusException("Error calculating Bivariate Heuristics with only one target!");
        }
        int M = 0;
        int N = this.m_data.getNbRows();
        long NR = this.m_data.getNbRows();
        if (this.splitIndex > 0) {
            N = this.splitIndex;
        } else {
            M = -this.splitIndex;
        }
        double upsum = 0.0;
        double downsumAll = 1.0;
        double ikk = 0.0;
        double W = 0.0;
        double[] downsum = new double[schema.getNbTargetAttributes()];
        double[] means = new double[schema.getNbTargetAttributes()];
        double[] xi = new double[schema.getNbTargetAttributes()];
        double[] xj = new double[schema.getNbTargetAttributes()];
        int k = 0;
        while (k < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k];
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                double xxi = type.getNumeric(exi);
                int n = k;
                means[n] = means[n] + xxi;
            }
            int n = k++;
            means[n] = means[n] / (double)(N - M);
        }
        for (int i = M; i < N; ++i) {
            int k2;
            DataTuple exi = this.m_data.getTuple(permutation[i]);
            for (k2 = 0; k2 < schema.getNbTargetAttributes(); ++k2) {
                NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k2];
                xi[k2] = type.getNumeric(exi);
            }
            for (int j = M; j < N; ++j) {
                long indexMap;
                Double temp;
                DataTuple exj = this.m_data.getTuple(permutation[j]);
                for (int k3 = 0; k3 < schema.getNbTargetAttributes(); ++k3) {
                    NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k3];
                    xj[k3] = type.getNumeric(exj);
                }
                double w = 0.0;
                long indexI = permutation[i].intValue();
                long indexJ = permutation[j].intValue();
                if (permutation[i] == permutation[j]) continue;
                if (permutation[i] > permutation[j]) {
                    indexI = permutation[j].intValue();
                    indexJ = permutation[i].intValue();
                }
                w = (temp = GISHeuristic.m_distances.get(indexMap = indexI * NR + indexJ)) != null ? temp : 0.0;
                upsum += w * (xi[0] - means[0]) * (xj[1] - means[1]);
                W += w;
            }
            for (k2 = 0; k2 < schema.getNbTargetAttributes(); ++k2) {
                int n = k2;
                downsum[n] = downsum[n] + (xi[k2] - means[k2]) * (xi[k2] - means[k2]);
            }
        }
        for (k = 0; k < schema.getNbTargetAttributes(); ++k) {
            downsumAll *= downsum[k];
        }
        ikk = downsumAll > 0.0 && upsum != 0.0 ? ((double)(N - M) + 0.0) * upsum / (W * Math.sqrt(downsumAll)) : 0.0;
        double IL = ikk * (double)(N - M);
        N = this.m_data.getNbRows();
        M = this.splitIndex;
        double upsumR = 0.0;
        double downsumAllR = 1.0;
        double ikkR = 0.0;
        double WR = 0.0;
        double[] downsumR = new double[schema.getNbTargetAttributes()];
        double[] meansR = new double[schema.getNbTargetAttributes()];
        double[] xiR = new double[schema.getNbTargetAttributes()];
        double[] xjR = new double[schema.getNbTargetAttributes()];
        int k4 = 0;
        while (k4 < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k4];
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                double xxi = type.getNumeric(exi);
                int n = k4;
                meansR[n] = meansR[n] + xxi;
            }
            int n = k4++;
            meansR[n] = meansR[n] / (double)(N - M);
        }
        for (int i = M; i < N; ++i) {
            int k5;
            DataTuple exi = this.m_data.getTuple(permutation[i]);
            for (k5 = 0; k5 < schema.getNbTargetAttributes(); ++k5) {
                NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k5];
                xiR[k5] = type.getNumeric(exi);
            }
            for (int j = M; j < N; ++j) {
                long indexMap;
                Double temp;
                DataTuple exj = this.m_data.getTuple(permutation[j]);
                for (int k6 = 0; k6 < schema.getNbTargetAttributes(); ++k6) {
                    NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k6];
                    xjR[k6] = type.getNumeric(exj);
                }
                double w = 0.0;
                long indexI = permutation[i].intValue();
                long indexJ = permutation[j].intValue();
                if (permutation[i] == permutation[j]) continue;
                if (permutation[i] > permutation[j]) {
                    indexI = permutation[j].intValue();
                    indexJ = permutation[i].intValue();
                }
                w = (temp = GISHeuristic.m_distances.get(indexMap = indexI * NR + indexJ)) != null ? temp : 0.0;
                upsumR += w * (xiR[0] - meansR[0]) * (xjR[1] - meansR[1]);
                WR += w;
            }
            for (k5 = 0; k5 < schema.getNbTargetAttributes(); ++k5) {
                int n = k5;
                downsumR[n] = downsumR[n] + (xiR[k5] - meansR[k5]) * (xiR[k5] - meansR[k5]);
            }
        }
        for (k4 = 0; k4 < schema.getNbTargetAttributes(); ++k4) {
            downsumAllR *= downsumR[k4];
        }
        ikkR = downsumAllR > 0.0 && upsumR != 0.0 ? ((double)(N - M) + 0.0) * upsumR / (WR * Math.sqrt(downsumAllR)) : 0.0;
        double IR = ikkR;
        double I = (IL + IR * (double)(N - M)) / (double)N;
        double scaledI = 1.0 + I;
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return scaledI;
    }

    @Override
    public double calcCItotalD(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_data.getSchema();
        NumericAttrType xt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
        int M = 0;
        int N = this.m_data.getNbRows();
        if (this.splitIndex > 0) {
            N = this.splitIndex;
        } else {
            M = -this.splitIndex;
        }
        double[] D = new double[N - M];
        double[] W = new double[N - M];
        double[][] w = new double[N - M][N - M];
        double[] ikk = new double[this.m_NbAttrs];
        double avgik = 0.0;
        for (int k = 0; k < this.m_NbAttrs; ++k) {
            int i;
            for (i = M; i < N; ++i) {
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                long xxi = (long)((ClusAttrType)xt).getNumeric(exi);
                for (int j = M; j < N; ++j) {
                    String indexMap;
                    Double temp;
                    long indexI = xxi;
                    DataTuple exj = this.m_data.getTuple(permutation[j]);
                    long yyi = (long)((ClusAttrType)xt).getNumeric(exj);
                    long indexJ = yyi;
                    if (indexI == indexJ) continue;
                    if (indexI > indexJ) {
                        indexI = yyi;
                        indexJ = xxi;
                    }
                    w[permutation[i].intValue()][permutation[j].intValue()] = (temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) != null ? temp : 0.0;
                    int n = permutation[i];
                    D[n] = D[n] + w[permutation[i]][permutation[j]];
                }
            }
            for (i = M; i < N; ++i) {
                for (int j = M; j < N; ++j) {
                    if (permutation[i] == permutation[j] || D[permutation[j]] == 0.0) continue;
                    int n = permutation[i];
                    W[n] = W[n] + Math.sqrt(D[permutation[j]]);
                }
                if (D[permutation[i]] == 0.0) continue;
                int n = k;
                ikk[n] = ikk[n] + Math.sqrt(D[permutation[i]]);
            }
            avgik += ikk[k];
        }
        double IL = avgik /= (double)this.m_NbAttrs;
        if (Double.isNaN(IL)) {
            IL = 0.0;
        }
        N = this.m_data.getNbRows();
        M = this.splitIndex;
        double IR = 0.0;
        double[] DR = new double[N - M];
        double[] WR = new double[N - M];
        double[][] wr = new double[N - M][N - M];
        double[] ikkR = new double[this.m_NbAttrs];
        for (int k = 0; k < this.m_NbAttrs; ++k) {
            int i;
            for (i = M; i < N; ++i) {
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                long xxi = (long)((ClusAttrType)xt).getNumeric(exi);
                for (int j = M; j < N; ++j) {
                    String indexMap;
                    Double temp;
                    long indexI = xxi;
                    DataTuple exj = this.m_data.getTuple(permutation[j]);
                    long yyi = (long)((ClusAttrType)xt).getNumeric(exj);
                    long indexJ = yyi;
                    if (indexI == indexJ) continue;
                    if (indexI > indexJ) {
                        indexI = yyi;
                        indexJ = xxi;
                    }
                    wr[permutation[i].intValue() - M][permutation[j].intValue() - M] = (temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) != null ? temp : 0.0;
                    int n = permutation[i] - M;
                    DR[n] = DR[n] + wr[permutation[i] - M][permutation[j] - M];
                }
            }
            for (i = M; i < N; ++i) {
                for (int j = M; j < N; ++j) {
                    if (permutation[i] == permutation[j] || DR[permutation[j] - M] == 0.0) continue;
                    int n = permutation[i] - M;
                    WR[n] = WR[n] + wr[permutation[i] - M][permutation[j] - M] / Math.sqrt(DR[permutation[j] - M]);
                }
                if (DR[permutation[i] - M] == 0.0) continue;
                int n = k;
                ikkR[n] = ikkR[n] + WR[permutation[i] - M] / Math.sqrt(DR[permutation[i] - M]);
            }
            IR += ikkR[k];
        }
        if (Double.isNaN(IR /= (double)this.m_NbAttrs)) {
            IR = 0.0;
        }
        double I = (IL + IR) / (double)this.m_data.getNbRows();
        double scaledI = 1.0 + I;
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return scaledI;
    }

    @Override
    public double calcCItotal(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_data.getSchema();
        int M = 0;
        int N = this.m_data.getNbRows();
        long NR = this.m_data.getNbRows();
        if (this.splitIndex > 0) {
            N = this.splitIndex;
        } else {
            M = -this.splitIndex;
        }
        double[] D = new double[N - M];
        double[] W = new double[N - M];
        double[][] w = new double[N - M][N - M];
        double[] ikk = new double[schema.getNbTargetAttributes()];
        double avgik = 0.0;
        for (int k = 0; k < schema.getNbTargetAttributes(); ++k) {
            int j;
            int i;
            for (i = M; i < N; ++i) {
                for (j = M; j < N; ++j) {
                    String indexMap;
                    Double temp;
                    long indexI = permutation[i].intValue();
                    long indexJ = permutation[j].intValue();
                    if (permutation[i] == permutation[j]) continue;
                    if (permutation[i] > permutation[j]) {
                        indexI = permutation[j].intValue();
                        indexJ = permutation[i].intValue();
                    }
                    w[permutation[i].intValue()][permutation[j].intValue()] = (temp = GISHeuristic.m_distances.get(indexMap = indexI + "#" + indexJ)) != null ? temp : 0.0;
                    int n = permutation[i];
                    D[n] = D[n] + w[permutation[i]][permutation[j]];
                }
            }
            for (i = M; i < N; ++i) {
                for (j = M; j < N; ++j) {
                    if (permutation[i] == permutation[j] || D[permutation[j]] == 0.0) continue;
                    int n = permutation[i];
                    W[n] = W[n] + w[permutation[i]][permutation[j]] / Math.sqrt(D[permutation[j]]);
                }
                if (D[permutation[i]] != 0.0) {
                    int n = k;
                    ikk[n] = ikk[n] + W[permutation[i]] / Math.sqrt(D[permutation[i]]);
                }
                int n = k;
                ikk[n] = ikk[n] + W[permutation[i]] / Math.sqrt(D[permutation[i]]);
            }
            avgik += ikk[k];
        }
        double IL = avgik /= (double)schema.getNbTargetAttributes();
        if (Double.isNaN(IL)) {
            IL = 0.0;
        }
        N = this.m_data.getNbRows();
        M = this.splitIndex;
        double IR = 0.0;
        double[] DR = new double[N - M];
        double[] WR = new double[N - M];
        double[][] wr = new double[N - M][N - M];
        double[] ikkR = new double[schema.getNbTargetAttributes()];
        for (int k = 0; k < schema.getNbTargetAttributes(); ++k) {
            int j;
            int i;
            for (i = M; i < N; ++i) {
                for (j = M; j < N; ++j) {
                    long indexMap;
                    Double temp;
                    long indexI = permutation[i].intValue();
                    long indexJ = permutation[j].intValue();
                    if (permutation[i] == permutation[j]) continue;
                    if (permutation[i] > permutation[j]) {
                        indexI = permutation[j].intValue();
                        indexJ = permutation[i].intValue();
                    }
                    wr[permutation[i].intValue() - M][permutation[j].intValue() - M] = (temp = GISHeuristic.m_distances.get(indexMap = indexI * NR + indexJ)) != null ? temp : 0.0;
                    int n = permutation[i] - M;
                    DR[n] = DR[n] + wr[permutation[i] - M][permutation[j] - M];
                }
            }
            for (i = M; i < N; ++i) {
                for (j = M; j < N; ++j) {
                    if (permutation[i] == permutation[j] || DR[permutation[j] - M] == 0.0) continue;
                    int n = permutation[i] - M;
                    WR[n] = WR[n] + wr[permutation[i] - M][permutation[j] - M] / Math.sqrt(DR[permutation[j] - M]);
                }
                int n = k;
                ikkR[n] = ikkR[n] + WR[permutation[i] - M] / Math.sqrt(DR[permutation[i] - M]);
            }
            IR += ikkR[k];
        }
        if (Double.isNaN(IR /= (double)schema.getNbTargetAttributes())) {
            IR = 0.0;
        }
        double I = (IL + IR) / (double)this.m_data.getNbRows();
        double scaledI = 1.0 + I;
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return scaledI;
    }

    @Override
    public double calcCIwithNeighbours(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_data.getSchema();
        int M = 0;
        int N = this.m_data.getNbRows();
        if (this.splitIndex > 0) {
            N = this.splitIndex;
        } else {
            M = -this.splitIndex;
        }
        double[] ikk = new double[schema.getNbTargetAttributes()];
        double avgik = 0.0;
        for (int k = 0; k < schema.getNbTargetAttributes(); ++k) {
            NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k];
            int NeighCount = (int)schema.getSettings().getTree().getNumNeightbours();
            double[] D = new double[N - M];
            double[] W = new double[N - M];
            if (NeighCount > 0) {
                int i;
                double[][] w = new double[N][N];
                Distance[] distances = new Distance[NeighCount];
                double biggestd = Double.POSITIVE_INFINITY;
                int biggestindex = Integer.MAX_VALUE;
                SettingsTree.SpatialMatrixType spatialMatrix = schema.getSettings().getTree().getSpatialMatrix();
                int NN2 = N - M < NeighCount ? N - M : M + NeighCount;
                for (i = M; i < N; ++i) {
                    int j;
                    DataTuple exi = this.m_data.getTuple(permutation[i]);
                    NumericAttrType xt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
                    NumericAttrType yt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[1];
                    double xi = ((ClusAttrType)xt).getNumeric(exi);
                    double yi = ((ClusAttrType)yt).getNumeric(exi);
                    for (j = M; j < N; ++j) {
                        DataTuple exj = this.m_data.getTuple(permutation[j]);
                        double tj = type.getNumeric(exj);
                        double xj = ((ClusAttrType)xt).getNumeric(exj);
                        double yj = ((ClusAttrType)yt).getNumeric(exj);
                        double d = Math.sqrt((xi - xj) * (xi - xj) + (yi - yj) * (yi - yj));
                        if (N - M < NeighCount) {
                            distances[j] = new Distance(permutation[j].intValue(), tj, d);
                            continue;
                        }
                        if (permutation[j] < NeighCount) {
                            distances[j] = new Distance(permutation[j].intValue(), tj, d);
                            continue;
                        }
                        biggestd = distances[0].distance;
                        biggestindex = 0;
                        for (int a = 1; a < NeighCount; ++a) {
                            if (!(distances[a].distance > biggestd)) continue;
                            biggestd = distances[a].distance;
                            biggestindex = a;
                        }
                        if (!(d < biggestd)) continue;
                        distances[biggestindex].index = permutation[j].intValue();
                        distances[biggestindex].target = tj;
                        distances[biggestindex].distance = d;
                    }
                    for (j = M; j < NN2; ++j) {
                        if (distances[j].distance == 0.0) {
                            w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                        } else {
                            switch (spatialMatrix) {
                                case Binary: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                    break;
                                }
                                case Euclidean: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0 / distances[j].distance;
                                    break;
                                }
                                case Modified: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount)) * (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount));
                                    break;
                                }
                                case Gaussian: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = Math.exp(-(distances[j].distance * distances[j].distance) / (double)(NeighCount * NeighCount));
                                    break;
                                }
                                default: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                }
                            }
                        }
                        int n = permutation[i];
                        D[n] = D[n] + w[permutation[i]][permutation[j]];
                    }
                }
                for (i = M; i < N; ++i) {
                    for (int j = M; j < NN2; ++j) {
                        if (distances[j].distance == 0.0) {
                            w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                        } else {
                            switch (spatialMatrix) {
                                case Binary: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                    break;
                                }
                                case Euclidean: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0 / distances[j].distance;
                                    break;
                                }
                                case Modified: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount)) * (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount));
                                    break;
                                }
                                case Gaussian: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = Math.exp(-(distances[j].distance * distances[j].distance) / (double)(NeighCount * NeighCount));
                                    break;
                                }
                                default: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                }
                            }
                        }
                        int n = permutation[i];
                        W[n] = W[n] + w[permutation[i]][permutation[j]] / Math.sqrt(D[permutation[j]]);
                    }
                    int n = k;
                    ikk[n] = ikk[n] + W[permutation[i]] / Math.sqrt(D[permutation[i]]);
                }
            }
            avgik += ikk[k];
        }
        double IL = (avgik /= (double)schema.getNbTargetAttributes()) * (double)(N - M);
        N = this.m_data.getNbRows();
        M = this.splitIndex;
        double[] ikkR = new double[schema.getNbTargetAttributes()];
        double avgikR = 0.0;
        for (int k = 0; k < schema.getNbTargetAttributes(); ++k) {
            NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k];
            int NeighCount = (int)schema.getSettings().getTree().getNumNeightbours();
            double[] DR = new double[N - M];
            double[] WR = new double[N - M];
            if (NeighCount > 0) {
                int i;
                double[][] w = new double[N][N];
                Distance[] distances = new Distance[NeighCount];
                double biggestd = Double.POSITIVE_INFINITY;
                int biggestindex = Integer.MAX_VALUE;
                SettingsTree.SpatialMatrixType spatialMatrix = schema.getSettings().getTree().getSpatialMatrix();
                for (i = M; i < N; ++i) {
                    int j;
                    DataTuple exi = this.m_data.getTuple(permutation[i]);
                    NumericAttrType xt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
                    NumericAttrType yt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[1];
                    double xi = ((ClusAttrType)xt).getNumeric(exi);
                    double yi = ((ClusAttrType)yt).getNumeric(exi);
                    int a = 0;
                    for (j = M; j < N; ++j) {
                        DataTuple exj = this.m_data.getTuple(permutation[j]);
                        double tj = type.getNumeric(exj);
                        double xj = ((ClusAttrType)xt).getNumeric(exj);
                        double yj = ((ClusAttrType)yt).getNumeric(exj);
                        double d = Math.sqrt((xi - xj) * (xi - xj) + (yi - yj) * (yi - yj));
                        if (N - M < NeighCount) {
                            distances[a] = new Distance(permutation[j].intValue(), tj, d);
                            ++a;
                            continue;
                        }
                        if (a < NeighCount) {
                            distances[a] = new Distance(permutation[j].intValue(), tj, d);
                            ++a;
                            continue;
                        }
                        biggestd = distances[0].distance;
                        biggestindex = 0;
                        for (a = 1; a < NeighCount; ++a) {
                            if (!(distances[a].distance > biggestd)) continue;
                            biggestd = distances[a].distance;
                            biggestindex = a;
                        }
                        if (!(d < biggestd)) continue;
                        distances[biggestindex].index = permutation[j].intValue();
                        distances[biggestindex].target = tj;
                        distances[biggestindex].distance = d;
                    }
                    j = 0;
                    while (j < NeighCount) {
                        if (distances[j].distance == 0.0) {
                            w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                        } else {
                            switch (spatialMatrix) {
                                case Binary: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                    break;
                                }
                                case Euclidean: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0 / distances[j].distance;
                                    break;
                                }
                                case Modified: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount)) * (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount));
                                    break;
                                }
                                case Gaussian: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = Math.exp(-(distances[j].distance * distances[j].distance) / (double)(NeighCount * NeighCount));
                                    break;
                                }
                                default: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                }
                            }
                        }
                        int n = permutation[i];
                        DR[n] = DR[n] + w[permutation[i]][permutation[j]];
                    }
                }
                for (i = M; i < N; ++i) {
                    for (int j = M; j < N; ++j) {
                        if (distances[j].distance == 0.0) {
                            w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                        } else {
                            switch (spatialMatrix) {
                                case Binary: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                    break;
                                }
                                case Euclidean: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0 / distances[j].distance;
                                    break;
                                }
                                case Modified: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount)) * (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount));
                                    break;
                                }
                                case Gaussian: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = Math.exp(-(distances[j].distance * distances[j].distance) / (double)(NeighCount * NeighCount));
                                    break;
                                }
                                default: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                }
                            }
                        }
                        int n = permutation[i];
                        WR[n] = WR[n] + w[permutation[i]][permutation[j]] / Math.sqrt(DR[permutation[j]]);
                    }
                    int n = k;
                    ikkR[n] = ikkR[n] + WR[permutation[i]] / Math.sqrt(DR[permutation[i]]);
                }
            }
            avgikR += ikkR[k];
        }
        double IR = avgikR /= (double)schema.getNbTargetAttributes();
        double I = (IL + IR * (double)(N - M)) / (double)this.m_data.getNbRows();
        double scaledI = 1.0 + I;
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return scaledI;
    }

    @Override
    public double calcCwithNeighbourstotal(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_data.getSchema();
        int M = 0;
        int N = this.m_data.getNbRows();
        if (this.splitIndex > 0) {
            N = this.splitIndex;
        } else {
            M = -this.splitIndex;
        }
        double[] upsum = new double[schema.getNbTargetAttributes()];
        double[] downsum = new double[schema.getNbTargetAttributes()];
        double[] means = new double[schema.getNbTargetAttributes()];
        double[] ikk = new double[schema.getNbTargetAttributes()];
        int k = 0;
        while (k < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k];
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNominal(exi);
                int n = k;
                means[n] = means[n] + xi;
            }
            int n = k++;
            means[n] = means[n] / (double)(N - M);
        }
        double avgik = 0.0;
        for (int k2 = 0; k2 < schema.getNbTargetAttributes(); ++k2) {
            NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k2];
            int NeighCount = (int)schema.getSettings().getTree().getNumNeightbours();
            double W = 0.0;
            if (NeighCount > 0) {
                double[][] w = new double[N][N];
                for (int i = M; i < N; ++i) {
                    Distance[] distances = new Distance[NeighCount];
                    DataTuple exi = this.m_data.getTuple(permutation[i]);
                    NumericAttrType xt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
                    NumericAttrType yt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[1];
                    double ti = type.getNumeric(exi);
                    double xi = ((ClusAttrType)xt).getNumeric(exi);
                    double yi = ((ClusAttrType)yt).getNumeric(exi);
                    double biggestd = Double.POSITIVE_INFINITY;
                    int biggestindex = Integer.MAX_VALUE;
                    for (int j = M; j < N; ++j) {
                        DataTuple exj = this.m_data.getTuple(permutation[j]);
                        double tj = type.getNumeric(exj);
                        double xj = ((ClusAttrType)xt).getNumeric(exj);
                        double yj = ((ClusAttrType)yt).getNumeric(exj);
                        double d = Math.sqrt((xi - xj) * (xi - xj) + (yi - yj) * (yi - yj));
                        if (N - M < NeighCount) {
                            distances[j] = new Distance(permutation[j].intValue(), tj, d);
                            continue;
                        }
                        if (j < NeighCount) {
                            distances[j] = new Distance(permutation[j].intValue(), tj, d);
                            continue;
                        }
                        biggestd = distances[0].distance;
                        biggestindex = 0;
                        for (int a = 1; a < NeighCount; ++a) {
                            if (!(distances[a].distance > biggestd)) continue;
                            biggestd = distances[a].distance;
                            biggestindex = a;
                        }
                        if (!(d < biggestd)) continue;
                        distances[biggestindex].index = permutation[j].intValue();
                        distances[biggestindex].target = tj;
                        distances[biggestindex].distance = d;
                    }
                    SettingsTree.SpatialMatrixType spatialMatrix = schema.getSettings().getTree().getSpatialMatrix();
                    int NN2 = N - M < NeighCount ? N - M : M + NeighCount;
                    for (int j = M; j < NN2; ++j) {
                        if (distances[j].distance == 0.0) {
                            w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                        } else {
                            switch (spatialMatrix) {
                                case Binary: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                    break;
                                }
                                case Euclidean: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0 / distances[j].distance;
                                    break;
                                }
                                case Modified: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount)) * (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount));
                                    break;
                                }
                                case Gaussian: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = Math.exp(-(distances[j].distance * distances[j].distance) / (double)(NeighCount * NeighCount));
                                    break;
                                }
                                default: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                }
                            }
                        }
                        int n = k2;
                        upsum[n] = upsum[n] + w[permutation[i]][permutation[j]] * (ti - distances[j].target) * (ti - distances[j].target);
                        W += w[permutation[i]][permutation[j]];
                    }
                    int n = k2;
                    downsum[n] = downsum[n] + (ti - means[k2]) * (ti - means[k2]);
                }
            }
            int n = k2;
            downsum[n] = downsum[n] / ((double)(N - M - 1) + 0.0);
            if (downsum[k2] != 0.0 && upsum[k2] != 0.0) {
                ikk[k2] = upsum[k2] / (2.0 * W * downsum[k2]);
                avgik += ikk[k2];
                continue;
            }
            avgik = 1.0;
        }
        double IL = (avgik /= (double)schema.getNbTargetAttributes()) * (double)(N - M);
        N = this.m_data.getNbRows();
        M = this.splitIndex;
        double[] upsumR = new double[schema.getNbTargetAttributes()];
        double[] downsumR = new double[schema.getNbTargetAttributes()];
        double[] meansR = new double[schema.getNbTargetAttributes()];
        double[] ikkR = new double[schema.getNbTargetAttributes()];
        int k3 = 0;
        while (k3 < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k3];
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNominal(exi);
                int n = k3;
                meansR[n] = meansR[n] + xi;
            }
            int n = k3++;
            meansR[n] = meansR[n] / (double)(N - M);
        }
        double avgikR = 0.0;
        for (int k4 = 0; k4 < schema.getNbTargetAttributes(); ++k4) {
            NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k4];
            int NeighCount = (int)schema.getSettings().getTree().getNumNeightbours();
            double WR = 0.0;
            if (NeighCount > 0) {
                double[][] w = new double[N][N];
                for (int i = M; i < N; ++i) {
                    Distance[] distances = new Distance[NeighCount];
                    DataTuple exi = this.m_data.getTuple(permutation[i]);
                    NumericAttrType xt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
                    NumericAttrType yt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[1];
                    double ti = type.getNumeric(exi);
                    double xi = ((ClusAttrType)xt).getNumeric(exi);
                    double yi = ((ClusAttrType)yt).getNumeric(exi);
                    int a = 0;
                    double biggestd = Double.POSITIVE_INFINITY;
                    int biggestindex = Integer.MAX_VALUE;
                    for (int j = M; j < N; ++j) {
                        DataTuple exj = this.m_data.getTuple(permutation[j]);
                        double tj = type.getNumeric(exj);
                        double xj = ((ClusAttrType)xt).getNumeric(exj);
                        double yj = ((ClusAttrType)yt).getNumeric(exj);
                        double d = Math.sqrt((xi - xj) * (xi - xj) + (yi - yj) * (yi - yj));
                        if (N - M < NeighCount) {
                            distances[a] = new Distance(permutation[j].intValue(), tj, d);
                            ++a;
                            continue;
                        }
                        if (a < NeighCount) {
                            distances[a] = new Distance(permutation[j].intValue(), tj, d);
                            ++a;
                            continue;
                        }
                        biggestd = distances[0].distance;
                        biggestindex = 0;
                        for (a = 1; a < NeighCount; ++a) {
                            if (!(distances[a].distance > biggestd)) continue;
                            biggestd = distances[a].distance;
                            biggestindex = a;
                        }
                        if (!(d < biggestd)) continue;
                        distances[biggestindex].index = permutation[j].intValue();
                        distances[biggestindex].target = tj;
                        distances[biggestindex].distance = d;
                    }
                    SettingsTree.SpatialMatrixType spatialMatrix = schema.getSettings().getTree().getSpatialMatrix();
                    for (int j = 0; distances.length > j && distances[j] != null && j < NeighCount; ++j) {
                        if (distances[j].distance == 0.0) {
                            w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                        } else {
                            switch (spatialMatrix) {
                                case Binary: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                    break;
                                }
                                case Euclidean: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0 / distances[j].distance;
                                    break;
                                }
                                case Modified: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount)) * (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount));
                                    break;
                                }
                                case Gaussian: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = Math.exp(-(distances[j].distance * distances[j].distance) / (double)(NeighCount * NeighCount));
                                    break;
                                }
                                default: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                }
                            }
                        }
                        int n = k4;
                        upsumR[n] = upsumR[n] + w[permutation[i]][permutation[j]] * (ti - distances[j].target) * (ti - distances[j].target);
                        WR += w[permutation[i]][permutation[j]];
                    }
                    int n = k4;
                    downsumR[n] = downsumR[n] + (ti - meansR[k4]) * (ti - meansR[k4]);
                }
            }
            int n = k4;
            downsumR[n] = downsumR[n] / ((double)(N - M - 1) + 0.0);
            if (downsumR[k4] != 0.0 && upsumR[k4] != 0.0) {
                ikkR[k4] = upsumR[k4] / (2.0 * WR * downsumR[k4]);
                avgikR += ikkR[k4];
                continue;
            }
            avgikR = 1.0;
        }
        double IR = avgikR /= (double)schema.getNbTargetAttributes();
        double I = 2.0 - (IL + IR * (double)(N - M)) / (double)this.m_data.getNbRows();
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return I;
    }

    @Override
    public double calcIwithNeighbourstotal(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_data.getSchema();
        int M = 0;
        int N = this.m_data.getNbRows();
        if (this.splitIndex > 0) {
            N = this.splitIndex;
        } else {
            M = -this.splitIndex;
        }
        double[] upsum = new double[schema.getNbTargetAttributes()];
        double[] downsum = new double[schema.getNbTargetAttributes()];
        double[] means = new double[schema.getNbTargetAttributes()];
        double[] ikk = new double[schema.getNbTargetAttributes()];
        int k = 0;
        while (k < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k];
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNominal(exi);
                int n = k;
                means[n] = means[n] + xi;
            }
            int n = k++;
            means[n] = means[n] / (double)(N - M);
        }
        double avgik = 0.0;
        for (int k2 = 0; k2 < schema.getNbTargetAttributes(); ++k2) {
            NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k2];
            int NeighCount = (int)schema.getSettings().getTree().getNumNeightbours();
            double W = 0.0;
            if (NeighCount > 0) {
                double[][] w = new double[N][N];
                for (int i = M; i < N; ++i) {
                    Distance[] distances = new Distance[NeighCount];
                    DataTuple exi = this.m_data.getTuple(permutation[i]);
                    NumericAttrType xt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
                    NumericAttrType yt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[1];
                    double ti = type.getNumeric(exi);
                    double xi = ((ClusAttrType)xt).getNumeric(exi);
                    double yi = ((ClusAttrType)yt).getNumeric(exi);
                    double biggestd = Double.POSITIVE_INFINITY;
                    int biggestindex = Integer.MAX_VALUE;
                    for (int j = M; j < N; ++j) {
                        DataTuple exj = this.m_data.getTuple(permutation[j]);
                        double tj = type.getNumeric(exj);
                        double xj = ((ClusAttrType)xt).getNumeric(exj);
                        double yj = ((ClusAttrType)yt).getNumeric(exj);
                        double d = Math.sqrt((xi - xj) * (xi - xj) + (yi - yj) * (yi - yj));
                        if (N - M < NeighCount) {
                            distances[j] = new Distance(permutation[j].intValue(), tj, d);
                            continue;
                        }
                        if (permutation[j] < NeighCount) {
                            distances[j] = new Distance(permutation[j].intValue(), tj, d);
                            continue;
                        }
                        biggestd = distances[0].distance;
                        biggestindex = 0;
                        for (int a = 1; a < NeighCount; ++a) {
                            if (!(distances[a].distance > biggestd)) continue;
                            biggestd = distances[a].distance;
                            biggestindex = a;
                        }
                        if (!(d < biggestd)) continue;
                        distances[biggestindex].index = permutation[j].intValue();
                        distances[biggestindex].target = tj;
                        distances[biggestindex].distance = d;
                    }
                    SettingsTree.SpatialMatrixType spatialMatrix = schema.getSettings().getTree().getSpatialMatrix();
                    int NN2 = N - M < NeighCount ? N - M : M + NeighCount;
                    for (int j = M; j < NN2; ++j) {
                        if (distances[j].distance == 0.0) {
                            w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                        } else {
                            switch (spatialMatrix) {
                                case Binary: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                    break;
                                }
                                case Euclidean: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0 / distances[j].distance;
                                    break;
                                }
                                case Modified: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount)) * (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount));
                                    break;
                                }
                                case Gaussian: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = Math.exp(-(distances[j].distance * distances[j].distance) / (double)(NeighCount * NeighCount));
                                    break;
                                }
                                default: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                }
                            }
                        }
                        int n = k2;
                        upsum[n] = upsum[n] + w[permutation[i]][permutation[j]] * (ti - means[k2]) * (distances[j].target - means[k2]);
                        W += w[permutation[i]][permutation[j]];
                    }
                    int n = k2;
                    downsum[n] = downsum[n] + (ti - means[k2]) * (ti - means[k2]);
                }
            }
            int n = k2;
            downsum[n] = downsum[n] / ((double)(N - M) + 0.0);
            if (downsum[k2] != 0.0 && upsum[k2] != 0.0) {
                ikk[k2] = upsum[k2] / (W * downsum[k2]);
                avgik += ikk[k2];
                continue;
            }
            avgik = 1.0;
        }
        double IL = (avgik /= (double)schema.getNbTargetAttributes()) * (double)(N - M);
        N = this.m_data.getNbRows();
        M = this.splitIndex;
        double[] upsumR = new double[schema.getNbTargetAttributes()];
        double[] downsumR = new double[schema.getNbTargetAttributes()];
        double[] meansR = new double[schema.getNbTargetAttributes()];
        double[] ikkR = new double[schema.getNbTargetAttributes()];
        int k3 = 0;
        while (k3 < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k3];
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNominal(exi);
                int n = k3;
                meansR[n] = meansR[n] + xi;
            }
            int n = k3++;
            meansR[n] = meansR[n] / (double)(N - M);
        }
        double avgikR = 0.0;
        for (int k4 = 0; k4 < schema.getNbTargetAttributes(); ++k4) {
            NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k4];
            int NeighCount = (int)schema.getSettings().getTree().getNumNeightbours();
            double WR = 0.0;
            if (NeighCount > 0) {
                double[][] w = new double[N][N];
                for (int i = M; i < N; ++i) {
                    Distance[] distances = new Distance[NeighCount];
                    DataTuple exi = this.m_data.getTuple(permutation[i]);
                    NumericAttrType xt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
                    NumericAttrType yt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[1];
                    double ti = type.getNumeric(exi);
                    double xi = ((ClusAttrType)xt).getNumeric(exi);
                    double yi = ((ClusAttrType)yt).getNumeric(exi);
                    int a = 0;
                    double biggestd = Double.POSITIVE_INFINITY;
                    int biggestindex = Integer.MAX_VALUE;
                    for (int j = M; j < N; ++j) {
                        DataTuple exj = this.m_data.getTuple(permutation[j]);
                        double tj = type.getNumeric(exj);
                        double xj = ((ClusAttrType)xt).getNumeric(exj);
                        double yj = ((ClusAttrType)yt).getNumeric(exj);
                        double d = Math.sqrt((xi - xj) * (xi - xj) + (yi - yj) * (yi - yj));
                        if (N - M < NeighCount) {
                            distances[a] = new Distance(permutation[j].intValue(), tj, d);
                            ++a;
                            continue;
                        }
                        if (a < NeighCount) {
                            distances[a] = new Distance(permutation[j].intValue(), tj, d);
                            ++a;
                            continue;
                        }
                        biggestd = distances[0].distance;
                        biggestindex = 0;
                        for (a = 1; a < NeighCount; ++a) {
                            if (!(distances[a].distance > biggestd)) continue;
                            biggestd = distances[a].distance;
                            biggestindex = a;
                        }
                        if (!(d < biggestd)) continue;
                        distances[biggestindex].index = permutation[j].intValue();
                        distances[biggestindex].target = tj;
                        distances[biggestindex].distance = d;
                    }
                    SettingsTree.SpatialMatrixType spatialMatrix = schema.getSettings().getTree().getSpatialMatrix();
                    for (int j = 0; distances.length > j && distances[j] != null && j < NeighCount; ++j) {
                        if (distances[j].distance == 0.0) {
                            w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                        } else {
                            switch (spatialMatrix) {
                                case Binary: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                    break;
                                }
                                case Euclidean: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0 / distances[j].distance;
                                    break;
                                }
                                case Modified: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount)) * (1.0 - distances[j].distance * distances[j].distance / (double)(NeighCount * NeighCount));
                                    break;
                                }
                                case Gaussian: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = Math.exp(-(distances[j].distance * distances[j].distance) / (double)(NeighCount * NeighCount));
                                    break;
                                }
                                default: {
                                    w[permutation[i].intValue()][permutation[j].intValue()] = 1.0;
                                }
                            }
                        }
                        int n = k4;
                        upsumR[n] = upsumR[n] + w[permutation[i]][permutation[j]] * (ti - meansR[k4]) * (distances[j].target - meansR[k4]);
                        WR += w[permutation[i]][permutation[j]];
                    }
                    int n = k4;
                    downsumR[n] = downsumR[n] + (ti - meansR[k4]) * (ti - meansR[k4]);
                }
            }
            int n = k4;
            downsumR[n] = downsumR[n] / ((double)(N - M) + 0.0);
            if (downsumR[k4] != 0.0 && upsumR[k4] != 0.0) {
                ikkR[k4] = upsumR[k4] / (WR * downsumR[k4]);
                avgikR += ikkR[k4];
                continue;
            }
            avgikR = 1.0;
        }
        double IR = avgikR /= (double)schema.getNbTargetAttributes();
        double I = (IL + IR * (double)(N - M)) / (double)this.m_data.getNbRows();
        double scaledI = 1.0 + I;
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return scaledI;
    }

    @Override
    public double calcEquvalentIwithNeighbourstotal(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_data.getSchema();
        double avgik = 0.0;
        double I = avgik /= (double)schema.getNbTargetAttributes();
        if (I > 1.0) {
            I = 1.0;
        }
        if (I < -1.0) {
            I = -1.0;
        }
        double scaledI = 1.0 - I;
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return scaledI;
    }

    @Override
    public double calcEquvalentGDistance(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_data.getSchema();
        double[] ikk = new double[schema.getNbTargetAttributes()];
        double[] ikkR = new double[schema.getNbTargetAttributes()];
        double[] num = new double[schema.getNbTargetAttributes()];
        double[] den = new double[schema.getNbTargetAttributes()];
        double[] numR = new double[schema.getNbTargetAttributes()];
        double[] denR = new double[schema.getNbTargetAttributes()];
        double[] means = new double[schema.getNbTargetAttributes()];
        double[] meansR = new double[schema.getNbTargetAttributes()];
        double avgik = 0.0;
        double avgikR = 0.0;
        int M = 0;
        int N = 0;
        int NR = this.m_data.getNbRows();
        double I = 0.0;
        int vkupenBrojElementiVoOvojSplit = N - M;
        int vkupenBrojElementiVoCelataSuma = NR;
        for (int k = 0; k < schema.getNbTargetAttributes(); ++k) {
            long xxi;
            double xi;
            DataTuple exi;
            String indexMap;
            Double temp;
            long indexJ;
            long yyi;
            double xj;
            DataTuple exj;
            DataTuple exi2;
            int i;
            double w;
            NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k];
            NumericAttrType xt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
            M = this.prevIndex;
            N = this.splitIndex;
            if (INITIALIZEPARTIALSUM) {
                INITIALIZEPARTIALSUM = false;
                for (int i2 = M = 0; i2 < NR; ++i2) {
                    DataTuple exi3 = this.m_data.getTuple(permutation[i2]);
                    double xi2 = ((ClusAttrType)type).getNominal(exi3);
                    long xxi2 = (long)((ClusAttrType)xt).getNumeric(exi3);
                    int n = k;
                    meansR[n] = meansR[n] + xi2;
                    int n2 = k;
                    this.previousSumX2R[n2] = this.previousSumX2R[n2] + xi2 * xi2;
                    int n3 = k;
                    this.previousSumXR[n3] = this.previousSumXR[n3] + xi2;
                    for (int j = M; j < NR; ++j) {
                        DataTuple exj2 = this.m_data.getTuple(permutation[j]);
                        double xj2 = ((ClusAttrType)type).getNominal(exj2);
                        long yyi2 = (long)((ClusAttrType)xt).getNumeric(exj2);
                        w = 0.0;
                        long indexI = xxi2;
                        long indexJ2 = yyi2;
                        if (indexI != indexJ2) {
                            String indexMap2;
                            Double temp2;
                            if (indexI > indexJ2) {
                                indexI = yyi2;
                                indexJ2 = xxi2;
                            }
                            w = (temp2 = GISHeuristic.m_distancesS.get(indexMap2 = indexI + "#" + indexJ2)) != null ? temp2 : 0.0;
                            int n4 = k;
                            this.previousSumWR[n4] = this.previousSumWR[n4] + w;
                            int n5 = k;
                            this.previousSumWXXR[n5] = this.previousSumWXXR[n5] + w * (xi2 - xj2) * (xi2 - xj2);
                            continue;
                        }
                        int n6 = k;
                        this.previousSumWR[n6] = this.previousSumWR[n6] + 1.0;
                        int n7 = k;
                        this.previousSumWXXR[n7] = this.previousSumWXXR[n7] + (xi2 - xj2) * (xi2 - xj2);
                    }
                }
            }
            boolean flagRightAllEqual = true;
            boolean flagLeftAllEqual = true;
            for (int i3 = M; i3 < N; ++i3) {
                DataTuple exi4 = this.m_data.getTuple(permutation[i3]);
                double xi3 = ((ClusAttrType)type).getNominal(exi4);
                int n = k;
                means[n] = means[n] + xi3;
                int n8 = k;
                this.previousSumX2[n8] = this.previousSumX2[n8] + xi3 * xi3;
                int n9 = k;
                this.previousSumX[n9] = this.previousSumX[n9] + xi3;
                int n10 = k;
                meansR[n10] = meansR[n10] - xi3;
                int n11 = k;
                this.previousSumX2R[n11] = this.previousSumX2R[n11] - xi3 * xi3;
                int n12 = k;
                this.previousSumXR[n12] = this.previousSumXR[n12] - xi3;
            }
            flagLeftAllEqual = true;
            double oldX = ((ClusAttrType)type).getNominal(this.m_data.getTuple(0));
            for (i = 1; i < N; ++i) {
                exi2 = this.m_data.getTuple(permutation[i]);
                double xi4 = ((ClusAttrType)type).getNominal(exi2);
                if (xi4 == oldX) continue;
                flagLeftAllEqual = false;
                break;
            }
            for (i = 0; i < M; ++i) {
                exi2 = this.m_data.getTuple(permutation[i]);
                double xi5 = ((ClusAttrType)type).getNominal(exi2);
                long xxi3 = (long)((ClusAttrType)xt).getNumeric(exi2);
                for (int j = M; j < N; ++j) {
                    exj = this.m_data.getTuple(permutation[j]);
                    xj = ((ClusAttrType)type).getNominal(exj);
                    yyi = (long)((ClusAttrType)xt).getNumeric(exj);
                    double w2 = 0.0;
                    long indexI = xxi3;
                    indexJ = yyi;
                    if (indexI != indexJ) {
                        if (indexI > indexJ) {
                            indexI = yyi;
                            indexJ = xxi3;
                        }
                        w2 = (temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) != null ? temp : 0.0;
                        int n = k;
                        this.previousSumW[n] = this.previousSumW[n] + w2;
                        int n13 = k;
                        this.previousSumWXX[n13] = this.previousSumWXX[n13] + w2 * (xi5 - xj) * (xi5 - xj);
                        continue;
                    }
                    int n = k;
                    this.previousSumW[n] = this.previousSumW[n] + 1.0;
                    int n14 = k;
                    this.previousSumWXX[n14] = this.previousSumWXX[n14] + (xi5 - xj) * (xi5 - xj);
                }
            }
            for (i = M; i < N; ++i) {
                for (int j = 0; j < M; ++j) {
                    long yyi3;
                    double w3 = 0.0;
                    DataTuple exj3 = this.m_data.getTuple(permutation[j]);
                    double xj3 = ((ClusAttrType)type).getNominal(exj3);
                    exi = this.m_data.getTuple(permutation[i]);
                    xi = ((ClusAttrType)type).getNominal(exi);
                    xxi = (long)((ClusAttrType)xt).getNumeric(exi);
                    long indexI = xxi;
                    if (indexI != (indexJ = (yyi3 = (long)((ClusAttrType)xt).getNumeric(exj3)))) {
                        if (indexI > indexJ) {
                            indexI = yyi3;
                            indexJ = xxi;
                        }
                        w3 = (temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) != null ? temp : 0.0;
                        int n = k;
                        this.previousSumW[n] = this.previousSumW[n] + w3;
                        int n15 = k;
                        this.previousSumWXX[n15] = this.previousSumWXX[n15] + w3 * (xi - xj3) * (xi - xj3);
                        continue;
                    }
                    int n = k;
                    this.previousSumW[n] = this.previousSumW[n] + 1.0;
                    int n16 = k;
                    this.previousSumWXX[n16] = this.previousSumWXX[n16] + (xi - xj3) * (xi - xj3);
                }
            }
            for (i = M; i < N; ++i) {
                exi2 = this.m_data.getTuple(permutation[i]);
                double xi6 = ((ClusAttrType)type).getNominal(exi2);
                for (int j = M; j < N; ++j) {
                    long yyi4;
                    DataTuple exj4 = this.m_data.getTuple(permutation[j]);
                    double xj4 = ((ClusAttrType)type).getNominal(exj4);
                    w = 0.0;
                    xxi = (long)((ClusAttrType)xt).getNumeric(exi2);
                    long indexI = xxi;
                    if (indexI != (indexJ = (yyi4 = (long)((ClusAttrType)xt).getNumeric(exj4)))) {
                        if (indexI > indexJ) {
                            indexI = yyi4;
                            indexJ = xxi;
                        }
                        w = (temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) != null ? temp : 0.0;
                        int n = k;
                        this.previousSumW[n] = this.previousSumW[n] + w;
                        int n17 = k;
                        this.previousSumWXX[n17] = this.previousSumWXX[n17] + w * (xi6 - xj4) * (xi6 - xj4);
                        continue;
                    }
                    int n = k;
                    this.previousSumW[n] = this.previousSumW[n] + 1.0;
                    int n18 = k;
                    this.previousSumWXX[n18] = this.previousSumWXX[n18] + (xi6 - xj4) * (xi6 - xj4);
                }
            }
            flagRightAllEqual = true;
            oldX = ((ClusAttrType)type).getNominal(this.m_data.getTuple(N));
            for (i = N; i < NR; ++i) {
                exi2 = this.m_data.getTuple(permutation[i]);
                double xi7 = ((ClusAttrType)type).getNominal(exi2);
                if (oldX != xi7) {
                    flagRightAllEqual = false;
                }
                for (int j = M; j < N; ++j) {
                    long yyi5;
                    long indexI;
                    double w4 = 0.0;
                    exj = this.m_data.getTuple(permutation[j]);
                    xj = ((ClusAttrType)type).getNominal(exj);
                    if (xi7 != oldX) {
                        flagRightAllEqual = false;
                    }
                    if ((indexI = (xxi = (long)((ClusAttrType)xt).getNumeric(exi2))) != (indexJ = (yyi5 = (long)((ClusAttrType)xt).getNumeric(exj)))) {
                        if (indexI > indexJ) {
                            indexI = yyi5;
                            indexJ = xxi;
                        }
                        w4 = (temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) != null ? temp : 0.0;
                        int n = k;
                        this.previousSumWR[n] = this.previousSumWR[n] - w4;
                        int n19 = k;
                        this.previousSumWXXR[n19] = this.previousSumWXXR[n19] - w4 * (xi7 - xj) * (xi7 - xj);
                        continue;
                    }
                    int n = k;
                    this.previousSumWR[n] = this.previousSumWR[n] - 1.0;
                    int n20 = k;
                    this.previousSumWXXR[n20] = this.previousSumWXXR[n20] - (xi7 - xj) * (xi7 - xj);
                }
            }
            for (i = M; i < N; ++i) {
                for (int j = N; j < NR; ++j) {
                    long yyi6;
                    double w5 = 0.0;
                    DataTuple exj5 = this.m_data.getTuple(permutation[j]);
                    double xj5 = ((ClusAttrType)type).getNominal(exj5);
                    exi = this.m_data.getTuple(permutation[i]);
                    xi = ((ClusAttrType)type).getNominal(exi);
                    xxi = (long)((ClusAttrType)xt).getNumeric(exi);
                    long indexI = xxi;
                    if (indexI != (indexJ = (yyi6 = (long)((ClusAttrType)xt).getNumeric(exj5)))) {
                        if (indexI > indexJ) {
                            indexI = yyi6;
                            indexJ = xxi;
                        }
                        w5 = (temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) != null ? temp : 0.0;
                        int n = k;
                        this.previousSumWR[n] = this.previousSumWR[n] - w5;
                        int n21 = k;
                        this.previousSumWXXR[n21] = this.previousSumWXXR[n21] - w5 * (xi - xj5) * (xi - xj5);
                        continue;
                    }
                    int n = k;
                    this.previousSumWR[n] = this.previousSumWR[n] - 1.0;
                    int n22 = k;
                    this.previousSumWXXR[n22] = this.previousSumWXXR[n22] - (xi - xj5) * (xi - xj5);
                }
            }
            for (i = M; i < N; ++i) {
                exi2 = this.m_data.getTuple(permutation[i]);
                double xi8 = ((ClusAttrType)type).getNominal(exi2);
                long xxi4 = (long)((ClusAttrType)xt).getNumeric(exi2);
                for (int j = M; j < N; ++j) {
                    exj = this.m_data.getTuple(permutation[j]);
                    xj = ((ClusAttrType)type).getNominal(exj);
                    yyi = (long)((ClusAttrType)xt).getNumeric(exj);
                    double w6 = 0.0;
                    long indexI = xxi4;
                    indexJ = yyi;
                    if (indexI != indexJ) {
                        if (indexI > indexJ) {
                            indexI = yyi;
                            indexJ = xxi4;
                        }
                        w6 = (temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) != null ? temp : 0.0;
                        int n = k;
                        this.previousSumWR[n] = this.previousSumWR[n] - w6;
                        int n23 = k;
                        this.previousSumWXXR[n23] = this.previousSumWXXR[n23] - w6 * (xi8 - xj) * (xi8 - xj);
                        continue;
                    }
                    int n = k;
                    this.previousSumWR[n] = this.previousSumWR[n] - 1.0;
                    int n24 = k;
                    this.previousSumWXXR[n24] = this.previousSumWXXR[n24] - (xi8 - xj) * (xi8 - xj);
                }
            }
            vkupenBrojElementiVoOvojSplit = N;
            num[k] = (double)(vkupenBrojElementiVoOvojSplit - 1) * this.previousSumWXX[k];
            den[k] = 2.0 * this.previousSumW[k] * (this.previousSumX2[k] - (double)vkupenBrojElementiVoOvojSplit * (this.previousSumX[k] / (double)vkupenBrojElementiVoOvojSplit) * (this.previousSumX[k] / (double)vkupenBrojElementiVoOvojSplit));
            ikk[k] = den[k] != 0.0 && num[k] != 0.0 && !flagLeftAllEqual ? num[k] / den[k] : 1.0;
            vkupenBrojElementiVoOvojSplit = NR - N;
            numR[k] = (double)(vkupenBrojElementiVoOvojSplit - 1) * this.previousSumWXXR[k];
            denR[k] = 2.0 * this.previousSumWR[k] * (this.previousSumX2R[k] - this.previousSumXR[k] * this.previousSumXR[k] / (double)vkupenBrojElementiVoOvojSplit);
            ikkR[k] = denR[k] != 0.0 && numR[k] != 0.0 && !flagRightAllEqual ? numR[k] / denR[k] : 1.0;
            avgikR += ikkR[k];
            avgik += ikk[k];
        }
        I = ((avgik /= (double)schema.getNbTargetAttributes()) * (double)N + (avgikR /= (double)schema.getNbTargetAttributes()) * (double)(NR - N)) / (double)vkupenBrojElementiVoCelataSuma;
        M = this.prevIndex;
        N = this.splitIndex;
        double scaledI = 2.0 - I;
        if (Double.isNaN(scaledI)) {
            throw new ClusException("err!");
        }
        return scaledI;
    }

    @Override
    public double calcEquvalentIDistance(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_data.getSchema();
        double[] ikk = new double[schema.getNbTargetAttributes()];
        double[] ikkR = new double[schema.getNbTargetAttributes()];
        double[] num = new double[schema.getNbTargetAttributes()];
        double[] den = new double[schema.getNbTargetAttributes()];
        double[] numR = new double[schema.getNbTargetAttributes()];
        double[] denR = new double[schema.getNbTargetAttributes()];
        double[] means = new double[schema.getNbTargetAttributes()];
        double[] meansR = new double[schema.getNbTargetAttributes()];
        double avgik = 0.0;
        double avgikR = 0.0;
        int M = 0;
        int N = 0;
        int NR = this.m_data.getNbRows();
        double I = 0.0;
        int vkupenBrojElementiVoOvojSplit = N - M;
        int vkupenBrojElementiVoCelataSuma = NR;
        for (int k = 0; k < schema.getNbTargetAttributes(); ++k) {
            long xxi;
            double xi;
            DataTuple exi;
            String indexMap;
            Double temp;
            long indexJ;
            long yyi;
            double xj;
            DataTuple exj;
            DataTuple exi2;
            int i;
            double w;
            NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k];
            NumericAttrType xt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
            M = this.prevIndex;
            N = this.splitIndex;
            if (INITIALIZEPARTIALSUM) {
                INITIALIZEPARTIALSUM = false;
                for (int i2 = M = 0; i2 < NR; ++i2) {
                    DataTuple exi3 = this.m_data.getTuple(permutation[i2]);
                    double xi2 = ((ClusAttrType)type).getNominal(exi3);
                    long xxi2 = (long)((ClusAttrType)xt).getNumeric(exi3);
                    int n = k;
                    meansR[n] = meansR[n] + xi2;
                    int n2 = k;
                    this.previousSumX2R[n2] = this.previousSumX2R[n2] + xi2 * xi2;
                    int n3 = k;
                    this.previousSumXR[n3] = this.previousSumXR[n3] + xi2;
                    for (int j = M; j < NR; ++j) {
                        String indexMap2;
                        Double temp2;
                        DataTuple exj2 = this.m_data.getTuple(permutation[j]);
                        double xj2 = ((ClusAttrType)type).getNominal(exj2);
                        long yyi2 = (long)((ClusAttrType)xt).getNumeric(exj2);
                        w = 0.0;
                        long indexI = xxi2;
                        long indexJ2 = yyi2;
                        if (indexI > indexJ2) {
                            indexI = yyi2;
                            indexJ2 = xxi2;
                        }
                        w = (temp2 = GISHeuristic.m_distancesS.get(indexMap2 = indexI + "#" + indexJ2)) != null ? temp2 : 0.0;
                        int n4 = k;
                        this.previousSumWR[n4] = this.previousSumWR[n4] + w;
                        int n5 = k;
                        this.previousSumWXXR[n5] = this.previousSumWXXR[n5] + w * xi2 * xj2;
                        int n6 = k;
                        this.previousSumWXR[n6] = this.previousSumWXR[n6] + w * xj2;
                    }
                }
            }
            boolean flagRightAllEqual = true;
            boolean flagLeftAllEqual = true;
            for (int i3 = M; i3 < N; ++i3) {
                DataTuple exi4 = this.m_data.getTuple(permutation[i3]);
                double xi3 = ((ClusAttrType)type).getNominal(exi4);
                int n = k;
                means[n] = means[n] + xi3;
                int n7 = k;
                this.previousSumX2[n7] = this.previousSumX2[n7] + xi3 * xi3;
                int n8 = k;
                this.previousSumX[n8] = this.previousSumX[n8] + xi3;
                int n9 = k;
                meansR[n9] = meansR[n9] - xi3;
                int n10 = k;
                this.previousSumX2R[n10] = this.previousSumX2R[n10] - xi3 * xi3;
                int n11 = k;
                this.previousSumXR[n11] = this.previousSumXR[n11] - xi3;
            }
            flagLeftAllEqual = true;
            double oldX = type.getNumeric(this.m_data.getTuple(0));
            for (i = 1; i < N; ++i) {
                exi2 = this.m_data.getTuple(permutation[i]);
                double xi4 = ((ClusAttrType)type).getNominal(exi2);
                if (xi4 == oldX) continue;
                flagLeftAllEqual = false;
                break;
            }
            for (i = 0; i < M; ++i) {
                exi2 = this.m_data.getTuple(permutation[i]);
                double xi5 = ((ClusAttrType)type).getNominal(exi2);
                long xxi3 = (long)((ClusAttrType)xt).getNumeric(exi2);
                for (int j = M; j < N; ++j) {
                    exj = this.m_data.getTuple(permutation[j]);
                    xj = ((ClusAttrType)type).getNominal(exj);
                    yyi = (long)((ClusAttrType)xt).getNumeric(exj);
                    double w2 = 0.0;
                    long indexI = xxi3;
                    indexJ = yyi;
                    if (indexI > indexJ) {
                        indexI = yyi;
                        indexJ = xxi3;
                    }
                    w2 = (temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) != null ? temp : 0.0;
                    int n = k;
                    this.previousSumW[n] = this.previousSumW[n] + w2;
                    int n12 = k;
                    this.previousSumWXX[n12] = this.previousSumWXX[n12] + w2 * xi5 * xj;
                    int n13 = k;
                    this.previousSumWX[n13] = this.previousSumWX[n13] + w2 * xj;
                }
            }
            for (i = M; i < N; ++i) {
                for (int j = 0; j < M; ++j) {
                    long yyi3;
                    double w3 = 0.0;
                    DataTuple exj3 = this.m_data.getTuple(permutation[j]);
                    double xj3 = ((ClusAttrType)type).getNominal(exj3);
                    exi = this.m_data.getTuple(permutation[i]);
                    xi = ((ClusAttrType)type).getNominal(exi);
                    xxi = (long)((ClusAttrType)xt).getNumeric(exi);
                    long indexI = xxi;
                    if (indexI > (indexJ = (yyi3 = (long)((ClusAttrType)xt).getNumeric(exj3)))) {
                        indexI = yyi3;
                        indexJ = xxi;
                    }
                    w3 = (temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) != null ? temp : 0.0;
                    int n = k;
                    this.previousSumW[n] = this.previousSumW[n] + w3;
                    int n14 = k;
                    this.previousSumWX[n14] = this.previousSumWX[n14] + w3 * xj3;
                    int n15 = k;
                    this.previousSumWXX[n15] = this.previousSumWXX[n15] + w3 * xi * xj3;
                }
            }
            for (i = M; i < N; ++i) {
                exi2 = this.m_data.getTuple(permutation[i]);
                double xi6 = ((ClusAttrType)type).getNominal(exi2);
                for (int j = M; j < N; ++j) {
                    long yyi4;
                    DataTuple exj4 = this.m_data.getTuple(permutation[j]);
                    double xj4 = ((ClusAttrType)type).getNominal(exj4);
                    w = 0.0;
                    xxi = (long)((ClusAttrType)xt).getNumeric(exi2);
                    long indexI = xxi;
                    if (indexI > (indexJ = (yyi4 = (long)((ClusAttrType)xt).getNumeric(exj4)))) {
                        indexI = yyi4;
                        indexJ = xxi;
                    }
                    w = (temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) != null ? temp : 0.0;
                    int n = k;
                    this.previousSumW[n] = this.previousSumW[n] + w;
                    int n16 = k;
                    this.previousSumWX[n16] = this.previousSumWX[n16] + w * xj4;
                    int n17 = k;
                    this.previousSumWXX[n17] = this.previousSumWXX[n17] + w * xi6 * xj4;
                }
            }
            flagRightAllEqual = true;
            oldX = type.getNumeric(this.m_data.getTuple(N));
            for (i = N; i < NR; ++i) {
                exi2 = this.m_data.getTuple(permutation[i]);
                double xi7 = ((ClusAttrType)type).getNominal(exi2);
                if (oldX != xi7) {
                    flagRightAllEqual = false;
                }
                for (int j = M; j < N; ++j) {
                    long yyi5;
                    long indexI;
                    double w4 = 0.0;
                    exj = this.m_data.getTuple(permutation[j]);
                    xj = ((ClusAttrType)type).getNominal(exj);
                    if (xi7 != oldX) {
                        flagRightAllEqual = false;
                    }
                    if ((indexI = (xxi = (long)((ClusAttrType)xt).getNumeric(exi2))) > (indexJ = (yyi5 = (long)((ClusAttrType)xt).getNumeric(exj)))) {
                        indexI = yyi5;
                        indexJ = xxi;
                    }
                    w4 = (temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) != null ? temp : 0.0;
                    int n = k;
                    this.previousSumWR[n] = this.previousSumWR[n] - w4;
                    int n18 = k;
                    this.previousSumWXXR[n18] = this.previousSumWXXR[n18] - w4 * xi7 * xj;
                    int n19 = k;
                    this.previousSumWXR[n19] = this.previousSumWXR[n19] - w4 * xj;
                }
            }
            for (i = M; i < N; ++i) {
                for (int j = N; j < NR; ++j) {
                    long yyi6;
                    double w5 = 0.0;
                    DataTuple exj5 = this.m_data.getTuple(permutation[j]);
                    double xj5 = ((ClusAttrType)type).getNominal(exj5);
                    exi = this.m_data.getTuple(permutation[i]);
                    xi = ((ClusAttrType)type).getNominal(exi);
                    xxi = (long)((ClusAttrType)xt).getNumeric(exi);
                    long indexI = xxi;
                    if (indexI > (indexJ = (yyi6 = (long)((ClusAttrType)xt).getNumeric(exj5)))) {
                        indexI = yyi6;
                        indexJ = xxi;
                    }
                    w5 = (temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) != null ? temp : 0.0;
                    int n = k;
                    this.previousSumWR[n] = this.previousSumWR[n] - w5;
                    int n20 = k;
                    this.previousSumWXXR[n20] = this.previousSumWXXR[n20] - w5 * xi * xj5;
                    int n21 = k;
                    this.previousSumWXR[n21] = this.previousSumWXR[n21] - w5 * xj5;
                }
            }
            for (i = M; i < N; ++i) {
                exi2 = this.m_data.getTuple(permutation[i]);
                double xi8 = ((ClusAttrType)type).getNominal(exi2);
                long xxi4 = (long)((ClusAttrType)xt).getNumeric(exi2);
                for (int j = M; j < N; ++j) {
                    exj = this.m_data.getTuple(permutation[j]);
                    xj = ((ClusAttrType)type).getNominal(exj);
                    yyi = (long)((ClusAttrType)xt).getNumeric(exj);
                    double w6 = 0.0;
                    long indexI = xxi4;
                    indexJ = yyi;
                    if (indexI > indexJ) {
                        indexI = yyi;
                        indexJ = xxi4;
                    }
                    w6 = (temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) != null ? temp : 0.0;
                    int n = k;
                    this.previousSumWR[n] = this.previousSumWR[n] - w6;
                    int n22 = k;
                    this.previousSumWXXR[n22] = this.previousSumWXXR[n22] - w6 * xi8 * xj;
                    int n23 = k;
                    this.previousSumWXR[n23] = this.previousSumWXR[n23] - w6 * xj;
                }
            }
            vkupenBrojElementiVoOvojSplit = N;
            num[k] = (double)vkupenBrojElementiVoOvojSplit * (this.previousSumWXX[k] - 2.0 * (this.previousSumX[k] / (double)vkupenBrojElementiVoOvojSplit) * this.previousSumWX[k] + this.previousSumX[k] / (double)vkupenBrojElementiVoOvojSplit * (this.previousSumX[k] / (double)vkupenBrojElementiVoOvojSplit) * this.previousSumW[k]);
            den[k] = this.previousSumW[k] * (this.previousSumX2[k] - (double)vkupenBrojElementiVoOvojSplit * (this.previousSumX[k] / (double)vkupenBrojElementiVoOvojSplit) * (this.previousSumX[k] / (double)vkupenBrojElementiVoOvojSplit));
            ikk[k] = den[k] != 0.0 && num[k] != 0.0 && !flagLeftAllEqual ? num[k] / den[k] : 1.0;
            vkupenBrojElementiVoOvojSplit = NR - N;
            numR[k] = (double)vkupenBrojElementiVoOvojSplit * (this.previousSumWXXR[k] - 2.0 * this.previousSumWXR[k] * (this.previousSumXR[k] / (double)vkupenBrojElementiVoOvojSplit) + this.previousSumXR[k] / (double)vkupenBrojElementiVoOvojSplit * (this.previousSumXR[k] / (double)vkupenBrojElementiVoOvojSplit) * this.previousSumWR[k]);
            denR[k] = this.previousSumWR[k] * (this.previousSumX2R[k] - this.previousSumXR[k] * this.previousSumXR[k] / (double)vkupenBrojElementiVoOvojSplit);
            ikkR[k] = denR[k] != 0.0 && numR[k] != 0.0 && !flagRightAllEqual ? numR[k] / denR[k] : 1.0;
            avgikR += ikkR[k];
            avgik += ikk[k];
        }
        I = ((avgik /= (double)schema.getNbTargetAttributes()) * (double)N + (avgikR /= (double)schema.getNbTargetAttributes()) * (double)(NR - N)) / (double)vkupenBrojElementiVoCelataSuma;
        M = this.prevIndex;
        N = this.splitIndex;
        double scaledI = 1.0 + I;
        if (Double.isNaN(scaledI)) {
            throw new ClusException("err!");
        }
        return scaledI;
    }

    @Override
    public double calcEquvalentGtotal(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_data.getSchema();
        double[] ikk = new double[schema.getNbTargetAttributes()];
        double[] ikkR = new double[schema.getNbTargetAttributes()];
        double[] num = new double[schema.getNbTargetAttributes()];
        double[] den = new double[schema.getNbTargetAttributes()];
        double[] numR = new double[schema.getNbTargetAttributes()];
        double[] denR = new double[schema.getNbTargetAttributes()];
        double[] means = new double[schema.getNbTargetAttributes()];
        double[] meansR = new double[schema.getNbTargetAttributes()];
        double avgik = 0.0;
        double avgikR = 0.0;
        int M = 0;
        int N = 0;
        int NR = this.m_data.getNbRows();
        double I = 0.0;
        int vkupenBrojElementiVoOvojSplit = N - M;
        int vkupenBrojElementiVoCelataSuma = NR;
        for (int k = 0; k < schema.getNbTargetAttributes(); ++k) {
            Double temp;
            long indexMap;
            DataTuple exi;
            double xj;
            Double temp2;
            DataTuple exj;
            double w;
            double xi;
            DataTuple exi2;
            int i;
            NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k];
            M = this.prevIndex;
            N = this.splitIndex;
            if (INITIALIZEPARTIALSUM) {
                INITIALIZEPARTIALSUM = false;
                for (int i2 = M = 0; i2 < NR; ++i2) {
                    DataTuple exi3 = this.m_data.getTuple(permutation[i2]);
                    double xi2 = ((ClusAttrType)type).getNominal(exi3);
                    int n = k;
                    meansR[n] = meansR[n] + xi2;
                    int n2 = k;
                    this.previousSumX2R[n2] = this.previousSumX2R[n2] + xi2 * xi2;
                    int n3 = k;
                    this.previousSumXR[n3] = this.previousSumXR[n3] + xi2;
                    for (int j = M; j < NR; ++j) {
                        Double temp3;
                        DataTuple exj2 = this.m_data.getTuple(permutation[j]);
                        double xj2 = ((ClusAttrType)type).getNominal(exj2);
                        long indexMap2 = permutation[i2] * NR + permutation[j];
                        double w2 = 0.0;
                        if (permutation[i2] > permutation[j]) {
                            indexMap2 = permutation[j] * NR + permutation[i2];
                        }
                        w2 = (temp3 = GISHeuristic.m_distances.get(indexMap2)) != null ? temp3 : 0.0;
                        int n4 = k;
                        this.previousSumWR[n4] = this.previousSumWR[n4] + w2;
                        int n5 = k;
                        this.previousSumWXXR[n5] = this.previousSumWXXR[n5] + w2 * (xi2 - xj2) * (xi2 - xj2);
                    }
                }
            }
            boolean flagRightAllEqual = true;
            boolean flagLeftAllEqual = true;
            for (int i3 = M; i3 < N; ++i3) {
                DataTuple exi4 = this.m_data.getTuple(permutation[i3]);
                double xi3 = ((ClusAttrType)type).getNominal(exi4);
                int n = k;
                means[n] = means[n] + xi3;
                int n6 = k;
                this.previousSumX2[n6] = this.previousSumX2[n6] + xi3 * xi3;
                int n7 = k;
                this.previousSumX[n7] = this.previousSumX[n7] + xi3;
                int n8 = k;
                meansR[n8] = meansR[n8] - xi3;
                int n9 = k;
                this.previousSumX2R[n9] = this.previousSumX2R[n9] - xi3 * xi3;
                int n10 = k;
                this.previousSumXR[n10] = this.previousSumXR[n10] - xi3;
            }
            flagLeftAllEqual = true;
            double oldX = type.getNumeric(this.m_data.getTuple(0));
            for (i = 1; i < N; ++i) {
                exi2 = this.m_data.getTuple(permutation[i]);
                xi = ((ClusAttrType)type).getNominal(exi2);
                if (xi == oldX) continue;
                flagLeftAllEqual = false;
                break;
            }
            for (i = 0; i < M; ++i) {
                exi2 = this.m_data.getTuple(permutation[i]);
                xi = ((ClusAttrType)type).getNominal(exi2);
                for (int j = M; j < N; ++j) {
                    long indexMap3 = permutation[i] * NR + permutation[j];
                    w = 0.0;
                    exj = this.m_data.getTuple(permutation[j]);
                    double xj3 = ((ClusAttrType)type).getNominal(exj);
                    if (permutation[i] > permutation[j]) {
                        indexMap3 = permutation[j] * NR + permutation[i];
                    }
                    w = (temp2 = GISHeuristic.m_distances.get(indexMap3)) != null ? temp2 : 0.0;
                    int n = k;
                    this.previousSumW[n] = this.previousSumW[n] + w;
                    int n11 = k;
                    this.previousSumWXX[n11] = this.previousSumWXX[n11] + w * (xi - xj3) * (xi - xj3);
                }
            }
            for (i = M; i < N; ++i) {
                for (int j = 0; j < M; ++j) {
                    long indexMap4 = permutation[i] * NR + permutation[j];
                    double w3 = 0.0;
                    DataTuple exj3 = this.m_data.getTuple(permutation[j]);
                    xj = ((ClusAttrType)type).getNominal(exj3);
                    exi = this.m_data.getTuple(permutation[i]);
                    double xi4 = ((ClusAttrType)type).getNominal(exi);
                    if (permutation[i] > permutation[j]) {
                        indexMap4 = permutation[j] * NR + permutation[i];
                    }
                    w3 = (temp2 = GISHeuristic.m_distances.get(indexMap4)) != null ? temp2 : 0.0;
                    int n = k;
                    this.previousSumW[n] = this.previousSumW[n] + w3;
                    int n12 = k;
                    this.previousSumWXX[n12] = this.previousSumWXX[n12] + w3 * (xi4 - xj) * (xi4 - xj);
                }
            }
            for (i = M; i < N; ++i) {
                DataTuple exi5 = this.m_data.getTuple(permutation[i]);
                double xi5 = ((ClusAttrType)type).getNominal(exi5);
                for (int j = M; j < N; ++j) {
                    DataTuple exj4 = this.m_data.getTuple(permutation[j]);
                    double xj4 = ((ClusAttrType)type).getNominal(exj4);
                    double w4 = 0.0;
                    long indexI = permutation[i].intValue();
                    long indexJ = permutation[j].intValue();
                    if (permutation[i] > permutation[j]) {
                        indexI = permutation[j].intValue();
                        indexJ = permutation[i].intValue();
                    }
                    indexMap = indexI * (long)NR + indexJ;
                    if (permutation[i] > permutation[j]) {
                        indexMap = permutation[j] * NR + permutation[i];
                    }
                    w4 = (temp = GISHeuristic.m_distances.get(indexMap)) != null ? temp : 0.0;
                    int n = k;
                    this.previousSumW[n] = this.previousSumW[n] + w4;
                    int n13 = k;
                    this.previousSumWXX[n13] = this.previousSumWXX[n13] + w4 * (xi5 - xj4) * (xi5 - xj4);
                }
            }
            flagRightAllEqual = true;
            oldX = type.getNumeric(this.m_data.getTuple(N));
            for (i = N; i < NR; ++i) {
                DataTuple exi6 = this.m_data.getTuple(permutation[i]);
                double xi6 = ((ClusAttrType)type).getNominal(exi6);
                if (oldX != xi6) {
                    flagRightAllEqual = false;
                }
                for (int j = M; j < N; ++j) {
                    Double temp4;
                    long indexMap5 = permutation[i] * NR + permutation[j];
                    w = 0.0;
                    exj = this.m_data.getTuple(permutation[j]);
                    double xj5 = ((ClusAttrType)type).getNominal(exj);
                    if (xi6 != oldX) {
                        flagRightAllEqual = false;
                    }
                    if (permutation[i] > permutation[j]) {
                        indexMap5 = permutation[j] * NR + permutation[i];
                    }
                    w = (temp4 = GISHeuristic.m_distances.get(indexMap5)) != null ? temp4 : 0.0;
                    int n = k;
                    this.previousSumWR[n] = this.previousSumWR[n] - w;
                    int n14 = k;
                    this.previousSumWXXR[n14] = this.previousSumWXXR[n14] - w * (xi6 - xj5) * (xi6 - xj5);
                }
            }
            for (i = M; i < N; ++i) {
                for (int j = N; j < NR; ++j) {
                    Double temp5;
                    long indexMap6 = permutation[i] * NR + permutation[j];
                    double w5 = 0.0;
                    DataTuple exj5 = this.m_data.getTuple(permutation[j]);
                    xj = ((ClusAttrType)type).getNominal(exj5);
                    exi = this.m_data.getTuple(permutation[i]);
                    double xi7 = ((ClusAttrType)type).getNominal(exi);
                    if (permutation[i] > permutation[j]) {
                        indexMap6 = permutation[j] * NR + permutation[i];
                    }
                    w5 = (temp5 = GISHeuristic.m_distances.get(indexMap6)) != null ? temp5 : 0.0;
                    int n = k;
                    this.previousSumWR[n] = this.previousSumWR[n] - w5;
                    int n15 = k;
                    this.previousSumWXXR[n15] = this.previousSumWXXR[n15] - w5 * (xi7 - xj) * (xi7 - xj);
                }
            }
            for (i = M; i < N; ++i) {
                DataTuple exi7 = this.m_data.getTuple(permutation[i]);
                double xi8 = ((ClusAttrType)type).getNominal(exi7);
                for (int j = M; j < N; ++j) {
                    DataTuple exj6 = this.m_data.getTuple(permutation[j]);
                    double xj6 = ((ClusAttrType)type).getNominal(exj6);
                    double w6 = 0.0;
                    long indexI = permutation[i].intValue();
                    long indexJ = permutation[j].intValue();
                    if (permutation[i] > permutation[j]) {
                        indexI = permutation[j].intValue();
                        indexJ = permutation[i].intValue();
                    }
                    indexMap = indexI * (long)NR + indexJ;
                    if (permutation[i] > permutation[j]) {
                        indexMap = permutation[j] * NR + permutation[i];
                    }
                    w6 = (temp = GISHeuristic.m_distances.get(indexMap)) != null ? temp : 0.0;
                    int n = k;
                    this.previousSumWR[n] = this.previousSumWR[n] - w6;
                    int n16 = k;
                    this.previousSumWXXR[n16] = this.previousSumWXXR[n16] - w6 * (xi8 - xj6) * (xi8 - xj6);
                }
            }
            vkupenBrojElementiVoOvojSplit = N;
            num[k] = (double)(vkupenBrojElementiVoOvojSplit - 1) * this.previousSumWXX[k];
            den[k] = 2.0 * this.previousSumW[k] * (this.previousSumX2[k] - (double)vkupenBrojElementiVoOvojSplit * (this.previousSumX[k] / (double)vkupenBrojElementiVoOvojSplit) * (this.previousSumX[k] / (double)vkupenBrojElementiVoOvojSplit));
            ikk[k] = den[k] != 0.0 && num[k] != 0.0 && !flagLeftAllEqual ? num[k] / den[k] : 1.0;
            vkupenBrojElementiVoOvojSplit = NR - N;
            numR[k] = (double)(vkupenBrojElementiVoOvojSplit - 1) * this.previousSumWXXR[k];
            denR[k] = 2.0 * this.previousSumWR[k] * (this.previousSumX2R[k] - this.previousSumXR[k] * this.previousSumXR[k] / (double)vkupenBrojElementiVoOvojSplit);
            ikkR[k] = denR[k] != 0.0 && numR[k] != 0.0 && !flagRightAllEqual ? numR[k] / denR[k] : 1.0;
            avgikR += ikkR[k];
            avgik += ikk[k];
        }
        I = ((avgik /= (double)schema.getNbTargetAttributes()) * (double)N + (avgikR /= (double)schema.getNbTargetAttributes()) * (double)(NR - N)) / (double)vkupenBrojElementiVoCelataSuma;
        M = this.prevIndex;
        N = this.splitIndex;
        double scaledI = 2.0 - I;
        if (Double.isNaN(scaledI)) {
            throw new ClusException("err!");
        }
        return scaledI;
    }

    @Override
    public double calcEquvalentItotal(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_data.getSchema();
        double[] ikk = new double[schema.getNbTargetAttributes()];
        double[] ikkR = new double[schema.getNbTargetAttributes()];
        double[] num = new double[schema.getNbTargetAttributes()];
        double[] den = new double[schema.getNbTargetAttributes()];
        double[] numR = new double[schema.getNbTargetAttributes()];
        double[] denR = new double[schema.getNbTargetAttributes()];
        double[] means = new double[schema.getNbTargetAttributes()];
        double[] meansR = new double[schema.getNbTargetAttributes()];
        double avgik = 0.0;
        double avgikR = 0.0;
        int M = 0;
        int N = 0;
        int NR = this.m_data.getNbRows();
        double I = 0.0;
        int vkupenBrojElementiVoOvojSplit = N - M;
        int vkupenBrojElementiVoCelataSuma = NR;
        for (int k = 0; k < schema.getNbTargetAttributes(); ++k) {
            Double temp;
            long indexMap;
            DataTuple exi;
            double xj;
            Double temp2;
            DataTuple exj;
            double w;
            double xi;
            DataTuple exi2;
            int i;
            NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k];
            M = this.prevIndex;
            N = this.splitIndex;
            if (INITIALIZEPARTIALSUM) {
                INITIALIZEPARTIALSUM = false;
                for (int i2 = M = 0; i2 < NR; ++i2) {
                    DataTuple exi3 = this.m_data.getTuple(permutation[i2]);
                    double xi2 = ((ClusAttrType)type).getNominal(exi3);
                    int n = k;
                    meansR[n] = meansR[n] + xi2;
                    int n2 = k;
                    this.previousSumX2R[n2] = this.previousSumX2R[n2] + xi2 * xi2;
                    int n3 = k;
                    this.previousSumXR[n3] = this.previousSumXR[n3] + xi2;
                    for (int j = M; j < NR; ++j) {
                        Double temp3;
                        DataTuple exj2 = this.m_data.getTuple(permutation[j]);
                        double xj2 = ((ClusAttrType)type).getNominal(exj2);
                        long indexMap2 = permutation[i2] * NR + permutation[j];
                        double w2 = 0.0;
                        if (permutation[i2] > permutation[j]) {
                            indexMap2 = permutation[j] * NR + permutation[i2];
                        }
                        w2 = (temp3 = GISHeuristic.m_distances.get(indexMap2)) != null ? temp3 : 0.0;
                        int n4 = k;
                        this.previousSumWR[n4] = this.previousSumWR[n4] + w2;
                        int n5 = k;
                        this.previousSumWXXR[n5] = this.previousSumWXXR[n5] + w2 * xi2 * xj2;
                        int n6 = k;
                        this.previousSumWXR[n6] = this.previousSumWXR[n6] + w2 * xj2;
                    }
                }
            }
            boolean flagRightAllEqual = true;
            boolean flagLeftAllEqual = true;
            for (int i3 = M; i3 < N; ++i3) {
                DataTuple exi4 = this.m_data.getTuple(permutation[i3]);
                double xi3 = ((ClusAttrType)type).getNominal(exi4);
                int n = k;
                means[n] = means[n] + xi3;
                int n7 = k;
                this.previousSumX2[n7] = this.previousSumX2[n7] + xi3 * xi3;
                int n8 = k;
                this.previousSumX[n8] = this.previousSumX[n8] + xi3;
                int n9 = k;
                meansR[n9] = meansR[n9] - xi3;
                int n10 = k;
                this.previousSumX2R[n10] = this.previousSumX2R[n10] - xi3 * xi3;
                int n11 = k;
                this.previousSumXR[n11] = this.previousSumXR[n11] - xi3;
            }
            flagLeftAllEqual = true;
            double oldX = type.getNumeric(this.m_data.getTuple(0));
            for (i = 1; i < N; ++i) {
                exi2 = this.m_data.getTuple(permutation[i]);
                xi = ((ClusAttrType)type).getNominal(exi2);
                if (xi == oldX) continue;
                flagLeftAllEqual = false;
                break;
            }
            for (i = 0; i < M; ++i) {
                exi2 = this.m_data.getTuple(permutation[i]);
                xi = ((ClusAttrType)type).getNominal(exi2);
                for (int j = M; j < N; ++j) {
                    long indexMap3 = permutation[i] * NR + permutation[j];
                    w = 0.0;
                    exj = this.m_data.getTuple(permutation[j]);
                    double xj3 = ((ClusAttrType)type).getNominal(exj);
                    if (permutation[i] > permutation[j]) {
                        indexMap3 = permutation[j] * NR + permutation[i];
                    }
                    w = (temp2 = GISHeuristic.m_distances.get(indexMap3)) != null ? temp2 : 0.0;
                    int n = k;
                    this.previousSumW[n] = this.previousSumW[n] + w;
                    int n12 = k;
                    this.previousSumWXX[n12] = this.previousSumWXX[n12] + w * xi * xj3;
                    int n13 = k;
                    this.previousSumWX[n13] = this.previousSumWX[n13] + w * xj3;
                }
            }
            for (i = M; i < N; ++i) {
                for (int j = 0; j < M; ++j) {
                    long indexMap4 = permutation[i] * NR + permutation[j];
                    double w3 = 0.0;
                    DataTuple exj3 = this.m_data.getTuple(permutation[j]);
                    xj = ((ClusAttrType)type).getNominal(exj3);
                    exi = this.m_data.getTuple(permutation[i]);
                    double xi4 = ((ClusAttrType)type).getNominal(exi);
                    if (permutation[i] > permutation[j]) {
                        indexMap4 = permutation[j] * NR + permutation[i];
                    }
                    w3 = (temp2 = GISHeuristic.m_distances.get(indexMap4)) != null ? temp2 : 0.0;
                    int n = k;
                    this.previousSumW[n] = this.previousSumW[n] + w3;
                    int n14 = k;
                    this.previousSumWX[n14] = this.previousSumWX[n14] + w3 * xj;
                    int n15 = k;
                    this.previousSumWXX[n15] = this.previousSumWXX[n15] + w3 * xi4 * xj;
                }
            }
            for (i = M; i < N; ++i) {
                DataTuple exi5 = this.m_data.getTuple(permutation[i]);
                double xi5 = ((ClusAttrType)type).getNominal(exi5);
                for (int j = M; j < N; ++j) {
                    DataTuple exj4 = this.m_data.getTuple(permutation[j]);
                    double xj4 = ((ClusAttrType)type).getNominal(exj4);
                    double w4 = 0.0;
                    long indexI = permutation[i].intValue();
                    long indexJ = permutation[j].intValue();
                    if (permutation[i] > permutation[j]) {
                        indexI = permutation[j].intValue();
                        indexJ = permutation[i].intValue();
                    }
                    indexMap = indexI * (long)NR + indexJ;
                    if (permutation[i] > permutation[j]) {
                        indexMap = permutation[j] * NR + permutation[i];
                    }
                    w4 = (temp = GISHeuristic.m_distances.get(indexMap)) != null ? temp : 0.0;
                    int n = k;
                    this.previousSumW[n] = this.previousSumW[n] + w4;
                    int n16 = k;
                    this.previousSumWX[n16] = this.previousSumWX[n16] + w4 * xj4;
                    int n17 = k;
                    this.previousSumWXX[n17] = this.previousSumWXX[n17] + w4 * xi5 * xj4;
                }
            }
            flagRightAllEqual = true;
            oldX = type.getNumeric(this.m_data.getTuple(N));
            for (i = N; i < NR; ++i) {
                DataTuple exi6 = this.m_data.getTuple(permutation[i]);
                double xi6 = ((ClusAttrType)type).getNominal(exi6);
                if (oldX != xi6) {
                    flagRightAllEqual = false;
                }
                for (int j = M; j < N; ++j) {
                    Double temp4;
                    long indexMap5 = permutation[i] * NR + permutation[j];
                    w = 0.0;
                    exj = this.m_data.getTuple(permutation[j]);
                    double xj5 = ((ClusAttrType)type).getNominal(exj);
                    if (xi6 != oldX) {
                        flagRightAllEqual = false;
                    }
                    if (permutation[i] > permutation[j]) {
                        indexMap5 = permutation[j] * NR + permutation[i];
                    }
                    w = (temp4 = GISHeuristic.m_distances.get(indexMap5)) != null ? temp4 : 0.0;
                    int n = k;
                    this.previousSumWR[n] = this.previousSumWR[n] - w;
                    int n18 = k;
                    this.previousSumWXXR[n18] = this.previousSumWXXR[n18] - w * xi6 * xj5;
                    int n19 = k;
                    this.previousSumWXR[n19] = this.previousSumWXR[n19] - w * xj5;
                }
            }
            for (i = M; i < N; ++i) {
                for (int j = N; j < NR; ++j) {
                    Double temp5;
                    long indexMap6 = permutation[i] * NR + permutation[j];
                    double w5 = 0.0;
                    DataTuple exj5 = this.m_data.getTuple(permutation[j]);
                    xj = ((ClusAttrType)type).getNominal(exj5);
                    exi = this.m_data.getTuple(permutation[i]);
                    double xi7 = ((ClusAttrType)type).getNominal(exi);
                    if (permutation[i] > permutation[j]) {
                        indexMap6 = permutation[j] * NR + permutation[i];
                    }
                    w5 = (temp5 = GISHeuristic.m_distances.get(indexMap6)) != null ? temp5 : 0.0;
                    int n = k;
                    this.previousSumWR[n] = this.previousSumWR[n] - w5;
                    int n20 = k;
                    this.previousSumWXXR[n20] = this.previousSumWXXR[n20] - w5 * xi7 * xj;
                    int n21 = k;
                    this.previousSumWXR[n21] = this.previousSumWXR[n21] - w5 * xj;
                }
            }
            for (i = M; i < N; ++i) {
                DataTuple exi7 = this.m_data.getTuple(permutation[i]);
                double xi8 = ((ClusAttrType)type).getNominal(exi7);
                for (int j = M; j < N; ++j) {
                    DataTuple exj6 = this.m_data.getTuple(permutation[j]);
                    double xj6 = ((ClusAttrType)type).getNominal(exj6);
                    double w6 = 0.0;
                    long indexI = permutation[i].intValue();
                    long indexJ = permutation[j].intValue();
                    if (permutation[i] > permutation[j]) {
                        indexI = permutation[j].intValue();
                        indexJ = permutation[i].intValue();
                    }
                    indexMap = indexI * (long)NR + indexJ;
                    if (permutation[i] > permutation[j]) {
                        indexMap = permutation[j] * NR + permutation[i];
                    }
                    w6 = (temp = GISHeuristic.m_distances.get(indexMap)) != null ? temp : 0.0;
                    int n = k;
                    this.previousSumWR[n] = this.previousSumWR[n] - w6;
                    int n22 = k;
                    this.previousSumWXXR[n22] = this.previousSumWXXR[n22] - w6 * xi8 * xj6;
                    int n23 = k;
                    this.previousSumWXR[n23] = this.previousSumWXR[n23] - w6 * xj6;
                }
            }
            vkupenBrojElementiVoOvojSplit = N;
            num[k] = (double)vkupenBrojElementiVoOvojSplit * (this.previousSumWXX[k] - 2.0 * (this.previousSumX[k] / (double)vkupenBrojElementiVoOvojSplit) * this.previousSumWX[k] + this.previousSumX[k] / (double)vkupenBrojElementiVoOvojSplit * (this.previousSumX[k] / (double)vkupenBrojElementiVoOvojSplit) * this.previousSumW[k]);
            den[k] = this.previousSumW[k] * (this.previousSumX2[k] - (double)vkupenBrojElementiVoOvojSplit * (this.previousSumX[k] / (double)vkupenBrojElementiVoOvojSplit) * (this.previousSumX[k] / (double)vkupenBrojElementiVoOvojSplit));
            ikk[k] = den[k] != 0.0 && num[k] != 0.0 && !flagLeftAllEqual ? num[k] / den[k] : 1.0;
            vkupenBrojElementiVoOvojSplit = NR - N;
            numR[k] = (double)vkupenBrojElementiVoOvojSplit * (this.previousSumWXXR[k] - 2.0 * this.previousSumWXR[k] * (this.previousSumXR[k] / (double)vkupenBrojElementiVoOvojSplit) + this.previousSumXR[k] / (double)vkupenBrojElementiVoOvojSplit * (this.previousSumXR[k] / (double)vkupenBrojElementiVoOvojSplit) * this.previousSumWR[k]);
            denR[k] = this.previousSumWR[k] * (this.previousSumX2R[k] - this.previousSumXR[k] * this.previousSumXR[k] / (double)vkupenBrojElementiVoOvojSplit);
            ikkR[k] = denR[k] != 0.0 && numR[k] != 0.0 && !flagRightAllEqual ? numR[k] / denR[k] : 1.0;
            avgikR += ikkR[k];
            avgik += ikk[k];
        }
        I = ((avgik /= (double)schema.getNbTargetAttributes()) * (double)N + (avgikR /= (double)schema.getNbTargetAttributes()) * (double)(NR - N)) / (double)vkupenBrojElementiVoCelataSuma;
        M = this.prevIndex;
        N = this.splitIndex;
        double scaledI = 1.0 + I;
        if (Double.isNaN(scaledI)) {
            throw new ClusException("err!");
        }
        return scaledI;
    }

    @Override
    public double calcGtotal(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_data.getSchema();
        int M = 0;
        int N = this.m_data.getNbRows();
        long NR = this.m_data.getNbRows();
        if (this.splitIndex > 0) {
            N = this.splitIndex;
        } else {
            M = -this.splitIndex;
        }
        double[] upsum = new double[schema.getNbTargetAttributes()];
        double[] downsum = new double[schema.getNbTargetAttributes()];
        double[] means = new double[schema.getNbTargetAttributes()];
        double[] ikk = new double[schema.getNbTargetAttributes()];
        int k = 0;
        while (k < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k];
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNominal(exi);
                int n = k;
                means[n] = means[n] + xi;
            }
            int n = k++;
            means[n] = means[n] / (double)(N - M);
        }
        double avgik = 0.0;
        double W = 0.0;
        for (int k2 = 0; k2 < schema.getNbTargetAttributes(); ++k2) {
            NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k2];
            for (int i = M; i < N; ++i) {
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNominal(exi);
                for (int j = M; j < N; ++j) {
                    DataTuple exj = this.m_data.getTuple(permutation[j]);
                    double xj = ((ClusAttrType)type).getNominal(exj);
                    double w = 0.0;
                    long indexI = permutation[i].intValue();
                    long indexJ = permutation[j].intValue();
                    if (permutation[i] != permutation[j]) {
                        long indexMap;
                        Double temp;
                        if (permutation[i] > permutation[j]) {
                            indexI = permutation[j].intValue();
                            indexJ = permutation[i].intValue();
                        }
                        w = (temp = GISHeuristic.m_distances.get(indexMap = indexI * NR + indexJ)) != null ? temp : 0.0;
                        int n = k2;
                        upsum[n] = upsum[n] + w * (xi - xj) * (xi - xj);
                        W += w;
                        continue;
                    }
                    W += 1.0;
                    int n = k2;
                    upsum[n] = upsum[n] + (xi - xj) * (xi - xj);
                }
                int n = k2;
                downsum[n] = downsum[n] + (xi - means[k2]) * (xi - means[k2]);
            }
            if (downsum[k2] != 0.0 && upsum[k2] != 0.0) {
                ikk[k2] = (double)(N - M - 1) * upsum[k2] / (2.0 * W * downsum[k2]);
                avgik += ikk[k2];
                continue;
            }
            ikk[k2] = 0.0;
        }
        double IL = (double)(N - M) * (avgik /= (double)schema.getNbTargetAttributes());
        M = this.splitIndex;
        N = this.m_data.getNbRows();
        double[] upsumR = new double[schema.getNbTargetAttributes()];
        double[] downsumR = new double[schema.getNbTargetAttributes()];
        double[] meansR = new double[schema.getNbTargetAttributes()];
        double[] ikkR = new double[schema.getNbTargetAttributes()];
        int k3 = 0;
        while (k3 < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k3];
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNominal(exi);
                int n = k3;
                meansR[n] = meansR[n] + xi;
            }
            int n = k3++;
            meansR[n] = meansR[n] / (double)(N - M);
        }
        double avgikR = 0.0;
        double WR = 0.0;
        for (int k4 = 0; k4 < schema.getNbTargetAttributes(); ++k4) {
            NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k4];
            for (int i = M; i < N; ++i) {
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNominal(exi);
                for (int j = M; j < N; ++j) {
                    DataTuple exj = this.m_data.getTuple(permutation[j]);
                    double xj = ((ClusAttrType)type).getNominal(exj);
                    double w = 0.0;
                    long indexI = permutation[i].intValue();
                    long indexJ = permutation[j].intValue();
                    if (permutation[i] != permutation[j]) {
                        long indexMap;
                        Double temp;
                        if (permutation[i] > permutation[j]) {
                            indexI = permutation[j].intValue();
                            indexJ = permutation[i].intValue();
                        }
                        w = (temp = GISHeuristic.m_distances.get(indexMap = indexI * NR + indexJ)) != null ? temp : 0.0;
                        int n = k4;
                        upsumR[n] = upsumR[n] + w * (xi - xj) * (xi - xj);
                        WR += w;
                        continue;
                    }
                    WR += 1.0;
                    int n = k4;
                    upsum[n] = upsum[n] + (xi - xj) * (xi - xj);
                }
                int n = k4;
                downsumR[n] = downsumR[n] + (xi - meansR[k4]) * (xi - meansR[k4]);
            }
            if (downsumR[k4] != 0.0 && upsumR[k4] != 0.0) {
                ikkR[k4] = (double)(N - M - 1) * upsumR[k4] / (2.0 * WR * downsumR[k4]);
                avgikR += ikkR[k4];
                continue;
            }
            ikkR[k4] = 0.0;
        }
        double IR = avgikR /= (double)schema.getNbTargetAttributes();
        double I = 2.0 - (IL + IR * (double)(N - M)) / (double)NR;
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return I;
    }

    @Override
    public double calcItotalD(Integer[] permutation) throws ClusException {
        double den;
        double num;
        ClusSchema schema = this.m_data.getSchema();
        double avgik = 0.0;
        double W = 0.0;
        int M = 0;
        int N = this.m_data.getNbRows();
        if (this.splitIndex > 0) {
            N = this.splitIndex;
        } else {
            M = -this.splitIndex;
        }
        double[] upsum = new double[schema.getNbTargetAttributes()];
        double[] downsum = new double[schema.getNbTargetAttributes()];
        double[] means = new double[schema.getNbTargetAttributes()];
        double[] ikk = new double[schema.getNbTargetAttributes()];
        int k = 0;
        while (k < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NominalAttrType type = this.m_Attrs[k];
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNominal(exi);
                int n = k;
                means[n] = means[n] + xi;
            }
            int n = k++;
            means[n] = means[n] / (double)(N - M);
        }
        for (k = 0; k < schema.getNbTargetAttributes(); ++k) {
            NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k];
            NumericAttrType xt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
            for (int i = M; i < N; ++i) {
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNominal(exi);
                long xxi = (long)((ClusAttrType)xt).getNumeric(exi);
                for (int j = M; j < N; ++j) {
                    DataTuple exj = this.m_data.getTuple(permutation[j]);
                    double xj = ((ClusAttrType)type).getNominal(exj);
                    long yyi = (long)((ClusAttrType)xt).getNumeric(exj);
                    double w = 0.0;
                    long indexI = xxi;
                    long indexJ = yyi;
                    if (indexI != indexJ) {
                        String indexMap;
                        Double tmp;
                        if (indexI > indexJ) {
                            indexI = yyi;
                            indexJ = xxi;
                        }
                        w = (tmp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) != null ? tmp : 0.0;
                        int n = k;
                        upsum[n] = upsum[n] + w * (xi - means[k]) * (xj - means[k]);
                        W += w;
                        continue;
                    }
                    int n = k;
                    upsum[n] = upsum[n] + (xi - means[k]) * (xi - means[k]);
                    W += 1.0;
                }
                int n = k;
                downsum[n] = downsum[n] + (xi - means[k]) * (xi - means[k]);
            }
            num = ((double)(N - M) + 0.0) * upsum[k];
            den = W * downsum[k];
            ikk[k] = num != 0.0 && den != 0.0 ? num / den : 1.0;
            avgik += ikk[k];
        }
        double IL = (avgik /= (double)schema.getNbTargetAttributes()) * (double)(N - M);
        N = this.m_data.getNbRows();
        M = this.splitIndex;
        double avgikR = 0.0;
        double[] upsumR = new double[schema.getNbTargetAttributes()];
        double[] downsumR = new double[schema.getNbTargetAttributes()];
        double[] meansR = new double[schema.getNbTargetAttributes()];
        double[] ikkR = new double[schema.getNbTargetAttributes()];
        int k2 = 0;
        while (k2 < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k2];
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNominal(exi);
                int n = k2;
                meansR[n] = meansR[n] + xi;
            }
            int n = k2++;
            meansR[n] = meansR[n] / (double)(N - M);
        }
        for (k2 = 0; k2 < schema.getNbTargetAttributes(); ++k2) {
            NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k2];
            NumericAttrType xt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
            for (int i = M; i < N; ++i) {
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNominal(exi);
                long xxi = (long)((ClusAttrType)xt).getNumeric(exi);
                for (int j = M; j < N; ++j) {
                    DataTuple exj = this.m_data.getTuple(permutation[j]);
                    double xj = ((ClusAttrType)type).getNominal(exj);
                    long yyi = (long)((ClusAttrType)xt).getNumeric(exj);
                    double w = 0.0;
                    long indexI = xxi;
                    long indexJ = yyi;
                    if (indexI != indexJ) {
                        String indexMap;
                        Double tmp;
                        if (indexI > indexJ) {
                            indexI = yyi;
                            indexJ = xxi;
                        }
                        w = (tmp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) != null ? tmp : 0.0;
                        int n = k2;
                        upsumR[n] = upsumR[n] + w * (xi - meansR[k2]) * (xj - meansR[k2]);
                        continue;
                    }
                    int n = k2;
                    upsumR[n] = upsumR[n] + (xi - meansR[k2]) * (xi - meansR[k2]);
                }
                int n = k2;
                downsumR[n] = downsumR[n] + (xi - meansR[k2]) * (xi - meansR[k2]);
            }
            num = ((double)(N - M) + 0.0) * upsumR[k2];
            den = W * downsumR[k2];
            ikkR[k2] = num != 0.0 && den != 0.0 ? num / den : 1.0;
            avgikR += ikkR[k2];
        }
        double IR = avgikR /= (double)schema.getNbTargetAttributes();
        double I = (IL + IR * (double)(N - M)) / (double)this.m_data.getNbRows();
        double scaledI = 1.0 + I;
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return scaledI;
    }

    @Override
    public double calcItotal(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_data.getSchema();
        int M = 0;
        int N = this.m_data.getNbRows();
        long NR = this.m_data.getNbRows();
        if (this.splitIndex > 0) {
            N = this.splitIndex;
        } else {
            M = -this.splitIndex;
        }
        double[] upsum = new double[schema.getNbTargetAttributes()];
        double[] downsum = new double[schema.getNbTargetAttributes()];
        double[] means = new double[schema.getNbTargetAttributes()];
        double[] ikk = new double[schema.getNbTargetAttributes()];
        int k = 0;
        while (k < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                int permI = permutation[i];
                NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k];
                DataTuple exi = this.m_data.getTuple(permI);
                double xi = ((ClusAttrType)type).getNominal(exi);
                int n = k;
                means[n] = means[n] + xi;
            }
            int n = k++;
            means[n] = means[n] / (double)(N - M);
        }
        double avgik = 0.0;
        double W = 0.0;
        for (int k2 = 0; k2 < schema.getNbTargetAttributes(); ++k2) {
            NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k2];
            for (int i = M; i < N; ++i) {
                int permI = permutation[i];
                DataTuple exi = this.m_data.getTuple(permI);
                double xi = ((ClusAttrType)type).getNominal(exi);
                for (int j = M; j < N; ++j) {
                    int permJ = permutation[j];
                    DataTuple exj = this.m_data.getTuple(permJ);
                    double xj = ((ClusAttrType)type).getNominal(exj);
                    double w = 0.0;
                    long indexI = permI;
                    long indexJ = permJ;
                    if (permI != permJ) {
                        long indexMap;
                        Double temp;
                        if (permI > permJ) {
                            indexI = permJ;
                            indexJ = permI;
                        }
                        w = (temp = GISHeuristic.m_distances.get(indexMap = indexI * NR + indexJ)) != null ? temp : 0.0;
                        int n = k2;
                        upsum[n] = upsum[n] + w * (xi - means[k2]) * (xj - means[k2]);
                        W += w;
                        continue;
                    }
                    W += 1.0;
                    int n = k2;
                    upsum[n] = upsum[n] + (xi - means[k2]) * (xj - means[k2]);
                }
                int n = k2;
                downsum[n] = downsum[n] + (xi - means[k2]) * (xi - means[k2]);
            }
            if (downsum[k2] != 0.0 && upsum[k2] != 0.0) {
                ikk[k2] = (double)(N - M) * upsum[k2] / (W * downsum[k2]);
                avgik += ikk[k2];
                continue;
            }
            ikk[k2] = 1.0;
        }
        double IL = (double)(N - M) * (avgik /= (double)schema.getNbTargetAttributes());
        M = this.splitIndex;
        N = this.m_data.getNbRows();
        double[] upsumR = new double[schema.getNbTargetAttributes()];
        double[] downsumR = new double[schema.getNbTargetAttributes()];
        double[] meansR = new double[schema.getNbTargetAttributes()];
        double[] ikkR = new double[schema.getNbTargetAttributes()];
        int k3 = 0;
        while (k3 < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                int permI = permutation[i];
                NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k3];
                DataTuple exi = this.m_data.getTuple(permI);
                double xi = ((ClusAttrType)type).getNominal(exi);
                int n = k3;
                meansR[n] = meansR[n] + xi;
            }
            int n = k3++;
            meansR[n] = meansR[n] / (double)(N - M);
        }
        double avgikR = 0.0;
        double WR = 0.0;
        for (int k4 = 0; k4 < schema.getNbTargetAttributes(); ++k4) {
            NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k4];
            for (int i = M; i < N; ++i) {
                int permI = permutation[i];
                DataTuple exi = this.m_data.getTuple(permI);
                double xi = ((ClusAttrType)type).getNominal(exi);
                for (int j = M; j < N; ++j) {
                    int permJ = permutation[j];
                    DataTuple exj = this.m_data.getTuple(permJ);
                    double xj = ((ClusAttrType)type).getNominal(exj);
                    double w = 0.0;
                    long indexI = permI;
                    long indexJ = permJ;
                    if (permI != permJ) {
                        long indexMap;
                        Double temp;
                        if (permI > permJ) {
                            indexI = permJ;
                            indexJ = permI;
                        }
                        w = (temp = GISHeuristic.m_distances.get(indexMap = indexI * NR + indexJ)) != null ? temp : 0.0;
                        int n = k4;
                        upsumR[n] = upsumR[n] + w * (xi - means[k4]) * (xj - means[k4]);
                        WR += w;
                        continue;
                    }
                    WR += 1.0;
                    int n = k4;
                    upsum[n] = upsum[n] + (xi - means[k4]) * (xj - means[k4]);
                }
                int n = k4;
                downsumR[n] = downsumR[n] + (xi - meansR[k4]) * (xi - meansR[k4]);
            }
            if (downsumR[k4] != 0.0 && upsumR[k4] != 0.0) {
                ikkR[k4] = (double)(N - M) * upsumR[k4] / (WR * downsumR[k4]);
                avgikR += ikkR[k4];
                continue;
            }
            ikkR[k4] = 0.0;
        }
        double IR = avgikR /= (double)schema.getNbTargetAttributes();
        double I = 1.0 + (IL + IR * (double)(N - M)) / (double)NR;
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return I;
    }

    @Override
    public double calcGtotalD(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_data.getSchema();
        int M = 0;
        int N = this.m_data.getNbRows();
        long NR = this.m_data.getNbRows();
        if (this.splitIndex > 0) {
            N = this.splitIndex;
        } else {
            M = -this.splitIndex;
        }
        double[] upsum = new double[schema.getNbTargetAttributes()];
        double[] downsum = new double[schema.getNbTargetAttributes()];
        double[] means = new double[schema.getNbTargetAttributes()];
        double[] ikk = new double[schema.getNbTargetAttributes()];
        int k = 0;
        while (k < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k];
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNominal(exi);
                int n = k;
                means[n] = means[n] + xi;
            }
            int n = k++;
            means[n] = means[n] / (double)(N - M);
        }
        double avgik = 0.0;
        double W = 0.0;
        for (int k2 = 0; k2 < schema.getNbTargetAttributes(); ++k2) {
            NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k2];
            NumericAttrType xt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
            for (int i = M; i < N; ++i) {
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNominal(exi);
                long xxi = (long)((ClusAttrType)xt).getNumeric(exi);
                for (int j = M; j < N; ++j) {
                    DataTuple exj = this.m_data.getTuple(permutation[j]);
                    double xj = ((ClusAttrType)type).getNominal(exj);
                    long yyi = (long)((ClusAttrType)xt).getNumeric(exj);
                    double w = 0.0;
                    long indexI = xxi;
                    long indexJ = yyi;
                    if (indexI != indexJ) {
                        String indexMap;
                        Double temp;
                        if (indexI > indexJ) {
                            indexI = yyi;
                            indexJ = xxi;
                        }
                        w = (temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) != null ? temp : 0.0;
                        int n = k2;
                        upsum[n] = upsum[n] + w * (xi - xj) * (xi - xj);
                        W += w;
                        continue;
                    }
                    W += 1.0;
                    int n = k2;
                    upsum[n] = upsum[n] + (xi - xj) * (xi - xj);
                }
                int n = k2;
                downsum[n] = downsum[n] + (xi - means[k2]) * (xi - means[k2]);
            }
            if (downsum[k2] != 0.0 && upsum[k2] != 0.0) {
                ikk[k2] = (double)(N - M - 1) * upsum[k2] / (2.0 * W * downsum[k2]);
                avgik += ikk[k2];
                continue;
            }
            ikk[k2] = 0.0;
        }
        double IL = (double)(N - M) * (avgik /= (double)schema.getNbTargetAttributes());
        M = this.splitIndex;
        N = this.m_data.getNbRows();
        double[] upsumR = new double[schema.getNbTargetAttributes()];
        double[] downsumR = new double[schema.getNbTargetAttributes()];
        double[] meansR = new double[schema.getNbTargetAttributes()];
        double[] ikkR = new double[schema.getNbTargetAttributes()];
        int k3 = 0;
        while (k3 < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k3];
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNominal(exi);
                int n = k3;
                meansR[n] = meansR[n] + xi;
            }
            int n = k3++;
            meansR[n] = meansR[n] / (double)(N - M);
        }
        double avgikR = 0.0;
        double WR = 0.0;
        for (int k4 = 0; k4 < schema.getNbTargetAttributes(); ++k4) {
            NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k4];
            NumericAttrType xt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
            for (int i = M; i < N; ++i) {
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNominal(exi);
                long xxi = (long)((ClusAttrType)xt).getNumeric(exi);
                for (int j = M; j < N; ++j) {
                    DataTuple exj = this.m_data.getTuple(permutation[j]);
                    double xj = ((ClusAttrType)type).getNominal(exj);
                    long yyi = (long)((ClusAttrType)xt).getNumeric(exj);
                    double w = 0.0;
                    long indexI = xxi;
                    long indexJ = yyi;
                    if (indexI != indexJ) {
                        String indexMap;
                        Double temp;
                        if (indexI > indexJ) {
                            indexI = yyi;
                            indexJ = xxi;
                        }
                        w = (temp = GISHeuristic.m_distancesS.get(indexMap = indexI + "#" + indexJ)) != null ? temp : 0.0;
                        int n = k4;
                        upsumR[n] = upsumR[n] + w * (xi - xj) * (xi - xj);
                        WR += w;
                        continue;
                    }
                    WR += 1.0;
                    int n = k4;
                    upsumR[n] = upsumR[n] + w * (xi - xj) * (xi - xj);
                }
                int n = k4;
                downsumR[n] = downsumR[n] + (xi - meansR[k4]) * (xi - meansR[k4]);
            }
            if (downsumR[k4] != 0.0 && upsumR[k4] != 0.0) {
                ikkR[k4] = (double)(N - M - 1) * upsumR[k4] / (2.0 * WR * downsumR[k4]);
                avgikR += ikkR[k4];
                continue;
            }
            ikkR[k4] = 0.0;
        }
        double IR = avgikR /= (double)schema.getNbTargetAttributes();
        double I = 2.0 - (IL + IR * (double)(N - M)) / (double)NR;
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return I;
    }

    @Override
    public double calcGetisTotal(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_data.getSchema();
        int M = 0;
        int N = this.m_data.getNbRows();
        if (this.splitIndex > 0) {
            N = this.splitIndex;
        } else {
            M = -this.splitIndex;
        }
        double[] upsum = new double[schema.getNbTargetAttributes()];
        double[] downsum = new double[schema.getNbTargetAttributes()];
        double[] ikk = new double[schema.getNbTargetAttributes()];
        double avgik = 0.0;
        for (int k = 0; k < schema.getNbTargetAttributes(); ++k) {
            NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k];
            for (int i = M; i < N; ++i) {
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNominal(exi);
                for (int j = M; j < N; ++j) {
                    long indexMap;
                    DataTuple exj = this.m_data.getTuple(permutation[j]);
                    double xj = ((ClusAttrType)type).getNominal(exj);
                    double w = 0.0;
                    long indexI = permutation[i].intValue();
                    long indexJ = permutation[j].intValue();
                    if (permutation[i] == permutation[j]) continue;
                    if (permutation[i] > permutation[j]) {
                        indexI = permutation[j].intValue();
                        indexJ = permutation[i].intValue();
                    }
                    w = GISHeuristic.m_distances.get(indexMap = indexI * (long)(N - M) + indexJ) != null ? GISHeuristic.m_distances.get(indexMap) : 0.0;
                    int n = k;
                    upsum[n] = upsum[n] + w * xi * xj;
                    int n2 = k;
                    downsum[n2] = downsum[n2] + xi * xj;
                }
            }
            if (downsum[k] != 0.0 && upsum[k] != 0.0) {
                ikk[k] = upsum[k] / downsum[k];
                avgik += ikk[k];
                continue;
            }
            avgik = 1.0;
        }
        double I = avgik /= (double)schema.getNbTargetAttributes();
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return I;
    }

    @Override
    public double calcLISAtotal(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_data.getSchema();
        int M = 0;
        int N = this.m_data.getNbRows();
        if (this.splitIndex > 0) {
            N = this.splitIndex;
        } else {
            M = -this.splitIndex;
        }
        double[][] upsum = new double[schema.getNbTargetAttributes()][N];
        double[][] upsum1 = new double[schema.getNbTargetAttributes()][N];
        double[][] ik = new double[schema.getNbTargetAttributes()][N];
        double[] downsum = new double[schema.getNbTargetAttributes()];
        double[] means = new double[schema.getNbTargetAttributes()];
        double[] ikk = new double[schema.getNbTargetAttributes()];
        int k = 0;
        while (k < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k];
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNominal(exi);
                int n = k;
                means[n] = means[n] + xi;
            }
            int n = k++;
            means[n] = means[n] / (double)(N - M);
        }
        double avgik = 0.0;
        for (int k2 = 0; k2 < schema.getNbTargetAttributes(); ++k2) {
            int i;
            NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k2];
            for (i = M; i < N; ++i) {
                for (int j = M; j < N; ++j) {
                    long indexMap;
                    DataTuple exj = this.m_data.getTuple(permutation[j]);
                    double xj = ((ClusAttrType)type).getNominal(exj);
                    double w = 0.0;
                    long indexI = permutation[i].intValue();
                    long indexJ = permutation[j].intValue();
                    if (permutation[i] == permutation[j]) continue;
                    if (permutation[i] > permutation[j]) {
                        indexI = permutation[j].intValue();
                        indexJ = permutation[i].intValue();
                    }
                    w = GISHeuristic.m_distances.get(indexMap = indexI * (long)(N - M) + indexJ) != null ? GISHeuristic.m_distances.get(indexMap) : 0.0;
                    double[] dArray = upsum1[k2];
                    int n = permutation[i];
                    dArray[n] = dArray[n] + w * (xj - means[k2]);
                }
            }
            for (i = M; i < N; ++i) {
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNominal(exi);
                upsum[k2][permutation[i].intValue()] = (xi - means[k2]) * upsum1[k2][permutation[i]];
                int n = k2;
                downsum[n] = downsum[n] + (xi - means[k2]) * (xi - means[k2]);
            }
            int n = k2;
            downsum[n] = downsum[n] / ((double)(N - M) + 0.0);
            for (i = M; i < N; ++i) {
                if (downsum[k2] != 0.0 && upsum[k2][i] != 0.0) {
                    ik[k2][permutation[i].intValue()] = upsum[k2][permutation[i]] / downsum[k2];
                    int n2 = k2;
                    ikk[n2] = ikk[n2] + ik[k2][permutation[i]];
                    continue;
                }
                ikk[k2] = 0.0;
            }
            avgik += ikk[k2];
        }
        double I = avgik /= (double)schema.getNbTargetAttributes();
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return I;
    }

    @Override
    public double calcGLocalTotal(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_data.getSchema();
        int M = 0;
        int N = this.m_data.getNbRows();
        if (this.splitIndex > 0) {
            N = this.splitIndex;
        } else {
            M = -this.splitIndex;
        }
        double[][] upsum = new double[schema.getNbTargetAttributes()][N];
        double[] downsum = new double[schema.getNbTargetAttributes()];
        double[] means = new double[schema.getNbTargetAttributes()];
        double[] ikk = new double[schema.getNbTargetAttributes()];
        double[][] ik = new double[schema.getNbTargetAttributes()][N];
        int k = 0;
        while (k < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k];
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNominal(exi);
                int n = k;
                means[n] = means[n] + xi;
            }
            int n = k++;
            means[n] = means[n] / (double)(N - M);
        }
        double avgik = 0.0;
        for (int k2 = 0; k2 < schema.getNbTargetAttributes(); ++k2) {
            int i;
            NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k2];
            for (i = M; i < N; ++i) {
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNominal(exi);
                for (int j = M; j < N; ++j) {
                    long indexMap;
                    DataTuple exj = this.m_data.getTuple(permutation[j]);
                    double xj = ((ClusAttrType)type).getNominal(exj);
                    double w = 0.0;
                    long indexI = permutation[i].intValue();
                    long indexJ = permutation[j].intValue();
                    if (permutation[i] == permutation[j]) continue;
                    if (permutation[i] > permutation[j]) {
                        indexI = permutation[j].intValue();
                        indexJ = permutation[i].intValue();
                    }
                    w = GISHeuristic.m_distances.get(indexMap = indexI * (long)(N - M) + indexJ) != null ? GISHeuristic.m_distances.get(indexMap) : 0.0;
                    double[] dArray = upsum[k2];
                    int n = permutation[i];
                    dArray[n] = dArray[n] + w * (xi - xj) * (xi - xj);
                }
                int n = k2;
                downsum[n] = downsum[n] + (xi - means[k2]) * (xi - means[k2]);
            }
            for (i = M; i < N; ++i) {
                if (downsum[k2] != 0.0 && upsum[k2][permutation[i]] != 0.0) {
                    ik[k2][permutation[i].intValue()] = (double)(N - M) * upsum[k2][permutation[i]] / downsum[k2];
                    int n = k2;
                    ikk[n] = ikk[n] + ik[k2][permutation[i]];
                    continue;
                }
                ikk[k2] = 0.0;
            }
            avgik += ikk[k2];
        }
        double I = avgik /= (double)schema.getNbTargetAttributes();
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return I;
    }

    @Override
    public double calcLocalGetisTotal(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_data.getSchema();
        int M = 0;
        int N = this.m_data.getNbRows();
        if (this.splitIndex > 0) {
            N = this.splitIndex;
        } else {
            M = -this.splitIndex;
        }
        double[][] upsum = new double[schema.getNbTargetAttributes()][N];
        double[][] downsum = new double[schema.getNbTargetAttributes()][N];
        double[] means = new double[schema.getNbTargetAttributes()];
        double[] ikk = new double[schema.getNbTargetAttributes()];
        double[][] ik = new double[schema.getNbTargetAttributes()][N];
        int k = 0;
        while (k < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k];
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNominal(exi);
                int n = k;
                means[n] = means[n] + xi;
            }
            int n = k++;
            means[n] = means[n] / (double)(N - M);
        }
        double avgik = 0.0;
        for (int k2 = 0; k2 < schema.getNbTargetAttributes(); ++k2) {
            NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k2];
            for (int i = M; i < N; ++i) {
                for (int j = M; j < N; ++j) {
                    long indexMap;
                    DataTuple exj = this.m_data.getTuple(permutation[j]);
                    double xj = ((ClusAttrType)type).getNominal(exj);
                    double w = 0.0;
                    long indexI = permutation[i].intValue();
                    long indexJ = permutation[j].intValue();
                    if (permutation[i] == permutation[j]) continue;
                    if (permutation[i] > permutation[j]) {
                        indexI = permutation[j].intValue();
                        indexJ = permutation[i].intValue();
                    }
                    w = GISHeuristic.m_distances.get(indexMap = indexI * (long)(N - M) + indexJ) != null ? GISHeuristic.m_distances.get(indexMap) : 0.0;
                    double[] dArray = upsum[k2];
                    int n = permutation[i];
                    dArray[n] = dArray[n] + w * xj;
                    double[] dArray2 = downsum[k2];
                    int n2 = permutation[i];
                    dArray2[n2] = dArray2[n2] + xj;
                }
                if (upsum[k2][permutation[i]] != 0.0) {
                    ik[k2][permutation[i].intValue()] = upsum[k2][permutation[i]] / downsum[k2][permutation[i]];
                    int n = k2;
                    ikk[n] = ikk[n] + ik[k2][permutation[i]];
                } else {
                    ikk[k2] = 0.0;
                }
                avgik += ikk[k2];
            }
        }
        double I = avgik /= (double)schema.getNbTargetAttributes();
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return I;
    }

    @Override
    public double calcGETIStotal(Integer[] permutation) throws ClusException {
        ClusSchema schema = this.m_data.getSchema();
        int M = 0;
        int N = this.m_data.getNbRows();
        if (this.splitIndex > 0) {
            N = this.splitIndex;
        } else {
            M = -this.splitIndex;
        }
        double[][] upsum = new double[schema.getNbTargetAttributes()][N];
        double[][] upsum1 = new double[schema.getNbTargetAttributes()][N];
        double[][] downsum1 = new double[schema.getNbTargetAttributes()][N];
        double[][] downsum2 = new double[schema.getNbTargetAttributes()][N];
        double[][] ik = new double[schema.getNbTargetAttributes()][N];
        double[] downsum = new double[schema.getNbTargetAttributes()];
        double[] means = new double[schema.getNbTargetAttributes()];
        double[] ikk = new double[schema.getNbTargetAttributes()];
        int k = 0;
        while (k < schema.getNbTargetAttributes()) {
            for (int i = M; i < N; ++i) {
                NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k];
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNominal(exi);
                int n = k;
                means[n] = means[n] + xi;
            }
            int n = k++;
            means[n] = means[n] / (double)(N - M);
        }
        double avgik = 0.0;
        double[] W = new double[N];
        for (int k2 = 0; k2 < schema.getNbTargetAttributes(); ++k2) {
            int i;
            NominalAttrType type = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target)[k2];
            for (i = M; i < N; ++i) {
                DataTuple exi = this.m_data.getTuple(permutation[i]);
                double xi = ((ClusAttrType)type).getNominal(exi);
                for (int j = M; j < N; ++j) {
                    long indexMap;
                    DataTuple exj = this.m_data.getTuple(permutation[j]);
                    double xj = ((ClusAttrType)type).getNominal(exj);
                    double w = 0.0;
                    long indexI = permutation[i].intValue();
                    long indexJ = permutation[j].intValue();
                    if (permutation[i] == permutation[j]) continue;
                    if (permutation[i] > permutation[j]) {
                        indexI = permutation[j].intValue();
                        indexJ = permutation[i].intValue();
                    }
                    w = GISHeuristic.m_distances.get(indexMap = indexI * (long)(N - M) + indexJ) != null ? GISHeuristic.m_distances.get(indexMap) : 0.0;
                    double[] dArray = upsum1[k2];
                    int n = permutation[i];
                    dArray[n] = dArray[n] + w * xj;
                    double[] dArray2 = downsum1[k2];
                    int n2 = permutation[i];
                    dArray2[n2] = dArray2[n2] + w * w;
                    int n3 = permutation[i];
                    W[n3] = W[n3] + w;
                }
                upsum[k2][permutation[i].intValue()] = upsum1[k2][permutation[i]] - means[k2] * W[permutation[i]];
                int n = k2;
                downsum[n] = downsum[n] + (xi - means[k2]) * (xi - means[k2]);
                downsum2[k2][permutation[i].intValue()] = (double)(N - M) * downsum1[k2][permutation[i]] - W[permutation[i]] * W[permutation[i]];
            }
            for (i = M; i < N; ++i) {
                if (downsum[k2] != 0.0 && upsum[k2][permutation[i]] != 0.0 && downsum2[k2][permutation[i]] != 0.0) {
                    ik[k2][permutation[i].intValue()] = upsum[k2][permutation[i]] / Math.sqrt(downsum[k2] / (double)((N - M) * (N - M - 1)) * downsum2[k2][permutation[i]]);
                    int n = k2;
                    ikk[n] = ikk[n] + ik[k2][permutation[i]];
                    continue;
                }
                ikk[k2] = 0.0;
            }
            avgik += ikk[k2];
        }
        double I = avgik /= (double)schema.getNbTargetAttributes();
        if (Double.isNaN(I)) {
            throw new ClusException("err!");
        }
        return I;
    }

    public double getCalcItotal() {
        return this.m_I;
    }

    public void setCalcItotal(double ii) {
        this.m_I = ii;
    }

    public class Distance {
        double index;
        double target;
        double distance;

        Distance(double index, double target, double distance) {
            this.index = index;
            this.target = target;
            this.distance = distance;
        }
    }

    public class DistanceB {
        double index;
        double target1;
        double target2;
        double distance;

        DistanceB(double index, double target1, double target2, double distance) {
            this.index = index;
            this.target1 = target1;
            this.target2 = target2;
            this.distance = distance;
        }
    }
}

