/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.statistic;

import java.util.ArrayList;
import si.ijs.kt.clus.data.cols.ColTarget;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.ext.ensemble.ClusOOBWeights;
import si.ijs.kt.clus.ext.ensemble.ros.ClusROSForestInfo;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.StatisticPrintInfo;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.jeans.list.BitList;

public class BitVectorStat
extends ClusStatistic {
    public static final long serialVersionUID = 1L;
    protected BitList m_Bits = new BitList();
    protected boolean m_Modified = true;
    private BitVectorStat m_ParentStat;

    public BitVectorStat(Settings sett) {
        super(sett);
    }

    @Override
    public ClusStatistic cloneStat() {
        BitVectorStat stat = new BitVectorStat(this.m_Settings);
        stat.cloneFrom(this);
        return stat;
    }

    public void cloneFrom(BitVectorStat other) {
    }

    @Override
    public void setSDataSize(int nbex) {
        this.m_Bits.resize(nbex);
        this.m_Modified = true;
    }

    @Override
    public void update(ColTarget target, int idx) {
        System.err.println("BitVectorStat: this version of update not implemented");
    }

    @Override
    public void updateWeighted(DataTuple tuple, int idx) {
        this.m_SumWeight += tuple.getWeight();
        this.m_Bits.setBit(idx);
        this.m_Modified = true;
    }

    @Override
    public void calcMean() throws ClusException {
    }

    @Override
    public String getArrayOfStatistic() {
        return "[" + String.valueOf(this.m_SumWeight) + "]";
    }

    @Override
    public String getString(StatisticPrintInfo info) {
        return String.valueOf(this.m_SumWeight);
    }

    @Override
    public void reset() {
        this.m_SumWeight = 0.0;
        this.m_Bits.reset();
        this.m_Modified = true;
    }

    @Override
    public void copy(ClusStatistic other) {
        BitVectorStat or = (BitVectorStat)other;
        this.m_SumWeight = or.m_SumWeight;
        this.m_Bits.copy(or.m_Bits);
        this.m_Modified = or.m_Modified;
    }

    @Override
    public void addPrediction(ClusStatistic other, double weight) {
        System.err.println("BitVectorStat: addPrediction not implemented");
    }

    @Override
    public void add(ClusStatistic other) {
        BitVectorStat or = (BitVectorStat)other;
        this.m_SumWeight += or.m_SumWeight;
        this.m_Bits.add(or.m_Bits);
        this.m_Modified = true;
    }

    @Override
    public void addScaled(double scale, ClusStatistic other) {
        System.err.println("BitVectorStat: addScaled not implemented");
    }

    @Override
    public void subtractFromThis(ClusStatistic other) {
        BitVectorStat or = (BitVectorStat)other;
        this.m_SumWeight -= or.m_SumWeight;
        this.m_Bits.subtractFromThis(or.m_Bits);
        this.m_Modified = true;
    }

    @Override
    public void subtractFromOther(ClusStatistic other) {
        BitVectorStat or = (BitVectorStat)other;
        this.m_SumWeight = or.m_SumWeight - this.m_SumWeight;
        this.m_Bits.subtractFromOther(or.m_Bits);
        this.m_Modified = true;
    }

    public int getNbTuples() {
        return this.m_Bits.getNbOnes();
    }

    @Override
    public double[] getNumericPred() {
        System.err.println("BitVectorStat: getNumericPred not implemented");
        return null;
    }

    @Override
    public int[] getNominalPred() {
        System.err.println("BitVectorStat: getNominalPred not implemented");
        return null;
    }

    @Override
    public String getPredictedClassName(int idx) {
        return "";
    }

    @Override
    public void vote(ArrayList<ClusStatistic> votes) {
        throw new RuntimeException("si.ijs.kt.clus.statistic.BitVectorStat.vote(ArrayList<ClusStatistic>) not implemented");
    }

    @Override
    public void vote(ArrayList<ClusStatistic> votes, ClusROSForestInfo ROSForestInfo) {
        throw new RuntimeException("si.ijs.kt.clus.statistic.BitVectorStat.vote(ArrayList<ClusStatistic>, ClusROSForestInfo) not implemented");
    }

    @Override
    public void vote(ArrayList<ClusStatistic> votes, ClusOOBWeights weights) {
        throw new RuntimeException("si.ijs.kt.clus.statistic.BitVectorStat.vote(ArrayList<ClusStatistic>, ArrayList<Double>) not implemented");
    }

    @Override
    public void vote(ArrayList<ClusStatistic> votes, ClusOOBWeights weights, ClusROSForestInfo ROSForestInfo) {
        throw new RuntimeException("si.ijs.kt.clus.statistic.BitVectorStat.vote(ArrayList<ClusStatistic>, ArrayList<Double>, ClusROSForestInfo) not implemented");
    }

    @Override
    public int getNbStatisticComponents() {
        throw new RuntimeException("BitVectorStat: getNbStatisticComponents() not implemented.");
    }

    @Override
    public void setParentStat(ClusStatistic parent) {
        this.m_ParentStat = (BitVectorStat)parent;
    }

    @Override
    public ClusStatistic getParentStat() {
        return this.m_ParentStat;
    }

    @Override
    public double getTargetSumWeights() {
        return this.getTotalWeight();
    }
}

