/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.selection;

import java.util.Random;
import si.ijs.kt.clus.selection.XValGroup;
import si.ijs.kt.clus.selection.XValMainSelection;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.ClusRandom;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.jeans.util.array.MyIntArray;

public class XValRandomSelection
extends XValMainSelection {
    protected int[] m_Selection;
    protected Random m_Random;

    public XValRandomSelection(int nbtot, int folds) throws ClusException {
        this(nbtot, folds, ClusRandom.getRandom(1));
    }

    public XValRandomSelection(int nbtot, int folds, Random random) throws ClusException {
        super(folds, nbtot);
        if (folds == nbtot) {
            this.createLeaveOneOutXVAL(nbtot);
        } else {
            this.createRegularXVAL(nbtot, folds, random);
        }
    }

    @Override
    public int getFold(int row) {
        return this.m_Selection[row];
    }

    public void printDebug() {
        ClusLogger.info("XVAL: " + MyIntArray.print(this.m_Selection));
    }

    public void createLeaveOneOutXVAL(int nbtot) {
        this.m_Selection = new int[nbtot];
        for (int i = 0; i < nbtot; ++i) {
            this.m_Selection[i] = i;
        }
    }

    public void createRegularXVAL(int nbtot, int folds, Random random) throws ClusException {
        int ok;
        this.m_Random = random;
        int max = nbtot / folds;
        XValGroup[] grps = new XValGroup[folds];
        for (int i = 0; i < folds; ++i) {
            grps[i] = new XValGroup(max + 1);
        }
        int from = this.devide2(grps, 0, nbtot, max);
        if (from != -1 && (ok = this.devide2(grps, from, nbtot, max + 1)) != -1) {
            throw new ClusException("Error partitioning xval data");
        }
        this.m_Selection = new int[nbtot];
        for (int i = 0; i < folds; ++i) {
            XValGroup gr = grps[i];
            for (int j = 0; j < gr.getNbElements(); ++j) {
                this.m_Selection[gr.getElement((int)j)] = i;
            }
        }
    }

    public int devide2(XValGroup[] grps, int from, int till, int max) {
        while (from < till) {
            int grp = this.m_Random.nextInt(grps.length);
            if (this.add_to_group(from, grps, grp, max)) {
                ++from;
                continue;
            }
            return from;
        }
        return -1;
    }

    public boolean add_to_group(int from, XValGroup[] grps, int grp, int max) {
        int nbg = grps.length;
        for (int ctr = 0; ctr < nbg; ++ctr) {
            XValGroup gr = grps[grp];
            if (gr.add(from, max)) {
                return true;
            }
            grp = (grp + 1) % nbg;
        }
        return false;
    }
}

