/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.selection;

import java.util.Random;
import si.ijs.kt.clus.selection.ClusSelection;

public class RandomSelection
extends ClusSelection {
    protected int m_NbSelected;
    protected boolean[] m_Selection;
    int m_Seed;

    public RandomSelection(int nbrows, double sel) {
        super(nbrows);
        this.m_Seed = 0;
        this.makeSelection(nbrows, (int)Math.round(sel * (double)nbrows));
    }

    public RandomSelection(int nbrows, int nbsel) {
        super(nbrows);
        this.m_Seed = 0;
        this.makeSelection(nbrows, nbsel);
    }

    public RandomSelection(int nbrows, double sel, int randomSeed) {
        super(nbrows);
        this.m_Seed = randomSeed;
        this.makeSelection(nbrows, (int)Math.round(sel * (double)nbrows));
    }

    public RandomSelection(int nbrows, int nbsel, int randomSeed) {
        super(nbrows);
        this.m_Seed = randomSeed;
        this.makeSelection(nbrows, nbsel);
    }

    public void setRandomSeed(int seed) {
        this.m_Seed = seed;
    }

    @Override
    public int getNbSelected() {
        return this.m_NbSelected;
    }

    @Override
    public boolean isSelected(int row) {
        return this.m_Selection[row];
    }

    private final void makeSelection(int nbrows, int nbsel) {
        this.m_NbSelected = nbsel;
        this.m_Selection = new boolean[nbrows];
        Random rnd = new Random(this.m_Seed);
        for (int i = 0; i < this.m_NbSelected; ++i) {
            int p = rnd.nextInt(nbrows - i) + 1;
            for (int j = 0; p > 0 && j < nbrows; ++j) {
                if (this.m_Selection[j] || --p != 0) continue;
                this.m_Selection[j] = true;
            }
        }
    }
}

