/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.pruning;

import java.util.ArrayList;
import si.ijs.kt.clus.algo.tdidt.ClusNode;
import si.ijs.kt.clus.data.attweights.ClusAttributeWeights;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.error.common.ClusError;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.pruning.PruneTree;
import si.ijs.kt.clus.pruning.TreeErrorComputer;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.jeans.io.MyFile;

public class SequencePruningVSB
extends PruneTree {
    protected RowData m_VSB;
    protected ClusErrorList m_Error;
    protected ClusAttributeWeights m_Weights;
    protected PruneTree m_SeqPruner;
    protected boolean m_1SERule;
    protected boolean m_HasMissing;
    protected String m_Output;

    public SequencePruningVSB(RowData data, ClusAttributeWeights weights) {
        this.m_VSB = data;
        this.m_Weights = weights;
        this.m_HasMissing = true;
    }

    @Override
    public int getNbResults() {
        return 1;
    }

    public void setSequencePruner(PruneTree pruner) {
        this.m_SeqPruner = pruner;
        this.m_Error = pruner.createErrorMeasure(this.m_VSB, this.m_Weights);
    }

    public PruneTree getSequencePruner() {
        return this.m_SeqPruner;
    }

    public static void resize(ArrayList list, int size) {
        if (size > list.size()) {
            list.ensureCapacity(size);
            int nb_add = size - list.size();
            for (int i = 0; i < nb_add; ++i) {
                list.add(null);
            }
        }
    }

    public void setOutputFile(String output) {
        this.m_Output = output;
    }

    public void set1SERule(boolean enable) {
        this.m_1SERule = enable;
    }

    public void setHasMissing(boolean missing) {
        this.m_HasMissing = missing;
    }

    @Override
    public void prune(ClusNode node) throws ClusException {
        PruneTree pruner = this.getSequencePruner();
        pruner.sequenceInitialize(node);
        ArrayList<ClusError> vsb_errors = new ArrayList<ClusError>();
        ArrayList<Double> train_errors = new ArrayList<Double>();
        ArrayList<Integer> sizes = new ArrayList<Integer>();
        int max_idx = -1;
        boolean done = false;
        pruner.sequenceReset();
        while (!done) {
            ClusNode pruned = pruner.sequenceNext();
            if (pruned == null) {
                done = true;
                continue;
            }
            SequencePruningVSB.resize(vsb_errors, ++max_idx + 1);
            SequencePruningVSB.resize(train_errors, max_idx + 1);
            SequencePruningVSB.resize(sizes, max_idx + 1);
            ClusError vsb_err = TreeErrorComputer.computeClusteringErrorStandard(pruned, this.m_VSB, this.m_Error);
            vsb_errors.set(max_idx, vsb_err);
            train_errors.set(max_idx, new Double(pruned.estimateClusteringSS(this.m_Weights)));
            sizes.set(max_idx, new Integer(pruned.getNbNodes()));
        }
        int best_idx = 0;
        double min_error = Double.POSITIVE_INFINITY;
        for (int idx = 0; idx <= max_idx; ++idx) {
            ClusError error = (ClusError)vsb_errors.get(idx);
            double value = error.getModelError();
            if (!(value <= min_error)) continue;
            min_error = value;
            best_idx = idx;
        }
        ClusError best_error = (ClusError)vsb_errors.get(best_idx);
        double se = best_error.getModelErrorStandardError();
        int se1_idx = 0;
        for (int idx = 0; idx <= max_idx; ++idx) {
            ClusError error = (ClusError)vsb_errors.get(idx);
            double value = error.getModelError();
            if (!(value <= min_error + se)) continue;
            se1_idx = idx;
        }
        if (se1_idx == -1) {
            se1_idx = best_idx;
        }
        if (this.m_Output != null) {
            MyFile log = new MyFile(this.m_Output);
            for (int idx = 0; idx <= max_idx; ++idx) {
                ClusError error = (ClusError)vsb_errors.get(idx);
                double value = error.getModelError();
                log.log(sizes.get(idx).toString() + "\t" + train_errors.get(idx) + "\t" + String.valueOf(value));
            }
            log.close();
        }
        if (this.m_1SERule) {
            pruner.sequenceToElemK(node, se1_idx);
        } else {
            pruner.sequenceToElemK(node, best_idx);
        }
    }
}

