/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.model.test;

import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.model.test.InverseNumericTest;
import si.ijs.kt.clus.model.test.NodeTest;
import si.ijs.kt.clus.util.ClusRandom;

public class NumericTest
extends NodeTest {
    protected double m_Bound;
    protected NumericAttrType m_Type;
    public static final long serialVersionUID = 1L;

    public NumericTest(ClusAttrType attr, double bound, double posfreq) {
        this.m_Type = (NumericAttrType)attr;
        this.m_Bound = bound;
        this.setArity(2);
        this.setPosFreq(posfreq);
    }

    public NumericTest(ClusAttrType attr) {
        this(attr, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
    }

    public boolean isInverseNumeric() {
        return false;
    }

    public final int getAttrIndex() {
        return this.m_Type.getArrayIndex();
    }

    public final NumericAttrType getNumType() {
        return this.m_Type;
    }

    public final double getBound() {
        return this.m_Bound;
    }

    public final void setBound(double bound) {
        this.m_Bound = bound;
    }

    @Override
    public ClusAttrType getType() {
        return this.m_Type;
    }

    @Override
    public void setType(ClusAttrType type) {
        this.m_Type = (NumericAttrType)type;
    }

    @Override
    public String getString() {
        return this.getStringWithPrefix(this.m_Type.getName());
    }

    public String getStringWithPrefix(String prefix) {
        String value = this.m_Bound != Double.NEGATIVE_INFINITY ? String.valueOf(this.m_Bound) : "?";
        return prefix + " > " + value;
    }

    @Override
    public String getPythonString(String xsElement) {
        return this.getStringWithPrefix(xsElement);
    }

    @Override
    public boolean hasConstants() {
        return this.m_Bound != Double.NEGATIVE_INFINITY;
    }

    @Override
    public boolean equals(NodeTest test) {
        if (this.m_Type != test.getType()) {
            return false;
        }
        NumericTest ntest = (NumericTest)test;
        if (this.isInverseNumeric() != ntest.isInverseNumeric()) {
            return false;
        }
        return this.m_Bound == ntest.m_Bound;
    }

    @Override
    public int hashCode() {
        long v = Double.doubleToLongBits(this.m_Bound);
        return this.m_Type.getIndex() + (int)(v ^ v >>> 32);
    }

    @Override
    public int softEquals(NodeTest test) {
        if (this.m_Type != test.getType()) {
            return 0;
        }
        NumericTest ntest = (NumericTest)test;
        if (this.m_Bound == ntest.m_Bound) {
            return 2;
        }
        if (Math.abs(this.getPosFreq() - ntest.getPosFreq()) < 0.1) {
            return 1;
        }
        return 0;
    }

    @Override
    public int numericPredict(double value) {
        if (value == Double.POSITIVE_INFINITY) {
            return ClusRandom.nextDouble(0) < this.getPosFreq() ? 0 : 1;
        }
        return value > this.m_Bound ? 0 : 1;
    }

    @Override
    public int numericPredictWeighted(double value) {
        if (value == Double.POSITIVE_INFINITY) {
            return this.hasUnknownBranch() ? 2 : -1;
        }
        return value > this.m_Bound ? 0 : 1;
    }

    @Override
    public int predictWeighted(DataTuple tuple) {
        double val = this.m_Type.getNumeric(tuple);
        return this.numericPredictWeighted(val);
    }

    @Override
    public NodeTest getBranchTest(int i) {
        if (i == 0) {
            return this;
        }
        return new InverseNumericTest(this.m_Type, this.getBound(), 1.0 - this.getPosFreq());
    }

    @Override
    public NodeTest simplifyConjunction(NodeTest other) {
        if (this.getType().getIndex() != other.getType().getIndex()) {
            return null;
        }
        NumericTest onum = (NumericTest)other;
        if (this.isInverseNumeric() != onum.isInverseNumeric()) {
            return null;
        }
        double pos_freq = Math.min(this.getPosFreq(), onum.getPosFreq());
        if (this.isInverseNumeric()) {
            double new_bound = Math.min(this.getBound(), onum.getBound());
            return new InverseNumericTest(this.m_Type, new_bound, pos_freq);
        }
        double new_bound = Math.max(this.getBound(), onum.getBound());
        return new NumericTest(this.m_Type, new_bound, pos_freq);
    }
}

