/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.model.test;

import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.model.test.NodeTest;
import si.ijs.kt.clus.model.test.SubsetTest;
import si.ijs.kt.clus.util.ClusRandom;
import si.ijs.kt.clus.util.jeans.util.sort.DoubleIndexSorter;

public class NominalTest
extends NodeTest {
    public static final long serialVersionUID = 1L;
    protected NominalAttrType m_Type;
    protected double[] m_Sorted;
    protected int[] m_Index;

    public NominalTest(NominalAttrType type, double[] freq) {
        this.m_Type = type;
        this.setProportion(freq);
    }

    @Override
    public ClusAttrType getType() {
        return this.m_Type;
    }

    @Override
    public void setType(ClusAttrType type) {
        this.m_Type = (NominalAttrType)type;
    }

    @Override
    public String getString() {
        if (this.m_Type.getNbValues() > 2) {
            return this.m_Type.getName();
        }
        String val = this.m_Type.getValue(0);
        if (this.hasBranchLabels()) {
            return this.m_Type.getName();
        }
        return this.m_Type.getName() + " = " + val;
    }

    @Override
    public String getPythonString(String xsElement) {
        if (this.m_Type.getNbValues() > 2) {
            return xsElement;
        }
        String val = this.m_Type.getValue(0);
        if (this.hasBranchLabels()) {
            return xsElement;
        }
        return xsElement + " == '" + val + "'";
    }

    @Override
    public boolean equals(NodeTest test) {
        return this.m_Type == test.getType();
    }

    @Override
    public int hashCode() {
        return this.m_Type.getIndex();
    }

    @Override
    public void preprocess(int mode) {
        DoubleIndexSorter sorter = DoubleIndexSorter.getInstance();
        this.m_Sorted = DoubleIndexSorter.arrayclone(this.m_BranchFreq);
        sorter.setData(this.m_Sorted);
        sorter.sort();
        this.m_Index = sorter.getIndex();
    }

    @Override
    public int predictWeighted(DataTuple tuple) {
        int val = this.m_Type.getNominal(tuple);
        return this.nominalPredictWeighted(val);
    }

    @Override
    public int nominalPredict(int value) {
        int arity = this.getNbChildren();
        if (value == arity) {
            double cumul = 0.0;
            double val = ClusRandom.nextDouble(0);
            for (int i = 0; i < arity - 1; ++i) {
                if (!(val < (cumul += this.m_Sorted[i]))) continue;
                return this.m_Index[i];
            }
            return this.m_Index[arity - 1];
        }
        return value;
    }

    @Override
    public int nominalPredictWeighted(int value) {
        if (value == this.getNbChildren()) {
            return this.hasUnknownBranch() ? 2 : -1;
        }
        return value;
    }

    @Override
    public boolean hasBranchLabels() {
        return true;
    }

    @Override
    public String getBranchLabel(int i) {
        return this.m_Type.getValue(i);
    }

    @Override
    public String getBranchString(int i) {
        return this.m_Type.getName() + " = " + this.m_Type.getValue(i);
    }

    @Override
    public NodeTest getBranchTest(int i) {
        SubsetTest test = new SubsetTest(this.m_Type, 1);
        test.setValue(0, i);
        test.setPosFreq(this.getProportion(i));
        return test;
    }
}

