/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.model.test;

import java.io.Serializable;
import java.util.HashMap;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.main.settings.section.SettingsOutput;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.format.ClusFormat;

public abstract class NodeTest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int UNKNOWN = -1;
    public static final int N_EQ = 0;
    public static final int S_EQ = 1;
    public static final int H_EQ = 2;
    @Deprecated
    private boolean m_UnknownBranch;
    private double m_UnknownFreq;
    public double[] m_BranchFreq;
    private double m_HeuristicValue;

    public final boolean hasUnknownBranch() {
        return this.m_UnknownBranch;
    }

    public abstract int predictWeighted(DataTuple var1);

    public int nominalPredict(int value) {
        return -1;
    }

    public int numericPredict(double value) {
        return -1;
    }

    public int nominalPredictWeighted(int value) {
        return -1;
    }

    public int numericPredictWeighted(double value) {
        return -1;
    }

    public boolean isUnknown(DataTuple tuple) {
        return this.getType().isMissing(tuple);
    }

    public final double[] getProportions() {
        return this.m_BranchFreq;
    }

    public final double getProportion(int branch) {
        return this.m_BranchFreq[branch];
    }

    public final void setProportion(int branch, double prop) {
        this.m_BranchFreq[branch] = prop;
    }

    public final void setProportion(double[] prop) {
        this.m_BranchFreq = prop;
    }

    public final void setPosFreq(double prop) {
        this.m_BranchFreq[0] = prop;
        this.m_BranchFreq[1] = 1.0 - prop;
    }

    public final double getPosFreq() {
        return this.m_BranchFreq[0];
    }

    public final double getUnknownFreq() {
        return this.m_UnknownFreq;
    }

    public final void setUnknownFreq(double unk) {
        this.m_UnknownFreq = unk;
    }

    public final boolean isBinary() {
        return this.m_BranchFreq.length == 2;
    }

    public final int getNbChildren() {
        return this.m_BranchFreq.length;
    }

    public final void setArity(int arity) {
        this.m_BranchFreq = new double[arity];
    }

    public final int updateArity() {
        return this.getNbChildren();
    }

    public void preprocess(int mode) {
    }

    public boolean isSoft() {
        return false;
    }

    public int softEquals(NodeTest test) {
        return this.equals(test) ? 2 : 0;
    }

    public boolean hasConstants() {
        return true;
    }

    public NodeTest getBranchTest(int i) {
        return null;
    }

    public NodeTest simplifyConjunction(NodeTest other) {
        return null;
    }

    public abstract boolean equals(NodeTest var1);

    public int hashCode() {
        return 1111;
    }

    public abstract ClusAttrType getType();

    public abstract void setType(ClusAttrType var1);

    public abstract String getString();

    public abstract String getPythonString(String var1);

    public String getBranchString(int i) {
        return null;
    }

    public String getBranchLabel(int i) {
        return this.getBranchString(i);
    }

    public boolean hasBranchLabels() {
        return false;
    }

    public void setHeuristicValue(double value) {
        this.m_HeuristicValue = value;
    }

    public double getHeuristicValue() {
        return this.m_HeuristicValue;
    }

    public final void attachModel(HashMap table) throws ClusException {
        ClusAttrType type = this.getType();
        ClusAttrType ntype = (ClusAttrType)table.get(type.getName());
        if (ntype == null) {
            throw new ClusException("Attribute " + type.getName() + " not in dataset");
        }
        ClusAttrType ctype = type.cloneType();
        ctype.copyArrayIndex(ntype);
        this.setType(ctype);
    }

    public int getNbLines() {
        return 1;
    }

    public String getLine(int i) {
        return this.getString();
    }

    public final String getTestString() {
        String str = this.getString();
        if (SettingsOutput.SHOW_BRANCH_FREQ && this.getPosFreq() != Double.NEGATIVE_INFINITY) {
            String bfr = ClusFormat.ONE_AFTER_DOT.format(this.getPosFreq() * 100.0);
            str = str + " (" + bfr + "%)";
        }
        if (SettingsOutput.SHOW_UNKNOWN_FREQ) {
            String unk = ClusFormat.ONE_AFTER_DOT.format(this.getUnknownFreq() * 100.0);
            str = str + " (miss: " + unk + "%)";
        }
        return str;
    }

    public final String getPythonTestString(String xsElement) {
        String str = this.getPythonString(xsElement);
        if (SettingsOutput.SHOW_BRANCH_FREQ && this.getPosFreq() != Double.NEGATIVE_INFINITY) {
            String bfr = ClusFormat.ONE_AFTER_DOT.format(this.getPosFreq() * 100.0);
            str = str + " (" + bfr + "%)";
        }
        if (SettingsOutput.SHOW_UNKNOWN_FREQ) {
            String unk = ClusFormat.ONE_AFTER_DOT.format(this.getUnknownFreq() * 100.0);
            str = str + " (miss: " + unk + "%)";
        }
        return str;
    }

    public final String getTestString(int idx) {
        String str = this.getBranchString(idx);
        if (SettingsOutput.SHOW_BRANCH_FREQ) {
            String bfr = ClusFormat.ONE_AFTER_DOT.format(this.getProportion(idx) * 100.0);
            str = str + " (" + bfr + "%)";
        }
        if (idx == 0 && SettingsOutput.SHOW_UNKNOWN_FREQ) {
            String unk = ClusFormat.ONE_AFTER_DOT.format(this.getUnknownFreq() * 100.0);
            str = str + " (miss:" + unk + "%)";
        }
        return str;
    }

    public final String toString() {
        return this.getString();
    }
}

