/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.model.test;

import java.text.NumberFormat;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.model.test.NodeTest;
import si.ijs.kt.clus.model.test.NumericTest;
import si.ijs.kt.clus.util.ClusRandom;

public class InverseNumericTest
extends NumericTest {
    public static final long serialVersionUID = 1L;

    public InverseNumericTest(ClusAttrType attr, double bound, double posfreq) {
        super(attr, bound, posfreq);
    }

    @Override
    public String getString() {
        String value = this.m_Bound != Double.NEGATIVE_INFINITY ? NumberFormat.getInstance().format(this.m_Bound) : "?";
        return this.m_Type.getName() + " <= " + value;
    }

    @Override
    public boolean isInverseNumeric() {
        return true;
    }

    @Override
    public int hashCode() {
        long v = Double.doubleToLongBits(this.m_Bound);
        return this.m_Type.getIndex() + (int)(v ^ v >>> 32) + 1;
    }

    @Override
    public int numericPredict(double value) {
        if (value == Double.POSITIVE_INFINITY) {
            return ClusRandom.nextDouble(0) < this.getPosFreq() ? 0 : 1;
        }
        return value <= this.m_Bound ? 0 : 1;
    }

    @Override
    public int numericPredictWeighted(double value) {
        if (value == Double.POSITIVE_INFINITY) {
            return this.hasUnknownBranch() ? 2 : -1;
        }
        return value <= this.m_Bound ? 0 : 1;
    }

    @Override
    public int predictWeighted(DataTuple tuple) {
        double val = this.m_Type.getNumeric(tuple);
        return this.numericPredictWeighted(val);
    }

    @Override
    public NodeTest getBranchTest(int i) {
        if (i == 0) {
            return this;
        }
        return new NumericTest(this.m_Type, this.getBound(), 1.0 - this.getPosFreq());
    }
}

