/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.model.test;

import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.model.test.NodeTest;

public class ClusRuleConstraintInduceTest
extends NodeTest {
    protected double m_Bound;
    protected NumericAttrType m_Type;
    protected boolean smallerThan;
    public static final long serialVersionUID = 1L;

    public ClusRuleConstraintInduceTest(ClusAttrType attr, double bound, boolean test) {
        this.m_Type = (NumericAttrType)attr;
        this.m_Bound = bound;
        this.setArity(2);
        this.smallerThan = test;
    }

    public boolean isSmallerThanTest() {
        return this.smallerThan;
    }

    public boolean isInverseNumeric() {
        return false;
    }

    public final int getAttrIndex() {
        return this.m_Type.getArrayIndex();
    }

    public final NumericAttrType getNumType() {
        return this.m_Type;
    }

    public final double getBound() {
        return this.m_Bound;
    }

    public final void setBound(double bound) {
        this.m_Bound = bound;
    }

    @Override
    public ClusAttrType getType() {
        return this.m_Type;
    }

    @Override
    public void setType(ClusAttrType type) {
        this.m_Type = (NumericAttrType)type;
    }

    @Override
    public String getString() {
        String value;
        String string = value = this.m_Bound != Double.NEGATIVE_INFINITY ? String.valueOf(this.m_Bound) : "?";
        if (this.smallerThan) {
            return this.m_Type.getName() + " < " + value;
        }
        return this.m_Type.getName() + " >= " + value;
    }

    @Override
    public String getPythonString(String xsElement) {
        return this.getString();
    }

    @Override
    public boolean hasConstants() {
        return this.m_Bound != Double.NEGATIVE_INFINITY;
    }

    @Override
    public boolean equals(NodeTest test) {
        if (this.m_Type != test.getType()) {
            return false;
        }
        ClusRuleConstraintInduceTest ntest = (ClusRuleConstraintInduceTest)test;
        return this.m_Bound == ntest.m_Bound && ntest.smallerThan == this.smallerThan;
    }

    @Override
    public int hashCode() {
        long v = Double.doubleToLongBits(this.m_Bound);
        return this.m_Type.getIndex() + (int)(v ^ v >>> 32);
    }

    @Override
    public int numericPredictWeighted(double value) {
        if (value == Double.POSITIVE_INFINITY) {
            return this.hasUnknownBranch() ? 2 : -1;
        }
        return value < this.m_Bound && this.smallerThan || value >= this.m_Bound && !this.smallerThan ? 0 : 1;
    }

    @Override
    public int predictWeighted(DataTuple tuple) {
        double val = this.m_Type.getNumeric(tuple);
        return this.numericPredictWeighted(val);
    }
}

