/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.model.processor;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.io.ARFFFile;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.model.processor.ClusModelProcessor;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.RegressionStatBase;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.format.ClusFormat;
import si.ijs.kt.clus.util.format.ClusNumberFormat;
import si.ijs.kt.clus.util.jeans.util.MyArray;
import si.ijs.kt.clus.util.jeans.util.StringUtils;

public class ClusEnsemblePredictionWriter
extends ClusModelProcessor {
    protected ClusSchema m_EnsPredSchema;
    protected Settings m_Sett;
    protected String m_Fname;
    protected MyArray m_Attrs;
    protected PrintWriter m_Writer;
    protected ArrayList<String> m_AttributeNames;
    protected int m_NbTargetAttributes;
    static int m_Type;
    protected double[] m_StDev;
    static ArrayList m_Votes;
    protected ClusNumberFormat m_Format = ClusFormat.FOUR_AFTER_DOT;
    boolean m_Initialized = false;

    public ClusEnsemblePredictionWriter(String fname) {
        this.m_Fname = fname;
        this.m_AttributeNames = new ArrayList();
    }

    public ClusEnsemblePredictionWriter(String fname, ClusSchema schema, Settings sett) {
        this.m_Fname = fname;
        this.m_AttributeNames = new ArrayList();
        this.m_NbTargetAttributes = schema.getNbTargetAttributes();
        this.m_Sett = sett;
        this.m_Initialized = true;
        try {
            this.doInitialize(schema);
            ARFFFile.writeArffHeader(this.m_Writer, this.m_EnsPredSchema);
            this.m_Writer.flush();
            this.addEnsPredHeader(schema);
            this.m_Writer.flush();
        }
        catch (Exception e) {
            System.err.println("Error while writing ensemble prediction header!");
        }
    }

    private void addEnsPredHeader(ClusSchema schema) throws ClusException {
        ClusAttrType at;
        int nb = schema.getNbAttributes();
        for (int i = 0; i < nb; ++i) {
            at = schema.getAttrType(i);
            if (!at.getStatus().equals((Object)ClusAttrType.Status.Target)) continue;
            this.m_Writer.print("@ATTRIBUTE ");
            this.m_Writer.print(StringUtils.printStr(at.getName() + "-pred", 65));
            at.writeARFFType(this.m_Writer);
            this.m_Writer.println();
        }
        for (int j = 0; j < nb; ++j) {
            at = schema.getAttrType(j);
            if (!at.getStatus().equals((Object)ClusAttrType.Status.Target)) continue;
            this.m_Writer.print("@ATTRIBUTE ");
            this.m_Writer.print(StringUtils.printStr(at.getName() + "-stdev", 65));
            at.writeARFFType(this.m_Writer);
            this.m_Writer.println();
        }
        this.m_Writer.println();
        this.m_Writer.print("@DATA");
        this.m_Writer.println();
    }

    private void doInitialize(ClusSchema schema) throws IOException, ClusException {
        ClusAttrType at;
        this.m_Attrs = new MyArray();
        int nb = schema.getNbAttributes();
        this.m_EnsPredSchema = new ClusSchema(StringUtils.removeSingleQuote(schema.getRelationName()) + "-pred-distr");
        this.m_EnsPredSchema.setSettings(schema.getSettings());
        for (int i = 0; i < nb; ++i) {
            at = schema.getAttrType(i);
            if (!at.getStatus().equals((Object)ClusAttrType.Status.Key)) continue;
            this.m_Attrs.addElement(at);
            this.m_AttributeNames.add(at.getName());
            this.m_EnsPredSchema.addAttrType(at.cloneType());
        }
        for (int j = 0; j < nb; ++j) {
            at = schema.getAttrType(j);
            if (!at.getStatus().equals((Object)ClusAttrType.Status.Target)) continue;
            this.m_Attrs.addElement(at);
            this.m_AttributeNames.add(at.getName());
            this.m_EnsPredSchema.addAttrType(at.cloneType());
        }
        this.m_Writer = this.m_Sett.getGeneric().getFileAbsoluteWriter(this.m_Fname);
    }

    public void writePredictionsForTuple(DataTuple tuple, ClusStatistic distr) {
        this.m_Writer.print(this.getRealValues(tuple) + ",");
        this.m_Writer.print(this.getPrediction(distr) + ",");
        String[] voting = this.processVotes(m_Votes);
        this.m_Writer.print(this.getPredictionStDev() + "\n");
        this.m_Writer.flush();
        for (int i = 0; i < this.m_NbTargetAttributes; ++i) {
            this.m_Writer.print("% Target = " + this.m_AttributeNames.get(i) + ": " + voting[i] + "\n");
            this.m_Writer.flush();
        }
    }

    private String getRealValues(DataTuple tuple) {
        String real = "";
        for (int j = 0; j < this.m_Attrs.size(); ++j) {
            if (j != 0) {
                real = real + ",";
            }
            ClusAttrType at = (ClusAttrType)this.m_Attrs.elementAt(j);
            real = real + at.getPredictionWriterString(tuple);
        }
        return real;
    }

    private String getPrediction(ClusStatistic distr) {
        String result = "";
        double[] pred = distr.getNumericPred();
        for (int i = 0; i < pred.length; ++i) {
            if (i != 0) {
                result = result + ",";
            }
            result = pred != null ? result + this.m_Format.format(pred[i]) : result + "?";
        }
        return result;
    }

    private String getPredictionStDev() {
        String result = "";
        for (int i = 0; i < this.m_StDev.length; ++i) {
            if (i != 0) {
                result = result + ",";
            }
            result = result + this.m_Format.format(this.m_StDev[i]);
        }
        return result;
    }

    private String[] processVotes(ArrayList votes) {
        String[] result = new String[this.m_NbTargetAttributes];
        this.m_StDev = new double[this.m_NbTargetAttributes];
        double[][] predicts = new double[this.m_NbTargetAttributes][votes.size()];
        for (int i = 0; i < votes.size(); ++i) {
            int j;
            RegressionStatBase stat = (RegressionStatBase)votes.get(i);
            if (i == 0) {
                for (j = 0; j < stat.getNbAttributes(); ++j) {
                    predicts[j][i] = stat.getMean(j);
                    result[j] = "" + this.m_Format.format(predicts[j][i]);
                }
                continue;
            }
            for (j = 0; j < stat.getNbAttributes(); ++j) {
                predicts[j][i] = stat.getMean(j);
                result[j] = result[j] + "," + this.m_Format.format(predicts[j][i]);
            }
        }
        this.m_StDev = ClusEnsemblePredictionWriter.calcStDev(predicts);
        return result;
    }

    private static double[] calcStDev(double[][] values) {
        double[] result = new double[values.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ClusEnsemblePredictionWriter.stDevOpt(values[i]);
        }
        return result;
    }

    private static double stDevOpt(double[] a) {
        double avg = 0.0;
        double summ = 0.0;
        for (int i = 0; i < a.length; ++i) {
            avg += a[i];
            summ += a[i] * a[i];
        }
        double sd = (summ - (double)a.length * (avg /= (double)a.length) * avg) / (double)(a.length - 1);
        return Math.sqrt(sd);
    }

    public static int getType() {
        return m_Type;
    }

    public static void setType(int type) {
        m_Type = type;
    }

    public void closeWriter() {
        ClusLogger.info("Ensemble predictions written in " + this.m_Fname);
        this.m_Writer.flush();
        this.m_Writer.close();
    }

    public static void setVotes(ArrayList votes) {
        m_Votes = votes;
    }

    public void printVotes() {
        ClusLogger.info("Votes: " + m_Votes);
    }

    public boolean isInitialized() {
        return this.m_Initialized;
    }

    static {
        m_Votes = new ArrayList();
    }
}

