/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.model.processor;

import java.io.IOException;
import si.ijs.kt.clus.algo.tdidt.ClusNode;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.model.processor.ClusModelProcessor;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.jeans.tree.CompleteTreeIterator;

public class CalcStatisticProcessor
extends ClusModelProcessor {
    ClusStatistic m_Clone;

    public CalcStatisticProcessor(ClusStatistic clone) {
        this.m_Clone = clone;
    }

    @Override
    public boolean needsModelUpdate() {
        return true;
    }

    @Override
    public boolean needsInternalNodes() {
        return true;
    }

    @Override
    public void initialize(ClusModel model, ClusSchema schema) {
        CompleteTreeIterator iter = new CompleteTreeIterator((ClusNode)model);
        while (iter.hasMoreNodes()) {
            ClusNode node = (ClusNode)iter.getNextNode();
            ClusStatistic stat = this.m_Clone.cloneStat();
            node.setClusteringStat(stat);
            stat.setSDataSize(1);
        }
    }

    @Override
    public void terminate(ClusModel model) throws IOException, ClusException {
        CompleteTreeIterator iter = new CompleteTreeIterator((ClusNode)model);
        while (iter.hasMoreNodes()) {
            ClusNode node = (ClusNode)iter.getNextNode();
            node.getClusteringStat().calcMean();
        }
    }

    @Override
    public void modelUpdate(DataTuple tuple, ClusModel model) {
        ClusNode node = (ClusNode)model;
        node.getClusteringStat().updateWeighted(tuple, 0);
    }
}

