/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.model.io;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Arrays;
import si.ijs.kt.clus.algo.tdidt.ClusNode;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.model.test.NominalTest;
import si.ijs.kt.clus.model.test.NumericTest;
import si.ijs.kt.clus.model.test.SubsetTest;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.jeans.util.MStringTokenizer;

public class ClusTreeReader {
    public static final String[] YESNO = new String[]{"yes", "no"};
    String m_FName;
    ClusSchema m_Schema;
    LineNumberReader m_Reader;
    MStringTokenizer m_Tokens = ClusTreeReader.createTokenizer();
    int m_StartLine;
    int m_CrLine;
    int m_PushBack;
    boolean m_IsReading;
    boolean m_NoPartialTree;
    ArrayList m_Lines;
    ArrayList m_StartPos;
    String m_LineAfterTree;

    public ClusNode loadTree(String fname, ClusSchema schema) throws IOException {
        this.m_FName = fname;
        this.m_Schema = schema;
        ClusLogger.info("Loading constraint file: " + fname);
        LineNumberReader rdr = new LineNumberReader(new InputStreamReader(new FileInputStream(fname)));
        String line = rdr.readLine();
        while (line != null && ClusTreeReader.isSkipLine(line)) {
            line = rdr.readLine();
        }
        ClusNode root = null;
        if (line != null) {
            root = this.readTree(line, rdr);
        }
        if ((line = ClusTreeReader.getFirstNonEmptyLine(rdr)) != null) {
            this.createError("Extra data after tree '" + line + "'");
        }
        rdr.close();
        return root;
    }

    public ClusNode loadOutTree(String fname, ClusSchema schema, String find) throws IOException {
        this.m_FName = fname;
        this.m_Schema = schema;
        this.m_NoPartialTree = true;
        ClusLogger.info("Loading .out file: " + fname);
        LineNumberReader rdr = new LineNumberReader(new InputStreamReader(new FileInputStream(fname)));
        String line = rdr.readLine();
        while (line != null && !line.trim().equals(find)) {
            line = rdr.readLine();
        }
        line = rdr.readLine();
        line = rdr.readLine();
        while (line != null && ClusTreeReader.isSkipLine(line)) {
            line = rdr.readLine();
        }
        ClusNode root = null;
        if (line != null) {
            root = this.readTree(line, rdr);
        }
        this.m_LineAfterTree = line = ClusTreeReader.getFirstNonEmptyLine(rdr);
        rdr.close();
        return root;
    }

    public ClusNode loadTreeTree(String fname, ClusSchema schema) throws IOException {
        this.m_FName = fname;
        this.m_Schema = schema;
        this.m_NoPartialTree = true;
        ClusLogger.info("Loading .tree file: " + fname);
        LineNumberReader rdr = new LineNumberReader(new InputStreamReader(new FileInputStream(fname)));
        String line = rdr.readLine();
        ClusNode root = null;
        root = this.readTree(line, rdr);
        rdr.close();
        return root;
    }

    public ClusNode readTree(String line, LineNumberReader rdr) throws IOException {
        this.m_Reader = rdr;
        this.m_IsReading = true;
        this.m_PushBack = -1;
        return this.readTree(line);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ClusNode readTree(String line) throws IOException {
        String trim = line.trim();
        ClusLogger.info("Reading: '" + line + "'");
        ClusNode result = new ClusNode();
        if (!trim.equals("?")) {
            int arity = 2;
            String[] branchnames = YESNO;
            MStringTokenizer tokens = this.getTokens();
            tokens.setString(trim);
            if (tokens.hasMoreTokens()) {
                String attrname = tokens.getToken();
                ClusAttrType attr = this.findAttrType(attrname, this.allowPartialTree());
                if (attr == null) return result;
                this.readTest(attr, result, tokens);
                if (result.getTest() instanceof NominalTest) {
                    NominalAttrType ntype = (NominalAttrType)attr;
                    arity = ntype.getNbValues();
                    branchnames = ntype.getValues();
                }
            } else {
                this.createError("No attribute name found");
            }
            result.setNbChildren(arity);
            boolean[] has_ch = new boolean[arity];
            boolean is_wildcard = false;
            for (int i = 0; i < arity && !is_wildcard; ++i) {
                is_wildcard = this.readNextChild(result, branchnames, has_ch);
                if (!is_wildcard) continue;
                this.readWildCardChild(result, has_ch);
                this.startPlayBack();
                for (int j = i + 1; j < arity; ++j) {
                    this.reset();
                    this.readWildCardChild(result, has_ch);
                }
                this.stopPlayBack();
            }
            return result;
        } else {
            this.checkPartialTreeAllowed("while reading child node");
        }
        return result;
    }

    public String getLineAfterTree() {
        return this.m_LineAfterTree;
    }

    public boolean allowPartialTree() {
        return !this.m_NoPartialTree;
    }

    public void checkPartialTreeAllowed(String str) throws IOException {
        if (!this.allowPartialTree()) {
            this.createError("No question marks allowed in tree (" + str + ")");
        }
    }

    public static boolean isSkipLine(String line) {
        String trim = line.trim();
        if (trim.equals("")) {
            return true;
        }
        return trim.length() > 1 && trim.charAt(0) == '%';
    }

    public ClusAttrType findAttrType(String name, boolean shouldfind) throws IOException {
        ClusAttrType type = this.m_Schema.getAttrType(name);
        if (type == null && shouldfind) {
            this.createError("Unknown attribute name: '" + name + "'");
        }
        return type;
    }

    public void readCharTokens(String chars, MStringTokenizer tokens) throws IOException {
        String token = tokens.getToken();
        for (int pos = 0; pos < chars.length(); ++pos) {
            if (!chars.substring(pos, pos + 1).equals(token)) {
                this.createError("Expected '" + chars.substring(pos, pos + 1) + "', not '" + token + "'");
            }
            if (pos >= chars.length() - 1) continue;
            if (tokens.hasMoreTokens()) {
                token = tokens.getToken();
                continue;
            }
            this.createError("Expected '" + chars.substring(pos + 1, pos + 2) + "' at end of line");
        }
    }

    public void readNumericTest(ClusAttrType attr, ClusNode node, MStringTokenizer tokens) throws IOException {
        NumericTest test = new NumericTest(attr);
        if (tokens.hasMoreTokens()) {
            this.readCharTokens(">", tokens);
            if (tokens.hasMoreTokens()) {
                String value = tokens.getToken();
                if (value.equals("?")) {
                    this.checkPartialTreeAllowed("in numeric test");
                } else {
                    try {
                        double bound = Double.parseDouble(value);
                        test.setBound(bound);
                    }
                    catch (NumberFormatException e) {
                        this.createError("Expected numeric value for '" + attr.getName() + "', not '" + value + "'");
                    }
                }
            } else {
                this.createError("Expected numeric value for test on '" + attr.getName() + "'");
            }
        }
        node.setTest(test);
    }

    /*
     * Enabled aggressive block sorting
     */
    public int readSingleValue(boolean[] isin, NominalAttrType attr, MStringTokenizer tokens) throws IOException {
        if (!tokens.hasMoreTokens()) {
            this.createError("Expected value after '=' while reading test on '" + attr.getName() + "'");
            return 0;
        }
        String token = tokens.getToken();
        if (token.equals("?")) {
            this.checkPartialTreeAllowed("in subset test");
            return 0;
        }
        Integer res = attr.getValueIndex(token);
        if (res == null) {
            this.createError("Value '" + token + "=' not in domain of '" + attr.getName() + "'");
        }
        isin[res.intValue()] = true;
        return 1;
    }

    public int readMultiValue(boolean[] isin, NominalAttrType attr, MStringTokenizer tokens) throws IOException {
        int nb = 0;
        if (tokens.hasMoreTokens()) {
            String token = tokens.getToken();
            if (token.equals("?")) {
                this.checkPartialTreeAllowed("in subset test");
            } else {
                if (!token.equals("{")) {
                    this.createError("Expected set after 'in' while reading test on '" + attr.getName() + "'");
                }
                while (tokens.hasMoreTokens()) {
                    String name = tokens.getToken();
                    Integer res = attr.getValueIndex(name);
                    if (res == null) {
                        this.createError("Value '" + name + "=' not in domain of '" + attr.getName() + "'");
                    }
                    isin[res.intValue()] = true;
                    ++nb;
                    if (tokens.hasMoreTokens()) {
                        String sep = tokens.getToken();
                        if (!sep.equals("}")) {
                            if (sep.equals(",")) continue;
                            this.createError("Expected '}' or ',' while reading test on '" + attr.getName() + "'");
                            continue;
                        }
                        break;
                    }
                    this.createError("End of set expected while reading test on '" + attr.getName() + "'");
                }
            }
        } else {
            this.createError("Expected value after 'in' while reading test on '" + attr.getName() + "'");
        }
        return nb;
    }

    public void readNominalTest(ClusAttrType attr, ClusNode node, MStringTokenizer tokens) throws IOException {
        NominalAttrType ntype = (NominalAttrType)attr;
        if (tokens.hasMoreTokens()) {
            int nb = 0;
            boolean[] isin = new boolean[ntype.getNbValues()];
            String token = tokens.getToken();
            if (token.equals("=")) {
                nb = this.readSingleValue(isin, ntype, tokens);
            } else if (token.equals("in")) {
                nb = this.readMultiValue(isin, ntype, tokens);
            } else {
                this.createError("Expected '=' or 'in' while reading test on '" + attr.getName() + "'");
            }
            SubsetTest test = new SubsetTest(ntype, nb, isin, Double.NEGATIVE_INFINITY);
            node.setTest(test);
        } else {
            double[] freqs = new double[ntype.getNbValues()];
            Arrays.fill(freqs, Double.NEGATIVE_INFINITY);
            NominalTest test = new NominalTest(ntype, freqs);
            node.setTest(test);
        }
    }

    public void readTest(ClusAttrType attr, ClusNode node, MStringTokenizer tokens) throws IOException {
        switch (attr.getAttributeType()) {
            case Numeric: {
                this.readNumericTest(attr, node, tokens);
                break;
            }
            case Nominal: {
                this.readNominalTest(attr, node, tokens);
                break;
            }
            default: {
                this.createError("Unsupported attribute type '" + attr.getTypeName() + "'");
            }
        }
    }

    public boolean readNextChild(ClusNode node, String[] bnames, boolean[] has_ch) throws IOException {
        String name;
        int idxmm;
        int idx;
        String str = this.readLine();
        int cnt = 1;
        for (int i = 0; i < has_ch.length; ++i) {
            if (!has_ch[i]) continue;
            ++cnt;
        }
        if (str == null) {
            this.createError("End of file encountered while reading branch " + cnt + " for " + node.getTest());
        }
        if ((idx = str.indexOf(58)) == -1) {
            this.createError("Expected ':' in start of branch " + cnt + " for " + node.getTest() + ", not '" + str + "'");
        }
        if ((idxmm = (name = str.substring(0, idx)).lastIndexOf("--")) != -1) {
            name = name.substring(idxmm + 2).trim();
        }
        if (name.equals("?")) {
            this.checkPartialTreeAllowed("as child node '" + str + "'");
            this.startRecording(str);
            return true;
        }
        int pos = -1;
        for (int i = 0; i < bnames.length; ++i) {
            if (!name.equals(bnames[i])) continue;
            pos = i;
            break;
        }
        if (pos == -1) {
            StringBuffer names = new StringBuffer("{");
            for (int i = 0; i < bnames.length; ++i) {
                if (i != 0) {
                    names.append(",");
                }
                names.append(bnames[i]);
            }
            names.append("}");
            this.createError("Branch start '" + name + "' does not match " + names + " for " + node.getTest());
        }
        if (has_ch[pos]) {
            this.createError("Branch '" + bnames[pos] + "' occurs twice for " + node.getTest());
        }
        has_ch[pos] = true;
        if (str.length() <= idx + 1) {
            this.createError("Expected start of branch after '" + name + "' for " + node.getTest());
        }
        String rest = str.substring(idx + 1).trim();
        ClusNode child = this.readTree(rest);
        node.setChild(child, pos);
        return false;
    }

    public void readWildCardChild(ClusNode node, boolean[] has_ch) throws IOException {
        int idx;
        String str = this.readLine();
        int cnt = 1;
        int first_free = -1;
        for (int i = 0; i < has_ch.length; ++i) {
            if (has_ch[i]) {
                ++cnt;
                continue;
            }
            if (first_free != -1) continue;
            first_free = i;
        }
        if (first_free == -1) {
            this.createError("Internal error (all branches already read) while reading wildcard branch for " + node.getTest());
        }
        if (str == null) {
            this.createError("End of file encountered while reading wildcard branch " + cnt + " for " + node.getTest());
        }
        if ((idx = str.indexOf(58)) == -1) {
            this.createError("Expected ':' in start of wildcard branch " + cnt + " for " + node.getTest() + ", not '" + str + "'");
        }
        if (str.length() <= idx + 1) {
            this.createError("Expected start of branch after wildcard '?:' for " + node.getTest());
        }
        String rest = str.substring(idx + 1).trim();
        ClusNode child = this.readTree(rest);
        node.setChild(child, first_free);
        has_ch[first_free] = true;
    }

    public void createError(String err) throws IOException {
        throw new IOException(err + " (" + this.m_FName + ": " + this.getLineNumber() + ")");
    }

    public String readLine() throws IOException {
        if (this.m_PushBack != -1) {
            String result = (String)this.m_Lines.get(this.m_PushBack);
            this.m_PushBack = -1;
            return result;
        }
        if (this.m_IsReading) {
            String line = this.m_Reader.readLine();
            if (this.isRecording() && line != null) {
                this.m_Lines.add(line);
                ++this.m_CrLine;
            }
            return line;
        }
        return (String)this.m_Lines.get(this.m_CrLine++);
    }

    public void markStartRecording() {
        this.m_PushBack = this.m_CrLine - 1;
        this.m_StartPos.add(new Integer(this.m_CrLine - 1));
    }

    public void startRecording(String firstline) {
        if (this.m_Lines != null) {
            this.markStartRecording();
        } else {
            this.m_CrLine = 1;
            this.m_StartLine = this.m_Reader.getLineNumber() - 1;
            this.m_Lines = new ArrayList();
            this.m_Lines.add(firstline);
            this.m_StartPos = new ArrayList();
            this.markStartRecording();
        }
    }

    public void startPlayBack() {
        this.m_IsReading = false;
        this.reset();
    }

    public void stopPlayBack() {
        this.m_StartPos.remove(this.m_StartPos.size() - 1);
        if (this.m_StartPos.size() == 0) {
            this.m_IsReading = true;
            this.m_Lines = null;
            this.m_StartPos = null;
        }
    }

    public void reset() {
        Integer pos = (Integer)this.m_StartPos.get(this.m_StartPos.size() - 1);
        this.m_CrLine = pos;
    }

    public boolean isRecording() {
        return this.m_Lines != null;
    }

    public int getLineNumber() {
        if (this.m_IsReading) {
            return this.m_Reader.getLineNumber();
        }
        return this.m_StartLine + this.m_CrLine;
    }

    public MStringTokenizer getTokens() {
        return this.m_Tokens;
    }

    public static boolean checkAtEnd(LineNumberReader rdr) throws IOException {
        String line = rdr.readLine();
        while (line != null && ClusTreeReader.isSkipLine(line)) {
            line = rdr.readLine();
        }
        return line == null;
    }

    public static String getFirstNonEmptyLine(LineNumberReader rdr) throws IOException {
        String line = rdr.readLine();
        while (line != null && ClusTreeReader.isSkipLine(line)) {
            line = rdr.readLine();
        }
        return line;
    }

    public static MStringTokenizer createTokenizer() {
        MStringTokenizer tokens = new MStringTokenizer();
        tokens.setCharTokens("=<>{},");
        tokens.setBlockChars("\"", "\"");
        tokens.setSpaceChars(" \t");
        return tokens;
    }
}

