/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.model.io;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.model.ClusModelInfo;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.jeans.io.ObjectLoadStream;
import si.ijs.kt.clus.util.jeans.io.ObjectSaveStream;

public class ClusModelCollectionIO
implements Serializable {
    public static final long serialVersionUID = 1L;
    protected ArrayList m_ModelInfos = new ArrayList();

    public int getNbModels() {
        return this.m_ModelInfos.size();
    }

    public void addModel(ClusModelInfo model) {
        this.m_ModelInfos.add(model);
    }

    public void insertModel(int idx, ClusModelInfo model) {
        this.m_ModelInfos.add(null);
        for (int i = this.m_ModelInfos.size() - 1; i >= idx + 1; --i) {
            this.m_ModelInfos.set(i, this.m_ModelInfos.get(i - 1));
        }
        this.m_ModelInfos.set(idx, model);
    }

    public ClusModelInfo getModelInfo(int index) {
        return (ClusModelInfo)this.m_ModelInfos.get(index);
    }

    public ClusModel getModel(int index) {
        ClusModelInfo info = (ClusModelInfo)this.m_ModelInfos.get(index);
        return info.getModel();
    }

    public ClusModel getModel(String name) {
        for (int i = 0; i < this.getNbModels(); ++i) {
            ClusModelInfo info = (ClusModelInfo)this.m_ModelInfos.get(i);
            if (!info.getName().equals(name)) continue;
            return info.getModel();
        }
        return null;
    }

    public void printModelNames() {
        if (this.getNbModels() == 0) {
            ClusLogger.info("Collection does not contain any models");
        } else {
            for (int i = 0; i < this.getNbModels(); ++i) {
                ClusModelInfo info = (ClusModelInfo)this.m_ModelInfos.get(i);
                ClusLogger.info("Model: " + info.getName());
            }
        }
    }

    public void save(String filename) throws IOException {
        ObjectSaveStream strm = new ObjectSaveStream(new FileOutputStream(filename));
        strm.writeObject(this);
        strm.close();
    }

    public static ClusModelCollectionIO load(String filename) throws IOException, ClassNotFoundException {
        ObjectLoadStream strm = new ObjectLoadStream(new FileInputStream(filename));
        ClusModelCollectionIO result = (ClusModelCollectionIO)strm.readObject();
        strm.close();
        return result;
    }
}

