/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.main.settings.section;

import java.util.ArrayList;
import si.ijs.kt.clus.main.settings.SettingsBase;
import si.ijs.kt.clus.main.settings.section.SettingsOutput;
import si.ijs.kt.clus.main.settings.section.SettingsTimeSeries;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.FTest;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileBool;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileDouble;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileEnum;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileEnumList;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileInt;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileNominalOrDoubleOrVector;
import si.ijs.kt.clus.util.jeans.io.range.IntRangeCheck;

public class SettingsTree
extends SettingsBase {
    private static final long serialVersionUID = 1L;
    private INIFileEnum<InductionOrder> m_InductionOrder;
    private INIFileEnum<EntropyType> m_EntropyType;
    private INIFileBool m_ConsiderUnlableInstancesInIGCalc;
    private INIFileEnum<Heuristic> m_Heuristic;
    private INIFileEnum<SetDistance> m_SetDistance;
    private INIFileEnum<TupleDistance> m_TupleDistance;
    private INIFileEnum<TimeSeriesDistanceMeasure> m_TSDistance;
    private INIFileEnum<SettingsTimeSeries.TimeSeriesPrototypeComplexity> m_HeuristicComplexity;
    private INIFileBool m_BinarySplit;
    private INIFileBool m_AlternativeSplits;
    private INIFileNominalOrDoubleOrVector m_FTest;
    private INIFileEnum<PruningMethod> m_PruningMethod;
    private INIFileBool m_1SERule;
    private INIFileBool m_MSENominal;
    private INIFileDouble m_M5PruningMult;
    private INIFileEnum<SettingsOutput.ConvertRules> m_RulesFromTree;
    private INIFileEnumList<TreeOptimizeValues> m_TreeOptimize;
    private INIFileEnum<SpatialMatrixType> m_SpatialMatrix;
    private INIFileEnum<SpatialMeasure> m_SpatialMeasure;
    private INIFileDouble m_Bandwidth;
    private INIFileBool m_Longlat;
    private INIFileDouble m_NeighCount;
    private INIFileDouble m_SpatialAlpha;
    private INIFileInt m_TreeSplitSampling;
    private INIFileEnum<SplitPositions> m_SplitPosition;
    public static double ALPHA;
    private INIFileEnum<MissingClusteringAttributeHandlingType> m_MissingClusteringAttrHandling;
    private INIFileEnum<MissingTargetAttributeHandlingType> m_MissingTargetAttrHandling;
    public static int FTEST_LEVEL;
    public static double FTEST_VALUE;
    public static double MINIMAL_WEIGHT;
    public static boolean ONE_NOMINAL;
    public static final double BANDWIDTH = 0.01;
    public static final double NumNeightbours = 0.0;
    public static boolean LONGLAT;

    public SettingsTree(int position) {
        super(position, "Tree");
    }

    public SplitPositions getSplitPosition() {
        return this.m_SplitPosition.getValue();
    }

    public MissingClusteringAttributeHandlingType getMissingClusteringAttrHandling() {
        return this.m_MissingClusteringAttrHandling.getValue();
    }

    public MissingTargetAttributeHandlingType getMissingTargetAttrHandling() {
        return this.m_MissingTargetAttrHandling.getValue();
    }

    public void setMissingClusteringAttrHandling(MissingClusteringAttributeHandlingType value) {
        this.m_MissingClusteringAttrHandling.setValue(value);
    }

    public void setMissingTargetAttrHandling(MissingTargetAttributeHandlingType value) {
        this.m_MissingTargetAttrHandling.setValue(value);
    }

    public void setMissingAttrHandlingToTrainingSet() {
        String warning = "Missing %s attribute handling should base on traning set statistics. Changing the setting accordingly.";
        if (!this.m_MissingClusteringAttrHandling.getValue().equals((Object)MissingClusteringAttributeHandlingType.EstimateFromTrainingSet)) {
            ClusLogger.info(String.format(warning, "clustering"));
            this.m_MissingClusteringAttrHandling.setValue(MissingClusteringAttributeHandlingType.EstimateFromTrainingSet);
        }
        if (!this.m_MissingTargetAttrHandling.getValue().equals((Object)MissingTargetAttributeHandlingType.DefaultModel)) {
            ClusLogger.info(String.format(warning, "target"));
            this.m_MissingTargetAttrHandling.setValue(MissingTargetAttributeHandlingType.DefaultModel);
        }
    }

    public SpatialMatrixType getSpatialMatrix() {
        return this.m_SpatialMatrix.getValue();
    }

    public SpatialMeasure getSpatialMeasure() {
        return this.m_SpatialMeasure.getValue();
    }

    public double getBandwidth() {
        return this.m_Bandwidth.getValue();
    }

    public boolean isLonglat() {
        return this.m_Longlat.getValue();
    }

    public double getNumNeightbours() {
        return this.m_NeighCount.getValue();
    }

    public double getSpatialAlpha() {
        return this.m_SpatialAlpha.getValue();
    }

    public void setSpatialMeasure(SpatialMeasure method) {
        this.m_SpatialMeasure.setValue(method);
    }

    public void setSpatialMatrix(SpatialMatrixType method) {
        this.m_SpatialMatrix.setValue(method);
    }

    public SettingsTimeSeries.TimeSeriesPrototypeComplexity getHeuristicComplexity() {
        return this.m_HeuristicComplexity.getValue();
    }

    public void setSectionTreeEnabled(boolean enable) {
        this.m_Section.setEnabled(enable);
    }

    public Heuristic getHeuristic() {
        return this.m_Heuristic.getValue();
    }

    public void setHeuristic(Heuristic value) {
        this.m_Heuristic.setValue(value);
    }

    public void setTSDistance(TimeSeriesDistanceMeasure value) {
        this.m_TSDistance.setValue(value);
    }

    public TimeSeriesDistanceMeasure getTSDistance() {
        return this.m_TSDistance.getValue();
    }

    public SetDistance getSetDistance() {
        return this.m_SetDistance.getValue();
    }

    public void setSetDistance(SetDistance value) {
        this.m_SetDistance.setValue(value);
    }

    public boolean checkSetDistance(SetDistance value) {
        return this.m_SetDistance.getValue().equals((Object)value);
    }

    public TupleDistance getTupleDistance() {
        return this.m_TupleDistance.getValue();
    }

    public void setTupleDistance(TupleDistance value) {
        this.m_TupleDistance.setValue(value);
    }

    public boolean checkTupleDistance(TupleDistance value) {
        return this.m_TupleDistance.getValue().equals((Object)value);
    }

    public InductionOrder getInductionOrder() {
        return this.m_InductionOrder.getValue();
    }

    public void setInductionOrder(InductionOrder value) {
        this.m_InductionOrder.setValue(value);
    }

    public EntropyType getEntropyType() {
        return this.m_EntropyType.getValue();
    }

    public void setEntropyType(EntropyType value) {
        this.m_EntropyType.setValue(value);
    }

    public boolean considerUnlableInstancesInIGCalc() {
        return this.m_ConsiderUnlableInstancesInIGCalc.getValue();
    }

    public int getTreeSplitSampling() {
        return this.m_TreeSplitSampling.getValue();
    }

    public void setTreeSplitSampling(int value) {
        this.m_TreeSplitSampling.setValue(value);
    }

    public boolean isBinarySplit() {
        return this.m_BinarySplit.getValue();
    }

    public boolean showAlternativeSplits() {
        return this.m_AlternativeSplits.getValue();
    }

    public INIFileNominalOrDoubleOrVector getFTestArray() {
        return this.m_FTest;
    }

    public double getFTest() {
        return this.m_FTest.getDouble();
    }

    public void setFTest(double ftest, int verbosityLevel) {
        FTEST_VALUE = ftest;
        FTEST_LEVEL = FTest.getLevelAndComputeArray(ftest, verbosityLevel);
        this.m_FTest.setDouble(ftest);
    }

    public PruningMethod getPruningMethod() {
        return this.m_PruningMethod.getValue();
    }

    public void setPruningMethod(PruningMethod method) {
        this.m_PruningMethod.setValue(method);
    }

    public String getPruningMethodName() {
        return this.m_PruningMethod.getStringValue();
    }

    public boolean get1SERule() {
        return this.m_1SERule.getValue();
    }

    public boolean isMSENominal() {
        return this.m_MSENominal.getValue();
    }

    public double getM5PruningMult() {
        return this.m_M5PruningMult.getValue();
    }

    public SettingsOutput.ConvertRules rulesFromTree() {
        return this.m_RulesFromTree.getValue();
    }

    public boolean hasTreeOptimize(TreeOptimizeValues value) {
        return this.m_TreeOptimize.getValue().contains((Object)value);
    }

    public void setM5PruningMultEnabled(boolean value) {
        this.m_M5PruningMult.setEnabled(value);
    }

    public void set1SERuleEnabled(boolean value) {
        this.m_1SERule.setEnabled(value);
    }

    public void setFTestEnabled(boolean value) {
        this.m_FTest.setEnabled(value);
    }

    @Override
    public void create() {
        this.m_Heuristic = new INIFileEnum<Heuristic>("Heuristic", Heuristic.Default);
        this.m_Section.addNode(this.m_Heuristic);
        this.m_HeuristicComplexity = new INIFileEnum<SettingsTimeSeries.TimeSeriesPrototypeComplexity>("HeuristicComplexity", SettingsTimeSeries.TimeSeriesPrototypeComplexity.N2);
        this.m_Section.addNode(this.m_HeuristicComplexity);
        this.m_SetDistance = new INIFileEnum<SetDistance>("SetDistance", SetDistance.GSMDistance);
        this.m_Section.addNode(this.m_SetDistance);
        this.m_TupleDistance = new INIFileEnum<TupleDistance>("TupleDistance", TupleDistance.Euclidean);
        this.m_Section.addNode(this.m_TupleDistance);
        this.m_TSDistance = new INIFileEnum<TimeSeriesDistanceMeasure>("TSDistance", TimeSeriesDistanceMeasure.DTW);
        this.m_Section.addNode(this.m_TSDistance);
        this.m_PruningMethod = new INIFileEnum<PruningMethod>("PruningMethod", PruningMethod.Default);
        this.m_Section.addNode(this.m_PruningMethod);
        this.m_M5PruningMult = new INIFileDouble("M5PruningMult", 2.0);
        this.m_Section.addNode(this.m_M5PruningMult);
        this.m_1SERule = new INIFileBool("1-SE-Rule", false);
        this.m_Section.addNode(this.m_1SERule);
        this.m_FTest = new INIFileNominalOrDoubleOrVector("FTest", NONELIST);
        this.m_Section.addNode(this.m_FTest);
        this.m_FTest.setDouble(1.0);
        this.m_BinarySplit = new INIFileBool("BinarySplit", true);
        this.m_Section.addNode(this.m_BinarySplit);
        this.m_RulesFromTree = new INIFileEnum<SettingsOutput.ConvertRules>("ConvertToRules", SettingsOutput.ConvertRules.No);
        this.m_Section.addNode(this.m_RulesFromTree);
        this.m_AlternativeSplits = new INIFileBool("AlternativeSplits", false);
        this.m_Section.addNode(this.m_AlternativeSplits);
        this.m_TreeOptimize = new INIFileEnumList<TreeOptimizeValues>("Optimize", new ArrayList(), TreeOptimizeValues.class);
        this.m_Section.addNode(this.m_TreeOptimize);
        this.m_MSENominal = new INIFileBool("MSENominal", false);
        this.m_Section.addNode(this.m_MSENominal);
        this.m_TreeSplitSampling = new INIFileInt("SplitSampling", 0);
        this.m_Section.addNode(this.m_TreeSplitSampling);
        this.m_TreeSplitSampling.setValueCheck(new IntRangeCheck(0, Integer.MAX_VALUE));
        this.m_MissingClusteringAttrHandling = new INIFileEnum<MissingClusteringAttributeHandlingType>("MissingClusteringAttrHandling", MissingClusteringAttributeHandlingType.EstimateFromParentNode);
        this.m_Section.addNode(this.m_MissingClusteringAttrHandling);
        this.m_MissingTargetAttrHandling = new INIFileEnum<MissingTargetAttributeHandlingType>("MissingTargetAttrHandling", MissingTargetAttributeHandlingType.ParentNode);
        this.m_Section.addNode(this.m_MissingTargetAttrHandling);
        this.m_InductionOrder = new INIFileEnum<InductionOrder>("InductionOrder", InductionOrder.DepthFirst);
        this.m_Section.addNode(this.m_InductionOrder);
        this.m_EntropyType = new INIFileEnum<EntropyType>("EntropyType", EntropyType.StandardEntropy);
        this.m_Section.addNode(this.m_EntropyType);
        this.m_ConsiderUnlableInstancesInIGCalc = new INIFileBool("ConsiderUnlableInstancesInIGCalc", false);
        this.m_Section.addNode(this.m_ConsiderUnlableInstancesInIGCalc);
        this.m_SpatialMatrix = new INIFileEnum<SpatialMatrixType>("SpatialMatrix", SpatialMatrixType.Binary);
        this.m_Section.addNode(this.m_SpatialMatrix);
        this.m_SpatialMeasure = new INIFileEnum<SpatialMeasure>("SpatialMeasure", SpatialMeasure.GlobalMoran);
        this.m_Section.addNode(this.m_SpatialMeasure);
        this.m_Bandwidth = new INIFileDouble("Bandwidth", 0.001);
        this.m_Section.addNode(this.m_Bandwidth);
        this.m_Longlat = new INIFileBool("Longlat", false);
        this.m_Section.addNode(this.m_Longlat);
        this.m_NeighCount = new INIFileDouble("NumNeightbours", 0.0);
        this.m_Section.addNode(this.m_NeighCount);
        this.m_SpatialAlpha = new INIFileDouble("Alpha", 1.0);
        this.m_Section.addNode(this.m_SpatialAlpha);
        this.m_SplitPosition = new INIFileEnum<SplitPositions>("SplitPosition", SplitPositions.Exact);
        this.m_Section.addNode(this.m_SplitPosition);
    }

    @Override
    public void initNamedValues() {
        this.m_TreeSplitSampling.setNamedValue(0, "None");
    }

    static {
        ONE_NOMINAL = true;
        LONGLAT = false;
    }

    public static enum SplitPositions {
        Exact,
        Middle;

    }

    public static enum MissingClusteringAttributeHandlingType {
        Ignore,
        EstimateFromTrainingSet,
        EstimateFromParentNode;

    }

    public static enum MissingTargetAttributeHandlingType {
        Zero,
        DefaultModel,
        ParentNode;

    }

    public static enum SpatialMatrixType {
        Binary,
        Euclidean,
        Modified,
        Gaussian;

    }

    public static enum SpatialMeasure {
        GlobalMoran,
        GlobalGeary,
        GlobalGetis,
        LocalMoran,
        LocalGeary,
        LocalGetis,
        StandardizedGetis,
        EquvalentI,
        IwithNeighbours,
        EquvalentIwithNeighbours,
        GlobalMoranDistance,
        GlobalGearyDistance,
        CI,
        MultiVariateMoranI,
        CwithNeighbours,
        Lee,
        MultiIwithNeighbours,
        CIwithNeighbours,
        LeewithNeighbours,
        Pearson,
        CIDistance,
        DH,
        EquvalentIDistance,
        PearsonDistance,
        EquvalentG,
        EquvalentGDistance,
        EquvalentPDistance;

    }

    public static enum Heuristic {
        Default,
        ReducedError,
        Gain,
        GainRatio,
        SSPD,
        VarianceReduction,
        MEstimate,
        Morishita,
        DispersionAdt,
        DispersionMlt,
        RDispersionAdt,
        RDispersionMlt,
        GeneticDistance,
        SemiSupervised,
        VarianceReductionMissing,
        StructuredData,
        VarianceReductionGIS;

    }

    public static enum TimeSeriesDistanceMeasure {
        DTW,
        QDM,
        TSC;

    }

    public static enum SetDistance {
        GSMDistance,
        HammingLoss,
        Jaccard,
        Matching,
        Euclidean;

    }

    public static enum TupleDistance {
        Euclidean,
        Minkowski;

    }

    public static enum InductionOrder {
        DepthFirst,
        BestFirst;

    }

    public static enum EntropyType {
        StandardEntropy,
        ModifiedEntropy;

    }

    public static enum PruningMethod {
        Default,
        None,
        C45,
        M5,
        M5Multi,
        ReducedErrorVSB,
        Garofalakis,
        GarofalakisVSB,
        CartVSB,
        CartMaxSize,
        EncodingCost,
        CategoryUtility;

    }

    public static enum TreeOptimizeValues {
        NoClusteringStats,
        NoInodeStats;

    }
}

