/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.main.settings.section;

import si.ijs.kt.clus.main.settings.SettingsBase;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileBool;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileDouble;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileEnum;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileInt;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileNominalOrDoubleOrVector;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileString;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileStringOrDouble;

public class SettingsSSL
extends SettingsBase {
    private static final long serialVersionUID = 1L;
    private boolean m_SemiSupervisedMode = false;
    private INIFileEnum<SSLMethod> m_SSL_SemiSupervisedMethod;
    private INIFileEnum<SSLUnlabeledCriteria> m_SSL_UnlabeledCriteria;
    private INIFileEnum<SSLStoppingCriteria> m_SSL_StoppingCriteria;
    private INIFileEnum<SSLConfidenceMeasure> m_SSL_ConfidenceMeasure;
    private INIFileInt m_SSL_Iterations;
    private INIFileDouble m_SSL_ConfidenceThreshold;
    private INIFileInt m_SSL_K;
    private INIFileStringOrDouble m_SSL_UnlabeledData;
    private INIFileInt m_SSL_PercentageLabeled;
    private INIFileBool m_SSL_useWeights;
    private INIFileInt m_SSL_airbagTrials;
    private INIFileNominalOrDoubleOrVector m_SSL_ExhaustiveSearchThresholds;
    private INIFileEnum<SSLOOBErrorCalculation> m_SSL_OOBErrorCalculation;
    private INIFileEnum<SSLNormalization> m_SSL_normalization;
    private INIFileEnum<SSLAggregation> m_SSL_aggregation;
    private INIFileBool m_CalibrateHmcThreshold;
    private INIFileNominalOrDoubleOrVector m_SSL_PossibleWeights;
    private INIFileBool m_SSL_PruningWhenTuning;
    private INIFileInt m_SSL_InternalFolds;
    private INIFileInt m_SSL_InternalFold;
    public static int DEFAULT_INTERNAL_FOLD = -1;
    private INIFileBool m_SSL_InduceMain;
    private INIFileString m_SSL_WeightScoresFile;
    private INIFileBool m_SSL_ForceInternalFolds;
    private INIFileInt m_SSL_SupervisionOptimisationTrees;
    private static final int DEFAULT_SUPERVISION_OPT_TREES = 0;
    private INIFileBool m_SSL_ImputeMissingTargetValues;

    public SettingsSSL(int position) {
        super(position, "SemiSupervised");
    }

    public boolean shouldCalibrateHmcThreshold() {
        return this.m_CalibrateHmcThreshold.getValue();
    }

    public int[] getInternalFoldIndices() {
        int[] answer;
        int internalFold = this.m_SSL_InternalFold.getValue();
        if (internalFold == 0 || internalFold >= this.getSSLInternalFolds()) {
            throw new RuntimeException("We must have 1 <= internal fold < internal fold indices");
        }
        if (internalFold == DEFAULT_INTERNAL_FOLD) {
            answer = new int[this.getSSLInternalFolds() - 1];
            for (int i = 0; i < answer.length; ++i) {
                answer[i] = i + 1;
            }
        } else {
            answer = new int[]{internalFold};
        }
        return answer;
    }

    public boolean shouldInduceMain() {
        return this.m_SSL_InduceMain.getValue();
    }

    public boolean imputeMissingTargetValues() {
        return this.m_SSL_ImputeMissingTargetValues.getValue();
    }

    public boolean isSemiSupervisedMode() {
        return this.m_SemiSupervisedMode;
    }

    public void setSemiSupervisedMode(boolean value) {
        this.m_SemiSupervisedMode = value;
    }

    public int getNumberOfTreesSupervisionOptimisation(int nIterationsActually) {
        int t = this.m_SSL_SupervisionOptimisationTrees.getValue();
        return t == 0 ? nIterationsActually : t;
    }

    public SSLMethod getSemiSupervisedMethod() {
        return this.m_SSL_SemiSupervisedMethod.getValue();
    }

    public String getSSLWeightScoresFile() {
        return this.m_SSL_WeightScoresFile.getValue();
    }

    public boolean shouldForceInternalXVal() {
        return this.m_SSL_ForceInternalFolds.getValue();
    }

    public boolean getSSLPruningWhenTuning() {
        return this.m_SSL_PruningWhenTuning.getValue();
    }

    public int getSSLInternalFolds() {
        return this.m_SSL_InternalFolds.getValue();
    }

    public int getSSLInternalFold() {
        return this.m_SSL_InternalFold.getValue();
    }

    public double[] getSSLPossibleWeights() {
        if (this.m_SSL_PossibleWeights.isVector()) {
            return this.m_SSL_PossibleWeights.getDoubleVector();
        }
        return new double[]{this.m_SSL_PossibleWeights.getDouble()};
    }

    public void setSemiSupervisedMethod(SSLMethod value) {
        this.m_SSL_SemiSupervisedMethod.setValue(value);
    }

    public void setSSLPruningWhenTuning(String value) {
        this.m_SSL_PruningWhenTuning.setValue(value);
    }

    public void setSSLInternalFolds(String value) {
        this.m_SSL_InternalFolds.setValue(value);
    }

    public void setStoppingCriteria(SSLStoppingCriteria value) {
        this.m_SSL_StoppingCriteria.setValue(value);
    }

    public SSLStoppingCriteria getStoppingCriteria() {
        return this.m_SSL_StoppingCriteria.getValue();
    }

    public void setUnlabeledCriteria(SSLUnlabeledCriteria value) {
        this.m_SSL_UnlabeledCriteria.setValue(value);
    }

    public SSLUnlabeledCriteria getUnlabeledCriteria() {
        return this.m_SSL_UnlabeledCriteria.getValue();
    }

    public void setIterations(int it) {
        this.m_SSL_Iterations.setValue(it);
    }

    public int getIterations() {
        return this.m_SSL_Iterations.getValue();
    }

    public void setConfidenceThreshold(double d) {
        this.m_SSL_ConfidenceThreshold.setValue(d);
    }

    public double getConfidenceThreshold() {
        return this.m_SSL_ConfidenceThreshold.getValue();
    }

    public void setK(int K) {
        this.m_SSL_K.setValue(K);
    }

    public int getK() {
        return this.m_SSL_K.getValue();
    }

    public String getUnlabeledFile() {
        return this.m_SSL_UnlabeledData.getValue();
    }

    public boolean isNullUnlabeledFile() {
        return this.m_SSL_UnlabeledData.getValue() == null || this.m_SSL_UnlabeledData.getValue() == "";
    }

    public int getPercentageLabeled() {
        return this.m_SSL_PercentageLabeled.getValue();
    }

    public SSLConfidenceMeasure getConfidenceMeasure() {
        return this.m_SSL_ConfidenceMeasure.getValue();
    }

    public boolean getUseWeights() {
        return this.m_SSL_useWeights.getValue();
    }

    public int getAirbagTrails() {
        return this.m_SSL_airbagTrials.getValue();
    }

    public double[] getExhaustiveSearchThresholds() {
        return this.m_SSL_ExhaustiveSearchThresholds.getDoubleVector();
    }

    public SSLOOBErrorCalculation getOOBErrorCalculation() {
        return this.m_SSL_OOBErrorCalculation.getValue();
    }

    public SSLNormalization getSSLNormalization() {
        return this.m_SSL_normalization.getValue();
    }

    public SSLAggregation getSSLAggregation() {
        return this.m_SSL_aggregation.getValue();
    }

    @Override
    public void create() {
        this.m_SSL_SemiSupervisedMethod = new INIFileEnum<SSLMethod>("SemiSupervisedMethod", SSLMethod.PCT);
        this.m_Section.addNode(this.m_SSL_SemiSupervisedMethod);
        this.m_SSL_StoppingCriteria = new INIFileEnum<SSLStoppingCriteria>("StoppingCriteria", SSLStoppingCriteria.NoneAdded);
        this.m_Section.addNode(this.m_SSL_StoppingCriteria);
        this.m_SSL_UnlabeledCriteria = new INIFileEnum<SSLUnlabeledCriteria>("UnlabeledCriteria", SSLUnlabeledCriteria.Threshold);
        this.m_Section.addNode(this.m_SSL_UnlabeledCriteria);
        this.m_SSL_ConfidenceThreshold = new INIFileDouble("ConfidenceThreshold", 0.8);
        this.m_Section.addNode(this.m_SSL_ConfidenceThreshold);
        this.m_SSL_ConfidenceMeasure = new INIFileEnum<SSLConfidenceMeasure>("ConfidenceMeasure", SSLConfidenceMeasure.Variance);
        this.m_Section.addNode(this.m_SSL_ConfidenceMeasure);
        this.m_SSL_Iterations = new INIFileInt("Iterations", 10);
        this.m_Section.addNode(this.m_SSL_Iterations);
        this.m_SSL_K = new INIFileInt("K", 5);
        this.m_Section.addNode(this.m_SSL_K);
        this.m_SSL_UnlabeledData = new INIFileStringOrDouble("UnlabeledData");
        this.m_Section.addNode(this.m_SSL_UnlabeledData);
        this.m_SSL_PercentageLabeled = new INIFileInt("PercentageLabeled", 5);
        this.m_Section.addNode(this.m_SSL_PercentageLabeled);
        this.m_SSL_useWeights = new INIFileBool("UseWeights", false);
        this.m_Section.addNode(this.m_SSL_useWeights);
        this.m_SSL_airbagTrials = new INIFileInt("AirbagTrials", 0);
        this.m_Section.addNode(this.m_SSL_airbagTrials);
        this.m_SSL_ExhaustiveSearchThresholds = new INIFileNominalOrDoubleOrVector("ExhaustiveSearchThresholds", NONELIST);
        this.m_Section.addNode(this.m_SSL_ExhaustiveSearchThresholds);
        this.m_SSL_ExhaustiveSearchThresholds.setDoubleArray(new double[]{0.5, 0.6, 0.7, 0.8, 0.9, 0.99});
        this.m_SSL_OOBErrorCalculation = new INIFileEnum<SSLOOBErrorCalculation>("OOBErrorCalculation", SSLOOBErrorCalculation.LabeledOnly);
        this.m_Section.addNode(this.m_SSL_OOBErrorCalculation);
        this.m_SSL_normalization = new INIFileEnum<SSLNormalization>("Normalization", SSLNormalization.MinMaxNormalization);
        this.m_Section.addNode(this.m_SSL_normalization);
        this.m_SSL_aggregation = new INIFileEnum<SSLAggregation>("Aggregation", SSLAggregation.Average);
        this.m_Section.addNode(this.m_SSL_aggregation);
        this.m_CalibrateHmcThreshold = new INIFileBool("CalibrateHmcThreshold", false);
        this.m_Section.addNode(this.m_CalibrateHmcThreshold);
        this.m_SSL_PruningWhenTuning = new INIFileBool("PruningWhenTuning", false);
        this.m_Section.addNode(this.m_SSL_PruningWhenTuning);
        this.m_SSL_InternalFolds = new INIFileInt("InternalFolds", 5);
        this.m_Section.addNode(this.m_SSL_InternalFolds);
        this.m_SSL_WeightScoresFile = new INIFileString("WeightScoresFile", "NO");
        this.m_Section.addNode(this.m_SSL_WeightScoresFile);
        INIFileNominalOrDoubleOrVector temp = new INIFileNominalOrDoubleOrVector("PossibleWeights", new String[0]);
        temp.setDoubleArray(new double[]{0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0});
        this.m_SSL_PossibleWeights = temp;
        this.m_Section.addNode(this.m_SSL_PossibleWeights);
        this.m_SSL_SupervisionOptimisationTrees = new INIFileInt("IterationsSupervisionOptimisation", 0);
        this.m_Section.addNode(this.m_SSL_SupervisionOptimisationTrees);
        this.m_SSL_ForceInternalFolds = new INIFileBool("ForceInternalXValOptimisation", false);
        this.m_Section.addNode(this.m_SSL_ForceInternalFolds);
        this.m_SSL_ImputeMissingTargetValues = new INIFileBool("ImputeMissingTargetValues", false);
        this.m_Section.addNode(this.m_SSL_ImputeMissingTargetValues);
        this.m_SSL_InternalFold = new INIFileInt("InternalFold", DEFAULT_INTERNAL_FOLD);
        this.m_Section.addNode(this.m_SSL_InternalFold);
        this.m_SSL_InduceMain = new INIFileBool("ProceedToMain", true);
        this.m_Section.addNode(this.m_SSL_InduceMain);
    }

    public static enum SSLMethod {
        SelfTraining,
        SelfTrainingFTF,
        PCT;

    }

    public static enum SSLStoppingCriteria {
        NoneAdded,
        Iterations,
        Airbag;

    }

    public static enum SSLUnlabeledCriteria {
        Threshold,
        KMostConfident,
        KPercentageMostConfident,
        AutomaticOOB,
        ExhaustiveSearch,
        KPercentageMostAverage,
        AutomaticOOBInitial;

    }

    public static enum SSLConfidenceMeasure {
        Variance,
        RandomUniform,
        RandomGaussian,
        Oracle,
        RForestProximities,
        RForestProximitiesV2,
        Precision,
        ClassesProbabilities;

    }

    public static enum SSLOOBErrorCalculation {
        LabeledOnly,
        AllData;

    }

    public static enum SSLNormalization {
        MinMaxNormalization,
        Ranking,
        Standardization,
        NoNormalization;

    }

    public static enum SSLAggregation {
        Average,
        Minimum,
        Maximum,
        AverageIgnoreZeros;

    }
}

