/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.main.settings.section;

import si.ijs.kt.clus.main.settings.SettingsBase;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileDouble;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileEnum;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileString;

public class SettingsPhylogeny
extends SettingsBase {
    private static final long serialVersionUID = 1L;
    private INIFileEnum<PhylogenyDistanceMeasure> m_PhylogenyDM;
    private INIFileEnum<PhylogenyCriterion> m_PhylogenyCriterion;
    private INIFileEnum<PhylogenySequence> m_PhylogenySequence;
    private INIFileString m_PhylogenyDistanceMatrix;
    private INIFileDouble m_PhylogenyEntropyVsRootStop;
    private INIFileDouble m_PhylogenyDistancesVsRootStop;
    private INIFileDouble m_PhylogenyEntropyVsParentStop;
    private INIFileDouble m_PhylogenyDistancesVsParentStop;

    public SettingsPhylogeny(int position) {
        super(position, "Phylogeny");
    }

    public PhylogenySequence getPhylogenySequence() {
        return this.m_PhylogenySequence.getValue();
    }

    public PhylogenyDistanceMeasure getPhylogenyDM() {
        return this.m_PhylogenyDM.getValue();
    }

    public PhylogenyCriterion getPhylogenyCriterion() {
        return this.m_PhylogenyCriterion.getValue();
    }

    public String getPhylogenyDistanceMatrix() {
        return this.m_PhylogenyDistanceMatrix.getValue();
    }

    public boolean isSectionPhylogenyEnabled() {
        return this.m_Section.isEnabled();
    }

    public void setSectionPhylogenyEnabled(boolean enable) {
        this.m_Section.setEnabled(enable);
    }

    public double getPhylogenyEntropyVsRootStop() {
        return this.m_PhylogenyEntropyVsRootStop.getValue();
    }

    public double getPhylogenyDistancesVsRootStop() {
        return this.m_PhylogenyDistancesVsRootStop.getValue();
    }

    public double getPhylogenyEntropyVsParentStop() {
        return this.m_PhylogenyEntropyVsParentStop.getValue();
    }

    public double getPhylogenyDistancesVsParentStop() {
        return this.m_PhylogenyDistancesVsParentStop.getValue();
    }

    @Override
    public void create() {
        this.m_PhylogenyDM = new INIFileEnum<PhylogenyDistanceMeasure>("DistanceMeasure", PhylogenyDistanceMeasure.PDist);
        this.m_Section.addNode(this.m_PhylogenyDM);
        this.m_PhylogenyCriterion = new INIFileEnum<PhylogenyCriterion>("OptimizationCriterion", PhylogenyCriterion.MinTotBranchLength);
        this.m_Section.addNode(this.m_PhylogenyCriterion);
        this.m_PhylogenySequence = new INIFileEnum<PhylogenySequence>("Sequence", PhylogenySequence.DNA);
        this.m_Section.addNode(this.m_PhylogenySequence);
        this.m_PhylogenyDistanceMatrix = new INIFileString("DistanceMatrix", "dist");
        this.m_Section.addNode(this.m_PhylogenyDistanceMatrix);
        this.m_PhylogenyEntropyVsRootStop = new INIFileDouble("EntropyVsRootStopCriterion", 0.0);
        this.m_Section.addNode(this.m_PhylogenyEntropyVsRootStop);
        this.m_PhylogenyDistancesVsRootStop = new INIFileDouble("SumPWDistancesVsRootStopCriterion", 0.0);
        this.m_Section.addNode(this.m_PhylogenyDistancesVsRootStop);
        this.m_PhylogenyEntropyVsParentStop = new INIFileDouble("EntropyVsParentStopCriterion", 0.0);
        this.m_Section.addNode(this.m_PhylogenyEntropyVsParentStop);
        this.m_PhylogenyDistancesVsParentStop = new INIFileDouble("SumPWDistancesVsParentStopCriterion", 0.0);
        this.m_Section.addNode(this.m_PhylogenyDistancesVsParentStop);
        this.m_Section.setEnabled(false);
    }

    public static enum PhylogenySequence {
        DNA,
        Protein,
        Any;

    }

    public static enum PhylogenyDistanceMeasure {
        PDist,
        Edit,
        JC,
        Kimura,
        AminoKimura;

    }

    public static enum PhylogenyCriterion {
        MinTotBranchLength,
        MaxAvgPWDistance,
        MaxMinPWDistance;

    }
}

