/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.main.settings.section;

import java.util.Arrays;
import java.util.List;
import si.ijs.kt.clus.main.settings.SettingsBase;
import si.ijs.kt.clus.statistic.StatisticPrintInfo;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileBool;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileEnum;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileEnumList;

public class SettingsOutput
extends SettingsBase {
    private static final long serialVersionUID = 1L;
    protected INIFileBool m_OutFoldErr;
    protected INIFileBool m_OutFoldData;
    protected INIFileBool m_OutFoldModels;
    protected INIFileBool m_OutTrainErr;
    protected INIFileBool m_OutValidErr;
    protected INIFileBool m_OutTestErr;
    protected INIFileBool m_ShowBrFreq;
    protected INIFileBool m_ShowUnknown;
    protected INIFileEnumList<ShowInfo> m_ShowInfo;
    protected INIFileEnumList<ShowModels> m_ShowModels;
    protected INIFileBool m_PrintModelAndExamples;
    protected INIFileEnumList<WritePredictions> m_WritePredictions;
    protected INIFileBool m_GzipOutput;
    protected INIFileBool m_WriteErrorFile;
    protected INIFileBool m_WriteModelFile;
    protected INIFileBool m_WritePerBagModelFiles;
    protected INIFileBool m_WriteOOBFile;
    protected INIFileBool m_ModelIDFiles;
    protected INIFileBool m_OutputPythonModel;
    private INIFileEnum<PythonModelType> m_PythonModelType;
    protected INIFileBool m_OutputJSONModel;
    protected INIFileBool m_OutputDatabaseQueries;
    protected INIFileBool m_WriteCurves;
    protected INIFileBool m_OutputClowdFlowsJSON;
    protected INIFileBool m_OutputROSSubspaces;
    protected INIFileEnum<SettingsBase.YesNo> m_ComputeSpearman;
    public static boolean SHOW_UNKNOWN_FREQ;
    public static boolean SHOW_BRANCH_FREQ;

    public SettingsOutput(int position) {
        super(position, "Output");
    }

    public boolean shouldWritePerBagModelFiles() {
        return this.m_WritePerBagModelFiles.getValue();
    }

    public boolean shouldComputeSpearman() {
        return this.m_ComputeSpearman.getValue().equals((Object)SettingsBase.YesNo.Yes);
    }

    public boolean isOutTrainError() {
        return this.m_OutTrainErr.getValue();
    }

    public void setOutTrainError(boolean value) {
        this.m_OutTrainErr.setValue(value);
    }

    public boolean isOutValidError() {
        return this.m_OutValidErr.getValue();
    }

    public void setOutValidError(boolean value) {
        this.m_OutValidErr.setValue(value);
    }

    public boolean isOutTestError() {
        return this.m_OutTestErr.getValue();
    }

    public void setOutTestError(boolean value) {
        this.m_OutTestErr.setValue(value);
    }

    public boolean isShowBranchFreq() {
        return this.m_ShowBrFreq.getValue();
    }

    public boolean isShowUnknown() {
        return this.m_ShowUnknown.getValue();
    }

    public boolean isPrintModelAndExamples() {
        return this.m_PrintModelAndExamples.getValue();
    }

    public boolean isOutFoldError() {
        return this.m_OutFoldErr.getValue();
    }

    public boolean isOutFoldData() {
        return this.m_OutFoldData.getValue();
    }

    public boolean isOutputFoldModels() {
        return this.m_OutFoldModels.getValue();
    }

    public boolean isOutputROSSubspaces() {
        return this.m_OutputROSSubspaces.getValue();
    }

    public boolean isWriteTestSetPredictions() {
        return this.m_WritePredictions.getValue().contains((Object)WritePredictions.Test);
    }

    public boolean isWriteTrainSetPredictions() {
        return this.m_WritePredictions.getValue().contains((Object)WritePredictions.Train);
    }

    public boolean isWriteErrorFile() {
        return this.m_WriteErrorFile.getValue();
    }

    public boolean isWriteModelIDPredictions() {
        return this.m_ModelIDFiles.getValue();
    }

    public boolean isOutputPythonModel() {
        return this.m_OutputPythonModel.getValue();
    }

    public PythonModelType getPythonModelType() {
        return this.m_PythonModelType.getValue();
    }

    public boolean isWriteOOBFile() {
        return this.m_WriteOOBFile.getValue();
    }

    public void setWriteOOBFile(boolean value) {
        this.m_WriteOOBFile.setValue(value);
    }

    public boolean isOutputJSONModel() {
        return this.m_OutputJSONModel.getValue();
    }

    public boolean isOutputClowdFlowsJSON() {
        return this.m_OutputClowdFlowsJSON.getValue();
    }

    public boolean isOutputDatabaseQueries() {
        return this.m_OutputDatabaseQueries.getValue();
    }

    public boolean isWriteCurves() {
        return this.m_WriteCurves.getValue();
    }

    public boolean isWriteModelFile() {
        return this.m_WriteModelFile.getValue();
    }

    public boolean getShowModel(ShowModels model) {
        return this.m_ShowModels.getValue().contains((Object)model);
    }

    public boolean shouldShowModel(int model) {
        boolean others = this.getShowModel(ShowModels.Others);
        if (model == 0 && this.getShowModel(ShowModels.Default)) {
            return true;
        }
        if (model == 1 && this.getShowModel(ShowModels.Original)) {
            return true;
        }
        if (model == 2 && (this.getShowModel(ShowModels.Pruned) || others)) {
            return true;
        }
        return others;
    }

    public StatisticPrintInfo getStatisticPrintInfo() {
        StatisticPrintInfo info = new StatisticPrintInfo();
        List<ShowInfo> vals = this.m_ShowInfo.getValue();
        info.SHOW_EXAMPLE_COUNT = vals.contains((Object)ShowInfo.Count);
        info.SHOW_EXAMPLE_COUNT_BYTARGET = vals.contains((Object)ShowInfo.CountByTarget);
        info.SHOW_DISTRIBUTION = vals.contains((Object)ShowInfo.Distribution);
        info.SHOW_INDEX = vals.contains((Object)ShowInfo.Index);
        info.INTERNAL_DISTR = vals.contains((Object)ShowInfo.NodePrototypes);
        info.SHOW_KEY = vals.contains((Object)ShowInfo.Key);
        return info;
    }

    @Override
    public void create() {
        this.m_ShowModels = new INIFileEnumList<ShowModels>("ShowModels", Arrays.asList(ShowModels.Default, ShowModels.Pruned, ShowModels.Others), ShowModels.class);
        this.m_Section.addNode(this.m_ShowModels);
        this.m_OutTrainErr = new INIFileBool("TrainErrors", true);
        this.m_Section.addNode(this.m_OutTrainErr);
        this.m_OutValidErr = new INIFileBool("ValidErrors", true);
        this.m_Section.addNode(this.m_OutValidErr);
        this.m_OutTestErr = new INIFileBool("TestErrors", true);
        this.m_Section.addNode(this.m_OutTestErr);
        this.m_OutFoldModels = new INIFileBool("AllFoldModels", true);
        this.m_Section.addNode(this.m_OutFoldModels);
        this.m_OutFoldErr = new INIFileBool("AllFoldErrors", false);
        this.m_Section.addNode(this.m_OutFoldErr);
        this.m_OutFoldData = new INIFileBool("AllFoldDatasets", false);
        this.m_Section.addNode(this.m_OutFoldData);
        this.m_ShowUnknown = new INIFileBool("UnknownFrequency", false);
        this.m_Section.addNode(this.m_ShowUnknown);
        this.m_ShowBrFreq = new INIFileBool("BranchFrequency", false);
        this.m_Section.addNode(this.m_ShowBrFreq);
        this.m_ShowInfo = new INIFileEnumList<ShowInfo>("ShowInfo", Arrays.asList(ShowInfo.Count), ShowInfo.class);
        this.m_Section.addNode(this.m_ShowInfo);
        this.m_PrintModelAndExamples = new INIFileBool("PrintModelAndExamples", false);
        this.m_Section.addNode(this.m_PrintModelAndExamples);
        this.m_WriteErrorFile = new INIFileBool("WriteErrorFile", false);
        this.m_Section.addNode(this.m_WriteErrorFile);
        this.m_WriteModelFile = new INIFileBool("WriteModelFile", false);
        this.m_Section.addNode(this.m_WriteModelFile);
        this.m_WritePerBagModelFiles = new INIFileBool("WritePerBagModelFile", true);
        this.m_Section.addNode(this.m_WritePerBagModelFiles);
        this.m_WriteOOBFile = new INIFileBool("WriteOOBFile", false);
        this.m_Section.addNode(this.m_WriteOOBFile);
        this.m_WritePredictions = new INIFileEnumList<WritePredictions>("WritePredictions", Arrays.asList(new WritePredictions[0]), WritePredictions.class);
        this.m_Section.addNode(this.m_WritePredictions);
        this.m_GzipOutput = new INIFileBool("GzipOutput", false);
        this.m_Section.addNode(this.m_GzipOutput);
        this.m_ModelIDFiles = new INIFileBool("ModelIDFiles", false);
        this.m_Section.addNode(this.m_ModelIDFiles);
        this.m_WriteCurves = new INIFileBool("WriteCurves", false);
        this.m_Section.addNode(this.m_WriteCurves);
        this.m_OutputPythonModel = new INIFileBool("OutputPythonModel", false);
        this.m_Section.addNode(this.m_OutputPythonModel);
        this.m_PythonModelType = new INIFileEnum<PythonModelType>("PythonModelType", PythonModelType.Object);
        this.m_Section.addNode(this.m_PythonModelType);
        this.m_OutputROSSubspaces = new INIFileBool("OutputROSSubspaces", false);
        this.m_Section.addNode(this.m_OutputROSSubspaces);
        this.m_OutputJSONModel = new INIFileBool("OutputJSONModel", false);
        this.m_Section.addNode(this.m_OutputJSONModel);
        this.m_OutputDatabaseQueries = new INIFileBool("OutputDatabaseQueries", false);
        this.m_Section.addNode(this.m_OutputDatabaseQueries);
        this.m_OutputClowdFlowsJSON = new INIFileBool("OutputClowdFlowsJSON", false);
        this.m_Section.addNode(this.m_OutputClowdFlowsJSON);
        this.m_ComputeSpearman = new INIFileEnum<SettingsBase.YesNo>("ComputeSpearman", SettingsBase.YesNo.No);
        this.m_Section.addNode(this.m_ComputeSpearman);
    }

    public void setOutputClowdFlows(boolean value) {
        this.m_OutputClowdFlowsJSON.setValue(value);
    }

    public boolean isGzipOutput() {
        return this.m_GzipOutput.getValue();
    }

    public static enum WritePredictions {
        Test,
        Train;

    }

    public static enum PythonModelType {
        Function,
        Object;

    }

    public static enum ShowModels {
        Default,
        Original,
        Pruned,
        Others;

    }

    public static enum ShowInfo {
        Count,
        CountByTarget,
        Distribution,
        Index,
        NodePrototypes,
        Key;

    }

    public static enum ConvertRules {
        No,
        Leaves,
        AllNodes;

    }
}

