/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.main.settings.section;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Date;
import java.util.zip.GZIPOutputStream;
import si.ijs.kt.clus.main.settings.SettingsBase;
import si.ijs.kt.clus.main.settings.section.SettingsOutput;
import si.ijs.kt.clus.util.jeans.util.FileUtil;
import si.ijs.kt.clus.util.jeans.util.StringUtils;

public class SettingsGeneric
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SettingsOutput m_SettOutput;
    protected Date m_Date;
    protected String m_AppName;
    protected String m_DirName;
    protected String m_Suffix = "";
    public static boolean EXACT_TIME = false;

    public SettingsGeneric(SettingsOutput settOutput) {
        this.m_SettOutput = settOutput;
    }

    public Date getDate() {
        return this.m_Date;
    }

    public void setDate(Date date) {
        this.m_Date = date;
    }

    public String getAppName() {
        return this.m_AppName;
    }

    public String getAppNameWithSuffix() {
        return this.m_AppName + this.m_Suffix;
    }

    public void setSuffix(String suffix) {
        this.m_Suffix = suffix;
    }

    public void setAppName(String file) {
        file = StringUtils.removeSuffix(file, ".gz");
        file = StringUtils.removeSuffix(file, ".arff");
        file = StringUtils.removeSuffix(file, ".s");
        file = StringUtils.removeSuffix(file, ".");
        this.m_AppName = FileUtil.removePath(file);
        this.m_DirName = FileUtil.getPath(file);
    }

    public String getFileAbsolute(String fname) {
        if (this.m_DirName == null) {
            return fname;
        }
        if (FileUtil.isAbsolutePath(fname)) {
            return fname;
        }
        return this.m_DirName + File.separator + fname;
    }

    public PrintWriter getFileAbsoluteWriter(String fname) throws FileNotFoundException {
        String path = this.getFileAbsolute(fname);
        if (this.m_SettOutput.isGzipOutput()) {
            path = path + ".gz";
            try {
                return new PrintWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(path))));
            }
            catch (IOException ex) {
                System.err.println(ex.toString());
            }
        }
        return new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path), SettingsBase.CHARSET));
    }
}

