/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.main.settings.section;

import si.ijs.kt.clus.main.settings.SettingsBase;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileBool;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileEnum;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileString;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileStringOrDouble;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileStringOrInt;
import si.ijs.kt.clus.util.jeans.util.StringUtils;

public class SettingsData
extends SettingsBase {
    private static final long serialVersionUID = 1L;
    private INIFileString m_DataFile;
    private INIFileStringOrDouble m_TestSet;
    private INIFileStringOrDouble m_PruneSet;
    private INIFileStringOrInt m_PruneSetMax;
    private INIFileStringOrInt m_XValFolds;
    private INIFileBool m_RemoveMissingTarget;
    private INIFileEnum<NormalizeDataValues> m_NormalizeData;

    public SettingsData(int position) {
        super(position, "Data");
    }

    public String getDataFile() {
        return this.m_DataFile.getValue();
    }

    public boolean isNullFile() {
        return StringUtils.unCaseCompare(this.m_DataFile.getValue(), "None");
    }

    public void updateDataFile(String fname) {
        if (this.isNullFile()) {
            this.m_DataFile.setValue(fname);
        }
    }

    public String getTestFile() {
        return this.m_TestSet.getValue();
    }

    public boolean isNullTestFile() {
        return this.m_TestSet.isDoubleOrNull("None");
    }

    public String getPruneFile() {
        return this.m_PruneSet.getValue();
    }

    public boolean isNullPruneFile() {
        return this.m_PruneSet.isDoubleOrNull("None");
    }

    public double getTestProportion() {
        if (!this.m_TestSet.isDouble()) {
            return 0.0;
        }
        return this.m_TestSet.getDoubleValue();
    }

    public double getPruneProportion() {
        if (!this.m_PruneSet.isDouble()) {
            return 0.0;
        }
        return this.m_PruneSet.getDoubleValue();
    }

    public int getPruneSetMax() {
        if (this.m_PruneSetMax.isString("Infinity")) {
            return Integer.MAX_VALUE;
        }
        return this.m_PruneSetMax.getIntValue();
    }

    public boolean isNullXValFile() {
        return this.m_XValFolds.isIntOrNull("None");
    }

    public boolean isLOOXVal() {
        return this.m_XValFolds.isString("LOO");
    }

    public String getXValFile() {
        return this.m_XValFolds.getValue();
    }

    public int getXValFolds() {
        return this.m_XValFolds.getIntValue();
    }

    public void setXValFolds(int folds) {
        this.m_XValFolds.setIntValue(folds);
    }

    public boolean isRemoveMissingTarget() {
        return this.m_RemoveMissingTarget.getValue();
    }

    public NormalizeDataValues getNormalizeData() {
        return this.m_NormalizeData.getValue();
    }

    public void setPruneSetMaxEnabled(boolean value) {
        this.m_PruneSetMax.setEnabled(value);
    }

    public boolean isPruneSetString(String str) {
        return this.m_PruneSet.isString(str);
    }

    @Override
    public void create() {
        this.m_DataFile = new INIFileString("File", "None");
        this.m_Section.addNode(this.m_DataFile);
        this.m_TestSet = new INIFileStringOrDouble("TestSet", "None");
        this.m_Section.addNode(this.m_TestSet);
        this.m_PruneSet = new INIFileStringOrDouble("PruneSet", "None");
        this.m_Section.addNode(this.m_PruneSet);
        this.m_PruneSetMax = new INIFileStringOrInt("PruneSetMax", "Infinity");
        this.m_Section.addNode(this.m_PruneSetMax);
        this.m_XValFolds = new INIFileStringOrInt("XVal");
        this.m_Section.addNode(this.m_XValFolds);
        this.m_XValFolds.setIntValue(10);
        this.m_RemoveMissingTarget = new INIFileBool("RemoveMissingTarget", false);
        this.m_Section.addNode(this.m_RemoveMissingTarget);
        this.m_NormalizeData = new INIFileEnum<NormalizeDataValues>("NormalizeData", NormalizeDataValues.None);
        this.m_Section.addNode(this.m_NormalizeData);
    }

    public static enum NormalizeDataValues {
        None,
        Numeric;

    }
}

