/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.main.settings.section;

import si.ijs.kt.clus.main.settings.SettingsBase;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileInt;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileNominalOrDoubleOrVector;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileNominalOrIntOrVector;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileString;
import si.ijs.kt.clus.util.jeans.util.StringUtils;

public class SettingsConstraints
extends SettingsBase {
    private static final long serialVersionUID = 1L;
    private INIFileString m_SyntacticConstrFile;
    private INIFileNominalOrIntOrVector m_MaxSizeConstr;
    private INIFileNominalOrDoubleOrVector m_MaxErrorConstr;
    private INIFileInt m_TreeMaxDepth;

    public SettingsConstraints(int position) {
        super(position, "Constraints");
    }

    public boolean hasConstraintFile() {
        return !StringUtils.unCaseCompare(this.m_SyntacticConstrFile.getValue(), "None");
    }

    public int getTreeMaxDepth() {
        return this.m_TreeMaxDepth.getValue();
    }

    public void setTreeMaxDepth(int value) {
        this.m_TreeMaxDepth.setValue(value);
    }

    public String getConstraintFile() {
        return this.m_SyntacticConstrFile.getValue();
    }

    public int getMaxSize() {
        return this.getSizeConstraintPruning(0);
    }

    public int getSizeConstraintPruning(int idx) {
        if (this.m_MaxSizeConstr.isNominal(idx)) {
            return -1;
        }
        return this.m_MaxSizeConstr.getInt(idx);
    }

    public int getSizeConstraintPruningNumber() {
        int len = this.m_MaxSizeConstr.getVectorLength();
        if (len == 1 && this.m_MaxSizeConstr.getNominal() == 0) {
            return 0;
        }
        return len;
    }

    public int[] getSizeConstraintPruningVector() {
        int size_nb = this.getSizeConstraintPruningNumber();
        int[] sizes = new int[size_nb];
        for (int i = 0; i < size_nb; ++i) {
            sizes[i] = this.getSizeConstraintPruning(i);
        }
        return sizes;
    }

    public void setSizeConstraintPruning(int size) {
        this.m_MaxSizeConstr.setInt(size);
    }

    public double getMaxErrorConstraint(int idx) {
        if (this.m_MaxErrorConstr.isNominal(idx)) {
            return Double.POSITIVE_INFINITY;
        }
        return this.m_MaxErrorConstr.getDouble(idx);
    }

    public int getMaxErrorConstraintNumber() {
        int len = this.m_MaxErrorConstr.getVectorLength();
        if (len == 1 && this.m_MaxErrorConstr.getDouble(0) == 0.0) {
            return 0;
        }
        return len;
    }

    public double[] getMaxErrorConstraintVector() {
        int error_nb = this.getMaxErrorConstraintNumber();
        double[] max_error = new double[error_nb];
        for (int i = 0; i < error_nb; ++i) {
            max_error[i] = this.getMaxErrorConstraint(i);
        }
        return max_error;
    }

    @Override
    public void create() {
        this.m_SyntacticConstrFile = new INIFileString("Syntactic", "None");
        this.m_Section.addNode(this.m_SyntacticConstrFile);
        this.m_MaxSizeConstr = new INIFileNominalOrIntOrVector("MaxSize", INFINITY);
        this.m_Section.addNode(this.m_MaxSizeConstr);
        this.m_MaxErrorConstr = new INIFileNominalOrDoubleOrVector("MaxError", INFINITY);
        this.m_Section.addNode(this.m_MaxErrorConstr);
        this.m_TreeMaxDepth = new INIFileInt("MaxDepth", -1);
        this.m_Section.addNode(this.m_TreeMaxDepth);
        this.m_MaxSizeConstr.setNominal(0);
        this.m_MaxErrorConstr.setDouble(0.0);
    }

    @Override
    public void initNamedValues() {
        this.m_TreeMaxDepth.setNamedValue(-1, "Infinity");
    }
}

