/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.main.settings.section;

import si.ijs.kt.clus.main.settings.SettingsBase;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileBool;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileNominalOrDoubleOrVector;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileString;
import si.ijs.kt.clus.util.jeans.util.StringUtils;

public class SettingsAttribute
extends SettingsBase {
    private static final long serialVersionUID = 1L;
    protected INIFileString m_Target;
    protected INIFileString m_Clustering;
    protected INIFileString m_Descriptive;
    protected INIFileString m_Key;
    protected INIFileString m_Disabled;
    protected INIFileNominalOrDoubleOrVector m_Weights;
    protected INIFileNominalOrDoubleOrVector m_ClusteringWeights;
    protected INIFileBool m_ReduceMemoryNominal;
    protected INIFileString m_GIS;
    public static final String[] NORMALIZATIONS = new String[]{"Normalize"};
    public static final int NORMALIZATION_DEFAULT = 0;
    public static final String[] NUM_NOM_TAR_NTAR_WEIGHTS = new String[]{"TargetWeight", "NonTargetWeight", "NumericWeight", "NominalWeight"};
    public static final int TARGET_WEIGHT = 0;
    public static final int NON_TARGET_WEIGHT = 1;
    public static final int NUMERIC_WEIGHT = 2;
    public static final int NOMINAL_WEIGHT = 3;

    public SettingsAttribute(int position) {
        super(position, "Attributes");
    }

    public String getGIS() {
        return this.m_GIS.getValue();
    }

    public boolean isNullGIS() {
        return StringUtils.unCaseCompare(this.m_GIS.getValue(), "None");
    }

    public String getTarget() {
        return this.m_Target.getValue();
    }

    public void setTarget(String str) {
        this.m_Target.setValue(str);
    }

    public boolean isNullTarget() {
        return StringUtils.unCaseCompare(this.m_Target.getValue(), "None");
    }

    public boolean isDefaultTarget() {
        return StringUtils.unCaseCompare(this.m_Target.getValue(), "Default");
    }

    public String getClustering() {
        return this.m_Clustering.getValue();
    }

    public void setClustering(String str) {
        this.m_Clustering.setValue(str);
    }

    public String getDescriptive() {
        return this.m_Descriptive.getValue();
    }

    public void setDescriptive(String str) {
        this.m_Descriptive.setValue(str);
    }

    public String getKey() {
        return this.m_Key.getValue();
    }

    public String getDisabled() {
        return this.m_Disabled.getValue();
    }

    public void setDisabled(String str) {
        this.m_Disabled.setValue(str);
    }

    public INIFileNominalOrDoubleOrVector getNormalizationWeights() {
        return this.m_Weights;
    }

    public boolean hasNonTrivialWeights() {
        for (int i = 0; i < this.m_Weights.getVectorLength(); ++i) {
            if (this.m_Weights.isNominal(i)) {
                return true;
            }
            if (this.m_Weights.getDouble(i) == 1.0) continue;
            return true;
        }
        return false;
    }

    public INIFileNominalOrDoubleOrVector getClusteringWeights() {
        return this.m_ClusteringWeights;
    }

    public boolean getReduceMemoryNominalAttrs() {
        return this.m_ReduceMemoryNominal.getValue();
    }

    @Override
    public void create() {
        this.m_Target = new INIFileString("Target", "Default");
        this.m_Section.addNode(this.m_Target);
        this.m_Clustering = new INIFileString("Clustering", "Default");
        this.m_Section.addNode(this.m_Clustering);
        this.m_Descriptive = new INIFileString("Descriptive", "Default");
        this.m_Section.addNode(this.m_Descriptive);
        this.m_Key = new INIFileString("Key", "None");
        this.m_Section.addNode(this.m_Key);
        this.m_Disabled = new INIFileString("Disable", "None");
        this.m_Section.addNode(this.m_Disabled);
        this.m_Weights = new INIFileNominalOrDoubleOrVector("Weights", NORMALIZATIONS);
        this.m_Section.addNode(this.m_Weights);
        this.m_Weights.setNominal(0);
        this.m_ClusteringWeights = new INIFileNominalOrDoubleOrVector("ClusteringWeights", EMPTY);
        this.m_Section.addNode(this.m_ClusteringWeights);
        this.m_ClusteringWeights.setDouble(1.0);
        this.m_ClusteringWeights.setArrayIndexNames(NUM_NOM_TAR_NTAR_WEIGHTS);
        this.m_ReduceMemoryNominal = new INIFileBool("ReduceMemoryNominalAttrs", false);
        this.m_Section.addNode(this.m_ReduceMemoryNominal);
        this.m_GIS = new INIFileString("GIS", "None");
        this.m_Section.addNode(this.m_GIS);
    }
}

