/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.main.settings;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.IntegerAttrType;
import si.ijs.kt.clus.main.settings.SettingsBase;
import si.ijs.kt.clus.main.settings.section.SettingsAttribute;
import si.ijs.kt.clus.main.settings.section.SettingsBeamSearch;
import si.ijs.kt.clus.main.settings.section.SettingsConstraints;
import si.ijs.kt.clus.main.settings.section.SettingsData;
import si.ijs.kt.clus.main.settings.section.SettingsEnsemble;
import si.ijs.kt.clus.main.settings.section.SettingsExhaustiveSearch;
import si.ijs.kt.clus.main.settings.section.SettingsExperimental;
import si.ijs.kt.clus.main.settings.section.SettingsGeneral;
import si.ijs.kt.clus.main.settings.section.SettingsGeneric;
import si.ijs.kt.clus.main.settings.section.SettingsHMLC;
import si.ijs.kt.clus.main.settings.section.SettingsHMTR;
import si.ijs.kt.clus.main.settings.section.SettingsILevelC;
import si.ijs.kt.clus.main.settings.section.SettingsKNN;
import si.ijs.kt.clus.main.settings.section.SettingsKNNTree;
import si.ijs.kt.clus.main.settings.section.SettingsMLC;
import si.ijs.kt.clus.main.settings.section.SettingsModel;
import si.ijs.kt.clus.main.settings.section.SettingsNominal;
import si.ijs.kt.clus.main.settings.section.SettingsOptionTree;
import si.ijs.kt.clus.main.settings.section.SettingsOutput;
import si.ijs.kt.clus.main.settings.section.SettingsPhylogeny;
import si.ijs.kt.clus.main.settings.section.SettingsRelief;
import si.ijs.kt.clus.main.settings.section.SettingsRules;
import si.ijs.kt.clus.main.settings.section.SettingsSIT;
import si.ijs.kt.clus.main.settings.section.SettingsSSL;
import si.ijs.kt.clus.main.settings.section.SettingsTimeSeries;
import si.ijs.kt.clus.main.settings.section.SettingsTree;
import si.ijs.kt.clus.util.ResourceInfo;
import si.ijs.kt.clus.util.exception.ClusInvalidSettingsException;
import si.ijs.kt.clus.util.jeans.io.ini.INIFile;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileNode;
import si.ijs.kt.clus.util.jeans.util.StringUtils;
import si.ijs.kt.clus.util.jeans.util.cmdline.CMDLineArgs;

public class Settings
implements Serializable {
    public static final long SERIAL_VERSION_ID = 1L;
    public static final long serialVersionUID = 1L;
    private INIFile m_Ini = new INIFile();
    private ArrayList<SettingsBase> m_Sections = new ArrayList();
    private SettingsGeneric m_SettGeneric;
    private SettingsGeneral m_SettGeneral = new SettingsGeneral(1);
    private SettingsData m_SettData = new SettingsData(2);
    private SettingsAttribute m_SettAttribute = new SettingsAttribute(3);
    private SettingsConstraints m_SettConstraints = new SettingsConstraints(5);
    private SettingsOutput m_SettOutput;
    private SettingsNominal m_SettNominal = new SettingsNominal(7);
    private SettingsModel m_SettModel;
    private SettingsTree m_SettTree;
    private SettingsRules m_SettRules;
    private SettingsMLC m_SettMLC;
    private SettingsHMLC m_SettHMLC;
    private SettingsHMTR m_SettHMTR;
    private SettingsILevelC m_SettILevelC;
    private SettingsBeamSearch m_SettBeamSearch;
    private SettingsExhaustiveSearch m_SettExhaustiveSearch;
    private SettingsTimeSeries m_SettTimeSeries = new SettingsTimeSeries(8);
    private SettingsPhylogeny m_SettPhylogeny;
    private SettingsRelief m_SettRelief;
    private SettingsEnsemble m_SettEnsemble;
    private SettingsKNN m_SettKNN;
    private SettingsKNNTree m_SettKNNTree;
    private SettingsOptionTree m_SettOptionTree;
    private SettingsExperimental m_SettExperimental;
    private SettingsSIT m_SettSIT;
    private SettingsSSL m_SettSSL;

    public Settings() {
        this.m_SettModel = new SettingsModel(9);
        this.m_SettTree = new SettingsTree(10);
        this.m_SettRules = new SettingsRules(11);
        this.m_SettHMLC = new SettingsHMLC(13);
        this.m_SettHMTR = new SettingsHMTR(14, this.m_SettAttribute, this.m_SettGeneral);
        this.m_SettOptionTree = new SettingsOptionTree(15);
        this.m_SettILevelC = new SettingsILevelC(16);
        this.m_SettBeamSearch = new SettingsBeamSearch(17);
        this.m_SettExhaustiveSearch = new SettingsExhaustiveSearch(18);
        this.m_SettPhylogeny = new SettingsPhylogeny(19);
        this.m_SettRelief = new SettingsRelief(20);
        this.m_SettEnsemble = new SettingsEnsemble(21);
        this.m_SettKNN = new SettingsKNN(22);
        this.m_SettKNNTree = new SettingsKNNTree(23);
        this.m_SettSIT = new SettingsSIT(24);
        this.m_SettSSL = new SettingsSSL(25);
        this.m_SettExperimental = new SettingsExperimental(26);
        this.m_SettOutput = new SettingsOutput(27);
        this.m_SettMLC = new SettingsMLC(12, this.m_SettHMLC, this.m_SettRelief);
        this.m_SettGeneric = new SettingsGeneric(this.m_SettOutput);
        Collections.addAll(this.m_Sections, this.m_SettGeneral, this.m_SettData, this.m_SettAttribute, this.m_SettConstraints, this.m_SettOutput, this.m_SettNominal, this.m_SettModel, this.m_SettTree, this.m_SettRules, this.m_SettMLC, this.m_SettHMLC, this.m_SettHMTR, this.m_SettILevelC, this.m_SettBeamSearch, this.m_SettExhaustiveSearch, this.m_SettTimeSeries, this.m_SettPhylogeny, this.m_SettRelief, this.m_SettEnsemble, this.m_SettKNN, this.m_SettKNNTree, this.m_SettOptionTree, this.m_SettExperimental, this.m_SettSIT, this.m_SettSSL);
    }

    public Enumeration<INIFileNode> getSectionsIterator() {
        return this.m_Ini.getNodes();
    }

    public SettingsGeneric getGeneric() {
        return this.m_SettGeneric;
    }

    public SettingsGeneral getGeneral() {
        return this.m_SettGeneral;
    }

    public SettingsData getData() {
        return this.m_SettData;
    }

    public SettingsAttribute getAttribute() {
        return this.m_SettAttribute;
    }

    public SettingsConstraints getConstraints() {
        return this.m_SettConstraints;
    }

    public SettingsOutput getOutput() {
        return this.m_SettOutput;
    }

    public SettingsNominal getNominal() {
        return this.m_SettNominal;
    }

    public SettingsModel getModel() {
        return this.m_SettModel;
    }

    public SettingsTree getTree() {
        return this.m_SettTree;
    }

    public SettingsRules getRules() {
        return this.m_SettRules;
    }

    public SettingsMLC getMLC() {
        return this.m_SettMLC;
    }

    public SettingsHMLC getHMLC() {
        return this.m_SettHMLC;
    }

    public SettingsHMTR getHMTR() {
        return this.m_SettHMTR;
    }

    public SettingsILevelC getILevelC() {
        return this.m_SettILevelC;
    }

    public SettingsBeamSearch getBeamSearch() {
        return this.m_SettBeamSearch;
    }

    public SettingsExhaustiveSearch getExhaustiveSearch() {
        return this.m_SettExhaustiveSearch;
    }

    public SettingsTimeSeries getTimeSeries() {
        return this.m_SettTimeSeries;
    }

    public SettingsPhylogeny getPhylogeny() {
        return this.m_SettPhylogeny;
    }

    public SettingsRelief getRelief() {
        return this.m_SettRelief;
    }

    public SettingsEnsemble getEnsemble() {
        return this.m_SettEnsemble;
    }

    public SettingsKNN getKNN() {
        return this.m_SettKNN;
    }

    public SettingsKNNTree getKNNTree() {
        return this.m_SettKNNTree;
    }

    public SettingsOptionTree getOptionTree() {
        return this.m_SettOptionTree;
    }

    public SettingsExperimental getExperimental() {
        return this.m_SettExperimental;
    }

    public SettingsSIT getSIT() {
        return this.m_SettSIT;
    }

    public SettingsSSL getSSL() {
        return this.m_SettSSL;
    }

    private void create() {
        Collections.sort(this.m_Sections, new Comparator<SettingsBase>(){

            @Override
            public int compare(SettingsBase p1, SettingsBase p2) {
                return p1.getPosition() - p2.getPosition();
            }
        });
        for (SettingsBase sec : this.m_Sections) {
            sec.create();
            this.m_Ini.addNode(sec.getSection());
        }
    }

    private void initNamedValues() {
        for (SettingsBase sec : this.m_Sections) {
            sec.initNamedValues();
        }
    }

    public void updateTarget(ClusSchema schema) {
        if (this.m_SettTree.getHeuristic().equals((Object)SettingsTree.Heuristic.SSPD)) {
            schema.addAttrType(new IntegerAttrType("SSPD"));
            int nb = schema.getNbAttributes();
            this.m_SettAttribute.setTarget(String.valueOf(nb));
        }
    }

    public void initialize(CMDLineArgs cargs, boolean loads) throws IOException {
        this.create();
        this.initNamedValues();
        if (loads) {
            try {
                String fname = this.m_SettGeneric.getFileAbsolute(this.m_SettGeneric.getAppName() + ".s");
                this.m_Ini.load(fname, '%');
            }
            catch (FileNotFoundException e) {
                System.err.println("No settings file found");
            }
        }
        if (cargs != null) {
            this.process(cargs);
        }
        this.m_SettData.updateDataFile(this.m_SettGeneric.getAppName() + ".arff");
        this.m_SettHMLC.initHierarchical();
    }

    public void validateSettings(ClusSchema schema) {
        try {
            this.validateSettingsCompatibility(schema);
        }
        catch (ClusInvalidSettingsException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void validateSettingsCompatibility(ClusSchema schema) throws ClusInvalidSettingsException {
        ArrayList<String> incompatibilities = new ArrayList<String>();
        List<String> tmpList = null;
        for (SettingsBase sec : this.m_Sections) {
            tmpList = sec.validateSettingsInternal();
            if (tmpList == null || tmpList.isEmpty()) continue;
            incompatibilities.add("Section: " + sec.getSection().getName());
            incompatibilities.addAll(tmpList);
        }
        tmpList = this.validateSettingsCombined(schema);
        if (tmpList != null && !tmpList.isEmpty()) {
            incompatibilities.add("COMBINED INCOMPATIBILITIES IN SETTINGS");
            incompatibilities.addAll(tmpList);
        }
        if (!incompatibilities.isEmpty()) {
            throw new ClusInvalidSettingsException(incompatibilities);
        }
    }

    private List<String> validateSettingsCombined(ClusSchema schema) {
        ArrayList<String> invalid = new ArrayList<String>();
        if (this.getEnsemble().isEnsembleMode() && this.getEnsemble().isEnsembleROSEnabled()) {
            if (!Arrays.asList(SettingsEnsemble.EnsembleMethod.Bagging, SettingsEnsemble.EnsembleMethod.RForest, SettingsEnsemble.EnsembleMethod.ExtraTrees).contains((Object)this.getEnsemble().getEnsembleMethod())) {
                invalid.add("ROS: Extension is not implemented for the selected ensemble method!");
            }
            List<ClusAttrType> targets = Arrays.asList(schema.getTargetAttributes());
            List<ClusAttrType> clustering = Arrays.asList(schema.getClusteringAttributes());
            if (!clustering.containsAll(targets) || !targets.containsAll(clustering)) {
                invalid.add("ROS: target and clustering attributes should be the same.");
            }
        }
        return invalid;
    }

    public void process(CMDLineArgs cargs) {
        if (cargs.hasOption("target")) {
            this.m_SettAttribute.setTarget(cargs.getOptionValue("target"));
        }
        if (cargs.hasOption("disable")) {
            String disarg = cargs.getOptionValue("disable");
            String orig = this.m_SettAttribute.getDisabled();
            if (StringUtils.unCaseCompare(orig, "None")) {
                this.m_SettAttribute.setDisabled(disarg);
            } else {
                this.m_SettAttribute.setDisabled(orig + "," + disarg);
            }
        }
        if (cargs.hasOption("silent")) {
            this.m_SettGeneral.enableVerbose(0);
        }
    }

    public void update(ClusSchema schema) {
        this.m_SettTree.setFTest(this.m_SettTree.getFTest(), this.m_SettGeneral.getVerbose());
        SettingsTree.MINIMAL_WEIGHT = this.m_SettModel.getMinimalWeight();
        SettingsTree.ONE_NOMINAL = schema.getNbNominalTargetAttributes() == 1 && schema.getNbNumericTargetAttributes() == 0;
        SettingsTree.ALPHA = this.m_SettTree.getSpatialAlpha();
        SettingsOutput.SHOW_UNKNOWN_FREQ = this.m_SettOutput.isShowUnknown();
        SettingsOutput.SHOW_BRANCH_FREQ = this.m_SettOutput.isShowBranchFreq();
        SettingsExperimental.SHOW_XVAL_FOREST = this.m_SettExperimental.isShowXValForest();
        SettingsBeamSearch.SIZE_PENALTY = this.m_SettBeamSearch.getSizePenalty();
        SettingsBeamSearch.BEAM_WIDTH = this.m_SettBeamSearch.getBeamWidth();
        SettingsBeamSearch.BEAM_SIMILARITY = this.m_SettBeamSearch.getBeamSimilarity();
        SettingsBeamSearch.BEAM_SYNT_DIST_CONSTR = this.m_SettBeamSearch.hasBeamConstraintFile();
    }

    public void updateDisabledSettings() {
        SettingsTree.PruningMethod pruning = this.m_SettTree.getPruningMethod();
        SettingsTree.Heuristic heur = this.m_SettTree.getHeuristic();
        this.m_SettTree.setM5PruningMultEnabled(Arrays.asList(SettingsTree.PruningMethod.M5, SettingsTree.PruningMethod.M5Multi).contains((Object)pruning));
        this.m_SettTree.set1SERuleEnabled(pruning.equals((Object)SettingsTree.PruningMethod.GarofalakisVSB));
        this.m_SettTree.setFTestEnabled(Arrays.asList(SettingsTree.Heuristic.SSPD, SettingsTree.Heuristic.VarianceReduction).contains((Object)heur));
        this.m_SettData.setPruneSetMaxEnabled(!this.m_SettData.isPruneSetString("None"));
        this.m_SettGeneral.getResourceInfoLoaded().setValue(ResourceInfo.isLibLoaded() ? SettingsGeneral.ResourceInfoLoad.Yes : SettingsGeneral.ResourceInfoLoad.No);
    }

    public void show(PrintWriter where) throws IOException {
        this.updateDisabledSettings();
        boolean tempInduceParamNeeded = this.m_SettRules.getRuleInduceParamsDisabled();
        if (this.m_SettRules.getCoveringMethod().equals((Object)SettingsRules.CoveringMethod.RulesFromTree) && tempInduceParamNeeded) {
            this.m_SettRules.returnRuleInduceParams();
        }
        this.m_Ini.save(where);
        if (this.m_SettRules.getCoveringMethod().equals((Object)SettingsRules.CoveringMethod.RulesFromTree) && tempInduceParamNeeded) {
            this.m_SettRules.disableRuleInduceParams();
        }
    }

    public static Settings getDefaultSettings() {
        Settings sett = new Settings();
        sett.create();
        return sett;
    }
}

