/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.main;

import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.main.ClusModelInfoList;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.model.ClusModelInfo;
import si.ijs.kt.clus.util.exception.ClusException;

public class ClusSummary
extends ClusModelInfoList {
    public static final long serialVersionUID = 1L;
    protected int m_Runs;
    protected int m_TotalRuns = 1;
    protected ClusErrorList m_TrainErr;
    protected ClusErrorList m_TestErr;
    protected ClusErrorList m_ValidErr;
    protected ClusStatManager m_StatMgr;

    public void resetAll() {
        this.m_Models.clear();
        this.m_IndTime = 0L;
        this.m_PrepTime = 0L;
        this.m_PruneTime = 0L;
        this.m_PredictionTime = 0L;
    }

    public void setStatManager(ClusStatManager mgr) {
        this.m_StatMgr = mgr;
    }

    @Override
    public ClusStatManager getStatManager() {
        return this.m_StatMgr;
    }

    @Override
    public ClusErrorList getTrainError() {
        return this.m_TrainErr;
    }

    @Override
    public ClusErrorList getTestError() {
        return this.m_TestErr;
    }

    @Override
    public ClusErrorList getValidationError() {
        return this.m_ValidErr;
    }

    public boolean hasTestError() {
        return this.m_TestErr != null;
    }

    public void setTrainError(ClusErrorList err) {
        this.m_TrainErr = err;
    }

    public void setTestError(ClusErrorList err) {
        this.m_TestErr = err;
    }

    public void setValidationError(ClusErrorList err) {
        this.m_ValidErr = err;
    }

    public int getNbRuns() {
        return this.m_Runs;
    }

    public int getTotalRuns() {
        return this.m_TotalRuns;
    }

    public void setTotalRuns(int tot) {
        this.m_TotalRuns = tot;
    }

    public ClusSummary getSummaryClone() throws ClusException {
        ClusSummary summ = new ClusSummary();
        summ.m_StatMgr = this.getStatManager();
        if (this.m_TestErr != null) {
            summ.m_TestErr = this.m_TestErr.getErrorClone();
        }
        if (this.m_TrainErr != null) {
            summ.m_TrainErr = this.m_TrainErr.getErrorClone();
        }
        if (this.m_ValidErr != null) {
            summ.m_ValidErr = this.m_ValidErr.getErrorClone();
        }
        summ.setModels(this.cloneModels());
        return summ;
    }

    public void addSummary(ClusRun cr) throws ClusException {
        ++this.m_Runs;
        this.m_IndTime += cr.getInductionTime();
        this.m_PruneTime += cr.getPruneTime();
        this.m_PredictionTime += cr.getPredictionTime();
        this.m_PredictionTimeNbExamples = (int)((long)this.m_PredictionTimeNbExamples + cr.getPredictionTimeNbExamples());
        this.m_PrepTime += cr.getPrepareTime();
        int nb_models = cr.getNbModels();
        for (int i = 0; i < nb_models; ++i) {
            ClusModelInfo mi = cr.getModelInfo(i);
            if (mi == null) continue;
            ClusModelInfo my = this.addModelInfo(i);
            my.add(mi);
        }
    }
}

