/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.main;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.math3.distribution.ChiSquaredDistribution;
import si.ijs.kt.clus.data.ClusData;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.attweights.ClusAttributeWeights;
import si.ijs.kt.clus.data.attweights.ClusNormalizedAttributeWeights;
import si.ijs.kt.clus.data.rows.DataPreprocs;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.complex.SetAttrType;
import si.ijs.kt.clus.data.type.complex.TupleAttrType;
import si.ijs.kt.clus.data.type.hierarchies.ClassesAttrType;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.data.type.primitive.TimeSeriesAttrType;
import si.ijs.kt.clus.distance.ClusDistance;
import si.ijs.kt.clus.distance.complex.SetDistance;
import si.ijs.kt.clus.distance.complex.sets.EuclideanDistance;
import si.ijs.kt.clus.distance.complex.sets.GSMDistance;
import si.ijs.kt.clus.distance.complex.sets.HammingLossDistance;
import si.ijs.kt.clus.distance.complex.sets.JaccardDistance;
import si.ijs.kt.clus.distance.complex.tuples.SSPDMatrix;
import si.ijs.kt.clus.distance.hierarchies.HierJaccardDistance;
import si.ijs.kt.clus.distance.primitive.nominal.NominalDistance;
import si.ijs.kt.clus.distance.primitive.timeseries.DTWTimeSeriesDist;
import si.ijs.kt.clus.distance.primitive.timeseries.QDMTimeSeriesDist;
import si.ijs.kt.clus.distance.primitive.timeseries.TSCTimeSeriesDist;
import si.ijs.kt.clus.distance.primitive.timeseries.TimeSeriesDist;
import si.ijs.kt.clus.error.AbsoluteError;
import si.ijs.kt.clus.error.AvgDistancesError;
import si.ijs.kt.clus.error.ContingencyTable;
import si.ijs.kt.clus.error.ICVPairwiseDistancesError;
import si.ijs.kt.clus.error.MSError;
import si.ijs.kt.clus.error.MSNominalError;
import si.ijs.kt.clus.error.MisclassificationError;
import si.ijs.kt.clus.error.PearsonCorrelation;
import si.ijs.kt.clus.error.RMSError;
import si.ijs.kt.clus.error.RRMSError;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.error.common.multiscore.MultiScore;
import si.ijs.kt.clus.error.hmlc.HierClassWiseAccuracy;
import si.ijs.kt.clus.error.hmlc.HierErrorMeasures;
import si.ijs.kt.clus.error.mlc.AveragePrecision;
import si.ijs.kt.clus.error.mlc.Coverage;
import si.ijs.kt.clus.error.mlc.HammingLoss;
import si.ijs.kt.clus.error.mlc.MLAccuracy;
import si.ijs.kt.clus.error.mlc.MLFOneMeasure;
import si.ijs.kt.clus.error.mlc.MLPrecision;
import si.ijs.kt.clus.error.mlc.MLRecall;
import si.ijs.kt.clus.error.mlc.MLaverageAUPRC;
import si.ijs.kt.clus.error.mlc.MLaverageAUROC;
import si.ijs.kt.clus.error.mlc.MLpooledAUPRC;
import si.ijs.kt.clus.error.mlc.MLweightedAUPRC;
import si.ijs.kt.clus.error.mlc.MacroFOne;
import si.ijs.kt.clus.error.mlc.MacroPrecision;
import si.ijs.kt.clus.error.mlc.MacroRecall;
import si.ijs.kt.clus.error.mlc.MicroFOne;
import si.ijs.kt.clus.error.mlc.MicroPrecision;
import si.ijs.kt.clus.error.mlc.MicroRecall;
import si.ijs.kt.clus.error.mlc.OneError;
import si.ijs.kt.clus.error.mlc.RankingLoss;
import si.ijs.kt.clus.error.mlcForHmlc.MlcMeasuresForHmlc;
import si.ijs.kt.clus.error.sets.Accuracy;
import si.ijs.kt.clus.error.sets.F1Score;
import si.ijs.kt.clus.error.sets.Precision;
import si.ijs.kt.clus.error.sets.Recall;
import si.ijs.kt.clus.error.sets.SubsetAccuracy;
import si.ijs.kt.clus.ext.beamsearch.ClusBeamHeuristicError;
import si.ijs.kt.clus.ext.beamsearch.ClusBeamHeuristicMEstimate;
import si.ijs.kt.clus.ext.beamsearch.ClusBeamHeuristicMorishita;
import si.ijs.kt.clus.ext.beamsearch.ClusBeamHeuristicSS;
import si.ijs.kt.clus.ext.beamsearch.ClusBeamSimRegrStat;
import si.ijs.kt.clus.ext.hierarchical.ClassHierarchy;
import si.ijs.kt.clus.ext.hierarchical.ClassesTuple;
import si.ijs.kt.clus.ext.hierarchical.HierClassTresholdPruner;
import si.ijs.kt.clus.ext.hierarchical.HierRemoveInsigClasses;
import si.ijs.kt.clus.ext.hierarchicalmtr.ClusHMTRHierarchy;
import si.ijs.kt.clus.ext.ilevelc.ILevelCRandIndex;
import si.ijs.kt.clus.ext.ilevelc.ILevelCStatistic;
import si.ijs.kt.clus.ext.semisupervised.Helper;
import si.ijs.kt.clus.ext.semisupervised.ModifiedGainHeuristic;
import si.ijs.kt.clus.ext.semisupervised.SemiSupMinLabeledWeightStopCrit;
import si.ijs.kt.clus.ext.structuredTypes.SetStatistic;
import si.ijs.kt.clus.ext.structuredTypes.TupleStatistic;
import si.ijs.kt.clus.ext.timeseries.TimeSeriesSignificantChangeTesterXVAL;
import si.ijs.kt.clus.ext.timeseries.TimeSeriesStat;
import si.ijs.kt.clus.heuristic.ClusHeuristic;
import si.ijs.kt.clus.heuristic.GISHeuristic;
import si.ijs.kt.clus.heuristic.GainHeuristic;
import si.ijs.kt.clus.heuristic.GeneticDistanceHeuristicMatrix;
import si.ijs.kt.clus.heuristic.ReducedErrorHeuristic;
import si.ijs.kt.clus.heuristic.VarianceReductionHeuristic;
import si.ijs.kt.clus.heuristic.VarianceReductionHeuristicEfficient;
import si.ijs.kt.clus.heuristic.VarianceReductionHeuristicInclMissingValues;
import si.ijs.kt.clus.heuristic.hierarchical.ClusRuleHeuristicHierarchical;
import si.ijs.kt.clus.heuristic.rules.ClusRuleHeuristicDispersionAdt;
import si.ijs.kt.clus.heuristic.rules.ClusRuleHeuristicDispersionMlt;
import si.ijs.kt.clus.heuristic.rules.ClusRuleHeuristicError;
import si.ijs.kt.clus.heuristic.rules.ClusRuleHeuristicMEstimate;
import si.ijs.kt.clus.heuristic.rules.ClusRuleHeuristicRDispersionAdt;
import si.ijs.kt.clus.heuristic.rules.ClusRuleHeuristicRDispersionMlt;
import si.ijs.kt.clus.heuristic.rules.ClusRuleHeuristicSSD;
import si.ijs.kt.clus.heuristic.stopCriterion.ClusStopCriterion;
import si.ijs.kt.clus.heuristic.stopCriterion.ClusStopCriterionMinNbExamples;
import si.ijs.kt.clus.heuristic.stopCriterion.ClusStopCriterionMinWeight;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsBeamSearch;
import si.ijs.kt.clus.main.settings.section.SettingsConstraints;
import si.ijs.kt.clus.main.settings.section.SettingsHMLC;
import si.ijs.kt.clus.main.settings.section.SettingsHMTR;
import si.ijs.kt.clus.main.settings.section.SettingsRules;
import si.ijs.kt.clus.main.settings.section.SettingsTimeSeries;
import si.ijs.kt.clus.main.settings.section.SettingsTree;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.pruning.BottomUpPruningVSB;
import si.ijs.kt.clus.pruning.C45Pruner;
import si.ijs.kt.clus.pruning.CartPruning;
import si.ijs.kt.clus.pruning.EncodingCostPruning;
import si.ijs.kt.clus.pruning.M5Pruner;
import si.ijs.kt.clus.pruning.M5PrunerMulti;
import si.ijs.kt.clus.pruning.PruneTree;
import si.ijs.kt.clus.pruning.SequencePruningVSB;
import si.ijs.kt.clus.pruning.SizeConstraintPruning;
import si.ijs.kt.clus.statistic.ClassificationStat;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.CombStat;
import si.ijs.kt.clus.statistic.CombStatClassRegHier;
import si.ijs.kt.clus.statistic.GeneticDistanceStat;
import si.ijs.kt.clus.statistic.HierSingleLabelStat;
import si.ijs.kt.clus.statistic.HierSumPairwiseDistancesStat;
import si.ijs.kt.clus.statistic.RegressionStat;
import si.ijs.kt.clus.statistic.SumPairwiseDistancesStat;
import si.ijs.kt.clus.statistic.WHTDStatistic;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileNominalOrDoubleOrVector;

public class ClusStatManager
implements Serializable {
    public static final long serialVersionUID = 1L;
    protected static Mode m_TargetMode = Mode.NONE;
    protected static Mode m_ClusterMode = Mode.NONE;
    protected transient ClusHeuristic m_Heuristic;
    protected ClusSchema m_Schema;
    protected boolean m_BeamSearch;
    protected boolean m_RuleInduceOnly;
    protected Settings m_Settings;
    protected ClusStatistic[] m_TrainSetStatAttrUse;
    protected ClusStatistic[] m_StatisticAttrUse;
    protected ClusAttributeWeights m_NormalizationWeights;
    protected ClusAttributeWeights m_ClusteringWeights;
    protected ClusNormalizedAttributeWeights m_DispersionWeights;
    protected ClassHierarchy m_Hier;
    protected ClusHMTRHierarchy m_HMTRHier;
    protected SSPDMatrix m_SSPDMtrx;
    protected double[] m_ChiSquareInvProb;

    public ClusStatManager(ClusSchema schema, Settings sett) throws ClusException, IOException {
        this(schema, sett, true);
    }

    public ClusStatManager(ClusSchema schema, Settings sett, boolean docheck) throws ClusException, IOException {
        this.m_Schema = schema;
        this.m_Settings = sett;
        if (docheck) {
            this.check();
        }
    }

    public TargetType getTargetType() {
        if (this.getSettings().getMLC().getSection().isEnabled()) {
            return TargetType.MULTI_LABEL_CLASSIFICATION;
        }
        ClusAttrType[] targets = this.m_Schema.getAllAttrUse(ClusAttrType.AttributeUseType.Target);
        boolean isHMLC = true;
        for (ClusAttrType a : targets) {
            if (a instanceof ClassesAttrType) continue;
            isHMLC = false;
            break;
        }
        if (isHMLC) {
            return TargetType.HIERACHICAL_MULTI_LABEL_CLASSIFICATION;
        }
        boolean isClassification = true;
        for (ClusAttrType a : targets) {
            if (a instanceof NominalAttrType) continue;
            isClassification = false;
            break;
        }
        if (isClassification) {
            return TargetType.CLASSIFICATION;
        }
        boolean isRegression = true;
        for (ClusAttrType a : targets) {
            if (a instanceof NumericAttrType) continue;
            isRegression = false;
            break;
        }
        if (isRegression) {
            return TargetType.REGRESSION;
        }
        return TargetType.OTHER;
    }

    public Settings getSettings() {
        return this.m_Settings;
    }

    public final ClusSchema getSchema() {
        return this.m_Schema;
    }

    public final Mode getTargetMode() {
        return m_TargetMode;
    }

    public final Mode getClusterMode() {
        return m_ClusterMode;
    }

    public final ClassHierarchy getHier() {
        return this.m_Hier;
    }

    public void initStatisticAndStatManager() throws ClusException, IOException {
        this.initWeights();
        this.initStatistic();
        this.initHierarchySettings();
    }

    public ClusAttributeWeights getClusteringWeights() {
        return this.m_ClusteringWeights;
    }

    public ClusNormalizedAttributeWeights getDispersionWeights() {
        return this.m_DispersionWeights;
    }

    public ClusAttributeWeights getNormalizationWeights() {
        return this.m_NormalizationWeights;
    }

    public static boolean hasBitEqualToOne(boolean[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i]) continue;
            return true;
        }
        return false;
    }

    public void initWeights(ClusNormalizedAttributeWeights result, NumericAttrType[] num, NominalAttrType[] nom, INIFileNominalOrDoubleOrVector winfo) throws ClusException {
        result.setAllWeights(0.0);
        int nbattr = result.getNbAttributes();
        if (winfo.hasArrayIndexNames()) {
            double tw;
            int i;
            double target_weight = winfo.getDouble(0);
            double non_target_weight = winfo.getDouble(1);
            double num_weight = winfo.getDouble(2);
            double nom_weight = winfo.getDouble(3);
            if (this.getSettings().getGeneral().getVerbose() >= 2) {
                ClusLogger.info("  Target weight     = " + target_weight);
                ClusLogger.info("  Non target weight = " + non_target_weight);
                ClusLogger.info("  Numeric weight    = " + num_weight);
                ClusLogger.info("  Nominal weight    = " + nom_weight);
            }
            for (i = 0; i < num.length; ++i) {
                NumericAttrType cr_num = num[i];
                tw = cr_num.getStatus().equals((Object)ClusAttrType.Status.Target) ? target_weight : non_target_weight;
                result.setWeight(cr_num, num_weight * tw);
            }
            for (i = 0; i < nom.length; ++i) {
                NominalAttrType cr_nom = nom[i];
                tw = cr_nom.getStatus().equals((Object)ClusAttrType.Status.Target) ? target_weight : non_target_weight;
                result.setWeight(cr_nom, nom_weight * tw);
            }
        } else if (winfo.isVector()) {
            if (this.getClusterMode() == Mode.HIER_CLASS_AND_REG) {
                int i;
                int l = winfo.getVectorLength();
                if (l + this.m_Hier.getTotal() != nbattr) {
                    throw new ClusException("Number of attributes is " + (nbattr - this.m_Hier.getTotal()) + " but weight vector has only " + l + " components");
                }
                for (i = 0; i < l - 1; ++i) {
                    result.setWeight(i, winfo.getDouble(i));
                }
                for (i = winfo.getVectorLength(); i < nbattr; ++i) {
                    result.setWeight(i, winfo.getDouble(l - 1));
                }
            } else {
                if (nbattr != winfo.getVectorLength()) {
                    throw new ClusException("Number of attributes is " + nbattr + " but weight vector has only " + winfo.getVectorLength() + " components");
                }
                for (int i = 0; i < nbattr; ++i) {
                    result.setWeight(i, winfo.getDouble(i));
                }
            }
        } else {
            result.setAllWeights(winfo.getDouble());
        }
        if (this.isRuleInduceOnly() && this.getClusterMode().isClassificationOrRegression()) {
            NominalAttrType cr_nom;
            NumericAttrType cr_num;
            int i;
            double sum = 0.0;
            for (i = 0; i < num.length; ++i) {
                cr_num = num[i];
                sum += result.getWeight(cr_num);
            }
            for (i = 0; i < nom.length; ++i) {
                cr_nom = nom[i];
                sum += result.getWeight(cr_nom);
            }
            if (sum <= 0.0) {
                throw new ClusException("initWeights(): Sum of clustering/dispersion weights must be > 0!");
            }
            for (i = 0; i < num.length; ++i) {
                cr_num = num[i];
                result.setWeight(cr_num, result.getWeight(cr_num) / sum);
            }
            for (i = 0; i < nom.length; ++i) {
                cr_nom = nom[i];
                result.setWeight(cr_nom, result.getWeight(cr_nom) / sum);
            }
        }
    }

    public void initDispersionWeights() throws ClusException {
        NumericAttrType[] num = this.m_Schema.getNumericAttrUse(ClusAttrType.AttributeUseType.All);
        NominalAttrType[] nom = this.m_Schema.getNominalAttrUse(ClusAttrType.AttributeUseType.All);
        this.initWeights(this.m_DispersionWeights, num, nom, this.getSettings().getRules().getDispersionWeights());
        if (this.getSettings().getGeneral().getVerbose() >= 1 && (this.isRuleInduceOnly() || this.isTreeToRuleInduce()) && this.getSettings().getRules().computeDispersion()) {
            ClusLogger.info("Dispersion:   " + this.m_DispersionWeights.getName(this.m_Schema.getAllAttrUse(ClusAttrType.AttributeUseType.All)));
        }
    }

    public void initClusteringWeights() throws ClusException {
        if (this.getClusterMode().includesHierarchical()) {
            int i;
            int nb_attrs = this.m_Schema.getNbAttributes();
            double[] weights = this.m_Hier.getWeights();
            NumericAttrType[] dummy = this.m_Hier.getDummyAttrs();
            double[] temp = null;
            if (this.getClusterMode() == Mode.HIER_CLASS_AND_REG) {
                temp = ((ClusNormalizedAttributeWeights)this.m_ClusteringWeights).getNormalizationWeights();
                double sum = Helper.sum(weights);
                for (int i2 = 0; i2 < weights.length; ++i2) {
                    weights[i2] = weights[i2] / sum;
                }
            }
            this.m_ClusteringWeights = new ClusAttributeWeights(nb_attrs + this.m_Hier.getTotal());
            for (i = 0; i < weights.length; ++i) {
                this.m_ClusteringWeights.setWeight(dummy[i], weights[i]);
            }
            if (this.getClusterMode() == Mode.HIER_CLASS_AND_REG) {
                for (i = 0; i < temp.length - 1; ++i) {
                    this.m_ClusteringWeights.setWeight(i, temp[i]);
                }
                this.m_ClusteringWeights = new ClusNormalizedAttributeWeights(this.m_ClusteringWeights);
            } else {
                return;
            }
        }
        NumericAttrType[] num = this.m_Schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Clustering);
        NominalAttrType[] nom = this.m_Schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Clustering);
        this.initWeights((ClusNormalizedAttributeWeights)this.m_ClusteringWeights, num, nom, this.getSettings().getAttribute().getClusteringWeights());
        if (this.getSettings().getGeneral().getVerbose() > 1) {
            ClusLogger.info("Clustering: " + this.m_ClusteringWeights.getName(this.m_Schema.getAllAttrUse(ClusAttrType.AttributeUseType.Clustering)));
        }
    }

    public void initNormalizationWeights(ClusStatistic stat, ClusData data) throws ClusException {
        int nbattr = this.m_Schema.getNbAttributes();
        this.m_NormalizationWeights.setAllWeights(1.0);
        boolean[] shouldNormalize = new boolean[nbattr];
        INIFileNominalOrDoubleOrVector winfo = this.getSettings().getAttribute().getNormalizationWeights();
        if (winfo.isVector()) {
            if (nbattr != winfo.getVectorLength()) {
                throw new ClusException("Number of attributes is " + nbattr + " but weight vector has only " + winfo.getVectorLength() + " components");
            }
            for (int i = 0; i < nbattr; ++i) {
                if (winfo.isNominal(i)) {
                    shouldNormalize[i] = true;
                    continue;
                }
                this.m_NormalizationWeights.setWeight(i, winfo.getDouble(i));
            }
        } else if (winfo.isNominal() && winfo.getNominal() == 0) {
            Arrays.fill(shouldNormalize, true);
        } else {
            this.m_NormalizationWeights.setAllWeights(winfo.getDouble());
        }
        if (ClusStatManager.hasBitEqualToOne(shouldNormalize)) {
            data.calcTotalStat(stat);
            CombStat cmb = (CombStat)stat;
            RegressionStat rstat = cmb.getRegressionStat();
            rstat.initNormalizationWeights(this.m_NormalizationWeights, shouldNormalize);
            if (!this.isRuleInduceOnly()) {
                ClassificationStat cstat = cmb.getClassificationStat();
                cstat.initNormalizationWeights(this.m_NormalizationWeights, shouldNormalize);
            }
            if (this.getClusterMode() == Mode.TIME_SERIES) {
                TimeSeriesStat tstat = (TimeSeriesStat)this.createStatistic(ClusAttrType.AttributeUseType.Target);
                ((RowData)data).calcTotalStatBitVector(tstat);
                tstat.initNormalizationWeights(this.m_NormalizationWeights, shouldNormalize);
            }
        }
    }

    public void initWeights() {
        int nbattr = this.m_Schema.getNbAttributes();
        this.m_NormalizationWeights = new ClusAttributeWeights(nbattr);
        this.m_NormalizationWeights.setAllWeights(1.0);
        this.m_ClusteringWeights = new ClusNormalizedAttributeWeights(this.m_NormalizationWeights);
        this.m_DispersionWeights = new ClusNormalizedAttributeWeights(this.m_NormalizationWeights);
    }

    public void check() throws ClusException, IOException {
        boolean is_multilabel;
        int nb_types = 0;
        int nb_nom = this.m_Schema.getNbNominalAttrUse(ClusAttrType.AttributeUseType.Clustering);
        int nb_num = this.m_Schema.getNbNumericAttrUse(ClusAttrType.AttributeUseType.Clustering);
        if (this.getSettings().getGeneral().getVerbose() >= 1) {
            ClusLogger.info("Clustering attributes check ==> #nominal: " + nb_nom + " #numeric: " + nb_num);
        }
        if (nb_nom > 0 && nb_num > 0) {
            m_ClusterMode = Mode.CLASSIFY_AND_REGRESSION;
        } else if (nb_nom > 0) {
            m_ClusterMode = Mode.CLASSIFY;
        } else if (nb_num > 0) {
            m_ClusterMode = Mode.REGRESSION;
        }
        if (this.m_Schema.hasAttributeType(ClusAttrType.AttributeUseType.All, ClusAttrType.AttributeType.Classes)) {
            this.getSettings().getHMLC().setSectionHierarchicalEnabled(true);
            this.createHierarchy();
            if (this.m_Schema.hasAttributeType(ClusAttrType.AttributeUseType.Clustering, ClusAttrType.AttributeType.Classes)) {
                m_ClusterMode = nb_nom > 0 || nb_num > 0 ? Mode.HIER_CLASS_AND_REG : Mode.HIERARCHICAL;
            }
            if (this.m_Schema.hasAttributeType(ClusAttrType.AttributeUseType.Target, ClusAttrType.AttributeType.Classes)) {
                m_TargetMode = Mode.HIERARCHICAL;
                ++nb_types;
            }
        }
        NumericAttrType[] num = this.m_Schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target);
        NominalAttrType[] nom = this.m_Schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target);
        TimeSeriesAttrType[] ts = this.m_Schema.getTimeSeriesAttrUse(ClusAttrType.AttributeUseType.Target);
        if (nom.length > 0 && num.length > 0) {
            m_TargetMode = Mode.CLASSIFY_AND_REGRESSION;
            ++nb_types;
        } else if (nom.length > 0) {
            m_TargetMode = Mode.CLASSIFY;
            ++nb_types;
        } else if (num.length > 0) {
            m_TargetMode = Mode.REGRESSION;
            ++nb_types;
        }
        boolean bl = is_multilabel = num.length == 0 && ts.length == 0 && nom.length > 1;
        if (is_multilabel) {
            Object[] twoLabels = new String[]{"1", "0"};
            for (int attr = 0; attr < nom.length; ++attr) {
                if (Arrays.equals(nom[attr].getValues(), twoLabels)) continue;
                is_multilabel = false;
                break;
            }
        }
        this.getSettings().getMLC().setSectionMultiLabelEnabled(is_multilabel);
        int nb_int = 0;
        if (nb_int > 0 || this.getSettings().getTree().getHeuristic().equals((Object)SettingsTree.Heuristic.SSPD)) {
            m_TargetMode = Mode.SSPD;
            m_ClusterMode = Mode.SSPD;
            this.m_SSPDMtrx = SSPDMatrix.read(this.getSettings().getGeneric().getFileAbsolute(this.getSettings().getGeneric().getAppName() + ".dist"), this.getSettings());
            ++nb_types;
        }
        if (this.getSettings().getTree().getHeuristic().equals((Object)SettingsTree.Heuristic.GeneticDistance)) {
            m_TargetMode = Mode.PHYLO;
            m_ClusterMode = Mode.PHYLO;
        }
        if (this.getSettings().getTimeSeries().isSectionTimeSeriesEnabled()) {
            m_TargetMode = Mode.TIME_SERIES;
            m_ClusterMode = Mode.TIME_SERIES;
            ++nb_types;
        }
        if (this.getSettings().getTree().getHeuristic().equals((Object)SettingsTree.Heuristic.StructuredData)) {
            m_TargetMode = Mode.STRUCTURED;
            m_ClusterMode = Mode.STRUCTURED;
            ++nb_types;
        }
        if (this.getSettings().getILevelC().isSectionILevelCEnabled()) {
            m_TargetMode = Mode.ILEVELC;
            m_ClusterMode = Mode.ILEVELC;
        }
        if (this.getSettings().getBeamSearch().isBeamSearchMode() && this.getSettings().getBeamSearch().getBeamSimilarity() != 0.0) {
            m_TargetMode = Mode.BEAM_SEARCH;
            m_ClusterMode = Mode.BEAM_SEARCH;
        }
        if (this.getSettings().getHMTR().isSectionHMTREnabled()) {
            m_TargetMode = Mode.HIERARCHICAL_MTR;
            m_ClusterMode = Mode.HIERARCHICAL_MTR;
        }
        if (nb_types == 0) {
            System.err.println("No target value defined");
        }
        if (nb_types > 1 && !this.getSettings().getRelief().isRelief()) {
            throw new ClusException("Incompatible combination of target attribute types");
        }
    }

    public ClusStatistic createSuitableStat(NumericAttrType[] num, NominalAttrType[] nom) {
        if (num.length == 0) {
            if (m_TargetMode == Mode.PHYLO || m_ClusterMode == Mode.PHYLO) {
                return new GeneticDistanceStat(this.getSettings(), nom);
            }
            if (this.getSettings().getMLC().getSectionMultiLabel().isEnabled()) {
                return new ClassificationStat(this.getSettings(), nom, this.getSettings().getMLC().getMultiLabelThreshold());
            }
            return new ClassificationStat(this.getSettings(), nom);
        }
        if (nom.length == 0) {
            return new RegressionStat(this.getSettings(), num);
        }
        return new CombStat(this, num, nom);
    }

    public boolean heuristicNeedsCombStat() {
        if (this.isRuleInduceOnly()) {
            return Arrays.asList(SettingsTree.Heuristic.Default, SettingsTree.Heuristic.DispersionAdt, SettingsTree.Heuristic.DispersionMlt, SettingsTree.Heuristic.RDispersionAdt, SettingsTree.Heuristic.RDispersionMlt).contains((Object)this.getSettings().getTree().getHeuristic());
        }
        return false;
    }

    public synchronized void initStatistic() throws ClusException {
        this.m_StatisticAttrUse = new ClusStatistic[ClusAttrType.AttributeUseType.values().length];
        NumericAttrType[] num1 = this.m_Schema.getNumericAttrUse(ClusAttrType.AttributeUseType.All);
        NominalAttrType[] nom1 = this.m_Schema.getNominalAttrUse(ClusAttrType.AttributeUseType.All);
        this.setAllStatistic(new CombStat(this, num1, nom1));
        NumericAttrType[] num2 = this.m_Schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target);
        NominalAttrType[] nom2 = this.m_Schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target);
        this.setTargetStatistic(this.createSuitableStat(num2, nom2));
        NumericAttrType[] num3 = this.m_Schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Clustering);
        NominalAttrType[] nom3 = this.m_Schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Clustering);
        if (num3.length != 0 || nom3.length != 0) {
            if (this.heuristicNeedsCombStat()) {
                this.setClusteringStatistic(new CombStat(this, num3, nom3));
            } else {
                this.setClusteringStatistic(this.createSuitableStat(num3, nom3));
            }
        }
        if (this.getClusterMode().includesHierarchical() || this.getTargetMode().includesHierarchical()) {
            WHTDStatistic clustering;
            SettingsHMLC.HierarchyDistance hd = this.getSettings().getHMLC().getHierDistance();
            if (hd.equals((Object)SettingsHMLC.HierarchyDistance.PooledAUPRC) || hd.equals((Object)SettingsHMLC.HierarchyDistance.WeightedEuclidean)) {
                clustering = this.getSettings().getHMLC().getHierSingleLabel() && hd.equals((Object)SettingsHMLC.HierarchyDistance.WeightedEuclidean) ? new HierSingleLabelStat(this.getSettings(), this.m_Hier) : new WHTDStatistic(this.getSettings(), this.m_Hier);
            } else {
                HierJaccardDistance dist = null;
                if (this.getSettings().getHMLC().getHierDistance().equals((Object)SettingsHMLC.HierarchyDistance.Jaccard)) {
                    dist = new HierJaccardDistance(this.m_Hier.getType());
                }
                clustering = new HierSumPairwiseDistancesStat(this.getSettings(), this.m_Hier, dist);
            }
            if (this.getTargetMode() == Mode.HIERARCHICAL) {
                this.setTargetStatistic(clustering.cloneStat());
            }
            if (this.getClusterMode() == Mode.HIERARCHICAL) {
                this.setClusteringStatistic(clustering);
            } else if (this.getClusterMode() == Mode.HIER_CLASS_AND_REG) {
                this.setClusteringStatistic(new CombStatClassRegHier(this, num3, nom3, clustering));
                this.setAllStatistic(new CombStatClassRegHier(this, num3, nom3, (WHTDStatistic)clustering.cloneStat()));
            }
        } else if (this.getClusterMode() == Mode.HIERARCHICAL_MTR || this.getTargetMode() == Mode.HIERARCHICAL_MTR) {
            if (this.getSettings().getHMTR().getHMTRDistance().getValue().equals((Object)SettingsHMTR.HierarchyDistanceHMTR.WeightedEuclidean)) {
                if (this.getSettings().getGeneral().getVerbose() > 0) {
                    ClusLogger.info("HMTR - Euclidean distance");
                }
            } else if (this.getSettings().getHMTR().getHMTRDistance().getValue().equals((Object)SettingsHMTR.HierarchyDistanceHMTR.Jaccard) && this.getSettings().getGeneral().getVerbose() > 0) {
                ClusLogger.info("HMTR - Jaccard distance");
            }
            this.m_HMTRHier = this.m_Schema.getHMTRHierarchy();
            this.setTargetStatistic(new RegressionStat(this.getSettings(), num2, this.m_HMTRHier));
            this.setClusteringStatistic(new RegressionStat(this.getSettings(), num3, this.m_HMTRHier));
        } else if (this.getClusterMode() == Mode.SSPD || this.getTargetMode() == Mode.SSPD) {
            ClusAttrType[] target = this.m_Schema.getAllAttrUse(ClusAttrType.AttributeUseType.Target);
            this.m_SSPDMtrx.setTarget(target);
            this.setClusteringStatistic(new SumPairwiseDistancesStat(this.getSettings(), this.m_SSPDMtrx, SettingsTimeSeries.TimeSeriesPrototypeComplexity.NPairs));
            this.setTargetStatistic(new SumPairwiseDistancesStat(this.getSettings(), this.m_SSPDMtrx, SettingsTimeSeries.TimeSeriesPrototypeComplexity.NPairs));
        } else if (this.getClusterMode() == Mode.TIME_SERIES || this.getTargetMode() == Mode.TIME_SERIES) {
            ClusAttrType[] targets = this.m_Schema.getAllAttrUse(ClusAttrType.AttributeUseType.Target);
            TimeSeriesAttrType type = (TimeSeriesAttrType)targets[0];
            SettingsTimeSeries.TimeSeriesPrototypeComplexity efficiency = this.getSettings().getTimeSeries().getTimeSeriesHeuristicSampling();
            switch (this.getSettings().getTimeSeries().getTimeSeriesDistance()) {
                case DTW: {
                    DTWTimeSeriesDist dist = new DTWTimeSeriesDist(type);
                    this.setClusteringStatistic(new TimeSeriesStat(this.getSettings(), type, dist, efficiency));
                    this.setTargetStatistic(new TimeSeriesStat(this.getSettings(), type, dist, efficiency));
                    break;
                }
                case QDM: {
                    if (type.isEqualLength()) {
                        QDMTimeSeriesDist qdm = new QDMTimeSeriesDist(type);
                        this.setClusteringStatistic(new TimeSeriesStat(this.getSettings(), type, qdm, efficiency));
                        this.setTargetStatistic(new TimeSeriesStat(this.getSettings(), type, qdm, efficiency));
                        break;
                    }
                    throw new ClusException("QDM Distance is not implemented for time series with different length");
                }
                case TSC: {
                    TSCTimeSeriesDist tsc = new TSCTimeSeriesDist(type);
                    this.setClusteringStatistic(new TimeSeriesStat(this.getSettings(), type, tsc, efficiency));
                    this.setTargetStatistic(new TimeSeriesStat(this.getSettings(), type, tsc, efficiency));
                }
            }
        } else if (this.getClusterMode() == Mode.STRUCTURED || this.getTargetMode() == Mode.STRUCTURED) {
            SettingsTimeSeries.TimeSeriesPrototypeComplexity efficiency = this.getSettings().getTree().getHeuristicComplexity();
            ClusAttrType[] structured_target = this.m_Schema.getAllAttrUse(ClusAttrType.AttributeUseType.Target);
            try {
                SetAttrType myType = (SetAttrType)structured_target[0];
                ClusDistance d = this.getInnerDistanceForType(myType.getTypeDefinition());
                SetDistance setDistance = null;
                switch (this.m_Settings.getTree().getSetDistance()) {
                    case GSMDistance: {
                        setDistance = new GSMDistance(myType, d, 1);
                        break;
                    }
                    case Euclidean: {
                        setDistance = new EuclideanDistance(myType, d);
                        break;
                    }
                    case HammingLoss: {
                        setDistance = new HammingLossDistance(myType, d);
                        break;
                    }
                    case Jaccard: {
                        setDistance = new JaccardDistance(myType, d);
                    }
                }
                this.setClusteringStatistic(new SetStatistic(this.getSettings(), myType, setDistance, efficiency));
                this.setTargetStatistic(new SetStatistic(this.getSettings(), myType, setDistance, efficiency));
            }
            catch (Exception e) {
                try {
                    TupleAttrType myType = (TupleAttrType)structured_target[0];
                    ClusDistance tupleDistance = ClusAttrType.createDistance(myType, this.m_Settings);
                    this.setClusteringStatistic(new TupleStatistic(this.getSettings(), myType, tupleDistance, efficiency));
                    this.setTargetStatistic(new TupleStatistic(this.getSettings(), myType, tupleDistance, efficiency));
                }
                catch (Exception e1) {
                    try {
                        TimeSeriesAttrType myType = (TimeSeriesAttrType)structured_target[0];
                        ClusDistance tupleDistance = ClusAttrType.createDistance(myType, this.m_Settings);
                        this.setClusteringStatistic(new TimeSeriesStat(this.getSettings(), myType, tupleDistance, efficiency));
                        this.setTargetStatistic(new TimeSeriesStat(this.getSettings(), myType, tupleDistance, efficiency));
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                        throw new ClusException(e2.getMessage());
                    }
                }
            }
        } else if (this.getClusterMode() == Mode.ILEVELC || this.getTargetMode() == Mode.ILEVELC) {
            this.setTargetStatistic(new ILevelCStatistic(this.getSettings(), num2));
            this.setClusteringStatistic(new ILevelCStatistic(this.getSettings(), num3));
        } else if ((this.getClusterMode() == Mode.BEAM_SEARCH || this.getTargetMode() == Mode.BEAM_SEARCH) && num3.length != 0 && num2.length != 0) {
            this.setTargetStatistic(new ClusBeamSimRegrStat(this.getSettings(), num2, null));
            this.setClusteringStatistic(new ClusBeamSimRegrStat(this.getSettings(), num3, null));
        }
    }

    private ClusDistance getInnerDistanceForType(String myType) {
        if (myType.startsWith("SET{")) {
            String def = myType;
            int open = 0;
            def = def.replace("SET{", "");
            def = def.substring(0, def.length() - 1);
            TimeSeriesDist cd = null;
            if (def.equalsIgnoreCase("TIMESERIES")) {
                switch (this.m_Settings.getTimeSeries().getTimeSeriesDistance()) {
                    case DTW: {
                        cd = new DTWTimeSeriesDist(null);
                        break;
                    }
                    case QDM: {
                        cd = new QDMTimeSeriesDist(null);
                    }
                }
                return cd;
            }
            for (int i = 0; i < def.length(); ++i) {
                if (def.charAt(i) == '[') {
                    ++open;
                } else if (def.charAt(i) == ']') {
                    --open;
                }
                if (open <= 1 || myType.contains("NOMINAL")) continue;
                throw new NotImplementedException();
            }
            if (myType.contains("NOMINAL")) {
                return new NominalDistance();
            }
        }
        return null;
    }

    public ClusHeuristic createHeuristic(SettingsTree.Heuristic type) {
        switch (type) {
            case Gain: {
                return new GainHeuristic(false, this.getClusteringWeights(), this.getSettings());
            }
        }
        return null;
    }

    public void initRuleHeuristic() throws ClusException {
        block22: {
            block23: {
                block21: {
                    if (this.getClusterMode() != Mode.CLASSIFY) break block21;
                    switch (this.getSettings().getTree().getHeuristic()) {
                        case Default: {
                            this.m_Heuristic = new ClusRuleHeuristicRDispersionMlt(this, this.getClusteringWeights(), this.getSettings());
                            this.getSettings().getTree().setHeuristic(SettingsTree.Heuristic.RDispersionMlt);
                            break block22;
                        }
                        case ReducedError: {
                            this.m_Heuristic = new ClusRuleHeuristicError(this, this.getClusteringWeights(), this.getSettings());
                            break block22;
                        }
                        case MEstimate: {
                            this.m_Heuristic = new ClusRuleHeuristicMEstimate(this.getSettings().getNominal().getMEstimate(), this.getSettings());
                            break block22;
                        }
                        case DispersionAdt: {
                            this.m_Heuristic = new ClusRuleHeuristicDispersionAdt(this, this.getClusteringWeights(), this.getSettings());
                            break block22;
                        }
                        case DispersionMlt: {
                            this.m_Heuristic = new ClusRuleHeuristicDispersionMlt(this, this.getClusteringWeights(), this.getSettings());
                            break block22;
                        }
                        case RDispersionAdt: {
                            this.m_Heuristic = new ClusRuleHeuristicRDispersionAdt(this, this.getClusteringWeights(), this.getSettings());
                            break block22;
                        }
                        case RDispersionMlt: {
                            this.m_Heuristic = new ClusRuleHeuristicRDispersionMlt(this, this.getClusteringWeights(), this.getSettings());
                            break block22;
                        }
                        default: {
                            throw new ClusException("Unsupported heuristic for single target classification rules!");
                        }
                    }
                }
                if (this.getClusterMode() != Mode.REGRESSION && this.getClusterMode() != Mode.CLASSIFY_AND_REGRESSION) break block23;
                switch (this.getSettings().getTree().getHeuristic()) {
                    case Default: {
                        this.m_Heuristic = new ClusRuleHeuristicRDispersionMlt(this, this.getClusteringWeights(), this.getSettings());
                        break block22;
                    }
                    case ReducedError: {
                        this.m_Heuristic = new ClusRuleHeuristicError(this, this.getClusteringWeights(), this.getSettings());
                        break block22;
                    }
                    case DispersionAdt: {
                        this.m_Heuristic = new ClusRuleHeuristicDispersionAdt(this, this.getClusteringWeights(), this.getSettings());
                        break block22;
                    }
                    case DispersionMlt: {
                        this.m_Heuristic = new ClusRuleHeuristicDispersionMlt(this, this.getClusteringWeights(), this.getSettings());
                        break block22;
                    }
                    case RDispersionAdt: {
                        this.m_Heuristic = new ClusRuleHeuristicRDispersionAdt(this, this.getClusteringWeights(), this.getSettings());
                        break block22;
                    }
                    case RDispersionMlt: {
                        this.m_Heuristic = new ClusRuleHeuristicRDispersionMlt(this, this.getClusteringWeights(), this.getSettings());
                        break block22;
                    }
                    default: {
                        throw new ClusException("Unsupported heuristic for multiple target or regression rules!");
                    }
                }
            }
            if (this.getClusterMode() == Mode.HIERARCHICAL) {
                this.m_Heuristic = new ClusRuleHeuristicHierarchical(this, this.getClusteringWeights(), this.getSettings());
                return;
            }
            if (this.getClusterMode() == Mode.TIME_SERIES) {
                String name = "Time Series Intra-Cluster Variation Heuristic for Rules";
                this.m_Heuristic = new ClusRuleHeuristicSSD(this, name, this.createClusteringStat(), this.getClusteringWeights(), this.getSettings());
                this.getSettings().getTree().setHeuristic(SettingsTree.Heuristic.VarianceReduction);
                return;
            }
            if (this.getClusterMode() == Mode.ILEVELC) {
                String name = "Intra-Cluster Variation Heuristic for Rules";
                this.m_Heuristic = new ClusRuleHeuristicSSD(this, name, this.createClusteringStat(), this.getClusteringWeights(), this.getSettings());
            } else {
                throw new ClusException("Unsupported mode for rules!");
            }
        }
    }

    public void initBeamSearchHeuristic() throws ClusException {
        this.m_Heuristic = this.getSettings().getTree().getHeuristic().equals((Object)SettingsTree.Heuristic.ReducedError) ? new ClusBeamHeuristicError(this.createClusteringStat(), this.getSettings()) : (this.getSettings().getTree().getHeuristic().equals((Object)SettingsTree.Heuristic.MEstimate) ? new ClusBeamHeuristicMEstimate(this.createClusteringStat(), this.getSettings().getNominal().getMEstimate(), this.getSettings()) : (this.getSettings().getTree().getHeuristic().equals((Object)SettingsTree.Heuristic.Morishita) ? new ClusBeamHeuristicMorishita(this.createClusteringStat(), this.getSettings()) : new ClusBeamHeuristicSS(this.createClusteringStat(), this.getClusteringWeights(), this.getSettings())));
    }

    public void initHeuristic() throws ClusException {
        if (this.isRuleInduceOnly() && !this.isTreeToRuleInduce()) {
            this.initRuleHeuristic();
            return;
        }
        if (this.isBeamSearch()) {
            this.initBeamSearchHeuristic();
            return;
        }
        if (this.getClusterMode().includesHierarchical()) {
            if (this.getSettings().getTree().getHeuristic().equals((Object)SettingsTree.Heuristic.VarianceReductionGIS)) {
                this.m_Heuristic = new GISHeuristic(this.getClusteringWeights(), this.m_Schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Clustering), this.getSettings());
            } else {
                this.m_Heuristic = new VarianceReductionHeuristicEfficient(this.getClusteringWeights(), null, this.getSettings());
                this.getSettings().getTree().setHeuristic(SettingsTree.Heuristic.VarianceReduction);
            }
            return;
        }
        if (this.getClusterMode() == Mode.SSPD) {
            ClusStatistic clusstat = this.createClusteringStat();
            this.m_Heuristic = new VarianceReductionHeuristic(clusstat.getDistanceName(), clusstat, this.getClusteringWeights(), this.getSettings());
            this.getSettings().getTree().setHeuristic(SettingsTree.Heuristic.SSPD);
            return;
        }
        if (this.getClusterMode() == Mode.TIME_SERIES) {
            ClusStatistic clusstat = this.createClusteringStat();
            this.m_Heuristic = new VarianceReductionHeuristic(clusstat.getDistanceName(), clusstat, this.getClusteringWeights(), this.getSettings());
            this.getSettings().getTree().setHeuristic(SettingsTree.Heuristic.VarianceReduction);
            return;
        }
        if (this.getClusterMode() == Mode.STRUCTURED) {
            ClusStatistic clusstat = this.createClusteringStat();
            this.m_Heuristic = new VarianceReductionHeuristic(clusstat.getDistanceName(), clusstat, this.getClusteringWeights(), this.getSettings());
            this.getSettings().getTree().setHeuristic(SettingsTree.Heuristic.VarianceReduction);
            return;
        }
        NumericAttrType[] num = this.m_Schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Clustering);
        ClusAttrType[] nom = this.m_Schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Clustering);
        if (this.getSettings().getTree().getHeuristic().equals((Object)SettingsTree.Heuristic.VarianceReductionMissing)) {
            this.m_Heuristic = new VarianceReductionHeuristicInclMissingValues(this.getClusteringWeights(), this.m_Schema.getAllAttrUse(ClusAttrType.AttributeUseType.Clustering), this.createClusteringStat(), this.getSettings());
            return;
        }
        if (num.length > 0 && nom.length > 0) {
            if (!this.getSettings().getTree().getHeuristic().equals((Object)SettingsTree.Heuristic.Default) && !this.getSettings().getTree().getHeuristic().equals((Object)SettingsTree.Heuristic.VarianceReduction)) {
                throw new ClusException("Only SS-Reduction heuristic can be used for combined classification/regression trees!");
            }
            this.m_Heuristic = new VarianceReductionHeuristicEfficient(this.getClusteringWeights(), this.m_Schema.getAllAttrUse(ClusAttrType.AttributeUseType.Clustering), this.getSettings());
            this.getSettings().getTree().setHeuristic(SettingsTree.Heuristic.VarianceReduction);
        } else if (num.length > 0) {
            List<SettingsTree.Heuristic> allowedHeuristics = Arrays.asList(SettingsTree.Heuristic.Default, SettingsTree.Heuristic.VarianceReduction, SettingsTree.Heuristic.VarianceReductionGIS);
            if (!allowedHeuristics.contains((Object)this.getSettings().getTree().getHeuristic())) {
                throw new ClusException("Only SS-Reduction heuristic and GISHeuristic can be used for regression trees!");
            }
            if (this.getSettings().getTree().getHeuristic().equals((Object)SettingsTree.Heuristic.VarianceReductionGIS)) {
                this.m_Heuristic = new GISHeuristic(this.getClusteringWeights(), this.m_Schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Clustering), this.getSettings());
            } else {
                this.m_Heuristic = new VarianceReductionHeuristicEfficient(this.getClusteringWeights(), this.m_Schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Clustering), this.getSettings());
                this.getSettings().getTree().setHeuristic(SettingsTree.Heuristic.VarianceReduction);
            }
        } else if (nom.length > 0) {
            if (this.getSettings().getTree().getHeuristic().equals((Object)SettingsTree.Heuristic.SemiSupervised)) {
                this.m_Heuristic = new ModifiedGainHeuristic(this.createClusteringStat(), this.getSettings());
            } else if (this.getSettings().getTree().getHeuristic().equals((Object)SettingsTree.Heuristic.ReducedError)) {
                this.m_Heuristic = new ReducedErrorHeuristic(this.createClusteringStat(), this.getSettings());
            } else if (this.getSettings().getTree().getHeuristic().equals((Object)SettingsTree.Heuristic.GeneticDistance)) {
                this.m_Heuristic = new GeneticDistanceHeuristicMatrix(this.getSettings());
            } else if (this.getSettings().getTree().getHeuristic().equals((Object)SettingsTree.Heuristic.VarianceReduction)) {
                this.m_Heuristic = new VarianceReductionHeuristicEfficient(this.getClusteringWeights(), nom, this.getSettings());
            } else if (this.getSettings().getTree().getHeuristic().equals((Object)SettingsTree.Heuristic.VarianceReductionGIS)) {
                this.m_Heuristic = new GISHeuristic(this.getClusteringWeights(), this.m_Schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Clustering), this.getSettings());
            } else if (this.getSettings().getTree().getHeuristic().equals((Object)SettingsTree.Heuristic.GainRatio)) {
                this.m_Heuristic = new GainHeuristic(true, this.getClusteringWeights(), this.getSettings());
            } else {
                ArrayList<SettingsTree.Heuristic> allowedHeuristics = new ArrayList<SettingsTree.Heuristic>();
                allowedHeuristics.add(SettingsTree.Heuristic.Default);
                allowedHeuristics.add(SettingsTree.Heuristic.Gain);
                allowedHeuristics.add(SettingsTree.Heuristic.GeneticDistance);
                allowedHeuristics.add(SettingsTree.Heuristic.VarianceReductionGIS);
                if (!allowedHeuristics.contains((Object)this.getSettings().getTree().getHeuristic())) {
                    throw new ClusException("Given heuristic not supported for classification trees!");
                }
                this.m_Heuristic = new GainHeuristic(false, this.getClusteringWeights(), this.getSettings());
                this.getSettings().getTree().setHeuristic(SettingsTree.Heuristic.Gain);
            }
        }
    }

    public void initStopCriterion() {
        ClusStopCriterion stop = null;
        int minEx = this.getSettings().getModel().getMinimalNbExamples();
        double knownWeight = this.getSettings().getModel().getMinimalKnownWeight();
        if (minEx > 0) {
            stop = new ClusStopCriterionMinNbExamples(minEx);
        } else if (knownWeight > 0.0) {
            stop = new SemiSupMinLabeledWeightStopCrit(knownWeight);
        } else {
            double minW = this.getSettings().getModel().getMinimalWeight();
            stop = new ClusStopCriterionMinWeight(minW);
        }
        this.m_Heuristic.setStopCriterion(stop);
    }

    public void initSignifcanceTestingTable() {
        int max_nom_val = 0;
        int num_nom_atts = this.m_Schema.getNbNominalAttrUse(ClusAttrType.AttributeUseType.All);
        for (int i = 0; i < num_nom_atts; ++i) {
            if (this.m_Schema.getNominalAttrUse(ClusAttrType.AttributeUseType.All)[i].getNbValues() <= max_nom_val) continue;
            max_nom_val = this.m_Schema.getNominalAttrUse(ClusAttrType.AttributeUseType.All)[i].getNbValues();
        }
        if (max_nom_val == 0) {
            max_nom_val = 1;
        }
        double[] table = new double[max_nom_val];
        table[0] = 1.0 - this.getSettings().getRules().getRuleSignificanceLevel();
        for (int i = 1; i < table.length; ++i) {
            ChiSquaredDistribution chiSquaredDistribution = new ChiSquaredDistribution(i);
            table[i] = chiSquaredDistribution.inverseCumulativeProbability(table[0]);
        }
        this.m_ChiSquareInvProb = table;
    }

    public ClusErrorList createErrorMeasure(MultiScore score) throws ClusException {
        ClusErrorList parent = new ClusErrorList();
        NumericAttrType[] num = this.m_Schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target);
        NominalAttrType[] nom = this.m_Schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target);
        TimeSeriesAttrType[] ts = this.m_Schema.getTimeSeriesAttrUse(ClusAttrType.AttributeUseType.Target);
        if (nom.length != 0) {
            boolean isBinaryZeroOneClassification;
            parent.addError(new ContingencyTable(parent, nom));
            parent.addError(new MSNominalError(parent, nom, this.m_NormalizationWeights));
            boolean bl = isBinaryZeroOneClassification = nom.length == 1 && Arrays.equals(nom[0].getValues(), new String[]{"1", "0"});
            if (isBinaryZeroOneClassification) {
                parent.addError(new MLaverageAUROC(parent, nom));
                parent.addError(new MLaverageAUPRC(parent, nom));
            }
        }
        if (this.getSettings().getMLC().getSectionMultiLabel().isEnabled()) {
            parent.addError(new HammingLoss(parent, nom));
            parent.addError(new RankingLoss(parent, nom));
            parent.addError(new OneError(parent, nom));
            parent.addError(new Coverage(parent, nom));
            parent.addError(new AveragePrecision(parent, nom));
            parent.addError(new MLAccuracy(parent, nom));
            parent.addError(new MLPrecision(parent, nom));
            parent.addError(new MLRecall(parent, nom));
            parent.addError(new MLFOneMeasure(parent, nom));
            parent.addError(new si.ijs.kt.clus.error.mlc.SubsetAccuracy(parent, nom));
            parent.addError(new MacroPrecision(parent, nom));
            parent.addError(new MacroRecall(parent, nom));
            parent.addError(new MacroFOne(parent, nom));
            parent.addError(new MicroPrecision(parent, nom));
            parent.addError(new MicroRecall(parent, nom));
            parent.addError(new MicroFOne(parent, nom));
            parent.addError(new MLaverageAUROC(parent, nom));
            parent.addError(new MLaverageAUPRC(parent, nom));
            parent.addError(new MLweightedAUPRC(parent, nom));
            parent.addError(new MLpooledAUPRC(parent, nom));
        }
        if (num.length != 0) {
            parent.addError(new AbsoluteError(parent, num));
            parent.addError(new MSError(parent, num));
            parent.addError(new RMSError(parent, num));
            if (this.getSettings().getAttribute().hasNonTrivialWeights()) {
                parent.addError(new RMSError(parent, num, this.m_NormalizationWeights));
            }
            parent.addError(new RRMSError(parent, num));
            parent.addError(new PearsonCorrelation(parent, num));
        }
        if (ts.length != 0) {
            ClusStatistic stat = this.createTargetStat();
            parent.addError(new AvgDistancesError(parent, stat.getDistance()));
        }
        switch (this.getTargetMode()) {
            case HIERARCHICAL: {
                INIFileNominalOrDoubleOrVector class_thr;
                double[] recalls = this.getSettings().getHMLC().getRecallValues().getDoubleVector();
                boolean wrCurves = this.getSettings().getOutput().isWriteCurves();
                if (this.getSettings().getHMLC().isCalError()) {
                    parent.addError(new HierErrorMeasures(parent, this.m_Hier, recalls, SettingsHMLC.HierarchyMeasures.Undefined, wrCurves, this.getSettings().getOutput().isGzipOutput()));
                    parent.addError(new MlcMeasuresForHmlc(parent, this.m_Hier));
                }
                if (!(class_thr = this.getSettings().getHMLC().getClassificationThresholds()).hasVector()) break;
                parent.addError(new HierClassWiseAccuracy(parent, this.m_Hier));
                break;
            }
            case HIERARCHICAL_MTR: {
                int nbHMTR = this.getSchema().getNbHMTRAttributes();
                NumericAttrType[] numHMTR = new NumericAttrType[num.length - nbHMTR];
                for (int i = 0; i < num.length - nbHMTR; ++i) {
                    numHMTR[i] = num[i];
                }
                parent.addError(new AbsoluteError(parent, numHMTR, "HMTR"));
                parent.addError(new MSError(parent, numHMTR, "HMTR"));
                parent.addError(new RMSError(parent, numHMTR, "HMTR"));
                if (this.getSettings().getAttribute().hasNonTrivialWeights()) {
                    parent.addError(new RMSError(parent, numHMTR, this.m_NormalizationWeights, "HMTR"));
                }
                parent.addError(new PearsonCorrelation(parent, numHMTR, "HMTR"));
                break;
            }
            case ILEVELC: {
                NominalAttrType cls = (NominalAttrType)this.getSchema().getLastNonDisabledType();
                parent.addError(new ILevelCRandIndex(parent, cls));
                break;
            }
            case STRUCTURED: {
                ClusAttrType[] target = this.m_Schema.getAllAttrUse(ClusAttrType.AttributeUseType.Target);
                try {
                    SetAttrType set = (SetAttrType)target[0];
                    SetAttrType[] sets = new SetAttrType[]{set};
                    parent.addError(new Accuracy(parent, sets, new NominalDistance()));
                    parent.addError(new Precision(parent, sets, new NominalDistance()));
                    parent.addError(new Recall(parent, sets, new NominalDistance()));
                    parent.addError(new F1Score(parent, sets, new NominalDistance()));
                    parent.addError(new SubsetAccuracy(parent, sets, new NominalDistance()));
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return parent;
    }

    public ClusErrorList createEvalError() throws ClusException {
        ClusErrorList parent = new ClusErrorList();
        NumericAttrType[] num = this.m_Schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target);
        NominalAttrType[] nom = this.m_Schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target);
        TimeSeriesAttrType[] ts = this.m_Schema.getTimeSeriesAttrUse(ClusAttrType.AttributeUseType.Target);
        if (nom.length != 0) {
            parent.addError(new si.ijs.kt.clus.error.Accuracy(parent, nom));
        }
        if (num.length != 0) {
            parent.addError(new RMSError(parent, num));
        }
        if (ts.length != 0) {
            ClusStatistic stat = this.createTargetStat();
            parent.addError(new AvgDistancesError(parent, stat.getDistance()));
        }
        return parent;
    }

    public ClusErrorList createDefaultError() throws ClusException {
        ClusErrorList parent = new ClusErrorList();
        NumericAttrType[] num = this.m_Schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target);
        NominalAttrType[] nom = this.m_Schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target);
        if (nom.length != 0) {
            parent.addError(new MisclassificationError(parent, nom));
        }
        if (num.length != 0) {
            parent.addError(new RMSError(parent, num));
        }
        switch (this.getTargetMode()) {
            case HIERARCHICAL: {
                parent.addError(new HierClassWiseAccuracy(parent, this.m_Hier));
            }
        }
        return parent;
    }

    public ClusErrorList createAdditiveError() throws ClusException {
        ClusErrorList parent = new ClusErrorList();
        NumericAttrType[] num = this.m_Schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target);
        NominalAttrType[] nom = this.m_Schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target);
        if (nom.length != 0) {
            parent.addError(new MisclassificationError(parent, nom));
        }
        if (num.length != 0) {
            parent.addError(new MSError(parent, num, this.getClusteringWeights()));
        }
        switch (this.getTargetMode()) {
            case HIERARCHICAL: {
                parent.addError(new HierClassWiseAccuracy(parent, this.m_Hier));
                break;
            }
            case TIME_SERIES: {
                ClusStatistic stat = this.createTargetStat();
                parent.addError(new AvgDistancesError(parent, stat.getDistance()));
            }
        }
        parent.setWeights(this.getClusteringWeights());
        return parent;
    }

    public ClusErrorList createExtraError(int train_err) {
        ClusErrorList parent = new ClusErrorList();
        if (this.getTargetMode() == Mode.TIME_SERIES) {
            ClusStatistic stat = this.createTargetStat();
            parent.addError(new ICVPairwiseDistancesError(parent, stat.getDistance()));
            parent.addError(new TimeSeriesSignificantChangeTesterXVAL(parent, (TimeSeriesStat)stat));
        }
        return parent;
    }

    public PruneTree getTreePrunerNoVSB() throws ClusException {
        SettingsTree sett = this.getSettings().getTree();
        SettingsBeamSearch setb = this.getSettings().getBeamSearch();
        SettingsConstraints setc = this.getSettings().getConstraints();
        if (this.isBeamSearch() && setb.isBeamPostPrune()) {
            sett.setPruningMethod(SettingsTree.PruningMethod.Garofalakis);
            return new SizeConstraintPruning(setb.getBeamTreeMaxSize(), this.getClusteringWeights());
        }
        int err_nb = setc.getMaxErrorConstraintNumber();
        int size_nb = setc.getSizeConstraintPruningNumber();
        if (size_nb > 0 || err_nb > 0) {
            int[] sizes = setc.getSizeConstraintPruningVector();
            if (sett.getPruningMethod().equals((Object)SettingsTree.PruningMethod.CartMaxSize)) {
                return new CartPruning(sizes, this.getClusteringWeights());
            }
            sett.setPruningMethod(SettingsTree.PruningMethod.Garofalakis);
            SizeConstraintPruning sc_prune = new SizeConstraintPruning(sizes, this.getClusteringWeights());
            if (err_nb > 0) {
                double[] max_err = setc.getMaxErrorConstraintVector();
                sc_prune.setMaxError(max_err);
                sc_prune.setErrorMeasure(this.createDefaultError());
            }
            if (this.getClusterMode() == Mode.TIME_SERIES) {
                sc_prune.setAdditiveError(this.createAdditiveError());
            }
            return sc_prune;
        }
        INIFileNominalOrDoubleOrVector class_thr = this.getSettings().getHMLC().getClassificationThresholds();
        if (class_thr.hasVector()) {
            return new HierClassTresholdPruner(class_thr.getDoubleVector());
        }
        if (this.getClusterMode() == Mode.REGRESSION || this.getClusterMode() == Mode.HIERARCHICAL_MTR) {
            double mult = sett.getM5PruningMult();
            if (sett.getPruningMethod().equals((Object)SettingsTree.PruningMethod.M5Multi)) {
                return new M5PrunerMulti(this.getClusteringWeights(), mult);
            }
            if (sett.getPruningMethod().equals((Object)SettingsTree.PruningMethod.Default) || sett.getPruningMethod().equals((Object)SettingsTree.PruningMethod.M5)) {
                sett.setPruningMethod(SettingsTree.PruningMethod.M5);
                return new M5Pruner(this.getClusteringWeights(), mult);
            }
        } else if (this.getClusterMode() == Mode.CLASSIFY) {
            if (sett.getPruningMethod().equals((Object)SettingsTree.PruningMethod.Default) || sett.getPruningMethod().equals((Object)SettingsTree.PruningMethod.C45)) {
                sett.setPruningMethod(SettingsTree.PruningMethod.C45);
                return new C45Pruner();
            }
            if (sett.getPruningMethod().equals((Object)SettingsTree.PruningMethod.M5)) {
                return new M5Pruner(this.getClusteringWeights(), sett.getM5PruningMult());
            }
        } else if (this.getClusterMode().includesHierarchical()) {
            if (sett.getPruningMethod().equals((Object)SettingsTree.PruningMethod.M5)) {
                double mult = sett.getM5PruningMult();
                return new M5Pruner(this.m_NormalizationWeights, mult);
            }
        } else if (this.getClusterMode() == Mode.PHYLO) {
            if (sett.getPruningMethod().equals((Object)SettingsTree.PruningMethod.EncodingCost)) {
                return new EncodingCostPruning();
            }
        } else if (this.getClusterMode() == Mode.CLASSIFY_AND_REGRESSION) {
            if (sett.getPruningMethod().equals((Object)SettingsTree.PruningMethod.M5)) {
                return new M5Pruner(this.getClusteringWeights(), sett.getM5PruningMult());
            }
            if (sett.getPruningMethod().equals((Object)SettingsTree.PruningMethod.C45)) {
                return new C45Pruner();
            }
        }
        sett.setPruningMethod(SettingsTree.PruningMethod.None);
        return new PruneTree();
    }

    public PruneTree getTreePruner(ClusData pruneset) throws ClusException {
        Settings sett = this.getSettings();
        SettingsTree.PruningMethod pm = sett.getTree().getPruningMethod();
        if (pm.equals((Object)SettingsTree.PruningMethod.None)) {
            return new PruneTree();
        }
        if (this.getClusterMode().includesHierarchical() && pruneset != null) {
            SettingsHMLC seth = this.getSettings().getHMLC();
            PruneTree pruner = this.getTreePrunerNoVSB();
            boolean bonf = seth.isUseBonferroni();
            HierRemoveInsigClasses hierpruner = new HierRemoveInsigClasses(pruneset, pruner, bonf, this.m_Hier);
            hierpruner.setSignificance(seth.getHierPruneInSig());
            hierpruner.setNoRootPreds(seth.isHierNoRootPreds());
            sett.getTree().setPruningMethod(SettingsTree.PruningMethod.Default);
            return hierpruner;
        }
        if (pruneset != null) {
            if (pm.equals((Object)SettingsTree.PruningMethod.GarofalakisVSB) || pm.equals((Object)SettingsTree.PruningMethod.CartVSB)) {
                SequencePruningVSB pruner = new SequencePruningVSB((RowData)pruneset, this.getClusteringWeights());
                if (pm.equals((Object)SettingsTree.PruningMethod.GarofalakisVSB)) {
                    int maxsize = sett.getConstraints().getMaxSize();
                    pruner.setSequencePruner(new SizeConstraintPruning(maxsize, this.getClusteringWeights()));
                } else {
                    pruner.setSequencePruner(new CartPruning(this.getClusteringWeights(), sett.getTree().isMSENominal()));
                }
                pruner.setOutputFile(sett.getGeneric().getFileAbsolute("prune.dat"));
                pruner.set1SERule(sett.getTree().get1SERule());
                pruner.setHasMissing(this.m_Schema.hasMissing());
                return pruner;
            }
            if (pm.equals((Object)SettingsTree.PruningMethod.ReducedErrorVSB) || pm.equals((Object)SettingsTree.PruningMethod.Default)) {
                ClusErrorList parent = this.createEvalError();
                sett.getTree().setPruningMethod(SettingsTree.PruningMethod.ReducedErrorVSB);
                return new BottomUpPruningVSB(parent, (RowData)pruneset);
            }
            return this.getTreePrunerNoVSB();
        }
        return this.getTreePrunerNoVSB();
    }

    public synchronized void setTargetStatistic(ClusStatistic stat) {
        this.m_StatisticAttrUse[ClusAttrType.AttributeUseType.Target.getIndex()] = stat;
    }

    public synchronized void setClusteringStatistic(ClusStatistic stat) {
        this.m_StatisticAttrUse[ClusAttrType.AttributeUseType.Clustering.getIndex()] = stat;
    }

    public synchronized void setAllStatistic(ClusStatistic stat) {
        this.m_StatisticAttrUse[ClusAttrType.AttributeUseType.All.getIndex()] = stat;
    }

    public synchronized boolean hasClusteringStat() {
        return this.m_StatisticAttrUse[ClusAttrType.AttributeUseType.Clustering.getIndex()] != null;
    }

    public synchronized ClusStatistic createClusteringStat() {
        return this.m_StatisticAttrUse[ClusAttrType.AttributeUseType.Clustering.getIndex()].cloneStat();
    }

    public synchronized ClusStatistic createTargetStat() {
        return this.m_StatisticAttrUse[ClusAttrType.AttributeUseType.Target.getIndex()].cloneStat();
    }

    public synchronized ClusStatistic createStatistic(ClusAttrType.AttributeUseType attType) {
        return this.m_StatisticAttrUse[attType.getIndex()].cloneStat();
    }

    public synchronized ClusStatistic getStatistic(ClusAttrType.AttributeUseType attType) {
        return this.m_StatisticAttrUse[attType.getIndex()];
    }

    public ClusStatistic getTrainSetStat() {
        return this.getTrainSetStat(ClusAttrType.AttributeUseType.All);
    }

    public ClusStatistic getTrainSetStat(ClusAttrType.AttributeUseType attType) {
        return this.m_TrainSetStatAttrUse[attType.getIndex()];
    }

    public void computeTrainSetStat(RowData trainset, ClusAttrType.AttributeUseType attType) throws ClusException {
        this.m_TrainSetStatAttrUse[attType.getIndex()] = this.createStatistic(attType);
        trainset.calcTotalStatBitVector(this.m_TrainSetStatAttrUse[attType.getIndex()]);
        this.m_TrainSetStatAttrUse[attType.getIndex()].calcMean();
    }

    public void computeTrainSetStat(RowData trainset) throws ClusException {
        this.m_TrainSetStatAttrUse = new ClusStatistic[ClusAttrType.AttributeUseType.values().length];
        if (!this.getClusterMode().includesHierarchical()) {
            this.computeTrainSetStat(trainset, ClusAttrType.AttributeUseType.All);
        }
        this.computeTrainSetStat(trainset, ClusAttrType.AttributeUseType.Clustering);
        this.computeTrainSetStat(trainset, ClusAttrType.AttributeUseType.Target);
    }

    public ClusHeuristic getHeuristic() {
        return this.m_Heuristic;
    }

    public String getHeuristicName() {
        return this.m_Heuristic.getName();
    }

    public void getPreprocs(DataPreprocs pps) {
    }

    public boolean needsHierarchyProcessors() {
        return this.getClusterMode() != Mode.PHYLO && this.getTargetMode() != Mode.PHYLO;
    }

    public void setRuleInduceOnly(boolean rule) {
        this.m_RuleInduceOnly = rule;
    }

    public boolean isRuleInduceOnly() {
        return this.m_RuleInduceOnly;
    }

    public boolean isTreeToRuleInduce() {
        return this.getSettings().getRules().getCoveringMethod().equals((Object)SettingsRules.CoveringMethod.RulesFromTree);
    }

    public void setBeamSearch(boolean beam) {
        this.m_BeamSearch = beam;
    }

    public boolean isBeamSearch() {
        return this.m_BeamSearch;
    }

    public double getChiSquareInvProb(int df) {
        return this.m_ChiSquareInvProb[df];
    }

    public void updateStatistics(ClusModel model) throws ClusException {
        if (this.m_Hier != null) {
            ArrayList<ClusStatistic> stats = new ArrayList<ClusStatistic>();
            model.retrieveStatistics(stats);
            for (int i = 0; i < stats.size(); ++i) {
                WHTDStatistic stat = (WHTDStatistic)stats.get(i);
                stat.setHier(this.m_Hier);
            }
        }
    }

    private void createHierarchy() {
        for (int i = 0; i < this.m_Schema.getNbAttributes(); ++i) {
            ClusAttrType type = this.m_Schema.getAttrType(i);
            if (type.isDisabled() || !(type instanceof ClassesAttrType)) continue;
            ClassesAttrType cltype = (ClassesAttrType)type;
            if (this.getSettings().getGeneral().getVerbose() >= 1) {
                ClusLogger.info("Classes type: " + type.getName());
            }
            this.m_Hier = cltype.getHier();
        }
    }

    public void initHierarchySettings() throws ClusException, IOException {
        if (this.m_Hier != null && this.getSettings().getHMLC().hasHierEvalClasses()) {
            ClassesTuple tuple = ClassesTuple.readFromFile(this.getSettings().getHMLC().getHierEvalClasses(), this.m_Hier);
            this.m_Hier.setEvalClasses(tuple);
        }
    }

    public void initRuleSettings() throws ClusException {
        SettingsRules setr = this.getSettings().getRules();
        SettingsTree sett = this.getSettings().getTree();
        SettingsRules.CoveringMethod covering = setr.getCoveringMethod();
        SettingsRules.RulePredictionMethod prediction = setr.getRulePredictionMethod();
        if (!Arrays.asList(SettingsTree.Heuristic.DispersionAdt, SettingsTree.Heuristic.DispersionMlt, SettingsTree.Heuristic.RDispersionAdt, SettingsTree.Heuristic.RDispersionMlt).contains((Object)sett.getHeuristic()) && setr.isHeurRuleDist()) {
            setr.setHeurRuleDistPar(0.0);
        }
        if (setr.isRuleSignificanceTesting()) {
            setr.setIS_RULE_SIG_TESTING(true);
        }
        if (setr.isRandomRules()) {
            setr.setCoveringMethod(SettingsRules.CoveringMethod.Standard);
            setr.setCoveringWeight(0.0);
        } else {
            switch (covering) {
                case Standard: {
                    setr.setCoveringWeight(0.0);
                    break;
                }
                case HeurOnly: {
                    if (prediction.equals((Object)SettingsRules.RulePredictionMethod.DecisionList) || prediction.equals((Object)SettingsRules.RulePredictionMethod.Union)) {
                        setr.setRulePredictionMethod(SettingsRules.RulePredictionMethod.CoverageWeighted);
                    }
                    setr.setCoveringWeight(0.0);
                    if (setr.getHeurRuleDistPar() < 0.0) {
                        throw new ClusException("Clus heuristic covering: HeurRuleDistPar must be >= 0!");
                    }
                    if (Arrays.asList(SettingsTree.Heuristic.DispersionAdt, SettingsTree.Heuristic.DispersionMlt, SettingsTree.Heuristic.RDispersionAdt, SettingsTree.Heuristic.RDispersionMlt).contains((Object)sett.getHeuristic())) break;
                    throw new ClusException("Clus heuristic covering: Only dispersion-based heuristics supported!");
                }
                case WeightedAdditive: 
                case WeightedMultiplicative: 
                case WeightedError: 
                case BeamRuleDefSet: 
                case RandomRuleSet: {
                    if (Arrays.asList(SettingsRules.RulePredictionMethod.DecisionList, SettingsRules.RulePredictionMethod.Union).contains((Object)prediction)) {
                        setr.setRulePredictionMethod(SettingsRules.RulePredictionMethod.CoverageWeighted);
                    }
                    if (!(setr.getCoveringWeight() < 0.0)) break;
                    throw new ClusException("Clus weighted covering: Covering weight must be >= 0!");
                }
                case StandardBootstrap: {
                    setr.setRulePredictionMethod(SettingsRules.RulePredictionMethod.Optimized);
                    break;
                }
                case Union: {
                    setr.setRulePredictionMethod(SettingsRules.RulePredictionMethod.Union);
                    break;
                }
                case RulesFromTree: {
                    sett.setHeuristic(SettingsTree.Heuristic.VarianceReduction);
                    setr.setRuleAddingMethod(SettingsRules.RuleAddingMethod.Always);
                    break;
                }
                default: {
                    throw new RuntimeException("Covering method is not handled!");
                }
            }
        }
    }

    public static enum TargetType {
        CLASSIFICATION,
        REGRESSION,
        MULTI_LABEL_CLASSIFICATION,
        HIERACHICAL_MULTI_LABEL_CLASSIFICATION,
        OTHER;

    }

    public static enum Mode {
        NONE,
        CLASSIFY,
        REGRESSION,
        HIERARCHICAL,
        SSPD,
        CLASSIFY_AND_REGRESSION,
        TIME_SERIES,
        ILEVELC,
        PHYLO,
        BEAM_SEARCH,
        HIERARCHICAL_MTR,
        STRUCTURED,
        HIER_CLASS_AND_REG;


        public boolean isClassificationOrRegression() {
            return this == CLASSIFY || this == REGRESSION || this == CLASSIFY_AND_REGRESSION;
        }

        public boolean includesHierarchical() {
            return this == HIERARCHICAL || this == HIER_CLASS_AND_REG;
        }
    }
}

