/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.main;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import si.ijs.kt.clus.Clus;
import si.ijs.kt.clus.algo.tdidt.ClusNode;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.ext.ensemble.ClusForest;
import si.ijs.kt.clus.ext.ensemble.ClusOOBErrorEstimate;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.ClusStat;
import si.ijs.kt.clus.main.ClusSummary;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsOutput;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.model.ClusModelInfo;
import si.ijs.kt.clus.statistic.StatisticPrintInfo;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.ClusUtil;
import si.ijs.kt.clus.util.ResourceInfo;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.format.ClusFormat;
import si.ijs.kt.clus.util.jeans.util.FileUtil;
import si.ijs.kt.clus.util.jeans.util.StringUtils;

public class ClusOutput {
    protected ClusSchema m_Schema;
    protected Settings m_Sett;
    protected PrintWriter m_Writer;
    protected String m_Fname;
    protected Settings m_Sett2;
    protected StringWriter m_StrWrt;

    public ClusOutput(String fname, ClusSchema schema, Settings sett) throws IOException {
        this.m_Schema = schema;
        this.m_Sett = sett;
        this.m_Sett2 = sett;
        this.m_Fname = fname;
        this.m_Writer = sett.getGeneric().getFileAbsoluteWriter(fname);
    }

    public ClusOutput(ClusSchema schema, Settings sett) throws IOException {
        this.m_Schema = schema;
        this.m_Sett = sett;
        this.m_Sett2 = sett;
        this.m_StrWrt = new StringWriter();
        this.m_Writer = new PrintWriter(this.m_StrWrt);
    }

    public void print(String str) {
        this.m_Writer.print(str);
    }

    public String getString() {
        return this.m_StrWrt.toString();
    }

    public Settings getSettings() {
        return this.m_Sett;
    }

    public void writeHeader() throws IOException {
        String relname = this.m_Schema.getRelationName();
        this.m_Writer.println("Clus run " + relname);
        this.m_Writer.println(StringUtils.makeString('*', 9 + relname.length()));
        this.m_Writer.println();
        Date date = this.m_Schema.getSettings().getGeneric().getDate();
        this.m_Writer.println("Date: " + DateFormat.getInstance().format(date));
        this.m_Writer.println("File: " + this.m_Fname);
        int a_tot = this.m_Schema.getNbAttributes();
        int a_in = this.m_Schema.getNbDescriptiveAttributes();
        int a_out = this.m_Schema.getNbTargetAttributes();
        this.m_Writer.println("Attributes: " + a_tot + " (input: " + a_in + ", output: " + a_out + ")");
        this.m_Writer.println("Missing values: " + (this.m_Schema.hasMissing() ? "Yes" : "No"));
        if (ResourceInfo.isLibLoaded()) {
            this.m_Writer.println("Memory usage: " + ClusStat.m_InitialMemory + " kB (initial), " + ClusStat.m_LoadedMemory + " kB (data loaded)");
        }
        this.m_Writer.println();
        this.m_Sett.show(this.m_Writer);
        this.m_Writer.flush();
    }

    public void writeBrief(ClusRun cr) throws IOException {
        String ridx = cr.getIndexString();
        this.m_Writer.println("Run: " + ridx);
        ClusErrorList te_err = cr.getTestError();
        if (te_err != null) {
            te_err.showErrorBrief(cr, 1, this.m_Writer);
        }
        ClusErrorList tr_err = cr.getTrainError();
        if (this.m_Sett.getOutput().isOutTrainError() && tr_err != null) {
            tr_err.showErrorBrief(cr, 0, this.m_Writer);
        }
        this.m_Writer.println();
    }

    public void writeOutput(ClusRun cr, boolean detail) throws IOException, ClusException, InterruptedException {
        this.writeOutput(cr, detail, false);
    }

    public void writeOutput(ClusRun cr, boolean detail, boolean outputtrain) throws IOException, ClusException, InterruptedException {
        ClusModelInfo mi;
        int i;
        ArrayList<ClusModel> models = new ArrayList<ClusModel>();
        String ridx = cr.getIndexString();
        if (this.getSettings().getHMTR().isSectionHMTREnabled()) {
            this.m_Writer.println("HMTR Tree");
            this.m_Writer.println("---------");
            this.m_Writer.println();
            this.m_Writer.println(this.m_Schema.getHMTRHierarchy().printHierarchyTree());
        }
        this.m_Writer.println("Run: " + ridx);
        this.m_Writer.println(StringUtils.makeString('*', 5 + ridx.length()));
        this.m_Writer.println();
        this.m_Writer.println("Statistics");
        this.m_Writer.println("----------");
        this.m_Writer.println();
        this.m_Writer.println("FTValue (FTest): " + this.m_Sett.getTree().getFTest());
        if (!ClusOOBErrorEstimate.isOOBCalculation()) {
            double tsec = (double)cr.getInductionTime() / 1000.0;
            double tpru = (double)cr.getPruneTime() / 1000.0;
            long tpred = cr.getPredictionTime();
            long tpredavg = cr.getPredictionTimeAverage();
            String parallelTime = "";
            if (this.getSettings().getEnsemble().isEnsembleWithParallelExecution()) {
                parallelTime = " (sequential " + ClusFormat.FOUR_AFTER_DOT.format((double)cr.getInductionTimeSequential() / 1000.0) + " sec)";
            }
            String cpu = ResourceInfo.isLibLoaded() ? " (CPU)" : "";
            this.m_Writer.println("Induction Time: " + ClusFormat.FOUR_AFTER_DOT.format(tsec) + " sec" + parallelTime + cpu);
            this.m_Writer.println("Pruning Time: " + ClusFormat.FOUR_AFTER_DOT.format(tpru) + " sec" + cpu);
            this.m_Writer.println("Prediction Time (total for ClusModel.Original): " + System.lineSeparator() + "\t" + ClusFormat.FOUR_AFTER_DOT.format((double)tpred / Math.pow(10.0, 3.0)) + " microsecs" + System.lineSeparator() + "\t" + ClusFormat.FOUR_AFTER_DOT.format((double)tpred / Math.pow(10.0, 6.0)) + " millisecs" + System.lineSeparator() + "\t" + ClusFormat.FOUR_AFTER_DOT.format((double)tpred / Math.pow(10.0, 9.0)) + " secs");
            this.m_Writer.println("Prediction Time (average for ClusModel.Original): " + ClusFormat.FOUR_AFTER_DOT.format((double)tpredavg / Math.pow(10.0, 3.0)) + " microsecs");
        }
        for (i = 0; i < cr.getNbModels(); ++i) {
            mi = cr.getModelInfo(i);
            if (mi != null) {
                ClusModel root = mi.getModel();
                if (mi.shouldPruneInvalid()) {
                    root = root.prune(0);
                }
                models.add(root);
                continue;
            }
            models.add(null);
        }
        this.m_Writer.println("Model information:");
        for (i = 0; i < cr.getNbModels(); ++i) {
            ClusModel model;
            mi = cr.getModelInfo(i);
            if (mi == null || (model = (ClusModel)models.get(i)) == null) continue;
            this.m_Writer.print("     " + mi.getName() + ": ");
            String info_str = model.getModelInfo();
            String[] info = info_str.split("\\s*\\,\\s*");
            for (int j = 0; j < info.length; ++j) {
                if (j > 0) {
                    this.m_Writer.print(StringUtils.makeString(' ', mi.getName().length() + 7));
                }
                this.m_Writer.println(info[j]);
            }
        }
        if (cr.getStatManager().getSettings().getMLC().shouldShowThresholds()) {
            String mlThresholdsTitle = "MultiLabelThresholds:";
            this.m_Writer.println(System.lineSeparator() + mlThresholdsTitle);
            this.m_Writer.println(StringUtils.makeString('-', mlThresholdsTitle.length()));
            for (int i2 = 0; i2 < cr.getNbModels(); ++i2) {
                ClusModel root = (ClusModel)models.get(i2);
                String modelName = cr.getModelInfo(i2).getName();
                if (!cr.getStatManager().getSettings().getMLC().shouldShowThresholds(modelName)) continue;
                if (root instanceof ClusForest) {
                    this.m_Writer.println(modelName);
                    ClusForest forest = (ClusForest)root;
                    int forestSize = forest.getModelSize();
                    for (int tree = 0; tree < forestSize; ++tree) {
                        ((ClusNode)forest.getModel(tree)).printMultiLabelThresholds(this.m_Writer, tree);
                    }
                    this.m_Writer.println();
                    continue;
                }
                if (!(root instanceof ClusNode)) continue;
                this.m_Writer.println(modelName);
                ((ClusNode)root).printMultiLabelThresholds(this.m_Writer, -1);
                this.m_Writer.println();
            }
        }
        String bName = FileUtil.getName(this.m_Fname);
        this.m_Writer.println();
        ClusErrorList te_err = cr.getTestError();
        if (this.m_Sett.getOutput().isOutFoldError() || detail) {
            if (outputtrain) {
                ClusErrorList tr_err = cr.getTrainError();
                if (tr_err != null) {
                    if (ClusOOBErrorEstimate.isOOBCalculation()) {
                        this.m_Writer.println("Out-Of-Bag Estimate of Error");
                        this.m_Writer.println("----------------------------");
                    } else {
                        this.m_Writer.println("Training error");
                        this.m_Writer.println("--------------");
                    }
                    this.m_Writer.println();
                    tr_err.showError(cr, 0, bName + ".train", this.m_Writer, this.m_Sett);
                    this.m_Writer.println();
                }
                ClusErrorList.printExtraError(cr, 0, this.m_Writer);
            }
            ClusErrorList va_err = cr.getValidationError();
            if (!ClusOOBErrorEstimate.isOOBCalculation() && va_err != null && this.m_Sett.getOutput().isOutValidError()) {
                this.m_Writer.println("Validation error");
                this.m_Writer.println("----------------");
                this.m_Writer.println();
                va_err.showError(cr, 2, bName + ".valid", this.m_Writer, this.m_Sett);
                this.m_Writer.println();
            }
            if (!ClusOOBErrorEstimate.isOOBCalculation() && te_err != null && this.m_Sett.getOutput().isOutTestError()) {
                this.m_Writer.println("Testing error");
                this.m_Writer.println("-------------");
                this.m_Writer.println();
                te_err.showError(cr, 1, bName + ".test", this.m_Writer, this.m_Sett);
                this.m_Writer.println();
            }
        }
        StatisticPrintInfo info = this.m_Sett.getOutput().getStatisticPrintInfo();
        if (!ClusOOBErrorEstimate.isOOBCalculation()) {
            for (int i3 = 0; i3 < cr.getNbModels(); ++i3) {
                if (cr.getModelInfo(i3) == null || models.get(i3) == null || !this.m_Sett.getOutput().shouldShowModel(i3)) continue;
                ClusModelInfo mi2 = cr.getModelInfo(i3);
                ClusModel root = (ClusModel)models.get(i3);
                String modelname = mi2.getName() + " Model";
                this.m_Writer.println(modelname);
                this.m_Writer.println(StringUtils.makeString('*', modelname.length()));
                this.m_Writer.println();
                if (this.m_Sett.getOutput().isPrintModelAndExamples()) {
                    RowData pex = (RowData)cr.getTrainingSet();
                    if (te_err != null) {
                        pex = cr.getTestSet();
                    }
                    root.printModelAndExamples(this.m_Writer, info, pex);
                } else {
                    root.printModel(this.m_Writer, info);
                }
                this.m_Writer.println();
            }
        }
        if (!ClusOOBErrorEstimate.isOOBCalculation() && this.getSettings().getOutput().isOutputPythonModel()) {
            ClusModel root;
            String appName = this.m_Fname.substring(0, this.m_Fname.lastIndexOf(".out"));
            SettingsOutput.PythonModelType pyModelType = cr.getStatManager().getSettings().getOutput().getPythonModelType();
            if (pyModelType == SettingsOutput.PythonModelType.Object) {
                String[] fileNames;
                for (String fileName : fileNames = new String[]{"tree_as_object.py", "prediction_aggregators.py"}) {
                    try {
                        InputStream is = Clus.class.getResourceAsStream("/" + fileName);
                        String fullFileName = this.getSettings().getGeneric().getFileAbsolute(fileName);
                        Files.copy(is, Paths.get(fullFileName, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException ex) {
                        System.err.println("Error while copying " + fileName + " to the output folder.");
                        ex.printStackTrace();
                    }
                }
            }
            String pyName = appName + "_models.py";
            File pyscript = new File(this.getSettings().getGeneric().getFileAbsolute(pyName));
            PrintWriter wrtr = new PrintWriter(new FileOutputStream(pyscript));
            if (this.getSettings().getEnsemble().isEnsembleMode()) {
                String treeFile = ClusForest.getTreeFile(appName);
                ClusForest.writePythonAggregation(wrtr, treeFile, cr.getStatManager().getTargetType());
                int maxSize = -1;
                int maxSizedForest = -1;
                for (int i4 = 0; i4 < cr.getNbModels(); ++i4) {
                    root = (ClusModel)models.get(i4);
                    if (!(root instanceof ClusForest)) continue;
                    int trees = ((ClusForest)root).getNbModels();
                    if (trees > maxSize) {
                        maxSize = trees;
                        maxSizedForest = i4;
                    }
                    ((ClusForest)root).writePythonEnsembleFile(wrtr, treeFile, pyModelType);
                }
                ClusLogger.info(String.format("Python ensemble aggregation code written to: %s", pyName));
                ClusForest root2 = (ClusForest)models.get(maxSizedForest);
                if (this.getSettings().getEnsemble().shouldOptimizeEnsemble()) {
                    root2.joinPythonForestInOneFile(cr);
                } else {
                    root2.printForestToPython(pyModelType);
                }
            } else {
                if (pyModelType == SettingsOutput.PythonModelType.Object) {
                    wrtr.println("from tree_as_object import *\n\n");
                }
                HashMap<Integer, String> pythonNames = new HashMap<Integer, String>();
                pythonNames.put(0, "default");
                pythonNames.put(1, "original");
                pythonNames.put(2, "pruned");
                String defPattern = "def %s(xs):";
                HashMap<String, Integer> descrIndices = ClusUtil.getDescriptiveAttributesIndices(cr.getStatManager());
                block14: for (int i5 = 0; i5 < cr.getNbModels(); ++i5) {
                    root = (ClusModel)models.get(i5);
                    if (pythonNames.containsKey(i5)) {
                        switch (pyModelType) {
                            case Function: {
                                wrtr.println(String.format(defPattern, pythonNames.get(i5)));
                                root.printModelToPythonScript(wrtr, descrIndices);
                                continue block14;
                            }
                            case Object: {
                                root.printModelToPythonScript(wrtr, descrIndices, (String)pythonNames.get(i5));
                                continue block14;
                            }
                            default: {
                                throw new RuntimeException("Wrong PythonModelType: " + (Object)((Object)cr.getStatManager().getSettings().getOutput().getPythonModelType()));
                            }
                        }
                    }
                    System.err.println("Warning: this is not DEFAULT/ORIGINAL/PRUNED model and will not be printed. Extend the pythonNames hash map!");
                }
            }
            wrtr.close();
        }
        if (!ClusOOBErrorEstimate.isOOBCalculation() && this.getSettings().getOutput().isOutputDatabaseQueries()) {
            int starttree = this.getSettings().getExhaustiveSearch().getStartTreeCpt();
            int startitem = this.getSettings().getExhaustiveSearch().getStartItemCpt();
            ClusModel root = (ClusModel)models.get(cr.getNbModels() - 1);
            String out_database_name = this.m_Sett2.getGeneric().getAppName() + ".txt";
            PrintWriter database_writer = this.m_Sett2.getGeneric().getFileAbsoluteWriter(out_database_name);
            root.printModelToQuery(database_writer, cr, starttree, startitem, this.getSettings().getExhaustiveSearch().isExhaustiveSearch());
            database_writer.close();
            ClusLogger.info("The queries are in " + out_database_name);
        }
        if (!ClusOOBErrorEstimate.isOOBCalculation() && this.getSettings().getOutput().isOutputClowdFlowsJSON()) {
            JsonObject output = new JsonObject();
            StringWriter settingsStringWriter = new StringWriter();
            PrintWriter settingsWriter = new PrintWriter(settingsStringWriter);
            this.m_Sett.show(settingsWriter);
            output.addProperty("settings", settingsStringWriter.toString());
            JsonArray outputModels = new JsonArray();
            output.add("models", outputModels);
            for (int i6 = 0; i6 < cr.getNbModels(); ++i6) {
                if (cr.getModelInfo(i6) == null || models.get(i6) == null || !this.m_Sett.getOutput().shouldShowModel(i6)) continue;
                ClusModelInfo mi3 = cr.getModelInfo(i6);
                ClusModel root = (ClusModel)models.get(i6);
                String modelname = mi3.getName();
                JsonObject currentModel = new JsonObject();
                currentModel.addProperty("name", modelname);
                RowData pex = (RowData)cr.getTrainingSet();
                if (te_err != null) {
                    pex = cr.getTestSet();
                }
                currentModel.add("representation", root.getModelJSON(info, pex));
                outputModels.add(currentModel);
            }
            String jsonFileName = this.m_Sett2.getGeneric().getAppName() + ".json";
            PrintWriter jsonWriter = this.m_Sett2.getGeneric().getFileAbsoluteWriter(jsonFileName);
            jsonWriter.write(output.toString());
            jsonWriter.close();
        }
        this.m_Writer.flush();
    }

    public String getQuotient(int a, int b) {
        double val = b == 0 ? 0.0 : (double)a / (double)b;
        return ClusFormat.ONE_AFTER_DOT.format(val);
    }

    public void writeSummary(ClusSummary summary) throws IOException {
        ClusErrorList te_err;
        ClusErrorList va_err;
        this.m_Writer.println("Summary");
        this.m_Writer.println("*******");
        this.m_Writer.println();
        int runs = summary.getNbRuns();
        this.m_Writer.println("Runs: " + runs);
        double tsec = (double)summary.getInductionTime() / 1000.0;
        this.m_Writer.println("Induction time: " + ClusFormat.FOUR_AFTER_DOT.format(tsec) + " sec");
        double psec = (double)summary.getPrepareTime() / 1000.0;
        this.m_Writer.println("Preprocessing time: " + ClusFormat.ONE_AFTER_DOT.format(psec) + " sec");
        long tpred = summary.getPredictionTime();
        long tpredavg = summary.getPredictionTimeAverage();
        this.m_Writer.println("Prediction Time (total for ClusModel.Original, " + runs + " runs, " + summary.getPredictionTimeNbExamples() + " examples): " + System.lineSeparator() + "\t" + ClusFormat.FOUR_AFTER_DOT.format((double)tpred / Math.pow(10.0, 3.0)) + " microsecs" + System.lineSeparator() + "\t" + ClusFormat.FOUR_AFTER_DOT.format((double)tpred / Math.pow(10.0, 6.0)) + " millisecs" + System.lineSeparator() + "\t" + ClusFormat.FOUR_AFTER_DOT.format((double)tpred / Math.pow(10.0, 9.0)) + " secs");
        this.m_Writer.println("Prediction Time (average for ClusModel.Original): " + ClusFormat.FOUR_AFTER_DOT.format((double)tpredavg / Math.pow(10.0, 3.0)) + " microsecs");
        this.m_Writer.println("Mean number of tests");
        for (int i = 1; i <= 2; ++i) {
            ClusModelInfo mi = summary.getModelInfo(i);
            if (mi == null) continue;
            this.m_Writer.println("     " + mi.getName() + ": " + this.getQuotient(mi.getModelSize(), runs));
        }
        this.m_Writer.println();
        String bName = FileUtil.getName(this.m_Fname);
        ClusErrorList tr_err = summary.getTrainError();
        if (this.m_Sett.getOutput().isOutTrainError() && tr_err != null) {
            this.m_Writer.println("Training error");
            this.m_Writer.println("--------------");
            this.m_Writer.println();
            tr_err.showError(summary, 0, bName + ".train", this.m_Writer, this.m_Sett);
            this.m_Writer.println();
        }
        if ((va_err = summary.getValidationError()) != null) {
            this.m_Writer.println("Validation error");
            this.m_Writer.println("----------------");
            this.m_Writer.println();
            va_err.showError(summary, 2, bName + ".valid", this.m_Writer, this.m_Sett);
            this.m_Writer.println();
        }
        if ((te_err = summary.getTestError()) != null) {
            this.m_Writer.println("Testing error");
            this.m_Writer.println("-------------");
            this.m_Writer.println();
            te_err.showError(summary, 1, bName + ".test", this.m_Writer, this.m_Sett);
        }
        this.m_Writer.println();
        this.m_Writer.flush();
    }

    public PrintWriter getWriter() {
        return this.m_Writer;
    }

    public void close() {
        if (this.m_Fname != null && this.getSettings().getGeneral().getVerbose() >= 1) {
            ClusLogger.info("Output written to: " + this.m_Fname);
        }
        this.m_Writer.close();
    }
}

