/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.main;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.model.ClusModelInfo;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.exception.ClusException;

public abstract class ClusModelInfoList
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int TRAINSET = 0;
    public static final int TESTSET = 1;
    public static final int VALIDATIONSET = 2;
    protected ClusModelInfo m_AllModelsMI = new ClusModelInfo("AllModels");
    protected ArrayList<ClusModelInfo> m_Models = new ArrayList();
    protected long m_IndTime;
    protected long m_PrepTime;
    protected long m_PruneTime;
    protected long m_PredictionTime;
    protected int m_PredictionTimeNbExamples;
    protected long m_IndTimeSequential = 0L;

    public int getNbModels() {
        return this.m_Models.size();
    }

    public ClusModelInfo getModelInfo(int i) {
        if (i >= this.m_Models.size()) {
            return null;
        }
        return this.m_Models.get(i);
    }

    public ClusModelInfo getModelInfoFallback(int i, int j) {
        ClusModelInfo info = this.getModelInfo(i);
        if (info == null) {
            info = this.getModelInfo(j);
        }
        return info;
    }

    public ClusModelInfo getAllModelsMI() {
        return this.m_AllModelsMI;
    }

    public void setModelInfo(int i, ClusModelInfo info) {
        this.m_Models.set(i, info);
    }

    public ClusModel getModel(int i) {
        return this.getModelInfo(i).getModel();
    }

    public String getModelName(int i) {
        return this.getModelInfo(i).getName();
    }

    public void setModels(ArrayList<ClusModelInfo> models) {
        this.m_Models = models;
    }

    public void showModelInfos() {
        for (int i = 0; i < this.getNbModels(); ++i) {
            ClusModelInfo info = this.getModelInfo(i);
            ClusLogger.info("Model " + i + " name: '" + info.getName() + "'");
        }
    }

    public ClusModelInfo initModelInfo(int i) throws ClusException {
        String name = "M" + (i + 1);
        if (i == 0) {
            name = "Default";
        }
        if (i == 1) {
            name = "Original";
        }
        if (i == 2) {
            name = "Pruned";
        }
        ClusModelInfo inf = new ClusModelInfo(name);
        this.initModelInfo(inf);
        return inf;
    }

    public ClusModelInfo initModelInfo(int i, String name) throws ClusException {
        ClusModelInfo inf = new ClusModelInfo(name);
        this.initModelInfo(inf);
        return inf;
    }

    public void initModelInfo(ClusModelInfo inf) throws ClusException {
        inf.setSelectedErrorsClone(this.getTrainError(), this.getTestError(), this.getValidationError());
        inf.setStatManager(this.getStatManager());
    }

    public ClusModelInfo addModelInfo(String name) throws ClusException {
        ClusModelInfo inf = new ClusModelInfo(name);
        this.addModelInfo(inf);
        return inf;
    }

    public void addModelInfo(ClusModelInfo inf) throws ClusException {
        this.initModelInfo(inf);
        this.m_Models.add(inf);
    }

    public ClusModelInfo addModelInfo(int i) throws ClusException {
        while (i >= this.m_Models.size()) {
            this.m_Models.add(null);
        }
        ClusModelInfo inf = this.m_Models.get(i);
        if (inf == null) {
            inf = this.initModelInfo(i);
            this.m_Models.set(i, inf);
        }
        return inf;
    }

    public ClusModelInfo addModelInfo(int i, String model_name) throws ClusException {
        while (i >= this.m_Models.size()) {
            this.m_Models.add(null);
        }
        ClusModelInfo inf = this.m_Models.get(i);
        if (inf == null) {
            inf = this.initModelInfo(i, model_name);
            this.m_Models.set(i, inf);
        }
        return inf;
    }

    public abstract ClusStatManager getStatManager();

    public abstract ClusErrorList getTrainError();

    public abstract ClusErrorList getTestError();

    public abstract ClusErrorList getValidationError();

    public ArrayList<ClusModelInfo> cloneModels() throws ClusException {
        int nb_models = this.getNbModels();
        ArrayList<ClusModelInfo> clones = new ArrayList<ClusModelInfo>();
        for (int i = 0; i < nb_models; ++i) {
            ClusModelInfo my = this.getModelInfo(i);
            if (my != null) {
                my = my.cloneModelInfo();
            }
            clones.add(my);
        }
        return clones;
    }

    public void deleteModels() {
        int nb_models = this.getNbModels();
        for (int i = 0; i < nb_models; ++i) {
            ClusModelInfo my = this.getModelInfo(i);
            my.deleteModel();
        }
    }

    public void checkModelInfo() throws ClusException {
        int nb_models = this.getNbModels();
        for (int i = 0; i < nb_models; ++i) {
            ClusModelInfo my = this.getModelInfo(i);
            my.check();
        }
    }

    public boolean hasModel(int i) {
        ClusModelInfo my = this.getModelInfo(i);
        return my.getNbModels() > 0;
    }

    public void copyAllModelsMIs() {
        ClusModelInfo allmi = this.getAllModelsMI();
        int nb_models = this.getNbModels();
        for (int i = 0; i < nb_models; ++i) {
            ClusModelInfo my = this.getModelInfo(i);
            if (my == null) continue;
            allmi.copyModelProcessors(my);
        }
    }

    public void initModelProcessors(int type, ClusSchema schema) throws IOException, ClusException {
        ClusModelInfo allmi = this.getAllModelsMI();
        allmi.initAllModelProcessors(type, schema);
        for (int i = 0; i < this.getNbModels(); ++i) {
            ClusModelInfo mi = this.getModelInfo(i);
            if (mi == null) continue;
            mi.initModelProcessors(type, schema);
        }
    }

    public void initEnsemblePredictionsWriter(int type) {
        ClusModelInfo mi = this.getModelInfo(1);
        mi.initEnsemblePredictionWriter(type);
    }

    public void termModelProcessors(int type) throws IOException, ClusException {
        ClusModelInfo allmi = this.getAllModelsMI();
        allmi.termAllModelProcessors(type);
        for (int i = 0; i < this.getNbModels(); ++i) {
            ClusModelInfo mi = this.getModelInfo(i);
            if (mi == null) continue;
            mi.termModelProcessors(type);
        }
    }

    public void termEnsemblePredictionsWriter(int type) {
        ClusModelInfo mi = this.getModelInfo(1);
        mi.terminateEnsemblePredictionWriter(type);
    }

    public final void setInductionTime(long time) {
        this.m_IndTime = time;
    }

    public final long getInductionTime() {
        return this.m_IndTime;
    }

    public final void setInductionTimeSequential(long time) {
        this.m_IndTimeSequential = time;
    }

    public final long getInductionTimeSequential() {
        return this.m_IndTimeSequential;
    }

    public final void setPruneTime(long time) {
        this.m_PruneTime = time;
    }

    public final long getPruneTime() {
        return this.m_PruneTime;
    }

    public final void setPrepareTime(long time) {
        this.m_PrepTime = time;
    }

    public final long getPrepareTime() {
        return this.m_PrepTime;
    }

    public final void addToPredictionTime(long time, int nbExamples) {
        this.m_PredictionTime += time;
        this.m_PredictionTimeNbExamples += nbExamples;
    }

    public final long getPredictionTime() {
        return this.m_PredictionTime;
    }

    public final long getPredictionTimeNbExamples() {
        return this.m_PredictionTimeNbExamples;
    }

    public final long getPredictionTimeAverage() {
        if (this.m_PredictionTimeNbExamples == 0) {
            return 0L;
        }
        return this.m_PredictionTime / (long)this.m_PredictionTimeNbExamples;
    }
}

