/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.heuristic.rules;

import si.ijs.kt.clus.data.attweights.ClusAttributeWeights;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.heuristic.ClusHeuristic;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsTree;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.exception.ClusException;

public class ClusRuleHeuristicSSD
extends ClusHeuristic {
    protected RowData m_Data;
    protected String m_BasicDist;
    protected ClusStatistic m_NegStat;
    protected ClusStatManager m_StatManager;

    public ClusRuleHeuristicSSD(ClusStatManager statManager, String basicdist, ClusStatistic negstat, ClusAttributeWeights targetweights, Settings sett) {
        super(sett);
        this.m_StatManager = statManager;
        this.m_BasicDist = basicdist;
        this.m_NegStat = negstat;
        this.m_ClusteringWeights = targetweights;
    }

    @Override
    public void setData(RowData data) {
        this.m_Data = data;
    }

    @Override
    public double calcHeuristic(ClusStatistic tstat, ClusStatistic pstat, ClusStatistic missing) throws ClusException {
        double cov_par;
        double n_pos = pstat.getTotalWeight();
        if (n_pos < SettingsTree.MINIMAL_WEIGHT) {
            return Double.NEGATIVE_INFINITY;
        }
        double offset = this.m_StatManager.getSettings().getRules().getHeurDispOffset();
        double def_value = this.getTrainDataHeurValue();
        double value = pstat.getSVarS(this.m_ClusteringWeights, this.m_Data);
        double norm = this.m_StatManager.getSettings().getRules().getVarBasedDispNormWeight();
        value = 1.0 / (norm * norm) * (1.0 - value / def_value) + offset;
        double train_sum_w = this.m_StatManager.getTrainSetStat(ClusAttrType.AttributeUseType.Clustering).getTotalWeight();
        if ((value *= Math.pow(n_pos / train_sum_w, cov_par = this.m_StatManager.getSettings().getRules().getHeurCoveragePar())) < 1.0E-6) {
            return Double.NEGATIVE_INFINITY;
        }
        return value;
    }

    @Override
    public String getName() {
        return "SS Reduction for Rules (" + this.m_BasicDist + ", " + this.m_ClusteringWeights.getName() + ")";
    }
}

